/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DiskImageFileFilter
extends FileFilter {
    String root;

    public DiskImageFileFilter(File rootDirectory) {
        try {
            this.root = rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            this.root = rootDirectory.getAbsolutePath();
        }
    }

    @Override
    public boolean accept(File f) {
        String path;
        if (!f.canRead()) {
            return false;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        if (path.startsWith(this.root)) {
            if (f.isDirectory()) {
                return true;
            }
            if ((path = path.toLowerCase()).endsWith(".img")) {
                return true;
            }
            if (path.endsWith(".bkd")) {
                return true;
            }
            if (path.endsWith(".dsk")) {
                return true;
            }
            if (path.endsWith(".raw")) {
                return true;
            }
        }
        return f.isDirectory() && this.root.startsWith(path);
    }

    @Override
    public String getDescription() {
        return "BK2010 Disk Image File";
    }

    public static void main(String[] args) {
        File curdir = new File(".");
        JFileChooser jfc = new JFileChooser(curdir);
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.setFileFilter(new DiskImageFileFilter(curdir));
        if (jfc.showOpenDialog(null) == 0) {
            String sel = jfc.getSelectedFile().toString();
            System.out.println(sel);
        }
    }
}

