/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware;

import bk2010.hardware.BKMemorySelector;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusSlave;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.bus.registers.Keyboard;
import bk2010.hardware.bus.registers.SystemRegs;
import bk2010.io.Joystick;
import bk2010.preferences.PathStrings;
import bk2010.sound.SoundRenderer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BaseBK001x
extends QBusProxy
implements BKMemorySelector {
    protected static final int OF_RAMB10_120 = 16384;
    protected static final int OF_RAMB10_140 = 20480;
    protected static final int OF_ROMB10_100 = 65536;
    protected static final int OF_ROMBASIC10_120 = 69632;
    protected static final int OF_ROMBASIC10_140 = 73728;
    protected static final int OF_ROMBASIC10_160 = 77824;
    protected static final int OF_ROMB11M_140 = 81920;
    protected static final int OF_ROMB11M_120 = 86016;
    protected static final int OF_ROMBASIC11M_1_100 = 90112;
    protected static final int OF_ROMBASIC11M_0_100 = 94208;
    protected static final int OF_ROMFDD = 102400;
    protected static final int OF_MEMSIZE = 106496;
    protected static final int LEN_ROMBASIC10_160 = 8064;
    protected static final int LEN_ROMFDD_160 = 4096;
    protected short[] memory = new short[106496];
    protected final int MMAP_IOPAGE = 7;
    protected final int MMAP_PAGES = 8;
    protected int[] mmap = new int[8];
    protected boolean[] mmap_readable = new boolean[8];
    protected boolean[] mmap_writeable = new boolean[8];
    protected int rom160length = 8064;
    protected short iowritereg = 0;
    protected short ioreadreg = 0;
    protected short scrollReg = 0;
    protected short paletteReg = 0;
    protected static final int VM_1BIT = 0;
    protected static final int VM_GRAY = 1;
    protected static final int VM_RGB = 2;
    protected static final int VM_LAST = 2;
    protected int videoMode = 1;
    protected boolean is11M = false;
    protected List<QBusSlave> plugins = new ArrayList<QBusSlave>();
    public final Keyboard keyboard = new Keyboard();
    public final Joystick joystick = new Joystick();
    public final CPUTimer timer = new CPUTimer();
    public final SystemRegs sregs = new SystemRegs();
    private SoundRenderer srend = null;
    private static final byte BC_BLACK = 0;
    private static final byte BC_RED = 7;
    private static final byte BC_GREEN = 56;
    private static final byte BC_BLUE = -64;
    private static final byte BC_WHITE = -1;
    private static final byte BC_LGRAY = -92;
    private static final byte BC_DGRAY = 82;
    private static final byte BC_YELLOW = 63;
    private static final byte BC_CYAN = -8;
    private static final byte BC_DRED = 2;
    private static final byte BC_MRED = 4;
    private static final byte BC_VIOLET = -60;
    private static final byte BC_MAGENTA = -57;
    private static final byte BC_LGREEN = 28;
    private static final byte BC_LBLUE = -62;
    private static final byte[] monoColorMap;
    private static final byte[] fullColorMap;
    private static final int MPM_COUNT = 18;
    private static final int MPM_PPS = 8;
    private static final int MPM_PPS_BITS = 3;
    private static final int MPM_SIZE = 256;
    private static final byte[] modePaletteMaps;
    protected byte[] raster;
    protected static final int RS_WIDTH = 48;
    protected static final int RS_SIZE = 15000;
    protected static final int RS_TOPBLANK = 40;
    protected static final int RS_LEFTBLANK = 8;
    TimeSource ts;
    int cpw;
    int cpl;
    int cpf;
    long lastCycles;
    long lastFullFrame;
    int lastBeamPos;
    int lastSubPos;
    int scrollPos;

    static {
        byte[] byArray = new byte[4];
        byArray[1] = 82;
        byArray[2] = -92;
        byArray[3] = -1;
        monoColorMap = byArray;
        byte[] byArray2 = new byte[64];
        byArray2[1] = -64;
        byArray2[2] = 56;
        byArray2[3] = 7;
        byArray2[5] = 63;
        byArray2[6] = -57;
        byArray2[7] = 7;
        byArray2[9] = -8;
        byArray2[10] = -64;
        byArray2[11] = -57;
        byArray2[13] = 56;
        byArray2[14] = -8;
        byArray2[15] = 63;
        byArray2[17] = -57;
        byArray2[18] = -8;
        byArray2[19] = -1;
        byArray2[21] = -1;
        byArray2[22] = -1;
        byArray2[23] = -1;
        byArray2[25] = 2;
        byArray2[26] = 4;
        byArray2[27] = 7;
        byArray2[29] = 56;
        byArray2[30] = 28;
        byArray2[31] = 63;
        byArray2[33] = -60;
        byArray2[34] = -62;
        byArray2[35] = -57;
        byArray2[37] = 63;
        byArray2[38] = -62;
        byArray2[39] = -57;
        byArray2[41] = 63;
        byArray2[42] = -60;
        byArray2[43] = 7;
        byArray2[45] = -8;
        byArray2[46] = 63;
        byArray2[47] = 7;
        byArray2[49] = 7;
        byArray2[50] = 56;
        byArray2[51] = -8;
        byArray2[53] = -8;
        byArray2[54] = 63;
        byArray2[55] = -1;
        byArray2[57] = 63;
        byArray2[58] = 56;
        byArray2[59] = -1;
        byArray2[61] = -8;
        byArray2[62] = 56;
        byArray2[63] = -1;
        fullColorMap = byArray2;
        modePaletteMaps = new byte[36864];
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 8) {
                BaseBK001x.modePaletteMaps[(i << 3) + j] = (byte)((i >> j & 1) != 0 ? 255 : 0);
                ++j;
            }
            ++i;
        }
        BaseBK001x.fillMPMEntry(modePaletteMaps, 1, monoColorMap, 0);
        i = 0;
        while (i < 16) {
            BaseBK001x.fillMPMEntry(modePaletteMaps, 2 + i, fullColorMap, i * 4);
            ++i;
        }
    }

    public BaseBK001x() throws IOException {
        this.mmap_writeable[0] = true;
        this.mmap_writeable[1] = true;
        this.mmap_writeable[2] = true;
        this.mmap_writeable[3] = true;
        Arrays.fill(this.mmap_readable, true);
        this.mmap[0] = 0;
        this.mmap[1] = 4096;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 65536;
        this.mmap[5] = 69632;
        this.mmap[6] = 73728;
        this.mmap[7] = 77824;
        int i = 0;
        while (i < 16384) {
            this.memory[i] = (short)(((i >> 7 ^ i) & 1) == 1 ? -1 : 0);
            ++i;
        }
        FileInputStream ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "monit10.rom");
        int i2 = 0;
        while (i2 < 4096) {
            this.memory[65536 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "basic10.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.memory[69632 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4096) {
            this.memory[73728 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4032) {
            this.memory[77824 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "b11m_bos.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.memory[81920 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "b11m_ext.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.memory[86016 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "bas11m_1.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.memory[90112 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "bas11m_0.rom");
        i2 = 0;
        while (i2 < 8192) {
            this.memory[94208 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream(String.valueOf(PathStrings.romsPath) + "fdd.rom");
        i2 = 0;
        while (i2 < 2048) {
            this.memory[102400 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        this.plugins.add(this.keyboard);
        this.plugins.add(this.timer);
        this.plugins.add(this.sregs);
    }

    @Override
    public void setBase10Model() {
        this.is11M = false;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 65536;
        this.mmap_readable[4] = true;
        this.mmap_readable[5] = false;
        this.mmap_readable[6] = false;
        this.mmap_readable[7] = false;
        this.mmap_writeable[4] = false;
        this.mmap_writeable[5] = false;
        this.mmap_writeable[6] = false;
        this.mmap_writeable[7] = false;
    }

    @Override
    public void setFDD10Model() {
        this.is11M = false;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 65536;
        this.mmap[5] = 16384;
        this.mmap[6] = 20480;
        this.mmap[7] = 102400;
        this.mmap_readable[4] = true;
        this.mmap_readable[5] = true;
        this.mmap_readable[6] = true;
        this.mmap_readable[7] = true;
        this.mmap_writeable[4] = false;
        this.mmap_writeable[5] = true;
        this.mmap_writeable[6] = true;
        this.mmap_writeable[7] = false;
        this.rom160length = 4096;
    }

    @Override
    public void setBASIC10Model() {
        this.is11M = false;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 65536;
        this.mmap[5] = 69632;
        this.mmap[6] = 73728;
        this.mmap[7] = 77824;
        this.mmap_readable[4] = true;
        this.mmap_readable[5] = true;
        this.mmap_readable[6] = true;
        this.mmap_readable[7] = true;
        this.mmap_writeable[4] = false;
        this.mmap_writeable[5] = false;
        this.mmap_writeable[6] = false;
        this.mmap_writeable[7] = false;
        this.rom160length = 8064;
    }

    public void setFDD11MModel() {
        this.is11M = true;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 90112;
        this.mmap[5] = 86016;
        this.mmap[6] = 81920;
        this.mmap[7] = 102400;
        this.rom160length = 4096;
        this.mmap_readable[4] = true;
        this.mmap_readable[5] = true;
        this.mmap_readable[6] = true;
        this.mmap_readable[7] = true;
        this.mmap_writeable[4] = false;
        this.mmap_writeable[5] = false;
        this.mmap_writeable[6] = false;
        this.mmap_writeable[7] = false;
    }

    public void attach(QBusSlave plugin) {
        this.plugins.add(plugin);
    }

    @Override
    public short readWord(short addr) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_readable[page]) {
                return this.memory[mapped];
            }
            return super.readWord(addr);
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            return plugin.readWord(addr);
        }
        if (this.mmap_readable[7] && ia < 57344 + this.rom160length) {
            return this.memory[mapped];
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            return (short)(this.ioreadreg | this.joystick.getIO());
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            return (short)((this.keyboard.getKeyDown() ? 0 : 64) | (this.is11M ? 49280 : 32912));
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return this.scrollReg;
        }
        return super.readWord(addr);
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_writeable[page]) {
                this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
                return;
            }
            super.writeWord(addr, data);
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeByteAsWord(addr, data);
            return;
        }
        if (this.mmap_writeable[7] && ia < 57344 + this.rom160length) {
            this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = (ia & 1) == 0 ? (short)(this.iowritereg & 0xFF00 | data & 0xFF) : (short)(this.iowritereg & 0xFF | data & 0xFF00);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return;
        }
        super.writeByteAsWord(addr, data);
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_writeable[page]) {
                this.memory[mapped] = data;
                return;
            }
            super.writeWord(addr, data);
            return;
        }
        if (this.is11M && (ia & 0xFFFFFFFE) == 65458) {
            this.paletteReg = data;
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeWord(addr, data);
            return;
        }
        if (this.mmap_writeable[7] && ia < 57344 + this.rom160length) {
            this.memory[mapped] = data;
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = data;
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.is11M && (data & 0x800) != 0) {
                int sel = data & 0x1B;
                if (sel != 0) {
                    this.mmap_writeable[4] = false;
                    this.mmap_writeable[5] = false;
                    if ((sel & 1) != 0) {
                        this.mmap_readable[4] = true;
                        this.mmap_readable[5] = true;
                        this.mmap[4] = 94208;
                        this.mmap[5] = 98304;
                    } else if ((sel & 2) != 0) {
                        this.mmap_readable[4] = true;
                        this.mmap_readable[5] = true;
                        this.mmap[4] = 90112;
                        this.mmap[5] = 86016;
                    } else {
                        this.mmap_readable[4] = false;
                        this.mmap_readable[5] = false;
                    }
                } else {
                    this.mmap_writeable[4] = true;
                    this.mmap_writeable[5] = true;
                    this.mmap_readable[4] = true;
                    this.mmap_readable[5] = true;
                    sel = data >> 8 & 7;
                    this.mmap[4] = sel = (sel ^ 6) << 13;
                    this.mmap[5] = sel + 4096;
                }
                sel = data >> 12 & 7;
                this.mmap[2] = sel = (sel ^ 6) << 13;
                this.mmap[3] = sel + 4096;
            } else if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            this.scrollReg = (short)(data & 0x2FF);
            return;
        }
        super.writeWord(addr, data);
    }

    @Override
    public short getBaseAddress() {
        return 0;
    }

    @Override
    public int getNumWords() {
        return 0;
    }

    @Override
    public boolean gotInterrupt() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte interruptVector() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return plugin.interruptVector();
        }
        return -1;
    }

    @Override
    public void reset() {
        for (QBusSlave plugin : this.plugins) {
            plugin.reset();
        }
    }

    public boolean timerEnabled() {
        return (this.paletteReg & 0x4000) == 0;
    }

    public void setSoundRenderer(SoundRenderer sr) {
        this.srend = sr;
    }

    public void cycleVideomodes() {
        this.videoMode = this.is11M ? (this.videoMode == 0 ? 2 : 0) : (this.videoMode >= 2 ? 0 : this.videoMode + 1);
    }

    public void copyFramebuffer(byte[] buf) {
        int base = this.is11M && (this.paletteReg & 0x8000) == 0 ? 57344 : 8192;
        int src = this.scrollPos;
        int dst = 0;
        int limit = (this.scrollReg & 0x200) == 0 ? 64 : 256;
        int y = 0;
        while (y < 256) {
            int x;
            if (y < limit) {
                x = 0;
                while (x < 32) {
                    short s = this.memory[base + src++];
                    switch (this.videoMode) {
                        case 0: {
                            int bit = 0;
                            while (bit < 16) {
                                buf[dst++] = (byte)(s << 31 - bit >> 31);
                                ++bit;
                            }
                            break;
                        }
                        case 1: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = monoColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                        case 2: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = fullColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                    }
                    ++x;
                }
                src &= 0x1FFF;
            } else {
                x = 0;
                while (x < 512) {
                    buf[dst++] = 0;
                    ++x;
                }
            }
            ++y;
        }
        this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
    }

    public void copyFramebufferFast(byte[] buf) {
        int limit;
        int base = this.is11M && (this.paletteReg & 0x8000) == 0 ? 57344 : 8192;
        int src = this.scrollPos;
        int dst = 0;
        int n = limit = (this.scrollReg & 0x200) == 0 ? 64 : 256;
        int cmap = !this.is11M ? this.videoMode * 256 << 3 : (this.videoMode == 0 ? 0 : (2 + (this.paletteReg >> 8 & 0xF)) * 256 << 3);
        limit *= 32;
        while (limit-- > 0) {
            int s = this.memory[base + src++] & 0xFFFF;
            System.arraycopy(modePaletteMaps, cmap + ((s & 0xFF) << 3), buf, dst, 8);
            System.arraycopy(modePaletteMaps, cmap + (s >> 8 << 3), buf, dst += 8, 8);
            dst += 8;
            src &= 0x1FFF;
        }
        if (dst < 131072) {
            Arrays.fill(buf, dst, 131072, (byte)0);
        }
        this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
    }

    public void setRaster(byte[] aRaster) {
        this.raster = aRaster;
    }

    public void setTimeSource(TimeSource ts, int freq) {
        this.ts = ts;
        this.cpw = freq / 750000;
        this.cpl = this.cpw * 48;
        this.cpf = this.cpw * 15000;
        this.lastCycles = this.lastFullFrame = ts.getCycles();
        this.lastBeamPos = 0;
        this.lastSubPos = 0;
        this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
    }

    public boolean updateRaster() {
        long cycles = this.ts.getCycles();
        long step = cycles - this.lastCycles + (long)this.lastSubPos;
        if (step < (long)this.cpw) {
            return false;
        }
        if (step > (long)this.cpf) {
            step %= (long)this.cpf;
            this.lastBeamPos = 0;
            this.scrollPos = (this.scrollReg + 40 & 0xFF) * 32;
        }
        return false;
    }

    private static void fillMPMEntry(byte[] arr, int ofs, byte[] cmap, int mapofs) {
        ofs = ofs * 256 << 3;
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 8) {
                byte col = cmap[(i >> j & 3) + mapofs];
                BaseBK001x.modePaletteMaps[ofs++] = col;
                BaseBK001x.modePaletteMaps[ofs++] = col;
                j += 2;
            }
            ++i;
        }
    }
}

