/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.QBusSlave;

public final class FocalIRPS
implements QBusSlave {
    private static final short IRPSBase = -144;
    private static final short IRPSRxStatus = -144;
    private static final short IRPSRxData = -142;
    private static final short IRPSTxStatus = -140;
    private static final short IRPSTxData = -138;
    private static final short IRPSvector = 48;
    protected short txStatus = (short)128;
    protected short txData = 0;
    protected short rxStatus = 0;
    protected short rxData = 0;

    @Override
    public short getBaseAddress() {
        return -144;
    }

    @Override
    public int getNumWords() {
        return 4;
    }

    @Override
    public boolean gotInterrupt() {
        return (this.txStatus & 0xC0) == 192 || (this.rxStatus & 0xC0) == 192;
    }

    @Override
    public byte interruptVector() {
        return (byte)((this.rxStatus & 0x80) != 0 ? 48 : 52);
    }

    @Override
    public boolean readWord(short addr, QBusReadDTO result) {
        switch (addr & 0xFFFFFFFE) {
            case -138: {
                result.value = (short)48;
                return true;
            }
            case -140: {
                result.value = this.txStatus;
                return true;
            }
            case -142: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFF37);
                result.value = this.rxData;
                return true;
            }
            case -144: {
                result.value = this.rxStatus;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeByteAsWord(short addr, short data) {
        if ((addr & 1) != 0) {
            return true;
        }
        switch (addr & 0xFFFFFFFE) {
            case -138: {
                this.txData = (short)(data & 0xFF);
                this.txStatus = (short)(this.txStatus & 0xFFFFFF37);
                return true;
            }
            case -140: {
                this.txStatus = (short)(this.txStatus & 0xFFFFFFBF | data & 0x40);
                return true;
            }
            case -142: {
                return true;
            }
            case -144: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFFBF | data & 0x40);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeWord(short addr, short data) {
        return this.writeByteAsWord(addr, data);
    }

    @Override
    public void reset() {
        this.txStatus = (short)128;
        this.txData = 0;
        this.rxStatus = 0;
        this.rxData = 0;
    }

    public int pollTx() {
        if ((this.txStatus & 0x80) != 0) {
            return -1;
        }
        this.txStatus = (short)(this.txStatus | 0x80);
        return this.txData & 0xFF;
    }
}

