
/*------------------------------------------------------------------------*/
#define SCT	6
#define HEAD	3
#define CYL	1
#define SERIAL	10
#define MODEL	27
#define FIRMWARE 23
#define BUFSIZ	21
#define MAXPART	(8*3)
/*------------------------------------------------------------------------*/
#include <stdio.h>
extern long freesize();
extern unsigned int getuns();
/*------------------------------------------------------------------------*/
int $$narg=1;
char slot[2];
unsigned int  curslot;
unsigned int twait = 300, hide = 1000;
unsigned int sct, head, cyl;
unsigned int sctD, headD, cylD;
unsigned int curpart,parts,minparts;
unsigned int *partprop;
unsigned int *partsize;
unsigned int *buf;
long disksize;
long propsize;
/*------------------------------------------------------------------------*/
main()
{
 register int i;

 printf("WDX V01.00 by Oleg H.\n");
 printf("Program for manipulate partitons on the HDD/IDE device\n\n");

 buf      = malloc(0400    * sizeof(unsigned int));
 partprop = malloc(MAXPART * sizeof(unsigned int));
 partsize = malloc(MAXPART * sizeof(unsigned int));
 
 if(buf == NULL || partprop == NULL || partsize == NULL)
  {  printf("No memory\n"); exit();  }

 parts = 0;
 for(i = 0; i < MAXPART; i++)
   partsize[i] = partprop[i] = 0;

 slot[0] = castst(0) == 0;
 slot[1] = castst(1) == 0;
 
 if(slot[0] && slot[1])
   curslot = getuns("Which slot we are will use: 0 or 1 [%d] ? ", 1);

 else
  {
   if(slot[0]) curslot = 0;
   else
   if(slot[1]) curslot = 1;
   else
    {
     printf("HDD controller not found\n");
     exit();
    }
  }
 
 printf("\nUse controller in the slot: %d\n\n", curslot);

 if(sb$r(buf, curslot))
   if(!question("\nMaster block input error.\nContinue"))
     exit(1);

 if(!sb_tst(buf))
  {
   if(!question(
 "\nMaster block containts valid information, which will be lost!\nContinue"))
     exit(1);

   for(i = 0; i < MAXPART; i++)
     if((partprop[i] = buf[i + 1]) == 0) 
       break;
   parts = i;
   
   twait  = buf[0122 / 2];
   hide   = buf[0124 / 2];
   
   sctD    = ((char*)buf)[0];
   headD   = ((char*)buf)[1];
   
   for(i = 1, disksize = 0L; buf[i] != 0 && i <= MAXPART; i++)
     disksize += buf[i];
   cylD   = (disksize + (long)(sctD * headD) - 1L) / (sctD * headD);
   sct    = sctD;
   head   = headD;
   cyl    = cylD;
  }

 if(question("Execute autodetect"))
 {
  if(sb$A(buf, curslot))
    printf("Autodetect error\n");
  else
   {
    sct      = swab(buf[SCT]);
    head     = swab(buf[HEAD]);
    cyl      = swab(buf[CYL]);
  
    printf("Current disk autodetect:\n\n");
    shortpri("Model  No : %s\n", (char*)(buf + MODEL), 40);
    shortpri("Firmware  : %s\n", (char*)(buf + FIRMWARE), 8);
    shortpri("Serial No : %s\n", (char*)(buf + SERIAL), 20);
      printf("Bufer size: %d blocks\n", swab(buf[BUFSIZ]));
   }
 }  
 pripd:
 
 disksize = (long)cyl * (long)head * (long)sct;

 printf("\nCylinders : %d\n", cyl);
 printf("Heads     : %d\n", head);
 printf("Sectors   : %d\n", sct);
 printf("DiskSize  : %ld blocks (%ld K)\n", disksize, disksize >> 1);

 if(!question("\nDisk parameters correct"))
  {
   cyl  = getuns("Cylinders [%4d]? ", cylD ? cylD  : cyl);
   head = getuns("Heads     [%4d]? ", headD? headD : headD);
   sct  = getuns("Sectors   [%4d]? ", sctD ? sctD  : sctD);
   goto pripd;
  }

 disksize--;
 minparts = ((disksize + 0177777L - 1L) / (unsigned)0177777);

 do
  { 
   printf("\nYou will might used [%d-%d] partitions\n", minparts, MAXPART);
   parts = getuns("Enter parts number [%u] > ", parts? parts : minparts);
  }
 while(parts > MAXPART);
 
 putchar('\n');
 
 for(curpart = 0; curpart  < parts; curpart++)
 {
  printf("\nYou have %d partitions with summary size %ld blocks.\n", 
          parts - curpart, freesize());

  propsize = freesize() / (parts - curpart);
  
  if(propsize > 0177777L) 
     propsize = 0177777L;
 
  printf("Middle size of partition[%d] = %ld blocks.\n", 
          curpart, propsize);
          
  partsize[curpart] = getuns("Enter size of partition [%u] > ",
                      partprop[curpart]? partprop[curpart] 
                            : (unsigned) propsize);
 }
 
 if(freesize() > 0L)
  printf("WARNING: %ld blocks won't used\n\n", freesize());


 for(i = 0; i < 0400; i++)
   buf[i] = 0;

 ((char*)buf)[0] = sct;
 ((char*)buf)[1] = head;

 putchar('\n');

 for(i = 0; i < parts; i++)
  {
   if((buf[i + 1] = partsize[i]) == 0) break;
   printf("Made partition W%c%d: [%u]\n", 
           'D' + (i >> 3), i & 7, buf[i + 1]);
  }

 buf[0122 / 2] = getuns("\nEnter Wait-time in ticks [%d] > ", twait);
 buf[0124 / 2] = getuns("Enter number of hidden partition [%d] > ", hide);

 if(question("Rewrite master-block on the disk"))
 {
  sb_clc(buf); 
  if(sb$w(buf, curslot))
   printf("Can't wrote master block!");
 }

}
/*------------------------------------------------------------------------*/
long freesize()
{
 register int i;
 register long ret = 0L;
 
 for(i = 0; i < MAXPART; i++)
   ret += (long)partsize[i];

 return disksize - ret;
}
/*------------------------------------------------------------------------*/
question(str)
char *str;
{
 char tmpbuf[80];

 printf("%s. You agree [Y,N] ? ", str);
 
 while(1)
  {
   gets(tmpbuf);
   switch(*tmpbuf & ~040)
    {
     case 'Y' : return 1;
     case 'N' : return 0;
     default  : printf("Please, enter Y or N > ");
               break;
    }
  }
  
}
/*------------------------------------------------------------------------*/
shortpri(format, str, size)
char *format, *str;
int size;
{
 char tmp[80];
 register char *p = tmp, *s = str;
 
 while (--size >= 0) 
   if((*p++ = *s++) == 0) 
     break;
 *p = 0;
 
 printf(format, (*str == 0)? "<Not present>": tmp);
}
/*------------------------------------------------------------------------*/
unsigned int getuns(format, defval)
char *format;
unsigned int defval;
{
 char tmpbuf[80];
 register char *p = tmpbuf;
 
 unsigned int rc = 0, convflag = 0;
 
 printf(format, defval);

 gets(tmpbuf);
 
 while(*p == ' ' || *p == '\t') p++;
 
 while(*p >= '0' && *p <= '9')
  {
   convflag = 1;
   rc = rc * 10 + *p++ - '0';
  }

 return convflag? rc : defval;
}
/*------------------------------------------------------------------------*/

