/******************************************************************************/
/*                              CLA.H                                         */
/*                                                                            */
/*  CLAGLUE.H defines types and macros, and declares functions that are       */
/*  generally useful for writing modules to glue third-party code into        */
/*  Clarion applications.                                                     */
/*                                                                            */
/*  COPYRIGHT (C) 1989..1992 Clarion Software Corporation.                    */
/*  All Rights Reserved                                                       */
/*                                                                            */
/******************************************************************************/

#ifndef CLA_H
#define CLA_H

#pragma project("#set tscla='on'")

/*** The following macro defines the Clarion calling & naming conventions.  ***/
/*** This macro should be used when declaring C functions to interface with ***/
/*** Clarion in order to ensure future compatibility.                       ***/

#define CLA_CONV        name(prefix=>"", upper_case=>on)

/*** NOTE: C++ compiled functions which may be called from Clarion 3.0 must ***/
/*** be declared within a 'extern "Pascal" {...};' modifier.  The CLA_CONV  ***/
/*** pragma will not affect the name mangling employed by the C++ compiler. ***/

/*** Type equivalences.  The CLA prefix is used to avoid name clashes with  ***/
/*** third party libraries.                                                 ***/

typedef unsigned char   CLABYTE;
typedef short           CLASHORT;
typedef unsigned short  CLAUSHORT;
typedef long            CLALONG;
typedef unsigned long   CLAULONG;
typedef float           CLASREAL;
typedef double          CLAREAL;

/*** Clarion STRINGS are passed as two parameters, first an unsigned short  ***/
/*** is passed which contains the length of the data buffer, second the     ***/
/*** address of the data buffer.  If the RAW attribute is used in the       ***/
/*** Clarion procedure prototype then only the address of the data buffer   ***/
/*** is passed.  The CLASTRING structure is illustrative and cannot be used ***/
/*** to accept parameters from Clarion.                                     ***/

/*** typedef struct {CLAUSHORT ucLen; CLABYTE *pucString;} CLASTRING;       ***/

/*** Clarion PSTRINGS are passed as two parameters, first a CLABYTE is      ***/
/*** passed which contains the length of the string in the data buffer,     ***/
/*** second the address of the data buffer.  If the RAW attribute is used   ***/
/*** in the Clarion procedure prototype then only the address of the data   ***/
/*** buffer is passed.  The CLAPSTRING structure is illustrative and cannot ***/
/*** be used to accept parameters from Clarion.                             ***/

/*** typedef struct {CLABYTE ucLen; CLABYTE ucString[255];} CLAPSTRING;     ***/

/*** Clarion CSTRINGS are passed as two parameters, first a CLAUSHORT is    ***/
/*** passed which contains the length of the string in the data buffer,     ***/
/*** second the address of the data buffer.  If the RAW attribute is used   ***/
/*** in the Clarion procedure prototype then only the address of the data   ***/
/*** buffer is passed.  The CLACSTRING structure is illustrative and cannot ***/
/*** be used to accept parameters from Clarion.                             ***/

/*** typedef struct {CLAUSHORT ucLen; CLABYTE *pucString;} CLACSTRING;      ***/


/*** Clarion DATEs are passed as a CLALONG, the CLADATE union can be used   ***/
/*** to resolve the elements of the date from the CLALONG value.            ***/

typedef union {
    CLALONG         l;
    struct {
        CLABYTE     ucDay;
        CLABYTE     ucMonth;
        CLAUSHORT   usYear;
    }               s;
}   CLADATE;

/*** Clarion TIMEs are passed as a CLALONG, the CLADATE union can be used   ***/
/*** to resolve the elements of the time from the CLALONG value.            ***/

typedef union {
    CLALONG         l;
    struct {
        CLABYTE     ucHund;
        CLABYTE     ucSecond;
        CLABYTE     ucMinute;
        CLABYTE     ucHour;
    }               s;
}   CLATIME;


#define CLATRUE     1
#define CLAFALSE    0

/*** Various data types for calling functions in the core Clarion library   ***/

struct ffblk {
    char ff_reserved[21];
    char ff_attrib;
    int  ff_ftime;
    int  ff_fdate;
    long ff_fsize;
    char ff_name[13];
};

struct SSSTRK {
  unsigned      lin;
  unsigned      col;
  unsigned      noc;
  unsigned      nol;
  /* Graphics ONLY */
  char        * piece[40];
  unsigned char piece_count;
  unsigned      lsize;
  unsigned      rsize;
  unsigned      rlines;
  char        * text;
  char          cursor[4];
};

/*** Functions in the core Clarion library that could be useful to          ***/
/*** programmers could find useful                                          ***/
#pragma save, name(prefix=>"")

unsigned      Cla$validpathname(const char *path);
unsigned      Cla$pack(const char *src, char *dst, unsigned len);
unsigned      Cla$unpack(const char *src, char *dst);
unsigned      Cla$crc16(unsigned crc, unsigned len, const void *buffer);
unsigned long Cla$crc32(const char *buf, unsigned len, unsigned long crc);
int           Cla$fullpath(const char *fname, char fullpath[64]);
void          Cla$findclose(struct ffblk *buffer);
char         *Cla$nextwordtok(const char *loc, char *word, const char *toks);
void          Cla$seterror(int err);
void          Cla$clearerror(void);
int           Cla$matchspec(const char *spec, const char *name);

/*** Functions in the core Clarion screen library that could be useful to   ***/
/*** programmers could find useful                                          ***/

void          Cla$reposition_screen(unsigned char row, unsigned char col,
                                    unsigned char ylen, unsigned char xlen);
void          Cla$disable_scroll(void);
void          Cla$enable_scroll(void);
void          Cla$SETLIST(unsigned fldno, unsigned bar, unsigned elem);
void          Cla$GETLIST(unsigned fldno, unsigned *bar, unsigned *elem);
void          Cla$dim_radio(unsigned fldnum, unsigned radionum);
void          Cla$undim_radio(unsigned fldnum, unsigned radionum);
void          Hlp$check_file_dates(const char *filename);
unsigned      Cla$clarionkey(unsigned keycode);
void          Cla$de_alert(unsigned klow, unsigned khigh);
void          Cla$smooth_mouse_off(void);
void          Cla$smooth_mouse_on(void);
void          Cla$wait_pos(void);
void          Cla$SAVE_PALLETTE(void);
void          Cla$RESTORE_PALLETTE(void);
void          Cla$showpage(int attr);
int           Cla$onscreen(unsigned char y, unsigned char x);
void          Cla$pan_left(int num);
void          Cla$pan_right(int num);
void          Cla$pan_up(int num);
void          Cla$pan_down(int num);
void          Cla$savescreen(unsigned lin, unsigned col, unsigned nol,
                             unsigned noc, struct SSSTRK *buff,
                             unsigned char ctl);
void          Cla$rstscreen(struct SSSTRK *buff,unsigned char ctl);
void          Cla$UNLOADSYMBOLS(void);
void          Cla$map_character(const unsigned char *newmap, unsigned char c,
                                char map);
void          Cla$qshow(void *daddr, unsigned line, unsigned col,
                        unsigned len, unsigned char attr, unsigned style);
void          Cla$vidouta(unsigned line, unsigned col, unsigned len,
                          char *ptr);
void          Cla$getcurs(unsigned char *row, unsigned char *col);

extern unsigned char Cla$UserBreak;
extern unsigned      Alerts[500];
extern unsigned      Alertcount;
extern unsigned char CLACOLORS[256];
extern int           REAL_Y_MAX;
extern unsigned char LASTVIDEOROW;
extern unsigned char LASTVIDEOCOL;
extern unsigned char LASTVIDEOLEN;
extern char          FIRSTWIN;
extern char          VIRTUAL_SCREEN;
extern unsigned char ALT_TRACK[9];
extern char          DisableWindowMove;
extern char          CUA;
extern int           MSGROW;
extern int           MSGCOL;
extern int           MSGLEN;
extern int           CLICK_DELAY;
extern char          HELPWINDOW[64];
extern char          SMOOTH_MOUSE;
extern char          SCROLL_TYPE;
extern unsigned char roff1[16];
extern unsigned char roff2[16];
extern unsigned char ron1[16];
extern unsigned char ron2[16];
extern unsigned char checkoff1[16];
extern unsigned char checkoff2[16];
extern unsigned char checkon1[16];
extern unsigned char checkon2[16];
extern unsigned      Cla$_HouseMax;
extern unsigned long Cla$_LotSize;
extern unsigned      Cla$_LotCount;
extern unsigned      Cla$_Swapflag;
#pragma restore
extern char         *SMEM;
extern int           XOFFSET;
extern int           YOFFSET;
extern int           SPEED_INDEX;
extern char          CHAR_LINES;
extern char         *VRAM;
extern char         *c_table;

#endif /* CLAGLUE_H */
