/******************************************************************************/
/*                                  SLIST.HPP                                 */
/*                                                                            */
/*  The SList module defines the members for the singly linked list classes.  */
/*  Note that these classes are the minimum necessary for the example code    */
/*  and would need expansion before any serious use.                          */
/*                                                                            */
/*  Sean Wilson, 1/Feb/1993                                                   */
/******************************************************************************/
#ifndef SLIST_HPP
#define SLIST_HPP

/******************************************************************************/
/* The Link class defines the basic element of a singly-linked List, it is    */
/* intended to provide the base class for an application specific link type.  */
/******************************************************************************/

class Link {
    friend class List;                  // Allow List access to my members

protected:
    Link   *next;                       // Points to the next Link

public:
    Link();

    virtual int operator<(const void *tryLink);
};

/******************************************************************************/
/* The List class provides a base class for an application specific singly-   */
/* linked list.                                                               */
/******************************************************************************/

class List {
protected:
    Link   *head;                           // Head of list
    Link   *curr;                           // Current element of list

public:
    List();
   ~List();

    void operator+=(Link *link);            // Adds a Link to a List
    Link *operator++(int i);                // Returns the next Link in the List
    Link *operator--(int i);                // Returns the first Link, removing it
    void restart();                         // Resets the list to start
};

#endif /* SLIST_HPP */
