	.LALL
	PAGE	60,120
;-----------------------------------------------------------------------;
;	Written by Clarion Software Corp.				;
;	For Clarion Professional Developer Version 2.0			;
;									;
;	Copyright 1988 Clarion Software Corp.				;
;									;
;	Module: DOSLEM.ASM						;
;									;
;		DOS Language Extension Module				;
;		Miscellaneous DOS Procedures:				;
;									;
;		SPOOL ( FILE NAME )					;
;			Queue a file to be printed			;
;									;
;		SETDIR ( PATTERN , GROUP LABEL )			;
;			Set sequential processing of a directory	;
;									;
;		NEXTDIR ( GROUP LABEL )					;
;			Process the next directory entry		;
;									;
;		REMOVEDIR ( DIRECTORY NAME )				;
;			Remove an empty directory			;
;									;
;		MAKEDIR ( DIRECTORY NAME )				;
;			Make a new directory				;
;									;
;		GODOS ( RUNCODE VALUE )					;
;			Go to DOS					;
;									;
;		BOOT							;
;			Reboot your computer				;
;									;
;		COMMAND_LINE()						;
;			Return program command line			;
;									;
;		ENVIRONMENT( ENVIRONMENT VARIABLE )			;
;			Return value of an environment variable		;
;									;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
; L.E.M.  equates							;
;-----------------------------------------------------------------------;
TSTRING EQU	0			;String
TSHORT	EQU	1			;Signed word (16 bits)
TLONG	EQU	2			;Signed double word (32 bits)
TREAL	EQU	4			;Double precision float (8087)

PROCEDURE	EQU	0		;L.E.M. procedure
FUNCTION	EQU	1		;L.E.M. function

NAMELTH = 0				;Define NAMELTH for macro

;-----------------------------------------------------------------------;
; L.E.M.  macro								;
;	ROUTINE 'ROUTINE NAME', ROUTINE_PROC_LABEL, ROUTINE_TYPE,	;
;			NUMBER_OF_PARAMETERS				;
;-----------------------------------------------------------------------;
ROUTINE MACRO	RNAME, RPROC, RTYPE, RPARMS
	LOCAL	LBLSTRT
LBLSTRT DB	&RNAME
NAMELTH =	$-LBLSTRT		;;Padd name with nulls to 13 bytes
	IF NAMELTH GT 12
	  .ERR
	  %OUT routine name too long
	ELSE
	  DB	13-NAMELTH DUP (0)	;;Rest of name area
	  DW	&RPROC			;;Offset within binary module
	  DB	&RTYPE			;;Routine type = PROCEDURE or FUNCTION
	  DB	&RPARMS			;;Number of parameters
	ENDIF
	ENDM				;;End of macro

;-----------------------------------------------------------------------;
; L.E.M.  macro								;
;	PARAMETER LABEL_OF_PARAMETER, TYPE_OF_PARAMETER
;-----------------------------------------------------------------------;
PARAMETER	MACRO	PLBL, PTYPE
	DB	&PTYPE			;;Type = STRING, SHORT, LONG, or REAL
&PLBL	DD	0			;;Address of PARAMETER data
&PLBL&L DW	0			;;Length of PARAMETER data
	ENDM

;-----------------------------------------------------------------------;
; Start of CODE segment							;
;-----------------------------------------------------------------------;
CODE	SEGMENT BYTE PUBLIC 'CODE'	;Will be loaded on a paragraph boundary
	ASSUME	CS:CODE,DS:CODE

;-----------------------------------------------------------------------;
; Binary module header							;
;-----------------------------------------------------------------------;
	DB	'BIO'			;L.E.M Signature - Version 2.0
LIBVEC	DD	0			;Reserved for Runtime Library Vector!
	DW	BINEND			;Length of binary module
	DB	9			;Nine routines in this L.E.M.

;-----------------------------------------------------------------------;
; SPOOL definition							;
;									;
;		SPOOL ( SPOOLFILE )					;
;			Queue a file to be printed			;
;-----------------------------------------------------------------------;
	ROUTINE		'SPOOL', SPOOL_PROC, PROCEDURE, 1
	PARAMETER	SPOOLFILE, TSTRING

;-----------------------------------------------------------------------;
; SETDIR definition							;
;									;
;		SETDIR ( SETPATTERN , SETGROUP )			;
;			Set sequential processing of a directory	;
;									;
;     SETGROUP	GROUP							;
;		  BYTE,DIM(21)	!USED FOR NEXTDIR ENTRY MATCH		;
;	ATTRIB	  BYTE		!ATTRIBUTE BYTE OF FILE			;
;	TIME	  SHORT		!LAST FILE ACCESS TIME (DOS FORMAT)	;
;	DATE	  SHORT		!LAST FILE ACCESS DATE (DOS FORMAT)	;
;	SIZE	  LONG		!SIZE OF FILE				;
;	NAME	  STRING(13)	!FILE NAME (NULL TERMINATED)		;
;		.							;
;-----------------------------------------------------------------------;
	ROUTINE		'SETDIR', SETDIR_PROC, PROCEDURE, 2
	PARAMETER	SETPATTERN, TSTRING
	PARAMETER	SETGROUP, TSTRING

;-----------------------------------------------------------------------;
; NEXTDIR definition							;
;									;
;		NEXTDIR ( NEXTGROUP )					;
;			Process the next directory entry		;
;									;
;     NEXTGROUP GROUP							;
;		  BYTE,DIM(21)	!USED FOR NEXTDIR ENTRY MATCH		;
;	ATTRIB	  BYTE		!ATTRIBUTE BYTE OF FILE			;
;	TIME	  SHORT		!LAST FILE ACCESS TIME (DOS FORMAT)	;
;	DATE	  SHORT		!LAST FILE ACCESS DATE (DOS FORMAT)	;
;	SIZE	  LONG		!SIZE OF FILE				;
;	NAME	  STRING(13)	!FILE NAME (NULL TERMINATED)		;
;		.							;
;-----------------------------------------------------------------------;
	ROUTINE		'NEXTDIR', NEXTDIR_PROC, PROCEDURE, 1
	PARAMETER	NEXTGROUP, TSTRING

;-----------------------------------------------------------------------;
; REMOVEDIR definition							;
;									;
;		REMOVEDIR ( RDNAME )					;
;			Remove an empty directory			;
;-----------------------------------------------------------------------;
	ROUTINE		'REMOVEDIR', REMOVEDIR_PROC, PROCEDURE, 1
	PARAMETER	RDNAME, TSTRING

;-----------------------------------------------------------------------;
; MAKEDIR definition							;
;									;
;		MAKEDIR ( MDNAME )					;
;			Make a new directory				;
;-----------------------------------------------------------------------;
	ROUTINE		'MAKEDIR', MAKEDIR_PROC, PROCEDURE, 1
	PARAMETER	MDNAME, TSTRING

;-----------------------------------------------------------------------;
; GODOS definition							;
;									;
;		GODOS ( RUNCODE )					;
;			Go to DOS and return a runcode			;
;-----------------------------------------------------------------------;
	ROUTINE		'GODOS', GODOS_PROC, PROCEDURE, 1
	PARAMETER	RUNCODE, TSHORT

;-----------------------------------------------------------------------;
; BOOT definition							;
;									;
;		BOOT							;
;			Reboot your computer				;
;-----------------------------------------------------------------------;
	ROUTINE		'BOOT', BOOT_PROC, PROCEDURE, 0

;-----------------------------------------------------------------------;
; COMMAND_LINE() definition						;
;									;
;		COMMAND_LINE()						;
;			Return program command line			;
;									;
;-----------------------------------------------------------------------;
	ROUTINE		'COMMAND_LINE', COMMAND_LINE_PROC, FUNCTION, 0

;-----------------------------------------------------------------------;
; ENVIRONMENT() definition						;
;									;
;		ENVIRONMENT ( ENVVAR )					;
;			Return value of an environment variable		;
;									;
;-----------------------------------------------------------------------;
	ROUTINE		'ENVIRONMENT', ENVIRONMENT_PROC, FUNCTION, 1
	PARAMETER	ENVVAR, TSTRING

;-----------------------------------------------------------------------;
; Miscellaneous data area						;
;									;
; Common variables and constants for all routines			;
;-----------------------------------------------------------------------;
PACKET	DB	0			;Level for submit packet
FNPTR	DD	0			;Pointer to ASCIIZ filename string

BEGOFF	DW	0			;Beginning offset of contents
ENVLTH	DW	0			;Length of contents found
SET1ST	DB	0			;Flag for "Just did a SET"
SETERR	DW	0			;Non-zero means SETDIR had error

ASCIIZ	DB	129 DUP(0)		;Copy name to here (up to 128)
BUFFER	DB	256 DUP(0)		;Working storage (up to 255)

BOOTVEC DD	0F000E05Bh		;Address in BIOS to BOOT

;-----------------------------------------------------------------------;
; SPOOL procedure							;
;-----------------------------------------------------------------------;
	PUBLIC	SPOOL_PROC
SPOOL_PROC	PROC	FAR

	SUB	AX,AX			;Clear the global error
	CALL	SETGLOBERR

	MOV	AH,30h
	INT	21h			;Get DOS version number

	CMP	AL,3			;Must be 3.00 or greater for PRINT
	JB	ACCESS_DENIED
	MOV	AX,0100h		;Check installed state
	INT	2Fh
	JC	ACCESS_DENIED		;Is PRINT installed?
	CMP	AL,0FFh
	JNE	ACCESS_DENIED
	MOV	CX,SPOOLFILEL		;Get length of filename
	LES	SI,SPOOLFILE		;Get the filename
	MOV	BP,ES			;BP:SI is filename
	CALL	COPYNAME		;Copy DS:SI to ASCIIZ
	JC	NAME_TOO_LONG		;Error from COPYNAME
	MOV	AX,DS			;Get segment of ASCIIZ
	MOV	WORD PTR FNPTR+2,AX	;Store segment of ASCIIZ
	LEA	AX,ASCIIZ		;Get offset of ASCIIZ
	MOV	WORD PTR FNPTR,AX	;FNPTR has address of ASCIIZ
	LEA	DX,PACKET		;DS:DX - pointer to submit packet
	MOV	AX,0101h		;Submit file to PRINT
	INT	2Fh			;Call DOS
	JC	ERROR_FROM_PRINT	;Error from PRINT?
	RET				;No - RETURN to Clarion program
ERROR_FROM_PRINT:
	CMP	AX,8			;Was the error code less than 8?
	JB	SET_GLOBERR		;  Yes, leave error code as is
	CMP	AX,12			;Was the error code greater than 12?
	JA	SET_GLOBERR		;  Yes, leave error code as is
ACCESS_DENIED:
	MOV	AX,5			;If 8,9, or 12 -> 'access denied'
	JMP	SHORT SET_GLOBERR
NAME_TOO_LONG:
	MOV	AX,2			;'file not found' if name too long
	JMP	SHORT SET_GLOBERR
SET_GLOBERR:
	CALL	SETGLOBERR		;Set GLOBERR to AX
	RET				;Return to Clarion program
SPOOL_PROC	ENDP			;End of SPOOL

;-----------------------------------------------------------------------;
; SETDIR procedure							;
;-----------------------------------------------------------------------;
SETDIR_PROC	PROC	FAR

	SUB	AX,AX			;Set GLOBERR to no ERROR
	CALL	SETGLOBERR

	MOV	CX,SETPATTERNL		;Get length SETPATTERN
	LES	SI,DWORD PTR SETPATTERN ;Get address of SETPATTERN
	MOV	BP,ES			;BP:SI points to SETPATTERN data
	CALL	COPYNAME		;Copy SETPATTERN to ASCIIZ
	JC	SETPATTERN_TOO_LONG	;SETPATTERN too long?
	MOV	SET1ST,1		;Mark as first time for NEXTDIR
	MOV	SETERR,0		;Clear any error
	PUSH	DS			;Save data segment
	LDS	DX,SETGROUP		;Get address of SETGROUP
	MOV	AH,1Ah			;Set DTA function code
	INT	21h			;Call DOS
	POP	DS			;Reset DS
	LEA	DX,ASCIIZ		;Get address of pattern
	MOV	CX,16h			;Set for files and directories
	MOV	AH,4Eh			;'Find first' function code
	INT	21h			;Call DOS
	JNC	SET_SUCCESSFULL		;Error?
	JMP	SHORT SET_FAILURE	;Yes - set error and exit
SET_SUCCESSFULL:			;No - padd rest of name to spaces
	LES	DI,SETGROUP		;Get address of SETGROUP
	CLD
	ADD	DI,30			;Point to NAME
	MOV	CX,13			;Make all spaces after null
PADD_SETNAME:
	CMP	BYTE PTR ES:[DI],0	;Find a null?
	JNE	NOT_A_NULL
	MOV	AL,20h			;Yes - fill out with spaces
	REP	STOSB			;*
	JMP	SHORT EXIT_SETDIR	;Done
NOT_A_NULL:
	INC	DI
	LOOP	PADD_SETNAME		;Loop
	JMP	SHORT EXIT_SETDIR
SETPATTERN_TOO_LONG:
	MOV	AX,3			;Path not found (name too long)
SET_FAILURE:
	MOV	SETERR,AX		;Save error for NEXTDIR
	CALL	SETGLOBERR
EXIT_SETDIR:
	RET				;Return to Clarion program
SETDIR_PROC	ENDP			;End of SETDIR

;-----------------------------------------------------------------------;
; NEXTDIR procedure							;
;-----------------------------------------------------------------------;
NEXTDIR_PROC	PROC	FAR

	SUB	AX,AX			;Clear global error word
	CALL	SETGLOBERR

	CMP	SET1ST,0		;First call after SETDIR
	JE	JUST_DID_A_SET
	MOV	SET1ST,0		;Clear it for later
	CMP	SETERR,0		;There was an error when SETDIR ran
	JE	SETDIR_FAILED
	MOV	AX,SETERR
	CALL	SETGLOBERR		;Set ERROR to SETDIR error
SETDIR_FAILED:
	RET				;Everything is set from SETDIR
JUST_DID_A_SET:
	PUSH	DS			;Save data segment
	LDS	DX,NEXTGROUP		;Get address of buffer for use as a DTA
	MOV	AH,1Ah			;Set DTA function code
	INT	21h			;Call DOS
	POP	DS			;Restore data segment

	MOV	AH,4Fh			;'Find next' function
	INT	21h			;Call DOS
	JNC	NEXT_SUCCESSFULL	;Error?
	CALL	SETGLOBERR		;Yes - report it
	JMP	SHORT EXIT_NEXTDIR
NEXT_SUCCESSFULL:			;No - change all nulls in name to spc
	LES	DI,NEXTGROUP		;Get address of NEXTGROUP
	CLD
	ADD	DI,30			;Point to NAME
	MOV	CX,13			;Make all spaces after null
PADD_NEXTNAME:
	CMP	BYTE PTR ES:[DI],0	;Find a null?
	JNE	NOT_A_NULL_IN_NEXT
	MOV	AL,20h			;Yes - fill out with spaces
	REP	STOSB			;*
	JMP	SHORT EXIT_NEXTDIR	;Done
NOT_A_NULL_IN_NEXT:
	INC	DI
	LOOP	PADD_NEXTNAME
EXIT_NEXTDIR:
	RET				;Return to Clarion program
NEXTDIR_PROC	ENDP			;End of NEXTDIR

;-----------------------------------------------------------------------;
; REMOVEDIR procedure							;
;-----------------------------------------------------------------------;
REMOVEDIR_PROC	PROC	FAR

	SUB	AX,AX			;Clear GLOBERR
	CALL	SETGLOBERR

	LES	SI,DWORD PTR RDNAME	;Copy name to ASCIIZ
	MOV	BP,ES
	MOV	CX,RDNAMEL		;Length of name
	CALL	COPYNAME
	JC	PATH_NOT_FOUND		;Use ASCIIZ name if not too long
	LEA	DX,ASCIIZ		;DS:DX to directory name
	MOV	AH,3Ah			;'Remove directory' code
	INT	21h			;Call DOS
	JNC	EXIT_REMOVEDIR		;Had an error? No, exit
	JMP	SHORT REMOVE_ERROR	;Yes, report it
PATH_NOT_FOUND:
	MOV	AX,3			;Path not found (name too long)
REMOVE_ERROR:
	CALL	SETGLOBERR		;Set GLOBERR to DOS error (AX)
EXIT_REMOVEDIR:
	RET				;Return to Clarion program
REMOVEDIR_PROC	ENDP			;End of REMOVEDIR

;-----------------------------------------------------------------------;
; MAKEDIR procedure							;
;-----------------------------------------------------------------------;
MAKEDIR_PROC	PROC	FAR

	SUB	AX,AX			;Clear GLOBERR
	CALL	SETGLOBERR

	LES	SI,DWORD PTR MDNAME	;Copy name to ASCIIZ
	MOV	BP,ES			;Get the directory name
	MOV	CX,MDNAMEL		;Get the length of the name
	CALL	COPYNAME
	JC	BAD_MAKEDIR_PATH	;Error if name too long
	LEA	DX,ASCIIZ		;DS:DX to directory name
	MOV	AH,39h			;'Create directory' code
	INT	21h			;Call DOS
	JNC	EXIT_MAKEDIR		;Had an error? No, exit
	JMP	SHORT MAKEDIR_ERROR	;Yes, report it
BAD_MAKEDIR_PATH:
	MOV	AX,3			;Path not found (name too long)
MAKEDIR_ERROR:
	CALL	SETGLOBERR		;Set GLOBERR to DOS error (AX)
EXIT_MAKEDIR:
	RET				;Return to Clarion program
MAKEDIR_PROC	ENDP			;End of MAKEDIR

;-----------------------------------------------------------------------;
; GODOS procedure							;
;-----------------------------------------------------------------------;
GODOS_PROC	PROC	FAR
	LES	SI,DWORD PTR RUNCODE	;Get the run code
	PUSH	ES:[SI]
	MOV	AX,145			;0 = 'Call DOS' code
	CALL	DWORD PTR LIBVEC	;Tell Processor to exit
GODOS_PROC	ENDP			;End of GODOS

;-----------------------------------------------------------------------;
; BOOT procedure							;
;-----------------------------------------------------------------------;
BOOT_PROC	PROC	FAR
	MOV	AX,40h			;SET FLAG FOR DOS
	MOV	ES,AX			;ON BOOT
	MOV	DI,72h			;*
	MOV	AX,1234h		;*
	MOV	ES:[DI],AX		;*
	JMP	DWORD PTR BOOTVEC	;Call BIOS for boot
BOOT_PROC	ENDP			;End of BOOT

;-----------------------------------------------------------------------;
; COMMAND_LINE() function						;
;-----------------------------------------------------------------------;
COMMAND_LINE_PROC	PROC	FAR
	MOV	AH,0FFh			;Get address of _PSP
	MOV	AL,68
	CALL	DWORD PTR LIBVEC
	MOV	ES,ES:[DI]		;Get segment of PSP
	MOV	SI,80h			;Offset of command line length
	SUB	CH,CH
	MOV	CL,BYTE PTR ES:[SI]	;Get the command line length
	INC	SI			;Offset of command line
	MOV	BP,ES			;Copyname expects segment in BP
	CALL	COPYNAME		;Get command line
	JNC	EXIT_COMMAND_LINE	;Check for command line length error
	MOV	ASCIIZ,0		;Error - return empty string
	SUB	CX,CX			;Clear the string length
EXIT_COMMAND_LINE:
	MOV	AX,TSTRING		;AX = 0, returning a string
	LEA	BX,ASCIIZ		;Offset of copied command line
					;CX = length of string
	RET
COMMAND_LINE_PROC	ENDP

;-----------------------------------------------------------------------;
; ENVIRONMENT() function						;
;-----------------------------------------------------------------------;
ENVIRONMENT_PROC	PROC	FAR
	PUSH	DS			;Save data segment
	PUSH	DS			;Make ES = DS
	POP	ES			;
	MOV	CX,ENVVARL		;Get the length of the variable
	CMP	CX,SIZE BUFFER - 1	;Cant be greater than 255
	JA	BAD_SEARCH_LENGTH
	JMP	SHORT SET_UP_SEARCH
BAD_SEARCH_LENGTH:
	JMP	ENVIRONMENT_NOT_FOUND
SET_UP_SEARCH:
	LEA	DI,BUFFER		;Get offset of BUFFER
	LDS	SI,DWORD PTR ENVVAR	;Get the search variable
	CALL	COPYSTRING		;Copy search var to buffer
	ADD	DI,CX			;Length of clipped destination
	DEC	DI			;Point to last byte
	CMP	BYTE PTR ES:[DI],'='	;Ends in an equal sign?
	JE	SEARCH_ENVIRONMENT	;Yes, ready for search
	INC	DI			;No, add a '=' to end
	MOV	BYTE PTR ES:[DI],'='	;Add null at end
	INC	CX			;New compare length
SEARCH_ENVIRONMENT:
	POP	DS			;Reset data segment
	PUSH	DS
	MOV	CS:ENVVARL,CX		;Save the length of the variable
	LEA	SI,BUFFER		;Source is now BUFFER
UPSTRING_LOOP:
	CALL	UPCHAR			;Convert BUFFER to upper case
	INC	SI
	LOOP	UPSTRING_LOOP

	MOV	AH,0FFh			;Get address of _PSP
	MOV	AL,68
	CALL	DWORD PTR LIBVEC
	MOV	ES,ES:[DI]		;Get segment of PSP
	MOV	DI,2Ch			;Offset of environment pointer
	MOV	ES,ES:[DI]		;Get segment of environment
	SUB	DI,DI			;Environment offset = 0
	MOV	DX,DI			;Save offset of environment
	CLD				;Forward
NEXT_ENVIRONMENT:
	CMP	BYTE PTR ES:[DI],0	;First byte a null?
	JZ	ENVIRONMENT_NOT_FOUND	;Yes, done searching
	MOV	CX,CS:ENVVARL		;Get the length of the variable
	LEA	SI,BUFFER		;Restore offset of search variable
	REP	CMPSB			;Is this the variable?
	JZ	ENVIRONMENT_FOUND	;Yes, found it
	MOV	DI,DX			;Restore offset of current entry
	SUB	AL,AL			;Look for next null
	MOV	CX,128			;Max scan length = 128
	REPNZ	SCASB			;Find end of this entry
	JNZ	ENVIRONMENT_NOT_FOUND	;Didn't find the null
	MOV	DX,DI			;Save new offset
	JMP	SHORT NEXT_ENVIRONMENT	;Continue searching
ENVIRONMENT_FOUND:
	POP	DS			;Restore data segment
	MOV	BEGOFF,DI		;Save beginning offset
	SUB	AL,AL			;Look for ending null
	MOV	CX,128			;Max scan length = 128
	REPNZ	SCASB			;Find end of this entry
	JNZ	EXIT_ENVIRONMENT	;Error if couldn't find null
	MOV	CX,DI			;Compute length of contents
	SUB	CX,BEGOFF		;Subtract pos. from start
	DEC	CX			;Subtract out the null
	MOV	ENVLTH,CX		;Save contents length
	MOV	BP,ES			;Segment of contents
	MOV	SI,BEGOFF		;Offset of contents
	CALL	COPYNAME		;Copy contents to ASCIIZ
	JMP	SHORT EXIT_ENVIRONMENT
ENVIRONMENT_NOT_FOUND:
	POP	DS			;Restore data segment
	MOV	ENVLTH,0		;Length of found contents
	MOV	ASCIIZ,0		;Assume variable not found
EXIT_ENVIRONMENT:
	MOV	CX,ENVLTH		;CX = contents length
	MOV	AX,TSTRING		;AX = 0, returning a string
	LEA	BX,ASCIIZ		;Offset of copied command line
	RET
ENVIRONMENT_PROC	ENDP

;-----------------------------------------------------------------------;
; UPCHAR								;
;	Internal subroutine for the DOS L.E.M.				;
;	Makes a character upper case if its between 'a' and 'z'		;
;									;
;	DS:SI = address of character					;
;-----------------------------------------------------------------------;
UPCHAR		PROC	NEAR
	MOV	AL,BYTE PTR DS:[SI]
	CMP	AL,'a'
	JB	EXIT_UPCHAR
	CMP	AL,'z'
	JA	EXIT_UPCHAR
	SUB	AL,20h
	MOV	BYTE PTR DS:[SI],AL
EXIT_UPCHAR:
	RET
UPCHAR		ENDP

;-----------------------------------------------------------------------;
; COPYNAME								;
;	Internal subroutine for the DOS L.E.M.				;
;	Copies source to ASCIIZ and clips trailing spaces		;
;	Calls COPYSTRING						;
;	Returns CARRY set if length longer than size of ASCIIZ - 1	;
;									;
;	CX    = length of source					;
;	BP:SI = address of source					;
;-----------------------------------------------------------------------;
COPYNAME	PROC	NEAR
	CMP	CX,SIZE ASCIIZ - 1
	JBE	DO_THE_COPY
	STC				;Set error
	RET				;Return to caller in L.E.M.
DO_THE_COPY:
	PUSH	CX			;Save length
	PUSH	DS			;Save data segment
	PUSH	DS			;ES:DI = destination
	POP	ES			;
	LEA	DI,ASCIIZ		;destination = ASCIIZ
	MOV	DS,BP			;BP:SI points to source
	CALL	COPYSTRING
	POP	DS
	POP	CX
	RET				;Return to caller in L.E.M.
COPYNAME	ENDP			;End of COPYNAME

;-----------------------------------------------------------------------;
; COPYSTRING								;
;	Internal subroutine for the DOS L.E.M.				;
;	Copies a string and clips trailing spaces from the destination	;
;									;
; Expects:								;
;	CX    = length of source					;
;	DS:SI = address of source					;
;	ES:DI = address of destination					;
;									;
; Returns:								;
;	CX = the length of the resultant destination after clipping	;
;-----------------------------------------------------------------------;
COPYSTRING	PROC	NEAR
	PUSH	CX			;Save length
	PUSH	SI			;Save source offset
	PUSH	DI			;Save dest offset
	CLD				;Forward
	REP	MOVSB			;Move it
	MOV	BYTE PTR ES:[DI],0	;Add null at end
	POP	DI			;Restore dest offset
	POP	SI			;Restore source offset
	POP	CX			;Restore length
	PUSH	DI			;Save dest offset again
	MOV	AX,CX			;Set up count register
	DEC	AX			;Make relative to zero
	ADD	DI,AX			;Point to end
	MOV	AL,20h			;Look for spaces
	STD				;Backwards direction
	REPZ	SCASB			;Scan while equal to spaces
	JNZ	NOT_A_SPACE
	MOV	BYTE PTR ES:1[DI],0	;String all spaces;put null at begin
	JMP	SHORT EXIT_COPYSTRING
NOT_A_SPACE:
	INC	CX			;Fix CX which is 1 too small
	MOV	BYTE PTR ES:2[DI],0	;Null terminate after non-space
EXIT_COPYSTRING:
	CLD				;Back to forward
	CLC				;No error
	POP	DI			;Restore dest offset
	RET				;Return to caller in L.E.M.
COPYSTRING	ENDP			;End of COPYSTRING

;-----------------------------------------------------------------------;
; SETGLOBERR								;
;	Internal subroutine for the DOS L.E.M.				;
;	Set global error returned by ERROR() and ERRORCODE()		;
;									;
;	AX = error code							;
;-----------------------------------------------------------------------;
SETGLOBERR	PROC	NEAR
	PUSH	ES			;Save used registers
	PUSH	DI
	PUSH	AX			;Save error code
	MOV	AH,0FFh			;Get address of GLOBERR
	MOV	AL,29
	CALL	DWORD PTR LIBVEC
	POP	AX			;Get error code
	MOV	ES:[DI],AX		;Set GLOBERR
	POP	DI			;Restore used registers
	POP	ES
	RET				;Return to caller in L.E.M.
SETGLOBERR	ENDP			;End of SETGLOBERR

;-----------------------------------------------------------------------;
; End of L.E.M.								;
;-----------------------------------------------------------------------;
BINEND	DB	0			;Used to provide size of L.E.M.
CODE	ENDS				;End of the code segment
	END				;End of the DOS L.E.M.
