#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   whiteYouth.t 
 *
 *   This is the NPC who appears in the tomb and demands that the PC chooses 
 *   a clolured bead, 
 */

whiteYouth: Person 'young man/youth' 'young man' @tomb
    "He's dressed in a dazzling white shroud. Although he's young, his face
    looks strangely reminiscent of Professor Wortschachter's. "
    isHim = true
    uselessToAttackMsg = 'You sense that would be a seriously bad idea --
        there\'s something not quite natural about this young man, and he
        probably has hidden powers you\'d rather not put to the test. '
;

+ Decoration 'dazzling white shroud' 'white shroud'
    "It's whiter than any earthly fuller could bleach it, and covers his body
    from neck to ankle. "
    notImportantMsg = 'You don\'t want to annoy him by fiddling with his
        clothes. '
;

+ whiteYouthTalking: InConversationState
    specialDesc = "The young man is standing by the shelf, waiting for your
        next move. "
    beforeAction()
    {
        if(gActionIs(Break) && gDobj == ossuary)
        {
            "You're about to dash the ossuary on the ground when the young man
            puts out his hand to stop you, <q>I can't allow that!</q> he tells
            you, <q>It's a valuable artifact!</q> ";
            exit;  
        }
    } 
    attentionSpan = nil
    endConversation(actor, reason)
    {
        if(reason == endConvBye)
        {
            "<q>You're not going anywhere,</q> the young man points out. ";
            return nil;
        }
        return inherited(actor, reason);
    }
;

++ ConversationReadyState
    specialDesc = "A young man dressed in a white robe is standing just inside
        the tomb. "
    isInitState = true
;

++ AskTellTopic @tHistoricalJesus
    "<q>So where is Jesus, then?</q> you ask.\b
    <q>He is not here,</q> the young man replies. "
;

++ AskTopic @tAuthenticity
    "<q>How am I meant to tell which of these beads is authentic?</q> you want
    to know.\b
    <q>By applying the criteria for authenticity of course.</q> he replies. "
;

++ AskTellTopic [tCriteria, criteria]
    "<q>What are the criteria for judging authenticity?</q> you enquire.\b
    <q>Read the scroll - they're all clearly laid out there.</q> he tells you.
    <<gSetKnown(criteria)>>"  
;

+++ AltTopic
    "<q>But these criteria don't make any sense!</q> you complain.\b
    <q>Of course they do!</q> the young man retorts, <q>You New Testament
    scholars have been using them for decades!</q>"
    isActive = gRevealed('criteria')
;

++ AskTopic +110 [criteria, tScroll]
    "<q>Where can I find this scroll telling me about the criteria?</q> you
    want to know.\b
    <q>I'll make no bones about it -- that's something you'll have to find for
    yourself.</q> he replies. "
    isActive = (!criteria.seen)
;

++ AskTopic [tCoherence, tMultipleAttestation, tDoubleDissimilarity]
    "<q>Explain <<gTopicText>> to me,</q> you request.\b
    <q>You\'re the scholar; you should know about such things,</q> he
    replies. "
;

++ GiveShowTopic [redBead, pinkBead, greyBead, blackBead]
    "<q>Are you absolutely sure this is an authentic bead?</q> the young man
    asks, <q>Remember, you only get one chance -- so, are you sure that this is
    really the bead you want to give me?</q><.convnode sure-bead>"
;

++ AskTellTopic, StopEventList [redBead, pinkBead, greyBead, blackBead, tBeads]
    [
        '<q>Aren\'t these beads something to do with the Jesus Seminar?</q> you
        wonder, <q>Surely they\'re for <i>voting</i> on what\'s authentic;
        they\'re not authentic or inauthentic in themselves!</q><.p>
        <q>The Jesus Seminar\'s rules don\'t apply here,</q> he replies,
        <q>I\'m well aware that in their scheme of things red indicates
        authentic and black inauthentic, but that isn\'t the scheme I\'m asking
        you to judge by. It\'s the authenticity of the beads themselves you
        need to decide on.</q>',
        
        '<q>But what does it mean for a bead to be authentic?</q> you ask.<.p>
        <q>Study the criteria,</q> the young man replies.' 
        
    ]
;

++ AskTopic @whiteYouth
    "<q>Who are you?</q> you ask.<.p>
    <q>I am what you see,</q> he replies enigmatically."
;

++ AskTopic @tomb
    "<q>What is this tomb?</q> you ask.\b
    <q>It is whatever you think it is,</q> he replies engimatically,
    <q>but unless you give me the right bead, it will become your tomb.</q> "
;

++ AskTellTopic @ossuary
    "<q>What's the ossuary for?</q> you ask.\b
    <q>As you well know, it's a box for bones,</q> he tells you. "
;

++ AskTellTopic @niche
    "<q>What's that niche in the wall?</q> you enquire.\b
    The young man gives a heavy sigh, <q>Obviously, it's a loculus -- a place
    for burial,</q> he replies. "
;

++ DefaultGiveShowTopic
    "<q>I cannot be bribed,</q> the young man assures you, <q>give me one
    of those four beads, or nothing.</q> ";
;

++ DefaultAskTopic, ShuffledEventList
    [
        '<q>I\'m not here to discuss that,</q> he tells you. ',
        
        '<q>I suggest you concentrate on the task in hand,</q> he advises. ',
        
        '<q>I have nothing to say on that subject,</q> he replies. ',
        
        '<q>It is not my task to satisfy your curiosity,</q> he answers. ',
        
        '<q>Your job is to hand me an authentic bead; my job is to check
        that you do; nothing else concerns me,</q> he replies. ',
        
        '<q>You\'re simply wasting time with such questions,</q> he warns you. ',
        
        '<q>I have no interested in discussing that or any other topic with
        you,</q> he responds coldly. ',
        
        '<q>Your questions bore me,</q> he complains, <q>Just get on with the
        task in hand!</q>',
        
        '<q>The sooner you choose a bead, the sooner we can end this
        situation,</q> he tells you, <q>your idle chatter is utterly beside the
        point.</q>',
            
        '<q>I\'m not here to indulge your thirst for fruitless
        conversation,</q> he answers. ',
        
        '<q>Even if I thought that question pertinent or interesting I would
        not bother to answer it,</q> he replies loftily, <q>since I am not here
        to talk with you.</q>'     
    ]
;

++ DefaultTellTopic, ShuffledEventList
    [
        '<q>That is of no concern to me,</q> he remarks loftily. ',
        '<q>I\'m not here to listen to your opinions,</q> he replies. ',
        '<q>You have a task to complete, I suggest you get on with it,</q> he
        insists. ',
        '<q>Idle chatter will get you nowhere,</q> he warns you. '
    ]
;

++ DefaultAskForTopic
    "<q>It's not my job to give you anything,</q> he replies. "
;

++ CommandTopic @TopicActionBase
    "It probably doesn't make much sense to tell him to do that. "
    isConversational = nil
;

++ DefaultTCommandTopic
    "<q>Would you <<cmdPhrase>>, please?</q> you ask.\b
    <q>No, I would not,</q> he replies. "
;

+ ConvNode 'sure-bead'
;

++ NoTopic
    "You hesitate, <q>Not absolutely sure, no,</q> you confess.\b
    <q>Then you had better put it back and select another,</q> the young man
    suggests. "
    timesToSuggest = nil
;

++ YesTopic
    "<q>Yes, I'm sure that's the one.</q> you affirm.\b
    <q>Can you explain why?</q> the young man asks.<.convnode explain-bead>"
    timesToSuggest = nil
;

++ DefaultAnyTopic
    "<q>Yes or no?</q>he insists<.convstay>"
;

+ ConvNode 'explain-bead'
;

++ NoTopic, SuggestedNoTopic
    "<q>No, I can't, I'm just guessing.</q> you confess.\b
    <q>That's not good enough. You have to <i>know</i>,</q> the young man
    insists, <q>Try again.</q>\b
    He hands the bead back to you."
    timesToSuggest = nil
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes, you can see it's an authentic bead, just by looking at it.</q>\b
    <q>No you can't; you'll have to do better than that.</q> the young man
    contradicts you. "
    timesToSuggest = nil
;

+++ AltTopic, SuggestedYesTopic
    topicResponse()
    {
        "<q>Absolutely!</q> you declare confidently, <q>This bead meets the
        criterion of double dissimilarity because it is different in colour
        from all the other beads. On the other hand it is the same shape as all
        the authentic beads, and so it meets the criterion of coherence. At the
        same time, it is multiply attested by all the beads being the same
        size.</q>\b
        <q>Very well!</q> the young man declares, <q>You have convinced me that
        this must indeed be an authentic bead. So -- farewell!</q>\b
        The young man's white robe glows brighter and brighter, until you are
        temporarily blinded; when you are able to see again you find that the
        young man has vanished, along with the beads, but that the stone has
        rolled away once more.<.p>";
        
        whiteYouth.moveInto(nil);
        redBead.moveInto(nil);
        pinkBead.moveInto(nil);
        greyBead.moveInto(nil);
        blackBead.moveInto(nil);
        tombStone.makeOpen(true);
        achievement.awardPointsOnce();
    } 
    isActive = gRevealed('criteria')
    achievement: Achievement { +1 "identifying an authentic bead" }
;

++ DefaultAnyTopic
    "<q>Yes or no?</q> he insists<.convstay>"
;


+ AgendaItem
    initiallyActive = true
    isReady = (getActor.canSee(gPlayerChar))
    invokeItem()
    {
        "<q>You seek the Historical Jesus,</q> the young man in white surmises,
        <q>He is not here, see the place where they laid him,</q> he points to
        the rock shelf, <q>Now <i>you</i> must decide what\'s authentic here.
        You must select one of those four coloured beads and give it to me. If
        it is authentic, you will be allowed to leave -- but if it is an
        inauthentic bead, this tomb will be your final resting place.</q>
        <.reveal bead-task>";
        getActor.setCurState(whiteYouthTalking);
        isDone = true;
    }
;
