'************************************          Breath Pirates          ******
'  ** /\/\/\/\/\/\/\/\/\/\/\/\/\ **   (c) 1997 by: Prowler Productions   **
'************************************      Written by Mike Snyder      ******

'$INCLUDE: 'BREATH.INC'

'*** Have to "RE-DIM" arrays here. single vars are COMMON in BREATH.INC

DIM SHARED TransColor(0 TO 20) AS INTEGER
DIM SHARED Uo$(MaxItems, 4) 'Will accept up to FOUR nouns for each object
DIM SHARED oc$(MaxItems)     'What the object is called in the Room & Inventory
DIM SHARED Dir(MaxRooms, 4) 'Which DIRECTIONS are available!?!
DIM SHARED LDir(100, 3)  AS INTEGER   'What limitations on movement are there?
DIM SHARED CanGo(1 TO 4) AS INTEGER 'When showing room, CanGo is set to DIR's avail.
DIM SHARED o(1 TO MaxItems) AS INTEGER 'Where item is LOCATED. 0=In Inventory!!
DIM SHARED Special(1 TO MaxSpecial) AS INTEGER 'How many "Special" things are there?
DIM SHARED Token$(100)
DIM SHARED ScrollBackCommand$(MaxScroll)
DIM SHARED ScrollBackItem$(MaxScroll)

RANDOMIZE (-TIMER)

SoundOn = 1
IF INSTR(UCASE$(COMMAND$), "/Q") THEN SoundOn = 0

ReStartGame:

ret$ = CHR$(10) + CHR$(13)
nolag = 0  '1=NOLAG 0=lag (default)
TLocy = 25: TLocX = 42 'Status Line "TIME" is printed to this LOCATE pos.
PromptLineNum = 0: WaitState = 0 'Used in the "rotating" prompt line. :)

Oldx1 = -1: OldX2 = -1: OldX3 = -1 'Cursor positioning, I think.
TransColor(0) = 0: TransColor(1) = 4: TransColor(2) = 2
TransColor(3) = 6: TransColor(4) = 1: TransColor(5) = 5
TransColor(6) = 3: TransColor(7) = 7
TransColor(10) = 8: TransColor(11) = 12: TransColor(12) = 10
TransColor(13) = 14: TransColor(14) = 9: TransColor(15) = 13
TransColor(16) = 11: TransColor(17) = 15

'---------------------------------------------------------- SECTION: Intro
'                                          Title Screen, Instructions, etc
Score = 0: lo = 0 ' 0=Introduction :)
TempCommand$ = "": ScrollItemCount = 0: ScrollCommandCount = 0
TagLine$ = "`}============== `$Introduction "
    DoIntro

'------------------------------------------------------- SECTION: InitVars
'                                              Set up intro variables, etc

FOR x = 1 TO MaxSpecial: Special(x) = 0: NEXT x
RESTORE Uo1
FOR x = 1 TO MaxItems
    FOR y = 1 TO 4
        READ Uo$(x, y)
    NEXT y
NEXT x
RESTORE Uo2
FOR x = 1 TO MaxItems
    READ oc$(x)
NEXT x
RESTORE Uo3
FOR x = 1 TO MaxItems
    READ o(x)
NEXT x
RESTORE Uo4
FOR x = 1 TO MaxRooms
    READ Dir(x, 1): READ Dir(x, 2): READ Dir(x, 3): READ Dir(x, 4)
NEXT x
RESTORE Uo5
MaxLDir = 0
Veep: READ a1, a2, a3
IF a1 <> -1 THEN
    MaxLDir = MaxLDir + 1
    LDir(MaxLDir, 1) = a1: LDir(MaxLDir, 2) = a2: LDir(MaxLDir, 3) = a3
END IF
IF a1 <> -1 THEN GOTO Veep

PromptLineNum = 1  'Which "helpful hint" is being displayed. It increments.
lo = 12: OldLo = 0   'What's the start room and what's the room coming "from"
Ocls

'--------------------------------------------------------- SECTION: DoRoom
'                                            Re-displayes the current room

DoRoom:
ShowRoom lo, OldLo
OldLo = lo
Oprint ret$
ShowDirsAvail
ShowItemsHere
Oprint ret$

'-------------------------------------------------------- SECTION: TopLoop
'                                             Main INPUT section Beginning

TopLoop:
Oprint InLine$
TopLoop2:
IF OnHold$ = "" THEN MultiCommand = 0
IF MultiCommand = 0 THEN
    b$ = GetInput$
ELSE
    b$ = StripConcat$(OnHold$)
END IF

IF LEN(b$) = 0 THEN
    Oprint STRING$(80, 8): Oprint STRING$(79, " "): Oprint STRING$(80, 8)
    GOTO TopLoop
END IF

'*** check for concatenated commands using semi-colon or period!
OldMult = MultiCommand 'Store for checking it.
MultiCommand = 0
a1 = INSTR(b$, ";"): IF a1 = 0 THEN a1 = INSTR(b$, ".")
a2 = INSTR(UCASE$(b$), " THEN ")
IF a1 > 1 AND a1 < LEN(b$) AND (a1 < a2 OR a2 = 0) THEN
    OnHold$ = RTRIM$(LTRIM$((RIGHT$(b$, LEN(b$) - a1))))
    b$ = RTRIM$(LTRIM$(LEFT$(b$, a1 - 1)))
    b$ = StripConcat$(b$)
    IF LEN(b$) > 0 THEN
        MultiCommand = 1
    ELSE
        IF LEN(OnHold$) THEN MultiCommand = 1
        GOTO TopLoop2
    END IF
END IF
IF a2 > 1 AND (a1 + 5) < LEN(b$) AND (a2 < a1 OR a1 = 0) THEN
    OnHold$ = RTRIM$(LTRIM$((RIGHT$(b$, LEN(b$) - (a2 + 5)))))
    b$ = RTRIM$(LTRIM$(LEFT$(b$, a2 - 1)))
    b$ = StripConcat$(b$)
    IF LEN(b$) > 0 THEN
        MultiCommand = 1
    ELSE
        IF LEN(OnHold$) THEN MultiCommand = 1
        GOTO TopLoop2
    END IF
END IF

IF OldMult = 0 AND MultiCommand <> 0 THEN
    Oprint STRING$(80, 8): Oprint STRING$(79, " "): Oprint STRING$(80, 8)
    Oprint InLine$
    Oprint "`7" + b$
    : Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus
    : Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus
END IF

IF OldMult <> 0 THEN
    Oprint "`7" + b$ + ret$
    : Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus
    : Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus: Paus
ELSE
    Oprint ret$ '<enter> after typing a command. :)
END IF

a$ = AlterInput$(UCASE$(b$)) 'To change input to allow "other" commands

'--------------------------------------------------------- SECTION: Parser
'                                              Parsing the commands starts
'*** First, check if they want to re-display the room!
IF a$ = "L" OR a$ = "LOO" OR a$ = "LOOK" THEN Ocls: GOTO DoRoom

'*** Second, check if they typed a DIRECTION to go
IF VerbGo(a$) <> 0 THEN
    GOTO DoRoom
END IF

'*** Were they trying to look at Inventory?
IF a$ = "I" OR a$ = "INV" OR a$ = "INVENT" OR a$ = "INVENTORY" OR a$ = "ITEMS" OR a$ = "ITEM" THEN
    ShowInventory
    GOTO TopLoop
END IF

IF VerbGetDrop(a$) <> 0 THEN GOTO TopLoop
IF VerbFunnyGet(a$) <> 0 THEN GOTO TopLoop
IF VerbLookAtItems(a$) <> 0 THEN GOTO TopLoop
IF VerbTalk(a$) <> 0 THEN GOTO TopLoop
IF VerbGive(a$) <> 0 THEN GOTO TopLoop
IF VerbQuit(a$) <> 0 THEN GOTO TopLoop
IF VerbLook(a$) <> 0 THEN GOTO TopLoop
IF VerbUnlock(a$) <> 0 THEN GOTO TopLoop
IF VerbInsert(a$) <> 0 THEN GOTO TopLoop
IF VerbOpen(a$) <> 0 THEN GOTO TopLoop
IF VerbJump(a$) <> 0 THEN GOTO TopLoop
IF VerbPour(a$) <> 0 THEN GOTO TopLoop
IF VerbDig(a$) <> 0 THEN GOTO TopLoop
IF VerbMove(a$) <> 0 THEN GOTO TopLoop
IF VerbClimb(a$) <> 0 THEN GOTO TopLoop
IF IsVerb(a$, "SCORE") THEN Oprint " " + MakeScore$ + ret$: GOTO TopLoop
Nul = VerbLoadGame(a$): IF Nul = 1 THEN GOTO TopLoop ELSE IF Nul = 2 THEN Ocls: GOTO DoRoom
Nul = VerbHelp(a$): IF Nul = 1 THEN GOTO TopLoop ELSE IF Nul = 2 THEN Ocls: GOTO DoRoom
IF VerbSaveGame(a$) <> 0 THEN GOTO TopLoop
IF VerbMiscel(a$) <> 0 THEN GOTO TopLoop

'** want to re-start?
IF a$ = "RESTART" OR LEFT$(a$, 8) = "RESTART " THEN
    TIMER OFF: PLAY OFF
    VIEW PRINT 1 TO 24: CLS : COLOR 7
    GOTO ReStartGame
END IF

'***** Otherwise, command was not directly understood, so say so and cancel
'***** A concatenated command if one was tried

J = BadCommand(a$)
OnHold$ = ""

IF J = 0 THEN
    e = INT(8 * RND(1)) + 1
    IF e = 1 THEN Oprint "`7 That's pretty amusing." + ret$
    IF e = 2 THEN Oprint "`7 What? Where!!! Huh?" + ret$
    IF e = 3 THEN Oprint "`7 You can't do that." + ret$
    IF e = 4 THEN Oprint "`7 Where did you get an idea like that?" + ret$
    IF e = 5 THEN Oprint "`7 That doesn't make sense." + ret$
    IF e = 6 THEN Oprint "`7 That resulted in nothing." + ret$
    IF e = 7 THEN Oprint "`7 No." + ret$
    IF e = 8 THEN Oprint "`7 That didn't work." + ret$
END IF

GOTO TopLoop

'-------------------------------------------------------- SECTION: Globals
'                                        Error-Trapping & Interrupt Events

NoFile: FileExists = 0: RESUME NEXT
AnError: PRINT "error!": END
WatchError: ErrorFound = 1: RESUME NEXT

'--------------------------------------------------------- SECTION: Status
'                                        Error-Trapping & Interrupt Events

SoundDoIt:
IF TPlay = 1 THEN PLAY "mbo2t120msl8fl16ccl8fl16ccfgo3l4cl16cd"
IF TPlay = 2 THEN PLAY "l8d+dco2a+l16o3co2a+l4ap8"
IF TPlay = 3 THEN PLAY "o2t120msl8fl16ccl8fl16ccfgo3l4cl16cd"
IF TPlay = 4 THEN PLAY "l8d+l16dd+l8fl16d+dl4cp8"
IF TPlay = 5 THEN PLAY "o3t120msl16dd+l4fcl8o2d+dcp8d+"
IF TPlay = 6 THEN PLAY "l16dcl8dl16co1a+l4o2cp8"
IF TPlay = 7 THEN PLAY "o2t120msl16cdl8d+fga+l16agl8fp8l16ff"
IF TPlay = 8 THEN PLAY "l8d+l16dcl8dl16d+fl4a+p4"
IF TPlay = 9 THEN PLAY "mno2t120l4fcl8fgp4l4fcfp4"
IF TPlay = 10 THEN PLAY "fcl8a+agfmlal16amngl2gp4"
IF TPlay = 11 THEN PLAY "l4o2l4fco1afp8l8fgal4a+p4"
IF TPlay = 12 THEN PLAY "o2l4cfl8fedefl16ccl8cl16cc"
IF TPlay = 13 THEN PLAY "l8cl16ccl8de"

TPlay = TPlay + 1: IF TPlay > 13 THEN TPlay = 1
RETURN

TimeDoIt:
y = CSRLIN
x = POS(n)
f1 = OldFg: f2 = OldBg: F3 = Flash
c$ = MakeTime$

IF NoRecurse = 0 THEN
    IF TLocy = 1 THEN VIEW PRINT 1 TO 24

    LOCATE TLocy, TLocX
    COLOR 10, 1: PRINT c$;

    COLOR f1 + F3, f2: OldFg = f1: OldBg = f2: Flash = F3
    LOCATE y, x

    IF PromptLineNum > 0 THEN
        WaitState = WaitState + 1
        IF WaitState >= 3 THEN
            WaitState = 0
            PromptLineNum = PromptLineNum + 1
            IF PromptLineNum > 5 THEN
                PromptLineNum = 1
            END IF
            PromptLine (PromptLineNum)
        END IF
    END IF
   
    IF TLocy = 1 THEN
        ScoreToggle = ScoreToggle + 1
        IF ScoreToggle > 3 THEN ScoreToggle = 0 '2 cycles per each.
        IF ScoreToggle = 0 THEN
            LOCATE TLocy, 53
            Oprint "`a" + TagLine$
        END IF
        IF ScoreToggle = 2 THEN
            LOCATE TLocy, 53
            Oprint "`a" + MakeScore$
        END IF
    END IF

    IF TLocy = 1 THEN VIEW PRINT 2 TO 24
    COLOR f1 + F3, f2: OldFg = f1: OldBg = f2: Flash = F3
    LOCATE y, x
END IF

RETURN

'-------------------------------------------------------- SECTION: DataDec
'                                         Data Declarations for ITEMS, etc

Uo1: 'What words are "understood" to be this item for GET/LOOK/DROP
DATA "NEWS","PAPE","REBEL","VOIC"
DATA "KEY","KEY","KEY","KEY"
DATA "OIL","CAN","OIL","CAN"
DATA "BAND","SCARF","RAG","CLOTH"
DATA "CARD","MEMB","CARD","MEMB"
DATA "SHOV","SPAD","TOOL","SHOV"
DATA "NOTE","NOTE","PAPER","PAPER"

Uo2: 'What inventory CALLS this item when typing INV.
DATA "Rebel Voice Newspaper","Key","Can of Oil"
DATA "Bandana","Membership Card","Shovel","Note"

Uo3: 'Where each item is LOCATED
DATA 12, 100, 100, 6, 100, 100, 100
'DATA 12, 12, 12, 12, 12, 12, 12

Uo4: 'Directions Available if ALL exits are open
DATA 0,0,1,0
DATA 0,1,0,1
DATA 0,1,1,0
DATA 0,0,0,1
'room 5
DATA 0,1,0,0
DATA 1,1,1,0
DATA 1,0,1,1
DATA 0,0,0,1
'room 9
DATA 1,0,1,0
DATA 1,1,1,1
DATA 0,0,1,1
DATA 0,0,0,1

Uo5: 'Limitations on DIRECTIONS 1=room, 2=Direction, 3=SPECIAL needed!
DATA 9,1,1
DATA 10,1,2
DATA 3,3,3
DATA 2,4,4
'Data read terminates based on -1 field
DATA -1,-1,-1

SUB AddScore (d%)

NoRecurse = 1 'To pevent the GLOBAL routine from kicking in while this is.

Score = Score + d%
IF SoundOn <> 0 THEN PLAY "mbmnt160l16o2cdemlggmnl16emlgg"

y = CSRLIN
x = POS(n)
f1 = OldFg: f2 = OldBg: F3 = Flash

IF TLocy = 1 THEN VIEW PRINT 1 TO 24

LOCATE TLocy, 53
Oprint "`a" + MakeScore$
ScoreToggle = 2 'So it will stay up for at least 8 seconds :)

IF TLocy = 1 THEN VIEW PRINT 2 TO 24

COLOR f1 + F3, f2: OldFg = f1: OldBg = f2: Flash = F3
LOCATE y, x

PALETTE 0, 63
Paus
PALETTE 0, 0
Paus
PALETTE 0, 63
Paus
PALETTE 0, 0

NoRecurse = 0

END SUB

SUB AddToCommand (SB%, a$)


IF SB% = 1 AND a$ <> "" THEN
    IF ScrollCommandCount >= 1 THEN
        IF UCASE$(ScrollBackCommand$(ScrollCommandCount)) = UCASE$(a$) THEN
            EXIT SUB
        END IF
    END IF

    IF ScrollCommandCount >= MaxScroll THEN
        ScrollCommandCount = MaxScroll
        FOR x = 1 TO MaxScroll - 1: ScrollBackCommand$(x) = ScrollBackCommand$(x + 1)
        NEXT x
    ELSE
        ScrollCommandCount = ScrollCommandCount + 1
    END IF
    ScrollBackCommand$(ScrollCommandCount) = a$
END IF

IF SB% = 2 AND a$ <> "" THEN
    IF ScrollItemCount >= 1 THEN
        IF UCASE$(ScrollBackItem$(ScrollItemCount)) = UCASE$(a$) THEN
            EXIT SUB
        END IF
    END IF
   
    IF ScrollItemCount >= MaxScroll THEN
        ScrollItemCount = MaxScroll
        FOR x = 1 TO MaxScroll - 1: ScrollBackItem$(x) = ScrollBackItem$(x + 1)
        NEXT x
    ELSE
        ScrollItemCount = ScrollItemCount + 1
    END IF
    ScrollBackItem$(ScrollItemCount) = a$
END IF

END SUB

FUNCTION AlterInput$ (b$)

a$ = UCASE$(b$)
IF lo = 3 AND INSTR(a$, "LIFT LID") THEN b$ = "OPEN MAILBOX"
IF lo = 3 AND (LEFT$(a$, 8) = "OIL MAIL" OR LEFT$(a$, 7) = "OIL BOX" OR LEFT$(a$, 9) = "OIL HINGE") THEN b$ = "POUR OIL ON MAILBOX"
IF lo = 4 AND LEFT$(a$, 5) = "JOIN " THEN b$ = "TALK PIRATES ABOUT JOINING"
IF LEFT$(a$, 9) = "USE SHOVE" THEN b$ = "DIG WITH SHOVEL"

AlterInput$ = b$

END FUNCTION

FUNCTION CallAnyQuit%
    Oprint "`8.... `6Press [`@ENTER`6] to continue or [`@Q`6] to quit`7: "
    t$ = RTRIM$(LTRIM$(KbIn$(1, "", "$", 0)))
    IF t$ = "Q" THEN CallAnyQuit = 1: EXIT FUNCTION
    ClearLine
END FUNCTION

SUB CallPalette (b$)

'*** Scripting function

a$ = LTRIM$(RTRIM$(UCASE$(b$)))

IF a$ = "/PALETTE" THEN PALETTE: EXIT SUB

IF LEFT$(a$, 8) = "/PALETTE" AND LEN(a$) >= 12 AND INSTR(a$, ",") > 0 AND INSTR(a$, ",") < LEN(a$) THEN
    k = VAL(MID$(a$, 10, 2))
    n = VAL(MID$(a$, INSTR(a$, ",") + 1, 3))
    IF k >= 0 AND k <= 16 AND n >= 0 AND n <= 63 THEN PALETTE k, n
END IF
END SUB

SUB CallPaus (b$)

a$ = UCASE$(b$)
IF LEFT$(a$, 6) = "/PAUS:" AND LEN(a$) > 6 THEN
    n = VAL(MID$(a$, 7, 4))
    IF n > 0 AND n <= 99 THEN FOR x = 1 TO n: Paus: NEXT x
END IF

END SUB

SUB CallView (b$)

'*** Scripting function

a$ = LTRIM$(RTRIM$(UCASE$(b$)))

IF a$ = "/VIEW" THEN VIEW PRINT 1 TO 24: EXIT SUB

IF LEFT$(a$, 5) = "/VIEW" AND LEN(a$) >= 9 AND INSTR(a$, ",") > 0 AND INSTR(a$, ",") < LEN(a$) THEN
    k = VAL(MID$(a$, 7, 2))
    n = VAL(MID$(a$, INSTR(a$, ",") + 1, 3))
    IF k >= 1 AND k <= 24 AND n >= 1 AND n <= 24 AND k <= n THEN VIEW PRINT k TO n
END IF

END SUB

SUB CheckForComputer

'*** This function "ATTEMPTS" to do some of the things that happen in this
'*** game to trap any errors so the game "gracefully" exits instead of just
'*** bombs out. :)

ON ERROR GOTO WatchError

CLS : PRINT : COLOR 7

'*** First, test PALETTE rotations

FOR x = 1 TO 15
    PALETTE x, 63: PALETTE x, 0
NEXT x
PALETTE 0, 0
PALETTE

IF ErrorFound <> 0 THEN
    PRINT
    PRINT "    Your computer cannot do 16-color text palette alternations."
    PRINT "    You will not be able to play Breath Pirates on this computer."
    PRINT
    END
END IF

'*** Next, test view print command

VIEW PRINT 1 TO 24
VIEW PRINT 2 TO 24
VIEW PRINT 1 TO 25

IF ErrorFound <> 0 THEN
    PRINT
    PRINT "    Your computer cannot define a text view port."
    PRINT "    You will not be able to play Breath Pirates on this computer."
    PRINT
    END
END IF

PRINT
END SUB

SUB ClearLine

Oprint "`7" + STRING$(80, 8) + STRING$(79, " ") + STRING$(80, 8)

END SUB

FUNCTION ContainsToken% (a$) '** returns whether or not A$ contains a TOKEN!

g = 0
FOR x = 1 TO TokenCount
    IF INSTR(UCASE$(a$), UCASE$(Token$(x))) THEN g = g + 1
NEXT x

ContainsToken = g

END FUNCTION

SUB DoIntro

CLS
PRINT
PRINT
Oprint "`9    Press `3<`!ESC`3>`9 to bypass Intro Screens..." + ret$ + ret$

Oprint "`7    to play without sound, use `%BREATH /Q" + ret$

ob! = TIMER
zan: IF ABS(TIMER - ob!) > 1.5 THEN GOTO Cont1
a$ = INKEY$
IF a$ = CHR$(27) THEN
    CheckForComputer
    SetStandardErrorTrap
    TLocy = 1
    StatLine
    VIEW PRINT 2 TO 24
    ON TIMER(4) GOSUB TimeDoIt
    TIMER ON
    EXIT SUB
END IF
GOTO zan

Cont1:
CheckForComputer
SetStandardErrorTrap
VIEW PRINT 1 TO 24
: Ocls: PALETTE
IF SoundOn <> 0 THEN
    ON PLAY(3) GOSUB SoundDoIt
    TPlay = 1
    PLAY ON
    PLAY "mbt255l63o1p63p63p63p63p63"
END IF
ON TIMER(4) GOSUB TimeDoIt
StatLine
TIMER ON
'------------------------------------------------------- Intro Text!!! -----
    IF VariFile("BREATH.TXT") <> 0 THEN ShowFile "BREATH.TXT", "@@INTRO"
'-------------------------------------------------- Move StatLine up! -----
TIMER OFF
PLAY OFF
VIEW PRINT 1 TO 24
LOCATE 25, 1: Oprint "`7`h" + STRING$(80, " ")
TLocy = 24
StatLine
LOCATE 24, 80: Oprint ret$
FOR x = 1 TO 22: Paus: Oprint "" + ret$: NEXT x
VIEW PRINT 2 TO 24
TLocy = 1
TIMER ON

END SUB

FUNCTION DoRandomFeature%

    IF lo = 9 THEN
        ClearLine
        d = INT(3 * RND(1)) + 1
        IF d = 1 THEN
            Oprint "`@  The clerk pops his knuckles loudly." + ret$
        END IF
        IF d = 2 THEN
            Oprint "`@  The song on the store's sound system changes." + ret$
        END IF
        IF d = 3 THEN
            IF o(1) >= 0 THEN
                Oprint "`@  The clerk looks at you quickly, then turns away." + ret$
            ELSE
                Oprint "`@  The clerk mumbles something as he reads a section of the newspaper." + ret$
            END IF
        END IF
        DoRandomFeature = 1
        EXIT FUNCTION
    END IF

    IF lo = 8 THEN
        ClearLine
        d = INT(3 * RND(1)) + 1
        IF d = 1 THEN
            Oprint "`@  The police mumble something among themselves, as if getting restless." + ret$
        END IF
        IF d = 2 THEN
            Oprint "`@  You adjust the flow of your oxygen equipment as you stand here." + ret$
        END IF
        IF d = 3 THEN
            Oprint "`@  On of the policemen shoots a quick glance at you." + ret$
        END IF
        DoRandomFeature = 1
        EXIT FUNCTION
    END IF

    IF lo = 10 THEN
        d = INT(4 * RND(1)) + 1
        IF d = 1 THEN
            ClearLine
            Oprint "`@  A car honks as it drives past the store headed south." + ret$
            DoRandomFeature = 1
            EXIT FUNCTION
        END IF
        IF d = 2 THEN
            ClearLine
            Oprint "`@  A car honks as it drives past the store headed east." + ret$
            DoRandomFeature = 1
            EXIT FUNCTION
        END IF
    END IF

END FUNCTION

SUB DoTokenize (a$)

IF INSTR(a$, "{") = 0 OR TokenCount >= 100 THEN EXIT SUB

Begin = 1
d1 = INSTR(Begin, a$, "{")

DO WHILE TokenCount < 100 AND d1 > 0

d2 = INSTR(d1 + 1, a$, "}")

IF d1 > 0 AND d2 > 0 THEN
    TokenCount = TokenCount + 1
    Token$(TokenCount) = UCASE$(LTRIM$(RTRIM$(RemoveColor$(MID$(a$, d1 + 1, d2 - d1 - 1)))))
    IF LEN(Token$(TokenCount)) > 20 THEN TokenCount = TokenCount - 1
    Begin = d2 + 1
END IF
d1 = INSTR(Begin, a$, "{")
LOOP

END SUB

SUB DoUnToken

TokenCount = 0
FOR x = 1 TO 100: Token$(x) = "": NEXT x

END SUB

FUNCTION FixQuote$ (a$)

DO WHILE INSTR(a$, "\")
    n = INSTR(a$, "\")
    MID$(a$, n, 1) = CHR$(34)
LOOP

FixQuote$ = a$

END FUNCTION

SUB GameOver

ScoreToggle = 0: StatLine

Oprint "```4  GAME OVER      "

Oprint "`0YOUR FINAL SCORE IS: `%" + LTRIM$(STR$(Score)) + " `0of `%" + MaxScore$ + "`0." + ret$
IF SoundOn <> 0 THEN PLAY "mnt120l43mbo2gcgcgcgcgcgc;fcfcfcfcfcfc;ecececececec;dcdcdcdcdcdc;cccccccccccc"
PressEnter
PRINT
PRINT
VIEW PRINT 1 TO 24
COLOR 7, 0
CLS

END

END SUB

FUNCTION GetInput$

m$ = ""

Beam:
RandomFeature = 25 '25 seconds between "possibilities"

t$ = StripConcat$(RTRIM$(LTRIM$(KbIn$(MaxInputLen, m$, "7", 1))))

IF RandomFeature = -1 THEN 'INPUT return executed a random feature
    Oprint InLine$
    m$ = t$
    GOTO Beam
END IF

GetInput$ = t$

RandomFeature = 0

END FUNCTION

DEFINT A-Z
FUNCTION GetPromptLine$ (x)
a$ = "`d`0" + STRING$(80, " ")
IF x = 1 OR x = 3 THEN
    a$ = "`a`% HELP`7:`0Instructions `} `%QUIT`7:`0Exit Game `} `%SAVE`7:`0Save Your Place `} `%LOAD`7:`0Restore Game  `7`h"
END IF
IF x = 2 THEN
    a$ = "`a`! Don't like the music/sound effects? Start the game with `%BREATH /Q`! to disable!  "
END IF
IF x = 5 THEN
    a$ = "`a`% Wannna play my awesome multi-player game `0LUNATIX`% online? Telnet to `!bbs.cxo.com `7`h"
END IF
IF x = 4 THEN
    a$ = "`a`% Are you a `$BBS SysOp`%? Check out `0www.cxo.com/~wyndo `%for N-E-Ware BBS Door Games! `7`h"
END IF
GetPromptLine$ = a$
END FUNCTION

DEFSNG A-Z
FUNCTION GetWord$ (a$, DoNothing%)

Oprint a$
t$ = StripConcat$(RTRIM$(LTRIM$(KbIn$(MaxItemInputLen, m$, "0", 2))))

IF DoNothing% <> 0 AND LEN(t$) = 0 THEN
    Oprint "`7UHM... NEVERMIND..."
END IF

Oprint ret$
GetWord$ = t$

END FUNCTION

FUNCTION IsItem% (a$)

g = 0

FOR x = 1 TO MaxItems
    FOR y = 1 TO 4
        IF o(x) = 0 AND INSTR(UCASE$(a$), Uo$(x, y)) THEN g = x
    NEXT y
NEXT x

IsItem = g

END FUNCTION

DEFINT A-Z
FUNCTION IsVerb (t$, b$)
a$ = UCASE$(t$): b$ = UCASE$(b$)

IF b$ = "GET" THEN
    IF LEFT$(a$, 4) = "GET " OR LEFT$(a$, 4) = "TAKE" OR LEFT$(a$, 7) = "PICK UP" OR LEFT$(a$, 2) = "G " OR LEFT$(a$, 5) = "ACQUI" OR LEFT$(a$, 4) = "ACQ " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "DROP" THEN
    IF LEFT$(a$, 5) = "DROP " OR LEFT$(a$, 4) = "LEAV" OR LEFT$(a$, 5) = "LOSE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "NORTH" THEN
    IF LEFT$(a$, 4) = "GO N" OR a$ = "N" OR a$ = "NOR" OR a$ = "NORTH" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "SOUTH" THEN
    IF LEFT$(a$, 4) = "GO S" OR a$ = "S" OR a$ = "SOU" OR a$ = "SOUTH" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "EAST" THEN
    IF LEFT$(a$, 4) = "GO E" OR a$ = "E" OR a$ = "EAS" OR a$ = "EAST" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "WEST" THEN
    IF LEFT$(a$, 4) = "GO W" OR a$ = "W" OR a$ = "WES" OR a$ = "WEST" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "TALK" THEN
    IF LEFT$(a$, 4) = "ASK " OR LEFT$(a$, 5) = "TALK " OR LEFT$(a$, 5) = "SPEAK" OR LEFT$(a$, 5) = "WARN " OR LEFT$(a$, 5) = "TELL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "GIVE" THEN
    IF LEFT$(a$, 5) = "GIVE " OR LEFT$(a$, 5) = "TRADE" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "SAVE" THEN
    IF a$ = "SAVE" OR a$ = "STORE" OR a$ = "STOR" OR a$ = "SAVE GAME" OR LEFT$(a$, 9) = "SAVE PLAC" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "LOAD" THEN
    IF a$ = "LOAD" OR a$ = "RESTORE" OR a$ = "RESTOR" OR a$ = "RESTORE GAME" OR LEFT$(a$, 12) = "RESTORE PLAC" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "QUIT" THEN
    IF a$ = "Q" OR a$ = "EXIT" OR a$ = "QUIT" OR a$ = "STOP" OR a$ = "END" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "LOOK" THEN
    IF LEFT$(a$, 7) = "SEARCH " OR LEFT$(a$, 2) = "X " OR LEFT$(a$, 5) = "LOOK " OR LEFT$(a$, 4) = "EXAM" OR LEFT$(a$, 5) = "READ " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "OPEN" THEN
    IF LEFT$(a$, 5) = "OPEN " OR LEFT$(a$, 5) = "PUSH " OR LEFT$(a$, 5) = "PULL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "MOVE" THEN
    IF LEFT$(a$, 5) = "MOVE " OR LEFT$(a$, 5) = "PUSH " OR LEFT$(a$, 5) = "PULL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "UNLOCK" THEN
    IF LEFT$(a$, 5) = "UNLOC" OR LEFT$(a$, 6) = "UNFAST" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "INSERT" THEN
    IF LEFT$(a$, 5) = "INSER" OR LEFT$(a$, 4) = "PUT " OR LEFT$(a$, 4) = "USE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "POUR" THEN
    IF LEFT$(a$, 5) = "POUR " OR LEFT$(a$, 4) = "PUT " OR LEFT$(a$, 4) = "USE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "JUMP" THEN
    IF LEFT$(a$, 4) = "JUMP" OR LEFT$(a$, 4) = "LEAP" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "SCORE" THEN
    IF a$ = "SCORE" OR a$ = "POINTS" OR a$ = "POINT" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "DIG" THEN
    IF a$ = "DIG" OR LEFT$(a$, 4) = "DIG " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "HELP" THEN
   IF a$ = "HELP" THEN
       IsVerb = 1: EXIT FUNCTION
   END IF
   IsVerb = 0: EXIT FUNCTION
END IF

IF b$ = "CLIMB" THEN
    IF LEFT$(a$, 6) = "CLIMB " OR LEFT$(a$, 6) = "GO UP " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
    IsVerb = 0: EXIT FUNCTION
END IF

END FUNCTION

DEFSNG A-Z
FUNCTION MakeScore$
   
    n$ = "": P$ = LTRIM$(RTRIM$(STR$(Score))): IF LEN(P$) < 2 THEN n$ = " "
    e$ = "`0CURRENT SCORE IS: `%" + P$ + " `0of `%" + MaxScore$ + "  " + n$

    MakeScore$ = e$

END FUNCTION

FUNCTION MakeTime$

ot$ = "AM"
c$ = LEFT$(TIME$, 5)
d = VAL(MID$(c$, 1))
m = d
IF d = 0 THEN m = 12
IF m > 12 THEN m = m - 12: ot$ = "PM"
c$ = LTRIM$(STR$(m)) + ":" + MID$(c$, 4, 2) + " " + ot$
IF LEN(c$) < 8 THEN c$ = c$ + " "

MakeTime$ = c$

END FUNCTION

FUNCTION MciCode$ (a$)

c$ = "": Cod = 0
FOR x = 1 TO LEN(a$)
    b$ = UCASE$(MID$(a$, x, 1)): k$ = MID$(a$, x, 1)
    IF b$ = "|" AND Cod = 0 THEN Cod = 1: GOTO vax
    IF Cod = 1 THEN
        IF b$ = "A" THEN c$ = c$ + Alias$
        IF b$ = "B" AND LunType = 1 THEN c$ = c$ + Clinic$
        IF b$ = "B" AND LunType = 2 THEN c$ = c$ + LTRIM$(STR$(strength))
        IF b$ = "C" THEN c$ = c$ + LTRIM$(STR$(igmaward))
        IF b$ = "D" AND LunType = 1 THEN c$ = c$ + Guard$
        IF b$ = "D" AND LunType = 2 THEN c$ = c$ + LTRIM$(STR$(charm))
        IF b$ = "E" THEN c$ = c$ + LTRIM$(STR$(Exper))
        IF b$ = "F" THEN c$ = c$ + LTRIM$(STR$(Money))
        IF b$ = "G" THEN c$ = c$ + LTRIM$(STR$(Stash))
        IF b$ = "H" THEN c$ = c$ + LTRIM$(STR$(Level))
        IF b$ = "K" THEN c$ = c$ + LTRIM$(STR$(ClosFights))
        IF b$ = "L" THEN c$ = c$ + LTRIM$(STR$(Trips))
        IF b$ = "M" AND LunType = 1 THEN c$ = c$ + "5.XX"
        IF b$ = "M" AND LunType = 2 THEN c$ = c$ + "1.XX"
        'IF b$ = "N" THEN c$ = c$ + stringy$(1)
        'IF b$ = "O" THEN c$ = c$ + stringy$(2)
        'IF b$ = "P" THEN c$ = c$ + stringy$(3)
        IF b$ = "Q" THEN c$ = c$ + LTRIM$(STR$(Age))
        IF b$ = "X" AND LunType = 2 THEN c$ = c$ + LTRIM$(STR$(Gems))
        IF b$ = "Y" THEN
            a1$ = DATE$
            c$ = c$ + MID$(a1$, 1, 2) + "/" + MID$(a1$, 4, 2) + "/" + MID$(a1$, 9, 2)
        END IF
        IF b$ = "Z" THEN
            a1$ = TIME$: ampm$ = "AM"
            b1$ = LTRIM$(RTRIM$(STR$(VAL(MID$(a1$, 1, 2)))))
            IF VAL(b1$) > 12 THEN
                b1$ = LTRIM$(RTRIM$(STR$(VAL(b1$) - 12)))
                IF VAL(b1$) = 0 THEN b1$ = "12"
                ampm$ = "PM"
            END IF
            b2$ = MID$(a1$, 4, 2)
            c$ = c$ + b1$ + ":" + b2$ + " " + ampm$
        END IF
        'IF b$ = "T" THEN c$ = c$ + stringy$(4)
        'IF b$ = "U" THEN c$ = c$ + stringy$(5)
        'IF b$ = "V" THEN c$ = c$ + stringy$(6)
        IF b$ = "1" THEN c$ = c$ + "square"
        IF b$ = "2" THEN c$ = c$ + "silver"
        IF b$ = "3" THEN c$ = c$ + "table"
        IF b$ = "4" THEN c$ = c$ + "Anna"
        IF b$ = "5" THEN c$ = c$ + "perfect"
        'IF b$ = "!" THEN c$ = c$ + LTRIM$(STR$(Valy(1)))
        'IF b$ = "@" THEN c$ = c$ + LTRIM$(STR$(Valy(2)))
        'IF b$ = "#" THEN c$ = c$ + LTRIM$(STR$(Valy(3)))
        'IF b$ = "$" THEN c$ = c$ + LTRIM$(STR$(Valy(4)))
        'IF b$ = "%" THEN c$ = c$ + LTRIM$(STR$(Valy(5)))
        'IF b$ = "^" THEN c$ = c$ + LTRIM$(STR$(Valy(6)))
        'IF b$ = "&" THEN c$ = c$ + LTRIM$(STR$(Valy(7)))
        'IF b$ = "*" THEN c$ = c$ + LTRIM$(STR$(Valy(8)))
        'IF b$ = "(" THEN c$ = c$ + LTRIM$(STR$(Valy(9)))
        Cod = 0
        GOTO vax
    END IF
    c$ = c$ + k$
vax: NEXT x
MciCode$ = c$
END FUNCTION

FUNCTION NounItem% (a$, e%) 'which ITEM Number?

g = 0
FOR y = 1 TO 4
    f$ = UCASE$(Uo$(e%, y))
    IF INSTR(UCASE$(a$), f$) <> 0 THEN g = 1
NEXT y

NounItem = g

END FUNCTION

SUB Ocls
    Oprint CHR$(27) + "[2J"
END SUB

SUB Oprint (a$)

DoTokenize (a$)'This added to create "TOKENS" out of key words in the text!

Esc = 0
Ccode = 0
Yuk$ = ""
Didit = 0

PPRINT: FOR xz = 1 TO LEN(a$)
    hot$ = MID$(a$, xz, 1)
    GOSUB Opt
NEXT xz

IF Didit <> 0 THEN
    OldBg = 0: OldFg = 3: Flash = 0
    COLOR 3, 0
    Didit = 0
END IF
EXIT SUB

Opt:
IF hot$ = CHR$(8) THEN ntt = POS(n) - 1: IF ntt < 1 THEN ntt = 1
IF hot$ = CHR$(8) THEN LOCATE CSRLIN, ntt: RETURN
IF hot$ = CHR$(27) THEN Esc = 1: Yuk$ = CHR$(27): RETURN
IF Esc THEN IF (hot$ >= "A" AND hot$ <= "Z") OR (hot$ >= "a" AND hot$ <= "z") THEN GOSUB ANSI: Esc = 0: Yuk$ = "": RETURN
IF Esc THEN Yuk$ = Yuk$ + hot$: RETURN
IF Ccode THEN
    Ccode = 0
    IF hot$ = "}" THEN COLOR 0 + Flash: OldFg = 0
    IF hot$ = "1" THEN COLOR 1 + Flash: OldFg = 1
    IF hot$ = "2" THEN COLOR 2 + Flash: OldFg = 2
    IF hot$ = "3" THEN COLOR 3 + Flash: OldFg = 3
    IF hot$ = "4" THEN COLOR 4 + Flash: OldFg = 4
    IF hot$ = "5" THEN COLOR 5 + Flash: OldFg = 5
    IF hot$ = "6" THEN COLOR 6 + Flash: OldFg = 6
    IF hot$ = "7" THEN COLOR 7 + Flash: OldFg = 7
    IF hot$ = "8" THEN COLOR 8 + Flash: OldFg = 8
    IF hot$ = "9" THEN COLOR 9 + Flash: OldFg = 9
    IF hot$ = "0" THEN COLOR 10 + Flash: OldFg = 10
    IF hot$ = "!" THEN COLOR 11 + Flash: OldFg = 11
    IF hot$ = "@" THEN COLOR 12 + Flash: OldFg = 12
    IF hot$ = "#" THEN COLOR 13 + Flash: OldFg = 13
    IF hot$ = "$" THEN COLOR 14 + Flash: OldFg = 14
    IF hot$ = "%" THEN COLOR 15 + Flash: OldFg = 15
    IF hot$ = "^" THEN COLOR 15 + Flash: OldFg = 15
    IF hot$ = "a" THEN COLOR , 1: OldBg = 1: Didit = 1
    IF hot$ = "b" THEN COLOR , 2: OldBg = 2: Didit = 1
    IF hot$ = "c" THEN COLOR , 3: OldBg = 3: Didit = 1
    IF hot$ = "d" THEN COLOR , 4: OldBg = 4: Didit = 1
    IF hot$ = "e" THEN COLOR , 5: OldBg = 5: Didit = 1
    IF hot$ = "f" THEN COLOR , 6: OldBg = 6: Didit = 1
    IF hot$ = "g" THEN COLOR , 7: OldBg = 7: Didit = 1
    IF hot$ = "h" THEN COLOR , 0: OldBg = 0: Didit = 1
    IF hot$ = "&" THEN '** produce a RANDOM foreground color!
        c = INT(15 * RND(1)) + 1
        COLOR c + Flash: OldFg = c
    END IF
    IF hot$ = "i" THEN '** produce a RANDOM background color!
        c = INT(8 * RND(1))
        COLOR , c: OldBg = c
        Didit = 1
    END IF
    IF hot$ = "`" THEN '** toggle flashing on & off
        IF Flash = 16 THEN Flash = 0 ELSE Flash = 16
        COLOR OldFg + Flash
        : Didit = 1
    END IF
    IF hot$ = "(" THEN '** force flashing off regardless or prior state
        Flash = 0
        COLOR OldFg
    END IF
    RETURN
END IF
IF hot$ = "`" THEN Ccode = 1: Yuk$ = "`": RETURN
IF hot$ = CHR$(10) OR hot$ = "{" OR hot$ = "}" THEN RETURN'Ignore Line Feed or TOKEN char.

PRINT hot$;
RETURN

'****************************************************************************
'  Ansi-Translation routines: call to print ANSI escape-coded strings.
'****************************************************************************

ANSI:
Esc = 0

IF hot$ <> "m" THEN GOTO NotM

p1 = -1: p2 = -1: p3 = -1: p4 = -1
p1 = VAL(MID$(Yuk$, 3, 2))
'nul1 = 0: nul2 = 0: nul3 = 0
nul1 = INSTR(Yuk$, ";")
IF nul1 < 1 THEN GOTO Tzer ELSE p2 = VAL(MID$(Yuk$, nul1 + 1, 2))
nul2 = INSTR(nul1 + 1, Yuk$, ";")
IF nul2 < 1 THEN GOTO Tzer ELSE p3 = VAL(MID$(Yuk$, nul2 + 1, 2))
nul3 = INSTR(nul2 + 1, Yuk$, ";")
IF nul3 > 0 THEN p4 = VAL(MID$(Yuk$, nul3 + 1, 2))
Tzer:

n = 0: t = 0
x1 = -1: x2 = -1: x3 = -1: x4 = OldX4

IF p1 = 0 OR p2 = 0 OR p3 = 0 OR p4 = 0 THEN Oldx1 = 0: OldX2 = 37: OldX3 = 40: OldX4 = 0: x4 = 0
IF p1 = 5 OR p2 = 5 OR p3 = 5 OR p4 = 5 THEN OldX4 = 1: x4 = 1

IF p1 = 1 THEN x1 = p1 ELSE IF p1 >= 30 AND p1 < 40 THEN x2 = p1 ELSE IF p1 >= 40 THEN x3 = p1
IF p2 = 1 THEN x1 = p2 ELSE IF p2 >= 30 AND p2 < 40 THEN x2 = p2 ELSE IF p2 >= 40 THEN x3 = p2
IF p3 = 1 THEN x1 = p3 ELSE IF p3 >= 30 AND p3 < 40 THEN x2 = p3 ELSE IF p3 >= 40 THEN x3 = p3
IF p4 = 1 THEN x1 = p4 ELSE IF p4 >= 30 AND p4 < 40 THEN x2 = p4 ELSE IF p4 >= 40 THEN x3 = p4

IF x2 = -1 THEN x2 = OldX2
IF x3 = -1 THEN x3 = OldX3
IF x1 = -1 THEN x1 = Oldx1

t = TransColor((x2 - 30) + (x1 * 10))
IF x4 = 1 THEN t = t + 16
n = TransColor(x3 - 40)

grk:
IF x3 >= 0 AND x2 >= 0 THEN COLOR t, n: OldFg = t: OldBg = n: GOTO Gif
IF x2 >= 0 AND x3 < 0 THEN COLOR t: OldFg = t: GOTO Gif
IF x3 >= 0 AND x2 < 0 THEN COLOR , n: OldBg = n

Gif:
Oldx1 = x1
OldX2 = x2
OldX3 = x3

Yuk$ = "": RETURN

NotM:
IF UCASE$(hot$) <> "F" AND UCASE$(hot$) <> "H" THEN GOTO NotF

IF Yuk$ = CHR$(27) + "[" THEN
    x2 = 1: x1 = 1
    GOTO Petty
END IF
IF INSTR(Yuk$, "?") > 0 THEN
    x2 = 1
    x1 = VAL(MID$(Yuk$, INSTR(2, Yuk$, "?") + 1, 2))
    GOTO Petty
END IF
IF INSTR(Yuk$, ";") = 0 THEN
    x2 = 1: x1 = VAL(MID$(Yuk$, 3, 2))
    GOTO Petty
END IF

x1 = VAL(MID$(Yuk$, 3, 2))
x2 = VAL(MID$(Yuk$, INSTR(4, Yuk$, ";") + 1, 2))

Petty:
IF x1 > 24 THEN x1 = 24 ELSE IF x1 < 1 THEN x1 = 1
IF x2 > 80 THEN x2 = 80 ELSE IF x2 < 1 THEN x2 = 1
LOCATE x1, x2
RETURN

NotF:
IF hot$ = "A" OR hot$ = "B" OR hot$ = "C" OR hot$ = "D" THEN v = VAL(MID$(Yuk$, INSTR(Yuk$, "[") + 1, 2)) ELSE GOTO NotN
IF v < 1 THEN v = 1
a = CSRLIN: b = POS(n)

IF hot$ = "A" THEN
    IF a - v < 1 THEN LOCATE 1, b: RETURN
    LOCATE a - v, b: RETURN
END IF
IF hot$ = "B" THEN
    IF a + v > 24 THEN LOCATE 24, b: RETURN
    LOCATE a + v, b: RETURN
END IF
IF hot$ = "C" THEN
    IF b + v > 80 THEN LOCATE a, 80: RETURN
    LOCATE a, b + v: RETURN
END IF
IF hot$ = "D" THEN
    IF b - v < 1 THEN LOCATE a, 1: RETURN
    LOCATE a, b - v: RETURN
END IF
RETURN

NotN:
IF hot$ <> "K" THEN GOTO NotK
a1 = CSRLIN: a2 = POS(0): d = 80 - a2: IF d > 0 THEN PRINT STRING$(d, " ");
Yuk$ = "": LOCATE a1, a2: RETURN

NotK:
IF hot$ = "J" THEN COLOR 7, 0: CLS : StatLine: Yuk$ = "": RETURN
IF hot$ = "s" THEN Savedxx = POS(0): Savedyy = CSRLIN: RETURN
IF hot$ = "u" THEN LOCATE Savedyy, Savedxx: RETURN

Yuk$ = "": RETURN

'****** Notes about the OPRINT procedure:

'** This nifty bit of code has been over 2 years in the making. It started off
'** small but has grown to not only allow COLOR codes (`1, `2, `3 etc) but
'** ALSO ansi support. So this routine could be used to print ANSI-code
'** strings as well! It's probably not "optimized" as well as it could be,
'** but it works! It's main purpose is to simplify the QuickBASIC printing
'** of colors. The code "COLOR 14: print "TEST ";:COLOR 9:print "COLORS!";
'** could be simplified as "Oprint "`$TEST `9COLORS!" -- in fact, there are
'** color codes for all foreground, background, and flashing so entire ANSI
'** pictures can be "emulated" in color codes -- but it has been modified to
'** also accept ANSI-encoded strings as well. :)

END SUB

SUB Paus
IF nolag = 1 THEN EXIT SUB
J! = TIMER
DO WHILE ABS(TIMER - J) < .001: LOOP
END SUB

SUB PressEnter

FOR x = 1 TO 16: Nul$ = INKEY$: NEXT x 'Waste buffered keystrokes

Oprint "                                                     `8...`5...`#... `9Press ENTER "
m = 0
virk:
a$ = INKEY$
IF a$ = CHR$(13) THEN
    Oprint STRING$(80, 8)
    Oprint STRING$(79, " ")
    Oprint STRING$(80, 8)
    EXIT SUB
END IF
Paus
IF m = 0 THEN Oprint "`%" + CHR$(8)
IF m = 1 THEN Oprint "`#o" + CHR$(8)
IF m = 2 THEN Oprint "`5O" + CHR$(8)
m = m + 1: IF m > 2 THEN m = 0

GOTO virk
END SUB

DEFINT A-Z
SUB PrintItem (g, a$)

    IF g > 0 THEN
        Oprint "`6, "
    END IF
    IF POS(n) > 65 THEN
        Oprint ret$ + "          "
    END IF
    Oprint "`#" + a$

END SUB

SUB PromptLine (x)

bt$ = GetPromptLine$(x)
y = CSRLIN
x = POS(n)
f1 = OldFg
f2 = OldBg
F3 = Flash
LOCATE 25, 1
Oprint bt$
COLOR f1 + F3, f2: OldFg = f1: OldBg = f2: Flash = F3
LOCATE y, x

END SUB

DEFSNG A-Z
FUNCTION RemoveColor$ (te$)

a$ = te$ + " "
FOR x = 1 TO LEN(te$)
    IF MID$(te$, x, 1) = "`" THEN
        MID$(a$, x, 1) = "*": MID$(a$, x + 1, 1) = "*"
    END IF
NEXT x
rx$ = ""
FOR x = 1 TO LEN(a$)
    IF MID$(a$, x, 1) <> "*" THEN rx$ = rx$ + MID$(a$, x, 1)
NEXT x
RemoveColor$ = rx$

END FUNCTION

SUB SetStandardErrorTrap

  ON ERROR GOTO AnError
  ErrorFound = 0

END SUB

SUB ShowDirsAvail

FOR x = 1 TO 4: CanGo(x) = Dir(lo, x): NEXT x
FOR x = 1 TO MaxLDir'Now see if there are any LIMITS imposed here
    IF lo = LDir(x, 1) AND Special(LDir(x, 3)) = 0 THEN CanGo(LDir(x, 2)) = 0
NEXT x

Oprint "`5 Directions Available: "
g = 0
IF CanGo(1) <> 0 THEN
    Oprint "`#North": g = 1
END IF
IF CanGo(2) <> 0 THEN
    IF g = 1 THEN
        Oprint "`6, "
    END IF
    Oprint "`#South": g = 1
END IF
IF CanGo(3) <> 0 THEN
    IF g = 1 THEN
        Oprint "`6, "
    END IF
    Oprint "`#East": g = 1
END IF
IF CanGo(4) <> 0 THEN
    IF g = 1 THEN
        Oprint "`6, "
    END IF
    Oprint "`#West": g = 1
END IF
IF g = 0 THEN Oprint "`9Nowhere!"
Oprint ret$
END SUB

SUB ShowFile (a$, P$)

OPEN a$ FOR INPUT SHARED AS #1

IF LEN(P$) THEN GoodRead = 0 ELSE GoodRead = 1
Lag = 0

ShowLoop: IF EOF(1) THEN GOTO OutFile
LINE INPUT #1, b$: b$ = LTRIM$(RTRIM$(b$))

IF GoodRead = 0 THEN
    IF LEFT$(UCASE$(b$), LEN(P$)) = UCASE$(P$) THEN GoodRead = 1: GOTO ShowLoop
    GOTO ShowLoop
END IF

IF LEFT$(b$, 1) = "/" THEN GOTO ControlCode
IF LEFT$(b$, 1) = ";" THEN GOTO ShowLoop

Oprint b$
IF RIGHT$(b$, 1) <> "`" THEN Oprint ret$
IF Lag = 1 THEN Paus
GOTO ShowLoop

ControlCode:

IF LEFT$(UCASE$(b$), 6) = "/ABORT" THEN GOTO OutFile
IF LEFT$(UCASE$(b$), 6) = "/PAUS:" THEN
    CallPaus b$
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 5) = "/VIEW" THEN
    CallView b$
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 8) = "/PALETTE" THEN
    CallPalette b$
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 8) = "/ANYQUIT" THEN
    IF CallAnyQuit = 1 THEN GOTO OutFile
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 6) = "/CLEAR" THEN
    Ocls
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 6) = "/ENTER" THEN
    PressEnter
    GOTO ShowLoop
END IF
IF LEFT$(UCASE$(b$), 4) = "/LAG" THEN
    IF INSTR(UCASE$(b$), "ON") THEN Lag = 1
    IF INSTR(UCASE$(b$), "ONF") THEN Lag = 0
    GOTO ShowLoop
END IF

GOTO ShowLoop

OutFile: CLOSE #1

END SUB

SUB ShowInventory

g = 0 'How MANY items were here!!!
Oprint "`2 You're carrying: "
FOR x = 1 TO MaxItems
    IF o(x) = 0 THEN 'The item *IS* at this location!
        IF g > 0 THEN
            Oprint "`6, "
        END IF
        IF POS(n) > 65 THEN
            Oprint ret$ + "                  "
        END IF
        g = g + 1
        Oprint "`0" + oc$(x)
    END IF
NEXT x
IF g = 0 THEN
    Oprint "`9Nothing!"
END IF
Oprint ret$

END SUB

DEFINT G
SUB ShowItemsHere

g = 0 'How MANY items were here!!!
Oprint "`5 You see: "
FOR x = 1 TO MaxItems
    IF o(x) = lo THEN 'The item *IS* at this location!
        PrintItem g, oc$(x): g = g + 1
    END IF
NEXT x
'*** Next show OTHER items that might be here but can't be picked up ****
IF lo = 10 THEN PrintItem g, "Mazda 323": g = g + 1
IF lo = 9 THEN PrintItem g, "Clerk": g = g + 1
IF lo = 3 THEN PrintItem g, "{Chair}": g = g + 1
IF lo = 3 THEN PrintItem g, "Chair": g = g + 1 '*there are TWO chairs here.
IF lo = 2 THEN PrintItem g, "{Pott}ed {Plant}": g = g + 1
IF lo = 2 THEN PrintItem g, "Potted Plant": g = g + 1

'*** And the conclusion *************************************************
IF g = 0 THEN
    Oprint "`9Nothing of interest"
END IF
Oprint ret$
END SUB

DEFSNG G
SUB ShowRoom (k%, d%)

Room = k%: OldRoom = d%
DoUnToken 'Erase existing token list. New tokens are built from brace {} keys

'IF ScoreToggle <= 1 AND Room <> OldRoom THEN '(0 to 1 is descript)
'    ScoreToggle = 0
'END IF

IF Room = 1 THEN
    TagLine$ = "`}======`$Inside an Empty House"
    Oprint "`3" + ret$
    Oprint "`3 You are standing inside the living {room} of a totally empty {house}. The {floor}" + ret$
    Oprint "`3 is bare {wood} and your footsteps cause a soft echo. To the west is a narrow" + ret$
    Oprint FixQuote$("`3 {door}. An open path to the north is blocked by yellow {plastic} \{danger}\ {ribbon}s." + ret$)
END IF

IF Room = 2 THEN
    TagLine$ = "`}==`$On the Porch of Red House"
    Oprint "`3" + ret$
    IF Special(4) = 0 THEN
        Oprint "`3    You are standing on the small {cement} {porch} of a small red {house}. A {potted}" + ret$
        Oprint "`3 {plant} is on either side of it. To the west is a {door} which is currently" + ret$
        Oprint "`3 closed. A {fence} is to the north and east." + ret$
    ELSE
        Oprint "`3    You are standing on the small {cement} {porch} of a small red {house}. A {potted}" + ret$
        Oprint "`3 {plant} is on either side of it. To the west is an open {door}way. A {fence} is to" + ret$
        Oprint "`3 the north and east." + ret$
    END IF
END IF

IF Room = 3 THEN
    Special(13) = 0
    TagLine$ = "`}=`$On the Porch of Gray House"
    Oprint "`3" + ret$
    IF OldLo = 7 THEN
        Oprint "`3    You approach the {house} and step up onto the {porch} which is enclosed in" + ret$
        Oprint "`3 a chest-high {green} {wooden} {rail}ing. Wooden {pole}s rise to the overhanging" + ret$
        Oprint "`3 {roof}, and two {wood}en {chair}s sit opposite each other on the wooden {floor}." + ret$
    END IF
    IF OldLo <> 7 THEN
        Oprint "`3    You are standing on the front {porch} of a gray {brick} {house}. A little {mail}{box}" + ret$
        Oprint "`3 is on the {wall} beside the {door}. The door itself is large and {ornament}ed" + ret$
        Oprint "`3 and painted a dark shade of {green}. The porch is enclosed in a chest-high green" + ret$
        Oprint "`3 wooden {rail}ing, and two {wood}en {chair}s sit opposite each on the {deck}." + ret$
    END IF
END IF

IF Room = 4 THEN
    TagLine$ = "`}`$Inside the Gray Brick House"
    Oprint "`3" + ret$
    IF o(4) <> 0 THEN '*if they're NOT holding the Bandana
        Oprint "`3    You enter the house and only catch a glimpse of the cluttered room before" + ret$
        Oprint "`3 one of the angry residents unloads a round of shells in your chest. Before" + ret$
        Oprint "`3 you even have the opportunity to be scared, you're dead." + ret$ + ret$
        GameOver
    END IF
    Oprint "`3    You are standing inside a cluttered living {room}. Two mismatched {sofa}s (one" + ret$
    Oprint "`3 a {vinyl} {maroon} and the other a tattered {blue}) are supporting a rough-looking" + ret$
    Oprint "`3 array of young {men} and {women}, all wearing black bandanas. Empty {bags} of {chip}s" + ret$
    Oprint "`3 and half-crushed {soda} {cans} are on the {coffee} {table} and the {floor}." + ret$
    IF OldLo = 3 THEN
        Oprint "`3    The cast of questionable Breath Pirates regard you with wonder, and you" + ret$
        Oprint "`3 smile as you hold your bandana up for them to see." + ret$
    END IF
END IF

IF Room = 5 THEN
    TagLine$ = "`}=`$Inside a Small Supply Room"
    Oprint "`3" + ret$
    Oprint "`3    You are standing inside a small supply {room}. It's predominantly bare," + ret$
    Oprint "`3 except for a {gray} {metal} {shelf} {rack} against the west wall. A brown {stain} in" + ret$
    Oprint "`3 the shape of a {rectang}le is on the {floor}, as if a freezer once occupied" + ret$
    Oprint "`3 this room." + ret$
END IF

IF Room = 6 THEN
    TagLine$ = "`}===`$Walking along a Sidewalk"
    Oprint "`3" + ret$
    IF OldRoom = 10 THEN
        Oprint "`3    The {side}{walk} ends at a {street} that goes east and west. You walk across" + ret$
        Oprint "`3 the street to a {sidewalk} that runs parallel to it on the other side." + ret$
    ELSE
        Oprint "`3    You're standing on a {side}{walk} north of a street and south of a red brick" + ret$
        Oprint "`3 {house}. On the other side of the {street}, another {sidewalk} leads south through" + ret$
        Oprint "`3 an open {gate}." + ret$
    END IF
    Oprint "`3    The area is dimly lit by {light}s atop tall wooden {pole}s which are" + ret$
    Oprint "`3 {ornament}ed by textured {brass} {plate}s. The {sun} is a near-invisible circular" + ret$
    Oprint "`3 outline in the {sky}." + ret$
    IF OldRoom = 10 THEN
        Oprint "`3    A {gravel} {path} leads north to a red {brick} {house}." + ret$
    END IF
END IF

IF Room = 7 THEN
    TagLine$ = "`}==============`$On a Sidewalk"
    Oprint "`3" + ret$
    Oprint "`3    You're standing on the {side}{walk} just north of a {street} that goes east and" + ret$
    Oprint "`3 west. To the north, a {brick}-lined {path} leads to the front {step}s of a {gray}" + ret$
    Oprint "`3 brick {house}." + ret$
END IF

IF Room = 8 THEN
    TagLine$ = "`}=====`$East end of the Street"
    Oprint "`3" + ret$
    IF o(4) = 0 THEN '*if they're holding the Bandana
        Oprint "`3    You approach a police barricade. As you get close, policemen begin to" + ret$
        Oprint "`3 shout among themselves `!IT'S ONE OF THEM `3and they open fire. You take" + ret$
        Oprint "`3 several shots in the chest and the force of it knocks you backward. Bleeding" + ret$
        Oprint "`3 and dying, you realize that this hasn't been the way you intended your life" + ret$
        Oprint "`3 to end. If only you had decided to jump off the bridge..." + ret$ + ret$
        GameOver
    END IF
    IF OldRoom = 7 THEN
        Oprint "`3    You approach a {police} {barricade}. {Squad} {cars} are angled to block the" + ret$
        Oprint "`3 east-bound traffic, if there was any. Several police{men} are crouched down" + ret$
        Oprint "`3 behind their {cars} with {rifle}s drawn, although they aren't aimed at you." + ret$
    ELSE
        Oprint "`3    You're standing on the {side}{walk} by a {police} {barricade} of {squad} {cars} that" + ret$
        Oprint "`3 blocks the {street} here. The police{men} are crouched behind their cars with" + ret$
        Oprint "`3 {rifle}s drawn, though not aimed at you." + ret$
    END IF
    Oprint "`3    Street {lamp}s hang off wooden {pole}s to help motorists and pedestrians" + ret$
    Oprint "`3 see their way through the mist-like {darkness}." + ret$
END IF

IF Room = 9 THEN
    TagLine$ = "`}=`$Inside a Convenience Store"
    Oprint "`3" + ret$
    IF OldRoom = 10 THEN
        Oprint "`3    You enter the {conven}ience {store} and notice right away that most everything" + ret$
        Oprint "`3 is out of stock. The {shelve}s are sparsly populated with a few {canned} {goods}" + ret$
        Oprint "`3 and {box}es of {crack}ers." + ret$
    END IF
    IF OldRoom = 5 THEN
        Oprint "`3    You step out of the small supply {room} back into the {conven}ience {store}. A" + ret$
        Oprint "`3 breeze blows through the open {door}, and you turn your oxygen down a little" + ret$
        Oprint "`3 to conserve and draw from the fresh air." + ret$
    END IF
    IF OldRoom <> 5 AND OldRoom <> 10 THEN
        Oprint "`3    You're standing in a small {conven}ience {store}. This place doesn't appear" + ret$
        Oprint "`3 to do as much business as you'd expect. Management hasn't felt the need" + ret$
        Oprint "`3 to order more {good}s in (seemingly) a long time." + ret$
    END IF
    IF o(1) >= 0 THEN 'if it's negative, it's "GONE" for good in this game
        Oprint "    A {clerk} is behind the {counter}. He smiles at you but doesn't say hello." + ret$
        Oprint " After a moment, he looks away and shrinks back into what appears to be total" + ret$
        Oprint " boredom." + ret$
    END IF
    IF o(1) < 0 THEN
        Oprint "    A {clerk} is here. He looks quite amazed as he reads the outlawwed" + ret$
        Oprint " {news}{paper}. He doesn't even appear to notice you." + ret$
    END IF
    IF Special(1) = 0 THEN
        Oprint "    To the north is a {door}way. As you approach it, the {clerk} coughs" + ret$
        Oprint " nervously and you instinctively step away." + ret$
    END IF
END IF

IF Room = 10 THEN
    TagLine$ = "`}`$Outside a Convenience Store"
    Oprint "`3" + ret$
    Oprint "`3    You're standing in the {parking} {lot} of a {conven}ience {store}, which sits" + ret$
    Oprint "`3 off the {highway} to the west. The highway itself makes a sharp bend to the" + ret$
    Oprint "`3 south, making it a perfect place for motorists to stop." + ret$
    IF Special(2) = 0 THEN
        Oprint "`3    To the north, you notice a high wooden {fence} with a closed {metal} {gate}" + ret$
        Oprint "`3 that blocks a {side}{walk} leading that direction." + ret$
    END IF
    IF Special(6) = 0 THEN
        Oprint "`3    Parked in the {grass} is an old {gray} {Mazda} {323}. It looks as though it was" + ret$
        Oprint "`3 just abandoned there." + ret$
    END IF
    IF Special(6) <> 0 THEN
        Oprint "`3    Parked in the {grass} is an old {gray} {Mazda} {323}. The {hood} is open." + ret$
    END IF
    IF o(1) >= 0 THEN
        Oprint "`3    To the west, the {door} of the {conven}ience {store} is propped open. Inside," + ret$
        Oprint "`3 a young {man} is sitting behind the {counter} with his {chin} in his {hands}. He looks" + ret$
        Oprint "`3 absoletely bored. To the east is the {highway}." + ret$
    END IF
END IF
IF Room = 11 THEN
    TagLine$ = "`}==`$Walking along the Highway "
    Oprint "`3" + ret$
    Oprint "`3    You're walking along the side of a {high}{way}. To the east is a {bridge}." + ret$
    IF OldRoom = 12 THEN
        Oprint "`3 You can't see what's over the {hill} to the west. A {sign} here proclaims that" + ret$
        Oprint "`3 you're now entering the {town} of Milford. Its Population is 1,246. You smile." + ret$
    END IF
    IF OldRoom = 10 THEN
        Oprint "`3 You notice a {sign} which proclaims that you're now leaving the {town} of Milford" + ret$
        Oprint "`3 and that you should have a nice day. You smile." + ret$
    END IF
END IF
IF Room = 12 THEN
    TagLine$ = "`}`$Walking along Webber Bridge "
    Oprint "`3" + ret$
    IF OldRoom = 0 THEN
        Oprint "`#    For instructions, type `@HELP`# from anywhere!" + ret$ + ret$
    END IF
    Oprint "`3    You're walking along a {side}{walk} on the {Webber} {Bridge} high above a {river}." + ret$
    Oprint "`3 {Traff}ic zips by in four {lanes} going both directions. To the north, you can" + ret$
    Oprint "`3 see the {lights} of the {city} lighting up the dark-gray day {sky}." + ret$
    IF OldRoom <> 0 THEN
        IF INT(3 * RND(1)) + 1 = 1 THEN
            Oprint "`3    You adjust your {breath}{mask} and reach down to turn the oxygen level" + ret$
            Oprint "`3 up a bit to help supplement the thin {air}." + ret$
        END IF
    END IF
    IF OldRoom = 0 THEN
        Oprint "`3    Hanging your head sadly, you climb up on a {rail} and gaze down into" + ret$
        Oprint "`3 the hazy, {vicious} {water} below. Your life as a librarian ends here, now. You" + ret$
        Oprint "`3 have chosen to give up on this doomed world. You know that if you ever begin" + ret$
        Oprint "`3 to see visions (although you haven't yet), it's a sign that you'll soon die." + ret$
        Oprint "`3 Even if you don't, the oxygen on Earth won't last forever. Either way, you're" + ret$
        Oprint "`3 a goner and you know it. You lean over the {edge} and prepare to jump." + ret$
        Oprint "`3    Before you have a chance to let go of the rail, something smacks you" + ret$
        Oprint "`3 in the face. You fall backwards onto the {sidewalk}, and realize that a news-" + ret$
        Oprint "`3 paper has blown right to you. The title makes your heart jump. It's an" + ret$
        Oprint "`3 outlawwed publication, Rebel Voice." + ret$
    END IF
END IF

IF Room = 14 THEN
    TagLine$ = "`}`$Walking South along Highway "
    Oprint "" + ret$
    Oprint "`3    You begin walking south along the side of the highway. You walk for hours" + ret$
    Oprint "`3 and completely forget that your oxygen supply won't last forever. You begin" + ret$
    Oprint "`3 to choke, and you rip your breathmask off in a panic. Panting and wheezing," + ret$
    Oprint "`3 your lungs grip the air but can't pull enough oxygen from it to help you." + ret$
    Oprint "`3 You fall to your knees with your hands on your neck, then you collapse." + ret$ + ret$
    GameOver
END IF

StatLine
END SUB

SUB StatLine
IF NoRecuse <> 0 THEN EXIT SUB

NoRecurse = 1
y = CSRLIN
x = POS(x)
IF TLocy = 1 THEN VIEW PRINT 1 TO 24
LOCATE TLocy, 1

f1 = OldFg
f2 = OldBg
F3 = Flash

c$ = MakeTime$

k$ = "`!`a Breath Pirates `} `3By Mike Snyder `} `2Time: `0" + c$ + "`}  "
IF ScoreToggle < 2 THEN
    k$ = k$ + TagLine$
ELSE
    k$ = k$ + MakeScore$
END IF
Oprint k$
IF TLocy = 1 THEN VIEW PRINT 2 TO 24
COLOR f1 + F3, f2
LOCATE y, x
IF PromptLineNum > 0 THEN
    PromptLine (PromptLineNum)
END IF

NoRecurse = 0
END SUB

FUNCTION StripConcat$ (x$)
  
'** StripConcat is here to allow for people who type get x; then get y where
'** the semicolon and the THEN would double-up concat. :)

    IF LEFT$(UCASE$(x$), 4) = "AND " THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 4))))
    END IF
    IF RIGHT$(UCASE$(RTRIM$(x$)), 4) = " AND" THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 4))))
    END IF
    IF LEFT$(UCASE$(x$), 5) = "THEN " THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 5))))
    END IF
    IF RIGHT$(UCASE$(RTRIM$(x$)), 5) = " THEN" THEN
        x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 5))))
    END IF
    IF LEFT$(x$, 1) = ";" THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(RIGHT$(x$, LEN(x$) - 1))))
    END IF
    IF RIGHT$(x$, 1) = ";" THEN
       x$ = StripConcat$(LTRIM$(RTRIM$(LEFT$(x$, LEN(x$) - 1))))
    END IF
    IF UCASE$(x$) = "THEN" THEN x$ = ""

StripConcat$ = x$
END FUNCTION

FUNCTION VariFile% (a$)

    FileExists = 1
    ON ERROR GOTO NoFile
    OPEN a$ FOR INPUT SHARED AS #1
    CLOSE #1
    SetStandardErrorTrap
    VariFile = FileExists

END FUNCTION

