#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


chicken : UntakeableActor 'chicken' 'chicken'
	@froggerRoadsideC
	
	cannotTakeMsg = (curState.cannotTakeMsg)
	cannotMoveMsg = (cannotTakeMsg)
	cannotPutMsg = (cannotTakeMsg)
	
	
	startCrossingRoad() {
		if(daemon==nil && isIn(froggerRoadsideC)) {
			daemon = new Daemon(self,&continueCrossing,3);
		}
	}
	
	continueCrossing() {
		if(isIn(froggerRoadsideC)) {
			chicken.scriptedTravelTo(froggerRoadway3c);
		} else if(isIn(froggerRoadway3c)) {
			chicken.scriptedTravelTo(froggerRiverbankC);
		} else {
			daemon.removeEvent();
			daemon = nil;
		}
	}
	
	daemon = nil
	
	
	curState {
		if(isIn(froggerRoadsideC)) {
			return chickenByRoad;
		} else if(isIn(froggerRoadway3c)) {
			return chickenRunningAcrossRoad;
		} else if(isIn(froggerRiverbankC)) {
			return chickenByRiver;
		} else {
			return chickenDead;
		}
	}

	dobjFor(Attack) asDobjFor(Take)
/*	
	iobjFor(ThrowAt) {
		verify() {
		}
		check() {
			"The chicken dodges your projectile easily. ";
//			gDobj.processThrow();
//			gDobj.moveInto(gPlayerChar.roomLocation.roomParts.indexOf(Floor));
			exit;
		}
		action() {
		}
	}
*/	
    throwTargetHitWith(projectile, path) {
		"The chicken dodges your projectile easily. ";
        getHitFallDestination(projectile, path).receiveDrop(projectile, new DropTypeThrowNoMsg(self, path));
	}
	
;
	+ Decoration '(chicken) head' 'head'
		"This chicken doesn't look like it's too bright. "
	;
	
	+ Decoration '(nice) (white) (chicken) feathery wing*wings' 'wings'
		"They're nice white feathery wings, but sadly, a chicken's wings do not allow it to fly. "
		isPlural = true
	;

	+ DefaultGiveShowTopic, ShuffledEventList [
		'The chicken cocks its head on the side and looks at you strangely. '
		]
	;
	+ DefaultAnyTopic, ShuffledEventList [
		'The chicken flaps its wings a bit and goes, <q>SQUAWK!</q> '
		]
	;


class DropTypeThrowNoMsg: DropTypeThrow
    standardReport(obj, dest) {}
;

+ chickenByRoad : ActorState
	isInitState = true
	
	stateDesc = "The chicken looks flustered and unhappy. It keeps walking towards the road, but whenever
		it gets close a car zooms by and the chicken squawks and jumps back. "
	
	specialDesc = "There is a chicken nervously walking back and forth near the road. "
	
	cannotTakeMsg = 'As anyone who has seen Rocky would know, catching a chicken is
		extremely difficult. When you reach for it, it runs towards the road, nearly gets
		run over by the traffic, but makes a last minute turn and runs alongside the road
		and around in circles until you give up trying to catch it. Then it stands, just
		out of reach, and squawks at you for a bit before resuming its task of being
		annoyed by the traffic. The chicken doesn\'t appear to like you very much. '	
;

+ chickenRunningAcrossRoad : ActorState
	stateDesc = "The chicken looks very happy. "
	
	specialDesc = "There is an extremely happy chicken here running across the road towards the river. "
	
	cannotTakeMsg = 'As anyone who has seen Rocky would know, catching a chicken is
		extremely difficult. When you reach for it, it jumps out of your way and continues
		on its quest for the other side. '
;

+ chickenByRiver : ActorState
	stateDesc = "Now that the chicken has crossed the road, it appears to once again be flustered and
		unhappy. But it's flustered in a very subdued way. It keeps walking towards the river,
		but before it gets too close to the crocodile it stops and backs away. Apparently
		this chicken is smart enough to know that the crocodile is unlikely to have the chicken's
		best interests at hear. "

	specialDesc = "There is a chicken here nervously walking back and forth near the river. It
		looks a little subdued though. "
	
	cannotTakeMsg {
		chicken.roomLocation.crocInThisRoom().feedCrocodile();
		chicken.moveInto(nil);
	
		return 'As anyone who has seen Rocky would know, catching a chicken is
			extremely difficult. When you reach for it, it runs toward the river and nearly runs
			into the crocodile before making a last minute turn to run alongside the river.
			Sadly, the crocodile has other plans and lunges for the chicken. With a horrid squawk,
			the chicken disappears into the crocodile\'s mouth.\b
			
			The crocodile appears to be docile now, so it would probably be safe to cross the river
			here. Apparently the answer to the age old question is that the chicken crossed the road
			in a selfless act of heroism to help you get to the other side.\b ';
	}
;

+ chickenDead : ActorState
	stateDesc = ""

	specialDesc = ""
	
	cannotTakeMsg = ''
;

