/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The adaptive hint dispenser.
 * Hideous version that uses lists instead of objects to keep the object
 * count down.
 *
 * (Requires maxinlist function from world.t)
 */
hintnum: function(name)
{
	local	i;

	for (i := 1; i <= length(hint.hintlist); i++)
		if (hint.hintlist[i][1] = name)
			return i;

	return 0;
}

inithints: function 
{
	local	i, j, o, name;

	// correct TADS parsing brain-damage
	hint.hintlist += hint.h1;	hint.h1 := nil;
	hint.hintlist += hint.h2;	hint.h2 := nil;
	hint.hintlist += hint.h3;	hint.h3 := nil;
	hint.hintlist += hint.h4;	hint.h4 := nil;
	hint.hintlist += hint.h5;	hint.h5 := nil;
	hint.hintlist += hint.h6;	hint.h6 := nil;
	hint.hintlist += hint.h7;	hint.h7 := nil;
	hint.hintlist += hint.h8;	hint.h8 := nil;
	hint.hintlist += hint.h9;	hint.h9 := nil;
	hint.hintlist += hint.h10;	hint.h10 := nil;
	hint.hintlist += hint.h11;	hint.h11 := nil;
	
	// Replace names in allows-lists with numbers
	for (i := 1; i <= length(hint.hintlist); i++) {
		for (j := 1; j <= length(hint.hintlist[i][2]); j++) {
			name := hint.hintlist[i][2][j];
			hint.hintlist[i][2][j] := hintnum(name);

			if (hint.hintlist[i][2][j] = 0)
				"hintnum returns zero for hint <<name>>!\n";
		}
	}
	
	// Create requires-lists on ends of hint records
	for (i := 1; i <= length(hint.hintlist); i++)
		hint.hintlist[i] += [[]];
	
	// Compute requirements lists from allows lists
	for (i := 1; i <= length(hint.hintlist); i++)
		for (j := 1; j <= length(hint.hintlist[i][2]); j++)
			hint.hintlist[hint.hintlist[i][2][j]][6] += i;

	// Put all hint nodes that have no requirements
	// (aka "bottoms") in a separate list.
	for (i := 1; i <= length(hint.hintlist); i++)
		if (hint.hintlist[i][6] = [])
			global.hintbottoms += i;

	// Now get rid of name strings -- we only support them to
	// make typing in the hint nodes easier.
	for (i := 1; i <= length(hint.hintlist); i++)
		hint.hintlist[i][1] := nil;

	// Set hintlevel for each hint node to one
	for (i := 1; i <= length(hint.hintlist); i++)
		hint.hintlevel += [1];
}

//
// ROT13 a string.  This is reversible.
//
crypt: function(s)
{
	local	i, j;
	local	s13;
	local	rot13 = [
		'a' 'n'
		'b' 'o'
		'c' 'p'
		'd' 'q'
		'e' 'r'
		'f' 's'
		'g' 't'
		'h' 'u'
		'i' 'v'
		'j' 'w'
		'k' 'x'
		'l' 'y'
		'm' 'z'
		'n' 'a'
		'o' 'b'
		'p' 'c'
		'q' 'd'
		'r' 'e'
		's' 'f'
		't' 'g'
		'u' 'h'
		'v' 'i'
		'w' 'j'
	       	'x' 'k'
		'y' 'l'
		'z' 'm'

		'A' 'N'
		'B' 'O'
		'C' 'P'
		'D' 'Q'
		'E' 'R'
		'F' 'S'
		'G' 'T'
		'H' 'U'
		'I' 'V'
		'J' 'W'
		'K' 'X'
		'L' 'Y'
		'M' 'Z'
		'N' 'A'
		'O' 'B'
		'P' 'C'
		'Q' 'D'
		'R' 'E'
		'S' 'F'
		'T' 'G'
		'U' 'H'
		'V' 'I'
		'W' 'J'
	       	'X' 'K'
		'Y' 'L'
		'Z' 'M'
	];

	if (not global.encrypt)
		return s;

	s13 := '';
	for (i := 1; i <= length(s); i++) {
		for (j := 1; j + 1 <= length(rot13); j += 2)
			if (rot13[j] = substr(s, i, 1)) {
				s13 += rot13[j + 1];
				break;
			}
		
		if (j + 1 > length(rot13))
			s13 += substr(s, i, 1);
	}

	return s13;
}

hint_instructions: function
{
	I(); "The hint system in this game is adaptive.  This means
	that it adjusts itself based on your progress, to give you
	the most useful hint it can.  You will not be penalized for getting
	hints, though the game does keep track of how many you've used
	throughout the game."; P();

	I(); "Be warned, however, that the hints will eventually
	spell out the solution to every puzzle -- if you overuse
	the hints, you will likely spoil the puzzle-solving part of
	the game.  Before giving up on a puzzle, take a break and come
	back to it later."; P();

	I(); "To get a hint, just type \"hint\" at any time.  If
	the hint system has any remaining advice for you, it will
	respond with a list of hint topics:"; P();

	"\t\(1\): Basics\n\t\(2\): How to get the cheez kee\n"; P();

	"You then enter the topic you want a hint for.  The program
	will respond with two numbers and the hint text, like so:"; P();

	I(); "(1/4): Try typing \"hint\" when you're stuck."; P();

	I(); "The numbers tell you which hint you're on in the topic,
	and how many hints there are in all.  The hint above, for example,
	is the first of four for the topic \"Basics.\""; P();

	I(); "Within a topic, hints get progressively more direct --
	the last hint in a group will generally spell out the solution
	to the puzzle."; P();
}

//
// Compute the distance from a hintnode to the final node (which allows
// nothing -- i.e., nothing depends on it).
//
// Since we're dealing with a DAG, we find the maximum depth (i.e.,
// the length of the longest path from the hintnode to the highest node).
//
hintdistance: function(h)
{
	local	i, allows := hint.hintlist[h][2], l := [];

	if (allows = [])
		return 0;
	else {
		for (i := length(allows); i > 0; i--)
			l += hintdistance(allows[i]) + 1;

		return maxinlist(l);
	}
}

//
// Find subnodes that are unsatisfied but that have all children satisfied.
//
unsatisfied: function(h)
{
	local	i, hl := hint.hintlist[h], l := [];

	if (hint.(hl[4]))	// call sat function
		return unsatisfiedlist(hl[2]);
	else {
		//
		// Is this node a win?
		// Check requirements: are they all satisfied?
		//
		for (i := 1; i <= length(hl[6]); i++)
			if (not hint.(hint.hintlist[hl[6][i]][4]))
				break;

		if (i > length(hl[6])) {
			//
			// This node has all requirements satisfied, but is not
			// satisfied itself.  It is therefore a candidate for
			// a hint.
			//
			return [] + h;
		}
		else {
			//
			// This node isn't satisfied, and neither are its
			// requirements.  This means that some node in
			// the subtree for one of the unsatisfied requirements
			// is a better hint.
			//
			return [];
		}
	}
}

//
// Call the unsatisfied function on a list of hintnodes.
//
unsatisfiedlist: function(hintnodelist)
{
	local	i, l := [];

	for (i := 1; i <= length(hintnodelist); i++)
		l += unsatisfied(hintnodelist[i]);

	return l;
}

//
// Front-end for unsatisifedlist that uniq's the resulting list.
//
unsat: function(hintnodelist)
{
	local	i, l, r := [];

	l := unsatisfiedlist(hintnodelist);

	//
	// Now construct a new list that contains each 
	// unsatisfied node only once.  (Our recursive
	// search may have put duplicates in.)
	//
	for (i := length(l); i > 0; i--)
		if (find(r, l[i]) = nil)
			r += l[i];

	return r;
}

//
// Find the best hint node, and give its (next) hint.
//
dispensehint: function(prompt)
{
	local	i, l, candidates := [];
	local	max, maxpos;
	local	dist;
	local	hints, hintlev;
	local	best;

	//
	// First give hint system instructions if this is the
	// first hint request.
	// 
	if (global.hintsused = 0)
		hint_instructions();

	"\bSearching for hint topics...\b";

	//
	// First find all unsatisfied nodes with all children satisfied.
	// We have to start this search from all nodes that have no
	// requirements themselves.  (This is necessary because we
	// only search up the graph, not down.)
	//
	l := unsat(global.hintbottoms);

	//
	// Eliminate candidates that have no hints left to give.
	//
	for (i := length(l); i > 0; i--)
		if (hint.hintlevel[l[i]] <= length(hint.hintlist[l[i]][3]))
			candidates += l[i];

	//
	// Make sure we have some hints left.
	//
	if (candidates = []) {
		"No hint available at this time.";
		return;
	}

/*
	//
	// Now we want to find the candidate with the maximum distance
	// from the final node.
	//
	max := hintdistance(candidates[1]);
	maxpos := 1;
	for (i := 2; i <= length(candidates); i++) {
		dist := hintdistance(candidates[i]);
		if (dist > max) {
			max := dist;
			maxpos := i;
		}
	}
	best := candidates[maxpos];
*/

	//
	// Let the player choose which topic he wants.
	//
	if (length(candidates) > 1) {
		local	b;

		"There are <<length(candidates)>> topics available:\b";
		for (i := 1; i <= length(candidates); i++) {
			b := candidates[i];
			"\(<<i>>\):<<i<10? ' ' : ''>> <<crypt(hint.hintlist[b][5])>> (<<hint.hintlevel[b]>>/<<length(hint.hintlist[b][3])>>)\n";
		}

		"\b";
		for (;;) {
			"Enter hint topic number (0 to quit) > ";
			best := cvtnum(input());
			if (best = 0) {
				"Ok.";
				return;
			}
			else if (best >= 1 and best <= length(candidates))
				break;
			else
				"No such topic.\b";
		}
	}
	else {
		local	b;

		"There is only one hint topic available at this time:\b";
		b := candidates[1];
		"\(1\): <<crypt(hint.hintlist[b][5])>> (<<hint.hintlevel[b]>>/<<length(hint.hintlist[b][3])>>)\n";
		best := 1;
	}

	best := candidates[best];

	//
	// Figure out how many hints there are for this node,
	// and what the current hint is.
	//	
	hintlev := hint.hintlevel[best];
	hints := length(hint.hintlist[best][3]);

	//
	// Give the player a chance to change his mind.
	//
	if (prompt) {
		"\bThis will be hint <<hintlev>> of <<hints>>. Are you sure
		you want the hint? (YES or NO) > ";
		if (yorn() <> 1) {
			"\bOkay.";
			return;
		}
		else
			"\b";
	}
	
	//
	// Give hint
	//
	"(<<hintlev>>/<<hints>>):\ <<crypt(hint.hintlist[best][3][hintlev])>>";
	hint.hintlevel[best]++;
	
	//
	// Score hint
	//
	global.hintsused++;
}

//
// Return the total number of hintnodes.
//
hintnodes: function
{
	return length(hint.hintlist);
}

//
// Count the number of hintnodes the player has satisifed.
//
hintnodes_satisfied: function
{
	local	i, count := 0, hl := hint.hintlist;

	for (i := 1; i <= length(hl); i++)
		if (hint.(hl[i][4]))
			count++;

	return count;
}

//
// Repository for hint stuff
// We have to do this the ugly was so we don't use too many objects.
// (Otherwise, our game won't run under conventional DOS!)
//
hint: object

//
// hintlist entry format:
//
// [ 'name' [allows-list] [msg-list] [sat-prop] [requires-list] ]
//
// NOTE: The requires-list is added by the init function above.
//
hintlevel = []
hintlist = []

h1 = [
	['H_Your_Bachelor_Pod'
	['H_Ada_Pod' 'H_Color_Chart']
	[]
	,&sattrue
	'']

	['H_Color_Chart'
	['H_TV_Gateway' 'H_Visit_Kuwl' 'H_Give_HandyPad_To_Watchmaker']
	['Look through the contents of your pod more carefully.'
	
	'Try reading through your old textbooks.']
	,&satcolorchart
	'How to get an item hidden in your pod']

	['H_Ada_Pod'
	['H_Open_Adas_Hatch' 'H_Visit_Barfee']
	['The matter mover can take you places!'
	
	'Use the autodialer to get to Ada\'s pod.']
	,&satadapod
	'How to get to Ada\'s pod']
	
	['H_Open_Adas_Hatch'
	['H_Zdybel' 'H_Hammer']
	['The matter mover isn\'t the only way out of Ada\'s pod.'
	
	'There\'s something that doesn\'t work in your pod
	that does work in Ada\'s pod.'
	
	'Try opening the hatch in Ada\'s pod.']
	,&satopenhatch
	'Another way out of Ada\'s pod']

	['H_TV_Gateway'
	['H_Open_Beanbag' 'H_Get_Password' 'H_Find_Backdoor']
	['Have you found the coordinates to Terminal Velocity yet?'
	
	'The coordinates to Terminal Velocity are on one of
	the Stik-Em Nowtz in your pod.  Why not pay Terminal
	Velocity a visit?'
	
	'Using the base coordinates for Hot Pink on your RGB color
	chart, you can get the coordinates for Terminal Velocity.'
	
	'The coordinates for Terminal Velocity are 
	Hot Pink (+0, -52, -5) = (10000, 4065, 7053)']
	,&sattvgateway
	'Visiting Terminal Velocity']
	]
	
h2 = [	
	['H_Visit_Barfee'
	['H_Ask_Woman_About_Daughter' 'H_Break_Vending_Machine']
	['Have you been to the Barfee Outlet yet?'
	
	'The Barfee Outlet coordinates are on the note in
	Ada\'s pod.']
	,&satvisitbarfee
	'Getting to the Barfee Outlet']

	['H_Break_Vending_Machine'
	['H_BARF_Ship']
	['Examine the vending machine.'

	'There\'s all that useful stuff in the vending machine.
	Too bad you can\'t seem to get any of it!'

	'Someone ought to fix that vending machine -- it\'s
	dangerously unstable!'

	'Try to knock over the vending machine.'

	'Kick the vending machine three times, and it will
	surely topple.']
	,&satbreakvendingmachine
	'The vending machine']

	['H_BARF_Ship'
	['H_Combo_Lock']
	['Have you seen the Barfee Advanced Research Foundation
	ship yet?'

	'Go to the flower warehouse and wait a while.  You\'ll
	see the Barfee Advanced Research Foundation ship before
	too long.'

	'If the Barfee ship were to land in front of the
	flower warehouse, the crowd would probably disperse.'

	'How could you make the Barfee ship pilot think you\'re
	part of the landing crew?'

	'Watch how the Barfee employees on the roof of the
	building guide the Barfee ship to a landing.'

	'You need to something bright orange to attract
	the Barfee ship pilot\'s attention.'

	'Wave the can of Akmi Soopur Wundur Gro when the pilot
	tries to land.']
	,&satbarfship
	'The Research Foundation']

	['H_Combo_Lock'
	['H_Barfee_Research_Labs']
	['The sequence of numbers on the Barfee lab\'s lock
	follows a pattern.'

	'The pattern of numbers for the lock is not a
	simple arithmetic or multiplicative sequence.'

	'Rather than thinking of the numbers in the
	sequence as atomic units, consider them as 
	compounds.'

	'The pattern of numbers depends on multiples
	of two and three.'

	'Each number in the sequence has two parts.
	The first part is an even number; the second
	part is an odd number.'

	'The next number in the sequence is 1015, because
	10 is the next multiple of 2 after 8, and 15 is the
	next multiple of 3 after 12.']
	,&satcombolock
	'Cracking the combination lock']

	['H_Zdybel'
	['H_Escape_Pod']
	['Be sure you\'ve explored the corridor under
	Ada\'s pod thoroughly.'

	'An object found in the corridor under Ada\'s pod
	will be useful in getting past the Zdybel.'

	'Shoot the Zdybel with the ary ung.']
	,&satzdybel
	'The Zdybel']

	['H_Barfee_Research_Labs'
	['H_Transmogrifyer' 'H_Have_Growth_Formula']
	['Go through the door with the keypad lock and look around.']
	,&satbrl
	'Barfee Research Labs']
]

h3 = [
	['H_Have_Growth_Formula'
	['H_Have_Egg']
	['You found something earlier that helps things grow fast.'
	
	'Use the Barfee advanced growth formula QX-32-Beta.']
	,&sathavegrowth
	'Green thumb advice']

	['H_Escape_Pod'
	['H_Get_To_Irata']
	['Have you been to the escape pod bay in the corridor under
	Ada\'s pod yet?']
	,&satescapepod
	'The escape pod bay']

	['H_Transmogrifyer'
	['H_Give_Prune_Seeds_To_Hoppian' 'H_Liquid_N']
	['Have you played with the Transmogrifyer in the
	Barfee Lab yet?'

	'The Transmogrifyer is broken.  Some of the dials
	don\'t work.'

	'There are twenty different objects you can
	get from the Transmogrifyer.  Make sure you
	know what they all are so you don\'t miss anything
	important.'

	'The Transmogrifyer only pays attention to
	the salmon dial and the orange dial.'

	'Set the salmon Transmogrifyer dial to 0 or 10.
	Set the orange dial to any number from 0 to 9.']
	,&sattransmog
	'The Transmogrifyer']

	['H_Ask_Woman_About_Daughter'
	['H_Elwood_Farm']
	['Listen to the Foonian woman at the Barfee outlet.'

	'The Foonian woman is eager for you to do something.'

	'The Foonian woman seems very eager to talk about her
	daughter.'

	'Ask the Foonian woman about her daughter.']
	,&sataskwoman
	'Chatting with the Foonian woman']

	['H_Give_Prune_Seeds_To_Hoppian'
	['H_Give_Credit_Slip_To_Woman']
	['Something the Transmogrifyer produces might be
	useful at this point.'

	'You should make a transaction with the Hoppian.'

	'Give the prune seeds to the Hoppian.']
	,&satgiveprune
	'Solving a puzzle with a-plum (sic)']
]

h4 = [
	['H_Get_To_Irata'
	['H_Get_New_Hell_Coords_From_Timon'
	'H_Put_Fried_Synthegg_In_Jade_Box'
	'H_Dylbez_Bedzyl']
	[]
	,&satgettoirata
	'']

	['H_Elwood_Farm'
	['H_Have_Fried_Synthegg'
	'H_Find_String'
	'H_Find_Akmid'
	'H_Plant_Eggplant_Seeds']
	['Use the coordinates the Foonian woman gave you.']
	,&satelwoodfarm
	'A getaway on beautfiul Foon']

	['H_Give_Credit_Slip_To_Woman'
	['H_Plant_Eggplant_Seeds']
	['You can use the credit slip you got from the Hoppian
	to buy some seeds.']
	,&satgivecredit
	'Giving credit where credit is due']

	['H_Dylbez_Bedzyl'
	['H_Return_From_Irata']
	['Figure out how to get past the Dylbez.'

	'The Dylbez is like several other creatures
	you\'ve already encountered in one way.'

	'Use the Bedzyl to get past the Dylbez.'

	'You can\'t get the Bedzyl, because you\'re
	too slow to catch it.'

	'Do you have anything that might speed you up
	so you could catch the Bedzyl?'

	'If you shoot the Bedzyl with the ary ung, you\'ll
	get a Zdybel. What do you suppose will happen if
	you shoot the Dylbez?'

        'Drink the ReVoLT Kola to pep yourself up.  Then
        grab the Bedzyl before the effect of the Kola 
        wears off.  Then drop the Bedzyl where the
        Dyblez is, shoot the Dylbez with the ary ung,
	shoot the Bedzyl with ary ung, and watch what
	happens!']

	,&satdylbez
	'Getting past the Dylbez']
]

h5 = [
	['H_Return_From_Irata'
	['H_Visit_Kuwl' 'H_Give_HandyPad_To_Watchmaker']
	['Figure out how to get off planet Irata.'

	'Look inside the survey station.'

	'Press the button inside the survey station
	to activate the matter mover so you can
	leave Irata.']
	,&satreturn
	'Leaving Irata']

	['H_Have_Fried_Synthegg'
	['H_Put_Fried_Synthegg_In_Jade_Box']
	['There\'s a pan in the cupboard in the Elwood\'s
	kitchen.  You might try cooking something in it.'

	'A cooked SynthEgg isn\'t as good as a cooked
	Foonian egg, but you could be worse off.'

	'Put the SynthEgg in the pan.  Then turn on the
	burners and put the pan on one of the burners.']
	,&sathavefried
	'The joy of cooking']

	['H_Find_Backdoor'
	['H_Inside_TV']
	['Decipher the mosaic on the floor in the Terminal
	Velocity Gateway.'

	'The mosaic on the floor deals with colors.  What
	other things have you seen that use colors?'

	'The mosaic describes updates to certain values.
	These updates can be applied in any order.'

	'Look up the colors mentioned in the mosaic on
	your RGB color chart.  Notice anything special
	about them?'

	'In the mosaic, "up" means "add" and "down" means
	"subtract".'

	'The mosaic describes the changes you must make
	to the Terminal Velocity matter mover coordinates
	to get the coordinates for a different matter mover.'

	'The mosaic is trying to tell you to go to coordinates
	(10000 - 2, 4065 + 2, 7053 - 2) = (9998, 4067, 7051).']
	,&satfindbackdoor
	'The Terminal Velocity mosaic']
]

h6 = [
	['H_Get_Password'
	['H_Inside_TV']
	['Pay close attention to the other Terminal Velocity
	patrons.'

	'Watch the interaction between the guard and the
	patrons at the Terminal Velocity Gateway.'

	'To get into Terminal Velocity, you will need the
	password.'

	'There\'s something in one of the side rooms
	in the "Infinite Corridor" that will help you.'

	'If you don\'t know what a "Trojan Horse" is, 
	look it up in a good dictionary.'

	'If you look like a Terminal Velocity guard,
	maybe one of the patrons will tell you the
	password.'

	'Wear the guard\'s extra uniform and then ask one
	of the other guests for the password.']
	,&satgetpassword
	'Getting into Terminal Velocity']

	['H_Plant_Eggplant_Seeds'
	['H_Have_Egg' 'H_Have_Growth_Formula']
	['Try planting some seeds in the Elwood\'s garden.'
	
	'On Tode, eggs come from chickens.  Not so on Foon.']
	,&satplanteggplant
	'The Compleat Gardener']

	['H_Inside_TV'
	['H_Jax_Den' 'H_Play_Game']
	['Try typing the password on the terminal in
	the Terminal Velocity Backdoor.  You\'ll need
	a suitable keyboard.'

	'Your Zippikraft Data Liquidizer has a detachable keyboard.']
	,&satinsidetv
	'Password authentication']

	['H_Have_Egg'
	['H_Cook_Egg']
	[]
	,&sathaveegg
	'']

	['H_Put_Fried_Synthegg_In_Jade_Box'
	['H_Visit_Kuwl']
	['Kuulest wants you to put an egg in the jade box
	outside his shack on Irata.  Don\'t you have
	something that might do?'

	'Put the fried SynthEgg in the jade box outside
	Kuulest\'s shack on Irata.']
	,&satputfried
	'The jade box']
]

h7 = [
	['H_Jax_Den'
	['H_TV_Elite_Pass' 'H_Create_Matter_Digital_Converter']
	['Explore Terminal Velocity.'

	'Head southeast from the bar in Terminal Velocity.']
	,&satjaxden
	'Meet Jax']

	['H_Cook_Egg'
	['H_Put_Egg_And_Jade_Figurine_On_Disk']
	['"If cooked it be, it\'s Dam Tastee!"'

	'That Foonian egg\'s not going to do
	you much good raw.']
	,&satcookegg
	'More on cookery']

	['H_Visit_Kuwl'
	['H_Have_Jade_Figurine']
	['Pay a visit to Kuwl.'

	'Read the leaflet in Kuulest\'s shack.']
	,&satvisitkuwl
	'Going Too Kuwl (sic)']

	['H_Create_Matter_Digital_Converter'
	['H_Put_Egg_And_Jade_Figurine_On_Disk']
	['Check out the Digital-to-Matter converter.'

	'Can you do anything to change the 
	Digital-to-Matter converter in any way?'

	'This looks like a job for an ary ung!'

	'Shoot the Digital-to-Matter converter
	with the ary ung.']
	,&satcreatemdc
	'An item of interest in Jax\'s Data Den']

	['H_Have_Jade_Figurine'
	['H_Put_Egg_And_Jade_Figurine_On_Disk']
	['Make sure you spend enough time at
	the Kuwl startport to get a good feel
	for the place.']
	,&sathavejade
	'Sightseeing on Kuwl']

	['H_Put_Egg_And_Jade_Figurine_On_Disk'
	['H_Have_Jade_Figurine_In_GWG' 'H_Have_Fried_Egg_In_GWG']
	['You can\'t get anywhere in Unnkulian Unventure III
	with the objects you start out with.'

	'Now how could you change Unnkulian Unventure III
	so that you can make progress in it?'
	
	'Use the Matter-to-Digital converter.']
	,&satputstuffondisk
	'How to succeed in Unnklian Unventure III']
]

h8 = [
	['H_Play_Game'
	['H_Have_Jade_Figurine_In_GWG' 'H_Have_Fried_Egg_In_GWG']
	['Try playing Unnkulian Unventure III.']
	,&satplaygame
	'Playing Unnkulian Unventure III']

	['H_Have_Jade_Figurine_In_GWG'
	['H_Get_To_Monk']
	['You need Duhdha\'s help to succeed at Unnkulian
	Unventure III.'

	'The Watchful Duhdha has greater power than you
	imagine.'

	'You need to get the jade figurine into Unnkulian
	Unventure III.']
	,&sathavejadeingwg
	'Duhdha and UU3']

	['H_Have_Fried_Egg_In_GWG'
	['H_Give_Fried_Egg_To_Monk']
	[]
	,&sathavefriedingwg
	'']

	['H_Get_To_Monk'
	['H_Give_Fried_Egg_To_Monk']
	['Look carefully.  There\'s a hut somewhere around here.']
	,&satgettomonk
	'Finding the monk']

	['H_Give_Fried_Egg_To_Monk'
	['H_Get_Riddle_Right']
	['The monk wants breakfast.'

	'The monk loves cooked eggs.']
	,&satgivefried
	'How to make the monk happy']
]

h9 = [
	['H_Get_Riddle_Right'
	['H_Win_GWG']
	['"They" can mean a lot of different things.'

	'Sometimes the meanings of words aren\'t important.'
	
	'Say the riddle aloud and listen carefully.'

	'To solve the riddle, think about how the words	sound.'

	'What things meet when you say "mama" and "papa"?'

	'"They" refers to a part of the body.'

	'What things meet when you kiss?']
	,&satriddle
	'About the riddle']

	['H_Win_GWG'
	['H_Have_Mirror']
	[]
	,&satwingwg	
	'']

	['H_Have_Mirror'
	['H_Win']
	[]
	,&sathavemirror
	'']

	['H_TV_Elite_Pass'
	['H_Ride_Bike_And_Live']
	[]
	,&sattvelite
	'']

	['H_Hammer'
	['H_Break_Lock']
	[]
	,&sathammer
	'']

	['H_Liquid_N'
	['H_Break_Lock']
	[]
	,&satliquidn
	'']

	['H_Ride_Bike_And_Live'
	['H_Break_Lock']
	['Have you checked out the bar yet?'

	'Look behind the bar.'

	'Try riding the bicycle behind the bar.']
	,&satridebike
	'The bar']
]

h10 = [
	['H_Break_Lock'
	['H_Get_HandyPad']
	['Work on getting into the oak chest.'

	'To get into the chest, you will need to break the lock.'

	'Try hitting the lock with the hammer.'

	'What could you do to weaken the lock?'

	'Things tend to become brittle when exposed to extremely
	low temperatures.'

	'Something the Transmogrifyer creates is very cold.'

	'Pour the liquid nitrogen on the lock and then hit
	the lock with the hammer.']
	,&satbreaklock
	'What to do in the future']

	['H_Get_HandyPad'
	['H_Give_HandyPad_To_Watchmaker']
	[]
	,&satgethandy
	'']

	['H_Get_New_Hell_Coords_From_Timon'
	['H_Give_HandyPad_To_Watchmaker']
	[]
	,&satgetnhcoords
	'']

	['H_Give_HandyPad_To_Watchmaker'
	['H_Get_Akmi_Coords' 'H_Guess_Colorspace_Akmi']
	['Try to figure out what the Watchmaker might want.'

	'The Watchmaker wants information.  You have found
	something that contains valuable information.'

	'Give the HandyPad to the Watchmaker.']
	,&satgivehandy
	'Who watches the Watchmen?']

	['H_Get_Akmi_Coords'
	['H_Win']
	[]
	,&satgetakmi
	'']

	['H_Guess_Colorspace_Akmi'
	['H_Win']
	['Take a close look at the RGB color chart.'

        'Akmi has enough clout to have an entire colorspace
	dedicated for their use alone.'

	'Look at the Transmogrifyer dials.  These are popular
	Akmi colors.  Are there any related colorspaces?'

	'The colorspace you\'re looking for is Akmi Orange.']
	,&satguesscolorspace
	'Finding Plast']
]

h11 = [
	['H_Open_Beanbag'
	['H_Have_Squirt']
	['Have you checked out the Terminal Velocity toy
	room thoroughly?'

	'Beanbag chairs always have very specific functions.'
	
	'There\'s a lump in that beanbag chair.  Hmmm...'

	'It might be worth cutting open that beanbag chair
	to see what\'s in there.'

	'Cut open the beanbag chair with the coat hanger.']
	,&satopenbeanbag
	'Goodies in the Terminal Velocity toy room']

	['H_Have_Squirt'
	['H_Win']
	[]
	,&sathavesquirt
	'']

	['H_Find_String'
	['H_Beat_Cranemaster']
	['Have you been up the tree next to the Elwood\'s farmhouse?']
	,&satfindstring
	'Something near the farmhouse']

	['H_Find_Akmid'
	['H_Beat_Cranemaster']
	['You\'ve missed something on the road near the mover
	on Foon.']
	,&satfindakmid
	'Good luck all day']

	['H_Beat_Cranemaster'
	['H_Have_Firecracker']
	['You can\'t beat the CraneMaster machine with dexterity
	alone.'

	'Those crane games are so unfair -- it seems only right
	to cheat them.'

	'You only have one Akmid, but you need to play the crane
	game many times to get good enough to win the goodies.'

	'Can you make the crane machine think you\'ve put in more
	than on Akmid when you only have one?'

	'Could you put the Akmid in the CraneMaster and then
	get it back out?'

	'The Akmid has a hole in it.  Hmmm....'

	'Tie the string to the Akmid.  Then put the Akmid in
	the machine and pull it back out.  Repeat as needed.']
	,&satcranemaster
	'Beating the CraneMaster']

	['H_Have_Firecracker'
	['H_Win']
	['There\'s something you still need to get from the CraneMaster.']
	,&sathavefirecracker
	'More on the CraneMaster']

	['H_Win'
	[]
	['Have you figured out how to control Squirt?  Watch
	what he does closely.'

	'Put Squirt on the ground.  Stomp.'

	'Squirt will respond to the following actions: yell, stomp,
	whistle, clap, snap.']

	,&satnil
	'Squirt']
]

//
// Hint satisfication methods.
// Each hint node has a method which returns true if the node has
// been satisifed, false otherwise.
//
	sattrue = { return true; }
	satnil = { return nil; }

#ifdef	DEMO

	//
	// Fake ones for the demo
	//

	satcolorchart = { return rgb.isknownto(Me); }
	satadapod = {	return adapod.isseen; }
	satopenhatch = { return ADAhatch.isopen; }
	sattvgateway = { return TV.isseen; }
	satvisitbarfee = { return barfee.isseen; }
	satbreakvendingmachine = { return not SUPPLIESmachine.upright; }


	satbarfship = { return nil; }
	satcombolock = { return nil; }

	satzdybel = { return Zdybel.scored; }

	satbrl = { return nil; }
	sathavegrowth = { return nil; }
	satescapepod = { return inpod.isseen; }
	sattransmog = { return nil; }

	sataskwoman = { return ELmover.accepting; }
	satgiveprune = { return nil; }
	satgettoirata = { return nil; }
	satelwoodfarm = { return elroad.isseen; }
	satgivecredit = { return nil; }
	satdylbez = { return nil; }
	satreturn = { return nil; }

	satfindbackdoor = { return nil; }
	satgetpassword = { return TVpassword.isknown; }
	satplanteggplant = { return nil; }
	satinsidetv = { return nil; }

	sathaveegg = { return nil; }
	satputfried = { return nil; }
	satjaxden = { return nil; }
	satcookegg = { return nil; }
	satvisitkuwl = { return nil; }
	satcreatemdc = { return nil; }
	sathavejade = { return nil; }
	satputstuffondisk = { return nil; }
	satplaygame = { return nil; }
	sathavejadeingwg = { return nil; }
	sathavefriedingwg = { return nil; }
	satgettomonk = { return nil; }
	satgivefried = { return nil; }
	satriddle = { return nil; }
	satwingwg = { return nil; }
	sathavemirror = { return nil; }
	sattvelite = { return nil; }
	sathammer = { return nil; }
	satliquidn = { return nil; }
	satridebike = { return nil; }
	satbreaklock = { return nil; }
	satgethandy = { return nil; }
	satgetnhcoords = { return nil; }
	satgivehandy = { return nil; }
	satgetakmi = { return nil; }
	satguesscolorspace = { return nil; }

	satopenbeanbag = { return beanbag.itemfound; }
	sathavesquirt = { return squirt.isknownto(Me); }

	satfindstring = { return nil; }
	satfindakmid = { return akmid.isknownto(Me); }
	satcranemaster = { return nil; }
	sathavefirecracker = { return nil; }

#else	/* DEMO */

	//
	// The real ones
	//
	satcolorchart = { return rgb.isknownto(Me); }
	satadapod = {	return adapod.isseen; }
	satopenhatch = { return ADAhatch.isopen; }
	sattvgateway = { return TV.isseen; }
	satvisitbarfee = { return barfee.isseen; }
	satbreakvendingmachine = { return not SUPPLIESmachine.upright; }
	satbarfship = { return researchhall.isseen; }

	satcombolock = { return researchdoorway.openedonce; }
	satzdybel = { return Zdybel.scored; }
	satbrl = { return barfeelab.isseen; }
	sathavegrowth = { return barfeegrowthformula.isseen; }
	satescapepod = { return inpod.isseen; }
	sattransmog = { return seeds.isknownto(Me) and liquidnitrogen.isknownto(Me); }
	sataskwoman = { return ELmover.accepting; }
	satgiveprune = { return creditslip.isknownto(Me); }
	satgettoirata = { return landingarea.isseen; }
	satelwoodfarm = { return elroad.isseen; }
	satgivecredit = { return VEGseller.paid; }
	satdylbez = { return Dylbez.scored; }
	wassat1 = nil
	satreturn = { 
		if (self.wassat1)
			return true;

		if (SSmover.accepting)
			self.wassat1 := true;

		return true;
	}
	sathavefried = { return friedsynthegg.isknownto(Me); }
	satfindbackdoor = { return TVbackdoor.isseen; }
	satgetpassword = { return TVpassword.isknown; }
	satplanteggplant = { return seedlump.isknownto(Me); }
	satinsidetv = { return TVaround1.isseen; }
	sathaveegg = { return egg.isknownto(Me); }
	satputfried = { return retreatcontainer.scored; }
	satjaxden = { return TVJaxden.isseen; }
	satcookegg = { return friedegg.isknownto(Me); }
	satvisitkuwl = { return starport.isseen; }
	satcreatemdc = { return converter.hasbeenscrambled; }
	sathavejade = { return figurine.isknownto(Me); }
	satputstuffondisk = { return figurine.tossed; }
	satplaygame = { return uu3transition.isseen; }
	sathavejadeingwg = { return figurine.tossed; }
	sathavefriedingwg = { return true; }
	satgettomonk = { return outsidehut.isseen; }
	satgivefried = { return AtTheCenter.isseen; }
	satriddle = { return answerriddle.scored; }
	satwingwg = { return self.satriddle; }
	sathavemirror = { return mirror.isknownto(Me); }
	sattvelite = { return TVelite.isknownto(Me); }
	sathammer = { return hammer.isknownto(Me); }
	satliquidn = { return liquidnitrogen.isknownto(Me); }
	satridebike = { return bicycle.isknownto(Me); }
	satbreaklock = { return padlock.location = nil; }
	satgethandy = { return handypad.isknownto(Me); }
	satgetnhcoords = { return triangle.isknownto(Me); }
	satgivehandy = { return watchmaker.solved; }
	satgetakmi = { return watchmaker.solved; }
	satguesscolorspace = { return akmihq1.isseen; }
	satopenbeanbag = { return beanbag.itemfound; }
	sathavesquirt = { return squirt.isknownto(Me); }
	satfindstring = { return string.isknownto(Me); }
	satfindakmid = { return akmid.isknownto(Me); }
	satcranemaster = { return cranemaster.scored; }
	sathavefirecracker = { return firecracker.isknownto(Me); }

#endif	/* DEMO */

;
