#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ericstry.t: Eric's Gift narration.
 */

#include <adv3.h>
#include <en_us.h>

doMorePrompt(doClear)
{
    inputManager.pauseForMore(nil);
    if ( doClear )
        clearScreen();
}

intro()
{
    local z = gActor;

    clearScreen();

    "\b\bThree-thirty in the morning. Turill Plaza is always empty at this
     hour. For about four years, you have been coming here, hoping... no,
     knowing you would find her.\b";
    "And tonight, she may finally be here.\b";

    doMorePrompt(nil);

    gActor = gPlayerChar;
    setHer([cappellaNight]);
    gActor = z;

    "<center><big><b>E R I C ' S\tG I F T</b></big>";
    "\nAn interactive tale about the future.</center>";
    "\b(First time users, please type <b>about</b>.)\b";
}

greetCappella()
{
    "You walk across the plaza, towards the woman.\b";
    "<q>Mrs. Chandler?</q> you ask.\b";
    "The woman turns and looks at you. Indeed, it is she. The light that used
     to shine in her eyes is gone, as you knew it would be. For a moment, she
     doesn't seem to recognize you. Then, she smiles.\b";
    "<q>Oh, it's you,</q> she says, <q>I didn't really expect to ever see you
     again.</q>\b";
    "She is standing directly between you and the old clock tower. Almost
     directly above her, the full moon is shining its pale blue light on the
     both of you. The whole scene lies before your eyes, almost exactly like
     in the painting. Except for the old clock, of course.";

    cappellaNight.name = 'Mrs. Chandler';
    cappellaNight.isProperName = true;
    cappellaNight.myHereDesc = 'Mrs. Chandler is standing right in front of you.';
    plaza.noGoText = 'You don\'t want to just leave. After all, this is what
                      you have been coming here for.';
}

askCappellaAboutMe()
{
    "<q>So you do remember me, Mrs. Chandler. I was wondering if you
     would,</q> you say.\b";
    "<q>I do,</q> she says, <q>but please, call me Cappella. I don't use the
     name Chandler any more.</q>\b";
    "<q>Oh! I'm sorry to hear that.</q> So he did die that night. Somehow,
     that doesn't surprise you.\b";
    "<q>Thank you, it's quite all right. Why don't we go and have a cup of
     coffee?</q> she asks, pleasantly.\b";
    "Nodding in agreement, you turn and head towards Sal's Diner.\b";

    doMorePrompt(nil);

    "As you arrive at the diner, you get in and head for a corner table,
     ordering two cups of synthcaf.\b";

    cappellaNight.name = 'Cappella';
    cappellaNight.myHereDesc = 'Cappella is sitting across the table from you,
                                holding her own cup.';
    me.moveInto(theBench);
    me.posture = sitting;
    cappellaNight.moveInto(diner);
    me.lookAround(true, true);
    setIt([theCoffee]);
    cappellaNight.startDaemon();
}

coffeeFlashback()
{
    "\bAs the steam rises from the cups, you quietly stare at each other. All
     the while, your mind floats back to that fateful day, almost four years
     ago, when you met Cappella Chandler.\b";

    doMorePrompt(true);

    cappellaNight.stopDaemon();
    me.moveInto(apartment);
    me.posture = standing;
    me.lookAround(true, true);

    "\bIt is Thursday night. You have nothing to do.";
}

hatFlashback()
{
    "Your thinking hat. You always wear this hat whenever you need to do any
     creative work. This hat has been with you ever since your friend JB found
     it in some sleazy joint and bought it for you as a joke. JB. You haven't
     seen him in a few months. Perhaps it's a good time to pay him a surprise
     visit. ";

    doMorePrompt(nil);

    "You turn and head towards JB's house.\b";

    me.moveInto(streetJB);
    me.lookAround(true, true);
}

knockOnDoor()
{
    "\bA woman opens the door, smiling to you in a kind and honest manner, her
     eyes shining brightly.";
    "\b<q>Yes?</q> she asks, <q>What can I do for you?</q>";
    "\bYou are completely blown over by her lack of fear of the total stranger
     that you are to her. It is as if she knows that nothing could ever hurt
     her. You babble for a bit, before being able to speak.";

    cappellaHallway.moveInto(hallway);
    doorJB.makeLocked(nil);
    doorJB.makeOpen(true);
    hallway.east = forcePastWoman;
    leavingJB.noGoDesc = 'You think about leaving but something about the woman
                          makes you change your mind.';
    unknown.noGoDesc = 'You glance at the other apartment doors. No, you are
                        quite sure that you have the right one.';
    setHer([cappellaHallway]);
}

askAboutJB()
{
    "<q>I'm looking for Jack Brown,</q> you say, hesitantly.";
    "\bShe seems puzzled.";
    "\b<q>Samuel Jackson Brown. He lives here, or so I seem to think.</q>";
    "\b<q>Oh! Yes. Mr. Brown no longer owns this apartment. It's our home now,
     mine and Eric's.</q>";
    "\bThat is a shock. You can't think of a single reason why JB would move
     without telling you. The woman notices your surprise, but she obviously
     does not know what to do about it, any more than you do. Apologetically,
     she speaks:";
    "\b<q>Please! Come in. You look tired.</q>";
    "\bYou are unable to refuse.\b";

    doMorePrompt(nil);

    cappellaEarly.descCount = cappellaHallway.descCount;
    me.moveInto(living);
    me.lookAround(true, true);
    setHer([cappellaEarly]);

    "\bAs she takes your coat and hat, she starts to tell you about how she
     and Eric have just gotten married and how they have just bought this
     house from the nicest guy and how they have all kinds of plans. Finally,
     you manage to interrupt her, as she sits on the sofa.";

    cappellaEarly.myHereDesc = 'The woman that now lives in JB\'s old
                                apartment is sitting on the sofa, idly
                                chatting with you, her eyes shining as
                                brightly as ever.';
    theHat.makeWornBy(nil);
    theHat.moveInto(rack);
    theCoat.makeWornBy(nil);
    theCoat.moveInto(rack);
    cappellaEarly.startDaemon();
}

askName()
{
    "I'm Cappella. Cappella Chandler.</q>";
    "\b<q>A beautiful name for a beautiful lady,</q> you reply, with a smile.";

    cappellaEarly.name = 'Cappella';
    cappellaEarly.isProperName = true;
    cappellaEarly.nameKnown = true;
    cappellaEarly.myHereDesc = 'Cappella is sitting on the sofa, idly
                                chatting with you, her eyes shining
                                brightly.';
}

enterEric()
{
    local z = gActor;

    "You hear a door opening and a strong baritone voice yelling, <q>Honey! I'm
     home!</q>";
    "\bYou turn in time to see Cappella run and embrace the newly arrived man.
     Then, he turns and looks at you, his green eyes seeming to shine with the
     same inner light as Cappella's, although not as bright. Just as the moon
     can never be as bright as the sun, you think to yourself. He smiles and
     stretches out his hand, in the same calm and relaxed manner as
     Cappella had done earlier.";
    "\b<q>Welcome,</q> he says, <q>any friend of Cappella's is a friend of
     mine.</q>";
    "\bYou shake his hand, adding a simple <q>Nice to meet you.</q>";

    Eric.moveInto(living);
    cappellaEarly.spokeThisTurn = true;
    Eric.startDaemon();

    gActor = gPlayerChar;
    setHim([Eric]);
    gActor = z;
}

showPainting()
{
    local z = gActor;

    "\b<q>Sure, why not?</q>";

    doMorePrompt(nil);

    "Eric leads you through the door to his study.\b";

    Eric.moveInto(study);
    Eric.myHereDesc = 'Eric is here, showing you his work in progress.';
    me.moveInto(study);
    me.posture = standing;
    me.lookAround(true, true);
    cappellaEarly.stopDaemon();
    Eric.stopDaemon();

    gActor = gPlayerChar;
    setIt([thePortrait]);
    gActor = z;
}

seePainting()
{
    "You recognize Cappella's face easily. It is almost perfect, lacking only
     the inner light in her eyes.";
    "\bSomehow, he seems to realize you noticed that fault.";
    "\b<q>I just cannot capture it,</q> he says.";
    "\bThe scene is a mid-afternoon portrait, a close-up of Cappella, with
     the old clock tower in the background. The old clock looks just like it
     did during the days of your childhood. It indicates three-thirty. Above
     the tower, the sun is shining.";
    "\b<q>Perhaps the background is wrong,</q> you venture, out of the blue,
     <q>why don't you try a night scene?</q>";
    "\bHe looks at you, maybe wondering why he didn't think of it himself.
     Then, he takes a jet-paint, adjusts it to dark blue, and with six or
     seven masterful strokes, turns the day into night. When he is finished
     painting the moon where the sun used to be, he steps back and admires his
     work.";
    "\bIt has improved, as you hoped it would. Cappella's face is now radiant
     where it was gloomy. But still, her eyes do not shine.";
    "\b<q>And yet,</q> he murmurs, <q>there must be a way to capture it.</q>";
    "\bThen, he looks at you and cheerfully asks, <q>Would you like to stay
     for dinner?</q>";
    "\bOnce again, you are unable to refuse.\b";

    doMorePrompt(nil);

    Eric.moveInto(chairs);
    Eric.posture = sitting;
    Eric.myHereDesc = 'Eric is sitting at the table, savoring the excellent
                       food and idly chatting with you.';

    cappellaEarly.moveInto(chairs);
    cappellaEarly.posture = sitting;
    cappellaEarly.myHereDesc = 'Cappella is sitting at the table, eating.
                                Once in a while, she glances around to see if
                                everyone is appropriately catered to.';

    me.moveInto(chairs);
    me.posture = sitting;
    me.lookAround(true, true);

    if ( Eric.goCount < 2 )
        Eric.goCount--;
    Eric.startDaemon();
    cappellaEarly.topicLst = cappellaEarly.topicLst + jinglesTopic;
    cappellaEarly.waitCount = 3;
    cappellaEarly.startDaemon();
}

tasteFood()
{
    "On top of it all, Cappella is an excellent cook. The synthurkey tastes
     almost like real meat, and the rice and orange blend together in
     perfection. Compared to the instant meals you are used to, this is
     absolutely divine.";
}

askAboutLove()
{
    "You hum a little ditty, one of the jingles you once wrote.";
    "\bAs you wind down, Eric cuts in:";
    "\b<q>Have you ever been in love?</q> he asks.";
    "\b<q>No,</q> you reply, <q>I can't say I've had the pleasure.</q>";
    "\b<q>Oh, it's no pleasure,</q> he says, <q>it's a torture! A kind of
     wonderful torture.</q>";
    "\bYou all laugh.";

    Eric.history = Eric.history + loveTopic;
    cappellaEarly.history = cappellaEarly.history + loveTopic;
    me.canSingNow = 2;
    cappellaEarly.topicLst = [giftTopic, gift2Topic, gift3Topic];
    cappellaEarly.waitCount = 1;
}

doGift1()
{
    "Out of the blue, Cappella starts:";
    "\b<q>Eric has this gift...</q>";
    "\b<q>Oh? And what might that be?</q> you ask, trying to give the
     impression that you know what is to come.";
    "\bEric actually seems somewhat displeased.";
    "\b<q>See that painting over there?</q> Cappella asks, pointing the
     largest of Eric's works. <q>He did that two years ago.</q>";

    thePainting.moveInto(dining);
}

doGift2()
{
    "Cappella continues:";
    "\b<q>On our honeymoon, three months ago, we went to East China. As we
     were driving by that very same plaza in a rented car, we bumped into
     another couple. Theirs was also a rented car, and in fact, they were also
     on their honeymoon. The driver came out and started to argue with
     Eric. I was just watching this when, all of a sudden, it struck me that
     Eric had painted this exact scene, with the exception of the Li Yang Po
     statue. I began to laugh. That was enough to end the argument. We still
     keep in touch with the other couple.</q>";
    "\bAs she tells her story, you find yourself fascinated by that
     unfinished painting in Eric's study. And as you listen, you can't help
     but pray that the light in those eyes never goes out.";
    cappellaEarly.waitCount = 0;
}

doGift3()
{
    "Cappella continues:";
    "\b<q>See? Eric's this kind of magician. He makes things happen when he
     paints them, and...</q>";
    "\b<q>That's not true,</q> Eric interrupts, <q>it was just a coincidence.
     And even if it wasn't, the most you can say is that I predict the future,
     which is ridiculous enough.</q>";
    "\b<q>What do you think?</q> Cappella asks you, <q>Does he predict the
     future, or does he make it happen?</q>";
    "\b<q>Oh, I don't know,</q> you reply, <q>Does it really make any
     difference?</q>";
    "\bThey both smile. They know you are right, of course.";

    theDinner.canEnd = true;
}

endDinner()
{
    "\bDinner winds down with a glass of a brand of synthliquor for which Eric
     shares your taste. Afterwards, you all move back to the living room and
     you prepare to leave.\b";

    doMorePrompt(nil);

    panelBuildings.isEnding = true;
    Eric.moveInto(living);
    Eric.posture = standing;
    Eric.myHereDesc = 'Eric is here, idly chatting as you prepare to leave.';
    cappellaEarly.moveInto(living);
    cappellaEarly.posture = standing;
    cappellaEarly.myHereDesc = 'Cappella is here, assisting you with your coat
                                and hat.';
    living.hereDesc = 'Eric and Cappella certainly have more taste than JB did.';
    me.moveInto(living);
    me.posture = standing;
    me.lookAround(true, true);

    "\bAs you are getting ready to leave, your eyes fall upon the giant panel
     above the fireplace.";
}

endVisit()
{
    "Suddenly, all the blood rushes out of your face, and the food churns in
     your stomach, as you recognize the buildings. There stand
     burning the old Museum of Arts and Sciences and a well-known three-story
     Victorian house.";
    "\b<q>What's wrong?</q> Cappella asks.";
    "\b<q>Had you ever been to this street before? Before you moved here,</q>
     you slowly reply.";
    "\bThey seem puzzled. Finally, Eric says, <q>No, I couldn't say that we
     had. Why?</q>";
    "\bCappella nods in agreement.";
    "\bYou have no choice but to tell them what you know. For a while they
     are silent.";
    "\bThen, Eric says, <q>I think you should leave now.</q>";
    "\bYou murmur a faint thanks for the dinner and leave the house, hoping
     that everything will be all right. ";

    doMorePrompt(true);

    "As it was, you were never to see Eric again.";
    "\bThere was a fire that night. One of Kemstone Electronics'
     Semiconductor Development labs exploded shortly after midnight. The
     Kemstone Tower burned to the ground, taking the neighboring apartment
     building down with it.";
    "\bEvery night since then, you have been going to see the old clock
     tower, knowing that Cappella escaped the fire. You knew you would find
     her there one night, at three-thirty in the morning, and that the light
     in her eyes would be gone.";
    "\bYour mind snaps back to the diner and the coffee you are drinking,
     when Cappella interrupts your thoughts.\b";

    doMorePrompt(nil);

    me.moveInto(theBench);
    me.posture = sitting;
    me.lookAround(true, true);

    "\b<q>All of a sudden, you are quiet,</q> she says.";
    "\b<q>Yes,</q> you reply, <q>I was just thinking about stuff...</q>";
    "\bYou finish drinking in silence, then go out for a quiet walk
     through the now empty streets of the city. It crosses your mind that she
     knows what you were thinking about.";

    doMorePrompt(nil);

    "<center><b><i>*** The End ***</i></b></center>";

    finishGame([finishOptionEpilogue, finishOptionUndo, finishOptionCredits]);
}

doEpilogue()
{
    "\b<b>Eric's Gift - Epilogue</b>";
    "\b<i>Cappella and I are married, now. We live a simple, yet happy life.
     We were never really in love with each other, but we both knew we would
     never in the future fall in love with anyone, anyway. We have no
     children, nor do we ever plan to.";
    "\bI never did find out what happened to JB, and I suppose I miss him.";
    "\bAs the days go by, I dream of the moment when I see Cappella's eyes
     shine again.</i>\b";

    doMorePrompt(nil);
}
