!*** NEW VERBS --------------------------------------------------------------

! Some grammar, such as "remove", needs to come before default library
! grammar. For this reason, if we have a reason to extend a verb, be sure
! to include the syntax in its entirety, so that it all works right.

xverb "walkthrough", "walkthru", "walk-thru", "walk-through", "solution"
    *                               DoWalkthru

xverb "xyzzy", "plugh"
    *                               DoMagicWord

xverb "about", "credit", "credits"
    *                               DoAbout

xverb "help"
    * "me"                          DoHelp
    *                               DoHelp

xverb "hint", "clue", "hints"
    *                               DoHint

!The word "foxtrot" serves as a password, for enabling the cheats.
xverb "cheat"
    *                                                         DoCheatMessage
    * "foxtrot" "on"/"enable"                                 DoCheatEnable
    * "foxtrot" "off"/"disable"                               DoCheatDisable
    * "off"/"disable"                                         DoCheatDisable
    * "skip"/"skipto"/"go"/"goto" "beginning"/"prologue"/"0"  DoCheatSkip1
    * "skip"/"skipto"/"go"/"goto" "part1"/"chapter1"/"1"      DoCheatSkip1
    * "skip"/"skipto"/"go"/"goto" "part2"/"chapter2"/"2"      DoCheatSkip2
    * "skip"/"skipto"/"go"/"goto" "part3"/"chapter3"/"3"      DoCheatSkip3
    * "skip"/"skipto"/"go"/"goto" "ending"/"epilogue"/"4"     DoCheatSkip4
    * "get"/"acquire"/"take" anything                         DoCheatGet

!Replaces "read" so that we can separate "read" from look" when needed"
verb "read", "peruse", "study"
    *                                 DoVague
    * readable                        DoRead

!Replaces "throw" from the "verbstub.g" file to be a little more robust.
verb "throw", "hurl", "toss", "pitch", "chuck", "chunk", "lob", "fling"
    *                                                         DoVague
    * held "at"/"to"/"toward"/"towards"/"on"/"onto" xobject   DoThrowAt
    * held "into"/"in"/"over" xobject                         DoThrowAt
    * held "down"/"over"                                      DoDropDown
    * held                                                    DoThrowAt

!Added to mimic "get" -- because some places say "you're not HOLDing that.."
!Also, some places say you can "carry" things, so make that a DoGet as well.
verb "hold", "collect", "carry"
    * multi                          DoGet

!Not a replacement to "look" -- just another implemenation of it.
verb "inspect"
    * object                         DoLook

!Not a replacement to "look" -- just another implemenation of it.
verb "glance"
    * "at"/"toward"/"towards"/"to" object      DoLook
    * object                                   DoLook

! This is from VerbStub, which we're not using for this game.
! Well, I've modified it some, adding "tip" for instance.
verb "push", "shove", "press", "tip"
    *                                                              DoVague
    * "on"/"against" object                                        DoPush
    * "over" object                                                DoRight    
    * object "at"/"to"/"toward"/"towards" xobject                  DoPush
    * object "over"/"down"/"against"/"under" xobject               DoPush
    * object "off"/"by"/"near"/"onto" xobject                      DoPush
    * object "over" "to"/"toward"/"towards"/"against" xobject      DoPush
    * object "over"/"upright"/"out"/"off"                          DoRight
    * object "in"/"into" container                                 DoPush
    * object "down"                                                DoRight
    * object                                                       DoPush

! Nobody will do this, but there is one bit of text referring to
! "righting the wagon" so we might as well allow for that.
verb "right"
    *                                       DoVague
    * object                                DoRight

!The one from VerbStub wasn't quite right, so using this instead. Basically,
!it's normal DoTie usage, except where we try to tie something "around" in
!which case then what we're really attempting to do is wrap the thing.
verb "tie", "lash"
    *                                       DoVague
!   * held "to"/"on"/"around" xobject       DoTie
    * object "to"/"on"/"around" xobject     DoTie
    * object "with"/"using" held            DoTieReverse
    * object                                DoTie

!If the player is really clever, they might try to lasso things with rope.
verb "lasso", "rope"
    * object                                DoLasso
    * object "with"/"using" held            DoLasso

!Because the harness can be "strapped" to things. Like DoTie, it'll re-route
!things to DoAttach if the object in question is attachable (like a rope).
!Also support a reversed variant, for attempts like "strap bull in harness".
verb "strap", "attach", "fasten", "wrap", "loop", "link", "connect", \
      "hitch", "harness", "hook", "attatch"
    *                                       DoVague
    * object "in"/"with" xobject            DoStrapReverse
!   * held "to"/"on"/"around" xobject       DoStrap
    * object "to"/"on"/"around" xobject     DoStrap
    * object                                DoStrap

verb "untie", "unlash"
    *                                       DoVague
    * object "from" "around" xobject        DoUntie
    * object "from" xobject                 DoUntie
    * object                                DoUntie

verb "unstrap", "unattach", "detach", "unfasten", "unhitch", \
     "disconnect", "unwrap", "unlink", "unharness", "unhook", "unattatch"
    *                                       DoVague
    * object "from" "around" xobject        DoUnstrap
    * object "from" xobject                 DoUnstrap
    * object                                DoUnstrap

!My attempt to make "search" verbs very robust. TONS of variations.
verb "search"
    *                                               DoVague
    * "for" anything "on"/"in"/"around" xobject     DoSearchReverse
    * "for" anything                                DoSearchReverse
    * "here" "for" anything                         DoSearchReverse
    * "around" "here" "for" anything                DoSearchReverse
    * "around" "for" anything                       DoSearchReverse
    * "under"/"underneath"/"beneath"/"below" object DoLookUnder
    * "beside"/"behind"/"around" object             DoLookBehind
    * "in"/"around" object "for" anything           DoSearch
    * "in"/"around" object "to" "find" anything     DoSearch
    * "in"/"around" object                          DoSearch
    * object "to" "find" anything                   DoSearch
    * object "for" anything                         DoSearch
    * object                                        DoSearch

!Additional ways to specify a search, using find, locate, or seek.
verb "find", "locate", "seek"
    * anything "in"/"around" xobject             DoSearchReverse
    * anything                                   DoSearchReverse

!hunt and look (in this context) refer to types of searching as well.
verb "hunt", "look"
    * "in" object "for" anything                 DoSearch
    * "for" anything "in"/"around" object        DoSearchReverse
    * "for" anything                             DoSearchReverse
    * "around" "here" "for" anything             DoSearchReverse
    * "around" "here"                            DoLookAround
    * "around" "for" anything                    DoSearchReverse

!I n the library, DoLookUnder handles "under" as well as "behind".
! In code, I could check word[2] for the proper context, but...
! It'll be easier to trap the "behind" version, and give code a
! chance to react "before" the verbroutine re-routes to DoLookUnder.
! to be sure default "look" grammar works, I'll include it entirely.
! I've also added "DoLookInside" so that if the player does something
! like "open bin" and then "look inside" it should work correctly.
! Basically, it'll take the last-used "it" object, and use DoLookIn.
!
verb "look", "l", "examine", "x", "watch"
    *                                                       DoLookAround
    * "around"                                              DoLookAround
    * "in"/"inside" container                               DoLookIn
    * "in"/"inside"                                         DoLookInside
    * "on" platform                                         DoLookIn
    * "at"/"to" object                                      DoLook
    * "out"/"through" object                                DoLookThrough
    * "under"/"underneath"/"beneath"/"below" object         DoLookUnder
    * "beside"/"behind"/"around" object                     DoLookBehind
    * object                                                DoLook

verb "jump", "leap"
    *                                                               DoJump
    * "over"/"across"/"down"/"off" "to"/"into"/"onto" object        DoJump
    * "over"/"across"/"down"/"off"/"in"/"into" object               DoJump
    * "off"/"down"                                                  DoJump
    * object                                                        DoJump

!Replaces "climb" from the "verbstub.g" file
!Added "over" and "across" as a words
!Also, we'll let DoClimb call DoVague if needed, because we need to be
!able to trap a simple "climb" for convenience, when on the trawl net.
verb "climb", "scale"
    *                                            DoClimb
    * "in"/"into"/"inside" object                DoEnter
    * "in"/"inside"                              DoEnter
    * "on"/"onto" object                         DoClimb
    * "up" object                                DoClimbUp
    * "up"                                       DoClimbUp
    * "down" object                              DoClimbDown
    * "down"                                     DoClimbDown
    * "over"/"across" object                     DoClimb
    * object                                     DoClimb

verb "ascend"
    *                                            DoClimbUp
    * "in"/"into"/"inside" object                DoEnter
    * "on"/"onto" object                         DoClimbUp
    * "up" object                                DoClimbUp
    * "up"                                       DoClimbUp
    * object                                     DoClimbUp

verb "descend"
    *                                            DoClimbDown
    * "in"/"into"/"inside" object                DoEnter
    * "on"/"onto" object                         DoClimbDown
    * "down" object                              DoClimbDown
    * "down"                                     DoClimbDown
    * object                                     DoClimbDown

!Basically, this is in case the player tries to ride an animal.
verb "ride"
    *                                           DoVague
    * "in"/"inside" object                      DoEnter
    * "on" object                               DoRide
    * object                                    DoRide

verb "listen"
    *                                            DoListen
    * "to"/"toward"/"towards"/"for" object       DoListen
    * direction                                  DoListen

verb "chase", "follow", "tail"
    *                                            DoVague
    * "after" anything                           DoChase
    * anything                                   DoChase

! Extensions to the "go" and "walk" to allow "go forward" or "go backward"
! Note that "walk after" requires "anything" because when you follow, the
! object of the verb won't be in the same room and shouldn't be prone to
! validation checks that require the object to be reachable. Also added
! the "go up object" and "go down object" aliases for climbing up or down.
! I'm also overriding "go to x" (but not "go in x") so that it calls the
! DoApproach routine, instead of the DoEnter routine. So I can trap it.
!
verb "go", "walk", "continue"
    * "forward"/"foreward"/"onward"/"ahead"/"on"   DoGoForward
    * "back"/"backward"                            DoGoBackward
    * "after" anything                             DoChase
	* "to"/"toward"/"towards" object               DoApproach
    * "up" object                                  DoClimbUp
    * "down" object                                DoClimbDown

verb "ahead", "forward", "foreward", "onward"
    *                                            DoGoForward

verb "back", "backward"
    *                                            DoGoBackward

! More extensions to "go", which apply only when on a boat. Note that
! "back" isn't used except in to/toward version, due to DoGoBackward.
! Also, can't use "a" as abbreviation for "aft" due to article "a"
! removal (unless I'm missing something simple from the library code).
!
verb "go", "walk"
    * "to"/"toward"/"towards" "f"/"fore"/"front"    DoGoBoatFore
    * "f"/"fore"/"front"                            DoGoBoatFore
    * "to"/"toward"/"towards" "aft"/"rear"/"back"   DoGoBoatAft
    * "aft"/"rear"                                  DoGoBoatAft

verb "f", "fore"
    *                                               DoGoBoatFore

verb "aft"
    *                                            DoGoBoatAft

verb "run", "hurry"
	*                                                       DoRun
	* "to"/"toward"/"at" object                             DoRun
	* direction                                             DoRun

!This is from VerbStub, which we're not using for this game.
!Extended a little to also provide an xobject and DoGetFrom.
verb "pull", "yank", "tug"
    *                                                             DoVague
    * object "over" "to" xobject                                  DoPull
    * "at"/"on" object                                            DoPull
    * object "to"/"toward"/"towards"/"over" xobject               DoPull
    * object "under"/"against"/"by"/"near" xobject                DoPull
    * object "from" "offof"/"outof"/"on"/"in" xobject             DoGetFrom
    * object "from"/"off"/"on"/"in" xobject                       DoGetFrom
    * object "offof"/"outof" xobject                              DoGetFrom
    * object                                                      DoPull

! Only because the text mentions this a few times. The player may try.
! But, it's specific and rare enough that DoPull and DoGetFrom will work.
verb "dislodge"
    *                                                             DoVague
    * object "from" xobject                                       DoGetFrom
    * object                                                      DoPull

!When dealing with the starboard wing and sail arm, it might make sense.
verb "drag"
    *                                                             DoVague
    * notheld "over" "to"/"by"/"toward"/"towards"/"near" xobject  DoPull
    * notheld "to"/"toward"/"towards"/"by"/"near" xobject         DoPull
    * notheld                                                     DoPull

!Initial "take" versions are synonymous with sleeping. But also use this
!as an opportunity to implement "take hold of x" for a DoGet action.
!Note that "of" isn't required, because it's one of those optional words.
verb "take"
    * "nap" "on"/"in"/"at" object                           DoSleep
    * "nap"                                                 DoSleep
    * "hold" notheld                                        DoGet

!This is a replacement to some library grammar dealing with getting or
!removing an object from a parent. I did something similar to this in
!Distress, but I think this is a better way. Instead of complicating the
!grammar rules, we'll simply call a "DoGetFrom" routine in these cases.
!Unless we have particular handling for particular objects (such as the
!sword in the sheath, when it's really *not* in the sheath), it'll just
!call the default DoGet and proceed as it ordinarily would have. The only
!gotcha is that since we remove the "parent" grammar token at this level,
!we have to check for it in the DoNewGet routine if xobject ~= nothing.
!This also lets us check for things "found_in" as opposed to just Parent.
verb "get", "take", "grab", "snatch", "fetch", "acquire"
    *                                                       DoVague
    * multi "from"/"off"/"on"/"in" xobject                  DoGetFrom
    * multi "offof"/"outof" xobject                         DoGetFrom
    * multi "from" "offof"/"outof"/"on"/"in" xobject        DoGetFrom
    * multi                                                 DoGet

!We also have to completely replace "remove" to do the same as "get"
verb "remove"
    *                                                       DoVague
    * multi "from"/"outof"/"offof" xobject                  DoGetFrom
    * multi                                                 DoTakeOff

!An initial version of "pick" to support "pick lock with object"
verb "pick"
    * object "with"/"using" held                            DoUnlock

!And on the off chance the user tries to "lift" sword from the sheath.
verb "pick", "lift", "raise"
    *                                                       DoVague
    * "up" multi                                            DoLift
    * "up" multi "from"/"off" xobject                       DoGetFrom
    * "up" multi "offof"/"outof" xobject                    DoGetFrom
    * multi "up"                                            DoLift
    * multi "up" "from"/"off" xobject                       DoGetFrom
    * multi "up" "offof"/"outof" xobject                    DoGetFrom
    * object "from"/"off" xobject                           DoGetFrom
    * multi                                                 DoLift

!Players may try to "lower" the handles on the barge's mast, etc.
verb "lower"
    *                                                       DoVague
    * held "in"/"into"/"down" container                     DoPutIn
    * held "on"/"onto"/"to" platform                        DoPutIn
    * object                                                DoLower

!A new verb sheathe - so that we can "sheath" and "unsheath" our sword.
!Be nice and allow "sheath" as an incorrect spelling for verb "sheathe"
verb "sheathe", "sheath", "stow", "resheath", "resheathe", "re-sheathe"
    *                                                       DoSheathe
    * (sword)                                               DoSheathe

verb "unsheathe", "unsheath", "unstow", "draw", "wield", "weild", "ready"
    *                                                       DoUnsheathe
    * (sword)                                               DoUnsheathe

!I've always wondered why there isn't a "say" verb in Hugo. My version is
!probably not the best way to do it, since I don't really *need* a "say"
!verb for this game. It probably wouldn't work right for general usage.
verb "say"
    *                                        DoVague
    * "hello"/"hi"/"howdy" "to" living       DoHello
    * "hello"/"hi"/"hi"                      DoHello
    * "yes"/"okay"/"ok" "to" living          DoYes
    * "yes"/"okay"/"ok"                      DoYes
    * "no"/"negatory"/"negative" "to" living DoNo
    * "no"/"negatory"/"negative"             DoNo
    * string "to" living                     DoSayString
    * string                                 DoSayString
    * anything                               DoSay
    * anything "to" living                   DoSay

!Also add "greet" for DoHello. Simple enough to do.
verb "greet"
    *                                       DoHello
    * living                                DoHello

!Also allow usage of a "string" in the DoTell. Replace grammar from library.
verb "tell"
    * "me" "about" anything                                 DoAskQuestion
    * living "yes"/"okay"/"ok"                              DoYes
    * living "no"/"negatory"/"negative"                     DoNo
    * living "about" string                                 DoTell
    * living "about" anything                               DoTell
    * living string                                         DoSayString

!Same situation with "talk-about". Replace and modify full default grammar.
verb "talk", "speak"
    *                                                       DoTalk
    * "to" living                                           DoTalk
    * "to" living "about" string                            DoTell !* DoTalk
    * "to" living "about" anything                          DoTell !* DoTalk
    * "about" anything                                      DoSay  !* DoAskQuestion

!Adds to "ask" (question/consult are not changed) in order to allow
!in order to accomodate the user trying to ask "for" something. Nothing in
!the game requires it, but it's better than "that doesn't make sense."
verb "ask"
    * living "for" string               DoAsk
    * living "for" anything             DoAsk

!The swordsman's only real means of communication is to nod yes, shake no,
!or point at something. We'll need verbs to accomodate that. Here they are.
verb "point", "aim", "motion"
    *                                                      DoVague
    * "my" "finger" "at"/"toward"/"towards"/"to" object    DoPoint
    * "my" "finger"                                        DoPoint
    * "finger" "at"/"toward"/"to" object                   DoPoint
    * "finger"                                             DoPoint
    * "at"/"toward"/"to" object                            DoPoint
    * direction                                            DoPoint

verb "yes"
    * living              DoYes
    *                     DoYes

verb "no"
    * living              DoNo
    *                     DoNo

verb "nod"
   *                                                               DoNodYes
   * "head" "yes"/"okay"/"ok" "to"/"toward"/"towards"/"at" living  DoNodYes
   * "yes"/"okay"/"ok" "to"/"toward"/"towards"/"at" living         DoNodYes
   * "head" "to"/"toward"/"towards"/"at" living                    DoNodYes
   * "head" "yes"/"okay"/"ok"                                      DoNodYes
   * "my" "head" "yes"/"okay"/"ok"                                 DoNodYes
   * "to"/"toward"/"towards"/"at" living                           DoNodYes
   * "my" "head"                                                   DoNodYes
   * "yes"/"okay"/"ok"                                             DoNodYes
   * "head"                                                        DoNodYes

verb "shake"
   *                                                              DoVague
   * "head" "no"/"negatory"/"negative" "to"/"toward"/"at" living  DoShakeNo
   * "no"/"negatory"/"negative" "to"/"toward"/"at" living         DoShakeNo
   * "head" "no"/"negatory"/"negative"                            DoShakeNo
   * "head" "to"/"toward"/"at" living                             DoShakeNo
   * "my" "head" "no"/"negatory"/"negative"                       DoShakeNo
   * "my" "head"                                                  DoShakeNo
   * "no"/"negatory"/"negative"                                   DoShakeNo
   * "head"                                                       DoShakeNo

! Next on the agenda are the sword actions. He's a swordsman, after all.
! A rule of thumb. If the verbroutine is DoCut and xobject=nothing, assume
! sword but don't set xobject=sword or print "(with the sword)". Just use
! DoReadySword, which will print the appropriate implied message. But, if
! the verbroutine is something else where we can imply cutting from, such
! as DoBreak or DoAttack, then we should print "(with the sword)" and set
! xobject to sword, before re-routing the command to DoCut.
!
verb "cut", "slice", "chop", "sever", "slash", "hack"
    *                                                 DoCut
    * "at"/"down"/"away" object "with"/"using" sharp  DoCut
    * "at"/"down"/"away" object                       DoCut
    * "off"/"out" object "from" xobject               DoCutOff
    * "off" object                                    DoCut
    * object "with"/"using" sharp                     DoCut
    * object "off"/"offof"/"outof"/"from" xobject     DoCutOff
    * object "off"                                    DoCut
    * object                                          DoCut

verb "stab", "poke", "pierce", "jab"
    *                                                    DoStab
    * object "with"/"using" sharp                        DoStab
    * "with"/"using" sharp                               DoStabReverse
    * sharp "at"/"toward"/"towards"/"into" xobject       DoStabReverse
    * object                                             DoStab

verb "thrust"
    *                                                    DoVague
    * sharp "at"/"toward"/"towards"/"into" xobject       DoStabReverse
    * sharp                                              DoStabReverse

verb "plunge"
    *                                          DoVague
    * sharp "at"/"into"/"in" xobject           DoStabReverse

! This has to be separated out from the other DoBlock verbs, because
! the "block" verb can also mean we want to "bar" something, and it
! wouldn't make sense for the xobject to be "sharp" in that case. So,
! I'll let the DoBar routine determine if the xobject is sharp, and
! route it into DoBlock instead. Otherwise, it's a "bar" attempt.
!
verb "block"
    *                                          DoBlock
    * "with"/"using" sharp                     DoBlockReverse
    * object "with"/"using" object             DoBar
    * object                                   DoBar

verb "fend", "ward"
    * "off"/"away" object "with"/"using" sharp  DoBlock
    * "off"/"away" object                       DoBlock
    * object "off"/"away"                       DoBlock

verb "parry", "defend", "counter", "evade", "fend"
    *                                          DoBlock
    * "with"/"using" sharp                     DoBlockReverse
    * object "with"/"using" sharp              DoBlock
    * object                                   DoBlock

verb "defend"
    * "against" object "with"/"using" sharp    DoBlock
    * "against" object                         DoBlock
    
verb "dodge", "avoid"
    *                                          DoDodge
    * object                                   DoDodge

!Player might try to "fix" the wagon using the wheel.
verb "fix", "repair", "mend"
    *                                          DoVague
    * object "with"/"using" xobject            DoRepair
    * object                                   DoRepair

!Player might try to "pour" water, or "pour" grain into the trough.
! Replaces "empty/unload" to add the "pour" and "dump" synonyms
! Adds "pour out object" and "pour object out" directives.
! The original version of this modification comes from Trading Punches.
!
verb "empty", "unload", "pour", "dump"
    *                                                       DoVague
    * container "on"/"onto" "ground"/"floor"                DoEmptyGround
    * platform "on"/"onto" "ground"/"floor"                 DoEmptyGround
    * container "out"                                       DoEmptyGround
    * "out" container                                       DoEmptyGround
    * container "in"/"into" container                       DoEmpty
    * container "on"/"onto" object                          DoEmpty

!Changing "pour object" to do a DoEmptyGround instead.
!   * container                                             DoEmpty
!   * platform                                              DoEmpty
    * container                                             DoEmptyGround
    * platform                                              DoEmptyGround

! Here's a fun new bit. This gives me the ability to ask questions such as
! "how do you intend to fix it?" and let the player reply "with the object"
!
verb "with", "using", "use"
    * object                                DoAnswerWith

verb "use"
	*                                       DoVague
	* object "with"/"on"/"in" xobject	    DoUse

!I want a little more control over the various ways to "attack" things. It'll
!be easy enough to redirect them all back to "DoHit" if there aren't any
!object.before/after or xobject.before/after handlers, but by separating them
!into different possible actions, I'll have the ability to react if needed.
!These definitions will override what's in the verblib.g from the library.
!Also, if the user specifies "with" a sharp object (the sword), I can direct
!the request into the DoCut verb instead of DoHit. I've also added a few
!more verb aliases, like "damage" and "hurt" to the mix. I've also given
!verbs "kick" and "punch" their own versions with an xobject, because it
!wouldn't otherwise make sense to say "kick object with xobject".
!
verb "break", "damage", "bust"
    *                                                       DoVague
    * object "with"/"using" held                            DoBreak
    * object                                                DoBreak

!Additional phrasings for the "break" verb.
!
verb "break", "bust"
    * "open" object "with"/"using" held                     DoBreak
    * "open" object                                         DoBreak

verb "attack", "clobber"
    *                                                       DoAttack
    * object "with"/"using" held                            DoAttack
    * object                                                DoAttack

verb "fight", "hurt", "combat", "battle"
    *                                                       DoAttack
    * object "with"/"using" held                            DoAttack
    * object                                                DoAttack

verb "kick", "trip"
    *                                                       DoKick
    * object                                                DoKick

verb "punch", "slap"
    *                                                       DoPunch
    * object                                                DoPunch

verb "swing"
    *                                                       DoVague
!!! * held                                                  DoHitReverse
    * held "at"/"toward"/"towards" xobject                  DoHitReverse

verb "hit", "strike", "whack", "beat", "smack", "bash"
    *                                                           DoHit
    * object "with"/"using" "my" "fist"/"fists"/"hand"/"hands"  DoPunch
    * object "with"/"using" "fist"/"fists"/"hand"/"hands"       DoPunch
    * object "with"/"using" held                                DoHit
    * object                                                    DoHit

verb "kill", "murder", "slay"
    *                                                       DoKill
    * object "with"/"using" held                            DoKill
    * object                                                DoKill

!Shaking the gate, shaking the apple tree, and so forth.
verb "shake", "rattle", "jiggle"
    *                                                       DoVague
    * object                                                DoShake

!There are a few places where scents are mentioned. It's said that deaf
!people get stronger senses to compensate for the loss (or is that said of
!blind people?) so we might as well go all out on smelling and sniffing.
verb "smell", "sniff"
    *                                                       DoSniff
    * "around" "here"                                       DoSniff
    * "here"/"around"                                       DoSniff
    * object                                                DoSniff

!We refer in one spot to rocking and sliding the cask. In case this makes
!player think they can do that elsewhere, let's equate those things to MOVE.
!Also, for supporting "slide beam into cleats" I'm doing a DoPutIn alias.
verb "move", "rock", "slide"
    *                                                             DoVague
    * object "over" "to"/"toward"/"towards"/"by" xobject          DoMove
    * object "over"/"off"                                         DoMove
    * object "at"/"to"/"toward"/"towards"/"by"/"near" xobject     DoMove
    * object "under"/"against" xobject                            DoMove
    * held "in"/"into" container                                  DoPutIn
    * held "on"/"onto" platform                                   DoPutIn
    * "off"/"over" object                                         DoMove
    * object                                                      DoMove

verb "arrange", "organize", "position", "stack", "lean"
    *                                                          DoVague
    * object "near"/"by"/"at"/"on"/"against"/"under" xobject   DoArrange
    * object                                                   DoArrange

! This is unchanged, from verblib.g. I include it here for reference,
! since there is some initial phrasing that goes on for "DoArrange".
! And, it has to come before the "DoArrange" version, to work right.
! Okay, not entirely unchanged. I added the "stand on" verb.
verb "stand"
    *                                                       DoStand
    * "up"                                                  DoStand
    * "on"/"in" object                                      DoStandOn

verb "prop", "stand"
    *                                                       DoVague
    * object "up" "on"/"near"/"at"/"by"/"against" xobject   DoArrange
    * object "on"/"near"/"by"/"against" xobject             DoArrange
    * object                                                DoRight

verb "step"
    *                                                       DoVague
    * "up"                                                  DoClimbUp
    * "down"                                                DoClimbDown
    * "on" object                                           DoStandOn
    
!This replaces "turn" from the library, so that we can "turn" things that
!aren't switchable. We'll check for it in our DoTurn routine.
!interfere with the default "turn" for switchables from the verb library.
!
verb "turn"
    *                                                       DoVague
    * "around" object                                       DoTurn
    * "over" object                                         DoRight
    * object "around"                                       DoTurn
    * object "over"                                         DoRight
    * object                                                DoSwitchOnOff

verb "twist", "rotate", "crank"
    *                                                       DoVague
    * object "around"                                       DoTurn
    * object                                                DoTurn

verb "wind"
    *                                                       DoVague
    * object "to"/"around" xobject                          DoStrap
    * object                                                DoWind

verb "unwind"
    *                                                       DoVague
    * object "from" "around" xobject                        DoUnstrap
    * object "from"/"around" xobject                        DoUnstrap
    * object                                                DoUnwind

!Because at one point we tell the player "unless you intend to excite it..."
verb "excite", "anger", "annoy", "antagonize", "provoke"
    *                                                       DoVague
    * living                                                DoProvoke

!Original definition was in VerbStub, which isn't included.
verb "touch", "tap", "pat"
    *                                             DoVague
    * object "with"/"using" held                  DoTouch
    * object                                      DoTouch

verb "feel", "rub", "pet"
    * object                                      DoTouch

!The only reason I'm including this is to make "inventory" an xverb, so
!that it won't take up a turn by default. There is also a "take inventory"
!variation, but since I doubt anybody uses it, I'm not going to include it.
xverb "inventory", "inv", "i"
    *                                                       DoInventory
    * "wide"/"tall"                                         DoInventory

!Let the user switch back and forth between default style and custom style.
xverb "style", "theme"
    *                                                   DoStyleThemes
    * string                                            DoStyleString
    * "normal"/"default"/"old"/"original"/"blue"        DoStyleNormal
    * "custom"/"swordsman"/"tales"/"new"/"white"        DoStyleCustom

!Doing away with "superbrief" mode (it's still in the lib verbs, but the
!game will say "you can't do that" now) and making "short" go to "brief".
!Also adding "terse" as a verb for short descriptions.
xverb "brief", "breif", "normal", "terse", "short"
    *                                                   DoBrief

!This comes from the library. Slight modifications for Swordsman. Basically,
!I added "let go of multi" as a variation, and "xobject" variations too.
!
verb "let"
    * "go" "of" multi "above"/"over" xobject                DoDropDown
    * "go" "of" multi                                       DoDrop
    * "go" multi "above"/"over" xobject                     DoDropDown
    * "go" multi                                            DoDrop
    * "down" object                                         DoLower
    * living "have" held                                    DoGiveReverse
    * object "down"                                         DoLower
    * multi "go" "above"/"over" xobject                     DoDropDown
    * multi "go"                                            DoDrop

!This comes from the library. Slight modifications for Swordsman. Basically,
!I want to trap trying to drop something "over" or "down" something as well.
!
verb "drop"
    *                                                       DoVague
    * multiheld "over"/"down" xobject                       DoDropDown
    * multiheld "over"/"down"                               DoDropDown
    * multiheld "on"/"onto" "ground"/"floor"                DoPutonGround
    * multiheld "outside" xobject                           DoPutonGround
    * multiheld "in"/"into"/"inside" container              DoPutIn
    * multiheld "on" platform                               DoPutIn
    * multiheld                                             DoDrop

!This is the preferred verb for barring the barn door, but other verbs are
!going to route into it as needed (DoLock, DoPutIn, DoBlock, etc).
!Also allow for a variety of misspellings, just in case players do that.
verb "bar", "barr", "barricade", "baricade", "barracade", "baracade"
    *                                                       DoVague
    * held "to"/"on" xobject                                DoBarReverse
    * object "with"/"using" held                            DoBar
    * object                                                DoBar

!If I support block/bar, then I'm going to have to support unblock/unbar.
verb "unbar", "unblock"
    *                                                       DoVague
    * object "from"/"off"/"offof" xobject                   DoUnbarReverse
    * object "with"/"using" held                            DoUnbar
    * object                                                DoUnbar

!When chasing the girl, some clues tell the player to trap or corner the
!girl in the barn. If taken literally, players may believe their goal is to
!"trap girl" or "corner girl" while inside the barn. So, allow for attempts.
verb "trap", "corner", "capture"
    *                                                       DoVague
    * living "in"/"at"/"by"/"near"/"with"/"using" xobject   DoTrap
    * living                                                DoTrap

! Looks like I'm going to end up replacing most of the default verbs.
! In this case, I want to extend "open" and "close" to allow xobjects,
! in which case the command gets routed as a DoUnlock and DoLock attempt.
verb "open"
	*                                                       DoVague
	* lockable "with"/"using" held                          DoUnlock
	* openable                                              DoOpen

verb "close", "shut"
	*                                                       DoVague
	* lockable "with"/"using" held                          DoLock
	* openable                                              DoClose

! Here's a new verb, for when the player tries to pry something open.
verb "pry", "lever"
    *                                                       DoVague
    * "open" openable "with"/"using" held                   DoPry
    * "open" openable                                       DoPry
    * openable "open" "with"/"using" held                   DoPry
    * openable "open"                                       DoPry
    * openable "with"/"using" held                          DoPry
    * openable                                              DoPry

! A new verb, for handling the player's attempt to "sleep" somewhere.
verb "sleep", "rest", "nap"
    *                                                       DoSleep
    * "in"/"on"/"at" object                                 DoSleep
    
! A new verb, created because of the wings and slots in Part 2.
! Skipping the "from xobject" version, because it's just too confusing.
! Things that are "at" certain places may not be "in", and, yeah, well.
!
verb "release", "unclamp"
    *                                                       DoVague
!   * object "from" xobject                                 DoRelease
    * object                                                DoRelease

! Default in Hugo libs is that "Give" doesn't require a held item. It may
! be because we can direct NPC's like "man, give me thing", but I don't
! know. For this game, I don't want to have to check that the player is
! holding everything he tries to give to an NPC, so I'm adding the "held"
! as a restriction in the verb defs, replacing what was in the library.
verb "give", "hand", "offer", "pass"
    *                                                       DoVague
    * "me" object                                           DoGive
    * held "to" xobject                                     DoGive
    * held                                                  DoGive

! This is for hanging the net on the fishing hooks, as an alternative to a
! simple "put net on hooks" command.
!
verb "hang", "drape"
    *                                                       DoVague
    * held "on"/"from"/"by"/"over" xobject                  DoHang
    * held                                                  DoHang
    
verb "water"
    *                                                       DoVague
    * object                                                DoWater
    * object "with"/"using" held                            DoWater
    
!Adding this because some players think they need to "approach" things.
verb "approach"
	*							                            DoVague
	* object                                                DoApproach
	
!Due to the demands of beta testers :) I am adding an "exits" verb.
xverb "exits"
    *                                                       DoExits

!Here's another thing that lots of testers tried. Going to support it.
verb "frighten", "scare", "startle"
    *                                                   DoVague
    * living                                            DoScare
