/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"
#include "lang.h"

int listedobjects,objectlist [200],said,subject;
bool all,speechflag;
char *yaccstring;
int direction,yaccplayer;

static char adjectives [4] [20];
static int numadjectives;

static int getnpc(int what)
{
  int oldwhat;

  do {
    oldwhat = what;
    what = objects [what].parent;
  } while((! objects [what].objtype.alive || objects [what].next == oldwhat
	   || objects [what].objtype.player)
	&& ! objects [what].objtype.room);
  if(objects [what].objtype.alive) return what;
  return 0;
}

static bool heldbynpc(int what)
{
  return getnpc(what) != 0;
}

extern void moveplayer(void)
{
  int playerroom = getroom(yaccplayer),dest;
  bool failquietly = FALSE;

  switch(direction)
  {
  case NORTH:
    dest = objects [playerroom].n;
    break;
  case SOUTH:
    dest = objects [playerroom].s;
    break;
  case WEST:
    dest = objects [playerroom].w;
    break;
  case EAST:
    dest = objects [playerroom].e;
    break;
  case NORTHWEST:
    dest = objects [playerroom].nw;
    break;
  case NORTHEAST:
    dest = objects [playerroom].ne;
    break;
  case SOUTHWEST:
    dest = objects [playerroom].sw;
    break;
  case SOUTHEAST:
    dest = objects [playerroom].se;
    break;
  case UP:
    dest = objects [playerroom].u;
    break;
  case DOWN:
    dest = objects [playerroom].d;
    break;
  default:
    fail();
  }
  if(dest != 0) failquietly = TRUE;
  dest = premove(yaccplayer,dest);
  if(dest == 0) {
    if(! failquietly) format("You don't seem to be able to get through that "
"way.");
  } else {
    if(! illuminated(getroom(yaccplayer)) && ! illuminated(dest)) {
      format("\nYou got eaten by the giant spider in the dark.  Sorry.\n");
      dead = TRUE;
    } else {
      detachfromchain(yaccplayer);
      objects [yaccplayer].next = objects [dest].inside;
      objects [yaccplayer].parent = dest;
      if(objects [dest].inside != 0) objects [objects [dest].inside].parent = yaccplayer;
      objects [dest].inside = yaccplayer;
      descr = TRUE;
    }
  }
  postmove();
}

extern bool strcmp_ci(char *a,char *b)
{
  while(tolower(*a) == tolower(*b))
  {
    if(*a == 0) return TRUE;
    a++;
    b++;
  }
  return FALSE;
}

extern int rnd(int range)
{
  return ((rand() & 0xffff) * range) >> 16;
}

extern void yyerror(char *s)
{
  switch(rnd(3))
  {
  case 0:
    format("Eh?");
    break;
  case 1:
    format("You're mumbling again.");
    break;
  case 2:
    format("Come again?");
    break;
  }
}

extern void command(int player,char *string)
{
  static char *oldline;

  if(oldline != 0) free(oldline);
  yaccstring = oldline = xmalloc(strlen(string) + 1);
  strcpy(yaccstring,string);
  yaccplayer = player;
  listedobjects = 0;
  numadjectives = 0;
  speechflag = FALSE;
  all = FALSE;
  yyparse();
}

extern void addadjective(char *adj)
{
  if(numadjectives != 4) strcpy(adjectives [numadjectives++],adj);
}

extern void addobject(int objectno)
{
  if(objectno != -1) {
    if(ispresent(objectno,yaccplayer)) objectlist [listedobjects++] = objectno;
    else format("I can't see %s anywhere near here.",quickname("the",objectno));
  }
  else format("I don't know anything like that (1)!");
  numadjectives = 0;
}

static void addchain(int this)
{
  while(this != 0)
  {
    objectlist [listedobjects++] = this;
    this = objects [this].next;
  }
}

extern void addfirstdescendants(int parent)
{
  addchain(objects [parent].above);
  addchain(objects [parent].below);
  addchain(objects [parent].inside);
}

static bool checkadjectives(char *name)
{
  int i;
  char buffer [20];

  for(i = 0;i < numadjectives;i++)
  {
    sprintf(buffer,"_%s_",adjectives [i]);
    if(! strstr(name,buffer) && strncmp(name,buffer + 1,strlen(buffer + 1))) return FALSE;
  }

  return TRUE;
}

extern int getobject(char *noun)
{
  int i,result = -1;
  char *objectname = noun,*a = "a",*extras = "";
  bool goodmatch = FALSE;

  while(strchr(objectname,' ')) objectname = strchr(objectname,' ') + 1;
  for(i = 0;objectname [i] != 0;i++) objectname [i] = tolower(objectname [i]);

  for(i = 0;objects [i].examine != (char *) 1;i++)
  {
    if(objects [i].shortname != 0) {
      if(strlen(objects [i].shortname) >= strlen(noun)) {
	if(strcmp_ci(objects [i].shortname + strlen(objects [i].shortname) - strlen(noun),noun)) {
	  if(checkadjectives(objects [i].shortname)) {
	    goodmatch = TRUE;
	    extras = "";
	    if(ispresent(i,yaccplayer) || speechflag) {
	      if(heldbynpc(i) && ! speechflag) {
		format("%s won't let you do anything with that.",quickname("The",getnpc(i)));
		return -1;
	      } else result = i;
	    } else {
	      objectname = quickname("",i);
	    }
	  } else {
	    if(! goodmatch) extras = " like that";
	  }
	}
      }
    }
  }
  if(result == -1) {
    if(strchr("aeiou",tolower(objectname [0]))) a = "an";
    format("I can't see %s %s%s here.",a,objectname,extras);
  }
  numadjectives = 0;
  return result;
}

extern char *quickname(char *newword,int i)
{
  static char buffer [32];
  char *a = strchr(objects [i].longname,' ');

  if(a == 0) return objects [i].longname;
  else sprintf(buffer,"%s %s",newword,a + 1);

  return *newword == 0 ? buffer + 1 : buffer;
}

extern bool ispresent(int this,int player)
{
  return getroom(this) == getroom(player);
}

extern void examine(void)
{
  int i;

  for(i = 0;i < listedobjects;i++)
  {
    format("%s\n",objects [objectlist [i]].examine);
  }
  listedobjects = 0;
}

extern void do_read(void)
{
  int i;

  for(i = 0;i < listedobjects;i++)
  {
    switch(objectlist [i])
    {
    case 102: /* scroll */ case 123: /* card */
      format("%s\n",objects [objectlist [i]].examine);
      break;
    default:
      format("You can't read that!");
      break;
    }
  }
  listedobjects = 0;
}

extern void get(void)
{
  int i;
  bool gotsomething = FALSE;

  if(all) addfirstdescendants(getroom(yaccplayer));
  for(i = 0;i < listedobjects;i++)
  {
    if(objects [objectlist [i]].objtype.virtual == FALSE) {
      detachfromchain(objectlist [i]);
      addtochain(objectlist [i],yaccplayer,& objects [yaccplayer].inside);
      gotsomething = TRUE;
      format("You take %s.",quickname("the",objectlist [i]));
    } else {
      if(! objects [objectlist [i]].objtype.player)
	format("You can't take %s!",quickname("the",objectlist [i]));
    }
  }
  listedobjects = 0;
  if(all && ! gotsomething) format("There is nothing here that you can reall"
"y take!");
}

extern void drop(void)
{
  int i;
  bool gotsomething = FALSE;

  if(all) addfirstdescendants(yaccplayer);
  for(i = 0;i < listedobjects;i++)
  {
    if(ancestor(yaccplayer,objectlist [i])) {
      detachfromchain(objectlist [i]);
      addtochain(objectlist [i],getroom(yaccplayer),& objects [getroom(yaccplayer)].inside);
      gotsomething = TRUE;
      format("You drop %s.",quickname("the",objectlist [i]));
    } else {
      if(! all) format("You are not carrying %s!",quickname("the",objectlist [i]));
    }
  }
  if(all && ! gotsomething) format("You are not carrying anything!");
  listedobjects = 0;
}

extern void put(int destination,int *chain)
{
  int i;
  bool gotsomething = FALSE;

  if(!objects [destination].objtype.container && chain == & objects [destination].inside) {
    format("You won't be able to put things in that very easily!\n");
    return;
  }

  if(all) addfirstdescendants(yaccplayer);
  for(i = 0;i < listedobjects;i++)
  {
    if(! objects [objectlist [i]].objtype.virtual) {
      detachfromchain(objectlist [i]);
      addtochain(objectlist [i],destination,chain);
      gotsomething = TRUE;
      format("You put %s in position.",quickname("the",objectlist [i]));
      justput(objectlist [i],destination,chain);
    } else {
      if(! all) format("You can't move %s!",quickname("the",objectlist [i]));
    }
  }
  if(all && ! gotsomething) format("You are not carrying anything!");
  listedobjects = 0;
}

extern void give(int destination)
{
  int i;
  bool gotsomething = FALSE;

  if(all) addfirstdescendants(yaccplayer);
  for(i = 0;i < listedobjects;i++)
  {
    if(ispresent(yaccplayer,objectlist [i])) {
      if(wantsit(destination,objectlist [i])) gotsomething = TRUE;
    } else {
      if(! all) format("You are not carrying %s!",quickname("the",objectlist [i]));
    }
  }
  if(all && ! gotsomething) format("You are not carrying anything!");
  listedobjects = 0;
}

extern int getbeastie()
{
  int posn = objects [getroom(yaccplayer)].inside;

  while(posn != 0 && (! objects [posn].objtype.alive || objects [posn].objtype.player))
    posn = objects [posn].next;
  return posn;
}

extern void speech(int recipient,int type)
{
  if(! ispresent(recipient,player)) {
    format("You can't see anything like that near here!");
    return;
  }

  if(! objects [recipient].objtype.alive) {
    format("Strangely enough, %s takes no notice of you!",quickname("the",recipient));
    return;
  }

  if(type == 0 && said == 1) {
    type = 1;
    objectlist [0] = subject;
    listedobjects = 1;
  }

  if(type == 0) {
    switch(said)
    {
    case 0:
      if(! dogreeting(recipient)) format("%s says, 'Hello!'",quickname("The",recipient));
      break;
    case 2:
      doyes(recipient);
      break;
    case 3:
      dono(recipient);
      break;
    case 4:
      if(! dofarewell(recipient)) format("%s says, 'Goodbye!'",quickname("Th"
"e",recipient));
      break;
    case 5:
      if(! referred_to(recipient)) format("%s says, 'You what?!'",quickname("The",recipient));
      break;
    default:
      fail();
    }
  } else {
    int i;
    bool gotsomething = FALSE;

    if(all) addfirstdescendants(getroom(recipient));
    for(i = 0;i < listedobjects;i++)
    {
      if(ancestor(getroom(recipient),objectlist [i])) {
	examineobject(recipient,objectlist [i]);
      } else {
	if(! all) format("%s says 'What ever's that?'",quickname("The",recipient));
      }
    }
    if(all && ! gotsomething) format("%s says 'I can't see anything!'",quickname("The",recipient));
    listedobjects = 0;
  }
}

extern void hack(void)
{
  char *password = "";

  format("So you want to hack the game, for debugging of course... now enter"
" the password:\n");
  if(! hacker) password = getline(">",LINE_NO_HISTORY);
  if(strcmp_ci(password,"tarnisher") || hacker) {
    int dest;

    format("Which room do you want?\n");
    dest = atoi(getline(">",LINE_NO_HISTORY));
    detachfromchain(yaccplayer);
    objects [yaccplayer].next = objects [dest].inside;
    objects [yaccplayer].parent = dest;
    if(objects [dest].inside != 0) objects [objects [dest].inside].parent = yaccplayer;
    objects [dest].inside = yaccplayer;
    descr = TRUE; 
    hacker = TRUE;
  } else format("Wrong password");
}

extern void destroy(int what)
{
  detachfromchain(what);
  /* Now make the object hang off the storage room.  It is not a good idea to make it hang off the
     root, because then we can't go and look at anything (looking in the root object doesn't
     work).  */
  addtochain(what,59,& objects [59].inside);
}
