/*
 *      ADVDEF.H - #defines and typedefs for Adventure
 *      (C) 1986 Ravi Bhavnani
 *      All rights reserved
 *
 *      4 more #defines available due to cls() fix in advinit.c 2/14/87
 */

#ifndef _AdvDef_h_
#define _AdvDef_h_

#include "stdio.h"
#include "ctype.h"
#include "errno.h"
#include "time.h"

#include "Messages.h"
#include "Places.h"
#include "Objects.h"
#include "Vocab.h"

#define SIGNATURE   "AdvRaviB"      // game signature
#define MAJOR		    7               // major version
#define MINOR		    0		            // minor version

// VARIOUS MACROS

#define apport( obj, loc )    gc.m_nWhereIs [obj] = loc
#define apportHere( obj )     gc.m_nWhereIs [obj] = gc.m_nHere
#define at( loc )             (gc.m_nHere == loc)
#define carrying( obj )       (gc.m_nWhereIs [obj] == inhand)
#define dropIt( obj )         gc.m_nWhereIs [obj] = gc.m_nHere
#define forever               while (true)
#define getIt( obj )          gc.m_nWhereIs [obj] = inhand
#define isDirection( foo )    ((foo >= MINDIR) && (foo <= MAXDIR))
#define isMagic( foo )        ((foo >= MINMAGIC) && (foo <= MAXMAGIC))
#define isObject( foo )       ((foo == all) || ((foo >= MINOBJECTS) && (foo <= MAXOBJECTS)))
#define isPlace( foo )        ((foo >= MINPLACE) && (foo <= MAXPLACE))
#define isVerb( foo )         ((foo >= MINACTION) && (foo <= MAXACTION))
#define isUtil( foo )         ((foo >= MINUTIL) && (foo <= MAXUTIL))
#define near( obj )           ((gc.m_nWhereIs [obj] == inhand) || (gc.m_nWhereIs [obj] == gc.m_nHere))

// VARIOUS ERRORS

#define ERR_CANT_OPEN_FILE              1
#define ERR_INVALID_DATAFILE_ENTRY      2
#define ERR_TOO_MANY_ENTRIES            3
#define ERR_OUT_OF_MEMORY_READ_FILE     4
#define ERR_DESCRIBE_OBJECT             5
#define ERR_DESCRIBE_OBJECT_INVEN       6
#define ERR_DESCRIBE_PLACE              7
#define ERR_SAY_MESSAGE                 8
#define ERR_SAY_MESSAGE_TEXT            9
#define ERR_SAY_MESSAGE_VALUE           10
#define ERR_SAY_MESSAGE_UNKNOWN_WORD    11
#define ERR_SAY_UNKNOWN_MESSAGE_WORD    12

////////////////////
// Various constants

#define MAX_OBJECT_STATES   32      // max # states of an object

#define WORDLEN		          16      // max size of vocabulary word
#define STRINGLEN           256     // max size of char string

#define MAXDEMO		          50      // length of demo game
#define MAXGAME		          1000    // length of normal game
#define DETAIL		          3       // long descriptions said every so often 
#define MAXDIE		          3       // max # of reincarnations allowed
#define MAXRETORT	          10      // max # of different retorts to obscenities
#define HINTCOST	          5       // cost of a hint

//////////////////
// Data structures

typedef char STRING [STRINGLEN];    // generic char string

typedef struct _textLines
  {
    char*               pszText;  // text string
    struct _textLines*  pNext;    // next text line
  } TEXTLINES;

typedef TEXTLINES*  PTR_TEXTLINES;

typedef struct _objectDescriptor
  {
    char*           pszInventory;                           // inventory description
    long            nStates;                                // # states
    PTR_TEXTLINES   stateDescriptions [MAX_OBJECT_STATES];  // state descriptions
  } OBJECT_DESCRIPTOR;


#endif

// End AdvDef.h
