#include "glk.h"

#include "miscfort.h"
#include "funcs.h"

/* This file contains some functions which Fortran expects to be built in.
    Remember, Fortran strings are fixed-width and padded with spaces. */

void s_copy(char *a, char *b, ftnlen la, ftnlen lb)
{
    char *aend, *bend;

    aend = a + la;

    if (la <= lb) {
        if (a <= b || a >= b + la)
            while(a < aend)
                *a++ = *b++;
        else
            for(b += la; a < aend; )
                *--aend = *--b;
    }
    else {
        bend = b + lb;
        if (a <= b || a >= bend)
            while(b < bend)
                *a++ = *b++;
        else {
            a += lb;
            while(b < bend)
                *--a = *--bend;
            a += lb;
        }
        while(a < aend)
            *a++ = ' ';
    }
}

void s_cat(char *lp, char *rpp[], ftnlen rnp[], ftnlen *np, ftnlen ll)
{
    /* This implementation does not handle the case where lp overlaps one of the
        rp strings. This is acceptable for all the uses of s_cat in Dungeon, but
        don't try to use it for Fortran in general. */
    ftnlen i, nc;
    char *rp;
    ftnlen n = *np;
    ftnlen L, m;
    char *lp1;

    lp1 = lp;
    L = ll;
    i = 0;
    while(i < n) {
        rp = rpp[i];
        m = rnp[i++];
        if (rp >= lp1 || rp + m <= lp) {
            if ((L -= m) <= 0) {
                n = i;
                break;
            }
            lp1 += m;
            continue;
        }
        glk_exit(); /* Bail */
    }
    lp1 = lp;
    for(i = 0 ; i < n ; ++i) {
        nc = ll;
        if(rnp[i] < nc)
            nc = rnp[i];
        ll -= nc;
        rp = rpp[i];
        while(--nc >= 0)
            *lp++ = *rp++;
    }
    while(--ll >= 0)
        *lp++ = ' ';
}

integer s_cmp(char *a0, char *b0, ftnlen la, ftnlen lb)
{
    unsigned char *a, *aend, *b, *bend;
    a = (unsigned char *)a0;
    b = (unsigned char *)b0;
    aend = a + la;
    bend = b + lb;

    if (la <= lb) {
        while (a < aend)
            if (*a != *b)
                return ( *a - *b );
            else
                { ++a; ++b; }

        while (b < bend)
            if (*b != ' ')
                return ( ' ' - *b );
            else     
                ++b;
    }
    else {
        while (b < bend)
            if (*a == *b)
                { ++a; ++b; }
            else
                return ( *a - *b );
        while (a < aend)
            if (*a != ' ')
                return (*a - ' ');
            else    
                ++a;
    }
    return 0;
}

integer i_indx(char *a, char *b, ftnlen la, ftnlen lb)
{
    ftnlen i, n;
    int found;
    char *s, *t, *bend;

    n = la - lb + 1;
    bend = b + lb;

    for (i = 0 ; i < n ; ++i) {
        s = a + i;
        t = b;
        found = TRUE_;
        while (t < bend) {
            if (*s++ != *t++) {
                found = FALSE_;
                break;
            }
        }
        if (found)
            return (i+1);
    }
    return(0);
}

integer i_len(char *s, ftnlen n)
{
    return n;
}

void v_set(void *a, ftnlen la, char val)
{
    char *ptr = a;
    ftnlen ix;
    for (ix=0; ix<la; ix++)
        ptr[ix] = val;
}

