/* Clock events, demons, actors for DUNGEON. */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 27-Sep-94     RMS     Fixed bugs in thief demon, fight demon, master actor, */
/*                       robot actor, dead player, balloon, bell. */
/* 30-Jan-94     RMS     Fixed bugs from MS DOS port. */
/* 18-Jan-94     RMS     Fixed bug in dead player recovery. */
/* 01-Jul-92     RMS     Removed extraneous function from CEVAPP. */
/* 30-Jun-92     RMS     Changed file names to lower case. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* CLOCKD- Intermove clock events demon */

/* Declarations */

logical clockd_(integer *x)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = FALSE_;
/* assume no action. */
    i__1 = cevent_1.clnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (! cevent_1.cflag[i__ - 1] || cevent_1.ctick[i__ - 1] == 0) {
            goto L100;
        }
        if (cevent_1.ctick[i__ - 1] < 0) {
            goto L50;
        }
/* permanent entry? */
        --cevent_1.ctick[i__ - 1];
        if (cevent_1.ctick[i__ - 1] != 0) {
            goto L100;
        }
/* timer expired? */
L50:
        ret_val = TRUE_;
        cevapp_(&cevent_1.cactio[i__ - 1]);
/* do action. */
L100:
        ;
    }
    return ret_val;

} /* clockd_ */



/* CEVAPP- Clock event applicables */

/* Declarations */

/* Subroutine */ int cevapp_(integer *ri)
{
    /* Initialized data */

    static integer cndtck[10] = { 50,20,10,5,0,156,156,156,157,0 };
    static integer lmptck[12] = { 50,30,20,10,4,0,154,154,154,154,155,0 };

    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    logical f;
    logical waslit;
    integer i__;
    integer br, bc;
    integer j;


/* Functions and data */


    if (*ri == 0) {
        return 0;
    }
/* ignore disabled. */
    waslit = lit_(&play_1.here);
    switch (*ri) {
        case 1:  goto L1000;
        case 2:  goto L2000;
        case 3:  goto L3000;
        case 4:  goto L4000;
        case 5:  goto L5000;
        case 6:  goto L6000;
        case 7:  goto L7000;
        case 8:  goto L8000;
        case 9:  goto L9000;
        case 10:  goto L10000;
        case 11:  goto L11000;
        case 12:  goto L12000;
        case 13:  goto L13000;
        case 14:  goto L14000;
        case 15:  goto L15000;
        case 16:  goto L16000;
        case 17:  goto L17000;
        case 18:  goto L18000;
        case 19:  goto L19000;
        case 20:  goto L20000;
        case 21:  goto L21000;
        case 22:  goto L22000;
        case 23:  goto L23000;
        case 24:  goto L24000;
        case 25:  goto L25000;
        case 26:  goto L26000;
        case 27:  goto L27000;
        case 28:  goto L28000;
        case 29:  goto L29000;
        case 30:  goto L30000;
    }
    bug_(&c__3, ri);

/* Return here to test for change in light. */

L50:
    if (waslit && ! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
    return 0;
/* CEVAPP, PAGE 2 */

/* CEV1--        Cure clock.  Let player slowly recover. */

L1000:
/* Computing MIN */
    i__1 = 0, i__2 = advs_1.astren[0] + 1;
    advs_1.astren[0] = min(i__1,i__2);
/* recover. */
    if (advs_1.astren[0] >= 0) {
        return 0;
    }
/* fully recovered? */
    cevent_1.cflag[0] = TRUE_;
    cevent_1.ctick[0] = 30;
/* no, wait some more. */
    return 0;

/* CEV2--        Maint-room with leak.  Raise the water level. */

L2000:
    if (play_1.here == 100) {
        i__1 = findex_1.rvmnt / 2 + 71;
        rspeak_(&i__1);
    }
/* describe. */
    ++findex_1.rvmnt;
/* raise water level. */
    if (findex_1.rvmnt <= 16) {
        return 0;
    }
/* if not full, exit. */
    cevent_1.ctick[1] = 0;
/* full, disable clock. */
    rooms_1.rflag[99] = rooms_1.rflag[99] | 256;
/* mung room. */
    rooms_1.rdesc1[99] = 80;
/* say it is full of wate */
    if (play_1.here == 100) {
        jigsup_(&c__81);
    }
/* drown him if present. */
    return 0;

/* CEV3--        Lantern.  Describe growing dimness. */

L3000:
    litint_(&c__15, &findex_1.orlamp, &c__3, lmptck, &c__12);
/* do light interrupt. */
    goto L50;

/* CEV4--        Match.  Out it goes. */

/* go see if now dark. */
L4000:
    rspeak_(&c__153);
/* match is out. */
    objcts_1.oflag1[50] = objcts_1.oflag1[50] & -74;
    goto L50;

/* CEV5--        Candle.  Describe growing dimness. */

/* go see if now dark. */
L5000:
    litint_(&c__48, &findex_1.orcand, &c__5, cndtck, &c__10);
/* do candle interrupt. */
    goto L50;
/* CEVAPP, PAGE 3 */

/* CEV6--        Balloon. */

/* go see if now dark. */
L6000:
    cevent_1.cflag[5] = TRUE_;
    cevent_1.ctick[5] = 3;
/* reschedule interrupt. */
    f = advs_1.avehic[play_1.winner - 1] == 98;
/* see if in balloon. */
    if (play_1.bloc == 126) {
        goto L6800;
    }
/* at bottom? */
    if (play_1.bloc == 131 || play_1.bloc == 132 || play_1.bloc == 133) {
        goto L6700;
    }
/* on ledge? */
    if ((objcts_1.oflag2[c__99 - 1] & 8) != 0 && findex_1.binff != 0) {
        goto L6500;
    }

/* Balloon is in midair and is deflated (or has receptacle closed). */
/* Fall to next room. */

/* inflated and recep ope */
    if (play_1.bloc != 127) {
        goto L6300;
    }
/* in vair1? */
    play_1.bloc = 126;
/* yes, now at vlbot. */
    newsta_(&c__98, &c__0, &play_1.bloc, &c__0, &c__0);
    if (f) {
        goto L6200;
    }
/* in balloon? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133 || 
            play_1.here == 126) {
        rspeak_(&c__530);
    }
/* if can see, describe. */
    return 0;

L6200:
    f = moveto_(&play_1.bloc, &play_1.winner);
/* move him. */
    if (findex_1.binff == 0) {
        goto L6250;
    }
/* in balloon.  inflated? */
    rspeak_(&c__531);
/* yes, landed. */
    f = rmdesc_(&c__0);
/* describe. */
    return 0;

L6250:
    newsta_(&c__98, &c__532, &c__0, &c__0, &c__0);
/* no, balloon & contents */
    newsta_(&c__113, &c__0, &play_1.bloc, &c__0, &c__0);
/* insert dead balloon. */
    if (prssta_1.lastit == 98) {
        prssta_1.lastit = 113;
    }
/* fix last it reference. */
    advs_1.avehic[play_1.winner - 1] = 0;
/* not in vehicle. */
    cevent_1.cflag[5] = FALSE_;
/* disable interrupts. */
    cevent_1.cflag[6] = FALSE_;
    return 0;

L6300:
    --play_1.bloc;
/* not in vair1, descend. */
    newsta_(&c__98, &c__0, &play_1.bloc, &c__0, &c__0);
    if (f) {
        goto L6400;
    }
/* is he in balloon? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133 || 
            play_1.here == 126) {
        rspeak_(&c__533);
    }
/* if can see, describe. */
    return 0;

L6400:
    f = moveto_(&play_1.bloc, &play_1.winner);
/* in balloon, move him. */
    rspeak_(&c__534);
/* describe. */
    f = rmdesc_(&c__0);
    return 0;

/* Balloon is in midair and is inflated, up-up-and-away! */

L6500:
    if (play_1.bloc != 130) {
        goto L6600;
    }
/* at vair4? */
    cevent_1.cflag[6] = FALSE_;
/* disable interrupts. */
    cevent_1.cflag[5] = FALSE_;
    findex_1.binff = 0;
    play_1.bloc = 126;
/* fall to bottom. */
    newsta_(&c__98, &c__0, &c__0, &c__0, &c__0);
/* balloon & contents die */
    newsta_(&c__113, &c__0, &play_1.bloc, &c__0, &c__0);
/* substitute dead balloo */
    if (prssta_1.lastit == 98) {
        prssta_1.lastit = 113;
    }
/* fix last it reference. */
    if (f) {
        goto L6550;
    }
/* was he in it? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133) {
        rspeak_(&c__535);
    }
/* if can see, describe. */
    if (play_1.here == 126) {
        rspeak_(&c__925);
    }
/* if at bottom, describe */
    return 0;

L6550:
    jigsup_(&c__536);
/* in balloon at crash, d */
    return 0;

L6600:
    ++play_1.bloc;
/* not at vair4, go up. */
    newsta_(&c__98, &c__0, &play_1.bloc, &c__0, &c__0);
    if (f) {
        goto L6650;
    }
/* in balloon? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133 || 
            play_1.here == 126) {
        rspeak_(&c__537);
    }
/* if can see, describe. */
    return 0;

L6650:
    f = moveto_(&play_1.bloc, &play_1.winner);
/* move player. */
    rspeak_(&c__538);
/* describe. */
    f = rmdesc_(&c__0);
    return 0;

/* On ledge, goes to midair room whether inflated or not. */

L6700:
    play_1.bloc += -3;
/* move to midair. */
    newsta_(&c__98, &c__0, &play_1.bloc, &c__0, &c__0);
    if (f) {
        goto L6750;
    }
/* in balloon? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133 || 
            play_1.here == 126) {
        rspeak_(&c__539);
    }
/* if can see, describe. */
    cevent_1.cflag[10] = TRUE_;
/* stranded. */
    cevent_1.ctick[10] = 10;
/* materialize gnome. */
    return 0;

L6750:
    f = moveto_(&play_1.bloc, &play_1.winner);
/* move to new room. */
    rspeak_(&c__540);
/* describe. */
    f = rmdesc_(&c__0);
    return 0;

/* At bottom, go up if inflated, do nothing if deflated. */

L6800:
    if (findex_1.binff == 0 || ! ((objcts_1.oflag2[c__99 - 1] & 8) != 0)) {
        return 0;
    }
    play_1.bloc = 127;
/* inflated and open, */
    newsta_(&c__98, &c__0, &play_1.bloc, &c__0, &c__0);
/* go up to vair1. */
    if (f) {
        goto L6850;
    }
/* in balloon? */
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133 || 
            play_1.here == 126) {
        rspeak_(&c__541);
    }
/* if can see, describe. */
    return 0;

L6850:
    f = moveto_(&play_1.bloc, &play_1.winner);
/* move player. */
    rspeak_(&c__542);
    f = rmdesc_(&c__0);
    return 0;
/* CEVAPP, PAGE 4 */

/* CEV7--        Balloon burnup. */

L7000:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* find burning object */
        if (99 == objcts_1.ocan[i__ - 1] && (objcts_1.oflag1[i__ - 1] & 8) != 
                0) {
            goto L7200;
        }
/* in receptacle. */
/* L7100: */
    }
    bug_(&c__4, &c__0);

L7200:
    newsta_(&i__, &c__0, &c__0, &c__0, &c__0);
/* vanish object. */
    findex_1.binff = 0;
/* uninflated. */
    if (play_1.here == play_1.bloc) {
        rspsub_(&c__292, &objcts_1.odesc2[i__ - 1]);
    }
/* describe. */
    return 0;

/* CEV8--        Fuse function. */

L8000:
    if (objcts_1.ocan[109] != 109) {
        goto L8500;
    }
/* ignited brick? */
    br = objcts_1.oroom[108];
/* get brick room. */
    bc = objcts_1.ocan[108];
/* get container. */
    if (br == 0 && bc != 0) {
        br = objcts_1.oroom[bc - 1];
    }
    if (br == 0) {
        br = play_1.here;
    }
/* it's here... */
    newsta_(&c__110, &c__0, &c__0, &c__0, &c__0);
/* kill fuse. */
    newsta_(&c__109, &c__0, &c__0, &c__0, &c__0);
/* kill brick. */
    if (br != play_1.here) {
        goto L8100;
    }

/* brick elsewhere? */
    rooms_1.rflag[play_1.here - 1] = rooms_1.rflag[play_1.here - 1] | 256;
/* blew self. */
    rooms_1.rdesc1[play_1.here - 1] = 114;
/* mung room. */
    jigsup_(&c__150);
/* dead. */
    return 0;

L8100:
    rspeak_(&c__151);
/* boom. */
    play_1.mungrm = br;
/* save room that blew. */
    cevent_1.cflag[9] = TRUE_;
    cevent_1.ctick[9] = 5;
/* set safe interrupt. */
    if (br != 135) {
        goto L8200;
    }
/* blew safe room? */
    if (bc != 107) {
        return 0;
    }
/* was brick in safe? */
    newsta_(&c__107, &c__0, &c__0, &c__0, &c__0);
/* kill slot. */
    objcts_1.oflag2[104] = objcts_1.oflag2[104] | 8;
/* open safe. */
    findex_1.safef = TRUE_;
/* indicate safe blown. */
    return 0;

L8200:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* blew wrong room. */
        if (qhere_(&i__, &br) && (objcts_1.oflag1[i__ - 1] & 8192) != 0) {
            newsta_(&i__, &c__0, &c__0, &c__0, &c__0);
        }
/* vanish contents. */
/* L8250: */
    }
    if (br != 8) {
        return 0;
    }
/* blew living room? */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.ocan[i__ - 1] == 9) {
            newsta_(&i__, &c__0, &c__0, &c__0, &c__0);
        }
/* kill trophy case. */
/* L8300: */
    }
    return 0;

L8500:
    if (qhere_(&c__110, &play_1.here) || objcts_1.oadv[109] == play_1.winner) 
            {
        rspeak_(&c__152);
    }
    newsta_(&c__110, &c__0, &c__0, &c__0, &c__0);
/* kill fuse. */
    return 0;
/* CEVAPP, PAGE 5 */

/* CEV9--        Ledge munge. */

L9000:
    rooms_1.rflag[132] = rooms_1.rflag[132] | 256;
/* ledge collapses. */
    rooms_1.rdesc1[132] = 109;
    if (play_1.here == 133) {
        goto L9100;
    }
/* was he there? */
    rspeak_(&c__110);
/* no, narrow escape. */
    return 0;

L9100:
    if (advs_1.avehic[play_1.winner - 1] != 0) {
        goto L9200;
    }
/* in vehicle? */
    jigsup_(&c__111);
/* no, dead. */
    return 0;

L9200:
    if (findex_1.btief != 0) {
        goto L9300;
    }
/* tied to ledge? */
    rspeak_(&c__112);
/* no, no place to land. */
    return 0;

L9300:
    play_1.bloc = 126;
/* yes, crash balloon. */
    newsta_(&c__98, &c__0, &c__0, &c__0, &c__0);
/* balloon & contents die */
    newsta_(&c__113, &c__0, &play_1.bloc, &c__0, &c__0);
/* insert dead balloon. */
    if (prssta_1.lastit == 98) {
        prssta_1.lastit = 113;
    }
/* fix last it reference. */
    objcts_1.odesc1[findex_1.btief - 1] = 1073;
/* restore description. */
    findex_1.btief = 0;
    findex_1.binff = 0;
    cevent_1.cflag[5] = FALSE_;
    cevent_1.cflag[6] = FALSE_;
    jigsup_(&c__113);
/* dead. */
    return 0;

/* CEV10--       Safe munge. */

L10000:
    rooms_1.rflag[play_1.mungrm - 1] = rooms_1.rflag[play_1.mungrm - 1] | 256;
/* mung target. */
    rooms_1.rdesc1[play_1.mungrm - 1] = 114;
    if (play_1.here == play_1.mungrm) {
        goto L10100;
    }
/* is he present? */
    rspeak_(&c__115);
/* let him know. */
    if (play_1.mungrm != 135) {
        return 0;
    }
    cevent_1.cflag[8] = TRUE_;
    cevent_1.ctick[8] = 8;
/* start ledge clock. */
    return 0;

L10100:
    i__ = 116;
/* he's dead, */
    if ((rooms_1.rflag[play_1.here - 1] & 64) != 0) {
        i__ = 117;
    }
/* one way or another. */
    jigsup_(&i__);
/* let him know. */
    return 0;
/* CEVAPP, PAGE 6 */

/* CEV11--       Volcano gnome entrance. */

L11000:
    if (play_1.here == 131 || play_1.here == 132 || play_1.here == 133) {
        goto L11100;
    }
/* is he on ledge? */
    cevent_1.cflag[10] = TRUE_;
    cevent_1.ctick[10] = 1;
/* no, wait a while. */
    return 0;

L11100:
    newsta_(&c__111, &c__118, &play_1.here, &c__0, &c__0);
/* yes, materialize gnome */
    return 0;

/* CEV12--       Volcano gnome exit. */

L12000:
    if (objcts_1.oroom[110] == play_1.here) {
        rspeak_(&c__149);
    }
/* player here to hear? */
    newsta_(&c__111, &c__0, &c__0, &c__0, &c__0);
/* disappear the gnome. */
    return 0;

/* CEV13--       Bucket. */

L13000:
    if (objcts_1.ocan[10] == 137) {
        newsta_(&c__11, &c__0, &c__0, &c__0, &c__0);
    }
/* water leaks out. */
    return 0;

/* CEV14--       Sphere.  If expires, he's trapped. */

L14000:
    rooms_1.rflag[139] = rooms_1.rflag[139] | 256;
/* mung room. */
    rooms_1.rdesc1[139] = 147;
    play_1.winner = 1;
/* kill player, not robot */
    jigsup_(&c__148);
/* mung player. */
    return 0;

/* CEV15--       END GAME HERALD. */

L15000:
    findex_1.endgmf = TRUE_;
/* we're in endgame. */
    rspeak_(&c__119);
/* inform of endgame. */
    return 0;
/* CEVAPP, PAGE 7 */

/* CEV16--       Forest murmurs. */

L16000:
    cevent_1.cflag[15] = play_1.here == 147 || (play_1.here >= 31 && 
            play_1.here < 36);
    if (cevent_1.cflag[15] && prob_(&c__10, &c__10)) {
        rspeak_(&c__635);
    }
    return 0;

/* CEV17--       Scol alarm. */

L17000:
    if (play_1.here == 154) {
        jigsup_(&c__636);
    }
/* if in vau, dead. */
    if (findex_1.zgnomf || play_1.here != 153) {
        return 0;
    }
/* if not in twi, nothing */
    findex_1.zgnomf = TRUE_;
/* gnome only comes once */
    cevent_1.cflag[17] = TRUE_;
/* turn on gnome timer */
    cevent_1.ctick[17] = 5;
    return 0;

/* CEV18--       Gnome of Zurich entrance. */

L18000:
    if (play_1.here != 153) {
        return 0;
    }
/* player here? */
    cevent_1.cflag[18] = TRUE_;
/* exits, too. */
    cevent_1.ctick[18] = 12;
    newsta_(&c__152, &c__637, &c__153, &c__0, &c__0);
/* place in twi. */
    return 0;

/* CEV19--       Gnome of Zurich exits. */

L19000:
    newsta_(&c__152, &c__0, &c__0, &c__0, &c__0);
/* vanish. */
    if (play_1.here == 153) {
        rspeak_(&c__638);
    }
/* announce. */
    return 0;
/* CEVAPP, PAGE 8 */

/* CEV20--       Start of endgame. */

L20000:
    if (findex_1.spellf) {
        goto L20200;
    }
/* spell his way in? */
    if (play_1.here != 157) {
        return 0;
    }
/* no, still in tomb? */
    if (! lit_(&play_1.here)) {
        goto L20100;
    }
/* lights off? */
    cevent_1.cflag[19] = TRUE_;
    cevent_1.ctick[19] = 3;
/* reschedule. */
    return 0;

L20100:
    rspeak_(&c__727);
/* announce. */
L20200:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* strip him of objs. */
        newsta_(&i__, &c__0, &objcts_1.oroom[i__ - 1], &objcts_1.ocan[i__ - 1]
                , &c__0);
/* L20300: */
    }
    newsta_(&c__15, &c__0, &c__0, &c__0, &c__1);
/* give him lamp. */
    newsta_(&c__14, &c__0, &c__0, &c__0, &c__1);

/* give him sword. */
    objcts_1.oflag1[14] = (objcts_1.oflag1[14] | 64) & -2;
    objcts_1.oflag2[14] = objcts_1.oflag2[14] | 4;
    cevent_1.cflag[2] = FALSE_;
/* lamp is good as new. */
    cevent_1.ctick[2] = 350;
    findex_1.orlamp = 0;
    objcts_1.oflag2[13] = objcts_1.oflag2[13] | 4;
/* recreate sword. */
    hack_1.swdact = TRUE_;
    hack_1.swdsta = 0;

    hack_1.thfact = FALSE_;
/* thief gone. */
    findex_1.endgmf = TRUE_;
/* endgame running. */
    cevent_1.cflag[14] = FALSE_;
/* herald gone, */
    cevent_1.cflag[3] = FALSE_;
/* matches gone, */
    cevent_1.cflag[4] = FALSE_;

/* candles gone. */
    scrupd_(&rooms_1.rval[156]);
/* score crypt, */
    rooms_1.rval[156] = 0;
/* but only once. */
    f = moveto_(&c__158, &play_1.winner);
/* to top of stairs, */
    f = rmdesc_(&c__3);
/* and describe. */
    return 0;

/* CEV21--       Mirror closes. */

/* bam! */
L21000:
    findex_1.mrpshf = FALSE_;
/* button is out. */
    findex_1.mropnf = FALSE_;
/* mirror is closed. */
    if (play_1.here == 159) {
        rspeak_(&c__728);
    }
/* describe button. */
    if (play_1.here == 177 || mrhere_(&play_1.here) == 1) {
        rspeak_(&c__729);
    }
/* describe mirror. */
    return 0;
/* CEVAPP, PAGE 9 */

/* CEV22--       Door closes. */

L22000:
    if (findex_1.wdopnf) {
        rspeak_(&c__730);
    }
/* describe. */
    findex_1.wdopnf = FALSE_;
/* closed. */
    return 0;

/* CEV23--       Inquisitor's question. */

L23000:
    if (advs_1.aroom[0] != 166) {
        return 0;
    }
/* if player left, die. */
    rspeak_(&c__769);
    i__1 = findex_1.quesno + 770;
    rspeak_(&i__1);
    cevent_1.cflag[22] = TRUE_;
    cevent_1.ctick[22] = 2;
    return 0;

/* CEV24--       Master follows. */

L24000:
    if (advs_1.aroom[2] == play_1.here) {
        return 0;
    }
/* no movement, done. */
    if (play_1.here != 184 && play_1.here != 185) {
        goto L24100;
    }
    if (findex_1.follwf) {
        rspeak_(&c__811);
    }
/* wont go to cells. */
    findex_1.follwf = FALSE_;
    return 0;

L24100:
    findex_1.follwf = TRUE_;
/* following. */
    i__ = 812;
/* assume catches up. */
    for (j = 1024; j <= 16384; j += 1024) {
        if (findxt_(&j, &advs_1.aroom[2]) && curxt_1.xroom1 == play_1.here) {
            i__ = 813;
        }
/* assume follows. */
/* L24200: */
    }
    rspeak_(&i__);
    newsta_(&c__279, &c__0, &play_1.here, &c__0, &c__0);
/* move master object. */
    advs_1.aroom[2] = play_1.here;
/* move master actor. */
    return 0;

/* CEV25--       Brochure arrives. */

L25000:
    newsta_(&c__195, &c__948, &c__0, &c__53, &c__0);
/* put brochure in mailbo */
    findex_1.broc2f = TRUE_;
/* flag arrival */
    return 0;
/* CEVAPP, PAGE 10 */

/* CEV26--       Cyclops. */

L26000:
    if (play_1.here != 101 || findex_1.magicf) {
        goto L26500;
    }
/* player or cyclops gone */
    if (findex_1.cyclof) {
        return 0;
    }
/* if asleep, check later */
    if (abs(findex_1.rvcyc) <= 5) {
        goto L26200;
    }
/* cyclops overly annoyed */
    cevent_1.cflag[25] = FALSE_;
/* disable cyclops timer */
    jigsup_(&c__188);
/* player munched for lun */
    return 0;

L26200:
    if (findex_1.rvcyc < 0) {
        --findex_1.rvcyc;
    }
/* cyclops gets more anno */
    if (findex_1.rvcyc >= 0) {
        ++findex_1.rvcyc;
    }
    i__1 = abs(findex_1.rvcyc) + 193;
    rspeak_(&i__1);
/* report cyclops state */
    return 0;

L26500:
    cevent_1.cflag[25] = FALSE_;
/* disable cyclops timer */
    return 0;

/* CEV27--       Slippery slide. */

L27000:
    if (play_1.here < 194 || play_1.here >= 197) {
        return 0;
    }
/* in slide? */
    rspeak_(&c__1034);
/* slide to cellar */
    f = moveto_(&c__9, &play_1.winner);
/* into cellar */
    f = rmdesc_(&c__3);
/* describe */
    return 0;

/* CEV28--       Exorcism bell. */

L28000:
    if (! findex_1.exorcf && play_1.here == 93) {
        rspeak_(&c__970);
    }
    findex_1.exorbf = FALSE_;
/* spell broken */
    return 0;

/* CEV29--       Exorcism candles. */

L29000:
    findex_1.exorcf = FALSE_;
/* spell broken */
    goto L28000;

/* CEV30--       Hot bell cools down. */

L30000:
    newsta_(&c__190, &c__0, &c__0, &c__0, &c__0);
/* banish hot bell */
    newsta_(&c__46, &c__0, &c__93, &c__0, &c__0);
/* get normal bell */
    if (prssta_1.lastit == 190) {
        prssta_1.lastit = 46;
    }
/* fix last it reference. */
    if (play_1.here == 93) {
        rspeak_(&c__971);
    }
/* tell player if here */
    return 0;

} /* cevapp_ */



/* LITINT-       Light interrupt processor */

/* Declarations */

/* Subroutine */ int litint_(integer *obj, integer *ctr, integer *cev, 
        integer *ticks, integer *tickln)
{
    /* Local variables */


    /* Parameter adjustments */
    --ticks;

    /* Function Body */
    ++(*ctr);
/* advance state cntr. */
    cevent_1.ctick[*cev - 1] = ticks[*ctr];
/* reset interrupt. */
    if (cevent_1.ctick[*cev - 1] != 0) {
        goto L100;
    }
/* expired? */
    objcts_1.oflag1[*obj - 1] = objcts_1.oflag1[*obj - 1] & -74;
    if (objcts_1.oroom[*obj - 1] == play_1.here || objcts_1.oadv[*obj - 1] == 
            play_1.winner) {
        rspsub_(&c__293, &objcts_1.odesc2[*obj - 1]);
    }
    return 0;

L100:
    cevent_1.cflag[*cev - 1] = TRUE_;
    if (objcts_1.oroom[*obj - 1] == play_1.here || objcts_1.oadv[*obj - 1] == 
            play_1.winner) {
        rspeak_(&ticks[*ctr + *tickln / 2]);
    }
    return 0;

} /* litint_ */



/* FIGHTD- Intermove fight demon */

/* Declarations */

/* Subroutine */ int fightd_(void)
{
    /* Initialized data */

    static integer rout = 1;

    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    logical f;
    integer i__, ra, j;
    integer obj;
    integer res, out;


/* Functions and data */

/* FIGHTD, PAGE 2 */

    i__1 = vill_1.vlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop thru villains. */
        vill_1.vopps[i__ - 1] = 0;
/* clear opponent slot. */
        obj = vill_1.villns[i__ - 1];
/* get object no. */
        ra = objcts_1.oactio[obj - 1];
/* get his action. */
        if (play_1.here != objcts_1.oroom[obj - 1]) {
            goto L2200;
        }
/* adventurer still here? */
        if (obj != 61 || ! findex_1.thfenf) {
            goto L2010;
        }
/* thief engrossed? */
        findex_1.thfenf = FALSE_;
/* yes, not anymore. */
        goto L2400;

L2010:
        if (objcts_1.ocapac[obj - 1] >= 0) {
            goto L2050;
        }
/* no, vill awake? */
        i__2 = (vill_1.vprob[i__ - 1] + 100) / 2;
        if (vill_1.vprob[i__ - 1] == 0 || ! prob_(&vill_1.vprob[i__ - 1], &
                i__2)) {
            goto L2025;
        }
/* no, see if wakes up. */
        objcts_1.ocapac[obj - 1] = (i__2 = objcts_1.ocapac[obj - 1], abs(i__2)
                );
        vill_1.vprob[i__ - 1] = 0;
        if (ra == 0) {
            goto L2400;
        }
/* anything to do? */
        prsvec_1.prsa = 4;
/* yes, wake him up. */
        f = oappli_(&ra, &c__0);
        goto L2400;

/* nothing else happens. */
L2025:
        vill_1.vprob[i__ - 1] += 10;
/* increase wakeup prob. */
        goto L2400;

/* nothing else. */
L2050:
        if ((objcts_1.oflag2[obj - 1] & 256) == 0) {
            goto L2100;
        }
        vill_1.vopps[i__ - 1] = obj;
/* fighting, set up opp. */
        goto L2400;

L2100:
        if (ra == 0) {
            goto L2400;
        }
/* not fighting, */
        prsvec_1.prsa = 3;
/* set up probability */
        if (! oappli_(&ra, &c__0)) {
            goto L2400;
        }
/* of fighting. */
        objcts_1.oflag2[obj - 1] = objcts_1.oflag2[obj - 1] | 256;
        vill_1.vopps[i__ - 1] = obj;
/* set up opp. */
        prsvec_1.prscon = 0;
/* stop cmd stream. */
        goto L2400;

L2200:
        if ((objcts_1.oflag2[obj - 1] & 256) == 0 || ra == 0) {
            goto L2300;
        }
/* nothing to do. */
        prsvec_1.prsa = 7;
/* have a fight. */
        f = oappli_(&ra, &c__0);
L2300:
        if (obj == 61) {
            findex_1.thfenf = FALSE_;
        }
/* turn off engrossed. */
        advs_1.aflag[0] = advs_1.aflag[0] & -32769;
        objcts_1.oflag2[obj - 1] = objcts_1.oflag2[obj - 1] & -321;
        if (objcts_1.ocapac[obj - 1] >= 0 || ra == 0) {
            goto L2400;
        }
        prsvec_1.prsa = 4;
/* wake him up. */
        f = oappli_(&ra, &c__0);
        objcts_1.ocapac[obj - 1] = (i__2 = objcts_1.ocapac[obj - 1], abs(i__2)
                );
L2400:
        ;
    }
/* FIGHTD, PAGE 3 */

/* Now do actual counterblows. */

    out = 0;
/* assume hero ok. */
L2600:
    i__1 = vill_1.vlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop thru opps. */
        j = vill_1.vopps[i__ - 1];
        if (j == 0) {
            goto L2700;
        }
/* slot empty? */
        prsvec_1.prscon = 0;
/* stop cmd stream. */
        ra = objcts_1.oactio[j - 1];
        if (ra == 0) {
            goto L2650;
        }
/* villain action? */
        prsvec_1.prsa = 7;
/* see if */
        if (oappli_(&ra, &c__0)) {
            goto L2700;
        }
/* special action. */
L2650:
        res = blow_(&c__1, &j, &vill_1.vmelee[i__ - 1], &c_false, &out);
/* strike blow. */
        if (res < 0) {
            return 0;
        }
/* if hero dead, exit. */
        if (res == rout) {
            out = rnd_(&c__3) + 2;
        }
/* if hero out, set flg. */
L2700:
        ;
    }
    --out;
/* decrement out count. */
    if (out > 0) {
        goto L2600;
    }
/* if still out, go again */
    return 0;

} /* fightd_ */



/* BLOW- Strike blow */

/* Declarations */

integer blow_(integer *h__, integer *v, integer *rmk, logical *hflg, integer *
        out)
{
    /* Initialized data */

    static integer rmiss = 0;
    static integer rout = 1;
    static integer rkill = 2;
    static integer rstag = 5;
    static integer rlose = 6;
    static integer rhes = 7;
    static integer rsit = 8;
    static integer def1r[3] = { 1,2,3 };
    static integer def2r[4] = { 13,23,24,25 };
    static integer def3r[5] = { 35,36,46,47,57 };
    static integer rvectr[66] = { 0,0,0,0,5,5,1,1,2,2,2,2,0,0,0,0,0,5,5,3,3,1,
            0,0,0,5,5,3,3,3,1,2,2,2,0,0,0,0,0,5,5,3,3,4,4,0,0,0,5,5,3,3,3,4,4,
            4,0,5,5,3,3,3,3,4,4,4 };
    static integer rstate[45] = { 5000,3005,3008,4011,3015,3018,1021,0,0,5022,
            3027,3030,4033,3037,3040,1043,0,0,4044,2048,4050,4054,5058,4063,
            4067,3071,1074,4075,1079,4080,4084,4088,4092,4096,4100,1104,4105,
            2109,4111,4115,4119,4123,4127,3131,3134 };

    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    logical f;
    integer ra, dv, pblose;
    integer oa, def;
    integer od, dweap, i__;
    integer mi, j, tbl;
    integer att, res;


/* Functions and data */


/* BLOW, PAGE 2 */

    ra = objcts_1.oactio[*v - 1];
/* get villain action, */
    dv = objcts_1.odesc2[*v - 1];
/* description. */
    ret_val = rmiss;
/* D     PRINT 10,H,V,RMK,HFLG,OUT */
/* D10   FORMAT(' BLOW 10-- ',3I7,L7,I7) */
/* assume no result. */
    if (! (*hflg)) {
        goto L1000;
    }

/* Hero is attacker, villain is defender. */

/* hero striking blow? */
    pblose = 10;
/* bad lk prob. */
    objcts_1.oflag2[*v - 1] = objcts_1.oflag2[*v - 1] | 256;
/* yes, villain gets mad. */
    if ((advs_1.aflag[*h__ - 1] & 32768) == 0) {
        goto L100;
    }
/* hero stag? */
    rspeak_(&c__591);
/* yes, cant fight. */
    advs_1.aflag[*h__ - 1] = advs_1.aflag[*h__ - 1] & -32769;
    return ret_val;

L100:
/* Computing MAX */
    i__1 = 1, i__2 = fights_(h__, &c_true);
    att = max(i__1,i__2);
/* get his strength. */
    oa = att;
    def = vilstr_(v);
/* get vill strength. */
    od = def;
    dweap = 0;
/* assume no weapon. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* search villain. */
        if (objcts_1.ocan[i__ - 1] == *v && (objcts_1.oflag2[i__ - 1] & 512) 
                != 0) {
            dweap = i__;
        }
/* L200: */
    }
    if (*v == advs_1.aobj[0]) {
        goto L300;
    }
/* killing self? */
    if (def != 0) {
        goto L2000;
    }
/* defender alive? */
    rspsub_(&c__592, &dv);
/* villain dead. */
    return ret_val;

L300:
    jigsup_(&c__593);
/* killing self. */
    return ret_val;

/* Villain is attacker, hero is defender. */

L1000:
    prsvec_1.prscon = 0;
/* stop cmd stream. */
    pblose = 50;
/* bad lk prob. */
    advs_1.aflag[*h__ - 1] = advs_1.aflag[*h__ - 1] & -32769;
/* vill striking. */
    if ((objcts_1.oflag2[*v - 1] & 64) == 0) {
        goto L1200;
    }
/* vill staggered? */
    objcts_1.oflag2[*v - 1] = objcts_1.oflag2[*v - 1] & -65;
/* make him ok. */
    rspsub_(&c__594, &dv);
/* describe. */
    return ret_val;

L1200:
    att = vilstr_(v);
/* set up att, def. */
    oa = att;
    def = fights_(h__, &c_true);
    if (def <= 0) {
        return ret_val;
    }
/* dont allow dead def. */
    od = fights_(h__, &c_false);
    dweap = (i__1 = fwim_(&c__0, &c__512, &c__0, &c__0, h__, &c_true), abs(
            i__1));
/* BLOW, PAGE 3 */

/* Parties are now equipped.  DEF cannot be zero. */
/* ATT must be > 0. */

/* find a weapon. */
L2000:
/* D     PRINT 2050,ATT,OA,DEF,OD,DWEAP */
/* D2050 FORMAT(' BLOW 2050-- ',5I7) */
    if (def > 0) {
        goto L2100;
    }
/* def alive? */
    res = rkill;
    if (*hflg) {
        rspsub_(&c__595, &dv);
    }
/* deader. */
    goto L3000;

L2100:
    if ((i__1 = def - 2) < 0) {
        goto L2200;
    } else if (i__1 == 0) {
        goto L2300;
    } else {
        goto L2400;
    }
/* def <2,=2,>2 */
L2200:
    att = min(att,3);
/* scale att. */
    tbl = def1r[att - 1];
/* choose table. */
    goto L2500;

L2300:
    att = min(att,4);
/* scale att. */
    tbl = def2r[att - 1];
/* choose table. */
    goto L2500;

L2400:
    att -= def;
/* scale att. */
/* Computing MIN */
    i__1 = 2, i__2 = max(-2,att);
    att = min(i__1,i__2) + 3;
    tbl = def3r[att - 1];

L2500:
    res = rvectr[tbl + rnd_(&c__10) - 1];
/* get result. */
    if (*out == 0) {
        goto L2600;
    }
/* was he out? */
    if (res == rstag) {
        goto L2550;
    }
/* yes, stag--> hes. */
    res = rsit;
/* otherwise, sitting. */
    goto L2600;
L2550:
    res = rhes;
L2600:
    if (res == rstag && dweap != 0 && prob_(&c__25, &pblose)) {
        res = rlose;
    }

/* lose weapon. */
    mi = rstate[(*rmk - 1) * 9 + res];
/* choose table entry. */
    if (mi == 0) {
        goto L3000;
    }
    i__1 = mi / 1000;
    i__ = mi % 1000 + rnd_(&i__1) + misc_1.mbase + 1;
    j = dv;
    if (! (*hflg) && dweap != 0) {
        j = objcts_1.odesc2[dweap - 1];
    }
/* D     PRINT 2650,RES,MI,I,J,MBASE */
/* D2650 FORMAT(' BLOW 2650-- ',5I7) */
    rspsub_(&i__, &j);
/* BLOW, PAGE 4 */

/* Now apply result. */

/* present result. */
L3000:
    switch (res + 1) {
        case 1:  goto L4000;
        case 2:  goto L3100;
        case 3:  goto L3200;
        case 4:  goto L3300;
        case 5:  goto L3400;
        case 6:  goto L3500;
        case 7:  goto L3600;
        case 8:  goto L4000;
        case 9:  goto L3200;
    }
/*              miss, out,kill,lght,svre,stag,lose, hes, sit */

L3100:
    if (*hflg) {
        def = -def;
    }
/* unconscious. */
    goto L4000;

L3200:
    def = 0;
/* killed or sitting duck */
    goto L4000;

L3300:
/* Computing MAX */
    i__1 = 0, i__2 = def - 1;
    def = max(i__1,i__2);
/* light wound. */
    goto L4000;

L3400:
/* Computing MAX */
    i__1 = 0, i__2 = def - 2;
    def = max(i__1,i__2);
/* serious wound. */
    goto L4000;

L3500:
    if (*hflg) {
        goto L3550;
    }
/* staggered. */
    advs_1.aflag[*h__ - 1] = advs_1.aflag[*h__ - 1] | 32768;
    goto L4000;

L3550:
    objcts_1.oflag2[*v - 1] = objcts_1.oflag2[*v - 1] | 64;
    goto L4000;

L3600:
    newsta_(&dweap, &c__0, &play_1.here, &c__0, &c__0);
/* lose weapon. */
    dweap = 0;
    if (*hflg) {
        goto L4000;
    }
/* if hero, done. */
    dweap = (i__1 = fwim_(&c__0, &c__512, &c__0, &c__0, h__, &c_true), abs(
            i__1));
/* get new. */
    if (dweap != 0) {
        rspsub_(&c__605, &objcts_1.odesc2[dweap - 1]);
    }
/* BLOW, PAGE 5 */

L4000:
    ret_val = res;
/* return result. */
    if (! (*hflg)) {
        goto L4500;
    }
/* hero? */
    objcts_1.ocapac[*v - 1] = def;
/* store new capacity. */
    if (def != 0) {
        goto L4100;
    }
/* dead? */
    objcts_1.oflag2[*v - 1] = objcts_1.oflag2[*v - 1] & -257;
/* yes, not fighting. */
    rspsub_(&c__572, &dv);
/* he dies. */
    newsta_(v, &c__0, &c__0, &c__0, &c__0);
/* make him disappear. */
    if (ra == 0) {
        return ret_val;
    }
/* if nx to do, exit. */
    prsvec_1.prsa = 2;
/* let him know. */
    f = oappli_(&ra, &c__0);
    return ret_val;

L4100:
    if (res != rout || ra == 0) {
        return ret_val;
    }
    prsvec_1.prsa = 5;
/* let him be out. */
    f = oappli_(&ra, &c__0);
    return ret_val;

L4500:
    advs_1.astren[*h__ - 1] = -10000;
/* assume dead. */
    if (def != 0) {
        advs_1.astren[*h__ - 1] = def - od;
    }
    if (def >= od) {
        goto L4600;
    }
    cevent_1.ctick[0] = 30;
    cevent_1.cflag[0] = TRUE_;
L4600:
    if (fights_(h__, &c_true) > 0) {
        return ret_val;
    }
    advs_1.astren[*h__ - 1] = 1 - fights_(h__, &c_false);
/* he's dead. */
    jigsup_(&c__596);
    ret_val = -1;
    return ret_val;

} /* blow_ */



/* SWORDD- Intermove sword demon */

/* Declarations */

/* Subroutine */ int swordd_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer ng, i__;


    if (objcts_1.oadv[13] != 1) {
        goto L500;
    }
/* holding sword? */
    ng = 2;
/* assume vill close. */
    if (infest_(&play_1.here)) {
        goto L300;
    }
/* vill here? */
    ng = 1;
    for (i__ = 1024; i__ <= 16384; i__ += 1024) {
/* no, search rooms. */
        if (! findxt_(&i__, &play_1.here)) {
            goto L200;
        }
/* room that way? */
        switch (curxt_1.xtype) {
            case 1:  goto L50;
            case 2:  goto L200;
            case 3:  goto L50;
            case 4:  goto L50;
        }
/* see if room at all. */
L50:
        if (infest_(&curxt_1.xroom1)) {
            goto L300;
        }
/* check room. */
L200:
        ;
    }
    ng = 0;

/* no glow. */
L300:
    if (ng == hack_1.swdsta) {
        return 0;
    }
/* any state change? */
    i__1 = ng + 495;
    rspeak_(&i__1);
/* yes, tell new state. */
    hack_1.swdsta = ng;
    return 0;

L500:
    hack_1.swdact = FALSE_;
/* dropped sword, */
    return 0;
/* disable demon. */
} /* swordd_ */



/* INFEST-       Subroutine to test for infested room */

/* Declarations */

logical infest_(integer *r__)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


    if (! findex_1.endgmf) {
        ret_val = objcts_1.oroom[57] == *r__ || objcts_1.oroom[18] == *r__ || 
                (objcts_1.oroom[60] == *r__ && hack_1.thfact);
    }
    if (findex_1.endgmf) {
        ret_val = *r__ == 164 || *r__ == 173 || *r__ == 174 || (*r__ == 177 &&
                 findex_1.mloc == 164);
    }
    return ret_val;
} /* infest_ */



/* AAPPLI- Applicables for adventurers */

/* Declarations */

logical aappli_(integer *ri)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    logical f;
    integer i__, j;


    if (*ri == 0) {
        goto L10;
    }
/* if zero, no app. */
    ret_val = TRUE_;
/* assume wins. */
    switch (*ri) {
        case 1:  goto L1000;
        case 2:  goto L2000;
        case 3:  goto L3000;
    }
/* branch on adv. */
    bug_(&c__11, ri);

/* Common false return. */

L10:
    ret_val = FALSE_;
    return ret_val;
/* AAPPLI, PAGE 2 */

/* A1--  Dead player. */

L1000:
    if (prsvec_1.prsa != 141 && prsvec_1.prsa != 138 && prsvec_1.prsa != 139 
            && prsvec_1.prsa != 140 && prsvec_1.prsa != 107 && prsvec_1.prsa 
            != 82) {
        goto L1050;
    }
    rspeak_(&c__949);
/* dead can't attack. */
    return ret_val;

L1050:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 126 && prsvec_1.prsa != 135 
            && prsvec_1.prsa != 136 && prsvec_1.prsa != 102 && prsvec_1.prsa 
            != 103 && prsvec_1.prsa != 116 && prsvec_1.prsa != 114 && 
            prsvec_1.prsa != 111 && prsvec_1.prsa != 97 && prsvec_1.prsa != 
            137 && prsvec_1.prsa != 113) {
        goto L1100;
    }
    rspeak_(&c__950);
/* dead can't do simple a */
    return ret_val;

L1100:
    if (prsvec_1.prsa != 123) {
        goto L1150;
    }
    rspeak_(&c__951);
/* dead don't need lights */
    return ret_val;

L1150:
    if (prsvec_1.prsa != 83) {
        goto L1200;
    }
    rspeak_(&c__952);
/* dead can't score. */
    return ret_val;

L1200:
    if (prsvec_1.prsa != 143) {
        goto L1250;
    }
    rspeak_(&c__953);
/* dead can't give orders */
    return ret_val;

L1250:
    if (prsvec_1.prsa != 132) {
        goto L1300;
    }
    rspeak_(&c__954);
/* dead can't take. */
    return ret_val;

L1300:
    if (prsvec_1.prsa != 145 && prsvec_1.prsa != 148 && prsvec_1.prsa != 133) 
            {
        goto L1350;
    }
    rspeak_(&c__955);
/* dead have no possesion */
    return ret_val;

L1350:
    if (prsvec_1.prsa != 94) {
        goto L1400;
    }
    rspeak_(&c__956);
/* dead as a doornail */
    return ret_val;

L1400:
    if (prsvec_1.prsa != 119) {
        goto L1500;
    }
    i__ = 957;
/* assume nothing here */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* loop through objects */
        if (qhere_(&j, &play_1.here)) {
            i__ = 958;
        }
/* found something */
/* L1450: */
    }
    rspeak_(&i__);
/* describe objects */
    if ((rooms_1.rflag[play_1.here - 1] & 16384) == 0) {
        rspeak_(&c__959);
    }
    goto L10;

/* don't handle */
L1500:
    if (prsvec_1.prsa != 79) {
        goto L1600;
    }
    if (play_1.here == 97) {
        goto L1550;
    }
/* praying in temple? */
    rspeak_(&c__960);
/* prayers are not answer */
    return ret_val;

L1550:
    objcts_1.oflag1[14] = objcts_1.oflag1[14] | 32768;
/* back to life, restore */
    advs_1.aactio[0] = 0;
/* disable dead player */
    findex_1.deadf = FALSE_;
/* clear dead flag */
    f = moveto_(&c__31, &play_1.winner);
/* move to forest */
    rspeak_(&c__9);
/* describe */
    return ret_val;

L1600:
    if (prsvec_1.prsa != 142) {
        goto L1700;
    }
    if (! findxt_(&prsvec_1.prso, &play_1.here)) {
        goto L10;
    }
/* if no exits, don't han */
    if (curxt_1.xroom1 != 76) {
        goto L10;
    }
/* if not bshaft, don't h */
    rspeak_(&c__962);
/* can't go and score poi */
    return ret_val;

L1700:
    if (prsvec_1.prsa == 84 || prsvec_1.prsa == 150) {
        goto L10;
    }
/* if quit or restore, don't handle (I added the restore. --Z) */
    rspeak_(&c__963);
/* can't do it */
    return ret_val;

/* A2--  Robot.  Process most commands given to robot. */

L2000:
    if (prsvec_1.prsa != 109 || prsvec_1.prso != 125) {
        goto L2200;
    }
    cevent_1.cflag[13] = FALSE_;
/* robot raised cage. */
    play_1.winner = 1;
/* reset for player. */
    f = moveto_(&c__140, &play_1.winner);
/* move to new room. */
    newsta_(&c__124, &c__567, &c__140, &c__0, &c__0);
/* install cage in room. */
    newsta_(&c__142, &c__0, &c__140, &c__0, &c__0);
/* install robot in room. */
    advs_1.aroom[1] = 140;
/* also move robot/adv. */
    findex_1.cagesf = TRUE_;
/* cage solved. */
    objcts_1.oflag1[141] = objcts_1.oflag1[141] & -513;
    objcts_1.oflag1[125] = objcts_1.oflag1[125] | 8192;
/* reset flags. */
    prsvec_1.prscon = 0;
/* stop cmd stream. */
    return ret_val;

L2200:
    if (prsvec_1.prsa != 136 && prsvec_1.prsa != 135) {
        goto L2300;
    }
    rspeak_(&c__568);
/* eat or drink, joke. */
    return ret_val;

L2300:
    if (prsvec_1.prsa != 100) {
        goto L2400;
    }
/* read, */
    rspeak_(&c__569);
/* joke. */
    return ret_val;

L2400:
    if (prsvec_1.prsa == 142 || prsvec_1.prsa == 132 || prsvec_1.prsa == 145 
            || prsvec_1.prsa == 144 || prsvec_1.prsa == 112 || prsvec_1.prsa 
            == 91 || prsvec_1.prsa == 116) {
        goto L2500;
    }
/* test for robot verb. */
    rspeak_(&c__570);
/* joke. */
    return ret_val;

L2500:
    rspeak_(&c__930);
/* buzz, whirr, click! */
    goto L10;
/* AAPPLI, PAGE 3 */

/* A3--  Master.  Process most commands given to master. */

/* don't handle here. */
L3000:
    if ((objcts_1.oflag2[172] & 8) != 0) {
        goto L3100;
    }
    rspeak_(&c__783);
/* no master yet. */
    return ret_val;

L3100:
    if (prsvec_1.prsa != 142) {
        goto L3200;
    }
/* walk? */
    i__ = 784;
/* assume wont. */
    if ((play_1.here == 179 && (prsvec_1.prso == 1024 || prsvec_1.prso == 
            13312)) || (play_1.here == 182 && (prsvec_1.prso == 5120 || 
            prsvec_1.prso == 13312))) {
        i__ = 785;
    }
/* if prison, cant. */
    rspeak_(&i__);
    return ret_val;

L3200:
    if (prsvec_1.prsa == 73 || prsvec_1.prsa == 85 || prsvec_1.prsa == 139 || 
            prsvec_1.prsa == 138 || prsvec_1.prsa == 141) {
        goto L10;
    }
    if (prsvec_1.prsa == 132 || prsvec_1.prsa == 145 || prsvec_1.prsa == 144 
            || prsvec_1.prsa == 148 || prsvec_1.prsa == 112 || prsvec_1.prsa 
            == 116 || prsvec_1.prsa == 129 || prsvec_1.prsa == 159 || 
            prsvec_1.prsa == 125 || prsvec_1.prsa == 126) {
        goto L3300;
    }
/* master can, politely. */
    rspeak_(&c__786);
/* master can't. */
    return ret_val;

L3300:
    rspeak_(&c__1057);
/* polite reply. */
    goto L10;

} /* aappli_ */



/* THIEFD-       Intermove thief demon */

/* Declarations */

/* This routine details on bit 6 of PRSFLG */

/* Subroutine */ int thiefd_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical dflag, once;
    logical waslit;
    integer rhere;
    integer i__;
    integer nr;
    integer j;
    integer rmk;

/* Functions AND DATA */

/* THIEFD, PAGE 2 */

    dflag = (misc_1.prsflg & 64) != 0;
/* set up detail flag. */
    once = FALSE_;
/* init flag. */
L1025:
    waslit = lit_(&play_1.here);
/* record if lit. */
    rhere = objcts_1.oroom[60];
/* visible pos. */
    if (rhere != 0) {
        hack_1.thfpos = rhere;
    }

    if (hack_1.thfpos == play_1.here && ! findex_1.deadf) {
        goto L1100;
    }
/* thief in live win */
    if (hack_1.thfpos != 103) {
        goto L1400;
    }

/* Thief is in treasure room, and winner is not. */

/* thief not in treas? */
    if (dflag) {
        glk_put_string("THIEFD-- IN TREASURE ROOM\n");
    }
    if (rhere == 0) {
        goto L1050;
    }
/* visible? */
    newsta_(&c__61, &c__0, &c__0, &c__0, &c__0);
/* yes, vanish. */
    rhere = 0;
    if (qhere_(&c__62, &c__103) || objcts_1.oadv[61] == -61) {
        newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
    }
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through objects. */
        if (qhere_(&i__, &hack_1.thfpos)) {
            objcts_1.oflag1[i__ - 1] = objcts_1.oflag1[i__ - 1] | 32768;
        }
/* make objects visible */
/* L1040: */
    }
L1050:
    i__ = robadv_(&c_n61, &hack_1.thfpos, &c__0, &c__0);
/* drop valuables. */
    if (qhere_(&c__154, &hack_1.thfpos)) {
        objcts_1.oflag2[153] = objcts_1.oflag2[153] | 8;
    }
    goto L1700;
/* THIEFD, PAGE 3 */

/* Thief and (live) winner in same room. */

L1100:
    if (hack_1.thfpos == 103) {
        goto L1700;
    }
/* if treas room, nothing */
    if ((rooms_1.rflag[hack_1.thfpos - 1] & 16384) != 0) {
        goto L1400;
    }
/* not if light. */
    if (dflag) {
        glk_put_string("THIEFD-- IN ADV ROOM\n");
    }
    if (hack_1.thfflg) {
        goto L1300;
    }
/* thief announced? */
    if (rhere != 0 || prob_(&c__70, &c__70)) {
        goto L1150;
    }
/* if invis and 30%. */
    if (objcts_1.ocan[61] != 61) {
        goto L1700;
    }
/* abort if no stilletto. */
    newsta_(&c__61, &c__583, &hack_1.thfpos, &c__0, &c__0);
/* insert thief into room */
    hack_1.thfflg = TRUE_;
/* thief is announced. */
    return 0;

L1150:
    if (rhere == 0 || (objcts_1.oflag2[60] & 256) == 0) {
        goto L1200;
    }
/* if visible and fight. */
    if (winnin_(&c__61, &c__1)) {
        goto L1175;
    }
/* winning? */
    newsta_(&c__61, &c__584, &c__0, &c__0, &c__0);
/* no, vanish thief. */
    objcts_1.oflag2[60] = objcts_1.oflag2[60] & -257;
    if (qhere_(&c__62, &hack_1.thfpos) || objcts_1.oadv[61] == -61) {
        newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
    }
    return 0;

L1175:
    if (prob_(&c__90, &c__90)) {
        goto L1700;
    }

/* 90% chance to stay. */
L1200:
    if (rhere == 0 || prob_(&c__70, &c__70)) {
        goto L1250;
    }
/* if visible and 30% */
    newsta_(&c__61, &c__585, &c__0, &c__0, &c__0);
/* vanish thief. */
    if (qhere_(&c__62, &hack_1.thfpos) || objcts_1.oadv[61] == -61) {
        newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
    }
    return 0;

L1300:
    if (rhere == 0) {
        goto L1700;
    }
/* announced.  visible? */
L1250:
    if (prob_(&c__70, &c__70)) {
        return 0;
    }
/* 70% chance to do nothi */
    hack_1.thfflg = TRUE_;
    nr = robrm_(&hack_1.thfpos, &c__100, &c__0, &c__0, &c_n61) + robadv_(&
            c__1, &c__0, &c__0, &c_n61);
    i__ = 586;
/* robbed em. */
    if (rhere != 0) {
        i__ = 588;
    }
/* was he visible? */
    i__1 = i__ + min(1,nr);
    newsta_(&c__61, &i__1, &c__0, &c__0, &c__0);
/* vanish thief, give res */
    if (qhere_(&c__62, &hack_1.thfpos) || objcts_1.oadv[61] == -61) {
        newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
    }
/* reclaim stilletto. */
    if (waslit && ! lit_(&play_1.here) && play_1.here == advs_1.aroom[0]) {
        rspeak_(&c__915);
    }
/* leave player in dark? */
    rhere = 0;
    goto L1700;
/* THIEFD, PAGE 4 */

/* Not in adventurers room, or adventurer dead, or room lit. */

/* onward. */
L1400:
    newsta_(&c__61, &c__0, &c__0, &c__0, &c__0);
/* vanish. */
    rhere = 0;
    if (dflag) {
        weeprintf("THIEFD-- IN ROOM %d\n", hack_1.thfpos);
    }
    if (qhere_(&c__62, &hack_1.thfpos) || objcts_1.oadv[61] == -61) {
        newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
    }
    if ((rooms_1.rflag[hack_1.thfpos - 1] & 32768) == 0) {
        goto L1700;
    }
/* cant rob unseen. */
    rmk = 1045;
/* first object to vanish */
    i__ = robrm_(&hack_1.thfpos, &c__75, &c__0, &c__0, &c_n5555);
/* rob room 75% to hypers */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop through objects. */
        if (objcts_1.oadv[i__ - 1] != -5555) {
            goto L1410;
        }
/* in hyperspace? */
        newsta_(&i__, &c__0, &c__0, &c__0, &c_n61);
/* move to thief. */
        if (hack_1.thfpos == play_1.here && ! findex_1.deadf) {
            rspsub_(&rmk, &objcts_1.odesc2[i__ - 1]);
        }
/* thief's remarks. */
        rmk = 1083;
/* for next object. */
L1410:
        ;
    }

    if (hack_1.thfpos < 11 || hack_1.thfpos > 30 || play_1.here < 11 || 
            play_1.here > 30) {
        goto L1500;
    }
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* both in maze. */
        if (! qhere_(&i__, &hack_1.thfpos) || prob_(&c__60, &c__60) || i__ == 
                11 || (objcts_1.oflag1[i__ - 1] & 40960) != 40960) {
            goto L1450;
        }
        if (! findex_1.deadf) {
            rspsub_(&c__590, &objcts_1.odesc2[i__ - 1]);
        }
/* thief's remarks. */
        if (prob_(&c__40, &c__20)) {
            goto L1700;
        }
        newsta_(&i__, &c__0, &c__0, &c__0, &c_n61);
/* steal it. */
        objcts_1.oflag2[i__ - 1] = objcts_1.oflag2[i__ - 1] | 4;
        goto L1700;
L1450:
        ;
    }
    goto L1700;

L1500:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* not in maze. */
        if (! qhere_(&i__, &hack_1.thfpos) || objcts_1.otval[i__ - 1] != 0 || 
                prob_(&c__80, &c__60) || i__ == 11 || (objcts_1.oflag1[i__ - 
                1] & 40960) != 40960) {
            goto L1550;
        }
        newsta_(&i__, &c__0, &c__0, &c__0, &c_n61);
        objcts_1.oflag2[i__ - 1] = objcts_1.oflag2[i__ - 1] | 4;
        if (hack_1.thfpos == play_1.here && ! findex_1.deadf) {
            rspsub_(&rmk, &objcts_1.odesc2[i__ - 1]);
        }
/* vanishes before you. */
        goto L1700;
L1550:
        ;
    }
/* THIEFD, PAGE 5 */

/* Now move to new room. */

L1700:
    if (objcts_1.oadv[11] != -61) {
        goto L1725;
    }
/* did he steal rope? */
    findex_1.domef = FALSE_;
    findex_1.ttie = 0;
L1725:
    if (once) {
        goto L1800;
    }
    once = ! once;
L1750:
    --hack_1.thfpos;
/* next room. */
    if (hack_1.thfpos <= 0) {
        hack_1.thfpos = rooms_1.rlnt;
    }
    if ((rooms_1.rflag[hack_1.thfpos - 1] & 9232) != 8192) {
        goto L1750;
    }
/* must be land, profane. */
    hack_1.thfflg = FALSE_;
/* not announced. */
    goto L1025;

/* All done. */

/* once more. */
L1800:
    if (hack_1.thfpos == 103) {
        return 0;
    }
/* in treasure room? */
    j = 1055;
/* no, drop junky stuff. */
    if (hack_1.thfpos != play_1.here) {
        j = 0;
    }
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.oadv[i__ - 1] != -61 || prob_(&c__70, &c__30) || 
                objcts_1.otval[i__ - 1] > 0) {
            goto L1850;
        }
        newsta_(&i__, &j, &hack_1.thfpos, &c__0, &c__0);
        j = 0;
L1850:
        ;
    }
    return 0;

} /* thiefd_ */



