/*
** Gndmenu.t contains the menu items that are displayed any time the player
** types HELP or HINT
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+

modify menuItem
    fgcolor = 'olive'
    bgcolor = 'black'
;

modify submenuItem
    bgcolor = 'silver'
    fgcolor = '#003000'
;

top_menu: menuItem
    bgcolor = 'silver'
    fgcolor = '#003000'
    title = "Common Ground"
    myContents = [instruct_menu, fine_print_menu]
;

/*
 * The instructions & other info
 */
instruct_menu: submenuItem
    title = "Instructions and Information"
    myContents = [musings, first_time, moving, dealing_with_objects,
		  save_and_restore, special_commands, suggestions,
		  faq, credits]
;

musings: longTopicItem
    title = "About Common Ground"
    myContents = {
	"\tYou may have played some of my other pieces of IF, such as
	 <I>Losing Your Grip</I> or <B>Arrival</B>. And if so, you may
	 have certain notions of what <B>Common Ground</B> is going to
	 be like.

	 \b\tIf that's true in your case, forgive me if I take some
	 delight in surprising you.

	 \b\tFor one thing, you cannot get <B>Common Ground</B> in
	 a state where you won't be able to finish it. I've become
	 known for writing unforgiving puzzles which can close off
	 your progress unexpectedly. <B>Common Ground</B> won't do
	 that to you.

	 \b\tFor another, it's extremely short. It is, in fact,
	 shorter than <B>Arrival</B>, which was written to be winnable
	 in under two hours.

	 \b\tAnd that's really all I feel I can tell you without
	 giving things away. I'd love to hear from you, whether you
	 like the game or not. I'd especially love to hear from you
	 if you found a bug. You can e-mail me at
	 sgranade@phy.duke.edu for a while longer yet.

	 \bStephen<BR>Durham, North Carolina<BR>29 December, 1999";
    }
;

first_time: longTopicItem
    title = "For Newcomers to Text Adventures"
    myContents = {
	"\tAn adventure game lies somewhere between a story and a puzzle.
	 You play the main character, and the story unfolds around you
	 as you perform actions. You do this by giving yourself commands
	 at the <q>&gt;</q> prompt, commands such as";

	"\b<BLOCKQUOTE><tt>SIT\n
	 WALK EAST\n
	 TALK TO DEB\n
	 PUT THE TOAST IN THE TOASTER</TT></BLOCKQUOTE>";

	"\bIn response, the game will tell you what happens next. ";

	"\b\tBasic commands consist of either a verb by itself (such as
	 <TT>LOOK</TT> to see where you are) or a verb followed by nouns
	 (such as <TT>OPEN THE BOX</TT>). Think of the sentences you
	 type as things you are telling yourself to do.";

	"\b\tAs the story progresses, you will be faced with puzzles
	 which must be solved. These puzzles keep you from progressing
	 too quickly through the story. To solve the puzzles, think
	 about what you would do in such a situation. Clues will be
	 given in the form of the descriptions of things (which you may
	 see by typing <TT>EXAMINE [object]</TT> or simply <TT>X
	 [object]</TT>) and of actions which occur. ";

	"\b\tIf you would like more information about what sorts of
	 commands the game understands, please see the other help
	 topics in the menu containing this topic. ";
    }
;

moving: longTopicItem
    title = "Moving Around"
    myContents = {
	"\tAn adventure game typically has a layout of locations (called
	 <q>rooms</q> whether or not they're indoors). You move between
	 them by specifying compass directions:";

	"\b<BLOCKQUOTE><tt>GO SOUTH</TT></BLOCKQUOTE>";

	"\b\tThe directions can be abbreviated as <TT>SOUTH</TT>, for
	 example, or even just <TT>S</TT>. You can move north, south,
	 east, west, northeast, northwest, southeast, and southwest.
	 In addition, on occasion you can move <TT>IN</TT> or
	 <TT>OUT</TT>, as well as <TT>UP</TT> or <TT>DOWN</TT>. ";
    }
;

dealing_with_objects: longTopicItem
    title = "Dealing With Objects"
    myContents = {
	"\tMuch of what you will be doing in an adventure is dealing
	 with objects. Many of them are portable, and may be picked
	 up using the <TT>TAKE</TT> command. If you get tired of toting
	 something around you can <TT>DROP</TT> it. To find out what
	 you're carrying, you may type <TT>INVENTORY</TT> (or simply
	 <TT>I</TT>). ";

	"\b\tOther items are not portable, but may be tampered with.
	 Still other items are only mentioned for decoration; if
	 you ever try to do something to an item and are told,
	 <q>That's not important,</q> then you don't have to do
	 anything with that item. ";

	"\b\tSometimes you will want to deal with many items at once.
	 If that occurs, you can use <TT>ALL</TT>, as in <TT>DROP
	 ALL</TT>, which will drop everything you're carrying. You
	 may also refer to several items in one command: ";

	"\b<BLOCKQUOTE><tt>DROP EVERYTHING BUT THE BOOK\n
	 PUT THE SLINKY, THE YO-YO, AND THE BOUNCY BALL IN THE TOY
	 CHEST</TT></BLOCKQUOTE>";

	"\b\tSometimes, if you don't specify what object you want
	 to perform a command on, the game can guess what you mean.
	 Whenever it does this, it will let you know by printing
	 its assumptions in parentheses after your command.";

	"\b<BLOCKQUOTE><tt>TIE THE YELLOW RIBBON</TT>\n
	 (around the old oak tree)\n
	 You tie the ribbon around the tree.</BLOCKQUOTE> ";

	"\b\tIf the game cannot guess what you mean, it will ask you
	 a question such as, <q>What do you want to tie that to?</q>
	 You may either type in what object you want to perform the
	 action on, or type a new command. ";

	"\b\tSometimes you refer to an object by a name which fits
	 more than one object. In that case, the game will ask you
	 which one you mean. ";

	"\b<BLOCKQUOTE><tt>GET THE WICKED WITCH</TT>\n
	 Which wicked witch do you mean, the Wicked Witch of the East
	 or the Wicked Witch of the West?</BLOCKQUOTE>";

	"\bYou may either say which object you mean or type a new
	 command. ";

	"\b\tThe pronoun <q>it</q> refers to the last object you have
	 manipulated, while <q>him</q> and <q>her</q> refer to the last
	 man or woman you have dealt with. ";

	"\b\tThis is only a small sampling of what is possible in a
	 game such as <b>Common Ground</b>. Don't be afraid to
	 experiment. ";
    }
;

save_and_restore: longTopicItem
    title = "Saving and Restoring"
    myContents = {
	"\tEven such a short game as <b>Common Ground</b> may be
	 longer than you can play in one sitting. Or you may want to
	 try something that may be dangerous and you don't want to
	 have to replay large parts of the game. In either case, you
	 can make a snapshot of your game in progress by using the
	 <tt>SAVE</tt> command. When you do, you will be prompted
	 for a filename for the saved game. To get back to a previously
	 saved position, use the <tt>RESTORE</tt> command and, when
	 prompted, give the filename you called your saved game. ";

	"\b\tIf you would like to start over, you can with the
	 <TT>RESTART</TT> command. You may give up entirely with
	 the <TT>QUIT</TT> command. ";
    }
;

special_commands: longTopicItem
    title = "Special Commands"
    myContents = { commandsVerb.describeMe; }
;

suggestions: longTopicItem
    title = "Commenting on the Game"
    myContents = {
	"\tAfter you've finished the game, you may want to make comments
	 on things the game did well or poorly. Alternatively, you
	 may have found bugs or misspellings which mar the game. In
	 either case, I would love to hear from you. You may e-mail
	 me at";

	"\b<blockquote>sgranade@phy.duke.edu</blockquote>";

	"\b\tOut of the kindness of your heart, please do not advertise
	 any bugs you find on any of the Usenet newsgroups dedicated to
	 interactive fiction.";
    }
;

credits: longTopicItem
    title = "Credits"
    myContents = { creditsVerb.describeMe; }
;

faq: submenuItem
    title = "Frequently Asked Questions"
    myContents = [whats_flowerdy, true_life]
;

whats_flowerdy: longTopicItem
    title = "You didn't mean <q>flowerdy,</q> did you?"
    myContents = {
	"Yes. It's a good ol' Southernism meaning <q>flowery</q>.
	 The flowerdy bag has flowers printed on it. ";
    }
;

true_life: longTopicItem
    title = "Is <q>Common Ground</q> based on a true story?"
    myContents = "Not really. Some parts were inspired by things
		  which happened to friends of mine, but Jeanie,
		  Frank, and Deb aren't based on real people. "
;

/*
 * The fine print
 */
fine_print_menu: submenuItem
    title = "Fine Print"
    myContents = [legalese, version_info, author_info]
;

legalese: longTopicItem
    title = "Legal Issues"
    myContents = {
        "<b>Copyright Information</b>
            \b\tThis game, <b>Common Ground</b>, is copyright &copy; 1999 by
            Stephen Granade.
        \b<b>Licensing Information</b>
            \b\tI place the following terms and conditions on copying and
            distributing <b>Common Ground</b>: You may copy and distribute
            <b>Common Ground</b> in whatever format you choose, as long as
	    it (and especially its copyright information) is not altered.
	    You may not distribute this game for a fee which is greater
	    than the cost of distribution. Distribution of this game
	    constitutes acceptance of this license.
        \b<b>A Legal Dodge</b>
            \b\tBecause this game is offered free of charge, there is no
            warranty attached to it. Whatever happens to your computer while
            playing <b>Common Ground</b> is your problem to deal with. ";
    }
;

version_info: longTopicItem
    title = "Version Information"
    myContents = {
	"This is the second version of <B>Common Ground</B>, compiled
	 on 17 Jan 2000. This version fixes a number of small bugs. ";
        "The first version of <B>Common Ground</B> was compiled
	 on 29 Dec 1999.";
    }
;

author_info: longTopicItem
    title = "About the Author"
    myContents = {
	"\tStephen Granade is currently finishing up a degree in physics
	 at Duke University in Durham, North Carolina. In his spare time
	 he maintains a web site dedicated to interactive fiction at
         http://interactfiction.about.com. He has also been known to
         run the annual IF Competition.";

	"\b\tThis is the fifth full game he will admit to writing. If
	 you like <b>Common Ground</b>, why not try <b>Arrival</b> or
	 <i>Losing Your Grip</i>? If you don't like <b>Common Ground</b>,
	 try the other games anyway&mdash;they're quite different from
	 this one. All are available from the GMD archive at
	 ftp://ftp.gmd.de/if-archive/games/tads.";
    }
;
