/* cvend.c
 *	do stuff about the end of the game.
 *************************************************************************/

#include <stdio.h>
#include "cvmisc.h"
#include "cvobj.h"
#include "cvlocs.h"
#include "cvocab.h"

void
getscore()
{
    struct cvobj *object;
    struct hint *hint;

    score = 0;
    /* get a first impression of how far the adventurer went */
    if (RICK->prop > 0)
	score = 10;
    if (DAM->prop > 0)
	score = 25;
    if (dflag != 0)
	score = 30;
    if (THRONE->prop == 0)
	score = 35;
    mxscore = 35;

    /* tally treasures.  Full points if in barn and not broken.
	    2 points each for treasures seen. */
    for (object = MINTRS; object < ENDTRS; ++object) {
	int value;

	mxscore +=
	    (value = (object < RUG) ? 12 : ((object == RUG) ? 14 : 16));
	if (object->prop >= 0) {
	    if (INBARN(object)
		&& (object->prop == 0 || object == CUP))
		score += value;
	    else
		score += 2;
	}
    }

    /* Now look at how he finished, and how far he got.
     *	"maxdie" and "numdie" tell us how well he survived.
     *	"gaveup" says whether he is using "QUIT".
     *	"dflag" will tell us if he ever got suitably deep into the cave.
     *	"closing" still indicates whether he reached the endgame.
     *	if he got as far as "CAVE CLOSED" then bonus will be false for
     *		mundane exits.
     */
    score += (maxdie - numdie) * 10;
    mxscore += maxdie * 10;
    if (!scoring && !gaveup)
	score += 10;
    mxscore += 10;
    if (closing)
	score += 30;
    mxscore += 30;
    if (closed) {
	score += 5;
	if (bonus)
	    score += 15;
    }
    mxscore += 20;

    for (hint = hints; hint->turns >= 0; ++hint) {
	if (hint->hinted)
	    score -= hint->points;
    }
    return;
}
