! ROOM_Objects.h, where all room definitions are stored.

! By C.E. Forman.
Class AGTRoom
 with
  n_to
  [;
   print "You can't go north from here!^";
   return self;
  ],
  s_to
  [;
   print "You can't go south from here!^";
   return self;
  ],
  e_to
  [;
   print "You can't go east from here!^";
   return self;
  ],
  w_to
  [;
   print "You can't go west from here!^";
   return self;
  ],
  u_to
  [;
   print "You can't go up from here!^";
   return self;
  ],
  d_to
  [;
   print "You can't go down from here!^";
   return self;
  ],
  ne_to
  [;
   print "You can't go northeast from here!^";
   return self;
  ],
  nw_to
  [;
   print "You can't go northwest from here!^";
   return self;
  ],
  se_to
  [;
   print "You can't go southeast from here!^";
   return self;
  ],
  sw_to
  [;
   print "You can't go southwest from here!^";
   return self;
  ],
  in_to
  [;
   print "You can't go in from here!^";
   return self;
  ],
  out_to
  [;
   print "You can't go out from here!^";
   return self;
  ],
  short_name
  [;
   print "<< ";
   print (object)self;
   print " >>";
   rtrue;
  ]
 has
;

! Limbo - a special room.
AGTRoom ROOM_Limbo "Limbo"
 with
  description "Limbo is a special room, not intended to be visited.",
  name "limbo"
 has
  enterable
  light
;

! Chief's office.
AGTRoom ROOM_Chief "Chief's office"
 with
  description
  [;
   print "You are standing in the Chief's office. ";
   Quip (1, 1, Mike, "So is this guy Commissioner Gordon, or what?", 2);
   print "He is telling you ~The Mayor was murdered yeaterday night ";
   Quip (0, 1, Mike, "Yeaterday? Is that like Veterans' Day?", 2);
   print "at 12:03 am. I want you to solve it before we get any bad publicity ";
   Quip (0, 1, Crow, "Which would only serve to counteract the GOOD publicity brought about by the mayor's death!", 2);
   print "or the FBI has to come in. ";
   Quip (0, 1, Tom, "~Tonight on the X-Files!~", 2);
   print "~Yessir!~ You reply. He hands you a sheet of paper. Once you have read it, go north or west.^";
   Quip (1, 1, Tom, "Uh... haven't we been through this already?", 1);
   rtrue;
  ],
  n_to ROOM_Outside1,	! Outside 1
  w_to ROOM_Closet1	! Closet 1
 has
  enterable
  light
  scored
;

! Closet 1.
AGTRoom ROOM_Closet1 "Closet"
 with
  description
  [;
   print "You are in a closet. ";
   Quip (0, 1, Crow, "So?", 2);
   print "There is a gun on the floor. Better get it. ";
   ! If the gun isn't in the location or has been moved, then give a suitable message.
   if (OBJECT_Gun notin location || OBJECT_Gun has moved)
   {
    ! Seen this now.
    Quip (0, 1, Tom, "Yes, the gun remains here despite the fact that we've already picked it up.", 1);
    Quip (0, 0, Mike, "How DO you do it, Matt Barringer?", 2);
   }
   "To exit, go east.";
  ],
  e_to ROOM_Chief	! The Chief's office (yes, a TWO-WAY door).
 has
  enterable
  light
;

! Outside 1.
AGTRoom ROOM_Outside1 "Outside"
 with
  description
  [;
   print "You are outside in the cold. To the east is a dead end. To the west is the rest of the street. Papers are blowing around. It's amazingly cold for this time of year.^";
   Quip (0, 1, Mike, "[Minnesotan voice] Yah, that kinda weather'll take ya by surprise, all right.", 1);
   Quip (0, 0, Crow, "[Minnesotan voice] Oh, yah, I remember the summer of '58 when it got ta be this cold.", 1);
   Quip (0, 0, Tom, "[Minnesotan voice] Yah, we musta got at least 8 feet o' snow that day, and all the streets was closed.", 1);
   rtrue;
  ],
  e_to
  [;
   print "You can't go east from here!^";
   Quip (0, 0, Crow, "So why bother mentioning there's a dead end to the east, then?", 1);
   rtrue;
  ],
  s_to
  [;
   print "You can't go south from here!^";
   Quip (0, 0, Tom, "Sorry, folks, it looks like the door just vanished into thin air.", 1);
   rtrue;
  ],
  w_to ROOM_Outside2	! Outside 2
 has
  enterable
  light
;

! Outside 2.
AGTRoom ROOM_Outside2 "Outside"
 with
  description
  [;
   print "You are still on the streets. To the north is a restraunt ";
   Quip (0, 1, Mike, "Uh, I think you mean ~restaurant,~ Matt.", 2);
   print "where the mayor ate often. To the east is the Mayor's home.^";
   Quip (0, 1, Crow, "Hey, isn't the street back to the east?", 1);
   rtrue;
  ],
  e_to ROOM_MayorsHouse,	! Mayor's house.
  n_to ROOM_Restaurant		! Restraunt (sic).
 has
  enterable
  light
  scored
;

! The restraunt (sic).
AGTRoom ROOM_Restaurant "Restraunt"
 with
  description
  [;
   ! High-class thugs do you in.
   print "You are about to enter the restraunt when two guys jump you. They take your wallet and beat you a bit. Then you flash your badge and that riles them. Your body was discovered in a river 10 miles away.^";
   Quip (-1, 1, Mike, "Man, that is one rough T.G.I. Friday's!", 1);
   deadflag=self.number;	! You're dead.
   rtrue;
  ],
  number 1
 has
  enterable
  light
;

! The Mayor's house.
AGTRoom ROOM_MayorsHouse "Mayor's house"
 with
  description
  [;
   Quip (0, 1, Crow, "I thought the street was back this way!", 1);
   Quip (0, 0, Mike, "Nope, apparently we were mistaken.", 2);
   print "You are in the house, at the scene of the crime. You enter ";
   Quip (0, 1, Tom, "Didn't it just say we were already IN the house?", 2);
   print "and flash your badge before a cop. He admits you. ";
   Quip (0, 1, Mike, "[As your character] Where's the body?", 1);
   Quip (0, 0, Crow, "[As the cop] I ate it.", 2);
   print "To the north is the upstairs. To the east is the living room and to the west is the dining room.^";
   Quip (0, 1, Tom, "I thought we just CAME from the west!", 1);
   Quip (0, 0, Mike, "I don't think this author quite grasped the concept of a two-way door.", 1);
   Quip (0, 0, Crow, "And you'd think the upstairs would be UP from here!", 1);
   Quip (1, 1, Tom, "But he already admitted us!", 1);
   Quip (1, 0, Crow, "Why, Mike? Why does it do this?", 1);
   Quip (1, 0, Mike, "Shhh, it's okay, guys.", 1);
   rtrue;
  ],
  e_to ROOM_Living,	! Living room.
  n_to ROOM_Upstairs,	! Upstairs hallway.
  w_to ROOM_Dining	! Dining room.
 has
  enterable
  light
  scored
;

! The dining room.
AGTRoom ROOM_Dining "Dining room"
 with
  description
  [;
   print "You are in the dining room. You look around and see a note on the table. ";
   if (OBJECT_Note has moved)	! Where's the note?
   {
    Quip (0, 1, Mike, "The exact same note you picked up only moments before.", 1);
    Quip (0, 0, Tom, "It's magic!", 2);
   }
   print "You can go back east.^";
   Quip (0, 1, Crow, "Wow! A two-way door! We can go back! Check it out, Mike!", 1);
   rtrue;
  ],
  e_to ROOM_MayorsHouse	! The Mayor's house proper.
 has
  enterable
  light
;

! The living room.
AGTRoom ROOM_Living "Living room"
 with
  description
  [;
   print "You are standing in the living room. You see a battered piece of wood. You wonder ~Should I pick this thing up?~. ";
   Quip (0, 1, Mike, "Wow, it's like he's reading our minds.", 2);
   if (OBJECT_Wooden has moved)	! Wooden wood (sic) is not here.
   {
    Quip (0, 1, Crow, "Pick what up, Matt?", 2);
   }
   "Well, whether you do or don't the only way out of the room is back west.";
  ],
  w_to ROOM_MayorsHouse	! Mayor's house.
 has
  enterable
  light
;

! The upstairs hallway.
AGTRoom ROOM_Upstairs "Upstairs hallway"
 with
  description
  [;
   print "You are in the hallway of the large house of the mayor. It is an amazingly large house. ";
   Quip (0, 1, Crow, "The house is so large it is amazing.", 1);
   Quip (0, 0, Tom, "You are amazed by how large the mayor's large house is.", 1);
   Quip (0, 0, Mike, "The amazing largeness of the mayor's large house amazes you.", 2);
   "You can go north, south, east or west.";
  ],
  e_to ROOM_Bath,		! Bathroom.
  n_to ROOM_Hallway1,		! Hallway 1.
  s_to ROOM_MayorsHouse,	! Mayors' house.
  w_to ROOM_Closet2		! Closet 2.
 has
  enterable
  light
  scored
;

! Closet 2.
AGTRoom ROOM_Closet2 "Closet"
 with
  description
  [;
   print "You are in a closet. The closet is of the walk in variety, with about thirty pairs of tennis shoes, ten pairs of heels and about ninety coats and shirts. ";
   Quip (0, 1, Tom, "None of which you can interact with, so don't bother trying.", 2);
   print "You start to get claustrophobia. ";
   Quip (0, 1, Crow, "Klaustrophobia? Let's play that instead!", 2);
   print "Better get out.^";
   Quip (0, 1, Tom, "Of this game.", 1);
   rtrue;
  ],
  e_to ROOM_Upstairs	! Upstairs hallway.
 has
  enterable
  light
;

! The bathroom.
AGTRoom ROOM_Bath "Bathroom"
 with
  description
  [;
   print "You are in the first bathroom, out of the 5 there is. ";
   Quip (0, 1, Tom, "Yes, there IS five bathrooms in this house.", 1);
   Quip (0, 0, Crow, "I bet the mayor needed all those bathrooms because he had to --", 1);
   Quip (0, 0, Mike, "[Grab's Crow's beak and holds it shut] Not another word, Crow.", 2);
   print "You notice that it is almost as big as your apartment. ";
   Quip (0, 1, Tom, "Oh no. Don't tell me you play Mitchell in this game!", 1);
   Quip (0, 0, Crow, "Mitchell -- ask for him by name.", 2);
   "You see a knife on the floor here.";
  ],
  w_to ROOM_Upstairs	! Upstairs hallway.
 has
  enterable
  light
;

! Hallway 1.
AGTRoom ROOM_Hallway1 "Hallway"
 with
  description
  [;
   print "You are at the end of the hallway. To the north is a room, while to the west is the rest of the hallway.^";
   Quip (0, 1, Crow, "Except the part that's to the south.", 1);
   Quip (1, 1, Tom, "Do you know who did it? Have you figured it out yet?", 1);
   rtrue;
  ],
  n_to ROOM_Closet3,	! Closet 3
  w_to ROOM_Hallway2	! Hallway 2
 has
  enterable
  light
;

! Closet 3.
AGTRoom ROOM_Closet3 "Closet"
 with
  before
  [;
   Go:	! South.
    if (noun==s_obj)	! Crow!
    {
     Quip (0, 1, Crow, "Ahh, coming out of the closet!", 1);
     Quip (0, 0, Mike, "Stop it, Crow.", 2);
     PlayerTo (self.s_to);
     rtrue;
    }
  ],
  description
  [;
   print "You are in a closet. There is no reason to be in here. Go south.^";
   Quip (0, 1, Tom, "There is no reason to have this room in the game, but we put it here anyway.", 1);
  ],
  s_to ROOM_Hallway1	! Hallway 1
 has
  enterable
  light
;

! Hallway 2.
AGTRoom ROOM_Hallway2 "Hallway"
 with
  description
  [;
   print "You are in the hallway. To the north is more hallway, and to the east is a door marked ~Guests~.^";
   Quip (0, 1, Crow, "I'm starting to get really sick of this hallway.", 1);
   Quip (0, 0, Mike, "Patience, Crow. It can't go on forever.", 1);
   Quip (0, 0, Crow, "Tell me about it.", 1);
  ],
  e_to ROOM_Guest1,	! Guest room 1.
  n_to ROOM_Hallway3	! Hallway 3.
 has
  enterable
  light
;

! Guest room 1.
AGTRoom ROOM_Guest1 "Guest Room"
 with
  description
  [;
   print "You are in one of the many guest rooms. It is a nice room, big screen TV in one corner, 2 king size beds in the back of the room, strategically placed so that you can see the TV while comfortably propped up in bed. You see nothing of intrest, you should go west.^";
   Quip (0, 1, Tom, "He described all that just to tell us there's nothing to do here?", 1);
   Quip (0, 0, Crow, "This is Matt's best room description so far.", 1);
   Quip (0, 0, Tom, "That's not saying much.", 1);
   rtrue;
  ],
  w_to ROOM_Hallway2	! Hallway 2
 has
  enterable
  light
;

! Hallway 3
AGTRoom ROOM_Hallway3 "Hallway"
 with
  description
  [;
   print "You are STILL in the hallway. ";
   Quip (0, 1, Crow, "Aaaaarrgh! NO! Get me outta here!", 2);
   print "There is EVEN MORE hallway to the north, ";
   Quip (0, 1, Crow, "That's it. I'm leaving. [Crow tries to get up, but Mike holds him back]", 2);
   "and a room to the west and a room to the east of you.";
  ],
  e_to ROOM_Closet5,	! Closet 5
  n_to ROOM_Hallway4,	! Hallway 4
  w_to ROOM_Closet4	! Closet 4
 has
  enterable
  light
;

! Closet 4
AGTRoom ROOM_Closet4 "Closet"
 with
  description
  [;
   print "You are in a closet. There is no reason to be in here. Go west.^";
   Quip (0, 1, Tom, "What the...? We came in here from the EAST!", 1);
   Quip (0, 0, Crow, "Try going west.", 1);
   Quip (1, 1, Crow, "[Ominous] We have entered the mysterious Closets of Teleportation!", 1);
   Quip (1, 0, Mike, "Beam us up, Scotty.", 1);
   rtrue;
  ],
  w_to ROOM_Hallway3	! Hallway 3
 has
  enterable
  light
;

! Closet 5
AGTRoom ROOM_Closet5 "Closet"
 with
  description
  [;
   print "You are in a small closet. The room is bare. Why not go east and get back to the situation at hand?^";
   Quip (0, 1, Tom, "What the...? We came in here from the EAST!", 1);
   Quip (0, 0, Crow, "Try going east.", 1);
   Quip (1, 1, Crow, "[Ominous] We have entered the mysterious Closets of Teleportation!", 1);
   Quip (1, 0, Mike, "Beam us up, Scotty.", 1);
   rtrue;
  ],
  e_to ROOM_Hallway3	! Hallway 3
 has
  enterable
  light
;

! Hallway 4
AGTRoom ROOM_Hallway4 "Hallway"
 with
  before
  [;
   Go:	! Moving out.
    if (noun==n_obj)	! Going outside.
    {
     Quip (-1, 1, Crow, "Oh, thank God that hallway's over with!", 2);
     PlayerTo (self.n_to);
     rtrue;
    }
  ],
  description
  [;
   print "You are still in the hallway. ";
   Quip (0, 1, Crow, "AAAARRRGGHHH! MAKE IT STOP, MAKE IT STOP, MAKE IT STOP -- [Mike pats Crow's shoulder reassuringly until he calms down]", 2);
   print "You can go north to where there is a police officer who will let you outside, or you can go east or west.^";
   Quip (0, 1, Crow, "North! Go north! Get us out of here!", 1);
   rtrue;
  ],
  e_to ROOM_Guest2,	! Guest room 2
  n_to ROOM_Outside3,	! Outside 3
  w_to ROOM_Bed		! Bedroom.
 has
  enterable
  light
;

! Guest room 2
AGTRoom ROOM_Guest2 "Guest Room"
 with
  description
  [;
   print "You are in a guest room. You see that there isn't much here, the murderers ransacked the room. ";
   Quip (0, 1, Mike, "Yet for some reason they didn't touch the big screen TV in the OTHER guest room!", 2);
   "You can go west.";
  ],
  w_to ROOM_Hallway4	! Hallway 4
 has
  enterable
  light
;

! The bedroom.
AGTRoom ROOM_Bed "Bedroom"
 with
  description
  [;
   print "You are in the bedroom. You noticed that there was a guard guarding the stairs to the 3rd story, ";
   Quip (0, 1, Mike, "Yeah, that's what guards typically do. They guard things.", 1);
   Quip (0, 0, Crow, "Hence the name.", 2);
   print "because there is remodelling going on there. ";
   Quip (0, 1, Tom, "And remodelling is far more important than some petty murder investigation.", 2);
   "You see nothing of importance. Go east.";
  ],
  e_to ROOM_Hallway4
 has
  enterable
  light
  scored
;

! Outside 3
AGTRoom ROOM_Outside3 "Outside"
 with
  description
  [;
   print "You pass the guard. He nods at you. You are now outside standing on the street. ";
   Quip (1, 1, Tom, "Hey, guys, I just thought I'd point out once again how this game blends the room, object, and character descriptions into a muddled mess.", 1);
   Quip (1, 0, Mike, "Thanks for the reminder, Tom.", 2);
   print "You can go north and east, your choice. ";
   Quip (0, 1, Mike, "It's good when a game lets players make a choice like this.", 1);
   Quip (0, 0, Crow, "Matt Barringer made a wise creative decision here.", 2);
   "To the north is more of the street, and to the east is a video store.";
  ],
  e_to ROOM_Video1,	! Video store 1
  n_to ROOM_DeadEnd1	! Dead end 1
 has
  enterable
  light
  scored
;

! 'Dead end'.
AGTRoom ROOM_DeadEnd1 "Dead End"
 with
  description
  [;
   print "You are at a dead end. You can go south or west. Which way?^";
   Quip (0, 1, Tom, "Mike, is it really a dead end if you can go 2 ways?", 1);
   rtrue;
  ],
  s_to ROOM_Outside3,
  w_to ROOM_Lounge	! Murderer's Lounge.
 has
  enterable
  light
;

! The Murderer's lounge.
AGTRoom ROOM_Lounge "Murderer's Lounge"
 with
  description
  [;
   ! You die here.
   print "You are in the so called ~Murderers Lounge~. Unfortunately, there ARE murderers here, and when you check around, they get angry. But, that's life. Ya lose!^";
   Quip (-1, 1, Tom, "And that's death.", 1);
   Quip (-1, 0, Crow, "But it's nice to know that this city has establishments that cater exclusively to criminals.", 1);
   Quip (-1, 0, Mike, "No weapon, no criminal record, no service!", 1);
   deadflag=self.number;	! Someone call the funeral home...
  ],
  number 1
 has
  enterable
  light
;

! Video store 1
AGTRoom ROOM_Video1 "Video Store"
 with
  description
  [;
   print "You are in a video store called Brickbuster Video. ";
   Quip (0, 1, Mike, "Let's make it a Brickbuster night!", 2);
   print "There are about 3,000 videos here. You can go north, or east.^";
   Quip (0, 1, Tom, "But the door you came through has mysteriously disappeared.", 1);
   Quip (0, 0, Mike, "Hey, that really deters late-night robberies.", 1);
   Quip (1, 1, Crow, "Wonder if they have ~Caligula~?", 1);
   Quip (1, 0, Mike, "Crow!", 1);
   Quip (1, 0, Tom, "Or maybe ~Mandingo.~", 1);
   Quip (1, 0, Mike, "Tom!", 1);
   rtrue;
  ],
  e_to ROOM_Video2,	! Video store 2
  n_to ROOM_Backroom	! Backroom
 has
  enterable
  light
;

! The backroom
AGTRoom ROOM_Backroom "Backroom"
 with
  description
  [;
   print "You are in the backroom of Brickbuster Video. ";
   Quip (0, 1, Crow, "[Little kid voice] I hafta go to the bathroom!", 2);
   print "You see a small video on the floor, but you dismiss it as having no potential value to the crime. ";
   Quip (0, 1, Mike, "Boy, nothing in this game is connected to the crime!", 1);
   Quip (0, 0, Crow, "What crime were we supposed to be investigating, again?", 1);
   Quip (0, 0, Mike, "You've got me, Crow.", 1);
   "You can go south.";
  ],
  s_to ROOM_Video1	! Video store 1
 has
  enterable
  light
;

! Video store 2
AGTRoom ROOM_Video2 "Video Store"
 with
  description
  [;
   print "You are still in the video store. ";
   Quip (0, 1, Mike, "Hey guys, there are a lot of movies here that I've never seen before: The Amazing Colossal Man, Marooned, Castle of Fu Manchu, Ring of Terror, The Sidehackers... Want to rent one?", 1);
   Quip (0, 0, CrowTom, "Noooooooooo!", 2);
   "You can go north, or east.";
  ],
  e_to ROOM_Outside4,	! Outside 4
  n_to ROOM_Closet6	! Closet 6
 has
  enterable
  light
  scored
;

! Closet 6
AGTRoom ROOM_Closet6 "Closet"
 with
  description
  [;
   print "You are in a closet. There is no use for being here. Gotta go south.^";
   Quip (0, 1, Tom, "Why do I get the feeling that Matt Barringer is just padding out the game?", 1);
   rtrue;
  ],
  s_to ROOM_Video2
 has
  enterable
  light
;

! Outside 4
AGTRoom ROOM_Outside4 "Outside"
 with
  description
  [;
   print "You are outside. You can go north, south, east or west.^";
   Quip (1, 1, Mike, "You know, it's the vivid descriptions that make this game come alive.", 1);
   rtrue;
  ],
  e_to ROOM_House,	! House
  n_to ROOM_Outside5,	! Outside 5
  s_to ROOM_McDonalds,	! McDonalds
  w_to ROOM_Video2	! Video store 2
 has
  enterable
  light
;

! McDonalds.
AGTRoom ROOM_McDonalds "McDonalds"
 with
  before
  [;
   Go:	! Moving out.
    if (noun==n_obj)	! Comment on not being killed.
    {
     Quip (0, 1, Crow, "Hey, Mike, I just noticed that no one killed us in that restaurant.", 1);
     Quip (0, 0, Mike, "Those thugs probably find fast-food franchises to be too low-class.", 2);
     PlayerTo (self.n_to);
     rtrue;
    }
  ],
  description
  [;
   Quip (0, 1, Crow, "Boy, I could really go for a hamburger sandwich and some French-fried potatoes!", 2);
   print "You are in a McDonalds. You pay the guy behind the counter. ";
   Quip (0, 1, Mike, "Shouldn't you have ordered first?", 1);
   Quip (0, 0, Tom, "Nah, this is fast food. It all tastes the same.", 2);
   print "Now there is a hamburger there. ";
   ! If the hamburger isn't here, display a comment.
   if (OBJECT_Food notin location)
   {
    Quip (0, 1, Tom, "By an astounding coincidence, it's the same one you picked up earlier!", 1);
    Quip (0, 0, Crow, "This could solve the world hunger problem in no time!", 2);
   }
   "When you have picked it up, go north.";
  ],
  n_to ROOM_Outside4
 has
  enterable
  light
;

! House
AGTRoom ROOM_House "House"
 with
  description
  [;
   print "You enter the house. A man charges down the stairs. Before you even have time to say anything, he shoots you. You lose!^";
   Quip (-1, 1, Crow, "Once again, the social effects of listening to Ice-T's ~Cop Killer~ song.", 1);
   deadflag=self.number;	! Call out the funeral home...
   rtrue;
  ],
  number 1
 has
  enterable
  light
;

! Outside 5
AGTRoom ROOM_Outside5 "Outside"
 with
  description
  [;
   print "You are still outside. You hit a dead end, then notice that you can go east only.^";
   Quip (0, 1, Crow, "Mike, I'm lost. Where are we?", 1);
   rtrue;
  ],
  e_to ROOM_Music1	! Music store 1
 has
  enterable
  light
  scored
;

! Music store 1
AGTRoom ROOM_Music1 "Music Store"
 with
  description
  [;
   print "You are in a music store. ";
   Quip (0, 1, CrowTom, "No! NO! NO!", 1);
   Quip (0, 0, Crow, "Not Mr. B Natural again!", 1);
   Quip (0, 0, Tom, "Make it stop, Mike!", 2);
   print "You ask the man behind the counter if he knew any information. ";
   Quip (0, 1, Mike, "So are we just grasping at straws now?", 2);
   print "~Uhh... nope! But the guy back there might be able ta help.~ You politly thank him and head to the back. You can only go north.^";
   Quip (0, 1, Tom, "So, was that man behind the counter the STAFF of the music store? Staff?", 1);
   Quip (0, 0, MikeCrow, "[Groan]", 1);
   rtrue;
  ],
  n_to ROOM_BackMusic	! Back of music store
 has
  enterable
  light
  scored
;

! Back of music store.
AGTRoom ROOM_BackMusic "Back of Music Store"
 with
  description
  [;
   print "You are in the back of the music store. ";
   Quip (0, 1, Mike, "Just like the name of this room says.", 2);
   print "You ask the guy who's looking at the cool tapes. ";
   if (NPC_Dazed notin ROOM_Music2)	! Enquire about dead man.
   {
    Quip (0, 1, Tom, "Hey, you know anything about the guy I just killed? Did he kill the mayor or something?", 2);
   }
   print "He looks up at you. ~Duh.. no... don't t'ink so... lemme see...~ ";
   Quip (0, 1, Crow, "So what exactly did we ask him about?", 2);
   if (NPC_Dazed notin ROOM_Music2)	! Comment on dead man.
   {
    Quip (0, 1, Tom, "Well, thanks anyway.", 2);
   }
   "You decide that he's no help. To the west there is a dazed looking man and to the north there is an exit.";
  ],
  n_to ROOM_Alley,	! Alley
  w_to ROOM_Music2	! Music store 2
 has
  enterable
  light
  scored
;

! Music store 2
AGTRoom ROOM_Music2 "Music Store"
 with
  before
  [;
   Go:
    if (NPC_Dazed in location)	! Not with the man here!
    {
     "The dazed man blocks your way!";
    }
  ],
  description
  [;
   print "You walk over to the guy. ";
   if (NPC_Dazed notin location)	! But he's not here!
   {
    Quip (0, 1, Tom, "He's already dead and gone, but you walk over to him anyway.", 2);
   }
   print "He jumps up with a wild look, ";
   if (NPC_Dazed notin location)	! Who's jumping up?
   {
    Quip (0, 1, Crow, "Despite his body having vanished in a cloud of green smoke.", 2);
   }
   print "and says ~Freeze!~. You stop. He motions you to the exit. ";
   Quip (0, 1, Mike, "So he doesn't want you to move, yet he wants you to leave?", 2);
   print "But you know he'll probably just kill you. ";
   Quip (0, 1, Tom, "Probably? He's an AGT hostile monster, of course he'll kill you!", 2);
   print "You NEED to get the weapon from him or kill him. Best chance: use your gun.^";
   Quip (0, 1, Crow, "Assuming you brought it with you, of course.", 1);
   rtrue;
  ],
  e_to ROOM_BackMusic	! Back of music store
 has
  enterable
  light
;

! Alley
AGTRoom ROOM_Alley "Alley"
 with
  description
  [;
   print "You are in an alley. A drunken man stagers up to you and says ~Boycott FDR! <HICKUP>.~. You just walk away. ";
   Quip (0, 1, Mike, "What was THAT all about?", 2);
   "You can go north, east or west. Your call.";
  ],
  e_to ROOM_Drug,	! Drug house
  n_to ROOM_Police,	! Police station
  w_to ROOM_Mob	! Mob house
 has
  enterable
  light
  scored
;

! Drug house
AGTRoom ROOM_Drug "Drug House"
 with
  description
  [;
   print "You are in a druggies house.^";
   Quip (-1, 1, Crow, "Of pancakes.", 2);
   print "Guys look over at you. ~Hey! It's a cop! Get 'im!~ One yells.^";
   Quip (-1, 1, Tom, "So how come these guys know you're a cop, but the guys who jumped you in the restaurant didn't know until you flashed your badge.", 2);
   print "They all grab their guns and aim' em at you. When the police find you 2 days later, you are scattered across the room - literally.^";
   Quip (-1, 1, Tom, "So why didn't the other cops get shot when they came in?", 1);
   deadflag=self.number;	! Death by dying.
   rtrue;
  ],
  number 1	! Death.
 has
  enterable
  light
;

! Mob house
AGTRoom ROOM_Mob "Mob House"
 with
  description
  [;
   print "You enter the infamous ~Mob House~.^";
   Quip (-1, 1, Crow, "Of pancakes.", 2);
   print "When you enter a hush quiets the room as guys in ugly pin striped suits look over at you. Fearing for your life, you turn to run away. But before you can do that, a big thug comes by with a .44 and shoots you in the head. A grisly death, for sure.^";
   Quip (-1, 1, Mike, "Gee, you'd think the Chief would've told you where these places were, so you could avoid them.", 1);
   deadflag=self.number;	! Death by dying.
  ],
  number 1	! Death.
 has
  enterable
  light
;

! Police station
AGTRoom ROOM_Police "Police Station"
 with
  description
  [;
   print "You are in the 3rd precinct police station. This isn't your station. ";
   Quip (0, 1, Mike, "So don't put your feet up on the desks.", 2);
   print "You get admitance from the guy at the desk and go to the holding cells. You ask each offender if they know anything. ";
   Quip (0, 1, Tom, "Man, you ARE getting desperate!", 2);
   Quip (1, 1, Crow, "[Rocket J. Squirrel voice] Again?", 2);
   print "You promise a lighter sentence for the ones who help. ";
   Quip (1, 1, Mike, "Do you have the authority to do that?", 2);
   print "But one guy really sets you straight. ~I got caught wit' t'ree ounces o' crack. ";
   Quip (0, 1, Crow, "Okay, so we've got crack and FDR. What decade is this supposed to be?", 2);
   print "I'm supposed to get 20 years but I'll be out in 2. ";
   Quip (0, 1, Tom, "[As the prisoner] Cuz I've started diggin' this tunnel so I can -- [As if covering his mouth to keep from saying any more] oop -- Damn!", 2);
   print "You can't make me talk cuz it don't matter to me. If I squeal, da guys ";
   Quip (1, 1, All, "DA Bears!", 2);
   print "who did it are gonna come lookin' for me. I know but I ain't gonna tell ya. Now git outta my face.~. You are surprised but used to it. You can go north to the outside, south to go back to the alley and west or east to talk to more guys.^";
   rtrue;
  ],
  e_to ROOM_Holding2,	! Holding cells 2
  n_to ROOM_Outside6,	! Outside 6
  s_to ROOM_Alley,	! Alley
  w_to ROOM_Holding1	! Holding cells 1
 has
  enterable
  light
  scored
;

! Holding cells 1
AGTRoom ROOM_Holding1 "Holding Cells"
 with
  description
  [;
   print "You are talking to more guys. But none of them tell you what you want. You can only go east.^";
   Quip (0, 1, Magic, "[Tom and Crow simply start snickering at this]", 1);
   rtrue;
  ],
  e_to ROOM_Police	! Police station
 has
  enterable
  light
;

! Holding cells 2
AGTRoom ROOM_Holding2 "Holding Cells"
 with
  description
  [;
   print "You are talking to more guys. But none tell you what you need to know. You can only go west.^";
   Quip (0, 1, Magic, "[Tom and Crow simply start snickering at this]", 1);
   rtrue;
  ],
  w_to ROOM_Police	! Police station
 has
  enterable
  light
;

! Outside 6
AGTRoom ROOM_Outside6 "Outside"
 with
  description
  [;
   print "You are outside. it's bitter cold and you pull your jacket around yourself. To the north is a nice, warm Holiday Inn hotel, where the killer is rumoured to be staying. ";
   Quip (0, 1, All, "WHAT?", 1);
   Quip (0, 0, Crow, "Where did we hear THAT?", 2);
   print "Or you could go to his favourite hang out, the Wall, to the west, or to the east is the place where he is supposed to be working, the Doughnut King.^";
   Quip (0, 1, Mike, "Wow! And we figured all that out just by entering this room!", 1);
   Quip (0, 0, Tom, "That was first-class detective work!", 1);
   rtrue;
  ],
  e_to ROOM_Doughnut,	! Doughnut King
  n_to ROOM_Holiday,	! Holiday Inn
  w_to ROOM_Wall	! The Wall
 has
  enterable
  light
  scored
;

! The Wall
AGTRoom ROOM_Wall "The Wall"
 with
  description
  [;
   Quip (0, 1, All, "[Sing] ~We don't need no ed-u-ca-tion!~", 2);
   print "You don't see him here. You ought to go east.^";
   Quip (0, 1, Mike, "Wow! We entered a building without getting killed!", 1);
   Quip (0, 0, Tom, "So how would we recognise the killer if we saw him? We don't even know who he is!", 1);
   rtrue;
  ],
  e_to ROOM_Outside6
 has
  enterable
  light
  scored
;

! Doughnut King
AGTRoom ROOM_Doughnut "Doughnut King"
 with
  description
  [;
   Quip (0, 1, Mike, "~Cops~ is filmed live on location at Doughnut King!", 2);
   print "You are in the Doughnut King, where the greasiest doughnuts on earth reside. He isn't here, no one seems to be for that matter, so you should go west.^";
   Quip (0, 1, Tom, "You mean no one's here, and they just left the doors wide open?", 1);
   Quip (0, 0, Crow, "Cool! Free coffee for everyone!", 1);
   Quip (0, 0, Mike, "[Coffee Guy voice] Coffee? I like coffee!", 1);
   rtrue;
  ],
  w_to ROOM_Outside6	! Outside 6
 has
  enterable
  light
  scored
;

! Holiday Inn
AGTRoom ROOM_Holiday "Holiday Inn"
 with
  description
  [;
   print "You are in the Holiday Inn registration room. You talk to some suspicious guys, but they don't talk until you hold your gun to their side. ~Alright! Alright! I'll talk! He's on the 15th floor! That's all I can tell ya!~ ";
   Quip (0, 1, Tom, "Geez, now you ARE acting like Mitchell!", 2);
   print "You shove them away. You walk up to the registration desk and show the woman there your badge. ";
   Quip (1, 1, Mike, "[As your character] See my badge? Got my picture on it and everything. Cool, huh?", 2);
   print "She gives you the master ring. ";
   Quip (0, 1, Crow, "[Ominous] One Ring to bring them all and in the darkness bind them!", 2);
   print "You now have access to all of the facilitys on the 15th floor. ";
   Quip (1, 1, Crow, "Good thing, too, because you don't think you can hold it much longer.", 1);
   Quip (1, 0, Tom, "Should've gone back at the mayor's house.", 2);
   print "But the problem is that the 15th floor is the suite level, and there are 30 suites, and 5 pools, 2 saunas and 5 game rooms. Big problem! Well, you have all night. You get a picture of all on the 15th floor, the people up there have to show their drivers license to be admitted, and the license is secretly xeroxed. ";
   Quip (0, 1, All, "WHAT?", 1);
   Quip (0, 0, Mike, "Uh... folks, we're completely lost here too.", 1);
   Quip (0, 0, Crow, "At this point the game has finally thrown up its hands and said, ~I just don't know.~", 2);
   "You look at them all. Well, better get started. You see one person who stands out. You get his room number from the lady. Room 30. Now you have to find it. To get started, go north.";
  ],
  n_to ROOM_Holiday15th	! Holiday Inn 15th floor
 has
  enterable
  light
  scored
;

! Holiday Inn 15th Floor
AGTRoom ROOM_Holiday15th "Holiday Inn 15th Floor"
 with
  description
  [;
   print "You go up the elevator. When you step out, you see the wallpaper is pink, with little flowers on it. ";
   Quip (0, 1, Mike, "You're a detective, so you're trained to notice stuff like that.", 2);
   Quip (1, 1, Mike, "Okay, guys, at this point we need to start piecing together the information we've gathered. So let's make a list of what we've learned.", 1);
   Quip (1, 0, Tom, "Well, we've learned that the mayor has been murdered.", 1);
   Quip (1, 0, Mike, "Right. Anything else?", 1);
   Quip (1, 0, Crow, "Ummm... no, I think Tom pretty much covered everything.", 1);
   Quip (1, 0, Mike, "Okay, let's get moving then.", 2);
   "You can go east or west.";
  ],
  e_to ROOM_Dead2,	! Dead end 2
  w_to ROOM_Hallway5	! Hallway 5
 has
  enterable
  light
  scored
;

! Dead end 2
AGTRoom ROOM_Dead2 "Dead End"
 with
  description
  [;
   print "You hit a dead end. There is a fire extinguisher here, but it is of no importance to you. ";
   Quip (0, 1, Crow, "Because we didn't want to spend time implementing it.", 1);
   Quip (0, 0, Mike, "I bet Matt Barringer spent a whole hour writing this game.", 1);
   Quip (0, 0, Tom, "And no time at all testing it.", 2);
   "You can only go west.";
  ],
  w_to ROOM_Holiday15th	! Holiday Inn 15th floor
 has
  enterable
  light
;

! Hallway 5
AGTRoom ROOM_Hallway5 "Hallway"
 with
  description
  [;
   Quip (0, 1, CrowTom, "No! No! Not MORE hallways! Aaaaagh!", 2);
   print "You are in the hallway. You see many doors... 1... 2... 3... 4... 5... 6... 7... ";
   Quip (0, 1, Mike, "[looking behind him] Huh? Are the theatre doors closing?", 2);
   print "boy, you have a long way to go. You can only go north.^";
   Quip (0, 1, Mike, "But you can go north for a long way.", 1);
   rtrue;
  ],
  n_to ROOM_Hallway6	! Hallway 6
 has
  enterable
  light
  scored
;

! Hallway 6
AGTRoom ROOM_Hallway6 "Hallway"
 with
  description
  [;
   print "You are still in the hallways. You can go west or east.^";
   Quip (0, 1, Crow, "Man, these hallways are the Interactive Fiction equivalent of ~rock-climbing.~", 1);
   Quip (0, 0, All, "DEEEEP HURRRRRTING! DEEEEEP HHUURRRRRRRTTIINNGG!", 1);
   rtrue;
  ],
  e_to ROOM_Dead3,	! Dead end 3
  w_to ROOM_Hallway7	! Hallway 7
 has
  enterable
  light
  scored
;

! Dead end 3
AGTRoom ROOM_Dead3 "Dead End"
 with
  description
  [;
   ! Literally.
   deadflag=self.number;	! Die here.
   print "You are at a dead end. There is nothing to do but go west.^";
   Quip (-1, 1, Tom, "WHAT! Why'd we just die here?", 1);
   Quip (-1, 0, Crow, "Oh, I get it! It's a ~dead~ end! See?", 1);
   Quip (-1, 0, Mike, "Matt Barringer made a funny!", 1);
   rtrue;
  ],
  number 1
 has
  enterable
  light
;

! Hallway 7
AGTRoom ROOM_Hallway7 "Hallway"
 with
  description
  [ Count;
   print "You are in the hallway. You see numbers flash by as you run through the halls. ";
   for (Count=19: Count<22: Count++)
   {
    print Count, "... ";
    Quip (-1, 0, Crow, "Hit me.", 1);
   }
   print "22... ";
   Quip (0, 0, Crow, "Damn, I'm busted.", 1);
   Quip (0, 0, Tom, "Can I hit him, Mike? Please?", 1);
   Quip (0, 0, Mike, "Sit tight, guys. It's almost over.", 2);
   "you are getting close! You can only go north.";
  ],
  n_to ROOM_Hallway8	! Hallway 8
 has
  enterable
  light
  scored
;

! Hallway 8
AGTRoom ROOM_Hallway8 "Hallway"
 with
  description
  [;
   print "You are in the hallway. You feel the heat from the sauna to the west, and to the east is a door marked ~Pool A~. To the north is more hall.^";
   Quip (0, 1, Tom, "Man, I'm starting to long for the good old days of Bert I. Gordon, Roger Corman, and Sandy Frank.", 1);
   rtrue;
  ],
  e_to ROOM_Pool,	! Pool
  n_to ROOM_30,		! Room #30
  w_to ROOM_Sauna	! Sauna
 has
  enterable
  light
  scored
;

! Sauna
AGTRoom ROOM_Sauna "Sauna"
 with
  description
  [;
   deadflag=self.number;
   print "You are in the sauna when from the steam steps the killer.^";
   Quip (-1, 1, Mike, "Man, that killer is EVERYWHERE!", 1);
   Quip (-1, 0, Crow, "Like God.", 1);
   Quip (-1, 0, Tom, "Only evil.", 1);
   Quip (-1, 0, Mike, "But he does have the same aura of mystery about him.", 2);
   print "You realise the guys downstairs must have tipped him off.^";
   Quip (-1, 1, Crow, "The first indication that the author has looked back at any of his previous writing.", 2);
   print "~So ya thought ya could get me eh?~ He flashes a gun. Well, let's not get into details.^";
   Quip (-1, 1, Tom, "Yeah, why start now, this close to the end?", 2);
   "You lose.";
  ],
  number 1	! Dead.
 has
  enterable
  light
;

! Pool
AGTRoom ROOM_Pool "Pool"
 with
  description
  [;
   print "You are in the pool when the killer shoots you from behind. You lose!^";
   Quip (-1, 1, Crow, "But we just wanted to check out the room!", 1);
   deadflag=self.number;
   rtrue;
  ],
  number 1	! Death.
 has
  enterable
  light
;

! Room #30
AGTRoom ROOM_30 "Room # 30"
 with
  description
  [;
   print "You enter room 30... after a harrowing gun battle you conk him on the head and take him in. ";
   if (self hasnt general)	! First time round, comment on inane ending.
   {
    score=score+100;	! For 'winning'.
    give self general;	! Once only.
   }
   Quip (0, 1, Tom, "What the...?", 1);
   Quip (0, 0, Crow, "That's IT?", 1);
   Quip (0, 0, Tom, "We sat through the whole game for THIS?", 2);
   Quip (1, 1, Mike, "Yep, this is the kind of ending that you want to read twice.", 2);
   print "You get promoted and suddenly, with the ~Jurrasic Park~ theme song playing in your head, you feel proud to be an American. ";
   Quip (0, 1, Tom, "So you go home and watch the Whitewater hearings and the O.J. Simpson trial until the feeling passes.", 1);
   Quip (0, 0, Crow, "And now we've got ~Jurassic Park~ and FDR!", 2);
   print "For special info about Exile Games, and to leave this darned game, go up.^";
   Quip (0, 1, Crow, "Uh, guys... ~darned~ isn't exactly the adjective I'd choose here.", 1);
   rtrue;
  ],
  u_to ROOM_Info	! Info
 has
  enterable
  light
;

! Info
AGTRoom ROOM_Info "Info"
 with
  description
  [;
   print "Exile Games is a group of people who like text games.^";
   Quip (-1, 1, Crow, "But just aren't very good at making them.", 2);
   print "We plan to get into graphic games sometime in 1995.^";
   Quip (-1, 1, Tom, "God help us all.", 2);
   print "We don't ask for money, we just want to know if you like it or not.^";
   Quip (-1, 1, Tom, "For the last time we don't!", 1);
   Quip (-1, 0, Mike, "If I remember right, they DID ask for money way back at the start.", 2);
   print "Our support BBS is (510) 208-5657, the Ghostbuster Central BBS.^";
   Quip (-1, 1, Mike, "Who ya gonna call?", 1);
   Quip (-1, 0, All, "GHOSTBUSTERS!", 2);
   print "We have accounts on Compuserve and Prodigy. Exile Games is curently made up of:^^Matt Barringer, president and head programmer^";
   Quip (-1, 1, All, "All hail, Matt Barringer!", 2);
   print "Nathaniel Smith, advisor^";
   Quip (-1, 1, Tom, "[As Nathaniel Smith] Hey, guys, let's make a really crappy text adventure with no puzzles in it!", 2);
   print "Kurt Somogue, assistent programmer^";
   Quip (-1, 1, Crow, "If you ever meet any of these people, please do us all a favour and put them out of their misery.", 2);
   print "And all the users of the Ghostbuster Central BBS, who give me ideas!^";
   Quip (-1, 1, Mike, "Uh... Matt, buddy, I think it's time you got yourself some new idea people.", 2);
   print "*** Congratulations. You have won the game. ***", (NewLine)1;
   Quip (-1, 1, Mike, "And the crowd goes wild!", 1);
   Quip (-1, 0, All, "[Subdued] Yaaaaay.", 1);
   Quip (-1, 0, Crow, "So, do you think this game was hard-boiled, like Dr. Forrester said?", 1);
   Quip (-1, 0, Tom, "No, I personally thought it was over-easy!", 1);
   Quip (-1, 0, Mike, "D'OH!", 1);
   Quip (-1, 0, Crow, "Lemme at him, Mike! Lemme at him! [Crow tries to attack Tom, but Mike stops him]", 1);
   Quip (-1, 0, Tom, "So did either of you guys see anything here remotely connected to detectives?", 1);
   Quip (-1, 0, Mike, "Nope, can't say I did.", 1);
   Quip (-1, 0, Crow, "You know, the AGT parser was ideal for making this game.", 1);
   Quip (-1, 0, Mike, "I wonder if Matt Barringer ever considered making the killer more realistic. Like, I dunno, maybe giving him a name, or something.", 1);
   Quip (-1, 0, Crow, "I think there are some questions better left unasked.", 1);
   Quip (-1, 0, Mike, "That's a good point, Crow.", 1);
   Quip (-1, 0, Tom, "[Sidles over into Mike's lap] Well, c'mon, guys, we gotta go.", 1);
   Quip (-1, 0, Mike, "I still liked this game WAY better than ~Leather Goddesses of Phobos 2.~", 1);
   Quip (-1, 0, Tom, "Oh, yeah, definitely.", 1);
   Quip (-1, 0, Crow, "Shut up, Servo. That's not funny!", 1);
   Quip (-1, 0, Tom, "Geez, what's your problem?", 1);
   PressAKey (1);
   End ();
   rtrue;
  ],
  number 0
 has
  enterable
  light
;