// Charon	

class chroom: room
	oncharon = true
	doUnwear( actor ) =
    {
        "Okay, you're no longer wearing "; self.thedesc; ". ";
        self.isworn := nil;
	if (self = suit or self = icesuit)
	if (Me.location.oncharon)
		{
		"You have always wondered if it was true that a person explodes when
			suddenly exposed to a vacuum.  When you remove the suit, you
			find the answer to your question confirmed.";
		die();
		} 
	}
;

charon: chroom
	sdesc = "On Charon"
	ldesc = 
		{"You are standing by the cylinder on a small hill on Charon.  Pluto, Charon's 
			twin planet, hovers high in the sky above.  Across the surface 
			of Charon's sister world you see many large domed cities, 
			most of which are completely dark.\n\t
			To the west from here there ";
			if(icechip.location = pillarpanel) 
					"are two ";
			else
					"is a ";
			"tall glowing pillars which cast a dim blue aura 
			over the surrounding environs.  
			To the north are the remains of what must have been another domed city.
			The entire top of the gargantuan dome looks like it exploded from the 
			inside.\n\t
			The only path leads down the hill to the northwest.";
		}
	nw = {ccity.moveInto(fork);
				copillars.moveInto(fork);
				return(fork);
				}
	down = {ccity.moveInto(fork);
				copillars.moveInto(fork);
				return(fork);
				}
	in = shipin
;

chcylin: decoration
	sdesc = "large glowing cylinder"
	isopen = true
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'large' 'glowing'
	location = charon
	ldesc = "The cylinder is about 30 feet in height and width.
		It is very shiny and glows slightly.  There is a passage 
		leading into its interior."
	verDoGo(actor) = {}
	doGo(actor) = {Me.travelTo(shipin);}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(shipin);}
;

ccity: decoration
	sdesc = "domed city"
	ldesc = "The destroyed dome looks like it exploded from within.  You have to get closer to see more detail."
	noun = 'city' 'dome'
	adjective  = 'huge' 'gargantuan' 'domed'
	location = charon
;

copillars: decoration
	sdesc = "pillars"
	ldesc = {
			"The two tall, black pillars lie to the west of here.  ";
				if (icechip.location = pillarpanel)
					"Both of the pillars are glowing with a pale blue light which lights the entire area.";
				else
					"The left pillar is glowing with a pale blue light which lights the entire area.";
			}
	noun = 'pillars'
	adjective = 'tall' 'black' 'glowing'
	location = charon
;

fork: chroom
	sdesc = "Fork"
	ldesc = {
			"You have reached a fork in the path.  The path continues to the west, towards the pillars, to
			the north, towards the destroyed city, and southeast, towards the cylinder.";
			
			}
	north = dome
	west = {ccity.moveInto(path);
				copillars.moveInto(path);
				return(path);
				}
	se = {ccity.moveInto(charon);
				copillars.moveInto(charon);
				return(charon);
				}
;

dome: chroom
	hno = true
	sdesc = "Destroyed City"
	ldesc = "North of here is the broken remains of a large domed city.  Halfway up the dome, a large 
		section has been destroyed, exposing the city inside to the 
		vacuum of space.  The airlock in front of you has been melted into a solid hunk 
		of metal.  The only paths are back to the south or to the southwest."
	south = fork
	north = {  "The airlock has been melted shut.  There is no way into the city. ";
					return (nil);
				}
	up = { "The dome is too smooth to climb";
					return(nil);
			}
	sw = path
;

chlock: decoration, openable
	isopen = nil
	hno = true
	sdesc = "melted airlock"
	ldesc = "The airlock has been melted shut.  There is no way to open it."
	noun = 'airlock' 'door'
	adjective = 'melted'
	location = city
	verDoOpen(actor) = {}
	doOpen(actor) = {"The airlock is melted shut.  There is no way to open it.\b";}
	verDoClose(actor) = {}
	doClose(actor) = {"The airlock is already melted shut!\b";}
;

city: decoration
	sdesc = "ruined city"
	ldesc = "The large dome of the city has been broken open halfway up.  The city 
		inside (at least what you can see of it) is in a complete shambles."
	noun = 'city' 'dome'
	adjective = 'ruined' 'domed' 'large' 'gargantuan'
	location = dome
	verDoGo(actor) ={}
	doGo(actor) = { "The airlock has been melted shut.  There is no way into the city.\b";}
	verDoClimb(actor) = {}
	doClimb(actor) = {"The dome is too smooth to climb.\b";}
;

path: chroom
	sdesc = "On the Path"
	ldesc = "The path turns here from the east to the southwest towards the pillars.  The shattered 
			dome is to the northeast of here."
	east = {ccity.moveInto(fork);
				copillars.moveInto(fork);
				return(fork);
				}
	sw = {ccity.moveInto(bpillars);
				return(bpillars);
				}
	ne = dome
;

bpillars: chroom
	sdesc = "By the Pillars"
	ldesc = {
				"You are standing on a path which terminates to the west just through a pair of tall black pillars. ";
				{
				if (icechip.location = pillarpanel)
					"Both of the pillars are glowing faintly with a dim blue light. ";
				else 
					"The left pillar is glowing faintly with a dim blue light. ";
				}
				"You can see the broken dome of the city a distance to the northeast of here.\n
				The path continues to the west, between the pillars, or northeast across the surface of Charon.";
				}
	pdone = nil
	ne = {ccity.moveInto(path);
				return(path);
				}
	west = {
			if (icechip.location = pillarpanel)
			{
			"When you pass directly between the pillars they both flash brightly
			and you find yourself someplace else.\b";
			if ( not bpillars.pdone)
				{
				bpillars.pdone := true;
				}
				return(cavern);
			}
			else
			{
			"With confidence you walk between the two pillars.  As you pass through, the left pillar increases 
			it's brightness slightly but nothing else of interest happens.  Disappointed, you return to the path.";
			return (nil);
			}
		}
;

surfpil: decoration
	hno = true
	sdesc = "pillars"
	ldesc = {"Both of the pillars are fifteen feet high, black and perfectly smooth. ";
				if (icechip.location = pillarpanel)
					"Each pillar glows with a faint blue light. ";
				else
					"The left pillar is glowing with a faint blue light. ";
				}
	noun = 'pillars'
	location = bpillars
;

culight: decoration
	sdesc = "faint blue light"
	ldesc = "There is nothing special about <<self.thedesc>>"
	noun = 'light'
	adjective = 'blue' 'faint' 'dim'
	location = surfpil
;

lftpillar: fixeditem
	hno = true
	sdesc = "left pillar"
	ldesc = "The pillar is fifteen feet high, black and perfectly smooth.  It stands ten feet 
		away from its counterpart and glows slightly with a dim blue light."
	noun = 'pillar'
	adjective = 'left'
	location = bpillars
;

rtpillar: fixeditem
	hno = true
	oncharon = true
	sdesc = "right pillar"
	ldesc = {"The pillar is fifteen feet high, black and perfectly smooth.  It stands ten feet 
			away from its counterpart";
			if (icechip.location = pillarpanel)
				"and glows slightly with a dim blue light.  ";
			else ".  ";
				"There is a small open panel on one side of the pillar.";
		}
	noun = 'pillar'
	adjective = 'right'
	location = bpillars
;

pillarpanel: fixeditem, qcontainer
	hno = true
	oncharon = true
	sdesc = "black panel"
	ldesc = {
			if (icechip.location = self)
				"The one inch square panel is housing some sort of microchip.";
			else
				"The one inch square panel is empty.";
			}
	noun = 'panel'
	adjective = 'black' 'small' 'square'
	location = rtpillar
	ioPutIn (actor, dobj) = {
					if (dobj <> icechip)
					{
					"\^<<dobj.thedesc>> doesn't fit in the panel. ";
					dobj.moveInto(Me);
					}
					else
					{
					"The ice chip slips snugly into panel.  As the ice chip snaps into place the right pillar lights 
						up with a blue halo.";
					icechip.moveInto(self);
					}
				}
;


chipmelt: function (parm)
	{
		{
			{
			if (icechip.location = dewar) 
				{icechip.melt := nil;
				 icechip.chipcount := 0;
				exit;}
			if((icechip.location).oncharon)
				{icechip.melt := nil;
				icechip.chipcount := 0;
				exit;}
			if((icechip.location = Me) and (Me.location).oncharon) 
				{icechip.melt := nil;
				icechip.chipcount := 0;
				exit;}
			if (icechip.location = void or icechip.location = tvoid or icechip.location = dvoid)
				{icechip.melt := nil;
				exit;
				}
			}
			icechip.melt := true;
		}
		if (icechip.melt)
			{
				if (icechip.chipcount = 1)
					"\nAs it starts to evaporate, the ice chip gives off a cool mist.\b";
				if (icechip.chipcount = 3)
					"\nThe ice chip's rate of evaporation is increasing dramatically.  It doesn't look like 
					it will last much longer.";
				if (icechip.chipcount = 5)
					{
					"\nThe ice chip completely evaporates into a thin, cool mist which quickly dissipates.";
					icechip.moveInto(dvoid);
					incscore(-20);				// -20 for loosing chip
					remdaemon (chipmelt, nil);
					exit;
					}
				icechip.chipcount := icechip.chipcount + 1;
			}
	}
;


cavern: chroom
	oncharon = nil
	sdesc = "Underground"
	ldesc = {"You are in what must be some kind of mine.  The walls glow with some 
			type of cool phosphorescence.  A large sign on the south wall announces in 
			cheerful letters\b";
			{
			if (srubble.location = scoll)
				"PRESSURE: STABLE\nTEMPERATURE: STABLE\b";
			else
				"PRESSURE: ALERT\nTEMPERATURE: ALERT\b";
			}
			"Two pillars, which start at the floor and continue into the ceiling, lie 
			embedded in the northern wall.  Both of the pillars are glowing slightly 
			with a pale blue light.  The only exit is down a tunnel to the southeast.";
				}
	se = tunnel
	north = {
			"The pillars flash brightly as you walk between them and you find 
			yourself back on the surface of Charon.\b";
			if (suit.isworn or icesuit.isworn)
				return(bpillars);
			else
				{
				"\bUnfortunately you are ill suited to survive in a vacuum and 	
			freeze solid just as your body explodes.";
				die();
				}
			}
;

cpillars: decoration
	hno = true
	sdesc = "pillars"
	ldesc = "Both pillars travel from the floor into the ceiling and are partially imbedded 
		in the wall.  They are glowing with a pale blue light."
	noun = 'pillars'
	location = cavern
;

ulight: decoration
	sdesc = "dim blue light"
	ldesc = "There is nothing special about <<self.thedesc>>"
	noun = 'light'
	adjective = 'blue' 'dim' 'faint'
	location = cpillars
;

tunnel: chroom
	oncharon = nil
	sdesc = "Tunnel"
	ldesc = "You are in a nondescript tunnel in some sort of mine.  
			Additional tunnels branch off to the east, south and northwest."
	nw = cavern
	east = tfork
	south = {
			if (srubble.location = scoll) return (scoll);
			else return (scoll2);
				}
;

scoll: chroom
	oncharon = nil
	sdesc =  "Collapsed Tunnel"
	ldesc = "The tunnel to the south has collapsed and is choked full of rubble.  The only 
		way out of here is back to the north."
	north = tunnel
	south = {
			"Even with heavy machinery you couldn't get though there.";
			return (nil);
			}
;

scoll2: chroom
	sdesc = "Tunnel"
	ldesc = "You are in a tunnel under the surface of Charon.  To the south is a 
		nearly vertical shaft leading up to the planet's surface. The tunnel continues to the north."
	north = tunnel
	south = {
			"The shaft is much to steep to climb.";
			return(nil);
			}
	up = {"The shaft is much to steep to climb.";
				return(nil);
				}
;

scolshaft: decoration
	sdesc = "shaft"
	ldesc = "The shaft is fairly wide and nearly vertical.  It looks like it travels hundreds 
		of feet up to the surface."
	noun = 'shaft'
	adjective = 'vertical' 'steep' 'wide'
	location = scoll2
	verDoClimb(actor) ={}
	verDoClimbup(actor) = {}
	doClimb(actor) = {
				"The shaft is much to steep to climb";
					if (gravboots.isworn)
					", even with the hover boots.";
					else
					".";
					return(nil);
				}
	doClimbup(actor) = {self.doClimb;}
;


srubble: fixeditem
	sdesc = "rubble"
	ldesc = "The rubble is mostly large rocks and dirt.  One of the rocks looks to be loose."
	noun = 'rubble'
	location = scoll
;

srubup:function;

srubup:function
	{
				if (srubblerock.location = srubble)
				{
				"With some effort you pull the rock free. Where the rock was there is now gap in the wall exposing the pressurized 
				atmosphere of the tunnel to the outside vacuum of space.  
				Red lights immediately start flashing and alarms start ringing throughout the mines as the 
				scream of air flooding out through 
				the hole fills the mines.  The wall of rubble explodes outwards from the sudden pressure change 
				exposing a nearly vertical passage to the surface.  The explosion sweeps you up 
				the shaft as well.  Before you can blink you find yourself back out on the surface.
				\b\b\b\b\b\b\b\b\b\b\b\b\b\b";
				if (not suit.isworn)
				if (not icesuit.isworn)
					{
					"This, of course, immediately exposes you to the vacuum of space and since you are ill 
					prepared to survive in such an environment you die.";
					die();
					}
				cavern.oncharon := true;
				tunnel.oncharon := true;
				scoll.oncharon := true;
				tfork.oncharon := true;
				ncoll.oncharon := true;
				machineroom.oncharon := true;
				// srubblerock.moveInto(Me);
				srubble.moveInto(void);
				Me.travelTo(coutside);
				incscore(5);		// 5 for being sucked up to the surface
				exit;
				}
				else pass doTake;
				}
;

srubblerock: item
	sdesc = "non-descript rock"
	ldesc = {if (self.location = srubble) {"There is nothing special about the <<self.sdesc>> other than it seems to be loose.";}
					else
						"There is nothing remarkable about <<self.thedesc>>.";
				}
	noun = 'rock'
	adjective = 'loose' 'non-descript'
	location = srubble
	verDoTake(actor) = {}
	verDoMove(actor) = {}
	doTake(actor) = {
				srubup();
				}
	doMove(actor) = {
				srubup();
				}
;

tfork: chroom
	oncharon = nil
	sdesc = "Fork in the Tunnel"
	ldesc = "The tunnel forks here to the northeast, southeast and west."
	west = tunnel
	ne = ncoll
	se = machineroom
;

ncoll: chroom
	oncharon = nil
	sdesc = "Collapsed Tunnel"
	ldesc = "The tunnel ends here at a cave-in to the east.  The only way out of here is back to
					the southwest."
	sw = tfork
	east = {
			"Even with heavy machinery you couldn't get though there.";
			return (nil);
			}
;

nrubble: decoration
	hno = true
	sdesc = "rubble"
	ldesc = "The rubble is mostly made up of very large boulders and completely fills the eastern tunnel."
	noun = 'rubble'
	location = ncoll
;

machineroom: chroom
	oncharon = nil
	sdesc = "Machine Room"
	ldesc = "The tunnel dead ends here.  The only way out is back to the northwest.  
			Against the far wall there is some sort of large ugly machine."
	nw = tfork
;

machine: vowelItem, fixeditem
	hno = true
	sdesc = "ugly machine"
	ldesc = "The machine is about the size of a washer machine and has numerous dents on it.  
			Engraved on its side is the faded word \"PURIFIER.\" 
		On the top of the machine there is what looks to be a hopper with the word \"IN\" engraved on it. "
	noun = 'machine' 'purifier'
	adjective = 'ugly' 'large'
	location = machineroom
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = {hopper.ioPutIn(actor, dobj);}
;

mdents:decoration
	sdesc = "dents"
	ldesc = "There is nothing special about the dents."
	noun = 'dent'
	plural = 'dents'
	location = machine
;

hopper: fixeditem, container
	hno = true
	sdesc = "hopper"
	ldesc = "It is marked \"IN\"."
	noun = 'hopper'
	location = machineroom
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = 
		{
			if (dobj = roughiron)
				{
				"The rock falls into the hopper with a thunk.  The machine begins to shake and tremble violently 
			as a battery of lights illuminate across its surface.  A small panel at the base of the machine opens and a piece 
			of one hundred percent pure iron plops out onto the floor. The panel quickly closes and the machine 
			shuts down. ";
				roughiron.moveInto(void);
				pureiron.moveInto(machineroom);
				}
		else				

			{
				"\^<<dobj.thedesc>> falls into the hopper with a thunk.  The machine 
			begins to shake and tremble violently as a battery of lights illuminate across its surface.  
			A small panel at the base of the machine opens and <<dobj.thedesc>> plops out onto the floor, looking 
			much purer.  
			The panel quickly closes and the machine shuts down. ";
				dobj.moveInto(machineroom);
				}
				
		}
;


coutside: chroom
	sdesc = "Back on the Surface of Charon"
	ldesc = {
			"You are standing on one of the frozen plains of Charon.  You can see a 
			group of small buildings under a clear dome to the west.  To the north there is open shaft in the ground.";
			}
	west = bcamp
	north = {
			if (gravboots.isworn)
				{
				"Closing your eyes you step over the open shaft and slowly float down into the mines below.\b";
				return (scoll2);
				}
			else
				{
				"Recklessly, you step into the shaft and fall hundreds of yards to your death.";
				die();
				}
			}
	down = {
			if (gravboots.isworn)
				{
				"Closing your eyes you step over the open shaft and slowly float down into the mines below.\b";
				return (scoll2);
				}
			else
				{
				"Recklessly, you step into the shaft and fall hundreds of yards to your death.";
				die();
				}
			}
;

outshaft: decoration
	sdesc = "shaft"
	ldesc = "The shaft is very steep, very dark and very deep.  Even if you could get down, it looks like a one-way trip."
	noun = 'shaft'
	adjective = 'vertical' 'steep' 'dark' 'deep'
	location = coutside
	verDoClimbdown(actor) = {}
	verDoClimb(actor) = {}
	doClimb(actor) = {
					if (gravboots.isworn)
					{
					"Closing your eyes you step over the open shaft and slowly float down into the mines below.";
					return (scoll2);
					}
					else
					{
					"Recklessly, you step into the shaft and fall hundreds of yards to your death.";
					die();
					}
				}
	doClimbdown(actor) = {self.doClimb;}
;

fardome: decoration
	sdesc = "clear dome"
	ldesc = "You can just make out some buildings through the dome.  Maybe, if you got closer, you could see more."
	noun = 'dome'
	adjective = 'clear'
	location = coutside
;

farcbuild: decoration
	sdesc = "small buildings"
	ldesc = "You can't make out much detail.  Maybe, if you got closer, you could see more."
	noun = 'buildings' 'camp'
	adjective = 'small'
	location = coutside
;
	

bcamp: chroom
	sdesc = "By Airlock"
	ldesc = "You are next to a clear dome on the surface of Charon.  Through the dome you can see a group 
		of buildings.  To the west lies an open airlock leading into the dome.  To the east is the open 
		surface of the planet."
	east = coutside
	west = {if (not coutdoor.isopen) {"The airlock door is closed."; return(nil);}else return (coutdoor);}
;


campbuild: decoration
	sdesc = "small buildings"
	ldesc = "Through the dome you can see there are four buildings huddled around a central area."
	noun = 'buildings' 'camp'
	adjective = 'small'
	location = bcamp
;

minairlock: vowelItem, decoration, readable
	hno = true
	sdesc = "airlock"
	ldesc = "The airlock is about three feet square.  Inside the airlock, the door into the dome is closed.  
				There is some writing scrawled above the door."
	readdesc = "BORSTIA MINES OUTPOST #55312"
	noun = 'airlock'
	location = bcamp
;

coutdoor: vowelItem, doorway
	hno = true
	sdesc = "outer door"
	ldesc = "The door is basically a wall of sliding metal.  There doesn't seem to be any way to close the door 
			from here."
	noun = 'door'
	adjective = 'outer' 'exterior'
	location = minairlock
	isopen = true
	otherside = couter
	doordest = cairlock
	doClose(actor) ={
				"There is no way to close the <<self.sdesc>> from here.";
				}
;

airwrit: decoration, readable
	sdesc = "writing"
	ldesc = "BORSTIA MINES OUTPOST #55312"
	noun = 'writing'
	location = minairlock
;

mindome: decoration
	hno = true
	sdesc = "dome"
	ldesc = "The dome is about fifty feet high, but very steep.  Through its surface you can see what looks 
			like an abandoned camp. "
	noun = 'dome' 'camp'
	location = bcamp
;

cairlock: chroom
	sdesc = "Airlock"
	ldesc = {
				"You are in an bare airlock.  The ";
					{
					if (couter.isopen) "open ";
					else "closed ";
					}
				"outer door is to your east and the ";
					{
					if (cinner.isopen) "open ";
					else "closed ";
					}
				"inner door is to the west.";
				}
	east = {if(not couter.isopen) {"The outer door is closed."; return(nil); }else return(couter);}
	west = {if(not cinner.isopen) {"The inner door is closed."; return(nil);}else return(cinner);}
;

couter: vowelItem, doorway
	hno = true
	sdesc = "outer door"
	ldesc = {
			"The outer door is basically a sliding metal wall.  There are some indentations on the door that look
			like they could be used as handholds.  The outer door is currently ";
			if (couter.isopen)
				"open.";
			if (not couter.isopen)
				"closed.";
			}
	noun = 'door'
	adjective = 'outer'
	location = cairlock
	otherside = coutdoor 
	doordest = bcamp
	isopen = true
	doOpen(actor) = {
				if (self.isopen)
					"\^<<self.thedesc>> is already open!";
				else
					{
					if (cinner.isopen)
					"The <<self.sdesc>> won't open.  It seems to be stuck.";
					else
					{
					"The door opens with a hiss revealing the surface of Charon.";
					self.isopen := true;
					cairlock.oncharon := true;
					if (not suit.isworn) 
					if (not icesuit.isworn)
						{
						"Unfortunately you are ill equipped to survive is a vacuum and quickly asphyxiate.";
						die();
						}
					}
					}
				}
	doClose(actor) = {
					if (self.isclosed)
						"\^<<self.thedesc>> is already closed!";
					else
						{
						"The outer door closes and the airlock quickly pressurizes with an atmosphere.";
						self.isopen := nil;
						cairlock.oncharon := nil;
						}
					}
;

cinner: vowelItem, doorway
	hno = true
	sdesc = "inner door"
	ldesc = {
			"The inner door is basically a sliding metal wall.  There are some 
			indentations on the door that look like they could be used as handholds.  The inner door is currently ";
			if (cinner.isopen)
			"open.";
			if (not cinner.isopen)
			"closed.";
			}
	noun = 'door'
	adjective = 'inner'
	location = cairlock
	otherside = cinner2
	doordest = camp
	isopen = nil
	doOpen(actor) = {
				if (self.isopen)
					"\^<<self.thedesc>> is already open!";
				else
					{
					if (couter.isopen)
						"The <<self.sdesc>> won't open.  It seems to be stuck.";
					else
					{
					"The door opens with a hiss revealing a group of buildings.";
					self.isopen := true;
					cinner2.isopen := true;
					}
					}
				}
	doClose(actor) = {
				if (self.isclosed)
					"\^<<self.thedesc>> is already closed!";
				else
					{
					"The inner door closes with a thud.";
					self.isopen := nil;
					cinner2.isopen := nil;
					}
				}
;


camp: room
	sdesc = "Center of Camp"
	ldesc = "This must have been the camp for the miners.  The inner door of the airlock is to the east.  
			A single large building can be entered to the north, northeast or northwest.  
		Individual smaller buildings can be entered from to south, southwest and west."
	east = {if (not cinner2.isopen) {"The airlock door is closed."; return(nil);} else return(cinner2);}
	north = bar2
	ne = bar3
	south = chmess
	sw = chwerehouse
	west = choffice
	nw = bar1
;

cinner2: vowelItem, doorway
	hno = true
	sdesc = "inner door"
	ldesc ={
			"The inner door is basically a sliding metal wall.  There are some indentations on the door that look
			like they could be used as handholds.  The door is currently ";
		if (cinner2.isopen)
			"open.";
		if (not cinner2.isopen)
			"closed.";
		}
	noun = 'door'
	adjective = 'inner'
	location = camp
	otherside = cinner
	doordest = cairlock
	doOpen(actor) = {
				if (self.isopen)
					"\^<<self.thedesc>> is already open!";
				else
					{
					if (couter.isopen)
						"The <<self.sdesc>> won't open.  It seems to be stuck.";
					else
					{
					"The door opens with a hiss revealing a bare airlock.";
					self.isopen := true;
					cinner.isopen := true;
					}
					}
				}
	doClose(actor) = {
				if (self.isclosed)
					"\^<<self.thedesc>> is already closed!";
				else
					{
					"The inner door closes with a thud.";
					self.isopen := nil;
					cinner.isopen := nil;
					}
				}
;

cbuildings: decoration
	sdesc = "buildings"
	ldesc = "There are five buildings here.  To the north there is a large long building which can be entered 
		from any of the northern directions.  The buildings to the west, southwest and south have the
		words  'Main Office', 'Storage', 'Mess' written on them respectively."
	noun = 'buildings' 'camp'
	location = camp
;

bar1: room
	sdesc = "Barracks"
	ldesc = "This long building must have been the barracks for the miners.  Someone (or something) must 
		have cleaned out this place, for the building is totally empty.\n\tThe barracks continue 
			to the east.  There is also an exit to the south."
	south = camp
	east = bar2
;

bar2: room
	sdesc = "Barracks"
	ldesc = "This long building must have been the barracks for the miners.  Someone 
		(or something) must have cleaned out this place, for the building is totally empty.\n\tThe 
		barracks continue far to the east and west. There is also an exit to the south."
	south = camp
	east = bar3
	west = bar1
;

bar3: room
	sdesc = "Barracks"
	ldesc = "This long building must have been the barracks for the miners.  Someone 
		(or something) must have cleaned out this place, for the building is totally empty.\n\t
		The barracks continue far to the west.  There is also an exit to the south."
	south = camp
	west = bar2
;

gravboots: clothingItem, vulnerable, readable
	sdesc = "pair of heavy boots"
	ldesc = "The pair of boots are made out of some type of thick metal.  There is some red writing on one of the 
			heels."
	readdesc = "\"LOW GRAVITY HOVER BOOTS\""
	noun = 'boots' 'gravboots'
	adjective = 'pair' 'hover' 'gravity' 'low' 'heavy' 'hover'
	preposition = 'of'
	location = bar3
;

choffice: room
	sdesc = "Office"
	ldesc = "Someone (or something) has emptied this building.  The only exit is back out to the east."
	east = camp
;

choffnote: vulnerable, readable
	sdesc = "booklet"
	ldesc = "The booklet is an annual report for the Borstia Mining Corporation.  You flip through the 
			pages skimming the material inside.  It is very dry stuff filled with stuff about gross production and 
			net output of something called raw chronocrystal ore."
	noun = 'booklet' 'report'
	adjective = 'annual'
	location = choffice
;

chwerehouse: room
	sdesc = "Warehouse"
	ldesc = "The floor of this long building is covered in a heavy layer of dust.  It looks like nobody has 
			been in here for ages. The only exit is to the north."
	north = camp
	down = {
			if(trapdoor.location = chwerehouse) 
				return(trapdoor);
			else
				{
			"You cannot go in that direction."; return(nil);
			}
		}
;

clearVerb:deepverb
	sdesc = "clear"
	verb = 'clear'
	doAction = 'Clear'
;

dust: fixeditem
	sdesc = "layer of dust"
	ldesc = "The dust is at least a inch deep and covers the entire floor."
	noun = 'dust'
	adjective = 'layer'
	preposition = 'of'
	location = chwerehouse
	verDoSearch(actor) = {}
	doSearch(actor) = {
				if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			}
	verDoClean(actor) = {}
	doClean(actor) = {
				if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			}
	verDoClear(actor) ={}
	doClear(actor) = {
				if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			}
;

trapdoor: doorway
	hno = true
	sdesc = "trapdoor"
	ldesc = "It looks like an ordinary trap door.  The trap door is currently 
		<<trapdoor.isopen ? "open.": "closed.">>"
	noun = 'door' 'trapdoor'
	adjective = 'trap'
	isopen = nil
	otherside = strapdoor
	doordest = schroom
	doOpen(actor)  = {
			if(self.isopen) "The trap door is already open!";
			else{
			"The door opens revealing a small passage down.";
			self.isopen := true;
			strapdoor.isopen := true;}
			}
	doClose(actor) = {
			if (self.isopen)
				{
				"You close the trap door.";
				self.isopen := nil;
				strapdoor.isopen := nil;
				}
			else "The trapdoor is already closed!";
			}
;

strapdoor: doorway
	hno = true
	sdesc = "trapdoor"
	ldesc = "It  looks like an ordinary trap door.  The trap door is currently 
		<<strapdoor.isopen ? "open.": "closed.">>"
	noun = 'door' 'trapdoor'
	adjective = 'trap'
	isopen = true
	location = schroom
	otherside = trapdoor
	doordest = chwerehouse
	doOpen(actor) = {
			if(self.isopen) "The trap door is already open!";
			else{
			"The door opens revealing a small passage down.";
			self.isopen := true;
			trapdoor.isopen := true;}
			}
	doClose(actor) = {
			if (self.isopen)
			{
			"You close the trap door.";
			self.isopen := nil;
			trapdoor.isopen := nil;
			}
			else "The trapdoor is already closed!";
			}
;

schroom: darkroom
	sdesc = "Secret Room"
	ldesc = {"You are in a secret room below the warehouse.  The overpowering musty smell of time fills the air.";
		if(strapdoor.isopen)
		"  The only exit is back up into the warehouse.";
		}
	up = strapdoor
;


cookie: fooditem
	sdesc = "cookie"
	ldesc = "It is your typical chocolate wafer with cream filling type of cookie."
	noun = 'cookie'
	adjective = 'chocolate' 'wafer'
	location = schroom
;


chmess: room
	sdesc = "Mess Hall"
	ldesc = "From the sign outside you gather that this bare room must have been the 
		miner's mess. If there was anything in this place it was removed a long time ago.  The only exit is back out to the north."
	north = camp
;
