// Perdition's Flames - haunted house section
// Copyright (c) 1993, 2002 Michael J. Roberts.

// a ghostItem is one that cannot be affected by the player
ghostItem: fixeditem
   dobjGen(a, v, i, p) =
   {
       if (v <> inspectVerb)
       {
           "Your hand passes through <<self.thedesc>>, nudging it
           just slightly.";
           exit;
       }
   }
   iobjGen(a, v, d, p) =
   {
       "Your hand passes through <<self.thedesc>>, nudging it
       just slightly.";
       exit;
   }
;

// travel through a wall - just mentions going through the wall
wallTravel: function(dest)
{
    "You approach the wall, and go right through it, emerging
    on the other side...\b";
    return(dest);
}

// travel through the floor
floorTravel: function(dest, goingUp)
{
    "You travel directly through the <<goingUp ? "ceiling" : "floor">>,
    and emerge on the other side...\b";
    return(dest);
}


basementBulb: ghostItem
    sdesc = "light bulb"
    noun = 'bulb'
    adjective = 'bare' 'light'
    location = basement
;

basementWalls: ghostItem
    sdesc = "cinderblock wall"
    noun = 'wall'
    adjective = 'cinderblock'
    location = basement
;

// move into a coordinate-based room
enterCoord: function(dest, y, x, thruwall)
{
    if (thruwall)
        "You approach the wall, and pass directly through, barely
        feeling the solid matter...\b";
    dest.xcoord := x;
    dest.ycoord := y;
    return(dest);
}

class ghostRoom: room
    roomAction(a, v, d, p, i) =
    {
        if (v = wailVerb or v = yellVerb or v = sayVerb)
        {
            "All you can manage is a sort of low moaning sound.";
            exit;
        }
        else
            pass roomAction;
    }
    ycoord1 = (self.ycoord)
    ycoord2 = (self.ycoord)
    xcoord1 = (self.xcoord)
    xcoord2 = (self.xcoord)
    coordWalled = true         // most rooms have walls...
    north = (enterCoord(self.coordDest, self.ycoord1+1, self.xcoord,
                        self.coordWalled))
    south = (enterCoord(self.coordDest, self.ycoord2-1, self.xcoord,
                        self.coordWalled))
    east = (enterCoord(self.coordDest, self.ycoord, self.xcoord1+1,
                        self.coordWalled))
    west = (enterCoord(self.coordDest, self.ycoord, self.xcoord2-1,
                        self.coordWalled))
    ne = (enterCoord(self.coordDest, self.ycoord1+1, self.xcoord1+1,
                        self.coordWalled))
    se = (enterCoord(self.coordDest, self.ycoord2-1, self.xcoord1+1,
                        self.coordWalled))
    nw = (enterCoord(self.coordDest, self.ycoord1+1, self.xcoord2-1,
                        self.coordWalled))
    sw = (enterCoord(self.coordDest, self.ycoord2-1, self.xcoord2-1,
                        self.coordWalled))
    up = (floorTravel(self.upDest, true))
    down = (floorTravel(self.downDest, nil))
    nrmLkAround(verbosity) =
    {
        inherited.nrmLkAround(verbosity);
        if (ghostRing.location = self and not ghostRing.isListed)
            "\n\t<< self.ringDesc >>";
    }
;

ghostEquipment: ghostItem
    sdesc = "scientific equipment"
    noun = 'equipment' 'microphone' 'microphones' 'counter' 'counters'
    adjective = 'geiger' 'radiation' 'scientific'
    location = hauntedPeople
;

ghostCameras: ghostItem
    sdesc = "video camera"
    noun = 'camera' 'cameras'
    adjective = 'video'
    location = hauntedPeople
;

ghostCross: ghostItem
    noun = 'cross' 'crucifix'
    sdesc = "cross"
    location = hauntedPeople
;

ghostBible: ghostItem
    sdesc = "bible"
    noun = 'bible' 'book'
    adjective = 'holy'
    location = hauntedPeople
;

hauntedPeople: ghostItem
    sdesc = "group of people"
    noun = 'people' 'group' 'scientist' 'scientists' 'reporter' 'reporters'
           'man' 'priest'
    adjective = 'television' 'old'
    location = basement
    actorAction(v, d, p, i) =
    {
        if (v = getOutVerb)
            "Unfortunately, you can't seem to summon a sufficiently
            impressive evil, deep, booming voice; all you can manage
            is a sort of faint moaning sounds.  No one runs away
            in fear.";
        else
            "You can only manage to make faint moaning sounds.";
        exit;
    }
    ldesc = "It's a group of about ten assorted people.  There are
        a couple of people carrying scientific equipment, pointing
        microphones and radiation counters at you.  Several others
        are carrying video cameras, and appear to be television
        reporters.  One is an old man dressed in the clothes of
        a priest; he's carrying a bible and holding out a cross
        in your direction."
    couldSee = nil
    actorDaemon =
    {
        if (Me.location = self.location)
        {
            if (not couldSee)
            {
                "\bA group of people standing around the room
                suddenly notices your presence.  They all gather
                around you, appearing slightly frightened but
                curious.";
                couldSee := true;
            }

            "\bThe group of people is here, watching you carefully
            but keeping their distance. ";
            switch(rand(10))
            {
            case 1:
                "The priest approaches you, crucifix held high
                in front of him. \"Begone, foul spirit!  Return
                thee to the bowels of Hell whence thou came!\" One of the
                reporters shoves him aside to get a better camera angle.";
                break;

            case 2:
                "One of the reporters shoves a camera in your
                face. \"Have you seen Elvis?\" he asks. \"Do you
                have any information on the whereabouts of
                Jimmy Hoffa?\"";
                break;

            case 3:
                "Several of the scientists approach you with
                test equipment. \"This could be bad,\" one of
                the scientists says to the other. \"I'm getting
                a very high ectoplasmatic densitometer reading.\"";
                break;

            case 4:
                "One of the reporters narrates her report:
                \"Top scientists are baffled by the continued
                presence of paranormal activity in this otherwise
                quiet rural home.  Many believe this can only be
                the work of Satan, while others are not so sure.\"";
                break;

            case 5:
                "The scientists move some of their equipment around.";
                break;

            case 6:
                "The priest flips frantically through the pages
                of his bible.";
                break;

            case 7:
                "The reporters check their light levels.";
                break;

            case 8:
                "One of the reporters approaches you. \"Could you make
                some wailing sounds, or rattle some chains?\" One of
                other reporters says, \"Don't worry about it, we can dub
                it in later.\"";
                break;

            case 9:
                "One of the scientists points a radiation counter at you.";
                break;

            case 10:
                break;
            }
            self.know_where := true;
        }
        else if (isclass(Me.location, coordRoom))
        {
            self.know_where := nil;
            couldSee := nil;
        }
        else
        {
            "\bYou hear several voices in the distance saying things
            like \"where did it go?\" and \"I think it went this way!\" ";
            
            if (self.know_where)
            {
                if (Me.location = attic)
                {
                    "The trap door flies open. ";
                    if (ghostRing.location = trapdoor)
                    {
                        "As it does, the ring sitting on the trap
                        door tumbles down into the hall below. ";
                        ghostRing.moveInto(hauntedHall2);
                    }
                    "The group of people scrambles up through the
                    trap door and into the attic; the trap door
                    swings shut again. ";
                }
                else if (Me.location.isPorch and not self.location.isPorch)
                {
                    if (ghostRing.location = hauntedHall1)
                    {
                        "You hear motion behind the door. Someone
                        says, \"Hey! What's this ring doing here?
                        I'll go put it back in the attic.\" A few
                        moments later, the crowd comes bursting
                        through the door, slamming it behind them.";
                        ghostRing.moveInto(ghostTrunk);
                    }
                    else
                        "The crowd comes bursting through the
                        door, slamming it behind them.";
                }
                else if (self.location.isPorch and not Me.location.isPorch)
                {
                    "The crowd comes bursting through the front door. ";
                    if (ghostRing.location = hauntedHall1)
                    {
                        "As the door flies open, it sends the ring
                        sliding down the hall and into the den. ";
                        ghostRing.moveInto(hauntedDen);
                    }
                    "They slam the door behind them.";
                }
                else if (self.location = attic and Me.location = hauntedHall2)
                    "The trap door flies open, and the people all scramble
                    through it down into the hall.  The trap door swings
                    shut once they're through.";
                else if (Me.location.isPorch)
                    " The group of people comes rushing over to you.";
                else
                    " The group of people comes rushing into the room.";

                self.moveInto(Me.location);
                couldSee := true;
            }
            else
                couldSee := nil;
        }
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "You try to speak, but you hear your voice come out
        as a ghostly wailing.";
    }
    doSynonym('AskAbout') = 'TellAbout'
;

backToHell: function
{
    "The same strange fog that brought you here envelopes you again.
    You feel yourself being pulled backwards, downwards.  Soon,
    you find yourself back in...\b";

    unnotify(hauntedPeople, &actorDaemon);
    return(dimnetBooth);
}

basementPortal: fixeditem
    sdesc = "portal"
    noun = 'portal'
    location = basement
    ldesc = "It's a glowing hole in the wall. You believe it may be...
        \b\b\b\t\t\t\tA PORTAL DIRECTLY TO HELL!"
    verDoEnter(actor) = {}
    doEnter(actor) =
    {
        "You approach the portal. ";
        backToHell();
        actor.travelTo(dimnetBooth);
    }
;

basement: ghostRoom
    xcoord = 0
    xcoord1 = 1
    xcoord2 = -1
    ycoord = 0
    ycoord1 = 1
    ycoord2 = -1
    coordDest = solidGround
    sdesc = "Basement"
    ldesc = "You're in a large, unfinished basement.  The walls
        are gray cinderblock; some light is provided by a bare
        bulb hanging from the ceiling. A stairwell leads up.
        \n\tIn the east wall is a strange, glowing portal. You
        realize that it's the interdimensional portal that brought
        you here."
    east =
    {
        "You enter the portal. ";
        return(backToHell());
    }
    up = hauntedDen
    down = (backToHell())
    enterRoom(actor) =
    {
        if (not self.isseen)
            quote(['Get out!'],
                  'The voice of Satan ("The Amityville Horror")');
        pass enterRoom;
    }
;

// move around in a coordinate-based area
moveCoord: function(obj, y, x)
{
    obj.ycoord += y;
    obj.xcoord += x;
    if (obj.xcoord >= obj.xcoord1 and obj.xcoord <= obj.xcoord2
        and obj.ycoord >= obj.ycoord1 and obj.ycoord <= obj.ycoord2)
    {
        if (obj.coordDest.coordWalled)
            "You pass through a wall, and find yourself in...\b";
        return(obj.coordDest);
    }
    else if (obj.xcoord > 5 or obj.xcoord < -5
             or obj.ycoord > 5 or obj.ycoord < -5)
    {
        return(backToHell());
    }
    else
        return(obj);
}

// a room navigated by coordinates
class coordRoom: room
    north = (moveCoord(self, 1, 0))
    south = (moveCoord(self, -1, 0))
    east = (moveCoord(self, 0, 1))
    west = (moveCoord(self, 0, -1))
    ne = (moveCoord(self, 1, 1))
    nw = (moveCoord(self, 1, -1))
    se = (moveCoord(self, -1, 1))
    sw = (moveCoord(self, -1, -1))
;

solidGround: coordRoom
    xcoord1 = -1
    xcoord2 = 1
    ycoord1 = -1
    ycoord2 = 1
    sdesc = "Underground"
    ldesc = "You are embedded in solid earth.  It is intensely
        uncomfortable to be here:  you feel the pressure of tons
        of earth closing in on you, and you can't see any of your
        body.  It feels as though you are unable to move any of
        your limbs."
    up = (enterCoord(meadow, self.ycoord, self.xcoord, nil))
    down =
    {
        "You pass through the floor into the deep ground. ";
        return(backToHell());
    }
    coordDest = basement
;

class downstairsRoom: ghostRoom
    coordDest = meadow
    downDest = basement
;

hauntedDen: downstairsRoom
    xcoord = -1
    ycoord = 1
    upDest = hauntedBR1
    sdesc = "Den"
    ldesc =
    {
        "You're in a den.  The kitchen is to the east,
        a hall leads south, and a stairway leads down.";
    }
    ringDesc = "There's a ring here, perched precariously at the
        top of the stairs."
    down = basement
    east = hauntedKitchen
    south = hauntedHall1
    se = (wallTravel(hauntedLR))
;

hauntedDoor1: ghostItem
    sdesc = "door"
    noun = 'door'
    adjective = 'heavy' 'wooden'
    location = hauntedHall1
    ldesc = "It's a heavy wooden door that opens inwards.
        It's currently closed."
;

hauntedHall1: downstairsRoom
    xcoord = -1
    ycoord = 0
    sdesc = "Hallway"
    ldesc = "You're in a short north-south hallway with a very
        slick, shiny tile floor.  A passage leads east into
        the living room; a stairway at the southwest corner
        of the hall climbs to the second floor.  A closed door
        leads south."
    ringDesc = "There's a ring here, sitting on the floor, right
        up against the door."
    up = hauntedHall2
    east = hauntedLR
    north = hauntedDen
    south =
    {
        "You pass directly through the closed door...\b";
        return(hauntedPorch);
    }
    ne = (wallTravel(hauntedKitchen))
    se = (wallTravel(hauntedPorch2))
;

hauntedDoor2: ghostItem
    sdesc = "door"
    noun = 'door'
    adjective = 'heavy' 'wooden'
    location = hauntedPorch
    ldesc = "It's a heavy wooden door that opens inwards.
        It's current closed."
;

hauntedPorch: downstairsRoom
    isPorch = true
    xcoord = -1
    ycoord = -1
    sdesc = "Porch"
    coordWalled = nil
    ldesc = "You're on the porch in front of the house.  A closed
        door is to the north, and all around is a meadow. The porch
        continues to the east."
    north =
    {
        "You pass directly through the closed door...\b";
        return(hauntedHall1);
    }
    east = hauntedPorch2
    ne = (wallTravel(hauntedLR))
    down = (floorTravel(basement, nil))
    up = (enterCoord(meadowSky, -1, -1, nil))
;

hauntedPorch2: downstairsRoom
    isPorch = true
    xcoord = 0
    ycoord = -1
    coordWalled = nil
    sdesc = "Porch"
    ldesc = "You're on the porch in front of the house, which is
        to the north.  The porch continues to the west, and all
        around is meadow."
    north = (wallTravel(hauntedLR))
    west = hauntedPorch
    nw = (wallTravel(hauntedHall1))
    up = (enterCoord(meadowSky, -1, 0, nil))
;

ghostCups: ghostItem
    location = hauntedKitchen
    sdesc = "styrofoam cup"
    noun = 'cup' 'cups'
    adjective = 'empty' 'styrofoam'
;

ghostWrappers: ghostItem
    location = hauntedKitchen
    noun = 'wrapper' 'wrappers'
    adjective = 'fast' 'food' 'fast-food' 'paper'
    sdesc = "fast-food wrappers"
;

ghostKitchenTable: ghostItem
    location = hauntedKitchen
    noun = 'table'
    adjective = 'kitchen'
    sdesc = "kitchen table"
    ldesc = "It's covered with empty styrofoam cups and fast-food wrappers."
;

ghostKitchenCounter: ghostItem
    location = hauntedKitchen
    noun = 'counter'
    adjective = 'kitchen'
    sdesc = "kitchen counter"
    ldesc = "It's covered with empty styrofoam cups and fast-food wrappers."
;

hauntedKitchen: downstairsRoom
    xcoord = 0
    ycoord = 1
    upDest = hauntedBath
    sdesc = "Kitchen"
    ldesc = "You're in a kitchen.  The room is a mess, as though
        a large group of people have been eating here and not cleaning
        up after themselves; the counter and the kitchen table are
        littered with empty styrofoam cups and fast-food wrappers.
        Passages lead south and west."
    west = hauntedDen
    south = hauntedLR
    sw = (wallTravel(hauntedHall1))
;

hauntedLR: downstairsRoom
    xcoord = 0
    ycoord = 0
    upDest = hauntedBR2
    sdesc = "Living Room"
    ldesc = "You're in the living room.  A kitchen lies to the
        north, and a hall is to the west."
    north = hauntedKitchen
    south = (wallTravel(hauntedPorch2))
    west = hauntedHall1
    nw = (wallTravel(hauntedDen))
    sw = (wallTravel(hauntedPorch))
;

class upstairsRoom: ghostRoom
    up =
    {
        attic.camefrom := self;
        return(floorTravel(attic, true));
    }
    coordDest = meadowSky
;

trapdoor: ghostItem, surface
    sdesc = "trap door"
    noun = 'door' 'trapdoor'
    adjective = 'trap'
    location = attic
;

ghostTrunk: ghostItem, surface
    location = attic
    noun = 'trunk'
    adjective = 'large' 'blue' 'storage'
    sdesc = "storage trunk"
    verDoPush(actor) = {}
    doPush(actor) =
    {
        "You manage to nudge it just slightly, causing it
        to rock back and forth a couple of times. ";
        if (ghostRing.location = self)
        {
            "You manage to disturb it enough that the ring, which
            was perched precariously on the edge, falls off the
            trunk and onto the floor. ";
            ghostRing.dropme;
        }
    }
;

silverRing: amuletItem
    sdesc = "genuine silver ring"
    noun = 'ring' 'amulet'
    adjective = 'silver' 'genuine'
    ldesc = "It's a silver ring with a complex pattern of very
        fine etchings."
;

ghostRing: ghostItem
    location = ghostTrunk
    noun = 'ring'
    adjective = 'silver'
    sdesc = "silver ring"
    isListed = (self.location = ghostTrunk or self.location = trapdoor
                or self.location = basement)
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb and self.location = basement
            and hauntedPeople.location = basement)
        {
            "Your hand passes through the ring, nudging it slightly.
            \n\tThe priest runs over to the ring. \"Can't you all see?
            This cursed ring is what the evil spirit seeks!\" He
            picks up the ring and holds it in front of him, his hands
            trembling. \"In the name of God, I condemn this talisman
            of evil to eternal damnation! Let this foul object be taken
            from the world by this portal of Satan, never to return from
            the infernal regions!  Now, evil spirit, with this ring,
            I thee damn!\" He throws the ring into the portal, and it
            disappears with a flash of sickly green light. \"Begone,
            evil spirit!  Return thee forthwith to Perdition's Flames!\"";

            self.moveInto(nil);
            silverRing.moveInto(dimnetBooth);
            exit;
        }
        else
           pass dobjGen;
    }
    dropme =
    {
        " The ring bounces along the floor, and lands on the trap door.";        if (hauntedPeople.location = attic)
        {
            "\n\tThe reporters all run over to the ring and
            focus their cameras on it. One of the scientists
            rushes over to it and scans it with a radiation
            detector. \"Stand back!  This object has come into
            contact with ectoplasmatic radiation!  It could be
            contaminated!\"\n\tAnother of the scientists approaches
            the ring and grips it with some long metal tongs.
            He turns it over, looking at it, then puts it back
            on the trunk. ";
            if (self.hasBeenMoved = nil)
            {
                "\"This is a highly significant development,\"
                he says importantly. \"This is the first known
                instance of kinetic physical interaction between the
                phenomenon and ordinary matter.\"";
                hasBeenMoved := 1;
            }
            else if (hasBeenMoved = 1)
            {
                "\"Amazing,\" he says. \"The phenomenon definitely
                has the ability to interact kinetically with physical
                matter.  This could open up entire new avenues of
                research.\"";
                hasBeenMoved := 2;
            }
            else
                "\"Hmm.  Perhaps this is all it is able to do.
                It's possible we're dealing with a kinetically
                challenged interdimensional apparitional phenomenon.\"";
        }
        else
            self.moveInto(trapdoor);
    }
    verDoPush(actor) = {}
    doPush(actor) =
    {
        switch(self.location)
        {
        case ghostTrunk:
            "Your hand passes right through it, but you manage to
            nudge it enough that it falls onto the floor.";
            self.dropme;
            break;

        case hauntedHall2:
            "You manage to nudge it down the stairs.  It tumbles
            down to the bottom of the stairs.";
            self.moveInto(hauntedHall1);
            break;

        case hauntedDen:
            "You manage to push it hard enough that it goes
            tumbling down the stairs into the basement.";
            self.moveInto(basement);
            break;

        case basement:
            self.dobjGen(actor, pushVerb, nil, nil);
            break;

        default:
            "You manage to nudge it slightly, but it doesn't
            go anywhere.";
            break;
        }
    }
    doSynonym('Push') = 'Pull' 'Take' 'Move'
    ldesc =
    {
        switch(self.location)
        {
        case ghostTrunk:
            "It's perched precariously on the edge of the trunk.";      
            break;

        case hauntedHall2:
            "It's sitting right at the top of the stairs.";
            break;

        case hauntedHall1:
            "It's sitting up against the closed door.";
            break;

        case hauntedDen:
            "It's sitting right at the top of the stairs.";
            break;

        default:
            pass ldesc;
        }
    }
;

ghostFurniture: ghostItem
   sdesc = "furniture"
   noun = 'furniture' 'couch' 'chair' 'lamp' 'junk' 'recliner' 'lamps' 'couple'
   adjective = 'old' 'leather' 'tattered' 'reclining'
   location = attic
   ldesc = "There's a tattered old couch, a leather reclining chair,
       and a couple of lamps."
;

ghostBoxes: ghostItem
    location = attic
    sdesc = "box"
    noun = 'box' 'boxes' 'book' 'books' 'paper' 'papers' 'junk'
    ldesc = "There's nothing particularly interesting in the boxes;
        just lots of old books and papers."
;

attic: ghostRoom
    xcoord = 0
    ycoord = 0
    xcoord1 = 1
    xcoord2 = -1
    ycoord1 = 1
    ycoord2 = -1
    coordDest = meadowSky
    sdesc = "Attic"
    ldesc = "You're in an old, musty attic. The only exit is
        a trap door, which is closed.  There's junk all around
        the room:  old furniture, boxes of books and papers,
        and several storage trunks.  One particularly large
        storage trunk is standing on one end near the trap door."
    up =
    {
        "You pass through the ceiling into the clear sky. ";
        return(backToHell());
    }
    down = 
    {
        if (self.camefrom) return(floorTravel(self.camefrom, nil));
        else return(floorTravel(hauntedHall2, nil));
    }
;

trapdoor2: ghostItem
    location = hauntedHall2
    noun = 'door' 'trapdoor'
    adjective = 'trap'
    sdesc = "trap door"
;

hauntedHall2: upstairsRoom
    xcoord = -1
    ycoord = -1       /* not really, but we want to be south of porch */
    sdesc = "Upstairs Hall"
    ldesc = "You're in a hall at the top of a stairway.  Passages
        lie to the north and east.  There's a trap door, which is
        currently closed, in the ceiling, probably leading to the
        attic."
    ringDesc = "There's a ring here, perched precariously at
        the top of the stairs."
    north = hauntedBR1
    east = hauntedBR2
    ne = (wallTravel(hauntedBath))
    down = hauntedHall1
;

hauntedBR1: upstairsRoom
    xcoord = -1
    ycoord = 1
    downDest = hauntedDen
    sdesc = "Bedroom"
    ldesc = "You're in a bedroom.  Exits are to the east and south."
    south = hauntedHall2
    east = hauntedBath
    se = (wallTravel(hauntedBR2))
;

hauntedBR2: upstairsRoom
    xcoord = 0
    ycoord = -1    /* not really, but we want to be south of porch */
    downDest = hauntedLR
    sdesc = "Bedroom"
    ldesc = "You're in a bedroom. Exits are to the west and north."
    west = hauntedHall2
    north = hauntedBath
    nw = (wallTravel(hauntedBR1))
;

hauntedBath: upstairsRoom
    xcoord = 0
    ycoord = 1
    downDest = hauntedKitchen
    sdesc = "Bathroom"
    ldesc = "You're in a bathroom. Exits are to the west and south."
    west = hauntedBR1
    south = hauntedBR2
    sw = (wallTravel(hauntedHall2))
;

meadow: coordRoom
    xcoord1 = -1
    xcoord2 = 0
    ycoord1 = -1
    ycoord2 = 1
    sdesc = "Meadow"
    ldesc =
    {
        "You're in a large meadow.  An old house is to the ";
        if (self.ycoord > 0) "south";
        else if (self.ycoord < 0) "north";
        if (self.xcoord > 0) "west";
        else if (self.xcoord < 0) "east";
        ".";
    }
    down = (enterCoord(solidGround, self.ycoord, self.xcoord, nil))
    up = (enterCoord(meadowSky, self.ycoord, self.xcoord, nil))
    coordDest =
    {
        if (self.xcoord = -1)
        {
            if (self.ycoord = 1) return(hauntedDen);
            else if (self.ycoord = 0) return(hauntedHall1);
            else return(hauntedPorch);
        }
        else
        {
            if (self.ycoord = 1) return(hauntedKitchen);
            else if (self.ycoord = 0) return(hauntedLR);
            else return(hauntedPorch2);
        }
    }
;

meadowSky: coordRoom
    xcoord1 = -1
    xcoord2 = 0
    ycoord1 = -1
    ycoord2 = 1
    sdesc = "Floating above meadow"
    ldesc =
    {
        "You're floating above a large meadow.  An old house is to the ";
        if (self.ycoord > 0) "south";
        else if (self.ycoord < 0) "north";
        if (self.xcoord > 0) "west";
        else if (self.xcoord < 0) "east";
        ".";
    }
    down = (enterCoord(meadow, self.ycoord, self.xcoord, nil))
    up =
    {
        "You float up higher. ";
        return(backToHell());
    }
    coordDest =
    {
        if (self.xcoord = -1)
        {
            if (self.ycoord = 1) return(hauntedBR1);
            else return(hauntedHall2);
        }
        else
        {
            if (self.ycoord = 1) return(hauntedBath);
            else return(hauntedBR2);
        }
    }
;

