 lLife.h   
  
y             |8}H}P&}TEXTR*ch       >  	5                       S  ! lLife.h
! The "Life" code, but not board
! David S. Glasser
! Life or Death

! Okay.  This file has most of the Life code.

! This file, with a bit of the code (slightly modified) from lBoard, could
! be stuck into any game.

! Pretty much, I store the status of cells in lists.  However,
! I trick them into pretending to be two-dimensional grids.
! Accessing the element at row r, column c of a grid is accessed by
! (r - 1) * NUM_COLS + (c - 1).  (NUM_COLS is the amount of columns and rows in
! the grid and is defined in life.inf.)  (Don't forget that Inform
! arrays are 0-based.)

! The current board is stored in a NUM_COLS + 2 by NUM_COLS + 2 grid
! called curBoard.  The reason it is two more is to provide a "border"
! so that one can access all neighbors of all cells and not need to put in
! any special case handling for the outside cells.  The border will always be
! empty.

! Therefore, the element in the second row, third column of a Life board
! is in the third row, fourth column of curBoard, and thus is at 
! curBoard -> (2 * (NUM_COLS + 2)) + 3.  curBoard is a byte array, since the
! values need merely to be Boolean.

! Because Life requires a "scratch space", an array that is only NUM_COLS
! by NUM_COLS, newBoard, is used.  As each cell's life is calculated,
! the corresponding section of newBoard is set to 1 or 0.  A routine then
! copies newBoard back onto curBoard.

Array curBoard -> (NUM_COLS + 2) * (NUM_COLS + 2);
Array newBoard -> NUM_COLS * NUM_COLS;

! Public functions are IsOccupied, Activate, Deactivate, RunGame, Board, Toggle
!				ClearLife

! The following functions should be self-evident.  They test curBoard,
! and modify it in place for simple changes.

[ IsOccupied col row;    ! == int IsOccupied(int col, int row)
	return curBoard -> ((NUM_COLS+2)*row + col);
];

[ Toggle col row;		 ! == void Toggle(int col, int row)
	if (IsOccupied(col,row))
		Deactivate(col,row);
	else
		Activate(col,row);
];

[ Activate col row;	 	! == void Activate(int col, int row)
	curBoard->((NUM_COLS+2)*row + col) = 1;
];

[ Deactivate col row;	 ! == void Deactivate(int col, int row)

	curBoard->((NUM_COLS+2)*row + col) = 0;
];

[ CountNeighbors col row; ! == private 
						!== int CountNeighbors(int col, int row)
	return
		IsOccupied (col - 1, row - 1) +
		IsOccupied (col - 1, row    ) +
		IsOccupied (col - 1, row + 1) +
		
		IsOccupied (col    , row - 1) +
		IsOccupied (col    , row + 1) +
		
		IsOccupied (col + 1, row - 1) +
		IsOccupied (col + 1, row    ) +
		IsOccupied (col + 1, row + 1);
];

! CountNeighbors is slightly more complicated.  It counts the neighbors
! by adding up the return values from IsOccupied.  Because of curBoard's
! "border", we don't need to slow this routine down by doing special
! things on the edge of the Board.

[ StartTurn i;		! == private == void StartTurn(void)
	for (i=0:i<(NUM_COLS * NUM_COLS):i++)
		newBoard->i = 0;
];

! StartTurn initializes newBoard.

[ RunGame col row;	! == void RunGame(void);
	StartTurn();
	
	for (col = 1:col <= NUM_COLS:col++)
		for (row = 1:row <=NUM_COLS:row++)
			RunCell(col,row);
	
	EndTurn();
];

! RunGame calls StartTurn to initialize newBoard, calls RunCell
! on each cell, and then calls EndTurn to copy newBoard back to
! curBoard.

[ EndTurn i col0 row0;		! == private == void EndTurn(void)
	for (i=0:i<(NUM_COLS*NUM_COLS):i++)
	{
		row0 = (i/NUM_COLS);
		col0 = (i % NUM_COLS);
		curBoard->(NUM_COLS + 3 + (row0 * (NUM_COLS + 2)) + col0)=newBoard->i;
	}
];

! EndTurn copies newBoard back onto curBoard.  The calculation works.
! If you can't figure out why, make a table of the corresponding values
! for some value of NUM_COLS.

! I'm not sure why the variables are called col0 and row0.  But I'm not
! changing them for fear of messing something up.

[ RunCell col row neighbors; ! == private 
							 ! == void RunCell(int col{1-5}, int row{1-5})
	neighbors = CountNeighbors(col, row);
	
	if (IsOccupied(col, row))
	{								! braces required or else will bind with wrong if
		if (neighbors == 2 or 3)
			NewSet(col, row);
	}
	else
		if (neighbors == 3)
			NewSet(col, row);
];

! RunCell counts neighbors, and sets a spot on newBoard to 1 if the cell
! should be alive.  If one (as an exercise) wanted to changed the Life
! rules to a similar game, RunCell is the function to hack.  (Possibly
! a user-controlable game, with switches for whether any given number
! of neighbors allows birth and survival.)

[ NewSet col row;	! == private == void NewSet(int col{1-5}, int row{1-5})
	newBoard->((row-1) * NUM_COLS + col - 1) = 1;
];

! NewSet sets a cell of newBoard to 1.

[ Board col row i;	! == print (Board) 1;
	font off;
	
	style underline;

	print "+";
	for (i = 1: i < NUM_COLS: i++)
		print i%10, "|";
	print NUM_COLS%10;
	print "+^";
	
	for (row = 1: row <= NUM_COLS: row++)
	{
		print row%10;
		for (col = 1:col <NUM_COLS:col++)
		{
			if (IsOccupied(col,row))
				print "*";
			else
				print " ";
			print "|";
		}
		
		if (IsOccupied(NUM_COLS,row))
			print "*";
		else
			print " ";

		print row%10,"^";
	}
	
	style roman;
	
	print "+";
	for (i = 1: i < NUM_COLS: i++)
		print i%10, "|";
	print NUM_COLS%10;
	print "+^";
	
	font on;
];

! Board is a printing routine that ignores its argument and prints the
! board out.

[ ClearLife i;
	for (i=0:i<NUM_COLS*NUM_COLS:i++)
		curBoard->i=0;
];

! ClearLife will clear the board.

! The rest of this file provides verbs for various cool patterns.

Verb "box" * -> Box;

[ BoxSub odd col row;
	ClearLife();
	odd = NUM_COLS % 2;
	
	if (odd)
		col = row = NUM_COLS/2+1;
	else
		col = row = NUM_COLS/2;
	
	Activate (col - 1, row - 1);
	Activate (col - 1, row    );
	Activate (col - 1, row + 1);
	
	Activate (col    , row - 1);
	Activate (col    , row + 1);
		
	Activate (col + 1, row - 1);
	Activate (col + 1, row    );
	Activate (col + 1, row + 1);
	"You made a box.";
];

Verb "cat" * -> Cat;

[ CatSub odd col row;
	ClearLife();
	odd = NUM_COLS % 2;
	
	if (odd)
		col = row = NUM_COLS/2+1;
	else
		col = row = NUM_COLS/2;
	
	Activate(col, row);
	Activate(col + 1, row);
	
	Activate(col - 2, row - 1);
	Activate(col - 2, row);
	Activate(col - 2, row + 1);

	Activate(col + 3, row - 1);
	Activate(col + 3, row);
	Activate(col + 3, row + 1);

	Activate(col - 1, row - 2);
	Activate(col, row - 2);
	Activate(col + 1, row - 2);
	Activate(col + 2, row - 2);
	
	Activate(col - 1, row + 2);
	Activate(col, row + 2);
	Activate(col + 1, row + 2);
	Activate(col + 2, row + 2);
	
	Activate(col - 1, row - 3);
	Activate(col + 2, row - 3);
	
	"You made a cat.";
];

Verb "glide" * -> Glide;

[ GlideSub;
	ClearLife();
	Activate(2,1);
	Activate(3,2);
	Activate(1,3);
	Activate(2,3);
	Activate(3,3);
	
	"You made a glider.";
];
                                                                       h  h   F[QY!Sk#;0SlLife.h Faxesms/3.24sDemod patt TEXTR*ch                   	  >  !k8-[+QP4k"ㅫ$##PC$SSk
9{,#+K0-;;s?8-/+&Y-K88C8[=   H 	Monaco B     P ^  *<   $ 0X $ 0X5  <  <      R*ch     H H    @]+(   hh    @   d        '                                             Monaco                                                                                                                                                                                                                                                          	   	Helvetica                                                                                                                                                                                                                                                      Confidential                                                                                                                                                                                                                                                                                  H                                                                                                          h  h   F&*<    F MPSR   BBST               L                                                                                   