#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


class RoomInSet : object
	roomSetId = nil
	
	// Note that this might be called multiple times even when going into the same room
	// if the player is travelling in a vehicle.
	notifyBeforeArriving() {
	}
//	notifyAfterArriving() {
//	}
	
	// Note that this might be called multiple times even when going into the same room
	// if the player is travelling in a vehicle.
	notifyBeforeLeaving() {
	}
//	notifyAfterLeaving() {
//: doesn't seem to get called		
//	}
;


// The "me" object needs to be an instance of this class in order for the RoomInSet stuff to work.
class MeRoomInSet : object
	beforeTravel(traveler, connector) {
		notifyOfTravel(connector);
		inherited(traveler,connector);
	}
//	afterTravel(traveler, connector) {
//		"<.p>ME after travel<.p>";	
//		inherited(traveler,connector);
//	}
	
	moveIntoForTravel(newDest) {
		notifyOfTravel(newDest);
		inherited(newDest);
	}
	
	// When entering a NestedRoom, newDest will be nil.
	notifyOfTravel(newDest) {
		// if newDest is nil then that means we're not actually moving to another room.
		// we might be entering a nested room though.
		if(newDest==nil)
			return;
	
		// If the current location is part of a set of rooms and the
		// new destination is not part of that set of rooms
		// then call the callback methods on RoomInSet to notify them that they
		// are leaving one room and entering a new one.
		
		local curLocIsRoomInSet = nil;
		local newLocIsRoomInSet = nil;
		
		local locFrom = location;
		while(true) {
			if(locFrom.ofKind(RoomInSet)) {
				curLocIsRoomInSet = true;
				break;
			}
			if(locFrom.location==nil)
				break;
			locFrom = locFrom.location;
		}
		local locTo = newDest;
		while(true) {
			if(locTo.ofKind(RoomInSet)) {
				newLocIsRoomInSet = true;
				break;
			}
			if(locTo.location==nil)
				break;
			locTo = locTo.location;
		}
		
		
		
		if(curLocIsRoomInSet==true) {
			if(newLocIsRoomInSet==true) {
				// the current location and the new destination are both rooms in a set
				if(locFrom.roomSetId!=locTo.roomSetId) {
					// the new room is not in the same set as the old room.
//					"<.p>FROM <<locFrom.roomSetId>> TO <<locTo.roomSetId>><.p>";
					
					locFrom.notifyBeforeLeaving();
					locTo.notifyBeforeArriving();
					
					inherited(locTo);

//					locFrom.notifyAfterLeaving();
//					locTo.notifyAfterArriving();
				} else {
					// both rooms are part of the same set, so nothing special needs to be done.
					inherited(locTo);
				}
			} else {
				// the current locFrom is a room in a set, but the new destination is not
//				"<.p>FROM <<locFrom.roomSetId>><.p>";
				locFrom.notifyBeforeLeaving();
				inherited(locTo);
//				locFrom.notifyAfterLeaving();
			}
			
		} else {
			if(newLocIsRoomInSet==true) {
				// the current locFrom is not a room in a set, but the new destination is.
//				"<.p>TO <<locTo.roomSetId>><.p>";
				locTo.notifyBeforeArriving();
				inherited(locTo);
//				locTo.notifyAfterArriving();
			} else {
				// neither the current room nor the new destination are part of a set of rooms.
				// so nothing special needs to be done.
				inherited(locTo);
			}
		}
	}
;




//TODO: notifyOfTravel is usually called twice for every travel. Once for by beforeTravel
//  and again by moveIntoForTravel. Modify it to only do it once.


//TODO: The notifyBeforeLeaving() seems to actually be called after the player has already left.

