      INTEGER FUNCTION IBIT(ARRAY,INDEX)
      IMPLICIT INTEGER (A-Z)
C
C Author       : Kevin B Black
C Date written : June 1986
C Abstract     :
C
C BIT ARRAY HANDLING
C
C Integer function. IBIT returns a value of 1 if the INDEXth bit in the
C 'bit array' ARRAY is set and 0 if it is not.
C
C ARRAY    o INTEGER BIT ARRAY An integer (or otherwise) array in which
C            the bit array is stored.
C
C INDEX    o INTEGER The bit which is to be tested.
C
      INTEGER*2 ARRAY(1)
      INTEGER INDEX
C
C Variables (local)
C
C BITS     o INTEGER Array holding masks for testing bits.
C
      INTEGER*2 BITS(16)
C
C Data for bits
C
      DATA BITS/     1,     2,     4,     8,    16,    32,    64,   128,
     *             256,   512,  1024,  2048,  4096,  8192, 16384,-32768/
C
C Compute index into ARRAY and which bit in that element
C
      I=(INDEX-1)/16
      J=INDEX-I*16
C
C Set result
C
      IF((ARRAY(I+1).AND.BITS(J)).EQ.0)THEN
         IBIT=0
      ELSE
         IBIT=1
      ENDIF
      RETURN
C
C
C
      ENTRY BITA(ARRAY,INDEX,VALUE)
C
C Subroutine will set/clear the INDEXth bit in the 'bit array' ARRAY, as
C indicated by the value of the integer VALUE. If value is non-zero then
C the bit is set, otherwise the bit is cleared.
C
      I=(INDEX-1)/16
      J=BITS(INDEX-I*16)
      K=ARRAY(I+1)
C
C Set or clear bit ?
C
      IF(VALUE.NE.0)THEN
         K=K.OR.J
      ELSE
         K=K.AND..NOT.J
      ENDIF
      ARRAY(I+1)=K
      RETURN
      END
