/* $Id: tunnels.t 1.22 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Tunnel locations for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

#include "dark.t"

class darktunnel : darkroom
    leaveRoom(actor) = {
 	if (actor = Me and not self.islit and defined(self, &darkleave))
	    self.darkleave;
    }	    

    shout(actor) = {
        "Perhaps it is not altogether wise to make so much noise down here";
	if (self.islit)
	    ". ";
	else
	    "; somebody	out there in the darkness might be listening.";
    }    
    noexit = "There is a wall in that direction."
    up = "There is about a mile of solid rock in the way."
    down = "There is no exit in that direction."
    out = "You must tell me which direction you want to go."
    in = "You must tell me which direction you want to go."        
    
    wallobj = tunnel_walls
;    


tunnel_walls : wall
    noun = 'wall' 'walls'
    adjective = 'tunnel' 'rock'
    sdesc = "wall"
    ldesc = "The flickering light from your lamp casts fantastic
        shadows on the rough rock walls."
    touchdesc = "Solid rock."
;

startroom : darktunnel
    noun = 'outside-door'
    sdesc = "Outside Door"
    ldesc = "You are standing at the end of a long, winding tunnel
        with rough rock walls. To the north your progress is blocked
	by a massive bronze door; to the south the tunnel begins its
	long, twisting climb back to the surface."

    lookAround(verbosity) = {
        if (not self.isseen) 
	    introtext.txt2;
        pass lookAround;
    }

    north = door_s
    in = door_s
    out = self.south
    south = "You can't just give up and go home, now that you've 
	come so far!"
;

door_s : doorway
    noun = 'door'    
    adjective = 'metal' 'bronze'
    sdesc = "bronze door"
    touchdesc = "The door feels cold to the touch, and reassuringly solid."
    ldesc = {
        if (self.isopen)
	    "It is wide open. The tunnel continues north on the other
	    side. ";
	else
	    "The door looks ancient, encrusted with verdigris, slightly
	    corroded in places, but still quite solid and sturdy. 
	    You notice that it has no visible lock and no handle, 
	    at least not on this side. ";
    }
    doordest = tunnel1
    
    noAutoOpen = true
    doOpen(actor) = {
        "There is no obvious way of opening the door (no handle, to
	start with).";
    }
    verDoBreak(actor) = {
        "With a battering ram, perhaps. Not with your bare hands.";
    }
    verDoLookthru(actor) = {
        if (not self.isopen)
	    "You can't see very much through a closed door.";
    }
    doLookthru(actor) = {
        "The tunnel continues for some distance on the other side
	of the door, losing itself in the shadows beyond the reach
	of your lamp.";
    }
    verDoUnlock(actor) = {
        "You can't find any way of locking or unlocking it - no keyhole,
	no visible lock.";
    }
    verDoLock(actor) = {
        self.verDoUnlock(actor);
    }
    location = startroom
;        

door_n : doorway
    noun = 'door'
    adjective = 'metal'
    sdesc = "door"

    touchdesc = "The door feels reassuringly solid."
    
    noAutoOpen = true
    doOpen(actor) = {
        if (self.location.islit)
            "The door doesn't have a handle on this side!";
	else
	    "You reach for the door handle, but find only the smooth 
	    metal surface of the door, flush against the rock, with no 
	    obvious way of opening it.";
    }
    darkReachable(verb, actor) = {
        return true;
    }
    location = tunnel1
;        
    
tunnel1 : darktunnel
    noun = 'inside-door'
    sdesc = "Inside Door"
    darkldesc = "The darkness is complete, as is the silence. There's
        just your own heartbeat and the invisible rock walls
	closing in on you. Only the cold metal of the door, an armslength 
	to the south, reminds you of the world outside. "
	
    darkleave = {
        if (not tunnel2.darkseen) 
	     "Slowly, carefully, you start advancing, one hand
             touching the tunnel wall.\b";
    }

    enterRoom(actor) = {
        if (not (isseen or darkseen)) {
            "As you walk through the door, you are greeted by a strange, 
	    ethereal harmony; not exactly music, but a single chord of 
	    heavenly beauty and infinite sadness, shimmering in the air
	    like an audible rainbow.\b
	    And then the door slams shut behind you: a metallic
	    crash that cuts off the chord like an axe. ";
	    if (lamp.isIn(self)) {
	        "Your lamp flickers one last time and goes out, 
	        leaving you in total darkness.";
  	        lamp.isActive := nil;
	    }
 	    "\b";
	    music.state := 1;
 	}

	pass enterRoom;
    }
    
    north = tunnel2
    out = door_n
    south = door_n
;

tunnel2 : darktunnel
    noun = 'tunnel-2'
    sdesc = "Tunnel"    
    darkldesc = "The tunnel seems to go on forever, straight into
        the bowels of the mountain, sloping slightly down towards
	the north."
	
    south = tunnel1
    up = tunnel1
    down = {
        return self.north;
    }
    north = { 
        if (not fork.isdarkseen)
	    "You continue down the tunnel for a while. The darkness
	    seems to grow on you until it seems more like a physical
	    object than the mere absence of light; a heavy, suffocating
	    cloak thrown over your head.\b
	    Then, suddenly, the western wall vanishes under your hand.\b";
	return fork;
    }
;    

fork : darktunnel
    noun = 'fork'
    sdesc = "Fork"
    darkldesc = "The tunnel branches here: at least, there's a
        feeling of openness to the northwest, while the main tunnel 
	seems to continue in a north-south direction."
    south = tunnel2
    north = bend
    nw = side_tunnel
;    

side_tunnel : darktunnel
    noun = 'side-tunnel'
    sdesc = "Side Tunnel"
    noexit = "The tunnel ends abruptly here; your hands reveal
             only a rough, unbroken rock surface and no side exits."
    se = fork
    out = fork
        
    enterRoom(actor) = {
	inherited.enterRoom(actor);
	if (whistle.location = self) {
	    "\bYour foot hits a small object, which clatters across the
	    floor with a ringing, metallic sound.";
	    setit(whistle);
	}
    }

    darkobj(verb, actor, obj) = {
	if (obj.darkReachable(verb, actor))
	    return true;
	"%You% can't seem to find it in the dark";
	if (obj = whistle)
	    ", but << obj.thedesc >> must be somewhere on the floor";
	". ";
	return nil;
    }
    floorobj = whistle_floor
;

whistle_floor : floor
    noun = 'floor' 'ground'
    touchdesc = {
        if (whistle.location = self.location)
	    self.doSearch(Me);
	else
	    theFloor.touchdesc;
    }
    doSearch(actor) = {    
        "You get down on your hands and knees and  
	search << self.thedesc >>";
	if (whistle.location = self.location) {
	    ". Your hand closes around something cold and metallic,
	    which you pick up. ";
	    whistle.moveInto(Me);
	    setit(whistle);
	}
	else
            ", but you don't find anything interesting. ";
    }
;

bend : darktunnel
    noun = 'bend'
    sdesc = "Bend"
    darkldesc = "The tunnel bends slightly here, from the 
  	south to the northeast."
    south = fork
    ne = junction
;
    
junction : darktunnel
    noun = 'junction'
    sdesc = "Junction"
    darkldesc = "The tunnel is wider here, and something - perhaps
        a difference in how the sound of your footsteps reflects off
	the walls, perhaps a faint movement of air - tells you that
	there are side tunnels leading off in many directions."
    sw = bend
    east = crawl
    north = { 
        "You follow the tunnel for a while; then, a feeling of 
        even denser darkness ahead makes you stop. The tunnel
	seems to be blocked by a cave-in; there's nothing to 
	do but return.";
	return nil;
    }
    ne = {
        "This tunnel rapidly becomes too narrow for you to pass.";
	return nil;
    }
    se = {
        return self.ne;
    }
    south = sandy_tunnel
;

sandy_tunnel : darktunnel
    noun = 'sandy-tunnel'
    sdesc = "Tunnel"
    darkldesc = {
        "This tunnel feels different: the walls are smoother
        to the touch, and the floor is covered with soft sand that
	muffles your footsteps.";
	if (manhole.isopen)
	    "\bWith your foot you can trace out an open manhole
	    in the floor.";
    }	    
    enterRoom(actor) = {
        local wasseen := self.isseen or self.darkseen;
	inherited.enterRoom(actor);
	if (wasseen and manhole_handle.status < 2) {
            "\b%Your% foot catches on something hard, 
	    buried in the sand.\n";
	    manhole_handle.moveInto(self);
	    setit(manhole_handle);
	}
    }

    south = sandy_dead_end
    north = junction
    floorobj = sandy_tunnel_floor
;
 
class sandy_floor : floor
    noun = 'sand' 'dirt' 'floor' 'ground'
    touchdesc = "The floor is covered by a thick layer of soft,
        rather moist sand. "

    doSynonym('DigIn') = 'Search'
    verDoDigIn(actor) = { }
    doDigIn(actor) = {
        "You dig in the sand with your hands for a while, finding
        nothing of interest. ";
    } 
    
    doSynonym('DigIn') = 'Take'
    darkReachable(verb, actor) = {
        return true;
    }
;
	
sandy_tunnel_floor : sandy_floor
    touchdesc = {
        if (manhole_handle.isIn(sandy_tunnel))
	    self.doDigIn(Me);
	else
	    pass touchdesc;
    }
    
    doSynonym('DigIn') = 'Search'
    doSynonym('DigIn') = 'Take'  
    doDigIn(actor) = {
        if (manhole_handle.status = 3)
	    "You dig in the sand for a while, but find nothing further.";
	else {
	    "You start digging in the sand with your hands. ";

	    if (manhole_handle.location = nil)
  	        manhole_handle.moveInto(sandy_tunnel);
	    if (manhole_handle.status < 2)
	        "Almost immediately, you hit something hard,
		some kind of metal handle.\b";
	    "Excitedly clearing away the sand around the handle, you
	    reveal a metal manhole cover.";

	    manhole_handle.status := 3;
	    manhole.moveInto(sandy_tunnel);
	    sandy_tunnel.down := manhole;
	    setit(manhole);
	}
    }  
;

manhole : doorway
    noun = 'cover' 'manhole' 'lid' 'trapdoor'
    adjective = 'manhole' 'iron'
    sdesc = "manhole"
    touchdesc = self.ldesc
    
    doordest = {
        "You carefully lower yourself through the manhole.
	Feeling metal ladder rungs under your feet, you start climbing;
	down through darkness for what seems like an eternity, until
	you finally reach the bottom of the shaft.\b";
	return below_manhole;
    }

    doOpen(actor) = {
	"You grasp the handle and pull with all your strength. 
	Slowly, with a grating noise of rusty hinges, you raise 
	the manhole cover. ";        
	self.isopen := true;
    }
    doPull -> manhole_handle
    doPush -> manhole_handle
    noAutoOpen = true
    
    darkReachable(verb, actor) = {
        return true;
    }
;
    
manhole_handle : fixeditem
    noun = 'object' 'handle'
    adjective = 'hard' 'iron' 'metal' 
    sdesc = { 
        if (self.status < 2)
	    "hard object";
	else
	    "iron handle";
    }
    touchdesc = {
        if (self.status = 3) 
	    "It is attached to a manhole cover. ";
	else {
            "It seems to be some kind of metal handle, 
            almost buried in the sand. ";
            self.status := 2;
	}
    }

    verDoTake(actor) = {
        if (self.status < 3)
	    self.verDoPull(actor);
	else
	    "It's firmly attached to the manhole cover.";
    }	         
        
    status = 1   // 1 = hidden, 
                 // 2 = examined but buried, 3 = excavated

    verDoPull(actor) = {
        if (status < 3) 
	    "You pull at << self.thedesc >> with all your strength, 
	    but it only gives a little. 
	    Perhaps if you cleared away all that sand..."; 
    }
    doPull(actor) = {
	if (manhole.location <> nil and not manhole.isopen)
	    manhole.doOpen(actor);
	else
	    "Nothing happens.";
    }

    verDoPush(actor) = { }
    doPush(actor) = {
        if (status < 3 or not manhole.isopen)
            "Nothing happens.";
	else
	    manhole.doClose(actor);
    }
    
    darkReachable(verb, actor) = {
        return true;
    }
;

sandy_dead_end : darktunnel
    noun = 'sandy-dead-end'
    sdesc = "Tunnel"
    darkldesc = "The tunnel gets narrower to the south, and the
 	sand is deeper, making it harder to walk."
    north = sandy_tunnel
    out = sandy_tunnel
    south = "The tunnel becomes too narrow to pass here."
    floorobj = sandy_dead_end_floor
;

sandy_dead_end_floor : sandy_floor
;


crawl : darktunnel
    noun = 'crawl'
    sdesc = "Crawl"
    darkldesc = "The ceiling gets lower and lower towards the east, and
        soon there's only room to crawl on your hands a knees."

    message = "A faint but insisten current of air brushes your face."
    airdesc = "The air current is weak, but steady; it seems to be
        coming from the east."
    west = junction
    east = squeeze
;

squeeze : darktunnel
    noun = 'squeeze'
    sdesc = "Squeeze"
    darkldesc = "The tunnel gets even lower and narrower towards the
        east, and you have to squeeze yourself forward between rough 
	rocks surface. Finally, you reach a point where you're almost
	stuck, like a cork in a bottle."
	
    message = "The air current is quite strong here, almost a breeze."
    airdesc = {
        "You trace the air current with your hand, up to a
        crack in the wall.";
	setit(crack);
    }
	
    west = crawl
    east = "The tunnel narrows even further in that direction; only a
        snake could proceed."
    out = crawl
    noexit = "It's a tight enough squeeze going east or west. There's
        no space at all to move in any other direction."

    wallobj = nil // crack serves as 'wall' in this room.
;

crack : fixeditem, qcontainer
    noun = 'opening' 'crack' 'wall' 'walls'
    adjective = 'tunnel' 'rock' 
    sdesc = "crack"
    
    darkReachable(verb, actor) = {
        return true;
    }
    verIoPutIn(actor) = {
        "That would be totally pointless.";
    }

    touchdesc = {
        if (not paper.discovered) {
	    paper.discovered := true;
	    paper.moveInto(self);
	}
        "The crack is about a foot long and a couple of
	inches across, with jagged edges. You can feel the air
	streaming up through it from below. ";
	if (paper.isIn(self)) {
	    "Your hand brushes against something: a piece of paper, 
	    lodged inside the crack. ";
	    
	    setit(paper);
	}
    }
    location = squeeze
;

air : item, floatingItem
    noun = 'current' 'air' 'draught' 'wind' 'breeze' 'breath'
    adjective = 'air'
    sdesc = "air"
    darkdesc = self.ldesc
    ldesc = {
        local loc := outerLoc(Me);
        if (defined (loc, &airdesc))
	    loc.airdesc;
	else
	    "The air is cold and surprisingly fresh, and moving; every
	    now and then you can feel it brushing against your
	    face, but it's hard to tell which way it's blowing.";
    }
    // You can always find the air, even in the dark...
    darkReachable(verb, actor) = {
        return true;
    }
    
    verDoSmell(actor) = { }
    doSmell(actor) = {
        "Cool, fresh, with just a hint of stone.";
    }

    verDoTouch(actor) = { }
    doTouch(actor) = {
        self.ldesc;
    }
    verDoFollow(actor) = {
        "You must tell me in which direction you want to go. ";
    }

    dobjGen(a, v, i, p) = {
        if (v <> inspectVerb and v <> smellVerb and v <> touchVerb and
	    v <> followVerb) {
            "I don't know how to << v.sdesc >> the air.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { 
        "How could you << v.sdesc >> anything << p.sdesc >> air?";
        exit;
    }
    location = {
        return Me.location;
    }
;

