#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <VideoGameMachine.h>


player2 : UntakeableActor 'young boy/guy/man/Eric/Fortytwo' 'Eric'
	@arcadeStairwellMiddle
	properName = 'Eric'
	nickname = 'Fortytwo'
	isHim=true
	
	isProperName = true
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"Why in the world would you want to hurt Eric? He's so nice! ";
		}
	}
	iobjFor(ThrowAt) {
		check() {
			replaceAction(Attack, self);
		}
	}
;

+ Decoration 'curly brown hair' 'hair'
	"It's curly and brown. "
;

//
// DEFAULT RESPONSES
//

	+ DefaultAskTopic, ShuffledEventList [
		'Eric just shrugs. He apparently has nothing to say. '
		]
	;
	+ DefaultTellTopic, ShuffledEventList [
		'Eric just shrugs. You don\'t seem to have captured his interest. '
		]
	;
	+ DefaultGiveTopic, ShuffledEventList [
		'<q>No thanks.</q> '
		]
	;
	+ DefaultShowTopic, ShuffledEventList [
		'<q>He seems uninterested.</q> '
		]
	;
	+ DefaultAskForTopic, ShuffledEventList [
		'<q>Don\'t be so greedy.</q> '
		]
	;
	+ DefaultAnyTopic, ShuffledEventList [
		'<q>You should really just play some video games.</q> '
		]
	;


//
//
//

+ class FurtherDelayableAgendaItem : object
	readyTime = nil
	
	// If this is put at the end of the isReady list of requirements then
	// it will not be executed until all other requirements have been met.
	// As a result, it is necessary for this to always be put at the end of the requirements list
	// in the isReady method.
	hasWaitedRequiredDelay(requiredTurnDelaySinceReady) {
		if(readyTime==nil)
			readyTime = Schedulable.gameClockTime + requiredTurnDelaySinceReady;
		return Schedulable.gameClockTime >= readyTime;
	}
;

+ class Player2MeetingAgendaItem : ConvAgendaItem,FurtherDelayableAgendaItem
    isReady = ( inherited()
				&& player2.canSee(gPlayerChar)
				)
	initiallyActive = true
	isDone = nil
;

+ commentOnFinishOfFrogger : Player2MeetingAgendaItem
    isReady = ( inherited() && froggerMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>So you won <<copyparanoid.name_frogger>> huh?
		That's incredible! I've never beaten that game!
		I was probably blinded by the horrible civil engineering in the game.
		You know, I always wondered what type of crappy civil engineer designed that roadway.
		You would think that there would be a crosswalk that you could make use of.
		But no! Normally civil engineers react to accidents and remedy the situation
		by adding stop signs or something. But what do they do when frog after frog
		after frog gets run over by cars? Nothing! They do nothing! It just makes me
		sick! Anyway, good job. You've beaten me. Go ahead and put your final ticket in the
		highscore board upstairs.</q>
		<p>
		Eric returns to staring thoughtfully around the room. ";
		isDone = true;
	}
;

+ commentOnFinishOfPong : Player2MeetingAgendaItem
    isReady = ( inherited() && pongMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>So <<copyparanoid.name_pong>> is now a notch on the bedpost for you eh?
		Have you ever thought what it would be like to be the <<copyparanoid.name_pong>> ball? It's all back and forth,
		over and over, with no respite but the inevitable plunge into the horrible infinite
		depths beyond the edges of the world. I have no doubt that it would thank you for the
		extra trips across the void. Anyway, good job.</q>
		<p>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;

+ commentOnFinishOfSpaceInvaders : Player2MeetingAgendaItem
    isReady = ( inherited() && spaceInvadersBunkerMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>So <<copyparanoid.name_spaceInvaders>> is now a bug beneath your boot?
		Well done! But, did you know that the invaders were actually on a peaceful mission
		to the earth? They met with delegates on Earth to set up agreements that would encourage
		trade between the two races. Things were going quite well until a farmer ran out onto
		the field and attacked one of the aliens with a pitchfork. The aliens dispatched with
		the man quite easily, but this caused quite a bit of embarrassment among the cows who
		eventually had to admit that the entire Cow Race was enslaved by humans.
		<p>
		When the aliens reported back, it set off a political tidal wave. Calls for blood came
		from all quarters. Feeling the tremendous political pressure, the alien leader who was
		by nature a calm and quiet herbivore, made an uncharacteristically fiery speech to his
		people. Within days the alien congress authorized a full scale invasion of earth.
		<p>
		You know the rest of the story. They started leveling all human population centers on
		earth, but you came along and took down the entire alien fleet! Congratulations!</q>
		<p>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;

+ commentOnFinishOfTetris : Player2MeetingAgendaItem
    isReady = ( inherited() && tetrisMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>I see that <<copyparanoid.name_tetris>> is now bird droppings on your windshield!
		You know, some games have in them a lot of social commentary.
		<<copyparanoid.name_tetris>> is definitely one of those games.
		<p>
		First off, I think it's clear that anyone who plays this game will come away with a better
		understanding of why we have building codes. Obviously, if people are left to their
		own devices like they are in <<copyparanoid.name_tetris>>, they will build buildings so
		rickety that any lateral pressure on the building (caused by pushing a block into a horizontal
		space that results in a full row from side to side) will cause floors to collapse until
		that pressure is relieved.
		<p>
		Secondly, this game illustrates the folly of restricting your building materials to only
		those pieces of steel that can be constructed by putting together 4 square blocks. It's
		pure zealous nonsense that people have to believe in such a Zen form of civil engineering.
		<p>
		I hope that, in addition to playing the game, you have also learned those important lessons.
		</q>
		<p>
		Eric looks contemplative for a bit and then turns away and starts wandering around the
		arcade again. ";

/*		
		"That's impressive, but did you know that there was a story behind that game and that
		you only played a part in the ending of that story?
		<p>
		
		<p>
		Honestly, it's just plain lazy to just play a game. Those that don't know
		history are doomed to repeat it.
		<p>
		The story begins with a bypass. The government decided to build a bypass through a tiny
		neighborhood. The property prices there were horrid, so most people were extremely enthusiastic
		to sell their homes to the government for prices that were substantially higher than what
		the houses had originally been worth.
		<p>
		But, despite the horrid environment in the area, a small group of people refused to move.
		The government systematically demolished all the buildings in the area, but the squatters
		refused to move even after everything around them had been leveled.
		<p>
		Negotiations became tense and someone in the government decided to try to scare them out.
		They started dropping girders and crushed cars and tons of other oddly twisted steel
		remnants (from who knows what) onto the building. However, unknown to the government,
		the squatters were prepared. They had put a layer of rubber onto the ceiling of the building
		and then electrified one steel fence on one side of the building and then grounded the fence
		on the other side.
		<p>
		When enough metal was dropped onto their building to form a solid floor from one fence to the
		other, the electricity shorted across and melted it into molten metal that dripped to the
		ground.
		<p>
		This worked great so long as only one or two stories worth of metal was melted at the same
		time. But, when you caused 4 stories to be shorted at the same time, the metal came crashing
		down and crushed the building beneath. Many people were probably killed.
		<p>
        That may sound harsh, but remember, this was for a bypass! You've got to build bypasses!
		</q>.
		<p>
		Eric looks contemplative for a bit and then turns away and starts wandering around the
		arcade again. ";
*/		
		
		isDone = true;
	}
;

+ commentOnFinishOfDuckHunt : Player2MeetingAgendaItem
    isReady = ( inherited() && duckHuntFieldMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>So the deadly ducks of <<copyparanoid.name_duckHunt>> are damp dirt dumped
		down the drainpipe? Excellent. I mean, they are clearly horrible or phrases
		like 'duck your responsibilities' would not have become commonplace. Clearly,
		ducks are lazy irresponsible layabouts who are, if third hand rumor and passionate claims
		made by unqualified people are anything to go by, the cause of 37% of all
		traffic accidents.
		You probably saved countless human lives by eliminating the menace that is
		Anas platyrhynchos.</q>
		<p>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;
/*
+ commentOnFinishOfCraneFrustration : Player2MeetingAgendaItem
    isReady = ( inherited() && craneFrustration.wasWon )
	invokeItem() {
		"Eric congratulates you, <q>That game is a huge pain.
        Honestly, you would think they could develop easier ways for people to buy
		crap with quarters. How about a vending machine?</q>
		<p>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;
*/

/*
+ commentOnFinishOfAtariAdventure : Player2MeetingAgendaItem
    isReady = ( inherited() && atariAdventureSecretMachine.wasWon )
	invokeItem() {
		"Eric congratulates you, <q></q>
		<p>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;
*/
+ commentOnFinishing1Game : Player2MeetingAgendaItem
    isReady = ( inherited() && highscoreBoard.playerScore==1 && hasWaitedRequiredDelay(1) )
	invokeItem() {
		"Eric turns towards you smiling. <q>I just realized that you just recently won
		your first game. Great job!
		Good luck on ever getting onto the high score board though.</q>
		Eric turns away and starts wandering around the arcade again. ";
		isDone = true;
	}
;

+ commentOnFinishingAllButOneGame : Player2MeetingAgendaItem
    isReady = ( inherited() && highscoreBoard.playerScore==(highscoreBoard.numWinningTickets-videoGameGlobalInfo.countGamesInBasement) )
	invokeItem() {
		"Eric walks up to you. <q>I see that your score matches mine now...
		No one has done that before.</q> Eric brightens up, <q>I will be magnanimous.
        Perhaps you would like the chance to beat it? Follow me.</q> ";
		
        p2sWalkingToBasement.startScript();

		isDone = true;
	}
;



+ p2aStart : ConvAgendaItem
	initiallyActive = true
	invokeItem {
		getActor.addToAgenda( p2aEnterArcade.setDelay(2) );
		isDone = true;
	}
;

+ p2aEnterArcade : DelayedAgendaItem
    isReady = ( inherited()
	 && gPlayerChar.roomLocation.ofKind(ArcadeRoomSet)
	 )
	isInitiallyActive = nil
	
	invokeItem {
		getActor.moveIntoForTravel(arcade);
		nestedActorAction(getActor,UnlockWith,arcade.north,arcadeMiddleDoorKey);
	
		if(gPlayerChar.isIn(arcade)) {
			"You hear the click click of a lock being unlocked on the north door.
			It opens and a young boy enters the arcade, closing the door behind him.
			He turns to you and smiles, <q>I thought I heard a noise
			up here! You must be here because you couldn't get access to the games during
			the day. Every now and then someone shows up after hours.</q> ";
		} else {
			callWithSenseContext(player2, sound, {:"You hear a door open and shut in the main arcade room. "} );
			getActor.addToAgenda(p2aIntroduceSelf);
		}
		isDone = true;
	}
; 

+ p2aIntroduceSelf : DelayedAgendaItem
    isReady = ( inherited() && gPlayerChar.isIn(arcade) && player2.isIn(arcade) )
	isInitiallyActive = nil
	
	invokeItem {
		"The source of the door sound was apparently the young boy that is walking
		around the room now. He turns to you and smiles, <q>I thought I heard a noise
		up here! You must be here because you couldn't get access to the games during
		the day. Every now and then someone shows up after hours. Hi! My name is Eric!</q>
		He walks up and vigorously shakes your hand then abruptly goes back to checking
		out the games in the arcade. ";
		isDone = true;
	}
; 

// This helps the player out if they're stuck trying to turn on the power.
+ Player2MeetingAgendaItem
    isReady = ( inherited() && gPlayerChar.isIn(arcade)
		&& !powerSwitch.wasTurnedOnAtLeastOnce
		&& libGlobal.totalTurns>40
		)
	
	invokeItem() {
		"Eric wanders over with a concerned look on his face,
		<q>You've been here for a while, but you haven't played any games yet!
		If you want to play some games, you need to turn on the power. Take a look at the money changer.</q> ";
		isDone = true;
	}
; 


+ p2sNormal : ActorState
	isInitState = true

	specialDesc = "Eric is wandering around the room, glancing at each of the
		machines. "

	stateDesc = "He looks about 8 years old. He has curly brown hair and is obviously
		the mischievous type considering that he is here after hours just like you are. "
;

// This is the state player2 is in as he walks to the basement.
+ p2sWalkingToBasement : ActorState
	specialDesc {
//		"Eric is here, heading to what looks to be your final challenge. ";
		if(player2.isIn(arcade)) {
//			"Eric is heading for the north door. ";
		} else if(player2.isIn(arcadeStairwellMiddle)) {
//			"Eric is here walking down the stairs. ";
		} else if(player2.isIn(arcadeStairwellBottom)) {
			"Eric is here, pulling out his keys. ";
		} else if(player2.isIn(arcadeBasement)) {
		}
	}

	// This assumes that player2 is in the arcade. It shouldn't be possible for this to
	// not be the case.
	startScript() {	
		if(daemon==nil) {
			player2.curState = p2sWalkingToBasement;
			player2.scriptedTravelTo(arcadeStairwellMiddle);
		
			daemon = new Daemon(self,&continueScript,2);
		}
	}
	
	continueScript() {
		if(player2.isIn(arcade)) {
			player2.scriptedTravelTo(arcadeStairwellMiddle);
		} else if(player2.isIn(arcadeStairwellMiddle)) {
			if(!gPlayerChar.isIn(arcadeStairwellMiddle))
				callWithSenseContext(player2, sound, {:"Eric's footsteps echo as he travels down the stairs. "} );
			player2.scriptedTravelTo(arcadeStairwellBottom);
		} else if(player2.isIn(arcadeStairwellBottom)) {
			if(arcadeBasementDoorFromStairs.isLocked) {
				nestedActorAction(player2,UnlockWith,arcadeStairwellBottom.south,arcadeBasementKey);
			} else {
				player2.scriptedTravelTo(arcadeBasement);
				daemon.removeEvent();
				daemon = nil;
				player2.curState = p2sInBasement;
			}
		}
	}
	
	daemon = nil
;



+ p2sInBasement : ActorState
	specialDesc = "Eric is standing in the basement, staring at the video game. "
;
/*
+ p2sFried : HermitActorState
	specialDesc = "The boy is lying on his back on the floor. "

	stateDesc = "He's lying on his back on the floor. The skin on his hands
		looks a little singed and his hair is all pointing straight out in a rather
		comic way. He appears to still be breathing, so he's apparently ok, but he is
		unconscious. I guess he didn't respond well to the lightning strike. "
	
	noResponse = "Any conversation you have with Eric at this time will be rather one sided. "
;
*/

+ HelloTopic
	topicResponse {
		if(highscoreBoard.playerScore>=(highscoreBoard.numWinningTickets-videoGameGlobalInfo.countGamesInBasement)) {
			"Eric grins and says, <q>I'm impressed at your gaming ability. Not many people
			are as good as you are.</q> ";
		} else {
			"Eric smiles and says, <q>Hello to you too! Nice storm we\'re having today... But, enough of this witty banter. I suggest
			you play some games!</q> ";
		}
	}
;

+ AskTopic @player2
	topicResponse {
		"<q>I love playing video games! Honestly, there isn't really much more to say about me.</q> ";
	}
;


+ AskTellTopic 'ball room'
	topicResponse {
		"<q>I caution against spending too much time in there. Some kids do extremely disgusting things in there.</q> ";
	}
;
+ AskTellTopic 'balls'
	topicResponse {
		"<q>I caution against spending too much time in there. Some kids do extremely disgusting things in there.</q> ";
	}
;

/*
+ AskTellTopic @craneFrustration
	topicResponse {
		"<q>I can\'t stand playing that stupid game. I beat it once and that was enough.</q> ";
	}
;
*/

+ AskTellTopic @duckHuntSenateMachine
	topicResponse {
		"<q>That\'s a good game. FYI, that machine is linked to the <<duckHuntFieldMachine.identifier>> machine.</q> ";
	}
;
+ AskTellTopic @duckHuntFieldMachine
	topicResponse {
		"<q>That\'s a good game. FYI, that machine is linked to the <<duckHuntSenateMachine.identifier>> machine.</q> ";
	}
;
+ AskTellTopic @froggerMachine
	topicResponse {
		"<q>It seems like a simple game, but I just can't master it. The only thing I do know is
		that nothing is required from any other game in order to finish this one.</q> ";
	}
;
+ AskTellTopic @pongMachine
	topicResponse {
		"<q>Sometimes simple games can provide a lot of enjoyment.</q> ";
	}
;
+ AskTellTopic @spaceInvadersBunkerMachine
	topicResponse {
		"<q>That\'s a good game. FYI, that machine is linked to the <<spaceInvadersShipMachine.identifier>> machine.</q> ";
	}
;
+ AskTellTopic @spaceInvadersShipMachine
	topicResponse {
		"<q>That\'s a good game. FYI, that machine is linked to the <<spaceInvadersBunkerMachine.identifier>> machine.</q> ";
	}
;
+ AskTellTopic @tetrisMachine
	topicResponse {
		"<q>That is a total classic.</q> ";
	}
;

/*
+ AskTellTopic @pacmanStuffedAnimal
	topicResponse {
		"<q>Pac-Man rules!</q> ";
	}
;
*/


+ AskTellTopic @highscoreBoard  topicResponse {"<q>I am #1! Hooray! No one has ever beaten my score.
	Just so you know, you only get a ticket when you finish a game for the first time. The highscore
	board indicates the total number of unique games that each person has won. If you beat a single
	game a bunch of times then good for you, but it won't matter when it comes to the highscore
	board.</q> ";}  ;
+ AskTellTopic @moneyChanger  topicResponse {
	"<q>The money changer has been out of order for a while. During the day the owner will
	convert money to tokens for players, but at night he just puts all the games on free play for me.</q> ";}  ;

+ AskTellTopic 'videogame|videogames|video game|video games|game|games'
	topicResponse {"<q>I love videogames. That's why I'm #1 on the highscore board!</q> ";}
;

+ keyringTopic : AskTellTopic @arcadeKeyring  topicResponse {"<q>Sorry, those are my keys. You can't have them.</q> ";}  ;
+ AskTellTopic @arcadeMiddleDoorKey  topicResponse=keyringTopic.topicResponse  ;
+ AskTellTopic @arcadeBasementKey  topicResponse=keyringTopic.topicResponse  ;

+ AskTellTopic 'power'  topicResponse {"<q>They power off all the machines every night.</q> ";}  ;
+ AskTellTopic @powerSwitch  topicResponse {"<q>They power off all the machines every night. If you want to play some games, just flip it to power the arcade on and off.</q> ";}  ;

+ AskTellTopic @arcade  topicResponse {"<q>I love this arcade! The games are fun and the people are cool. I've got all I could want here.</q> ";}  ;
+ AskTellTopic 'lightning|thunder|storm|rain|weather'  topicResponse {"<q>This is one heck of a storm isn't it!
	It's so dark out there that you can only see things during the lightning flashes!</q> ";}  ;
+ AskTellTopic 'roof'  topicResponse {"<q>Going up there is dangerous in this weather. Just stay inside.</q> ";}  ;
+ AskTellTopic 'basement'  topicResponse {"<q>The basement is my personal gaming room. Pretty cool huh!</q> ";}  ;
+ AskTellTopic 'stairs|downstairs|stairwell|stairway'  topicResponse {
	"<q>You really aren't supposed to be in the back of the arcade, but then again I suppose
	you're not supposed to be here after hours at all. So, feel free to explore.</q> ";}  ;

+ AskTellTopic @arcadeFrontDoor  topicResponse {"<q>The storm out there is pretty fierce. You should probably just stay in the arcade until the storm lets up.</q> ";}  ;
+ AskTellTopic @arcadeBasementDoorFromStairs  topicResponse {"<q></q> ";}  ;
 

+ AskTellTopic @msPacmanPoster topicResponse {"<q>It's so awesome! I got it at a Pac-Man convention.</q> ";}  ;
+ AskTellTopic '(.* )?ticket[s]?' topicResponse {"<q>When you get a ticket, be sure to put it into the highscore board.</q> ";}  ;

+ AskTellTopic 'reddragon' topicResponse {"<q>He is one scary guy. He has red hair, burnt red skin, and red eyes. I think he goes to tanning parlors specifically to burn his skin red on a regular basis. I'm pretty sure the red eyes are just contacts, but you never know...</q> ";}  ;
+ AskTellTopic 'nerfherder' topicResponse {"<q>He's a Star Wars freak. He's always walking around here quoting Star Wars characters.</q> ";}  ;
+ AskTellTopic 'zarf'  topicResponse {"<q>I've never met him personally, but I hear that he is a dark and mysterious fellow who is presumably good at games.</q> ";}  ;
+ AskTellTopic 'cobalt'  topicResponse {"<q>He got is nickname because he sometimes holds his breath when he's in tight spots while playing games.</q> ";}  ;
+ AskTellTopic 'hightower'  topicResponse {"<q>He is very tall. He can hardly reach down far enough to play games!</q> ";}  ;
+ AskTellTopic 'ram'  topicResponse {"<q>He's a big fan of Tron. He's an ok player I guess.</q> ";}  ;
+ AskTellTopic 'masterblaster'  topicResponse {"<q>He calls himself MasterBlaster, but he's really not much of a master at playing games.</q> ";}  ;
+ AskTellTopic 'l337'  topicResponse {"<q>You can pretty much guess that anyone who talks in l337 is anything but elite.</q> ";}  ;
+ AskTellTopic 'pacmaster'  topicResponse {"<q>His highscores don't really show how great a player he is. He's the type of guy that gets really good at one game instead of trying to master many games.</q> ";}  ;

+ AskTellTopic @Crocodile  topicResponse = "<q>Those crocodiles are horribly scary! I wouldn't get too close to one while it still looked hungry.</q> ";
+ AskTellTopic @frog  topicResponse = "<q>The frog is sooo cute!</q> ";
+ AskTellTopic @me  topicResponse = "<q>You seem like a nice enough person...</q> ";


+ GiveShowTopic
	topicResponse = "Eric grins and says, <q>That's your proof that you have won a game for the first time. I suggest
		that you go put it in the highscore board.</q> "
		
	matchTopic(fromActor,obj) {
		return obj.ofKind(WinningTicket) ? matchScore : nil;
	}
;

+ ShowTopic @twentyDollarBill
	"<q>It's always good to have cash on hand in here, but lucky for you the games are all set on free play after hours.</q> "
;
+ GiveShowTopic @twentyDollarBill
	topicResponse {
		"Eric takes the money and enthuses, <q>Thank you very much!</q> ";
		twentyDollarBill.moveInto(nil);
	}
;


//TODO: This doesn't work right. When I add UnlockAction, it has action.getDobj()==nil even when
//	unlocking something that's present.
+ CommandTopic [UnlockWithAction]
	handleTopic(fromActor, action) {
		if(action.getDobj()==nil)
			"<q>I can't unlock that.</q> ";
		if(action.getDobj()==arcadeFrontDoor)
			"<q>It's not locked.</q> ";
		else if([arcadeBasementDoorFromStairs,arcadeBasementDoorToStairs].indexOf(action.getDobj())!=nil) {
			if(arcadeBasementDoorFromStairs.isLocked())
				"<q>That's the basement. It's my personal little area. I only unlock it for people who have impressed me.</q> ";
			else
				"<q>It's already unlocked.</q> ";		
		} else if(action.getDobj().ofKind(Door)) {
			if(action.getDobj().isLocked())
				"<q>I can't unlock that.</q> ";
			else
				"<q>It's already unlocked.</q> ";		
		} else
			"<q>I can't unlock that.</q> ";
	}
;

