
Object sc_1
  class Scene,
  with
	number 1,
	begin_scene [ rock;
		print "^On the whole, it was worth the trip. The plains really were broad and
			grain-gold, if scarred with fences and agricultural crawlers. The mountains
			were overwhelming. And however much of the capital city
			is scarred with squat brick and faceless concrete hulks, there are still
			flashes of its historic charm.^^";
		print "This alley, however, has no time for charm.
			It ends in flat bare dirty
			brick, and a door which lacks even the courtesy of a handle.
			Not that you'll wait on courtesy.^";
		switch (rock) {
			-1, -2: ! boom/splat
				"How'd you get into that nasty stuff? [BUG]";
			1:
				move activeplayer to EndOfAlley;
				self.variant = 1;
			2:
				move activeplayer to EndOfAlley;
				move lockpick to activeplayer;
				self.variant = 2;
		}
	],
	end_scene [ rock subrock;
		subrock = 0;
		switch (rock) {
			-1, -2:
				"How'd you get through that nasty stuff? [BUG]";
			-3: ! security door open
				"The door opens, only it's ajar. Ha! [BUG]";
			1:
				SetQuestion(q1_1);
			2:
				move lockpick_model to Himself;
				SetQuestion(q1_3);
			3:
				lockpick.work_target = nothing;
				move lockpick to activeplayer; ! after successful use
				SetScene(sc_2);
		}
	],
	door_attempts 0;
	
Object q1_1
  class Question,
  with
	query "^~Don't be absurd,~ he says. ~You're no
		more a sightseer than the Old Tree in Capitol Square; and if you'd
		had enough sense to walk away from that door, you wouldn't be
		here. You don't and you didn't and are; we caught you. And
		you're going to start by telling me how you got through that
		door. Do you understand me?~",
	time_limit 5,
	answer_yes [; 
		num_helpfuls++;
		print "The man nods briefly -- a man satisfied with the least important
			detail.
			He touches a control. Once again, a faint whine begins to drill through
			your temples.^";
		BeginScene(1);
	],
	answer_no [;
		num_blatant_lies++;
		print "The man blinks, and gazes at you. ~That's a lie. You're not stupid.
			Understand me --";
		SetQuestion(q1_2);
	],
	answer_wait [;
		num_stupids++;
		print "The man flattens his hands on the desk, stares at you. ~Listen to 
			me --";
		SetQuestion(q1_2);
	];

Object q1_2
  class Question,
  with
	query " this machine can be set to a deeper probe. I don't
		want to do that, because I would get only a partial set of images
		before you lapsed into autism. This approach is more productive.
		...Isn't it?~",
	time_limit 6,
	daemon [;
		if (self.number == 3) {
			print "^~Are you listening?~^";
		}
	],
	answer_yes [;
		print "The man nods, apparently satisfied, and
			touches a control. Once again, a faint whine begins to drill through
			your temples.^";
		BeginScene(1);
	],
	answer_no [;
		print "The man's lips tighten. ~I believe you. I won't waste
			any more of your time, then.~ He touches a sequence of controls.^";
		BrainDrain();
	],
	answer_wait [;
		print "The man shakes his head. ~Let's try again.~^^
			He touches a control. Once again, a faint whine begins to drill through
			your temples.^";
		BeginScene(1);
	];

Object q1_3
  class Question,
  with
	query "^~This is tedious,~ the man says. ~Of course you didn't walk up
		and stand there rattling the door like a nightclump. Nor did you blow through
		the keyhole.~ Clenched knuckles rap on the desk, tension at odds with
		his patient tone.
		~Nor, I add, did you break into this place barehanded and bare
		naked. You had something which opened that door, and you used it. Was it this?~^^
		His fist opens abruptly. Something rod-shaped gleams silver in his palm.",
	time_limit 5,
	daemon [;
		if (self.number == 2) {
			print "^~Some sort of electronic key? An inductive code-scanner?~ He
				holds the silver rod out towards you.^";
		}
	],
	answer_yes [;
		num_helpfuls++;
		print "~I thought it might be.~ He turns the rod over in his fingers, 
			once. ~Small. But clearly functional. ...Show me.~^";
		BeginScene(2);
	],
	answer_no [;
		print "~No? But this ", (emphstring) "is", " yours. A guard found it inside,
			just before we caught you, and it's nothing of ours. So don't pretend
			you didn't carry it in.~^";
		BeginScene(2);
	],
	answer_wait [;
		print "~This ", (emphstring) "is", " yours. A guard found it inside,
			just before we caught you, and it's nothing of ours. So don't pretend
			you didn't carry it in. Now let's try again.~^";
		BeginScene(2);
	];

! ------------- The recall scene

Constant CantGoBrickWall "Not through a brick wall, you don't.";

Object EndOfAlley "End of Alley"
  with
	description [;
		print "It's a narrow dead end here, with walls rising oppressively
			high in three directions. The alley is quite empty, bare even of trash.";
		if (sc_1.variant == 0)
			print " (Your guidebook warned you: the";
		else
			print " (You're sure the";
		" police are as efficient about litter laws as about everything else
			they do.) You can retreat to the south.";
	],
	s_to MouthOfAlley,
	out_to MouthOfAlley,
	e_to outerdoor,
	in_to outerdoor,
	n_to "The alley ends here.",
	cant_go CantGoBrickWall,
	u_to CantGoThatWay,
	d_to CantGoThatWay;

! Matched with outerdoorin, in t-2.
Object -> outerdoor "steel door"
  with
	name 'plain' 'steel' 'metal' 'door',
	describe [;
		print "^A plain metal door faces you to the east, near the alley's end";
		if (outerdoorplate hasnt general)
			print ". It's firmly shut";
		".";
	],
	description "It's a naked sheet of metal, a foot taller than you, as wide
		as your outstretched arms. No handle, no keyhole, no label, no sign. No obvious way
		to open it at all, unless the black plate embedded beside it will serve.",
	door_dir e_to,
	door_to EndOfAlley,
	door_try [;
		print "The door is very definitely closed.^";
		return AttemptDoor();
	],
	before [;
		Open: 
			if (lockpick.work_target == outerdoorplate)
				print "Be patient.^";
			else
				print "You can't see how.^";
			return AttemptDoor();
		Close: 
			"It already is closed.";
		Attack, KnockOn: 
			print "You scrape your knuckles without result. There isn't
				even any sound; it's like knocking on the side of a mountain.^";
			return AttemptDoor();
		Push, Turn: 
			print "The steel is immobile.^";
			return AttemptDoor();
		Pull: 
			print "The door is flush with the wall, and there's no space around the 
				edges to work your fingers into.^";
			return AttemptDoor();
		Listen: 
			print "You can hear nothing at all.^";
			return AttemptDoor();
		Touch, Rub: 
			print "The steel is smooth and cool.^";
			return AttemptDoor();
		LookUnder: 
			print "There's no space under the door.^";
			return AttemptDoor();
	],
  has static door ~open;

Object -> outerdoorplate "black plate by the door"
  with
	name 'small' 'black' 'rectangle' 'plate',
	description [;
		print "A featureless, dull black rectangle is embedded in the bricks
			beside the door. It's about the width of your palm. No fool could doubt
			the plate has something to do with opening the door, but it doesn't bear 
			a clue about how to do it.^";
		if (lockpick.work_target == self) {
			print "^The lockpick is clinging to the plate.^";
		}
		return AttemptDoor();
	],
	before [;
		Push, Pull, Turn, Rub, Touch: 
			print "Nothing happens.^";
			return AttemptDoor();
		KnockOn, Attack: 
			print "There is no response.^";
			return AttemptDoor();
		Take: 
			print "The plate is fixed in the wall.^";
			return AttemptDoor();
	],
	daemon [;
		! started when the lockpick opens it.
		if (player == passiveplayer)
			print "^The plate begs for mercy. [BUG]^";
		if (self in location) {
			StopDaemon(self);
			if (self hasnt general)
				print "^The door slides neatly open.^";
			else
				print "^The door is standing open.^";
			EndScene(3);
		}
		else {
			! missed actual opening
			give self general;
		}
	],
  has scenery;	! general means it's open, and you missed seeing it open.

Object MouthOfAlley "Mouth of Alley"
  with
	description "You're in the entrance of a narrow brick alley, which runs
		further in to the north. To the south a broad street courses by, congested
		with traffic and bicycles, although none of them seem to notice you.",
	n_to EndOfAlley,
	in_to EndOfAlley,
	s_to alleystreet,
	out_to alleystreet,
	cant_go CantGoBrickWall,
	u_to CantGoThatWay,
	d_to CantGoThatWay;

Object -> alleystreet "street"
  with
	name 'broad' 'street',
	description "This is a dull section of the city, run a bit down, which is why you're
		nosing around in alleys. You can see tenement steps on the far side of the street.
		A few children in school uniforms lean there, but you can't see much through the
		cars that crowd by.",
	door_dir s_to,
	door_to MouthOfAlley,
	door_try [;
		if (sc_1.variant > 0) {
			print "You can't leave. You have a job to do.^";
			return AttemptDoor();
		}
		print "You leave door and alley behind, and set off to see what else
			this fine city might hold.^";
		EndScene(1);
		rtrue;
	],
  has door scenery;

Object -> alleytraffic "traffic"
  with
	name 'traffic' 'car' 'cars' 'bicycle' 'bicycles' 'pedestrian' 'pedestrians',
	description "Traffic pours down the street -- bicycles, the boxy cars of local make,
		the occasional pedestrian taking his chances.",
	life [;
		"Nobody pays any attention.";
	],
  has scenery animate neuter;
	
Object -> alleychildren "children"
  with
	name 'children' 'kids' 'tenement' 'steps',
	before [;
		"The children are on the far side of the street.";
	],
	orders [;
		self.before();
		rtrue;
	],
  has scenery pluralname animate;
	
Object alleywalls "brick walls"
  with
	name 'brick' 'bricks' 'wall' 'walls',
	found_in EndOfAlley MouthOfAlley,
	description "The walls are brownish brick, not recently washed. They stretch
		at least two stories above you.",
	before [;
		Climb: "The bricks are narrowly mortared. There's not a bit of hold
			to grasp.";
		Search: 
			if (location == EndOfAlley) 
				"It's just bricks. They stop for the door, and the small plate
					next to it, but everywhere else they're implacably solid.";
			else
				"It's just bricks.";
		Attack, KnockOn: "The brick walls are impervious.";
		Listen: "You can hear nothing at all.";
		Touch, Rub: "The bricks are rough, and not very clean.";
		Enter: print_ret (string) CantGoBrickWall;
	],
  has scenery pluralname;

[ AttemptDoor;
	if (sc_1.variant ~= 1)
		rtrue;
	sc_1.door_attempts++;
	if (sc_1.door_attempts == 4)
		EndScene(2);
	rtrue;
];

