/* FIRST THINGS FIRST - Locations - new_future.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001, 2002 and 2006 
 	by J. Robinson Wheeler. All Rights Reserved. */

/*
 *					********				 *********
 *					********	THE GAME CODE	 *********
 *					********				 *********
 */

/**************************************************************************
 *					The rooms of the NEW FUTURE.			  *
 **************************************************************************/

NFclearing: rodroom
	sdesc = "Pretty garden"
	ldesc = "Light pours prettily onto the grounds of a small garden, bursting with 
			flowers wild and rare. A fountain pool graced by a whitewashed bench 
			adds to the charm of this little area. "
	xdesc = "A footpath leads northeast to a fresh green lawn, and beyond that, 
			a white building. "
	listenDesc = 'You hear the peaceful burbling of the fountain pool. '
	smellDesc = { wildFlowers.smellDesc; }
	ne = lawn
	rodPoint = "fountain pool"
	firstseen =
	{
		if ( global.scoreCard[24] != 1 )
		{
			incscore( 5 );
			global.scoreCard[24] := 1;
		}
	}
;

NFdummyClearingItem: locationDesc
	sdesc = "Pretty garden"
	adjective = 'NFclearing'
	location = NFclearing
;

dummyWhiteBuilding: distantItem
	sdesc = "white building"
	ldesc = "The white building stands where your house used to be. In fact, it
			still resembles your house. "
	noun = 'building'
	adjective = 'white' 'house'
	location = NFclearing
;

NFfootpath: fixedBlock, floatingItem
	sdesc = "footpath"
	ldesc = { NFclearing.xdesc; }
	noun = 'path'
	adjective = 'foot' 'footpath'
	location = 
	{
		if ( Me.location = NFclearing || Me.location = lawn || 
			Me.location = NFsouthOfHouse )
			return( Me.location );
		else return( nil );
	}
;

whitewashedBench: fixedBlock, chairitem
	sdesc = "whitewashed bench"
	ldesc = "The bench is made of whitewashed concrete. "
	noun = 'bench'
	adjective = 'white' 'washed' 'whitewashed'
	location = NFclearing
;

fountainPool: waterItem
	sdesc = "fountain pool"
	ldesc = "The fountain pool is full of clear water, spraying and tumbling gently
			from a sculpture of tiered, natural rocks placed at gentle angles.
			Water splatters into a round pool with a mosaic tiled bottom. Shiny
			pennies and other small coins wobble beneath the rippled surface. "
	noun = 'pool'
	adjective = 'fountain' 'sculpture' 'tier' 'tiers' 'tiered' 'natural' 'rocks' 
			'gentle' 'angle' 'angles' 'round' 'pool' 'mosaic' 'tiled' 'tile'
			'tiles' 'bottom' 'ripple' 'ripples' 'rippled' 'surface' 'peaceful'
			'burbling' 'burble'
	location = NFclearing
	listenDesc = 'You hear the peaceful burbling of the fountain pool. '
;

shinyCoins: unimportantItem
	sdesc = "shiny coins"
	ldesc = "Shiny pennies and other small coins wobble beneath the pool's rippled
			surface. "
	noun = 'coin'
	plural = 'coins'
	isThem = true
	adjective = 'shiny' 'penny' 'pennies' 'small'
	location = NFclearing
;

smallGarden: fixedBlock
	sdesc = "small garden"
	ldesc = "The garden bursts with flowers wild and rare. "
	noun = 'garden'
	adjective = 'small' 'pretty'
	location = NFclearing
	
	doSmell -> wildFlowers
;

wildFlowers: fixedBlock
	sdesc = "flowers"
	ldesc = "Not being much of a botanist, you are unable to recognize these flowers,
			which burst with radiant colors. There are petals of sunny yellow, 
			pure cloud white, blushing red, and saturated vermillion, azure, 
			violet, and velvet black. "
	smellDesc = "The flowers smell like a mix of potent herb and wild honey, spring
			dew, and lush, creamy perfume. "
	noun = 'flower'
	plural = 'flowers'
	isThem = true
	adjective = 'wild' 'rare' 'petal' 'petals' 'sunny' 'yellow' 'pure' 'cloud' 'white'
			'blushing' 'red' 'saturated' 'vermillion' 'azure' 'violet' 'velvet'
			'black' 'potent' 'herb' 'wild' 'honey' 'spring' 'dew' 'lush' 'creamy'
			'perfume'
	location = NFclearing
	
	verDoTake( actor ) = 
	{
		"There is no need to pick any of the flowers. ";
	}
;

dummyLawn: fixedBlock
	sdesc = "lawn"
	ldesc = 
	{
		"You walk over to the lawn. \n";
		Me.travelTo( lawn );
	}
	noun = 'lawn'
	adjective = 'fresh' 'green'
	location = NFclearing
;

lawn: room
	sdesc = "Lawn"
	ldesc = "A manicured lawn, watered frequently by a built-in sprinkler system,
			surrounds the building, which seems to be your house, only a story 
			taller. A large rock sits in a circle of gravel adjacent to the 
			footpath, and a plaque has been affixed to it near the bottom. "
	xdesc = "A footpath leads northeast to the south side of the white building, and a 
			pretty garden is to the southwest. "
	listenDesc = 'You hear the peaceful burbling of the fountain pool in the garden. '
	ne = NFsouthOfHouse
	sw = NFclearing
;

NFrock: chairitem
	sdesc = "large rock"
	ldesc = "The rock is a five foot grey boulder, almost egg-shaped, 
		a single piece of heavy, textured granite. Polished smooth over
		time, a wedge shape sheared from the top ages ago provides a
		comfortable place to sit. \b
		
		The rock is now surrounded by a smooth circle of gravel.
		A brass plaque has been affixed to the rock near the bottom. "
	noun = 'rock' 'boulder' 'stone'
	adjective = 'large' 'wedge' 'shape' 'chipped' 'chip' 'top' 'granite'
				'heavy' 'textured'
	location = lawn
	ne = { self.getOff; return( self.location.ne ); }
	sw = { self.getOff; return( self.location.sw ); }
	noexit = { self.getOff; return( self.location.noexit ); }
	isdroploc = true
	statusPrep = "on"
	outOfPrep = "off of"
	
	getOff = 
	{
		if ( Me.location = self )
		{
			"You get off the rock.\n ";
			Me.moveInto( self.location );
		}
	}
	verDoStandon( actor ) = { self.verDoSiton( actor ); }
	doStandon( actor ) =
	{
		"You stand up on top of the rock. The view isn't much better, but
		it is very serene and peaceful. ";
		actor.moveInto( self );
	}
	verDoSiton( actor ) = 
	{
		if ( actor.location = self )
			"You are already on the rock. ";
	}
	doSiton( actor ) =
	{
		"You sit down on top of the rock. It is very serene and peaceful. ";
		Me.moveInto( self );
	}
	
	verDoTake( actor ) =
	{
		"The rock is made of solid granite and conservatively weighs
		one and a half tons. You are unable to move it. ";
	}
	verDoMove( actor ) = { self.verDoTake( actor ); }
	verDoPush( actor ) = { self.verDoTake( actor ); }
	verDoPull( actor ) = { self.verDoTake( actor ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes it's nice to have a big ol' rock to
				sit on when you need to think.\" ";
				return( true );
			case Laura:
				"Laura says, \"That sounds like a great spot to sit and 
				meditate.\" ";
				return( true );
			case Architect:
				"He says, \"Ah yes, that old rock just down in the woods. I made
				a special point of preserving it. It would have been such a 
				shame to blast it. I've made something of a habit of taking 
				walks down there to clear my head and think.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

dummyFountainPool: fixedBlock
	sdesc = "fountain pool"
	ldesc =
	{
		"You walk back to the pretty garden. \n";
		Me.travelTo( NFclearing );
	}
	noun = 'pool'
	adjective = 'fountain'
	location = lawn
;

dummyPrettyGarden: fixedBlock
	sdesc = "pretty garden"
	ldesc =
	{
		"You walk back to the pretty garden. \n";
		Me.travelTo( NFclearing );
	}
	noun = 'garden'
	adjective = 'pretty'
	location = lawn
;

dummyWhiteHouse2: fixedBlock
	sdesc = "white building"
	ldesc = "The building seems to be your house, only a story taller than
			before, and painted a vibrant white that reflects the golden
			sunlight in a picture perfect manner. "
	noun = 'building'
	adjective = 'white' 'house' 'vibrant' 'white' 'story' 'storey'
	location = lawn
;

manicuredLawn: unimportantItem
	sdesc = "lawn"
	ldesc = "The lawn has been carefully tended and manicured. "
	noun = 'lawn'
	adjective = 'tended' 'manicure' 'manicured' 'green'
	location = lawn
;

sprinklerSystem: unimportantItem
	sdesc = "sprinkler system"
	noun = 'system'
	adjective = 'sprinkler'
	location = lawn
;

circleOfGravel: unimportantItem
	sdesc = "circle of gravel"
	ldesc = "The gravel has been carefully raked into coencentric circles that
			seem to radiate out from the base of the rock, as if it were a 
			pebble thrown into a gentle pond. "
	noun = 'gravel'
	adjective = 'circle' 'circle of'
	location = lawn
;

plaque: staticItem, readable
	sdesc = "brass plaque"
	ldesc = "The brass plaque reads: \b
			\tDreams of mountains \n
			\tAs in their sleep \n
			\tThey dwell on things Eternal "
	noun = 'plaque'
	adjective = 'brass' 'bottom'
	location = lawn
;

NFsouthOfHouse: room
	sdesc = "South of <<NFfrontOfHouse.isseen ? "museum" : "house">>"
	ldesc = "The ground slopes here slightly, with cobblestones leading southwest 
			to the path through the lawn. A little window sits high above in the 
			wall, which has been painted a demure white. A couple of flagstones 
			and some tiny hedges make the landscaping complete. A fence prevents 
			passage northwest to the rear entrance. "
	xdesc = 
	{
		"The path leads northeast to the front of the building, and the lawn 
		lies to the southwest. ";
		
		if ( NFsecretDoor.location && NFsecretDoor.isopen )
			"A secret door is open to the north. ";
	}
	ne = NFfrontOfHouse
	nw = fence
	sw = lawn
	north = 
	{
		if ( NFsecretDoor.location )
			return( NFsecretDoor );
		else
			return( self.noexit );
	}
	in = 
	{
		if ( NFsecretDoor.location )
			return( NFsecretDoor );
		else
			return( self.noexit );
	}
;

fence: fixedBlock, obstacle
	sdesc = "fence"
	ldesc = "The fence is designed to keep people from walking behind the house from
			here. "
	noun = 'fence' 'back' 'yard' 'backyard'
	destination = 
	{
		"You should respect the rules and not cross the fence. ";
//		"Perhaps there's another way to access the back yard. ";
		return( nil );
	}
	location = NFsouthOfHouse
	
	verDoLeap( actor ) = {}
	doLeap( actor ) = { self.destination; }
	verDoCross( actor ) = {}
	doCross( actor ) = { self.destination; }
;

NFsouthOfHouseWindow: distantItem
	sdesc = "tiny window"
	ldesc = "The tiny window is no longer near the roof, which is an extra story
			higher than it used to be. You notice that it has also been replaced
			by stained glass. "
	noun = 'window'
	adjective = 'tiny' 'story' 'storey'
	location = NFsouthOfHouse
;

stainedGlass: distantItem
	sdesc = "stained glass"
	ldesc = "The stained glass sports no specific design, but is merely a pretty
			collage of colored shapes. "
	noun = 'glass'
	adjective = 'stained' 'pretty' 'collage' 'colored' 'color' 'colors' 'shape' 'shapes'
			'colour' 'coloured' 'colours' 
	location = NFsouthOfHouse
;

flagstones: unimportantItem
	sdesc = "flagstones"
	ldesc = "A couple of flagstones and some tiny hedges make the landscaping complete. "
	noun = 'flagstone'
	plural = 'flagstones'
	isThem = true
	adjective = 'couple'
	location = NFsouthOfHouse
;

tinyHedges: unimportantItem
	sdesc = "tiny hedges"
	ldesc = "A couple of flagstones and some tiny hedges make the landscaping complete. "
	noun = 'hedge'
	plural = 'hedges'
	isThem = true
	adjective = 'tiny'
	location = NFsouthOfHouse
;

NFwall: secretDoorWall
	ldesc = "The south wall of the house has been painted a demure white. "
	adjective = 'demure' 'white'
	myDoor = NFsecretDoor
	mySwitch = NFsecretSwitch
	location = NFsouthOfHouse
;

NFsecretDoor: secretDoorItem
	mySwitch = NFsecretSwitch
	myWall = NFwall
	otherside = NFinteriorSecretPassageDoor
	doordest = NFsecretPassage
;

NFsecretSwitch: secretSwitchItem
	myWall = NFwall
	myDoor = NFsecretDoor
;

NFfrontOfHouse: room
	sdesc = "Front of museum"
	ldesc = "You are in the front of your house, but you can see from here that it
			is no longer a simple residence. A signpost hanging above the stoop
			says that it is a laboratory museum. "
	xdesc = "A footpath leads southwest. The driveway is to the northeast. The front
			door, as always, is to the west. "
	sw = NFsouthOfHouse
	ne = NFdriveway
	west = NFfrontDoor
	in = NFfrontDoor
;

signpost: fixedBlock, readable
	sdesc = "signpost"
	ldesc = "The signpost hanging above the stoop reads: \b
			\tTime travel laboratory & museum \t
			\t\"Where yesterday, today, and \n
			\t\ttomorrow meet.\" \n
			\tHours:\tM-Th 1pm - 6pm
			\t\t\t\ F-Sat 10am - 6pm
			\t\t\t\ Closed Sundays \b
			There doesn't seem to be anyone else here. Perhaps today is Sunday. "
	noun = 'signpost'
	adjective = 'sign' 'post' 'stoop'
;

NFhouse: fixeditem, floatingItem
	sdesc = "house"
	ldesc = "Your house - or rather, the museum - is a pleasant three-story 
			structure, painted a pleasant white. " 
	noun = 'house'
	adjective = 'white' 'museum' 'three-story' 'three' 'story' 'storey' 'three-storey'
	location = 
	{
		switch( Me.location )
		{
			case NFfrontOfHouse:
			case NFnorthOfHouse:
//			case NFbehindHouse:
			case NFdriveway:
				return( Me.location );
			default: return( nil );
		}
	}
	
	verDoBuy( actor ) = { "You already own it. At least, you think you will. "; }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
		 case Fred:
		 	"Fred says, \"Locked out, eh? Don't you have a spare key?\" ";
		 	Fred.askedAboutKey := true;
			return( true );
		 case Laura:
		 	"Laura says, \"You should always keep a spare key outside in
		 	case of emergencies.\" ";
		 	Laura.askedAboutKey := true;
			return( true );
		 case Architect:
		 	"He says, \"It'll be a fine house, all righty.\" ";
			return( true );
		default: 
			return( nil );
		}
	}
;

NFfrontDoor: lockableDoorway
	isfixed = nil
	islocked = nil
	sdesc = "front door"
	ldesc = "It's solid wood, a real beauty, with the best lock money can buy. It's
			the same door that's always been here, a friendly sight indeed. "
	adesc = "the front door"
	noun = 'door'
	plural = 'hinges'
	adjective = 'solid' 'wood' 'front' 'locked' 'hinge'
	location = NFfrontOfHouse
	mykey = frontDoorKey
	doordest = NFlobby
	otherside = NFlobbyFrontDoor
	
	doKnock( actor ) =
	{
		if ( not NFlobby.isseen || youngMan.actorDaemon = 0 )
		{
			"You knock loudly on the door. You hear a voice inside say, \"I think our
			guest of honor has arrived, right on schedule.\" More loudly, you hear the
			voice call out, \"Coming!\" ";
			notify( youngMan, &actorDaemon, 0 );
		}
		else pass doKnock;
	}
	
	verDoOpen( actor ) =
	{
		if ( self.isopen )
			"It's already open. ";
	}
	doOpen( actor ) =
	{
		if ( self.islocked )
			"It's locked. ";
		else pass doOpen;
	}
	
	doUnlockWith( actor, io ) =
	{
		if ( io = self.mykey || io = duplicateKey )
		{
			"Unlocked. ";
			self.setIslocked( nil );
		}
		else if ( io = carKey ) 
			"This key opens your car, not the front door. ";
		else
			"It doesn't fit the lock. ";
	}
	verDoTake( actor ) = { "You can't take the front door. "; }

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Have you tried prying it open or busting in? I guess
				you wouldn't want to do that, though.\" ";
				Fred.askedAboutKey := true;
				return( true );
			case Laura:
				"Laura says, \"I'm not sure what to tell you. Don't you have a back
				door or a side door or something?\" She twiddles her hair as she
				thinks. ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He says, \"Oh, I'm going to give you a fine front door. Solid and
				strong!\" ";
				return( true );
			case squirrel:
				"The squirrel doesn't know what you're talking about. Or if he does,
				he isn't interested. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

NFdoorLock: fixedBlock
	sdesc = "lock"
	ldesc = "It's a standard door lock of good quality. Without the key,
			you won't be able to open this door. "
	noun = 'lock' 'bolt' 'deadbolt'
	location = NFfrontOfHouse
	doOpen -> NFfrontDoor
	doUnlockWith -> NFfrontDoor

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Locked out of your own house, eh? You might ask
				a locksmith about that, I guess.\" He drums his fingers on the
				countertop. \"Yeah, I dunno,\" he says. ";
				Fred.askedAboutKey := true;
				return( true );
			case Laura:
				"Laura says, \"I bet there's somewhere you could go to get a 
				spare key. A locksmith, maybe?\" ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He says, \"I'm planning on a good quality deadbolt lock. You
				don't want anyone getting in, after all.\" ";
				return( true );
			case squirrel:
				"The squirrel runs in a tiny circle and wags his tail, but that's
				pretty much what he would have done anyway. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

NFdoormat: staticItem, surface, readable, underHider
	isListed = true
	bulk = 2
	sdesc = "familiar doormat"
	ldesc = 
	{
		"It's a bulky rectangular mat made out of thatched brown fibers. ";
		self.readdesc;
	}
	readdesc = 
	{
		"It reads, \"Welcome, traveller.\" ";
	}
	noun = 'doormat' 'mat'
	plural = 'fibers'
	adjective = 'welcome' 'bulky' 'rectangular' 'thatched' 'thatch' 'brown' 
		'fiber' 'familiar'
	location = NFfrontOfHouse
	autoTake = true
	
	verIoPutUnder( actor ) = {}
	ioPutUnder( actor, dobj ) =
	{
		if ( dobj = carKey || dobj = duplicateCarKey || dobj = duplicateKey || 
			dobj = frontDoorKey )
		{	
			"This isn't the doormat that you need to put a spare key under. ";
		}
		else
		{
			"There is no reason to put that under the doormat. ";
		}
	}
	
	verDoLift( actor ) = { self.verDoLookunder( actor ); }
	doLift( actor ) = { self.doLookunder( actor ); }
	
	verDoMove( actor ) = { self.verDoLookunder( actor ); }
	doMove( actor ) = { self.doLookunder( actor ); }
	
	verDoTake( actor ) = 
	{
		"You really ought to leave the doormat where it is. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It's always good to put out the welcome mat.\" ";
				return( true );
			case Laura:
				"Laura says, \"I like a welcome mat.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

smallNote: readable, hiddenItem
	sdesc = "small note"
	ldesc = "It is addressed to you. It reads, \"We've been expecting you. Please
			knock to let us know you've arrived. We have something you've been
			missing.\" "
	noun = 'note'
	adjective = 'small'
	underLoc = NFdoormat
;

NFdrivewayDummy: fixedBlock, readable, floatingItem
	sdesc = "driveway"
	ldesc =
	{
		if ( wetDriveway.writtenOn )
			"\^<<wetDriveway.writtenOnDesc>> is written into <<self.thedesc>>	cement. ";
		else if ( wetDriveway.drawnOn )
			"\^<<wetDriveway.drawnOnDesc>> is drawn into <<self.thedesc>> cement. ";
		else pass ldesc;
	}
	noun = 'driveway' 'cement' 'concrete' 'paving' 'paved'
	location = 
	{
		switch( Me.location )
		{
			case NFdriveway:
			case NFfrontOfHouse:
			case NFnorthOfHouse:
				return( Me.location );
			default:
				return( nil );
		}
	}
;

NFdriveway: room
	sdesc = "Driveway"
	ldesc = "This is your old driveway, which leads west to the north side of the
			museum. "
	xdesc = "The front door of the museum is to the southwest. To the east is 
			the road into town. "
	sw = NFfrontOfHouse
	east = "You don't need to go that way. "
	west = NFnorthOfHouse
;

NFnorthOfHouse: room
	sdesc = "North of museum"
	ldesc = "The north end of your house has been considerably extended. What used
			to be your garage now serves as an extension to a separate north
			wing, giving the entire structure a sort of L shape. "
	xdesc = "Another fence prevents passage around the north wing. The only exit
			is back east into the driveway. "
	east = NFdriveway
;

NFhouseWindows: houseWindow, floatingItem
	thrudesc = "Inside the windows you see a strange mix of familiar and 
			unfamiliar furnishings. The unfamiliar furnishings are of a 
			much higher quality than the ones you recognize as your own. "
	verDoEnter( actor ) = { "The windows are closed and locked from the inside, 
		and probably have an alarm system in place. "; }
	location =
	{
		switch( Me.location )
		{
			case NFsouthOfHouse:
			case NFfrontOfHouse:
			case NFnorthOfHouse:
				return( Me.location );
			default: return( nil );
		}
	}
;

youngMan: NPC
	sdesc = "young man"
	adesc = "the young man"
	ldesc = "He is about eighteen years old, with a head of dark hair that has 
			been tamed into submission with a thick application of fragrant 
			gel. He has intelligent brown eyes and a bright smile. He's wearing
			a pair of shorts and some sort of souvenir t-shirt. "
	noun = 'man'
	adjective = 'young'
	location = NFlobby
	
	disavowedOnce = nil
	disavow( it ) = 
	{
		if ( !self.disavowedOnce )
			"The young man says, \"Sorry, I've been instructed not to answer
			any questions, even if they seem innocuous.\" He smiles and says,
			\"Besides, we don't have much time.\" ";
		else
			"The young man smiles, puts a finger to his lips, and shakes his head. ";
	}
	
	responseToThanks = 
	{
		"\^<<self.thedesc>> says, \"You're welcome!\" ";
	}
	yesOrNoAnswer( verb ) = 
	{
		if ( self.askedAboutTour )
		{
			switch( verb )
			{
				case yesVerb:
					"The young man says, \"Great. Follow me.\" ";
					break;
				case noVerb:
					"The young man laughs again and says, \"Oh come on. You 
					might like it. You're the one who -- oops. Never mind.\" He
					fidgets with his hands in his pockets. \"Anyway, follow me.
					I'll show you the place.\" ";
					break;
				case maybeVerb:
					"The young man gives you a friendly punch in the arm. \"You
					need to be more decisive,\" he says. \"Come on, it'll be 
					fun. Follow me.\" ";
					break;
			}
			
			self.askedAboutTour := nil;
			self.justAskedYesOrNoQuestion := nil;
			self.daemonCount := 19;
		}
		else if ( self.askedIfPlayerIsReady )
		{
			switch( verb )
			{
				case yesVerb:
					"The young man says, \"Okay, brace yourself.\" ";
					break;
				case noVerb:
					"The young man says, \"Are you sure you don't want to
					see them? Okay, suit yourself.\" He starts walking away,
					back to the lobby. Laughing, he turns and says, \"I've
					never been a very good kidder. Come on. And brace 
					yourself.\" ";
					break;
				case maybeVerb:
					"The young man says, \"Hey, relax. They're old friends.\" ";
					break;
			}
			
			self.askedIfPlayerIsReady := nil;
			self.justAskedYesOrNoQuestion := nil;
		}
		else
		{
			"The young man laughs. \"I bet it's a bit different than you
			remember. But after today, you're probably used to that,\" he
			says. ";
		}
	}
	
	ioGiveTo( actor, dobj ) = 
	{
		if ( dobj = frontDoorKey )
		{
			if ( duplicateKey.location )
			{
				"You hand the original front door key to the young man, who 
				smiles and puts it back in his pocket. \"It's been great 
				having you visit,\" he says. Spontaneously, he gives you 
				another hug. \"I'll see you soon, I think. Sooner than 
				you'll see me again.\" \b
				
				He stares at his feet for a moment. \"Okay, well, no use
				getting sentimental. I'm gonna go now. You probably should
				too. ";
				
				if ( timeMachine.location = NFclearing )
				{
					"I guess you can find your way back to the garden by
					yourself.\" He checks his watch again. \"Yeah, you
					really need to go. Bye!\" \b
					
					With that, he dashes off. He's right. It's time for
					you to go home, finally. You head back to the time
					machine. ";
					
					Me.travelTo( NFclearing );
				}
				else if ( timeMachine2.location = laboratory )
				{
					"I guess you can find your way back to the lab by
					yourself.\" He checks his watch again. \"Yeah, you
					really need to go. Bye!\" \b
					
					With that, he dashes off. He's right. It's time for
					you to go home, finally. You head back to the lab. ";
					
					Me.travelTo( laboratory );
				}
				else
				{
					"[ BUG! Hey, no time machine is here! ] ";
				}
				
				frontDoorKey.moveInto( nil );
				self.moveInto( nil );
			}
		}
		else if ( dobj = duplicateKey || dobj = carKey || dobj = duplicateCarKey )
		{
			if ( not self.gaveMeWrongKeyOnce )
				"You hand him <<dobj.thedesc>>. \"Great, thanks,\" he says,
				and then takes a close look at it. \"Aww, you joker! This 
				isn't the key and you know it.\" He hands it back to you. ";
			else 
				"He takes one look at it and says, \"Oh no, you're not fooling
				me with that gag again!\" ";
		}
		else if ( dobj = blueCrystal )
			"He says, \"Oh, gosh no. You need to hold onto that. Really.\" ";
		else
			"The young man doesn't want that. ";
	}
	
	daemonCount = 0
	actorDaemon =
	{
		self.daemonCount++;
		switch( self.daemonCount )
		{
			case 1:
				if ( Me.location = NFfrontOfHouse )
				{
					"\bA young man opens the door wide. His smile is even wider as he
					says, \"It's you! Look at you!\"\ and, laughing, embraces you with
					his strong young arms. \b
					
					\"Sorry, I guess you weren't expecting that,\" he says. \"Come in,
					come in.\" He steps back inside the house, waving you to follow. ";
					
					NFfrontDoor.setIsopen( true );
					NFfrontDoor.setIslocked( nil );
				}
				else if ( Me.location = NFmasterBedroom )
				{
					"\bA young man approaches from the north, smiling broadly. His 
					smile gets even wider as he says, \"It's you! Look at you!\"\ 
					and, laughing, embraces you with his strong young arms. \b
					
					\"Sorry, I guess you weren't expecting that,\" he says. \"Come in,
					come in.\" He steps back to the north, waving you to follow. ";
				}
				break;
			case 2:
				if ( Me.location != self.location )
				{
					self.daemonCount--;
					return;
				}
				"The young man says, \"So, what do you think? Pretty nice, huh?\" ";
				self.justAskedYesOrNoQuestion := true;
				break;
			case 3:
				"The young man rocks back and forth on his feet. \"Hey, I know.
				Would you like me to show you around?\"\ he asks. \"Should I give
				you the grand tour?\" ";
				
				self.askedAboutTour := true;
				break;
			case 4:
				self.yesOrNoAnswer( maybeVerb );
				break;
			case 20:
				"He starts by leading you upstairs. ";
				
				Me.travelTo( NFupstairsHallway );
				
				"He says, \"The upstairs kind of looks the same as always, except
				we've added another floor on top.\" He gestures to the staircase.
				\"Upstairs are staff offices for the museum. Kind of boring. Well,
				let me show you anyway.\" \b
				
				He takes you past the rope and up another flight of stairs. It's
				a small hallway with doors leading off into offices. On one wall is
				an enlarged picture of you, looking a bit older, standing next to
				a time machine in the clearing. A small team of people you don't
				recognize are hugging shoulders with you. \b
				
				The young man notices your interest in the picture and says, \"Yeah,
				how about that, huh? I can't tell you when that's taken, of course,
				but it's not far off.\" He briefly takes you out onto a balcony that
				provides a grand view of the area. The shopping village has expanded,
				but you see that many new trees have been planted in the area, 
				replacing the old trees that were removed from Oakwood Drive ages
				ago. \b
				
				\"Come on, there's more to see,\" he says. \b";
				
				morePrompt();
				
				"The young man leads you back downstairs to the lobby, and then 
				north into the new wing of the house. In fact, this is the only
				part of the house that is still living quarters, he explains. \"This
				is where we live,\" he says. \"We decided to keep the old house open
				as a museum, so we had to move somewhere new, so we built this wing.
				It's only been a year or so. You can kind of still smell the fresh
				paint.\" \b";
				
				if ( global.scoreCard[20] = 1 )
				{
					"He leads you to a door at the east end of a hallway full of 
					golden afternoon light. He raps his knuckles on the door and
					says, \"We've invited some guests today who were anxious to greet
					you,\" he says, smiling enigmatically. \"You ready for this?\" ";
				}
				else
				{
					"He leads you to a door at the east end of a hallway full of 
					golden afternoon light. He raps his knuckles on the door and
					says, \"We've invited a guest today who was anxious to greet
					you,\" he says, smiling enigmatically. \"You ready for this?\" ";
				}
				Me.moveInto( NFhallwayEast );
				self.justAskedYesOrNoQuestion := true;
				self.askedIfPlayerIsReady := true;
				break;
			case 21:
				"He opens the door into a large salon of paneled wood and 
				tasteful chairs. ";
				
				if ( global.scoreCard[20] = 1 )
				{
					"Sitting in the chairs, and rising as you 
					enter, are two people you recognize and three you do not, 
					including two children. \b
					
					Laura, looking mature with her silvered hair but as vibrant
					as ever, approaches first, giving you a hug. \"Apparently
					we're somewhat beholden to each other,\" she says, with a 
					bright twinkle in her eyes. \"You put me on quite a different
					path <<newFuture.startedFromPast ? "thirty" : "forty">> years 
					ago, one of environmental activism and fighting
					corporate interests. I know you're probably curious what that
					letter said. All I can tell you is that the first part was full
					of secrets that I never told anyone, and the second part was a
					set of warnings, and the third part was a set of wishes.\" She
					idly picks a bit of lint off of your shirt. \"Good wishes, from
					a bad person.\" She gives you a small kiss and steps aside. \b
					
					Unsurprisingly, the other person is Fred, looking trimmer than
					you've ever seen him, but with the same smile, below the same 
					cheesy mustache, on his tanned face. He gives you a hearty
					handshake and introduces you to his wife, Carla, and their
					two kids, Gary and Fred Jr. \"Sandwich shop's still open,\" he
					says, looking for small talk to fill the strange awkwardness
					of the moment. \"In fact, we've got local franchises now. I'm
					running a couple of them.\" He roughs up Fred Jr.'s hair. \"Gotta
					keep these hungry mouths fed. Heh heh, what can you do?\" He
					draws his hand several times across his chin, staring at you.
					\"Man, can you believe this? Same as ever. Same as ever.\" \b
					
					There is another few minutes of idle chit-chat, but the young
					man breaks in. \"We've gotta go folks, thanks for coming, though.\"
					Fred says, \"Yeah, we gotta get going, too. Thanks for the invite.
					Nobody believes me when I tell them that this museum is for real,
					but you got my vote, I'll tell you that right now.\" \b
					
					The young man escorts everyone back to the lobby. Laura, Fred,
					and Fred's family wave and depart. \b";
				}
				else
				{
					"Sitting in one of the chairs, and rising as you 
					enter, is Laura, looking mature with her silvered hair, but
					vibrant. She approaches you tentatively and gives you a hug.\b
					
					\"You put me on quite a different
					path <<newFuture.startedFromPast ? "thirty" : "forty">> years 
					ago, one of environmental activism and fighting
					corporate interests. I know you're probably curious what that
					letter said. All I can tell you is that the first part was full
					of secrets that I never told anyone, and the second part was a
					set of warnings, and the third part was a set of wishes.\" She
					idly picks a bit of lint off of your shirt. \"Good wishes, from
					a bad person.\" She gives you a small kiss and steps aside. \b
					
					You find your thoughts turning to Fred. You wish he were here
					now, but the way he was going he's probably been dead and 
					forgotten for years. If only you had done something to help
					him.
					
					There is another few minutes of idle chit-chat, but the young
					man breaks in. \"We have to go.\" The young man escorts you
					back to the lobby. Laura waves and departs. \b";
				}

				if ( laboratory.isseen )
				{
					"\"Let's go back downstairs,\" he says. He leads you to
					the south, back through the secret passage, and down 
					into the laboratory. ";
					
					self.moveInto( laboratory );
					Me.travelTo( laboratory );
				}
				else
				{
					"\"So,\" the young man says. \"One more place to show 
					you.\" He leads you to the south. ";
					
					Me.travelTo( NFmasterBedroom );
					
					"\b\"Let's see if I can remember how to do this,\" he says. 
					He steps on a secret switch in the floor and knocks on the 
					wall. A secret door opens. \"I love that,\" he says. You 
					follow him through, into the secret passage, and down the 
					stairs at the end. ";
					
					NFmasterBedroomSecretDoor.setIsopen( true );
					self.moveInto( laboratory );
					Me.travelTo( laboratory );
				}
				break;
			case 22:
				"\"This is where it all begins,\" he says. \"Well, sort of. It's
				a long story. A retroactive effort was made -- or will be made --
				to preserve the crystal cavern that used to be here in this spot. 
				He searches a drawer of the workdesk and withdraws a small tube of
				plastic. Sealed inside the tube, preserving it, is a shimmering
				blue crystal, about an inch long, with perfect hexagonal symmetry. 
				He plops it back in the drawer. \"Can't have you running off with
				that,\" he says. \"That'd really screw things up, let me tell you.\" \b
				
				He looks at his watch. \"Speaking of which, we've got to wrap this
				up and send you home. Oh!\" He fidgets in his pocket. \"First things
				first, though.\" He withdraws a key and puts it on the workdesk. \b
				
				\"I've been instructed to tell you that you can't take this key
				back with you,\" he says apologetically, \"but I've been led to
				understand that you've come prepared to make a copy ...?\" He
				starts to head back upstairs. \"I'll be waiting in the lobby.
				Just bring the original back to me when you're done. Thanks.\"
				He takes a long, funny, grinning look at you, and hops up the
				stairs three at a time. ";
				
				laboratoryWorkdeskDrawer.moveInto( laboratory );
				self.moveInto( NFlobby );
				self.tourIsOver := true;
				unnotify( self, &actorDaemon );
				frontDoorKey.moveInto( laboratoryWorkdesk );
				break;
		}
	}
;

pairOfShorts: unimportantItem
	sdesc = "pair of shorts"
	noun = 'short'
	plural = 'shorts'
	isThem = true
	adjective = 'pair' 'pair of'
	location = youngMan
	isworn = true
;

souvenirTShirt: readable
	sdesc = "t-shirt"
	ldesc = "The t-shirt reads, \b
			\tI travelled through time \n
			\tand all I got was this \n
			\tlousy t-shirt that hasn't \n
			\teven been printed yet! "
	noun = 'shirt'
	adjective = 't' 'tee' 'tee-shirt' 't-shirt' 'souvenir'
	location = youngMan
	isworn = true
;

NFlobby: room
	indoors = true
	sdesc = "Museum lobby"
	ldesc = "The lobby of the museum is homelike and welcoming. What used
			to be a tiled floor has been replaced with polished wood, and 
			tasteful decorations hang on the walls. A visitor information desk 
			has been set up here, but no one is staffing it at the moment. "
	xdesc = "The front door is east, and hallways lead south and north. A wide 
			staircase leads up. "
	east = 
	{
		if ( youngMan.tourIsOver )
			return( NFlobbyFrontDoor );
		else return( self.noexit );
	}
	south = 
	{
		if ( youngMan.tourIsOver )
			return( NFmasterBedroom );
		else return( self.noexit );
	}
	noexit =
	{
		if ( youngMan.tourIsOver )
		{
			"You are suddenly overcome by the fatigue of a long and very sleepless
			day. Or night. Or something. You really need to finish up your last bit
			of business and go straight home to bed, rather than exploring the 
			house again. Chances are, in twenty years you'll be seeing quite a lot 
			of it anyway. ";
		}
		else
		{
			"The young man says, \"Oh, shall I give you the grand tour? Come on,
			let me show you around.\" ";
			youngMan.daemonCount := 19;
		}
		return( nil );
	}
;

NFlobbyFrontDoor: lockableDoorway
	sdesc = "front door"
	ldesc = { NFfrontDoor.ldesc; }
	noun = 'door'
	adjective = 'front'
	otherside = NFfrontDoor
	location = NFlobby
	doordest = NFfrontOfHouse
	islocked = nil
	isopen = nil
;

NFupstairsHallway: room
	sdesc = "Upstairs hallway"
	ldesc = "The staircase ends at a slightly expanded upper hallway. The doors lead
			north and south, as usual, but into tiny offices stuffed with files
			and computers. In place of the upstairs bathroom is yet a third 
			office. You almost wonder how many people are really needed to staff
			such a place as this. It's starting to seem like a surreal joke of
			some kind. "
	xdesc = "The staircase leads back down. It also leads up to the third floor,
			but a velvet rope has been strung across it as a barrier to museum
			visitors. "
;

NFhallwayEast: room
	sdesc = "East end of hall"
	ldesc = "You are standing in front of a closed door at the east end of a 
			hallway full of golden afternoon light. "
	xdesc = "The lobby is back through the house to the south. "
	
	roomAction( a, v, d, p, i ) =
	{
		if ( isclass( v, yesNoMaybeVerb ) )
			pass roomAction;
		else
			exit;
	}
;

laboratory: room
	sdesc = "Laboratory"
	ldesc = "From the look of things, time machines are built here. The room is
			thirty feet square, with a fifteen foot ceiling. Rows of
			refrigeration ducts and sealed-off tubes poke through the 
			wall on the north side. Along the east wall is a set of 
			poster-sized pictures detailing the development from the 
			first, room-sized prototype to machines that look similar to
			the ones you have been using. Drafts of engineering blueprints 
			are tacked to the remaining walls. A busy workdesk is set up 
			to one side. You see various unrecognizable machine parts 
			and prototypes in various stages of assembly, and one unused
			electrical socket. "
	xdesc = "A carpeted staircase to the south leads up."
	
	up = 
	{
		if ( youngMan.daemonCount < 20 || youngMan.tourIsOver )
			return( NFsecretPassage );
		else
		{
			"You should wait until the young man is finished. ";
			return( nil );
		}
	}
	south = 
	{
		if ( youngMan.daemonCount < 20 || youngMan.tourIsOver )
			return( NFsecretPassage );
		else
		{
			"You should wait until the young man is finished. ";
			return( nil );
		}
	}
	
	firstseen =
	{
		if ( global.scoreCard[24] != 1 )
		{
			incscore( 5 );
			global.scoreCard[24] := 1;
		}
	}
;

refrigerationDucts: fixedBlock
	sdesc = "refrigeration ducts"
	ldesc = "From what you can tell, this room housed the first prototype
		time machine, and the refrigeration ducts were used to keep the
		room cold enough for the machine to function. "
	noun = 'duct' 'row'
	plural = 'ducts' 'rows'
	isThem = true
	adjective = 'refrigeration' 'refrig' 'frige' 'fridge' 'refrigerator'
		'refrigerate' 'refrigerat'
	location = laboratory
;

sealedOffTubes: fixedBlock
	sdesc = "sealed-off tubes"
	ldesc = "From what you can tell, this room housed the first prototype
		time machine, and the sealed-off tubes were once used to furnish
		energy and coolant to the massive machine. "
	noun = 'tube'
	plural = 'tubes'
	isThem = true
	adjective = 'sealed-off' 'sealed' 'off'
	location = laboratory
;

posterSizedPictures: fixedBlock
	sdesc = "poster-sized pictures"
	ldesc = "The pictures detail the development of the first, room-sized 
			prototype time machine, as well as subsequent efforts to get
			them down to a manageable size like the ones you've been using
			tonight. Apparently, development was swift after the first 
			working model was created. "
	noun = 'picture'
	plural = 'pictures'
	isThem = true
	adjective = 'poster' 'sized' 'posters' 'poster-sized'
	location = laboratory
;

machineParts: unimportantItem
	sdesc = "unrecognizeable machine parts"
	noun = 'part'
	plural = 'parts'
	isThem = true
	adjective = 'unrecognizeable' 'unrecognizable' 'machine'
	location = laboratory
;

prototypes: fixedBlock
	sdesc = "prototypes"
	ldesc = "The prototypes are in various stages of assembly. You scan your eyes
			over them, attempting to understand the inner workings of the 
			machines, but it's still beyond your ability. "
	noun = 'prototype'
	plural = 'prototypes'
	isThem = true
	location = laboratory
;

engineeringSchematics: fixedBlock
	sdesc = "engineering schematics"
	ldesc = "The engineering schematics are beyond your current understanding,
			although some of this is beginning to make a glimmer of sense to
			you. You recognize some of the plans from the time machine manual,
			but it's going to be a long time before you can construct anything
			like them yourself. "
	noun = 'schematic'
	plural = 'schematics'
	isThem = true
	adjective = 'engineering' 'print' 'prints' 'draft' 'drafts'
	location = laboratory
	
	verDoTake( actor ) = 
	{
		"You don't need to take those with you. ";
	}
;

laboratoryWorkdesk: surface, staticItem
	sdesc = "laboratory workdesk"
	noun = 'desk'
	adjective = 'workdesk' 'lab' 'laboratory' 'busy'
	location = laboratory
;

pileOfStuffOnWorkdesk: unimportantItem
	sdesc = "pile of stuff"
	ldesc = "The pile of stuff on the workdesk is a bunch of indecipherable schematics
			and computer printouts. "
	noun = 'stuff'
	adjective = 'pile' 'pile of'
	location = laboratoryWorkdesk
;

laboratoryWorkdeskDrawer: openable, staticItem
	isfixed = true
	sdesc = "drawer"
	noun = 'drawer'
	location = nil
	isopen = nil
;

secondBlueCrystal: item
	sdesc = "preserved blue crystal"
	ldesc = "Sealed inside a tube of clear plastic, preserving it, is a shimmering 
			blue crystal, about an inch long, with perfect hexagonal symmetry. "
	noun = 'crystal'
	adjective = 'preserved' 'blue' 'tube' 'clear' 'plastic'
	location = laboratoryWorkdeskDrawer
	
	verDoTake( actor ) =
	{
		"You feel inclined to heed the young man's warning and not take the
		preserved blue crystal with you. ";
	}
;

laboratoryWallSocket: socketItem
	adjective = 'electricity' 'wiring' 'electric' 'electrical'
	hasJuice = true
	location = laboratory
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				if ( blueprint.secretpassage )
					"He says, \"When the house is finished, the secret 
					passage will be all wired up.\" ";
				else
					"He says, \"Everything should be fine with the 
					house's electricity. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

carpetedStaircase: fixedBlock
	sdesc = "carpeted staircase"
	noun = 'staircase'
	adjective = 'stairs' 'steps' 'stair' 'case' 'stairway' 'step' 'carpet' 'carpeted'
	location = laboratory
	
	verDoClimb( actor ) = {}
	doClimb( actor ) =
	{
		Me.travelTo( self.location.up );
	}
;

NFmasterBedroom: room
	sdesc = "Exhibition room"
	ldesc = "What used to be your master bedroom is now an exhibition room, full of
			colorful photographs, as well as a video 
			projection providing a family-friendly documentary about the 
			museum. "
	xdesc = 
	{
		"The lobby is back to the north. ";
		
		if ( NFmasterBedroomSecretDoor.isopen )
			"A secret door is open to the southeast. ";
	}
	north = NFlobby
	se = NFmasterBedroomSecretDoor
	
	firstseen =
	{
		if ( youngMan.daemonCount = 0 )
			notify( youngMan, &actorDaemon, 0 );
	}
;

/*	This is the key that you use to grind the duplicate key that you use to open the
 *	front door. It takes almost the whole game to find.
 */
frontDoorKey: keyItem
	sdesc = "<<duplicateKey.location ? "original front" : "front">> door key"
	ldesc = 
	{
		if ( self.seenOnce )
			self.ldesc2;
		else
		{
			"At long last!  It's the key to your front door. You thought 
			you'd never see the darned thing again. ";
			
			self.seenOnce := true;
		}
	}
	ldesc2 = "It's a key to your house, all right, but it doesn't look like the
			original one that was missing from your doormat. And yet, it's
			an old key from the looks of it. It has the markings and
			smoothness of having been used for many years. "
	noun = 'key'
	adjective = 'house' 'front' 'door' 'markings' 'marks' 'mark' 'smoothness' 
			'original' 'old'
	location = nil
	
	verDoGiveTo( actor, io ) = {}
	
	doTake( actor ) =
	{
		inherited.doTake( actor );
		
		if ( not self.takenOnce )
		{
			"\b";
			self.ldesc2;
			self.takenOnce := true;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yay! You found your key! Where was it? No wait, 
				I don't think I can handle the explanation.\" ";
				return( true );
			case Laura:
				"Laura says, \"Wow, so you finally found it. Good for you.\" ";
				return( true );
			case Architect:
				"He says, \"Don't be silly. We haven't even installed the front
				door yet. How can you have a key for it?\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

NFmasterBedroomEastWall: secretDoorWall
	adjective = 'east' 'southeast' 'se'
	myDoor = NFmasterBedroomSecretDoor
	mySwitch = NFmasterBedroomSecretSwitch
	location = NFmasterBedroom
;

NFmasterBedroomSecretDoor: secretDoorItem
	myWall = NFmasterBedroomEastWall
	mySwitch = NFmasterBedroomSecretSwitch
	otherside = NFwestSecretPassageDoor
	location = NFmasterBedroom
	doordest = NFsecretPassage
;

NFmasterBedroomSecretSwitch: secretSwitchItem
	ldesc = 
	{
		if ( self.found )
			"It looks amazingly like nothing in particular at all. ";
		else
			"You can't see anything that looks like a secret switch
			around here. ";
	}
	myWall = NFmasterBedroomEastWall
	myDoor = NFmasterBedroomSecretDoor
	location = NFmasterBedroom
	found = true
	
	verDoFind( actor ) = {}
	doFind( actor ) =
	{
		if ( self.found )
			"You have already found the secret switch and remember 
			where it is. ";
		else if ( secretSwitch.found )
			theFloor.discoverSwitch( self );
		else
			"You aren't quite sure where you might need to look. ";
	}
;


/*  This is the key that you finally will use to open the front door, which is the
*   last item you are able to get in the game.
*   Location = nil for the time being.
*/
duplicateKey: keyItem
	sdesc = "shiny new duplicate house key"
	noun = 'key'
	adjective = 'duplicate' 'shiny' 'new' 'dupe' 'house' 'front' 'door' 'copy'
	ldesc = "A new, beautifully ground duplicate, if you do say so yourself. Funny,
			it looks uncannily like the original, although much more shiny. "
	location = nil
	masterKey = frontDoorKey
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Nice lookin' key you got there. Excellently
				crafted. That is a copy of your own key, right? I mean, you're
				not going to break into someplace you shouldn't or anything,
				huh? Okay. Then maybe you should put it under the doormat 
				where it should have been all along, ya big silly!\" ";
				return( true );
			case Laura:
				"Laura says, \"Just make sure you put that someplace where
				you'll know where to find it next time! Like under the 
				darned doormat!\"
				\bShe laughs pleasantly. ";
				return( true );
			case Architect:
				"He rolls his eyes at the ceiling. \"So it's a duplicate of a 
				key for a door that hasn't even been installed yet. Brilliant.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

NFsecretPassage: room
	indoors = true
	sdesc = "Secret passage"
	ldesc = 
	{
		"The secret passage is a narrow hallway of sorts, only about twelve feet
		long and three and a half feet wide. The walls are bare plaster and 
		sheet rock. Various springs and tumblers are connected together in an 
		elegant set of mechanisms to open the doors. ";
		
		self.lightDesc;
	}
	xdesc = "The short hallway dead-ends at a crudely-carved staircase leading 
			down. There is another door to the west, and you can go out the 
			way you came in. "
	lightDesc =
	{
		if ( !NFsecretPassageLightBulb.islit )
		{
			"A new light bulb hangs from the ceiling, but it is currently 
			turned off. ";
			
			if ( FinteriorSecretPassageDoor.isopen )
				"The only light in the passage is from the open door. ";
			else
				"There is barely enough light seeping in through the 
				closed door to see by. ";
		}
		else
		{
			"A new light bulb hangs from the ceiling, giving the room 
			some strong but soft illumnation. ";
		}
	}
	
	north = laboratory
	down = laboratory
	out = NFinteriorSecretPassageDoor
	south = NFinteriorSecretPassageDoor
	west = NFwestSecretPassageDoor
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sweet. You could hide stuff there and no one
				would ever find it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Cool. But does it lead anywhere? Maybe it's 
				just a good place to keep stuff.\" ";
				return( true );
			case Architect:
				"He says, \"There's not much room in the floor plan to have
				this connect throughout the house, but it will be a way in,
				and it will be a good storage area that no one else will 
				ever know about.\" He winks at you. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

NFsecretPassageLightBulb: lightsource, switchItem
	sdesc = "light bulb"
	ldesc = 
	{
		"The bulb is of a kind you've never quite seen before. It gives
		off a warm light like an incandescent, but it has no filament 
		that you can see. ";
		
		pass ldesc;
	}
	noun = 'fixture'
	adjective = 'light' 'bulb'
	location = NFsecretPassage
;

/*
NFsecretPassageWallSocket: socketItem
	adjective = 'electricity' 'wiring' 'electric' 'electrical'
	hasJuice = true
	location = NFsecretPassage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				if ( blueprint.secretpassage )
					"He says, \"When the house is finished, the secret 
					passage will be all wired up.\" ";
				else
					"He says, \"Everything should be fine with the 
					house's electricity. ";
				return( true );
			default: 
				return( nil );
		}
	}
;
*/

NFinteriorSecretPassageDoor: doorway
	sdesc = "main door"
	noun = 'door'
	adjective = 'south' 'main'
	location = NFsecretPassage
	otherside = NFsecretDoor
	doordest = NFsouthOfHouse
;

NFwestSecretPassageDoor: doorway
	sdesc = "west door"
	noun = 'door'
	adjective = 'west' 'w'
	location = NFsecretPassage
	otherside = NFmasterBedroomSecretDoor
	doordest = NFmasterBedroom
;

NFspringsAndTumblers: unimportantItem
	sdesc = "springs and tumblers"
	ldesc = "Various springs and tumblers are connected together in an elegant set 
			of mechanisms to open the doors. "
	noun = 'spring' 'tumbler'
	plural = 'springs' 'tumblers'
	isThem = true
	adjective = 'elegant' 'set' 'mechanism' 'mechanisms' 'various'
	location = NFsecretPassage
;

NFcrudelyCarvedStaircase: fixedBlock
	sdesc = "crudely carved staircase"
	ldesc = "The staircase doesn't seem to have been part of the architect's
			imaginings. You saw this spot when the house was being 
			constructed, and all that was here was a concrete foundation.
			An opening has been carved into the foundation, and a sloping
			tunnel has been constructed, with crude stair steps hewn out
			of the natural limestone. It is entirely unclear to you when
			this excavation took place, making its existence quite 
			mysterious. "
	noun = 'staircase'
	adjective = 'crudely' 'carved' 'concrete' 'cement' 'foundation' 'opening'
			'sloping' 'tunnel' 'crude' 'stair' 'stairs' 'step' 'steps' 
	location = NFsecretPassage
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbDown( actor ); }
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		Me.travelTo( laboratory );
		return( true );
	}
;

NFnaturalLimestone: unimportantItem
	sdesc = "natural limestone"
	ldesc = "The natural limestone is what makes up most of the earth in 
			this area. "
	noun = 'limestone'
	adjective = 'natural'
	location = NFsecretPassage
;


/*************************** END OF GAME CODE *****************************/

/* eof */
