All text will now be saved to the script file.  Type UNSCRIPT at any time to
discontinue scripting.

>restart
Are you sure you want to start over?  (YES or NO) > y

You've just arrived at home from your nightly visit to the science and
invention section of the local public library, where you spend each night
dreaming your dreamy dreams of one day inventing a time travel machine. 
Tonight, for some reason, you're especially fatigued, and can't wait to get
inside and go right to bed.  Seems like a good plan, but somehow you have a
premonition it's not going to be that easy...

First Things First - A Text Adventure Game by J. Robinson Wheeler
Developed with TADS:  The Text Adventure Development System.

Release Version 3.0 20061221
Copyright 2001 by J. Robinson Wheeler.  All Rights Reserved.
Published by JRW Digital Media.
Type ABOUT, CREDITS, and HELP for general information.


Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>i
You are carrying:
   a library book

>x book
Tonight, like every night, you brought home a book on time-travel theories. 
This one talks about the paradoxes involved in changing the future from the
past, or some such.

>read it
There are two main theories about the potential for time travel.  The first is
that time is linear and immutable.  Even if one were able to travel back and
forth, there would be no way to alter the course of events.  This does not rule
out free will; rather, it is stipulated that free action is accounted for --
the time traveller's comings and goings have, in a sense, already taken place. 
You could not go back in time and prevent your own birth, for circumstances
would intervene to make this action impossible.

The second theory is that the timeline branches when a time traveller moves
back and forth.  A traveller from the future may disrupt the possibility of
returning to the same world he or she left behind.  Some say that time is an
infinitely branching tree, with each moment containing a universe of all
probable or possible choices, and the time traveller slips around from one to
the next, with free will being a crucial factor in the consequent events.

A third theory has been recently posited, and is the core of this particular
book.  It delves into the possibility of a merger between the two theories
(previously determined to be mutually exclusive).  This theory is expanded upon
under the heading of paradoxes.

>look up paradoxes
(in the library book)
This book centers on a new kind of paradox.  It posits a theory in which the
two main theories of time travel (previously determined to be mutually
exclusive) are merged, allowing both for a universe in which time travel cannot
change the course of events; and yet at the same time depicts a branching time
stream where a time traveller may redirect events to change the future.

This new paradox goes something as follows:  A time traveller from the future
travels back to the past.  The mere act of traveling backwards disrupts the
future course of events from that moment, making it impossible for the
traveller to return to his or her own time and find it to be as he or she left
it.  However, through further manipulation of objects and events, the time
traveller will be able to alter the time stream such that the future he or she
left will be restored.

Once the future is restored, the time traveller will have discovered that all
of these events -- including the initial time trip which disrupted the time
stream -- needed to happen, or else the time traveller would never have existed
in the world he or she initially came from, and thus would not have been able
to make the trip in the first place.  The existence of the future he or she
came from was contingent on the very disruption and manipulation of the time
stream that nearly caused their future never to have existed at all!

>open door
It's locked.  Drat the luck, you've forgotten your house key tonight.  There
must be a spare around here somewhere.

>knock on door
You knock on the front door.  There is no response.

>l

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>x stones
Just a couple of cold grey stones sitting in the soft dirt.

>lift stones
You find a spare key!

[ Your score just went up by 3 points. You can toggle these notifications at
any time by typing 'notify.' ]

>i
You are carrying:
   a library book
   a spare key

>x key
This is a spare key that you left yourself in case of emergency.

>unlock door with key
This key doesn't fit the front door lock.  It must open something else.

As you move the key away from the lock, you are hit with a strong sense that it
is going to be a long and complicated night before you'll be able to unlock and
open this door.

At the same moment, something causes your spine to shiver.  Something is
definitely in the air this evening, but you don't know what.

>smell
You smell nothing unusual.

>smell air
You smell nothing unusual.

>look under doormat
There's nothing under the doormat.  It would be a good place to put your spare
house key, if only you knew where it was.

>put key under mat
You need to put your spare house key under the doormat, not this one.

>x key
This is a spare key that you left yourself in case of emergency.

>drop mat
You aren't carrying it.

>sw

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

>x bare spot
The bare spot reminds you that you always wished you'd planted a tree here. 
Standing in the spot, your attention drifts to the equally bare wall on this
side of the house.

>x wall
You always thought that the wall on this side of the house would make a great
place to hide a secret door.  Again, you are reminded of your lack of
foresight.  If there were a door here, you could get in that way.

>knock on wall
You knock on the wall.  It sounds solid.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>x trees
I see nothing special about the grove of cedar and live oak trees.

>x rock
The rock is a five foot grey boulder, almost egg-shaped, a single piece of
heavy, textured granite.  Polished smooth over time, a wedge shape sheared from
the top ages ago provides a comfortable place to sit.

>sit on rock
You sit down on top of the rock.  It is very serene and peaceful.

>think
Hmmmmmm.

>get up
Okay, you're no longer on the large rock.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

There is a warmth to the air you don't recognize.

>x moonlight
I don't know the word "moonlight".

>x moon
The moon is gibbous and waning, but bright on this cloudless night.

>note moonlight
I don't know the word "moonlight".

>note
What do you want to note?

>note hello
I don't understand that sentence.

>note "hello"
Noted.

>x clearing

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

>x gruond
I don't know the word "gruond".

>x ground
It lies beneath you.

>x woods
I don't see any woods here.

>x path
I see nothing special about the footpath.

>x light
Moonlight streams prettily through the canopy of leaves above.

>x canopy
I see nothing special about the canopy.

>smell
You smell nothing unusual.

>nw
There is nowhere to go in that direction.

>ne

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>e
There is nowhere to go in that direction.

>nw
There is nowhere to go in that direction.

>ne

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

>x wall
You always thought that the wall on this side of the house would make a great
place to hide a secret door.  Again, you are reminded of your lack of
foresight.  If there were a door here, you could get in that way.

>x window
The little window is probably the one that leads into your attic.  It's hard to
judge from here, but it looks like you could just fit through it.  Getting all
the way up to it is going to be the real problem.

>climb window
It's too far away.

>climb wall
The wall is not suitable for climbing.

>nw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

>e
You can't enter the house from here.

>x pipe
I see nothing special about the drainpipe.

>climb pipe
The drainpipe is not suitable for climbing.

>x path
I see nothing special about the gravel path.

>follow path
I don't know how to follow the gravel path.

>nw
There is nowhere to go in that direction.

>ne

North of house
The north side of your house is dominated by your garage door.  The garage door
is closed.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>s door
I don't recognize that sentence.

>open it
You can't reach that from here.

>x door
It's closed.

>x stone wall
I see nothing special about the stone wall.

>note "The wall tapers in a stairstep fashion as it climbs up to and beyond the edge of the roof. "
Noted.

>climb wall
You climb gingerly up the stone wall.

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

[ Your score just went up by 4 points. ]

>x chimney
I see nothing special about the chimney.

>look in it
There's nothing in the chimney.

>clean gutter
You pull some leaves out of the gutter and toss them aside.  The gutter looks a
little cleaner now, but not by much.

>g
You pull some leaves out of the gutter and toss them aside.  The gutter looks a
little cleaner now, but not by much.

>get leaves
You pull a few stray leaves from the gutter and toss them aside.

>s

South roof
The shingles are in even worse shape on this end of the house, which makes you
very nervous as the ground is a long way down from the peak here, at least 30
feet.  The gutter trap is to the west and continues up to the north end of the
house.  You can see the top opening of the drainpipe in the clogged leaves. 
The only exit is north.

A squirrel is here.

The squirrel is rather squat and feral, but it regards you with an almost
intelligent interest.

>x roof
The shingles are in really bad shape on this end of the house.  Some of them
are really loose.

The squirrel gazes into the distance, daydreaming about something.

>get shingle
You pry loose one of the bad shingles.

The squirrel dashes from one spot to another, then twitches its jaws.

>x squirrel
Definitely male, all right.  He's got a tuft of white hair on his head that
almost gives him an Einstein-like appearance.  In his little paws is a big,
juicy acorn.

The squirrel nibbles at his tail.

>ask squirrel for acorn
The squirrel doesn't want to give you that.

The squirrel lazes about in a state of squirrel contentment.

>d
You will fall off the roof if you go in that direction.

The squirrel shakes his little head.  It doesn't mean anything significant.

>n

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

>d
You climb gingerly down the stone wall.

North of house
The north side of your house is dominated by your garage door.  The garage door
is closed.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>se

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>e
There is nowhere to go in that direction.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>unlock car with key
Unlocked.  So that's what this key is for.

>open car
Opened.

>get in
(the little car)
Okay, you're now in the little car.

Driveway (in the little car)
The interior of the car has gotten a little dusty with disuse, but the seats
are still comfy.  The only obvious things to see are the glove compartment, an
armrest compartment, and the steering wheel.  The little car is open.

>open compartment
Opening the armrest compartment reveals a garage door opener.

[ Your score just went up by 5 points. ]

>get opener
Taken.

>open glove
It's locked.

>unlock it
(with the car key)
Unlocked.

>open it
Opening the glove compartment reveals a school pencil and a tourist map.

>x pencil
It's a standard school pencil.  It's got some teeth marks, the lead is blunt,
and the eraser has worn off.

>x map
It's a tourist map of Paris.  Must be left over from some other adventure.

>l

Driveway (in the little car)
The interior of the car has gotten a little dusty with disuse, but the seats
are still comfy.  The only obvious things to see are the glove compartment, an
armrest compartment, and the steering wheel.  The little car is open.  The
glove compartment seems to contain a school pencil and a tourist map.

>out
Okay, you're no longer in the little car.

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>close car
Closed.

>push opener
You push the opener button.  Click.

>w

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>s

In the garage
This room is a total mess.  No wonder you keep your car in the driveway.  It
would take a long time to sort through the junk in here, and even then it seems
unlikely there would be much point to it.  There is a garage door button on the
wall.  A closed door to the south leads into your house through the kitchen. 
The only other exit is the way you came in, which is open.

You see an opener button here.

>search junk
You find a crowbar!

>g
You find a can of WD-40!

>g
You find an old pillowcase!

>g
You find a handful of cobwebs.  Bleah!

>g
You find a deflated soccer ball!

>g
You find a broken tire pump!

>g
You find a wasp nest!

>g
You find a 2x4 plank!

>g
You find a can-opener!

>g
You find a moose head trophy!

>g
You find a shovel!

>g
You find a beat-up mattress!

>g
You find a divining rod!

>g
You find a machete!

>g
You find a busted wheelbarrow!

>g
You find a frisbee!

>g
You find a cannonball!

>g
You find the kitchen sink!

>g
You find absolutely nothing else!  At last!!!

[ Your score just went up by 10 points. ]

>l

In the garage
This room is a total mess.  No wonder you keep your car in the driveway.  Sure
enough, it took a long time to sort through the junk in here, and you have
found everything including the kitchen sink, and there still doesn't seem to
have been much point to it.  There is a garage door button on the wall.  A
closed door to the south leads into your house through the kitchen.  The only
other exit is the way you came in, which is open.

You see an opener button, a crowbar, a can of WD-40, an old pillowcase, a
deflated soccer ball, a broken tire pump, a wasp nest, a 2x4 plank, a can-
opener, a moose head trophy, a shovel, a beat-up mattress, a divining rod, a
machete, a busted wheelbarrow, a frisbee, a cannonball, and the kitchen sink
here.

>put crowbar, pillowcase, rod, machete, frisbee, and cannonball in the wheelbarrow
crowbar:  Done.
old pillowcase:  Done.
divining rod:  Done.
machete:  Done.
frisbee:  Done.
cannonball:  Done.

>x wheelbarrow
This filthy beast from, apparently, the last century, has a busted front wheel.
In the busted wheelbarrow you see:
   a crowbar
   an old pillowcase
   a divining rod
   a machete
   a frisbee
   a cannonball

>x front wheel
It looks like you hit it on a rock and loosened the bolt, as well as twisted
the axle out of shape.

>fix it
What do you want to fix it with?

>machete
That's not a tool you can use.

>l

In the garage
This room is a total mess.  No wonder you keep your car in the driveway.  Sure
enough, it took a long time to sort through the junk in here, and you have
found everything including the kitchen sink, and there still doesn't seem to
have been much point to it.  There is a garage door button on the wall.  A
closed door to the south leads into your house through the kitchen.  The only
other exit is the way you came in, which is open.

You see an opener button, a can of WD-40, a deflated soccer ball, a broken tire
pump, a wasp nest, a 2x4 plank, a can-opener, a moose head trophy, a shovel, a
beat-up mattress, a busted wheelbarrow, and the kitchen sink here.

>x moose
What a piece of junk!  Perhaps the ultimate.  Be proud.

>push barrow s
The back door is closed, but the wheelbarrow wouldn't fit through it anyway.

>x door
Which door do you mean, the garage door, or the back door?

>back
It's closed and locked.

>push barrow n

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

You see a busted wheelbarrow here.

>push barrow sw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

You see a busted wheelbarrow here.

>push barrow se

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

You see a busted wheelbarrow here.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You feel as if something is about to happen, but don't know what.

>smell
You smell nothing unusual.

There is a strange vibration to the air, and the smell of ozone.

>smell
The air smells of ozone.

Something is definitely happening!  The center of the clearing is starting to
glow bright yellow.

>x center
The light is blindingly bright, and seems to be coming from a disturbance of
the air in the middle of the clearing.

A sound like the crack of thunder erupts, sucking in the air from around you
into a vacuum in the center of the clearing.  The light becomes blindingly
bright.

>z
Time passes...

When the light fades, you see that a time machine has appeared!

>x machine
It's a large contraption that's about the size and shape of an engine block,
and made of solid metal.  It sits on a platform that is welded firmly to the
machine itself.  On the front is a knob and a large red button.  On the back
side of it is a hinged compartment.  There is a label on the knob.  You feel
heat radiating from the machine.

>feel machine
The time machine feels very warm.

>note "The time machine pings and clicks as the metal cools down."
Noted.

>get on
What do you want to get on?

>platform
Okay, you're now standing on the time machine platform.

[ Your score just went up by 5 points. ]

>x label
It reads:  -20, -10, 0, +10, +20.

The haze and ozone dissipate from the air.

>x compartment
You notice that a lot of heat is coming out of the hinged compartment.  The
hinged compartment is closed.

>open it
A wave of heat comes out of the compartment.  Opening the hinged compartment
reveals the time machine manual and a package.

>get all from compartment
time machine manual:  Taken.
package:  Taken.

>x package
It's a little package, addressed to you.

>read it
"We hope you find this item of use in finding what is useful."

>read address
I don't know the word "address".

>open package
Opening the package reveals a odd gadget.

>get gadget
Taken.

>x it
The gadget is comfortably held in the hand, and the front end of it seems
designed to be pointed at things.  There are no moving parts or ways to open it
that you can discern.

>point it at package
The gadget makes a happy "poing!"  noise.

>point it at time machine
The gadget makes a happy "poing!"  noise.

>point it at manual
The gadget makes a happy "poing!"  noise.

>l

Clearing (on the time machine platform)
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>point it at canopy
The gadget makes a happy "poing!"  noise.

>point at ground
You point at the ground.

>point it at the ground
Okay, you point the ground at the ground.

>point gadget at ground
The gadget makes a happy "poing!"  noise.

>set dial to 1
It's already set to 1!

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.

[ Your score just went up by 5 points. ]

>l

Clearing (on the time machine platform)
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.

>off
Okay, you're no longer on the time machine platform.

>ne
You push through the trees.  Your footpath doesn't seem to exist any more...

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>smell
You smell sawdust in the air.

>smell wood
I don't see any wood here.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

Someone shouts, "Get that paint over to number eight!"  A teenaged kid dashes
by with hot coffee for the foreman.

>x crew
The workers are skilled in various duties, and all are extremely busy at their
jobs.

Two guys wheel past with a load of cinder blocks.

>x blocks
Those aren't important.

A man with a hard hat barks commands to some dust-covered strongarms.  Someone
shouts, "Where's the langstrom 7-inch gangley wrench?"

>x wrench
That isn't important.

A young man scurries by, holding three bundles of copper piping.

>note "dust-covered strongarms"
Noted.

Two women walk by, discussing their favorite winch pulley manufacturers. 
Someone up in the roof rafters shouts orders that are ignored.

>e

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>x sidewalk
The concrete sidewalk that leads away from your house has been recently poured.
It is fresh and white and clean.

>write "hi there!" in sidewalk
There's no good way to draw on a sidewalk.

>draw on sidewalk
What do you want to draw on it with?

>hand
There's no good surface on the sidewalk.

>i
You are carrying:
   a library book
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget

>draw on sidewalk with car key
There's no good surface on the sidewalk.

>l

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>x concrete
The concrete sidewalk that leads away from your house has been recently poured.
It is fresh and white and clean.

>draw in concrete
What do you want to draw on it with?

>key
There's no good surface on the sidewalk.

>e

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>w

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>w

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

Someone cries, "Yeah!  We've been waitin' for those!"

A huge man with a mustache to match lopes by, carrying a trowel and a bag of
plaster mix.  A short man in a blue shirt says, "We ain't got enough water in
the mix.  Where's the foreman?  Get the foreman."

>ne

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  A huge
supply truck sitting on the other side of the driveway, behind the blockade. 
You can walk around the house to the northwest and southwest.  You can go
around the driveway and find the road into town to the southeast.

You see a jug of miracle-grow here.

A crashing noise is heard, and then a burst of laughter.  You can't see what
caused it.

The sharp noise of nails being hammered into thick planks causes you to blink
your eyes several times.  A young woman with a large box of wood screws rushes
past, crying, "Coming!  Coming!"

>get jug
You've already got your hands full.

A sweaty, red-faced man yells, "Where are my ducts?  Where are my flim-flanged
ducts?"

Someone yells, "That's a riot!  Where's Ed?  He's gotta hear this!"  A nervous
kid slouches by, looking like it's his first day on the job.

>x cement
I see nothing special about the wet driveway.

A trio of men with puffy faces and scruffy chest hair stride past, telling
dirty jokes.

A beefy blond man waddles past, blowing his nose ferociously into the sleeve of
his shirt.  Someone yells, "Fifteen!  Fifteen, everybody!"
Someone yells back, "You got that right!"

>write "hi there" in cement
Okay, you write "hi there" on the wet driveway.

A young woman with a pile of floor tiles rushes past, crying, "Who ordered
these?"

A guy clambers down from above and yells, "Let's eat!".  Someone rushes up to
you, looks you up and down, and then shakes his head and runs off.

>draw a duck in the cement
I don't know the word "duck".

>draw a time machine in the cement
You've already left your mark on the driveway.

A man with round spectacles stares at the sky and predicts rain.

A wiry lad from the electrical crew says, "We need to wait for the plumbers." 
There is a crashing noise and some amount of furor and muttered oaths from the
construction crew.

>x driveway
"Hi there" is written into the wet driveway cement.

Someone shouts, "Nobody move!  Wait, everyone get out of the way!  I said, get
out of the way!"

A fat man jumps up and down and makes 'bibble-brrrrrr' noises with his mouth. 
Oddly, nobody seems to care.  A handsome, tanned woman walks past, sipping a
cup of tea.

>l

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  A huge
supply truck sitting on the other side of the driveway, behind the blockade. 
You can walk around the house to the northwest and southwest.  You can go
around the driveway and find the road into town to the southeast.

You see a jug of miracle-grow here.

Someone shouts, "Budget!  We're over budget!  I can feel it."

There is a whoop from a nearby card game being played by a team of idle roof
shinglers.  A somber man winds past, unfurling a length of thick cabling behind
him.

>i
You are carrying:
   a library book
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget

A set of floor tiles is laid out on the ground and inspected.

A slouching plumber trundles by, snapping his chewing gum.  A tall man with a
hard hat checks the crossbeams with a level.
"Just about perfect," he intones.

>w

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

You see a screwdriver here.

A huge truck departs, diffusing the sunlight with its smoky exhaust.

Two young boys scamper by, tossing a ball back and forth.  Someone shouts,
"Hey!  Get your kids off the site!"  A voice cries, "Higher!  Higher!  Keep
going!  Stop!"

>get screwdriver
Taken.

An old gent with nails clenched between his lips totters by, carrying a
selection of hammers.

A beautiful woman walks by, slips on a cable, and breaks one of her high heels.
"Ooohh!"  she yells, enraged.  Someone cries, "Hammers!  Hammers!"
Another voice replies, "Ol' Meretzsky just went by!"

>climb ladder

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The architect is here.

Four electricians push their way through, carrying cartons of wiring and
sockets.

A voice yells, "We need more of that one, and less of the other!"
Someone responds, "You mean like this?"
The first voice shouts, "No, the other way around, Artie!"  A woman shouts,
"Has anyone seen Brian?"

>x blueprint
It's a lovely floor plan, rendered impeccably with blue pencil.  The name of
the architect is stenciled in the top corner.

A noisy blast comes from the cement mixer.  Several workers, clutching their
heads, emit vain cries of protest.

Someone shouts, "Get that paint over to number eight!"  A teenaged kid dashes
by with hot coffee for the foreman.

>x architect
The architect is a brilliant craftsman, in his own way.  You can tell just by
looking at him.  He must be in his early forties, with slightly peppery hair at
the sideburns.  His eyes are deep and intelligent, and his shoulders are
already rounded from years of hunching over drafting tables.

The lunchtime whistle blows shrilly.

All of the workers cry, "LUNCH!"  They drop what they're doing and gather north
of the house to start eating.  The architect looks up, grimaces, but goes back
to work.

He says, "Oh sure.  They get a lunch break.  They always get a lunch break. 
But me?  Do I get one?  Noooo..."

>note "rewrite"
Noted.

>ask architect about house
The architect says, "I'm afraid you'll have to ask someone else."

>ask architect about planks
He says, "Yes, wooden planks.  Made of wood."

>ask him about blueprint
He frowns at it.  "There's something missing.  Ah well, it's what you asked
for."

>ask him about me
The architect says, "You tell me."

>architect, who am i
The architect says, "You tell me."

>tell him about me
You start to tell the architect a little bit about yourself and your interest
in science and time travel, but he cuts you off with a plea to let him get back
to work.

>ask him about him
The architect says, "I'm not sure what to tell you about myself."

>d

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>s

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>get on
What do you want to get on?

>platform
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

You see a busted wheelbarrow here.

>fix wheel with screwdriver
Perhaps a wrench would have been better suited for the task, but with a little
effort you tighten the bolt holding the wheel.  The axle is still a little
bent, but the wheel should stay on.

[ Your score just went up by 2 points. ]

>full
In a total of 206 turns, you have achieved a score of 34 points out of a
possible 151, which means you are starting to get somewhere.  You have earned
the following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the past the first time
 2 points for fixing the wheel with the screwdriver
 3 points for finding various items

>put screwd in barrow
Done.

>push barrow sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

You see a wheelbarrow here.

>push barrow sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine and a wheelbarrow here.

>put barrow on platform
Done.

>get on platform
Okay, you're now standing on the time machine platform.

>get cannonball
Taken.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

>nw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

>ne

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>u
You climb gingerly up the stone wall.

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

>s

South roof
The shingles are in even worse shape on this end of the house, which makes you
very nervous as the ground is a long way down from the peak here, at least 30
feet.  The gutter trap is to the west and continues up to the north end of the
house.  You can see the top opening of the drainpipe in the clogged leaves. 
The only exit is north.

A squirrel is here.

The squirrel gazes into the distance, daydreaming about something.

>clean leaves
You pull out a few stray leaves, but it does nothing to unclog the drainpipe.

The squirrel flicks his tail and blinks.

>put ball in gutter
You drop the cannonball into the drainpipe.  It barely fits, so you give it a
shove.  There is a disgusting vomiting noise below, as the cannonball bursts
out the bottom of the spout, pushing all the muck out with it.

[ Your score just went up by 3 points. ]

The squirrel paces back and forth.

>s
You will fall off the roof if you go in that direction.

The squirrel squats down.

>n

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

>n
You will fall off the roof if you go in that direction.

>d
You climb gingerly down the stone wall.

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>ne
There is nowhere to go in that direction.

>e

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>e

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>search shrub
I don't see any shrub here.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

>search shrug
I don't understand that sentence.

>search shrub
You find a sewer grating!

>x litter
I see nothing special about the litter.

>get trash
You don't need to take the litter.

>but I want to!
I don't know the word "want".

>n

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>look in slot
You contort your neck to peer into the deposit slot.  Wedged just inside the
slot are two books.  Someone must have tried to cram them both in at the same
time, because they should have slid down and out of reach.

>x library
This is the library you left just a few minutes ago.  It is closed for the
night.  A depository slot is the only thing of note.

>get wedged books
You grab ahold of the books and give them a few solid yanks.  They pop free and
tumble onto the ground.

>get books
rare book:  Taken.
biology book:  Taken.

>i
You are carrying:
   a library book
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget
   a rare book
   a biology book

>x rare
A rare scientific volume, detailing the mating habits of small rodents.

>read it
You haven't the slightest interest in the subject.  Who would?

>read biology
The only thing interesting about this book is that the author was apparently
stranded on a small island in the Pacific for fifteen years while researching
the material.

>x it
The title of this book is "Fun With Ferns" by Prof. Roy Hinkley.

>put biology in slot
You return the biology book to the library.  It slides down the slot and out of
view.

>put time travel book in slot
There appear to be extra words after your command.

>put time book in slot
I don't see any time book here.

>i
You are carrying:
   a library book
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget
   a rare book

>put library book in slot
You return the library book to the library.  It slides down the slot and out of
view.

>i
You are carrying:
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget
   a rare book

>s

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>s
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>w

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>w

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>u
You climb gingerly up the stone wall.

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

>s

South roof
The shingles are in even worse shape on this end of the house, which makes you
very nervous as the ground is a long way down from the peak here, at least 30
feet.  The gutter trap is to the west and continues up to the north end of the
house.  You can see the top opening of the drainpipe in the clogged leaves. 
The only exit is north.

A squirrel is here.

A mood seems to come over the squirrel, indistinguishable from other squirrel
moods.

>show book to squirrel
The squirrel leaps up and down in a state of excitement!

>give it to him
You can't reach that from here.

>give book to him
You can't reach that from here.

>l

South roof
The shingles are in even worse shape on this end of the house, which makes you
very nervous as the ground is a long way down from the peak here, at least 30
feet.  The gutter trap is to the west and continues up to the north end of the
house.  You can see the top opening of the drainpipe in the clogged leaves. 
The only exit is north.

A squirrel is here.

The squirrel pouts, looks excited, then pouts again.  Just your usual squirrel
business.

>i
You are carrying:
   a car key
   a bad shingle
   a garage door opener
   the time machine manual
   a package
   a odd gadget
   a rare book

The squirrel waddles a bit.

>give book to squirrel
You give the rare book to the squirrel.

The squirrel is so excited by the numerous color depictions of female squirrels
in heat that he drops the acorn, which unfortunately rolls down the slope of
the roof into the gutter.  You hear the acorn rattle into the drainpipe.

The squirrel runs off with the rare book.

>d
You will fall off the roof if you go in that direction.

>s
You will fall off the roof if you go in that direction.

>n

North roof
This is the north end of the roof.  Shingle tiles, already looking the worse
for wear, make for slippery traction.  A gutter trap, clogged with leaves, runs
along the length of the west side of the house.  The roof itself continues
south.  The stone wall, which turns out to be the outside of your chimney,
leads back down.

>d
You climb gingerly down the stone wall.

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>sw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

You see a cannonball and a big juicy acorn here.

>get all
drainpipe:  It's fixed in place.
cannonball:  Taken.
big juicy acorn:  Taken.

[ Your score just went up by 8 points. ]

>se

South of house
You always thought this would be a nice place to plant a tree, but a bare spot
reminds you of your lack of foresight.  The ground slopes down slightly here,
and the wall of the house looms an extra story high because of it.  There is a
tiny window high in the wall, about 30 feet up.  A little path made by you on
your many daily walks leads southwest into the woods.  You can walk around your
house to the northwest and northeast.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>put all in barrow
car key:  Done.
bad shingle:  Done.
garage door opener:  Done.
time machine manual:  Done.
package:  Done.
odd gadget:  Done.
cannonball:  Done.
big juicy acorn:  Done.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you.  The world around you spins into a wild vortex that suddenly
vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can barely keep your bearings straight, as each
direction looks the same as every other.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

[ Your score just went up by 5 points. ]

>get machete
Taken.

>off
Okay, you're no longer on the time machine platform.

>listen
You hear the sound of a stream gurgling somewhere nearby.

>find stream
I don't see any stream here.

>x stream
I don't see any stream here.

>hack forest
(with the machete)
You raise the machete high and start hacking.  The thick foliage parts, and you
trudge forward.


In the forest
The woods surround you on all sides.  You can hear the soft gurgling of a
stream nearby, but the foliage is so rich and dense that the sound of it is
dispersed.  The foliage is so rich and dense that you can barely keep your
bearings straight.  Each direction looks the same as every other.

You see a hacked path leading north here.

>hack forest
(with the machete)
You raise the machete high and start hacking.  The thick foliage parts, and you
trudge forward.


In the forest
The woods surround you on all sides.  You can hear the soft gurgling of a
stream nearby, but the foliage is so rich and dense that the sound of it is
dispersed.  The foliage is so rich and dense that you can barely keep your
bearings straight.  Each direction looks the same as every other.

You see a hacked path leading southwest here.

>hack forest
(with the machete)
You raise the machete high and start hacking.  The thick foliage parts, and you
trudge forward.


In the forest
The woods surround you on all sides.  You can hear the soft gurgling of a
stream nearby, but the foliage is so rich and dense that the sound of it is
dispersed.  The foliage is so rich and dense that you can barely keep your
bearings straight.  Each direction looks the same as every other.

You see a hacked path leading south here.

>g
Your arm is starting to get tired, but again you raise the machete high and
start hacking.  The thick foliage parts, and you trudge forward.


Flowing stream
The foliage parts at last to reveal a sparkling forest stream.  Light dapples
gently through the leaves to highlight slick, wet rocks and the bright green of
fresh growth.  The stream flows, about half a meter wide, from the north to the
southwest.

You see a hacked path leading northwest here.

[ Your score just went up by 4 points. ]

>x stream
The stream is fast, but shallow.  From the looks of it, it is just a glimmer of
the rushing fullness it once was, and will soon dry up forever.

>sw

Grotto
The multiverdant greenery fed by the churning stream seems to end here in a
place of stillness and serenity surrounding a deep pool of clear water.  Even
the very air itself seems to obey the call to quiet.  The only exit is
northeast.

>smel
I don't know the word "smel".

>smell
The air smells crisp, fresh, and sweet.

>drink water
The water looks clear and clean, but that's no reason to take an unnecessary
risk to your health.

>listen
You hear the soothing gurgle of the stream as it pools here.

>d
There is nowhere to go in that direction.

>enter grotto
I don't know how to enter the grotto.

>swim
(the pool)
You should probably leave your things here before you do that.

>drop all
machete:  Dropped.

>swim
(the pool)
As you step into the cool water pool, you find it difficult to keep your
footing.  You move slowly towards the deeper end, and suddenly the bottom takes
a sudden drop.  Losing your balance, you slide under the water, pulled along by
a deep current you didn't imagine was lurking under the still surface.

Looking out through the water's surface, you see the sunlight disappear.  Air
returns to your lungs just as the light goes away, and you feel your body
sluicing down into groundwater caverns.

When the motion stops, all you hear is the dripping of shallow water.  You
crawl forward and find a hard but dry spot.  It is not completely dark here,
but it takes a few minutes for your eyes to adjust.  In the misty light you
find yourself in a ...


Limestone crawl
You are in a tiny crawlway carved by the flow of ancient waters through soft
limestone.  The natural groundwater springs are drying up, and soon will be
gone.  A current of dark but shallow water swirls nearby.  Light leaks down
from a vertical sluice that leads up into the deep end of the grotto.  You can
leave through careful navigation up the sluice, or follow the crawlway, which
leads north.

>n

Narrow north-south crawl
You are in a narrow north-south crawlway that bulges slightly, giving you more
room to maneuver.  The crawlway heads north and then bends, making it difficult
to see farther ahead, and slopes downward to the south.

>n

Tight bend
The tunnel you have been following makes a tight bend here.  Chalky dust swirls
in the damp air, stirred up by your arrival.  The crawl widens to the south,
and turns here to the southeast, making a sudden drop as it does so.

>x dust
Chalky dust swirls in the damp air, stirred up by your arrival.

>smell
The room smells of wet limestone.

>se

Crumbling tunnel
Eroding limestone has caused the floor here to give way recently.  You find
your footing on the crumbling chunks of limestone, but only after making a
scary drop of about four feet.  The walls of the tunnel sport all manner of
jagged cracks, but you don't feel any shifting or settling.  Perhaps it is safe
to continue, but probably not much farther.  The limestone shelf is up and back
to the northwest.  The tunnel continues forward to the north, descending even
further as it does so.

>x cracks
I don't see any cracks here.

>x shelf
I don't see any shelf here.

>n

Dark passage
The light you have been following darkens here, making you wonder how much
faith you have in the ambiguous light source.  You can no longer make out any
colors, only grainy shades of light and dark, but there wouldn't be many other
colors to see even in full light.  The passage continues ahead, zigzagging to
the northeast, and to the south.

>ne

Zigzag passage
The passage takes a series of sharp, zigzag turns here, north to west, north to
west.  As it does so, you feel your ears adjust to deepening pressure.  You are
definitely headed downhill the farther you go.  The passage straightens out to
the northeast, where you can discern a strange but growing brightness, and
zigzags back into the darkness to the southwest.

>ne

Ledge
The brightness coming from the bend in the tunnel to the north nearly distracts
you from watching your footing.  The sharp echo of a carelessly kicked stone,
that rattles down for ten or twelve seconds before coming to a splashing halt,
stops you in your tracks.

You are standing on a narrow ledge at the south end of a jagged east-west gap
in the cave floor.  The gap plunges straight down, erosion having eaten
everything away underneath.  It is not a wide gap, and you are capable of
crossing it without difficulty.  However, you are aware that if you had stepped
directly into it, your story would have ended here, in the darkness and the
deep.  Across the gap, the tunnel goes north and takes another bend, and it
continues back southwest.

>x ledge
I see nothing special about the narrow ledge.

>x gap
The gap plunges straight down, erosion having eaten everything away underneath.
It is not a wide gap, and you are capable of crossing it without difficulty.

>jump across
You jump across to the north side of the gap.

>listen
You hear the dripple of underground waters.

>ne
There is nowhere to go in that direction.

>n

Bright bend
Bright blue illumination shines from the opening to a larger cavern to the
east.  The light shimmers and ripples on the walls, wavelike patterns that
dance and intermingle, shining all the more brightly where they overlap.  The
cavern is east, and the tunnel bends south, where it meets a ledge.

>e

Crystal cavern
You are in a large cavern that seems to be an enormous natural geode, with
crystals as big as your head growing in splints and shafts from every
direction.  A pool of white water catches the reflected and refracted light and
spins it back into the room, where it is caught and re-refracted.  The original
source of the light seems to be a series of pinholes in the roof of the cavern
high above, but you don't think it could be sunlight.  You have lost track of
how deep you have gone, perhaps twenty, perhaps forty feet under the surface,
but too far down to see sunlight, you would have thought.  It is possible that
sunlight has periscoped down a set of small crystal encrusted shafts that lead
far enough up to see the open sky.  In any case, it is literally mesmerizing to
be here.  The only exit is a tunnel to the west.

You see crystals here.

>x pool
The pool of white water is silent and slightly rippled, calmer than the vibrant
dance of light on its surface.

>x crystals
Crystals as big as your head and as delicately small as your fingernail are
growing in splints and shafts from every direction.

>get crystal
You search for a crystal loose enough to take without breaking it or a larger
crystal.  After a short search, you discover a perfect blue crystal, which you
take.

[ Your score just went up by 3 points. ]

>put crystal in pool
There's no sense in getting your possessions wet.

>x pool
The pool of white water is silent and slightly rippled, calmer than the vibrant
dance of light on its surface.

>swim
What do you want to swim in?

>pool
The water is not deep enough to swim in.

>touch pool
The pool of white water feels like a pool of white water.

>drink pool
The water's white color indicates a strong mineral content.  It probably is not
good for drinking.

>l

Crystal cavern
You are in a large cavern that seems to be an enormous natural geode, with
crystals as big as your head growing in splints and shafts from every
direction.  A pool of white water catches the reflected and refracted light and
spins it back into the room, where it is caught and re-refracted.  The original
source of the light seems to be a series of pinholes in the roof of the cavern
high above, but you don't think it could be sunlight.  You have lost track of
how deep you have gone, perhaps twenty, perhaps forty feet under the surface,
but too far down to see sunlight, you would have thought.  It is possible that
sunlight has periscoped down a set of small crystal encrusted shafts that lead
far enough up to see the open sky.  In any case, it is literally mesmerizing to
be here.  The only exit is a tunnel to the west.

You see crystals here.

>out

Bright bend
Bright blue illumination shines from the opening to a larger cavern to the
east.  The light shimmers and ripples on the walls, wavelike patterns that
dance and intermingle, shining all the more brightly where they overlap.  The
cavern is east, and the tunnel bends south, where it meets a ledge.

>s

Ledge
You are standing on a narrow ledge at the north end of a jagged west-east gap
in the cave floor.  The gap plunges straight down, erosion having eaten
everything away underneath.  It is not a wide gap, and you are capable of
crossing it without difficulty.  Across the gap, the tunnel goes southwest, and
it continues back north and takes a bend into the crystal cavern.

>cross
(the jagged gap)
You carefully cross to the south side of the gap.

>sw

Zigzag passage
The passage takes a series of sharp, zigzag turns here, north to west, north to
west.  As it does so, you feel your ears adjust to deepening pressure.  You are
definitely headed downhill the farther you go.  The passage straightens out to
the northeast, where you can discern a strange but growing brightness, and
zigzags back into the darkness to the southwest.

>sw

Dark passage
The light you have been following darkens here, making you wonder how much
faith you have in the ambiguous light source.  You can no longer make out any
colors, only grainy shades of light and dark, but there wouldn't be many other
colors to see even in full light.  The passage continues ahead, zigzagging to
the northeast, and to the south.

>s

Crumbling tunnel
Eroding limestone has caused the floor here to give way recently.  You find
your footing on the crumbling chunks of limestone, but only after making a
scary drop of about four feet.  The walls of the tunnel sport all manner of
jagged cracks, but you don't feel any shifting or settling.  Perhaps it is safe
to continue, but probably not much farther.  The limestone shelf is up and back
to the northwest.  The tunnel continues forward to the north, descending even
further as it does so.

>nw

Tight bend
The tunnel you have been following makes a tight bend here.  Chalky dust swirls
in the damp air, stirred up by your arrival.  The crawl widens to the south,
and turns here to the southeast, making a sudden drop as it does so.

>s

Narrow north-south crawl
You are in a narrow north-south crawlway that bulges slightly, giving you more
room to maneuver.  The crawlway heads north and then bends, making it difficult
to see farther ahead, and slopes downward to the south.

>s

Limestone crawl
You are in a tiny crawlway carved by the flow of ancient waters through soft
limestone.  The natural groundwater springs are drying up, and soon will be
gone.  A current of dark but shallow water swirls nearby.  Light leaks down
from a vertical sluice that leads up into the deep end of the grotto.  You can
leave through careful navigation up the sluice, or follow the crawlway, which
leads north.

>u
It's a somewhat torturous ascent, but with patience and resolve you manage to
make your way up the sluice.  Your head again goes underwater for a moment, but
you follow the light.  Your hands grope and find a hold on the shallow bottom
of the pool.  Emerging, you shake yourself dry as best you can.

Grotto
The multiverdant greenery fed by the churning stream seems to end here in a
place of stillness and serenity surrounding a deep pool of clear water.  Even
the very air itself seems to obey the call to quiet.  The only exit is
northeast.

You see a machete here.

>get machete
Taken.

>ne

Flowing stream
The foliage parts at last to reveal a sparkling forest stream.  Light dapples
gently through the leaves to highlight slick, wet rocks and the bright green of
fresh growth.  The stream flows, about half a meter wide, from the north to the
southwest.

You see a hacked path leading northwest here.

>n

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot here.

>x spot
There is a spot here which is particularly moist and soft.

>dig
What do you want to dig in?

>spot
(with the machete)
The machete bites a nice hole in the earth.

>put acorn
(in the hole)
I don't see any acorn here.

>i
You are carrying:
   a perfect blue crystal
   a machete

>put crystal in soft spot
You can't put anything into the soft spot.

>put crystal in hle
I don't know the word "hle".

>put crystal in hole
There isn't much point to that.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a time machine and a hacked path leading south here.  Sitting on the
time machine platform is a wheelbarrow.

>push barrow ne

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot, a hole, and a wheelbarrow here.

>get acorn
Taken.

>plant acorn in hole
You put the acorn into the hole, and scoop the dirt over it, leaving a
noticeable little mound.

[ Your score just went up by 6 points. ]

>push barrow sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g
You push your way into the clearing, opening your usual path once again.  You
push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a time machine, a hacked path leading south, and a wheelbarrow here.

The divining rod vibrates, pulling to the northeast.

>put barrow on platform
Done.

>x rod
The divining rod vibrates, pulling to the northeast.

>note "well whaddayaknow, it works"
Noted.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The machine vibrates and heats up like a toaster oven.  A blinding light
envelops the machine, and it vanishes in a fancy puff of smoke, leaving only
the smell of ozone behind.

>undo
(Undoing one command)


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a time machine and a hacked path leading south here.  Sitting on the
time machine platform is a wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>push barrow ne

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

You see a wheelbarrow here.

>push barrow ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling and a wheelbarrow here.

>x sapling
The meter-high sapling looks a little intimidated by all the wood being sawed
and splintered nearby, but someone has taken the time to tie a bright ribbon to
its slender trunk, as a warning to be careful of harming it.  Good thing,
because it looks like it's going to be really gigantic one of these days.

>shake it
I don't know the word "shake".

>hold it
I don't understand that sentence.

>grab it
I don't know how to hold onto the sapling.

>tickle it
You can't tickle that.

>tickle me
You have never been able to successfully tickle yourself.

>yay
Glad you liked it!

>x ribbon
The ribbon is a reminder to the construction workers to be careful of the young
tree.

>take it
If you remove the ribbon, the sapling will be harmed by the construction
workers.

>push barrow ne

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  You can
walk around the house to the northwest and southwest.  You can go around the
driveway and find the road into town to the southeast.

You see a jug of miracle-grow and a wheelbarrow here.

>get jug
Taken.

>put it in barrow
Done.

>push barrow sw

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling and a wheelbarrow here.

>push barrow nw

Behind house
You are standing in what will be the back of your house.  If you thought it was
boring to look at before, you couldn't possibly be less enthusiastic about
seeing it now.  The wooden frame has gone up, but that is all there is to see. 
However, there is something new to see, a temporary workshed built by the
construction company.  The shed sits to the north.  You can walk around the
house to the northeast and southeast.

You see a wheelbarrow here.

>push barrow n

Outside workshed
The construction company has built a sturdy workshed on your property,
apparently for the convenience of storing materials and tools during the job. 
It is probably locked at night, but right now it is wide open.  You can enter
the shed to the north.  The back of the house is to the south, and you can hear
the work crew having lunch up in your driveway to the east.

You see a wheelbarrow here.

>get frisbee
Taken.

>push barrow n

Inside workshed
It's kind of hot and stuffy in here, during the heat of the day.  It is also
hard for your eyes to adjust to the darkness.  The materials that are locked in
here at night must all be in use right now, because the shed is basically
empty.  The only exit is south.

You see four jugs of miracle-grow and a wheelbarrow here.

A huge dog is sitting here.

>show frisbee to dog
The huge dog regards the frisbee with a keen canine interest.  He wags his tail
aggressively, his eyes locked on the frisbee.

>x frisbee
One of those little ones, for playing frisbee golf.

>throw frisbee
You throw the frisbee.  The huge dog tears off after it!  You hear his playful
barking disappear into the woods.

>put all jugs in barrow
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.

>push barrow s

Outside workshed
The construction company has built a sturdy workshed on your property,
apparently for the convenience of storing materials and tools during the job. 
It is probably locked at night, but right now it is wide open.  You can enter
the shed to the north.  The back of the house is to the south, and you can hear
the work crew having lunch up in your driveway to the east.

You see a wheelbarrow here.

>push barrow se
There is nowhere to go in that direction.

>push barrow s

Behind house
You are standing in what will be the back of your house.  If you thought it was
boring to look at before, you couldn't possibly be less enthusiastic about
seeing it now.  The wooden frame has gone up, but that is all there is to see. 
However, there is something new to see, a temporary workshed built by the
construction company.  The shed sits to the north.  You can walk around the
house to the northeast and southeast.

You see a wheelbarrow here.

>push barrow se

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling and a wheelbarrow here.

>push barrow se
There is nowhere to go in that direction.  The huge dog comes bounding up to
you and deposits the slobbery frisbee at your feet.  From somewhere nearby, you
hear a sharp whistle that gets the huge dog's attention.  A voice calls out,
"Blackie!  Here boy!"

The huge dog runs off.

>ha ha
I don't understand that sentence.

>ha
That's a real knee-slapper, all right!

>get frisbee
I don't see any frisbee here.

>l

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling and a wheelbarrow here.

>nw

Behind house
You are standing in what will be the back of your house.  If you thought it was
boring to look at before, you couldn't possibly be less enthusiastic about
seeing it now.  The wooden frame has gone up, but that is all there is to see. 
However, there is something new to see, a temporary workshed built by the
construction company.  The shed sits to the north.  You can walk around the
house to the northeast and southeast.

>n

Outside workshed
The construction company has built a sturdy workshed on your property,
apparently for the convenience of storing materials and tools during the job. 
It is probably locked at night, but right now it is wide open.  You can enter
the shed to the north.  The back of the house is to the south, and you can hear
the work crew having lunch up in your driveway to the east.

>n

Inside workshed
It's kind of hot and stuffy in here, during the heat of the day.  It is also
hard for your eyes to adjust to the darkness.  The materials that are locked in
here at night must all be in use right now, because the shed is basically
empty.  The only exit is south.

You see a frisbee here.

>s

Outside workshed
The construction company has built a sturdy workshed on your property,
apparently for the convenience of storing materials and tools during the job. 
It is probably locked at night, but right now it is wide open.  You can enter
the shed to the north.  The back of the house is to the south, and you can hear
the work crew having lunch up in your driveway to the east.

>s

Behind house
You are standing in what will be the back of your house.  If you thought it was
boring to look at before, you couldn't possibly be less enthusiastic about
seeing it now.  The wooden frame has gone up, but that is all there is to see. 
However, there is something new to see, a temporary workshed built by the
construction company.  The shed sits to the north.  You can walk around the
house to the northeast and southeast.

>se

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling and a wheelbarrow here.

>push barrow sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

You see a wheelbarrow here.

>g

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine and a wheelbarrow here.

>put barrow on platform
Done.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

A little alert bulb on the time machine flashes briefly.  Perhaps the machine
has a limited range, because nothing seems to happen.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  Sitting on the
time machine platform is a wheelbarrow.

>push barrow ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot, a little mound of dirt, and a wheelbarrow here.

>pour jugs on spot
jug of miracle-grow:  You shouldn't pour the thick liquid onto that.
jug of miracle-grow:  You shouldn't pour the thick liquid onto that.
jug of miracle-grow:  You shouldn't pour the thick liquid onto that.
jug of miracle-grow:  You shouldn't pour the thick liquid onto that.
jug of miracle-grow:  You shouldn't pour the thick liquid onto that.

>pour jugs on mound
jug of miracle-grow:  The liquid seeps into the mound of dirt with a nourishing
sigh.
jug of miracle-grow:  The liquid seeps into the mound of dirt with a nourishing
sigh.
jug of miracle-grow:  The liquid seeps into the mound of dirt with a nourishing
sigh.
jug of miracle-grow:  The liquid seeps into the mound of dirt with a nourishing
sigh.
jug of miracle-grow:  The liquid seeps into the mound of dirt with a nourishing
sigh.

[ Your score just went up by 8 points. ]

>full
In a total of 392 turns, you have achieved a score of 71 points out of a
possible 151, which means you are an adventurer.  You have earned the
following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
14 points for finding various items

>l

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot, a little mound of dirt, and a wheelbarrow here.

>push barrow sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g
You push your way into the clearing, opening your usual path once again.  You
push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south, a time machine, and a wheelbarrow here.

The divining rod vibrates, pulling to the northeast.

>put barrow on platform
Done.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push barrow ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot, a little mound of dirt, and a wheelbarrow here.

>g

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

You see a wheelbarrow here.

>push barrow n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

You see a wheelbarrow here.

>x shop
The sandwich shop is there, to the north, but it doesn't look like it's open
for business yet.  A sign on the shop says:  "Grand Opening in 1 Week!"

>x bank
This bank has been here as long as you can remember.  In fact, it's been around
even longer than that, because here it is, and open for business.

>x store
This little antique shop sits where the library will someday be.

>push barrow e

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a wheelbarrow here.

The merchant is here.

>note the merchant's reaction when you wheel in with that
I don't know the word "merchant's".

>this is someone who knows value when she sees it
I don't know the word "this".

>x antiques
The collection of antiques is disordered, and most of it doesn't look
important.  You think you might turn something up if you gave it a good search,
though.

>smell
This shop is pervaded by a rich, musty odor.

>search antiques
You find a metal suitcase, which you take.

>x it
It's a solid suitcase with a shiny aluminum case, capable of transporting a
volume of material securely.  The metal suitcase is closed.

>ask merchant about suitcase
The merchant says, "Ah yes.  That's quite a good metal suitcase."

>how much
I don't know the word "how".

>buy suitcase
Don't waste the merchant's time.  You don't have any money.

>drop suitcase
Dropped.

>put suitcase in barrow
Done.

>push barrow w

As you start to walk out the door, the merchant makes sure you're not taking
the metal suitcase with you.

The merchant says, "Sorry, that has to stay in the store."

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

You see a wheelbarrow here.

>push barrow e

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase and a wheelbarrow here.

The merchant is here.

>show barrow to merchant
The merchant gives it a quick once-over with her expertly trained eyeballs.

The merchant takes a glance at the wheelbarrow and says, "Could I ask you to
please take everything out of it?  I can't appraise it when it's carrying
things."

>empty barrow
You empty the wheelbarrow, and everything in it spills onto the ground.

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, a wheelbarrow, a crowbar, an old pillowcase, a
divining rod, a screwdriver, a car key, a bad shingle, a garage door opener,
the time machine manual, a package, a odd gadget, a cannonball, and five jugs
of miracle-grow here.

The merchant is here.

>search antiques
There's nothing else in the antiques.

>bah
I don't know the word "bah".

>grr
Whoops!  I hope that was supposed to happen.

>phooey
I don't know the word "phooey".

>show cannonball to merchant
The merchant gives the cannonball the once-over with her keen pair of eyeballs.

The merchant says, "Say, this cannonball is in good shape.  I'll give you $35
for it.  Deal?"

>y
The merchant tucks the cannonball away into a back room, then returns and hands
you the money.

The merchant says, "All righty.  Here you are.  Thank you."

>x merchant
She's a feisty old lady with sharp eyebrows.  Her deep-set green eyes have a
somewhat piercing power, as if they were her most-trained tool.

>x green eyes
She's a feisty old lady with sharp eyebrows.  Her deep-set green eyes have a
somewhat piercing power, as if they were her most-trained tool.

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, a wheelbarrow, a crowbar, an old pillowcase, a
divining rod, a screwdriver, a car key, a bad shingle, a garage door opener,
the time machine manual, a package, a odd gadget, and five jugs of miracle-grow
here.

The merchant is here.

>i
You are carrying:
   a perfect blue crystal
   a machete
   some money (35 dollars)

>x money
Money:  You have 35 dollars.

>sell barrow
(to the merchant)
The merchant gives it a quick once-over with her expertly trained eyeballs.

The merchant says, "Say, this wheelbarrow is as ancient as Methuselah.  I'll
give you $60 for it.  Deal?"

>>y
The merchant pulls the wheelbarrow over to one side of the shop and says, "All
righty.  Here you are.  Thank you."

>get crowbar
Taken.

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, an old pillowcase, a divining rod, a screwdriver, a
car key, a bad shingle, a garage door opener, the time machine manual, a
package, a odd gadget, five jugs of miracle-grow, and a wheelbarrow here.

The merchant is here.

>buy suitcase
The merchant says, "$45 for it.  Deal?"

>no
The mechant says, "Well, whatever.  Have a nice day."

>sw
There is nowhere to go in that direction.

>w

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>s
There is nowhere to go in that direction.

>sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>sw
You get all turned around in the dense forest growth and end up back where you
started.

>get on machine
Okay, you're now standing on the time machine platform.

>i
You are carrying:
   a perfect blue crystal
   a machete
   some money (95 dollars)
   a crowbar

>set dial to 4
It's already set to 4!

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>ne

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  You can
walk around the house to the northwest and southwest.  You can go around the
driveway and find the road into town to the southeast.

>ne
You can't walk across the newly-poured cement driveway.

>e
There is nowhere to go in that direction.

>sw

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>sw
There is nowhere to go in that direction.

>sw
There is nowhere to go in that direction.

>get on machine
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

You see a tire swing here.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>ne

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>open grate
(with the crowbar)

You pry up the sewer grating.  The sewer hole is now wide open.

>look in hole
In the sewer hole you see a five-dollar bill.

>get bill
Taken.

[ Your score just went up by 4 points. ]

>i
You are carrying:
   a perfect blue crystal
   a machete
   some money (100 dollars)
   a crowbar

>sw
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>open box
Opened.

>look in it
There's nothing in the mailbox.

>sw

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

You see a tire swing here.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>ne

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

You see a tire swing here.

>x tree
It's a whopper!

>x swing
It's a black rubber tire tied to a rope that's attached to a branch mid-way up
the tree, and suitable for swinging.

>untie rope
You can't untie the rope from down here on the ground.

>untie swing
It's too difficult to untie when it's dangling in the air.

>cut rope with machete
Hacking at the thick rope with the machete is unprofitable.

>i
You are carrying:
   a perfect blue crystal
   a machete
   some money (100 dollars)
   a crowbar

>u

Mid-way up tree
You are mid-way up the tree, which extends up another 15 feet.  A strong branch
here extends horizontally from the trunk.  You can climb even farther up from
here, or back down to the ground.

You see a thick rope (tied to a tire swing and to a strong branch) here.

>x branch
I see nothing special about the strong branch.

>untie rope
You untie the branch from the rope, and the rope and tire fall to the ground
with a thunk.

>d

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

You see a thick rope (tied to a tire) and a tire here.

>get rope
(first untying the rope from the tire)

You untie the rope from the tire.
Taken.

>get tire
Taken.

>u

Mid-way up tree
You are mid-way up the tree, which extends up another 15 feet.  A strong branch
here extends horizontally from the trunk.  You can climb even farther up from
here, or back down to the ground.

>u

Treetop
You're as high in the tree as your weight will let you climb.  The view from
here is incredible.  The window in the side of the house is right in front of
you to the north.

You are surprised and somewhat amused to see the rare book nestled within the
branches of the tree.  The squirrel must have been here recently.

>get book
You retrieve the book from the branches.

>x window
It's tantalizingly out of reach, but if you leap for it, you might just make
it.

>x view
I don't see any view here.

>throw tire at window
You take aim and heave the tire into the window.  It disappears inside.

>throw rope in window
You take aim and heave the thick rope into the window.  It disappears inside.

>jump to window
You make your leap of faith.  Your hands find a firm grip on the sill and you
pull yourself in.  Unfortunately, you drop all of your possessions in the
process.


Attic
This is a little attic space, barely tall enough for you to stand in.  Thick
boards run in parallel lines along the floor, with pink insulation laid out in
between.  A thick brass pipe passes up from the floor next to the window and
continues up through the ceiling.  Cardboard packing boxes of various sizes are
stacked along the walls.  A folded-up ladder attached to a hatch would lead
down if it were open, but it's closed.  The only exit is the little window you
came in.

You see a tire and a thick rope here.

[ Your score just went up by 10 points. ]

>tie rope to pipe
You tie the rope to the pipe.

>tie tire to rope
You tie the other end to the tire.

>drop tire out window
You throw tire out the window.  It comes to a yanking halt, the brass pipe
holding the rope taut.  Going down now might be safe.

>search insulation
That isn't important.

>x boxes
In the cardboard boxes you see a blue pencil and a desk lamp.

>search boxes
In the cardboard boxes you see a blue pencil and a desk lamp.

>get pencil
Taken.

>x lamp
This old desk lamp seems to be missing its power cord.  It would fit right in
with the other junk in the garage.

>point gadget at lamp
I don't see any gadget here.

>shoot
I don't know the word "shoot".

>l

Attic
This is a little attic space, barely tall enough for you to stand in.  Thick
boards run in parallel lines along the floor, with pink insulation laid out in
between.  A thick brass pipe passes up from the floor next to the window and
continues up through the ceiling.  Cardboard packing boxes of various sizes are
stacked along the walls.  A folded-up ladder attached to a hatch would lead
down if it were open, but it's closed.  The only exit is the little window you
came in.

You see a rope (tied to the brass pipe) here.

>open ladder
You can't open the hatch ladder from inside the attic.  You have to pull it
open from below.

>out
There is nowhere to go in that direction.

>climb out
What do you want to get out of?

>climb out window
You're too high up to jump down from here.  You'll have to find safe way to
climb down to the ground.

>climb rope
You shimmy down the rope.  After a few feet, your hands lose their grip and you
plummet.  Fortunately, the tire breaks your fall.


Dangling in the air
You are dangling on the tire swing about eight feet off the ground.  The window
is about 20 feet above you.  Apart from feeling a little foolish, you're doing
all right.  You can safely jump down from here, or climb up to the attic.

[ Your score just went up by 1 point. ]

>d
You leap from the tire swing and land with cat-like grace.  A clumsy, two-
legged cat, but there you go.


South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

You see a perfect blue crystal, a machete, some money (100 dollars), a crowbar,
and a rare book here.

>get all
tiny window:  It's too far away.
wall:  It's fixed in place.
beautiful tree:  It's fixed in place.
perfect blue crystal:  Taken.
machete:  Taken.
some money (100 dollars):  You put the money into the South of house along with
the rest of it.  Taken.
crowbar:  Taken.
rare book:  Taken.

>x wall
You always thought that the wall on this side of the house would make a great
place to hide a secret door.  Again, you are reminded of your lack of
foresight.  If there were a door here, you could get in that way.

>knock on wall
You knock on the wall.  It sounds solid.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you.  The world around you spins into a wild vortex that suddenly
vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>ne

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>hi laura
Laura smiles and says, "Good morning.  How can I help you?"

>ask laura about new account
Laura asks, "Yes, would you care to open a new account?"

>>yes
Laura says, "Okay.  We require a minimum deposit of $100 in order to open your
account.  Is that all right?"

>>yes
Laura smiles and says, "Okay, you're all set.  Your PIN number will be 1234. 
Thank you!"

[ Your score just went up by 7 points. ]

>x laura
Laura is a short woman in a dark suit.  She looks benevolent and patient, and
seems pleased to meet you.

>ask laura about laura
Laura says, "Oh, my life's pretty boring.  Grew up, started working here right
after college.  Blah blah blah.  Still no idea what I want to do with my life! 
I've got plans, though.  Gotta have plans."

>tell laura about time travel
You tell Laura what you know about the time travel, but it doesn't amount to
much, and the conversation sort of ends there.

>l

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>n

At the Teller window
The teller stands ready at the window, with a polite but grim expression.

The bank teller is standing behind the teller window.

The teller says, "Good morning.  Would you care to make a deposit or a
withdrawal today?"

>>deposit

The teller says, "A deposit.  Very good."  He punches some numbers on his
computer.  "How much will you be depositing today?"

$>100
The teller says, "Very good."

The teller takes the money and fiddles with his computer for a moment.  The
teller says, "You currently have 200 dollars in your account."

The teller says, "Have a nice day."

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>withdraw
What do you want to withdraw?

>make withdrawal
(first approaching the teller window)
The teller says, "A withdrawal.  Very good."  He punches some numbers on his
computer.  "Oh, I'm sorry.  You can't make any withdrawals at this time due to
a computer error."

The teller says, "Have a nice day."

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>wtf
I don't know the word "wtf".

>e

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 5
Okay, it's now turned to 5.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>ne

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>open box
The mailbox is already open!

>x it
The mailbox is open.  There's nothing in the mailbox.

>close mailbox
Closed.

>l

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>ne
There is nowhere to go in that direction.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>n

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>i
You are carrying:
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a rare book

>n

In the sandwich shop
The room is painted a gaudy yellow color.  On closer inspection, it is merely
spattered with mustard stains.  That's the kind of shop this is, I guess --
heavily frequented because it's the only one nearby.  There's a counter, a
menu, a big advertisement, and a row of tables and chairs.  The door is to the
south.

Fred, the sandwich guy, is standing at the counter.

Fred says, "Hey there.  How can I help you?"

Fred is cleaning some utensils.

>hi fred
Fred smiles.  "Hello once again.  Can I get you something?"

Fred is cleaning some utensils.

>show crystal to fred
Fred isn't impressed.

>s

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>sw
There is nowhere to go in that direction.

>s

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>sw
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>sw

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you.  The world around you spins into a wild vortex that suddenly
vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>get off
(the time machine platform)
Okay, you're no longer on the time machine platform.

>ne

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>ne

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>ne
There is nowhere to go in that direction.

>n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>e

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, an old pillowcase, a divining rod, a screwdriver, a
car key, a bad shingle, a garage door opener, the time machine manual, a
package, a odd gadget, five jugs of miracle-grow, and a wheelbarrow here.

The merchant is here.

>get gadget
Taken.

>get shingle
Taken.

>x jugs
jug of miracle-grow:  There's nothing in the jug of miracle-grow.
jug of miracle-grow:  There's nothing in the jug of miracle-grow.
jug of miracle-grow:  There's nothing in the jug of miracle-grow.
jug of miracle-grow:  There's nothing in the jug of miracle-grow.
jug of miracle-grow:  There's nothing in the jug of miracle-grow.

>w

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>hi laura
Laura smiles and says, "Good morning.  How can I help you?"

>show crystal to laura
Laura isn't impressed.

>ask laura about crystal
Laura says, "I'm afraid you'll have to ask someone else."

>i
You are carrying:
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a rare book
   a odd gadget
   a bad shingle

>show book to laura
Laura says, "It takes all kinds, I guess.  I mean, I don't know anyone who'd be
interested in pictures of rodents doing the nasty."

>w
There is nowhere to go in that direction.

>e
There is nowhere to go in that direction.

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>e

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>set dial to 5
Okay, it's now turned to 5.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>nw

Behind house
You are standing in what will be the back of your house.  If you thought it was
boring to look at before, you couldn't possibly be less enthusiastic about
seeing it now.  The wooden frame has gone up, but that is all there is to see. 
However, there is something new to see, a temporary workshed built by the
construction company.  The shed sits to the north.  You can walk around the
house to the northeast and southeast.

>n

Outside workshed
The construction company has built a sturdy workshed on your property,
apparently for the convenience of storing materials and tools during the job. 
It is probably locked at night, but right now it is wide open.  You can enter
the shed to the north.  The back of the house is to the south, and you can hear
the work crew having lunch up in your driveway to the east.

>e

North of house
You are standing on what will be the north side of your house.  The house is
currently under construction.  The wooden frame has gone up, and the driveway
is currently being poured, but apart from that, there's not much to see.

A bunch of workers are here, having a lunch break.  A temporary workshed is to
the west, and you can walk around the house to the southeast and southwest.

>x lunch
Everyone seems to be eating something tasty and refreshing.

>ask workers about lunch
The workers are all much too busy eating to pay attention to you.

>s

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>u

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The architect is here.

>show shingle to architect
He takes the bad shingle and then looks at it with alarm.  "Oh my goodness! 
This is the type of shingle we were planning to use, but it's obvious that we
need to use something of better quality.  I'll make sure to talk to the roofers
about this."

[ Your score just went up by 4 points. ]

>d

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>s

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.

[ Your score just went up by 5 points. ]

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>x roof
I don't see any roof here.

>x hole
I don't see any hole here.

>note "what is my problem?"
Noted.

>x splinters
They are moist from recent rains, but otherwise unremarkable.

>x rain
It is a grey drizzle.

>x clouds
The sky is overcast, a solid sheet of iron gray and pallid white.  The moon is
a silver sliver barely visible through the clouds near the horizon.  The sun is
a white circle nearing the opposite horizon.

>cool
I don't know the word "cool".

>l

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>x tree
The tree is crippled and broken, a burnt shadow of its once towering presence.

>climb it

Mid-way up tree
You are mid-way up the tree, or what used to be.  The broken top half of the
trunk extends at a slight vertical angle, the top branches poking into the
broken house.  You can climb back down to the ground.  More dangerously, you
can shimmy north along the slick, broken trunk that leads into the open attic
of the house.

>shimmy north
Testing it with gentle pressure, the trunk seems solid and steady, enough for
you to believe that it will hold.  Fearlessly, for the moment, you straddle
your legs around the broken base of the horizontal trunk, and begin to scoot
yourself forward.

Along the trunk
The trunk is slicker than you thought, and the ground is farther away, a wet
gray mass that will not be a comfortable landing should you fall.  At this
point, the base of the tree is still nearby, so after a few deep breaths to
collect yourself, you feel secure enough to continue.

>shimmy forward
I don't understand that sentence.

>shimmy 
As you shimmy forward, you start to lose your balance.  In a moment of utter
panic, you lean forward and grab the trunk with both hands, seizing it fast
until you assure yourself that you are finally stable.  Still, your head spins,
and you can't quite trust your sense of equilibrium.

Farther along the trunk
You have made your way about five feet along the trunk towards the attic.  Your
distorted sense of equilibrium is starting to induce a sense of fear, because
at any odd moment you feel as if you are starting to pitch to one side or the
other.  Holding fast, you remind yourself that you are not losing your balance,
but are only fearing that you might.  If you go just a bit farther, you will be
halfway there.  Seeing this boosts your courage.

You have dropped all of your possessions.

>i
You are holding onto the trunk with both hands.  You are empty-handed.

>shimmy north
You grit your teeth and loosen up your muscles.  Being tense isn't going to
help you if you start to totter.  You move an inch or so, releasing the grip
with your legs and then clamping them tight again.  Gradually, your confidence
returns.  You see the midway point ahead of you.

Rain is slicking your eyes, but you don't feel confident letting go with one
hand long enough to wipe the drops away.  You scoot forward again.  A salty
taste trickles into the corner of your mouth, and you realize that it's not
rain on your face, but sweat.  Spitting it out, you keep your eye on the goal: 
the halfway point.  You ignore the still-distant attic, and above all you
ignore the ground.

Point of no return
You realize now that you have reached the point of no return.  You are just a
little short of the halfway point, and to go forward any more will mean
committing to the rest of the crawl.  The safety of the tree will be too far
behind you to risk moving backwards.

>x attic
You stare at your ultimate goal, the opening into the attic, for a long moment.
It doesn't seem so very far away.  Something about shimmying along the trunk
feels vaguely exciting, like something you would have done as a child without
thinking twice.

>x ground
You look at the ground, at the base of the tree, for the first time in many
minutes.  You see nothing unusual, but vertigo overtakes you when you see the
great distance to the ground.  Instinctively, you shut your eyes to block out
the sight, but as soon as you shut them your sense of equilibrium completely
fails you.  Are you slipping?  You wrap your limbs completely around the tree
again, unable to look, but you feel your body sagging to one side, your weight
rotating around the slickened bark of the tree.  Panicking, you squeeze tighter
and tighter, but you are unable to find friction enough to stop your movement.

A sudden twang of reptile-brain fear opens your eyes and puts you into full,
unthinking panic.  Your body has shifted, and you are starting to fall off the
tree.  Your fingernails search for a hold, your legs clamp as if to snap the
trunk in two, but you can't hang on much longer.

Hanging for dear life
You are hanging for dear life, with your body slipping around the trunk of the
tree.  Soon you'll be upside down, trying to support your weight with atrophied
muscles, with fingers that can't find a grip on waterlogged bark.

You feel your body shift again.

>u
You strain your over-tensed, over-taxed muscles, desperately trying to find
some leverage, some way of making it back upright, back on top of the branch. 
You find you cannot.  Every effort you make, effort to the point of snapping
your super-taut tendons, only serves to increase your pain, your desperation,
and your chances of falling any second now.

You feel your body shift again.

>relax
Against all of your instincts, you relax your muscles.  This is not easy to do,
but it seems to help.  You ease up, but you do not fall.  In fact, you seem to
halt and hold steady, not slipping any more -- at least for the moment.

You take a deep breath.  Maybe you can make it out of this.

>climb up
(the broken trunk)
Your relaxed muscles seem willing to put in a renewed effort.  Your relaxed
mind takes an extra second to figure out how best to do this.  You're going to
need to let go of one arm and place it differently, so that you have the
leverage and strength to pull your upper body up and around.

You adjust your legs, locking your feet together so that you can trust them to
hold you.  You lengthen your arms, then pull as hard as you can, lifting your
chest to meet the trunk.  Then, fully aware of the gamble you are taking, you
release your left arm and swing it around from the far side of the trunk to the
nearer, so that your upper body is all on the same side.  You haven't fallen
yet.  You take another breath.

>u
You pull as hard as you can with your arms, and strain forward with your chin,
almost using it as a third hand on a patch of firm bark.  With fast, forward
slaps, you move each hand a little farther, and pull again.  You get your chin
up to the top of the branch, and take another short breather.

>u
You rotate your left arm back again.  Finding steady grips, you give the
muscles that pull a needed break and use the ones that can push, lifting your
torso up.  You relax your locked legs, allowing them to rotate, your hips
following your upper body.  Not wanting to lose the progress so far, you lean
forward and clamp the trunk more tightly again, and cinch your legs around an
inch at a time.

Before you know it, you are completely on top of the trunk again.  Too tired,
and still too short of the attic to be completely ecstatic, you take a rest. 
Finally, bravely, you push back up to a sitting position.

End of the trunk
You are almost there.  You can nearly touch the ragged sides of the house wall
to your left.  Inside, you can see the floorboards.  Receded far into the
shadows, you see the attic ladder, and that it is open.  Just a little farther,
and you can go in, you can go down, you can be inside your house, safe.

>x attic
You are almost there.  You can nearly touch the ragged sides of the house wall
to your left.  Inside, you can see the floorboards.  Receded far into the
shadows, you see the attic ladder, and that it is open.  Just a little farther,
and you can go in, you can go down, you can be inside your house, safe.

>enter
Slowly, slowly, with painstaking care, you shift your weight forward on the
thin, drooping upper branches, until you see attic floorboards beneath you
instead of open air.  Gingerly, you stretch a foot down, but just as your toe
makes contact, the branch in your right hand, which was holding your weight and
steadying your balance, snaps.  You hurtle yourself forward into a roll,
desperate to get your mass moving inward instead of outward.

Amid a tangle of crackling and snapping noises; none of them your bones,
fortunately; you find yourself, scratched but safe, inside the attic of your
house.  You crawl another foot away from the gaping opening before your fear of
falling abates enough to allow you to stand up.  You're safe.


Attic
A little attic space, once barely tall enough for you to stand in, now has a
huge, gaping hole raked open in the roof and the southern wall.  Silvery
rivulets of rain water drizzle down from above, pooling in the uneven
floorboards.  The twisted top of the tree provides a gnarled support structure
for the damaged roof.  The jagged, splayed ends of a thick brass pipe jut up
through the floor.

There is a monkey wrench lying lengthwise here, spanning the gap between two
floorboards.  A ladder attached to a hatch leads down into the darkened house
below.

You hear a car pull into your driveway outside.

>get wrench
It's a spanner, but you take it.

You hear the car engine turn off and three doors open and shut, and a female
voice issuing orders that you can't quite hear clearly.

>listen
You hear three people talking in the driveway.

>d
You descend the hatch ladder.


Upstairs hallway
You are in the upstairs hallway, but it has been desecrated nearly beyond
recognition.  The once pristine white carpeting has been stained and burned,
and a section of it has been torn up, revealing the shredded matting
underneath.  The walls have been spraypainted with unreadable graffiti,
shocking swirls of black and silver paint.  A fist sized hole has been smashed
into the east wall, and the light fixture in the ceiling has been torn out,
leaving gangly dangling wires and a darkness that oppresses.  The hatch ladder
leads back up into the attic.  A rickety staircase leads down to the bottom
floor.  To the east is the upstairs bathroom, and a bedroom is to the south.  A
smaller bedroom is north.

Perhaps it is just as well that the lights are out, as they would only
illuminate more ugliness, perhaps more than you could bear.

>e
(Opening the small door)

Upstairs bathroom
This is a hideous scene of waste and ruin.  It looks as if someone took a
sledgehammer to the place, destroying the tub and breaking tiles off the walls.
The sink has been ripped out, it is gone.  Someone attempted to do the same to
the toilet, leaving it yanked out at an angle but still attached to the floor. 
Swimming in the bowl is a foul brackish that fills the room with a rancid
stench.  The mirror above the sink area is cracked but still attached by its
hinges to the medicine cabinet behind it.  A broken window looks out into the
front yard.  The only exit is west, back into the hallway.

>x mirror
It's attached to the medicine cabinet.

>open it
The medicine cabinet is already open!

>look in it
You see a cracked reflection of yourself.

>look in cabinet
There's nothing in the medicine cabinet.

>look out window
Outside you see the front of the house.  Parked in the driveway is a dark
sedan.

>x sedan
You'll have to go outside to get a close look at it.

>w

Upstairs hallway
You are in the upstairs hallway, but it has been desecrated nearly beyond
recognition.  The once pristine white carpeting has been stained and burned,
and a section of it has been torn up, revealing the shredded matting
underneath.  The walls have been spraypainted with unreadable graffiti,
shocking swirls of black and silver paint.  A fist sized hole has been smashed
into the east wall, and the light fixture in the ceiling has been torn out,
leaving gangly dangling wires and a darkness that oppresses.  The hatch ladder
leads back up into the attic.  A rickety staircase leads down to the bottom
floor.  To the east is the upstairs bathroom, and a bedroom is to the south.  A
smaller bedroom is north.

>d
You descend the staircase.

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

>e
You'll have to open the front door first.

>open door
The outside of the door has been nailed shut with boards and cannot be opened.

>pry boards
What do you want to pry it with?

>crowbar
I don't see any crowbar here.

>i
You are carrying:
   a monkey wrench

>pry boards with wrench
I don't see any boards here.

>w

Dining room
The dining room, which you had recently converted into a study area, has been
kicked around and spraypainted in a similar fashion to the other rooms in the
house, but the large table remains standing where you left it.  Piled upon it
are empty cans and bottles, and its surface is mottled with cigarette burns and
knife marks.  A bookcase that stood in the southern corner of the room is
missing, but a pile of yellow, water-damaged books remains in its place,
underneath more trash.  Two large windows face west out to the back yard.  The
fireplace, too, is cluttered with debris.  The kitchen is east, and the living
room is to the south.  A doorway at the southeast corner of the room leads to
the foyer.

>x bookcase
It is no longer here.

>x books
The books have been water-damaged and are all worthless.  You sadly recognize
them as your own collection.

>x windows
Through them you see west out into the back yard.

>x fireplace
The fireplace is cluttered with debris.

>enter fireplace
That isn't important.

>s

Living room
The first thing you notice is that your television set is still here, which
seems ironic because you never used to watch it and were planning on giving it
away.  The tv set is no longer on a stand, it sits against the northern wall
under a stack of pizza boxes that emit a rude odor.  A stained and beaten
couch -- not your own -- sits to the south, facing the television set.  Some of
its cushions are missing, but it doesn't look as if it were particularly
comfortable even in its prime.  Bent and twisted blinds hang over the west-
facing windows.  The dining room is north, and a doorway into the hallway is
east.

>x tv
It's not a particularly great television set.  It's got a 13 inch screen, and
some buttons on the front to change the channels and volume and such.  A cord
runs out the back.  The thin brown cord is plugged into the wall socket.

>unplug it
You unplug the television set from the wall socket.

>get it
Taken.

>x pizza boxes
As you near the pizza boxes, they suddenly shift.  With a violent surge, more
cockroaches than you care to count run crazy out of the boxes in all
directions.  Within seconds, they have all disappeared again into various nooks
and crannies of the room.

>x roaches
Those aren't important.

>ne
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>e

Downstairs hallway
The hallway is dark and feels cramped due to the collected refuse that has
built up along the wall.  Graffiti covers every flat surface, as usual.  There
is no sign of the photographs that used to hang here.  The foyer is north, and
a doorway into the living room is west.  The master bedroom is to the south.  A
small door leads east into a half bathroom.

>x graffiti
The graffiti covers the walls.  It is the markings of territorial youth,
strange symbols and stylized lettering.  What little of it makes sense to you
is obscene.

>read it
The graffiti covers the walls.  It is the markings of territorial youth,
strange symbols and stylized lettering.  What little of it makes sense to you
is obscene.

>e
(Opening the small door)

Half bathroom
The bathroom is tiny and dark, but the sink, the toilet and the mirror seem to
be intact and in place.  A number of magazines lie in lopsided piles on the
floor.  The only exit is west, back into the hallway.

>x magazines
They're pornographic magazines of a somewhat unsavory variety.

>x toilet
There's nothing in the toilet.

>flush it
The plumbing no longer works.

>x sink
That isn't important.

>read magazines
Those aren't important.

>w

Downstairs hallway
The hallway is dark and feels cramped due to the collected refuse that has
built up along the wall.  Graffiti covers every flat surface, as usual.  There
is no sign of the photographs that used to hang here.  The foyer is north, and
a doorway into the living room is west.  The master bedroom is to the south.  A
small door leads east into a half bathroom.

>s

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
foyer is north through the hallway, and the master bathroom is to the east.

>x dresser
The large dresser that used to stand in the southeast corner of the room has
been toppled over.

>push it
Pushing the dresser doesn't do anything.

>pull it
Pulling the dresser doesn't have any effect.

>lift it
It's fixed in place.

>x linens
I don't see any linens here.

>x curtains
I don't see any curtains here.

>x window
I don't see any window here.

>l

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
foyer is north through the hallway, and the master bathroom is to the east.

>e

Master bathroom
This bathroom looks like it has been used as a place to party, in the
vernacular.  Various paraphernalia having to do with drug abuse is in evidence,
such as little plastic baggies, discarded needles, and the like.  It is a
shocking and somewhat depressing sight, to say the least.  The only exit is
west, back into the bedroom.

>x needles
You don't want to have anything to do with those.

>x toilet
There's nothing in the toilet.

>flush it
The plumbing no longer works.

>w

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
foyer is north through the hallway, and the master bathroom is to the east.

>n

Downstairs hallway
The hallway is dark and feels cramped due to the collected refuse that has
built up along the wall.  Graffiti covers every flat surface, as usual.  There
is no sign of the photographs that used to hang here.  The foyer is north, and
a doorway into the living room is west.  The master bedroom is to the south.  A
small door leads east into a half bathroom.

>n

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

>n

Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

>x able
I don't know the word "able".

>x table
The small kitchen table has been overturned in the western corner of the room. 
Windows look out west and east to the back and front yards.

>lift it
That isn't important.

>x front
I don't see any front here.

>x front yard
I don't see any front yard here.

>x back yard
I don't see any back yard here.

>x window
You see west out into the back yard and east into the corner of the driveway
where it curves around to the front of the garage.  Parked in the driveway is a
dark sedan.

>l

Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

>open door
As you reach for the door, you hear a thump and a crash from the other side of
it.

You are startled to see a staggering, red-eyed man with a bloated gut and ill-
fitting clothes burst in from the garage before you can open the door.  He
regards you warily, as if you are trespassing on his territory.

"What are you doing here?  Get out, go away!" he says, his voice a sooty croak.
You are horrified when you recognize that this is Fred, the man from the
sandwich shop.  Your instinct is to let him be, whatever he thinks his business
here is.

>fred
There's no verb in that sentence!

>hi fred
I don't see him here.


Fred, a hungry look darkening his features, leaves the kitchen in a boozy
version of a hurry.  You hear bits of trash being kicked around in the foyer at
the bottom of the staircase.

>undo
(Undoing one command)


Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

Fred is here, woozing back and forth on his fat legs.

>x fred
Fred looks haggard and unruly.  His always-friendly smile is gone, replaced by
a largely toothless sneer.  His got a pudgy frame now has a gigantic, round
gut, and his once dark eyebrows are a twizzled grey.  He hasn't shaved in a
long time, and the twinkle behind his eyes has gone dark.


Fred, a hungry look darkening his features, leaves the kitchen in a boozy
version of a hurry.  You hear bits of trash being kicked around in the foyer at
the bottom of the staircase.

>undo
(Undoing one command)


Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

Fred is here, woozing back and forth on his fat legs.

>fred, hello
Fred says, "Who are you?  Go away!"


Fred, a hungry look darkening his features, leaves the kitchen in a boozy
version of a hurry.  You hear bits of trash being kicked around in the foyer at
the bottom of the staircase.

>undo
(Undoing one command)


Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

Fred is here, woozing back and forth on his fat legs.

>hi fred
I don't see him here.


Fred, a hungry look darkening his features, leaves the kitchen in a boozy
version of a hurry.  You hear bits of trash being kicked around in the foyer at
the bottom of the staircase.

>s

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

Fred is here, woozing back and forth on his fat legs.

Fred struggles up the stairs.  You hear some muttering and cursing, and then a
pause, and then some more muttering.

"It's here somewhere," you hear him say.

>u
You ascend the staircase.

Upstairs hallway
You are in the upstairs hallway, but it has been desecrated nearly beyond
recognition.  The once pristine white carpeting has been stained and burned,
and a section of it has been torn up, revealing the shredded matting
underneath.  The walls have been spraypainted with unreadable graffiti,
shocking swirls of black and silver paint.  A fist sized hole has been smashed
into the east wall, and the light fixture in the ceiling has been torn out,
leaving gangly dangling wires and a darkness that oppresses.  The hatch ladder
leads back up into the attic.  A rickety staircase leads down to the bottom
floor.  To the east is the upstairs bathroom, and a bedroom is to the south.  A
smaller bedroom is north.

Fred is here, woozing back and forth on his fat legs.

In a raspy voice Fred mutters, "I'll find it -- I'll find it.  Gotta find it!"

>x fred
Fred looks haggard and unruly.  His always-friendly smile is gone, replaced by
a largely toothless sneer.  His got a pudgy frame now has a gigantic, round
gut, and his once dark eyebrows are a twizzled grey.  He hasn't shaved in a
long time, and the twinkle behind his eyes has gone dark.

In a raspy voice Fred mutters, "I'll find it -- I'll find it.  Gotta find it!"

>x hole
The hole looks like it was made by a fist striking the wall.

In a raspy voice Fred mutters, "I'll find it -- I'll find it.  Gotta find it!"

>look in hle
I don't know the word "hle".

>look in hole
For a moment, you are reluctant to put your hand down into the hole, cautious
about what you might find.  With care, you slip your hand in.  You find a
bottle of cheap liquor, which you take.

In a raspy voice Fred mutters, "I'll find it -- I'll find it.  Gotta find it!"

Fred glares at you with sunken, bloodshot eyes.  "I knew it!  Stay out of my
stuff, you thief!"  He grabs the bottle from you and takes a long suck at it. 
"And stay outta my house!"  Emitting a smelly belch, he shambles off.

Fred stumbles violently down the stairs, clutching the banister with his free
hand for support.  You hear his footsteps disappear out the back door into the
garage.

>follow fred
I don't see any fred here.

>d
You descend the staircase.

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

>n

Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

>n

In the garage
This room is a stinking mess, in a totally new and horrible way than the mess
you were used to.  A soiled mattress is lumped into one corner, surrounded by
filth and discarded bottles.  A door leads south into the kitchen.  The garage
door is to the north is open.

Fred is here, sitting on a soiled mattress.

>hi fred
I don't see him here.

>hi future fred
Fred says, "Who are you?  Go away!"

>ask fred about fred
Fred says, "So you 'knew me when', eh?  Bought my sandwiches, gave me a smile
and a wave.  Well, that guy's gone.  I'll never see him again."

He goes quiet for a minute, then says, "Don't talk to me about the past.  You
can't change the past!  You can't change anything.  Ah, just leave me be,
willya?  Go on, get out."

>ask fred about me
Fred squints at you for a long moment, trying to get his eyes to focus.  "You
look...  <hic> dissidently familiar."  He grunts and turns away.  "But I dunno
you.  Go away already."

>i
You are carrying:
   a monkey wrench
   a television set

>show tv to fred
Fred isn't impressed.

>show wrench to fred
Fred isn't impressed.

>l

In the garage
This room is a stinking mess, in a totally new and horrible way than the mess
you were used to.  A soiled mattress is lumped into one corner, surrounded by
filth and discarded bottles.  A door leads south into the kitchen.  The garage
door is to the north is open.

Fred is here, sitting on a soiled mattress.

>tell fred about fred
You tell Fred what you know about Fred, but it doesn't amount to much, and the
conversation sort of ends there.

>open garage door
It's already open.

>n

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

You are the focus of the surprised attention of three people in dark suits, a
woman and two rather large men.  She walks directly toward you, leaving the men
to take up imposing stances by the dark sedan parked in your driveway.

The woman is the biggest surprise.  Twenty years older, but still trim and
lovely, you recognize her immediately as Laura, the new accounts clerk at the
bank.  She recognizes you, too, as it happens, but not for the same reason.

"I was going to ask you who you are and what you're doing here, but I see that
I don't need to.  I recognize you quite well from my files.  And yet, still we
have a mystery on our hands, hmm?  My question is, why haven't you aged a day
in the last twenty years?"

She approaches you and puts her hand to your face.  You feel her manicured
nails at the ends of her cold, steely fingers.  She moves your head gently from
side to side, assessing your features.

"The long-lost owner of the house, reported missing ten years ago, arrives
unannounced, out of the blue, on the eve of final foreclosure.  Coincidence?" 
She aims the question to Carl and Victor, who wear impenetrable, goon-like
stone faces.  "Tomorrow we raze the property, and here you are, obviously
snooping around.  Here's my question.  What's inside that's so important?  What
did you need to rescue before we hauled it all away to scrap heaps and the city
dump?"

She paces from left to right and back again, still taking in your features.

"I'll be back later, and you had better not be here.  Carl, Victor?  Get the
car.  Let's go."

With that, the three of them turn the backs of their tailored jackets to you
and walk away.  You hear three car doors open and slam shut, and see a dark
sedan drive away through the drizzling rain.

>x car
I don't see any car here.

>l

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

>u
You climb gingerly up the stone wall.

North roof
You stand gingerly on the north end of the roof, one hand on the chimney for
support.  The shingles under your feet are solid and in very good shape, and
they seem to have kept the fire from spreading.  However, it is still extremely
precarious to stand here because of the damage to the south end of the roof. 
The stone wall of the chimney leads back down.

>s
You can't walk that way, because the tree has collapsed the south end of the
roof.

>x tree
The damage is severe.  A violent, gaping hole has been smashed open by the tree
trunk, splitting open the entire southern roof like a troll's axe through a
soft elven skull.  Drizzly rain leaks down the black, splintered edges.

>d
You climb gingerly down the stone wall.

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

>e

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

You see a newspaper here.

>e

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

There's something in your mailbox.

>x mailbox
The mailbox is open.  In the mailbox you see a ATM card.

>open it
The mailbox is already open!

>get card
Taken.

[ Your score just went up by 2 points. ]

>x it
It is your personal automated teller machine card.

>e

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal automated teller machine (ATM).

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>n

Locksmith shop
A sign inside says, "Going out of business - Free stuff."  Most everything has
been taken already.  The only exit is south.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>s

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal automated teller machine (ATM).

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>x sign
The sign in the locksmith shop reads, "Going out of business - Free stuff."

>x atm
The automated teller machine has a slot, a display, and a numeric keypad.

>x pad
It has the numbers 0 through 9 and a CANCEL button.

>put card in slot
The display reads:  Please type your PIN number or push CANCEL.

>type 1234
(on the keypad)
The machine whirs for a few moments of mechanical thought.

The display reads:  Type 1 to make a deposit, type 2 to make a withdrawal, type
3 to check your current balance, or push CANCEL to end this transaction.

>type 2
(on the keypad)
The display reads:  Please type the amount to withdraw, in multiples of $20.

>type 3
(on the keypad)
The display reads:  Incorrect entry.  Please type the amount to withdraw, in
multiples of $20.

>type 400
(on the keypad)
The machine whirrs and clacks.  Finally, it spits out $400, which you take.

The display reads:  Would you care to make another transaction?  Type 1 for
yes, CANCEL to end.

>type 1
(on the keypad)
The display reads:  Type 1 to make a deposit, type 2 to make a withdrawal, type
3 to check your current balance, or push CANCEL to end this transaction.

>type 3
(on the keypad)
The display reads:  You currently have 7218 dollars in your account.

Type 1 to make a deposit, type 2 to make a withdrawal, type 3 to check your
current balance, or push CANCEL to end this transaction.

>push cancel
The display reads:  Thank you for using VistaBank!

The machine spits out your ATM card, which you take.

>i
You are carrying:
   a monkey wrench
   a television set
   some money (400 dollars)
   a ATM card

>s
There is nowhere to go in that direction.

>sw
There is nowhere to go in that direction.

>e
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>l

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal ATM.

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>w

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>w

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

You see a newspaper here.

>sw

Front of house
This is the front your house, and something is terribly wrong.  The front door
is boarded up, sealing off all entrance to what should still be your home.  The
roof is crippled by the weight of a fallen tree, and all of the front windows
are cracked.  Sopping mounds of rotting leaves that have collected along the
edges and corners indicate years of neglect.  A pool of dirty yellow water
trickles down from the driveway and collects, full of black silt, near the
front door.  The driveway is to the northeast, and a clearing is visible far to
the southwest.  The front door is to the west.

>sw

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a blue pencil, a perfect blue crystal, a machete, a crowbar, a rare
book, and a odd gadget here.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a blue pencil, a perfect blue crystal, a machete, a crowbar, a rare
book, and a odd gadget here.

>get all
wall:  It's fixed in place.
blue pencil:  Taken.
perfect blue crystal:  Taken.
machete:  Taken.
crowbar:  Taken.
rare book:  You've already got your hands full.
odd gadget:  Taken.

>i
You are carrying:
   a monkey wrench
   a television set
   some money (400 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget

>drop wrench
Dropped.

>i
You are carrying:
   a television set
   some money (400 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget

>l

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a rare book and a monkey wrench here.

>get book
Taken.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>sw

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>ne

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>n

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>put book in slot
You return the rare book to the library.  It slides down the slot and out of
view.

>s

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>sw

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>i
You are carrying:
   a television set
   some money (400 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>ne

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>n
There is nowhere to go in that direction.

>ne
There is nowhere to go in that direction.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>n

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>n

In the sandwich shop
The room is painted a gaudy yellow color.  On closer inspection, it is merely
spattered with mustard stains.  That's the kind of shop this is, I guess --
heavily frequented because it's the only one nearby.  There's a counter, a
menu, a big advertisement, and a row of tables and chairs.  The door is to the
south.

Fred, the sandwich guy, is standing at the counter.

Fred says, "Well, if it isn't my favorite repeat customer."

Fred is cleaning some utensils.

>buy hot sandwich
You hand Fred five dollars, and he hands you the sandwich.

Fred says, "Thank you.  Come again."

Fred is cleaning some utensils.

>i
You are carrying:
   a television set
   some money (395 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget
   a hot meatball sandwich
   a paper napkin

Fred whistles a half-remembered melody.

>s

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>s

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>sw

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>ne

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

>ne

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

>e

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

>n

In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>n

In the sandwich shop
The room is painted a gaudy yellow color.  On closer inspection, it is merely
spattered with mustard stains.  That's the kind of shop this is, I guess --
heavily frequented because it's the only one nearby.  There's a counter, a
menu, a big advertisement, and a row of tables and chairs.  The door is to the
south.

Fred, the sandwich guy, is standing at the counter.

Fred says, "Back again, eh?"

Fred dries his hands with a paper towel.

>hi fred
Fred smiles.  "Hello once again.  Can I get you something?"

Fred dices some vegetables.

>tell fred about time travel
You can't think of anything interesting to say about that.

>tell fred about time
You tell Fred what you know about the time travel, but it doesn't amount to
much, and the conversation sort of ends there.

>tell fred about time machine
Fred says, "Aw, now you're pulling my leg, right?  A time machine?  Out in the
woods?  I don't believe it.  I mean, you'd have to show me some proof."  He
regards you with comical suspicion.

>tell fred about future fred
Fred looks slightly uncomfortable as you tell him about the old wino.

"Um, look," he says.  "You come for a sandwich, fine.  You come and ask me
about whatever, that's okay too -- it's a slow night.  But now you're trying to
tell me about some crazy drunk living in your house -- in the future -- and
that it's me?"

Fred stares at the counter, idly swabbing it with a cloth.  "I mean, I don't
know whether to throw you out or punch you in the nose.  Whoever you met, it's
not me, okay?  That's not my future.  I'm going to be manager of this place,
get married, settle down.  That's my future, okay?"

He looks briefly up at you, his eyebrows furrowing.  "Okay, so you've told me
you have a time machine.  I don't really believe you, but if this is something
I can see for myself, then I want to see it."  He starts to put things away,
packing up food and stowing utensils.  "It's about ten minutes till closing,
but I'm gonna close a few minutes early so you can take me to whoever -- or
whenever -- it is you're talking about.  Okay?  So just wait out front and I'll
join you there after I lock things up."

Fred escorts you out of the front of the shop, looking very preoccupied as he
locks the doors from inside and flips the "Closed" sign.


In the village
This little shopping village is attractively decorated with colored signs
pointing you to this merchant and that.  To the west is the bank, and to the
east is the public library.  Because it is late, the only thing open is the
sandwich shop, which is to the north.  The sidewalk leading home is south.

>z
Time passes...

>z
Time passes...

>z
Time passes...

You see Fred turn out the lights in the sandwich shop.

>z
Time passes...

>z
Time passes...

>z
Time passes...

>z
Time passes...

You start to wonder what's keeping Fred.

>z
Time passes...

>z
Time passes...

Fred comes wandering around from behind the sandwich shop.  "Hey, there you
are," he says.  Either he's decided to take this less seriously or he's just
trying to hide what he's feeling.

After a slight pause during which neither of you take the initiative, Fred
claps his hands and rubs them together.  "Well, where to?" he asks.  "Lead on,
MacDuff."

>s

Bend in path
As you approach the local nub of suburban civilization, you again are reminded
that community expansion has a price.  A small shrubbery here serves,
apparently, as an excuse for people to litter, as it is full of bits of trash. 
The footpath bends here from west to north, leading into the shopping village.

You see a sewer grating here.

Fred says, "It's not very far, is it?  I'm not wearing my best pair of walking
shoes."

>sw
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is starting to show the
wear and tear of the hot summers and cool winters.  The sections are uneven and
tufts of grass poke up through the cracks.  The sidewalk wanders east alongside
the road away from your house and toward the nearby shopping village.  Your
driveway is back to the west.

You see a mailbox here.

Fred follows you.

>sw

Driveway
This is your front driveway, which leads west to the north side of your house. 
A small path leads southwest to the front door.  To the east is the road into
town.

You see a little car here.

Fred says, "Hey, this is your house?  Huh.  Must be nice not having any
neighbors."

>x fred
Fred, the sandwich guy, always smiles at you even though you must have bought a
thousand sandwiches from him.  He's got a pudgy frame, dark eyebrows, and a
tiny mustache, but there is always a happy twinkle behind his eyes.

As you look at him, you can't help but think about the boozy wino you saw in
your house in the future, and how miserable he is compared to the Fred of
today.

>sw

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

Fred follows you.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

Fred follows you.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

Fred looks around.  "Hey!  I know this place," he says.  "There used to be a
little creek running along here.  I remember playing in it when I was a kid."

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

Fred gapes at the time machine.  "Whoo-aaoo," he says, stumbling closer to it. 
"Does this really work?  I mean, it looks real, you know?  Or are you just
putting me on?"  He stares at it for a few moments, and runs his hand across
it.  "It feels cool," he says.

>get on platform
Okay, you're now standing on the time machine platform.

Fred clambers onto the platform, looking awestruck and excited.  "Well, here we
go, huh?"  he says bravely.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.

>get off
(the time machine platform)
Okay, you're no longer on the time machine platform.

Fred follows you.

>ne

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

Fred follows you.

>ask fred about time travel
Fred says, "Time travel, eh?  I used to watch a lot of Doctor Who.  I'm not
really into science fiction stuff any more, though."

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a monkey wrench here.

Fred follows you.

>ne

Front of house
This is the front your house, and something is terribly wrong.  The front door
is boarded up, sealing off all entrance to what should still be your home.  The
roof is crippled by the weight of a fallen tree, and all of the front windows
are cracked.  Sopping mounds of rotting leaves that have collected along the
edges and corners indicate years of neglect.  A pool of dirty yellow water
trickles down from the driveway and collects, full of black silt, near the
front door.  The driveway is to the northeast, and a clearing is visible far to
the southwest.  The front door is to the west.

Fred follows you.

>nw

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

Fred follows you.

>x garage door
It's open.

>s

In the garage
This room is a stinking mess, in a totally new and horrible way than the mess
you were used to.  A soiled mattress is lumped into one corner, surrounded by
filth and discarded bottles.  A door leads south into the kitchen.  The garage
door is to the north is open.

Future Fred is here, sitting on a soiled mattress.

As Fred enters the garage, he holds his nose and says, "Whoo-ee, what crawled
in here and died?"  Then he sees future Fred sitting on the mattress, swigging
from his bottle of cheap liquor, and is struck dumb.

Fred turns a blotchy shade of white, and his lower lip quivers a bit.  "That's
me," he says.  "That's me."

Future Fred belches and squints at his former self.  "This is what I get for
mixin' my drinks," he mutters.  "Good thing I decided to quit drinkin' the
cheap stuff."  He goes to take another swig, but Fred snatches the bottle out
of his hand.

"This is what Dad used to drink," Fred says, staring numbly at the label. 
"This is exactly the --" Future Fred grabs the bottle back, letting out a
wheeze.  "Get yer own bottle," he says.

"No," Fred says, the color returning to his face.  He seems to have become very
still and quiet, but you can see the muscles in his cheeks twitching.  He opens
a white paper sack and withdraws a sandwich.  "Here," he says.  "Eat this."

"Lemme guess," says future Fred, taking it.  "Roast beef on wheat, with mustard
and tomatoes.  Bingo."  He sets it aside.  "My stomach don't take food so good
no more," he says, taking another drink.  "Makes me sick."

Fred's head falls, his chin resting on his chest.  Everything is quiet.

>are you ok fred
I don't know the word "ok".

>how are you 
I don't know the word "how".

>fred, how are you
I don't know the word "how".

>greet fred
I think Fred needs you to just take him directly home right now.

Fred looks at you and says, "I'd like to go back now, please.  I have a lot of
thinking to do."

>hug fred
I think Fred needs you to just take him directly home right now.

>n

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

Fred follows you.

>sw

Behind house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The dead trees that line the west edge of the property seem to regard the scene
with a sagelike sadness.  A gravel path extends northeast and southeast.

Fred follows you.

>sw
There is nowhere to go in that direction.

>se

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a monkey wrench here.

Fred follows you.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

Fred follows you.

>sw

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.

Fred follows you.

>get on machine
Okay, you're now standing on the time machine platform.

Fred follows you.

>x fred
Fred is looking rather pensive and solemn.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>get off
(the time machine platform)
Okay, you're no longer on the time machine platform.  Fred says, "Okay, I can
find my way from here."  He shakes your hand.  "This is really heavy-duty, you
know?  But thanks.  Thanks."  He starts to walk away through the woods.  You
hear Fred mumble to himself, "That's not what I want.  That's not the way I
want my life to go."

Just before he disappears into the trees, he points up at the sky and calls
out, "Beautiful night, huh?"  With that, Fred is gone.

[ Your score just went up by 7 points. ]

>x sky
The moon is gibbous and waning, but bright on this cloudless night.

>get on platform
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

Nothing seems to happen.  I wonder why.

>z
Time passes...

>z
Time passes...

>z
Time passes...

>z
Time passes...

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>undo
(Undoing one command)


Clearing (on the time machine platform)
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.

>put hot sandwich in compartment
Done.

>close compartment
Closed.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>open compartment
A wave of heat comes out of the compartment.  Opening the hinged compartment
reveals a hot meatball sandwich.

>get sandwich
Taken.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

You hear a woman calling your name from the northeast.  A vibrant young woman
in a professional suit is hurrying to catch up to you.  "Wait, wait," she says.
"The foreman said they'd seen you going down this way."

Paying careful attention to where she is stepping in her heeled shoes, she
neglects her hand, which is carrying a dark leather briefcase.  When she
reaches the bend in the path, she smacks her briefcase directly into the rock. 
It splits open and tumbles out of her hand, and paper scatters everywhere.

"Ooh!  This is not my day!" she sighs as she kneels and starts to pick up her
papers.

>get papers
You've already got your hands full.

Laura continues to pick up the loose papers and put them hastily back into her
briefcase.

>nw
Something tells you to stick with Laura for a while instead of wandering off.

Laura continues to pick up the loose papers and put them hastily back into her
briefcase.

>z
Time passes...

Laura continues to pick up the loose papers and put them hastily back into her
briefcase.

>z
Time passes...
Laura finishes picking up her loose papers.  She crams them all into the
briefcase in a hasty fashion.


Laura straightens herself up.  "Thank you.  I'm such a spaz these days."  She
looks at you straight on for the first time, and a funny look comes over her
face.  "You look different.  Have you suddenly grown older?"  She shakes her
head.  "Never mind.  That was rude of me, sorry."

She ruffles through the papers, looking for something.  "I came to talk to you
about your trust fund and issues concerning construction cost ..." she says,
"Argh, I can't find the papers, now, of course."

>x laura
You recognize her as Laura, the woman from the bank.  In fact, now that she is
older, you remember that you met her before, around this time -- subjectively
speaking.  She was a junior manager at the bank, and you talked to her on one
or two occasions about the mortgage on the house, and setting up your trust
fund to pay for it.  Since this is one of those occasions, it enters your head
that you might have to worry about meeting yourself in the past, but you're
pretty sure you don't remember dropping by the construction site on this
particular day.

Laura is dressed in a knee-length violet skirt and matching shoes, with a
sleeveless white blouse that's opened a couple of buttons at the top, a
concession to the summery weather.  She looks tanned and healthy, but there is
a distinct pensiveness in her green eyes.

Laura looks at you soberly.  She says, "I got a call from Mr. Mayhew concerning
certain improvements to the house that you have called for that significantly
drive up the cost of construction."  She continues her fruitless search for the
right document.  "Something about a better grade of roofing?  Well, there's
good news and bad news about this."

>ask laura about bad news
"The bad news is, I don't know how you're going to afford this particular
modification.  You were cutting it close already.  Accounting for cost of
living increases, I think you're going to run out of money just fifteen years
into your thirty year mortgage.  If things go in your favor, maybe twenty." 
She looks at you sympathetically.

"The good news is, it will lower your insurance significantly, as it
significantly reduces the risk of fire damage."  She rummages in her briefcase
a bit.

>z
Time passes...

"I'm sorry, I just can't make head or tails of my documents now.  Do you have a
minute?  Why don't you come back to the bank with me so we could chat?  Thanks.
I'm really sorry about this.  I'm just a little distracted today anyway."

>follow laura
But Laura is right here!

Laura starts walking to the northeast.  You follow her.

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

Laura is here.

Laura says, "I'm sorry if I'm not up on all of the details of your finances.  I
only recently accepted a promotion, and had to scramble to get up to speed on a
few dozen client histories.  My life is suddenly a lot more hectic than I
expected.  I suddenly have the responsibility to make decisions that affect
people's lives."

She stares down at the ground as she walks, lost in thought for a minute or
two.  "If the money hadn't been so good," she says, "If I'd known what I was
getting into ..."

"Sorry," she says to you.  "You probably have enough problems of your own
without listening to mine."

>ask laura about responsibility
I don't know the word "responsibility".

>ask laura about problems
Laura says, "I'm just wondering about my future, that's all.  It's a long
story."

Laura continues walking toward the shopping village.  You follow her.

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

Laura is here.

Laura says, "I don't know if anyone ever talked to you about what options you
have for investing your trust fund.  I know the stock market can seem confusing
when you're new to it, but the payoffs can be worth it, even within a few
years' time frame."

"I can tell this isn't very interesting to you.  Maybe we should forget about
all of this for the moment and talk about something else."

>tell laura about future laura
You tell Laura what you know about Laura, but it doesn't amount to much, and
the conversation sort of ends there.

Laura continues walking toward the shopping village.  You follow her.

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

Laura is here.

Laura stares at a bird as it passes overhead.

"I lost my train of thought just now," she says, distracted by thoughts you
can't guess.  After a pause, she asks, "Do you ever feel like life is a series
of decisions, and you never have quite enough information to make an informed
choice?  That only in hindsight can you ever see how good or bad a selection
you made?"

Laura straightens her posture, which had started to slump.  "Oh well.  What's
done is done.  You can only go forward, not backward."

>ask laura about future
Laura says, "I visited a fortune teller once.  She told me that, if I wanted
it, I could reach the top of the world.  Then she said that I shouldn't want
that.  I got angry at her, I'm not even sure why.  It just sounded phony, you
know?  Heck, I could do worse than reaching the top, you know?  I should have
such problems."

Laura continues walking toward the shopping village.  You follow her.

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

Laura is here.

Laura stops for a moment and takes a deep breath.  She looks at the trees
lining the road and says, "Aren't they beautiful?  I can see why you wanted to
build out here."

She resumes walking, slowly.  "I live on the north end of town, so I don't get
out into these older areas much.  I probably should.  I always tell myself I
should take walks out here during lunch.  I guess today was my excuse.  I just
wish I'd planned ahead and brought walking shoes."  She smiles and winces. 
"I'm all right.  We're almost there."

>n
You decide to let Laura take the lead.

Laura continues walking toward the shopping village.  You follow her.

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

Laura is here.

Laura looks at the sandwich shop.  "Geez, I missed lunch again.  That's another
thing about being promoted -- it's the best diet I've ever been on.  Eight
pounds so far."

She looks at her watch.  "If I weren't running late, I'd buy you lunch.  But I
guess I don't have time for that.  I guess I won't have time for that for a
long time."  She goes silent again, gazing into the distance.  "I keep thinking
that if I just keep moving onward and upward, into the big office with the big
chair and the big desk, I won't have to worry about money any more.  I won't
have to worry about anything.  That's the big thing, right?  Not having to
worry?  I guess that was your plan with the house.  Oops, sore subject, sorry."

"But sometimes I lie awake wondering, does that make any sense?  Doesn't the
bigger office just come with bigger worries?  And then I see guys who have made
it, women in business whom I admire, and they look happy.  I sound like a sap. 
'I just want to be happy!  I just want to be loved!'  My boss tells me that he
gave me the promotion so I could toughen up.  He says I'm too compassionate,
too lenient on the bank's debtors, too open-hearted about people in need."

"In fact, if he finds out I made this trip out to see you, he's not going to be
happy.  And he wants to be happy, too, just like ...  everyone."

>ask laura about lunch
She doesn't seem to register that you asked a question.  You get the feeling
she has a lot of other things on her mind right now.

Laura enters the bank.  You follow her.

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

Laura is here.

Laura almost walks toward the new accounts desk, but stops herself.  "Bad
habit," she says, grinning.  "I have an office now, in the back.  It used to be
a closet or something.  I remember thinking, 'Wow, my own office?  Cool.'  And
then I saw it for the first time, and -- oh well.  It'll only be for a year or
so, and then I'll get promoted again, to one with a window.  Maybe I'll be able
to see the trees from there.  Provided they don't cut the trees down to build
something, which is the way things look like they're going."

"You're a good listener, I have to give you that.  I don't know why you bother
with basket cases like me."

>ask laura about office
She doesn't seem to register that you asked a question.  You get the feeling
she has a lot of other things on her mind right now.

Laura invites you to come with her into her office in the back part of the
bank.  You follow her.

Laura's office
Laura's office is a small, windowless room with a file cabinet and a plain
white desk.  The only exit is to the east.

Laura is here.

A paunchy man with a bald head and a brown suit appears in the doorway. 
"Laura!" he says, and then casts a judgmental glance at you.  "We're holding
the meeting for you.  Are you ready?  Where's your report?"

Laura puts her briefcase on the desk.  "Right here, I'm coming," she says.  The
man clicks a ballpoint pen a few times, nods sternly, and exits.  You hear the
clicking noise disappear down the hall.

>x briefcase
It's a briefcase made of dark leather.

Laura sits down at her desk, sighing.

Laura dumps her papers onto the desk and begins picking out pieces of her
report.

Laura sighs.  "I'm sorry, I guess I need to get back to work.  Thanks for the
walk -- and the conversation.  If you need anything else, come back and see me.
My door's open."  She manages to get her report put back together and ushers
you back into the lobby.


In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

Laura shakes your hand, smooths back her hair, and disappears into the back
rooms of the bank.

>w

Laura's office
Laura's office is a small, windowless room with a file cabinet and a plain
white desk.  The only exit is to the east.

Laura is here.

>ask laura about stock
Laura types for a moment on her computer.  "I hate to break it to you, but
you're going to need five thousand dollars before I can make any investments
for you.  I wish I could help you come up with it, but I can't."

>e

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>n

At the Teller window
The teller stands ready at the window, with a polite but grim expression.

The bank teller is standing behind the teller window.

The teller says, "Good morning.  Would you care to make a deposit or a
withdrawal today?"

>>withdrawal
The teller says, "A withdrawal.  Very good."  He punches some numbers on his
computer.  "Oh, I'm sorry.  You can't make any withdrawals at this time due to
a computer error."

The teller says, "Have a nice day."

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>grr
Whoops!  I hope that was supposed to happen.

>i
You are carrying:
   a television set
   some money (395 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget
   a paper napkin
   a hot meatball sandwich

>e

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

>sw
There is nowhere to go in that direction.

>s

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>sw
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>sw
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>e

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>w

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>w

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.

>set dial to 4
Okay, it's now turned to 4.

>i
You are carrying:
   a television set
   some money (395 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget
   a paper napkin
   a hot meatball sandwich

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>ne

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>e

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, an old pillowcase, a divining rod, a screwdriver, a
car key, a garage door opener, the time machine manual, a package, five jugs of
miracle-grow, a wheelbarrow, and a lightning rod here.

The merchant is here.

As you enter, the antiques merchant smiles at you and waves you over to the
counter.

"Something new was just brought in that I thought you might like to see," she
says, and retrieves something from behind the counter.

It is a long spear of conducting metal.  The initials 'WCDW' are imprinted
along the shaft.

The merchant says, "Ah yes.  Let me tell you about this lightning rod.  You
can't just run down to the local hardware store to find a lightning rod like
this one.  Assuming there were a local hardware store, that is."

She looks it up and down.  "Yes, see here, on the shaft?  It's the craftsman's
initials.  This was hand made by a company in Boise, Idaho, that made lifetime
guarantees for their lightning rods.  Back in the 1940s, they could barely keep
up with demand.  Cheap, mass-produced lightning rods eventually forced them out
of the market.  If you really want to protect your house, though, this is the
one to get."

>x rod
Superstition has it divining rods can find water.  To you, it looks like an
ordinary stick, with a kind of forked end.

>x lightning rod
It is a long spear of conducting metal.  The initials 'WCDW' are imprinted
along the shaft.

>buy it
The merchant says, "$25 for it.  Deal?"

>yes
The merchant says, "All righty.  Here you are.  Thank you."

>buy barrow
The merchant says, "$120 for it.  Deal?"

>>yes
The merchant says, "All righty.  It's all yours.  Again.  Thank you."

>i
You are carrying:
   a television set
   some money (250 dollars)
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a odd gadget
   a paper napkin
   a hot meatball sandwich
   a lightning rod

>sell set
(to the merchant)
The merchant gives it a quick once-over with her expertly trained eyeballs.

The merchant says, "Hmmm, yes.  It is an old model, isn't it?  No, wait -- in
fact, it's not particularly old, it just looks aged.  You aren't trying to pull
a fast one on me, are you?"

He stares at it a little longer.  "Well, I'm not a pawn shop, you understand. 
I normally don't take electronics.  But I'll make an exception if it at least
turns on."

He plugs the television in and turns it on.  A snowy picture comes on the
screen.  He turns it off, unplugs it, and clicks his tongue a few times.

"Tell you what.  I'll give you $10 for it.  Deal?"

>yes
The merchant tucks the television set away into a back room, then returns and
hands you the money.

The merchant says, "All righty.  Here you are.  Thank you."

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a metal suitcase, an old pillowcase, a divining rod, a screwdriver, a
car key, a garage door opener, the time machine manual, a package, five jugs of
miracle-grow, and a wheelbarrow here.

The merchant is here.

>buy suitcase
The merchant says, "$45 for it.  Deal?"

>y
The merchant says, "All righty.  Here you are.  Thank you."

>put all in barrow
ATM card:  Done.
blue pencil:  Done.
perfect blue crystal:  Done.
machete:  Done.
crowbar:  Done.
odd gadget:  Done.
paper napkin:  Done.
hot meatball sandwich:  Done.
lightning rod:  Done.
some money (215 dollars):  Done.
metal suitcase:  Done.

>get suitcase
Taken.

>open it
Opened.

>put money in case
Which case do you mean, the metal suitcase, or the old pillowcase?

>suitcase
Done.  You put the money into the metal suitcase along with the rest of it.

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see an old pillowcase, a divining rod, a screwdriver, a car key, a garage
door opener, the time machine manual, a package, five jugs of miracle-grow, and
a wheelbarrow here.

The merchant is here.

>i
You are carrying:
   a metal suitcase
       some money (430 dollars)

>i
You are carrying:
   a metal suitcase
       some money (430 dollars)

>get gadget
Taken.

>put all in barrow
metal suitcase:  Done.
odd gadget:  Done.

>get all
antiques:  You can't take the collection of antiques.
old pillowcase:  Taken.
divining rod:  Taken.
screwdriver:  Taken.
car key:  Taken.
garage door opener:  Taken.
time machine manual:  Taken.
package:  Taken.
jug of miracle-grow:  Taken.
jug of miracle-grow:  Taken.
jug of miracle-grow:  Taken.
jug of miracle-grow:  Taken.
jug of miracle-grow:  You've already got your hands full.
ATM card:  You've already got your hands full.
blue pencil:  You've already got your hands full.
perfect blue crystal:  You've already got your hands full.
machete:  You've already got your hands full.
crowbar:  You've already got your hands full.
paper napkin:  Taken.
hot meatball sandwich:  You've already got your hands full.
lightning rod:  You've already got your hands full.
metal suitcase:  You'll have to close the suitcase first.
odd gadget:  Taken.

>put all in barrow
old pillowcase:  Done.
divining rod:  Done.
screwdriver:  Done.
car key:  Done.
garage door opener:  Done.
time machine manual:  Done.
package:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
jug of miracle-grow:  Done.
paper napkin:  Done.
odd gadget:  Done.

>l

Antique store
Stocked full of knickknacks and ancient collectibles, this shop is pervaded by
a rich, musty odor.  Taking a look around, you are somewhat ashamed to admit
that you really can't tell one item from another.  None of it looks any more
valuable or rare than the collection you keep heaped in your garage.  The only
exit is west into the village.

You see a jug of miracle-grow and a wheelbarrow here.

The merchant is here.

>get jug
Taken.

>put it in barrow
Done.

>i
You are empty-handed.

>x barrow
This filthy beast from, apparently, the last century, has a busted front wheel.
It's still a little wobbly, but the bolt is holding it tight.  In the
wheelbarrow you see:
   a ATM card
   a blue pencil
   a perfect blue crystal
   a machete
   a crowbar
   a hot meatball sandwich
   a lightning rod
   a metal suitcase
       some money (430 dollars)
   an old pillowcase
   a divining rod
   a screwdriver
   a car key
   a garage door opener
   the time machine manual
   a package
   five jugs of miracle-grow
   a paper napkin
   a odd gadget

>get pencil
Taken.

>get sandwich
Taken.

>push barrow
You seem able to push the wheelbarrow around with you.

>push barrow w

The merchant says, "Thank you, come again!"

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

You see a wheelbarrow here.

>push barrow sw
There is nowhere to go in that direction.

>push barrow s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

You see a wheelbarrow here.

>push barrow s
There is nowhere to go in that direction.

>push barrow w
There is nowhere to go in that direction.

>push barrow sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot, a little mound of dirt, and a wheelbarrow here.

>push barrow sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

You see a wheelbarrow here.

>g
You push your way into the clearing, opening your usual path once again.  You
push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south, a time machine, and a wheelbarrow here.

The divining rod vibrates, pulling to the northeast.

>put barrow on machine
Done.

>put sandwich in compartment
Done.

>set dial to 4
It's already set to 4!

>push button
You push the big red button.  Click!

The machine vibrates and heats up like a toaster oven.  A blinding light
envelops the machine, and it vanishes in a fancy puff of smoke, leaving only
the smell of ozone behind.

>undo
(Undoing one command)


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  The hinged
compartment seems to contain a hot meatball sandwich.  Sitting on the time
machine platform is a wheelbarrow.

>get on machine
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can see a construction site through the woods to the northeast.

You see a time machine here.  The hinged compartment seems to contain a hot
meatball sandwich.  Sitting on the time machine platform is a wheelbarrow.

>get sandwich
Taken.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>n

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>u

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The architect is here.

>give sandwich to architect
He says, "Why, thank you!  This will just hit the spot with some coffee.  I'll
be right back."  He clambers down the ladder and heads north out of sight.

[ Your score just went up by 5 points. ]

>draw secret door on blueprint
(with the blue pencil)

You put the blue pencil to the blueprint and sketch a quick hidden passage on
the south side of the house.  You make a note that it is to be a secret
entrance.  The architect will probably get the point when he sees it, provided
he doesn't blow his stack when he sees that you've tampered with his work.

>i
You are carrying:
   a blue pencil

>l

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The lunchtime whistle blows shrilly.

The foreman shouts, "That's it!  Back to work, people!"  Refreshed, the workers
spring back into action.

>x blueprint
It's a lovely floor plan, rendered impeccably with blue pencil.  The name of
the architect is stenciled in the top corner.

The architect returns, nursing a hot cup of coffee.  He immediately gets back
to work.  Seconds later, he does a blurbling spit-take with his coffee. 
"What's this?  What's this?"  he says, peering at the blueprint.  He gets up
from his desk and walks over to you.

"Normally," he says, "I would be furious if anyone tampered with my blueprint
while I was away.  In fact, I find the circumstances of my getting up to leave
to be suspiciously contrived.  However!  In this case, I'll make a very grand
exception!"

He pulls you back over to the desk and sits down.  He puts his finger on your
addition.

"A secret door!  A secret passage!"  He grins broadly.  "You don't know how
long I've wanted to create something like this.  People don't want creativity,
they want the same old thing every time.  Do you know I once got a failing
grade on an architecture school project for putting in secret passages?  My
instructor was this strict old biddy who didn't see the point of it."

"Now, we don't have much room in the floor plan to acommodate anything but a
narrow little hallway, but perhaps it'd be good enough to be at least an
entrance, and perhaps a small storage area.  What do you think?  You should at
least be able to enter the master bedroom through there.  I'm going to have to
give some thought to the secret switch that will open it.  Oh, what fun!  Thank
you.  Really."

He shakes your hand and gets to work, scribbling little notes to himself.

>ask him about the secret switch
He says, "The secret switch will be hidden on the ground next to the wall. 
Step on the switch, knock on the wall, and the door will open!"

>thanks
I don't know the word "thanks".

>thank
I don't know the word "thank".

>d

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>sw
There is nowhere to go in that direction.

>se
There is nowhere to go in that direction.

>s

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on machine
Okay, you're now standing on the time machine platform.

>full
In a total of 970 turns, you have achieved a score of 116 points out of a
possible 151, which means you are a first class adventurer.  You have earned
the following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 5 points for arriving in the future the first time
 4 points for giving the bad shingle to the architect
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
10 points for leaping to the attic
 1 point for using the tire to break your fall from the attic
 5 points for giving a piping hot sandwich to the architect
 7 points for opening a new bank account
 7 points for showing Fred his future self
20 points for finding various items

>x dial
The knob can be turned to settings numbered from 1 to 5.  It's currently set to
4.

>set dial to 5
Okay, it's now turned to 5.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

You see a monkey wrench here.

>get wrench
Taken.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>sw

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>fix wheel with wrench
The front wheel of the wheelbarrow is already repaired.

>put wrench in barrow
Done.

>look in barrow
In the wheelbarrow you see a ATM card, a perfect blue crystal, a machete, a
crowbar, a lightning rod, a metal suitcase, an old pillowcase, a divining rod,
a screwdriver, a car key, a garage door opener, the time machine manual, a
package, five jugs of miracle-grow, a paper napkin, a odd gadget, and a monkey
wrench.

>ne

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>ne

Front of house
This is the front your house, and something is terribly wrong.  The front door
is boarded up, sealing off all entrance to what should still be your home.  The
roof is crippled by the weight of a fallen tree, and all of the front windows
are cracked.  Sopping mounds of rotting leaves that have collected along the
edges and corners indicate years of neglect.  A pool of dirty yellow water
trickles down from the driveway and collects, full of black silt, near the
front door.  The driveway is to the northeast, and a clearing is visible far to
the southwest.  The front door is to the west.

>ne

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

You see a newspaper here.

>e

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>w

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

You see a newspaper here.

>get paper
Taken.

>read it
An item in the business section catches your eye.  Apparently, the Lothario
Corporation has failed to consume DibbleBits, an upstart technology company, in
hostile takeover.  It seems DibbleBits is cash-rich right now, its stock value
having taken a sudden 80-point jump in the last year, due to technology demand,
after having languished at pennies-per-share for 30 years.

>ne
There is nowhere to go in that direction.

>e

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>ne
There is nowhere to go in that direction.

>n
There is nowhere to go in that direction.

>e

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal ATM.

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>put card in slot
You can't put the card slot anywhere.

>i
You are carrying:
   a blue pencil
   a newspaper

>w

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>sw
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>w

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

>s
There is nowhere to go in that direction.

>sw

Front of house
This is the front your house, and something is terribly wrong.  The front door
is boarded up, sealing off all entrance to what should still be your home.  The
roof is crippled by the weight of a fallen tree, and all of the front windows
are cracked.  Sopping mounds of rotting leaves that have collected along the
edges and corners indicate years of neglect.  A pool of dirty yellow water
trickles down from the driveway and collects, full of black silt, near the
front door.  The driveway is to the northeast, and a clearing is visible far to
the southwest.  The front door is to the west.

>sw

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>sw

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get atm card
Taken.

>i
You are carrying:
   a blue pencil
   a newspaper
   a ATM card

>get suitcase
You'll have to close the suitcase first.

>i
You are carrying:
   a blue pencil
   a newspaper
   a ATM card

>close case
Which case do you mean, the metal suitcase, or the old pillowcase?

>close suitcase
Closed.

>get it
Taken.

>l

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>i
You are carrying:
   a blue pencil
   a newspaper
   a ATM card
   a metal suitcase

>get money
I don't see any money here.

>i
You are carrying:
   a blue pencil
   a newspaper
   a ATM card
   a metal suitcase

>look in barrow
In the wheelbarrow you see a perfect blue crystal, a machete, a crowbar, a
lightning rod, an old pillowcase, a divining rod, a screwdriver, a car key, a
garage door opener, the time machine manual, a package, five jugs of miracle-
grow, a paper napkin, a odd gadget, and a monkey wrench.

>where's my money?
I don't see any my money here.

>where is money
Metal suitcase.

>open case
Opening the metal suitcase reveals some money (430 dollars).

>ne

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>ne

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>ne

Front of house
This is the front your house, and something is terribly wrong.  The front door
is boarded up, sealing off all entrance to what should still be your home.  The
roof is crippled by the weight of a fallen tree, and all of the front windows
are cracked.  Sopping mounds of rotting leaves that have collected along the
edges and corners indicate years of neglect.  A pool of dirty yellow water
trickles down from the driveway and collects, full of black silt, near the
front door.  The driveway is to the northeast, and a clearing is visible far to
the southwest.  The front door is to the west.

>ne

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

>e

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>e

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal ATM.

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>n

Locksmith shop
A sign inside says, "Going out of business - Free stuff."  Most everything has
been taken already.  The only exit is south.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>unplug grinder
You unplug the motorized grinder from the socket.

>take it
You've already got your hands full.

>i
You are carrying:
   a blue pencil
   a newspaper
   a ATM card
   a metal suitcase
       some money (430 dollars)

>drop paper
Dropped.

>drop pnecil
I don't know the word "pnecil".

>put pencil in case
Done.

>put paper in case
Done.

>get grinder
Taken.

>put grinder in case
Done.

>i
You are carrying:
   a ATM card
   a metal suitcase
       some money (430 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank

>s

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal ATM.

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>put atm card in slot
The display reads:  Please type your PIN number or push CANCEL.

>type 1234
(on the keypad)
The machine whirs for a few moments of mechanical thought.

The display reads:  Type 1 to make a deposit, type 2 to make a withdrawal, type
3 to check your current balance, or push CANCEL to end this transaction.

>type 3
(on the keypad)
The display reads:  You currently have 7218 dollars in your account.

Type 1 to make a deposit, type 2 to make a withdrawal, type 3 to check your
current balance, or push CANCEL to end this transaction.

>type 2
(on the keypad)
The display reads:  Please type the amount to withdraw, in multiples of $20.

>5000
There's no verb in that sentence!

>type 5000
(on the keypad)
The machine whirrs and clacks.  Finally, it spits out $5000, which you take.

You put the money into the metal suitcase along with the rest of it.  The
display reads:  Would you care to make another transaction?  Type 1 for yes,
CANCEL to end.

>type cancel
(on the keypad)
The display reads:  Thank you for using VistaBank!

The machine spits out your ATM card, which you take.

>i
You are carrying:
   a metal suitcase
       some money (5430 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>e
There is nowhere to go in that direction.

>l

Strip mall
The walk to town is much shorter, because progress seems to have brought the
town to you.  Where there used to be some nice trees and bushes is a concrete
strip-mall.  The old village square with the library, bank, and sandwich shop
seems to have been mowed down to make way for this thing.  In fact, a sign here
makes you think even this strip mall isn't long for this world.  Even the bank
is gone, replaced by an impersonal ATM.

In the strip mall you see a number of vacant offices.  The only shop that seems
to be open for business is an alabaster little store labelled "Locksmith,"
which is directly to the north.  The sidewalk leads back west.

>w

Sidewalk
After the shocking sight of your house, this once-familiar sidewalk is a
calming surprise.  Someone must have recently repoured the walk, as it is
smooth and free of flaws.  The sidewalk wanders east-west alongside the road
from your house into the nearby strip mall.

You see a mailbox here.

>w

Driveway
Your driveway looks much the same, a thankful sight after the ruin your house
has become.  The road to town still lies to the east.  Your front door is to
the southwest.

>w

North of house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The driveway extends east, and a small path leads southeast to the front of the
house and southwest to the back.  A scaled stone wall runs up the side of the
house.

>sw

Behind house
The house is burned and crippled, a shadow of its former pleasant beauty.  The
southern roof has been torn open by the weight of a fallen tree.  However, the
fire seems not to have spread very far, thanks to the fire-resistant shingles. 
The dead trees that line the west edge of the property seem to regard the scene
with a sagelike sadness.  A gravel path extends northeast and southeast.

>se

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.

>sw

At the rock
A large rock juts up out of the ground right in your way, a familiar landmark
in an otherwise unfamiliar landscape.  Once nestled along a wooded path, it now
is the sole feature of an eerily empty landscape, distorting your perceptions
of scale and distance.  The broken remains of dark glass bottles lie around the
base.  The rock itself looks darker than you remember it, somewhat blackened. 
To the northeast is your house, and a clearing is visible to the southwest.

>sw

Clearing
The clearing here is desolate, giving the distinct impression that all natural
life has left this area.  The ground is hard and overgrown by weedy grass. 
There are no trees any more, but there are some stumps where once they stood. 
Your old footpath is nowhere to be seen.  You do see your house to the
northeast, but it too looks abandoned.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you.  The world around you spins into a wild vortex that suddenly
vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>i
You are carrying:
   a metal suitcase
       some money (5430 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>set dial to 2
Okay, it's now turned to 2.

>z
Time passes...

>z
Time passes...

>feel machine
The time machine feels warm.

>g
The time machine feels slightly warm.

>g
The time machine feels slightly warm.

>g
The time machine feels like a time machine.

>g
The time machine feels like a time machine.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  Sitting on the
time machine platform is a wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>ne

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>i
You are carrying:
   a metal suitcase
       some money (5430 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>make a deposit
(first approaching the teller window)

The teller says, "A deposit.  Very good."  He punches some numbers on his
computer.  "How much will you be depositing today?"

$>430
The teller says, "Very good."

The teller takes the money and fiddles with his computer for a moment.  The
teller says, "You currently have 630 dollars in your account."

The teller says, "Have a nice day."

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>e

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>tell laura about future laura
You can't think of anything interesting to say about her.

>tell laura about laura
There's not much you can tell Laura about herself, unless maybe you meant to
tell her about a different-era version of Laura.

>tell laura about far future
I don't know the word "far".

>e
There is nowhere to go in that direction.

>ne
There is nowhere to go in that direction.

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>e

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>s
There is nowhere to go in that direction.

>w
There is nowhere to go in that direction.

>sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  Sitting on the
time machine platform is a wheelbarrow.

>sw
You get all turned around in the dense forest growth and end up back where you
started.

>get on platform
Okay, you're now standing on the time machine platform.

>i
You are carrying:
   a metal suitcase
       some money (5000 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>off
Okay, you're no longer on the time machine platform.

>ne

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>ne

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  You can
walk around the house to the northwest and southwest.  You can go around the
driveway and find the road into town to the southeast.

>ne
You can't walk across the newly-poured cement driveway.

>e
There is nowhere to go in that direction.

>se

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>n
There is nowhere to go in that direction.

>e

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>n

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

>n

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>n
It's lunchtime, and the sandwich shop is crowded with customers.  You don't
feel like fighting your way through the line, especially since you know that,
somewhere, good old Fred is standing around in an empty shop with nothing to
do.

>l

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>l

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>w

Laura's office
Laura's office is a small, windowless room with a file cabinet and a plain
white desk.  The only exit is to the east.

Laura is here.

>ask laura about dibble
Laura types for a moment on her computer.  "You only have $2121 in your account
right now.  If you have more you can deposit, you should do that so that I can
handle the transfer electronically.  The teller should help you with that. 
Then come back and talk to me about DibbleBits."

>e

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>n

At the Teller window
The teller stands ready at the window, with a polite but grim expression.

The bank teller is standing behind the teller window.

The teller says, "Good morning.  Would you care to make a deposit or a
withdrawal today?"

>>deposit

The teller says, "A deposit.  Very good."  He punches some numbers on his
computer.  "How much will you be depositing today?"

$>4000
The teller says, "Very good."

The teller takes the money and fiddles with his computer for a moment.  The
teller says, "You currently have 15595 dollars in your account."

The teller says, "Have a nice day."

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>w

Laura's office
Laura's office is a small, windowless room with a file cabinet and a plain
white desk.  The only exit is to the east.

Laura is here.

>ask laura about dibble
Laura types for a moment on her computer.  "Well, you seem to have enough money
in your account now.  I guess I was wrong about that.  Still, I think investing
what you have is the way to go."  Laura says, "Okay, you're all set.  At 25
cents a share, you now own 20000 shares of DibbleBits stock.  Hope it helps you
out down the road."

[ Your score just went up by 5 points. ]

>full
In a total of 1114 turns, you have achieved a score of 121 points out of a
possible 151, which means you are a first class adventurer.  You have earned
the following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 5 points for arriving in the future the first time
 4 points for giving the bad shingle to the architect
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
10 points for leaping to the attic
 1 point for using the tire to break your fall from the attic
 5 points for giving a piping hot sandwich to the architect
 7 points for opening a new bank account
 7 points for showing Fred his future self
 5 points for buying DibbleBits stock
20 points for finding various items

>e

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>e

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>s

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>w

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>s
There is nowhere to go in that direction.

>w

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>s
There is nowhere to go in that direction.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 4
It's already set to 4!

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>off
Okay, you're no longer on the time machine platform.

>ne

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>find switch
You search along the ground near the base of the wall.  After a few passes,
your hand moves across a flat area, about four inches across.  It has been
colored and textured to look like the ground, but it feels different to the
touch.  This must be the switch.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
       a motorized grinder
           a blank
   a ATM card

>stand on switch
You put your foot onto the secret switch.  It moves under your weight, and you
hear some kind of tumbler shift inside the wall.

>knock on wall
You hear a weight dropping, and a couple of clicks.  The secret door springs
magically open wide, revealing a darkened entrance.

>x door
It's open.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it is currently turned off.  There is barely enough light seeping in through
the closed door to see by.  The short hallway dead-ends at a crudely-carved
staircase leading down.  There is another door to the west, and you can go out
the way you came in.

[ Your score just went up by 5 points. ]

>w
(Opening the west door)
The passageway seems to be blocked off by a large piece of furniture, probably
your dresser, because that's right where you used to keep it.  Perhaps the
architect never told the other-you (of the past) about the secret passage once
the house was finished.  Thus, you never knew not to block it off, if that
makes any sense.

>turn bulb on
You switch on the light bulb.

>l

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

>drop grinder
Dropped.

>d
You descend the stairs slowly, unsure of what you might find.  The stairs go
down deeper under the ground than you expected.  It becomes dark and hard to
see your footing, but as you keep going, your eyes once again find a dim source
of light, which you follow.  Finally, you reach the bottom, and find yourself
in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see another time machine here.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a ATM card

>x machine
It's a large contraption that's about the size and shape of an engine block,
and made of solid metal.  It sits on a platform that is welded firmly to the
machine itself.  On the front is a knob and a large red button.  On the back
side of it is a hinged compartment.  There is a label on the knob.  The machine
is covered by a layer of dust, as if it had been sitting here for some time.

>blow dust
You blow on the layer of dust.  It swirls away, and the machine looks a little
cleaner now.

>x dial
The knob can be turned to settings numbered from 1 to 5.  It's currently set to
3.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Broken cavern
You are in a large cavern that seems to have once been an enormous natural
geode, with crystals as big as your head growing in splints and shafts from
every direction.  What you see now are shattered shards.  The rock ceiling from
which the crystals grew overhead has crumbled, sending a half-ton of debris
smashing down, burying what has not destroyed.

Whether by accident or design you cannot guess, but the time machine has
arrived in perhaps the only clear area amid the rubble.  Still, it doesn't feel
safe here.  You hear the pounding and trampling of construction work going on
directly overhead, and with each thump more rock clatters down from above.  If
you stay long, you will probably take a large stone to the head.  There are no
exits from this cavern.

You see a time machine here.

>listen
You hear nothing unusual.

>smell
The room smells of wet limestone.

>w
(first getting off the platform)
Okay, you're no longer on the time machine platform.  The rubble has sealed off
all exits from the cavern.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 5
Okay, it's now turned to 5.

>z
Time passes...

>z
Time passes...

>z
Time passes...

>z
Time passes...

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>u
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  There is barely enough light seeping
in through the closed door to see by.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

>u
There is nowhere to go in that direction.

>s
(Opening the main door)

South of house
This is not your house as you expected to find it, but a scene of devastation. 
The beautiful tree you planted has split from its scorched trunk and smashed
into the side of your house.  From what you can see, the roof has been torn
open by the weight of it, and a terrifying hole gouged out to fully halfway
down the wall.  However, the fire seems not to have spread thanks to the fire-
resistant shingles.  Broken splinters of wet and rotting wood lie everywhere,
kept moist by recent rains.  To the southwest is the old rock and, farther, the
clearing.  You can walk around your house to the northwest and northeast.  A
secret door is open to the north.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  The only light in the passage is from
the open door.  The short hallway dead-ends at a crudely-carved staircase
leading down.  There is another door to the west, and you can go out the way
you came in.

>w
(Opening the west door)

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>e

Master bathroom
This bathroom looks like it has been used as a place to party, in the
vernacular.  Various paraphernalia having to do with drug abuse is in evidence,
such as little plastic baggies, discarded needles, and the like.  It is a
shocking and somewhat depressing sight, to say the least.  The only exit is
west, back into the bedroom.

>d
There is nowhere to go in that direction.

>se
There is nowhere to go in that direction.

>e
There is nowhere to go in that direction.

>open door
Opened.

>l

Master bathroom
This bathroom looks like it has been used as a place to party, in the
vernacular.  Various paraphernalia having to do with drug abuse is in evidence,
such as little plastic baggies, discarded needles, and the like.  It is a
shocking and somewhat depressing sight, to say the least.  The only exit is
west, back into the bedroom.

>open secret door
I don't see any secret door here.

>w

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>se

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  The only light in the passage is from
the open door.  The short hallway dead-ends at a crudely-carved staircase
leading down.  There is another door to the west, and you can go out the way
you came in.

>d

Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get on 
What do you want to get on?

>machine
Okay, you're now standing on the time machine platform.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>u
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>s
(Opening the main door)

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get rod
Taken.

>ne

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>nw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

>ne

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>u
You climb gingerly up the stone wall.

North roof
This is the north end of the roof.  Beautiful, brown metal shingle tiles, the
ultimate in roof shingling -- durable, weatherproof, and fancy!  -- are laid
out in row after glistening row.  Someone obviously took the time and care to
do this roof job right.  A gutter trap, clogged with leaves, runs along the
length of the west side of the house.  The roof itself continues south.  The
stone wall, which turns out to be the outside of your chimney, leads back down.

>s

South roof
The shingles are in even better shape on this end of the house.  The ground is
a long way down from the peak here, at least 30 feet.  The gutter trap is to
the west and continues up to the north end of the house.  You can see the top
opening of the drainpipe in the clogged leaves.  The only exit is north.

>attach rod
(to the peak of the roof)
There's no obvious way to do that.

>x peak
The roof here slants up to a high peak here, with the ground dizzyingly far
below.

>n

North roof
This is the north end of the roof.  Beautiful, brown metal shingle tiles, the
ultimate in roof shingling -- durable, weatherproof, and fancy!  -- are laid
out in row after glistening row.  Someone obviously took the time and care to
do this roof job right.  A gutter trap, clogged with leaves, runs along the
length of the west side of the house.  The roof itself continues south.  The
stone wall, which turns out to be the outside of your chimney, leads back down.

>d
You climb gingerly down the stone wall.

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>s

In the garage
This room is a total mess.  No wonder you keep your car in the driveway.  Sure
enough, it took a long time to sort through the junk in here, and you have
found everything including the kitchen sink, and there still doesn't seem to
have been much point to it.  There is a garage door button on the wall.  A
closed door to the south leads into your house through the kitchen.  The only
other exit is the way you came in, which is open.

You see an opener button, a can of WD-40, a deflated soccer ball, a broken tire
pump, a wasp nest, a 2x4 plank, a can-opener, a moose head trophy, a shovel, a
beat-up mattress, and the kitchen sink here.

>n

North of house
The north side of your house is dominated by your garage door.  The garage door
is open.  A scaled stone wall runs up the side of the house.  The driveway
extends east, and a small path leads southeast to the front of the house and
southwest to the back.

>sw

Behind house
The back of your house is pretty non-descript, except for some really nice
trees that make up for the lack of landscaping in the front.  The spout of your
drainpipe comes down here from the roof.  A gravel path extends northeast and
southeast.

>sw
There is nowhere to go in that direction.

>se

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 2
Okay, it's now turned to 2.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A dull orange
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>n

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>u

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The architect is here.

>give rod to architect
He's too busy to notice your offer.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a ATM card
   a divining rod

>ask architect about rod
He says, "I don't believe in such superstitious magic claptrap, personally."

>ask architect about lightning rod
He says, "Hmmm.  You really have a good memory for details, but the
installation of a lightning rod is more your personal business as the owner of
the house than it is mine."

He pauses and rubs his eyes blearily.  "However, I suppose that if you were to
give me a lightning rod, I would tell the men to attach it after they finish
the roofing.  It is a safety concern, especially when that tree at the south of
the house grows up.  If it gets big enough, it'll be its own lightning rod,
after all."

>give lightning rod to architect
I don't see any lightning rod here.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a ATM card
   a divining rod

>d

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>s

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get lightning
Taken.

>put divining in barrow
Done.

>ne

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>n

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>u

Second floor
The description 'second floor' is misleading, because the floor up here isn't
actually finished, so watch your step.  From up here you see a nice view of the
town square down the road.  There is a fancy blueprint of the house sitting on
a temporary workdesk.  The only exit is down.  Sitting on the workdesk is a
blueprint.

The architect is here.

>show rod to architect
He is too busy to look over your things.

>give rod to architect
He says, "Ah yes.  I had nearly forgotten.  Thank you."  He takes the lightning
rod from you and tosses it down to a passing worker below, hollering a few
instructions.  Then he settles into his chair and goes back to work.

[ Your score just went up by 4 points. ]

>d

Inside house
You finally step into your house.  Not much of a victory, given the
circumstances.  Just a lot of planks and rafters.  A temporary work ladder is
nailed into the structure, and leads up to the second floor.

>s

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>full
In a total of 1229 turns, you have achieved a score of 130 points out of a
possible 151, which means you are a master adventurer.  You have earned the
following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 5 points for arriving in the future the first time
 4 points for giving the bad shingle to the architect
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
10 points for leaping to the attic
 1 point for using the tire to break your fall from the attic
 5 points for giving a piping hot sandwich to the architect
 5 points for entering the secret passage the first time
 7 points for opening a new bank account
 7 points for showing Fred his future self
 4 points for installing the lightning rod
 5 points for buying DibbleBits stock
20 points for finding various items

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>i
You are carrying:
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a ATM card

>look in barrow
In the wheelbarrow you see a perfect blue crystal, a machete, a crowbar, an old
pillowcase, a screwdriver, a car key, a garage door opener, the time machine
manual, a package, five jugs of miracle-grow, a paper napkin, a odd gadget, a
monkey wrench, and a divining rod.

>get crystal
Taken.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>nn
I don't know the word "nn".

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>d

Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>u
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  The only light in the passage is from
the open door.  The short hallway dead-ends at a crudely-carved staircase
leading down.  There is another door to the west, and you can go out the way
you came in.

>s

South of house
The house is older and sagging, with long ruts where splinters have broken off,
but it otherwise looks the way you remember it.  The ground slopes down
slightly here, and the wall of the house looms an extra story high because of
it.  The tiny window high in the wall has been crudely boarded shut.  A large
and sagging tree grows here, leaning its bulky canopy toward the house.  A
large branch has snapped from the middle of its trunk and lies in the mud.  To
the southwest is the old rock and, farther, the clearing.  You can walk around
your house to the northwest and northeast.  A secret door is open to the north.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  The only light in the passage is from
the open door.  The short hallway dead-ends at a crudely-carved staircase
leading down.  There is another door to the west, and you can go out the way
you came in.

>w

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>e

Master bathroom
This bathroom looks like it has been used as a place to party, in the
vernacular.  Various paraphernalia having to do with drug abuse is in evidence,
such as little plastic baggies, discarded needles, and the like.  It is a
shocking and somewhat depressing sight, to say the least.  The only exit is
west, back into the bedroom.

>w

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>n

Downstairs hallway
The hallway is dark and feels cramped due to the collected refuse that has
built up along the wall.  Graffiti covers every flat surface, as usual.  There
is no sign of the photographs that used to hang here.  The foyer is north, and
a doorway into the living room is west.  The master bedroom is to the south.  A
small door leads east into a half bathroom.

>n

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

>n

Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

>n

In the garage
This room is a stinking mess, in a totally new and horrible way than the mess
you were used to.  A soiled mattress is lumped into one corner, surrounded by
filth and discarded bottles.  A door leads south into the kitchen.  The garage
door is to the north is closed.


>x fred
Fred is no longer here.

>l

In the garage
This room is a stinking mess, in a totally new and horrible way than the mess
you were used to.  A soiled mattress is lumped into one corner, surrounded by
filth and discarded bottles.  A door leads south into the kitchen.  The garage
door is to the north is closed.


>s

Kitchen
The kitchen has been looted and trashed, as if anger had been vented upon it
once its supplies ran out.  Every cabinet and drawer has been opened, and some
of the drawers are heaped in a broken pile on the floor.  The refrigerator is
wide open and full of disgusting green stains and patterns of blackening mold. 
The stove has been dented and shows evidence of muddy footprints having stood
on top of it and kicked it.  The small kitchen table has been overturned in the
western corner of the room.  Windows look out west and east to the back and
front yards.  The dining room is west, and the foyer is to the south.  A back
door leads north into the garage.

>s

Foyer
The entryway to your home has been used as a dumping ground for trash and
broken bottles.  The tiled floor has been scuffed and scarred, and swirled with
what looks suspiciously like tire treads.  Open doorways lead to various areas
of the house.  A broken staircase leads up to the second floor.  The front door
is east.  A hallway leads south, and the dining room is through a doorway to
the west.

>s

Downstairs hallway
The hallway is dark and feels cramped due to the collected refuse that has
built up along the wall.  Graffiti covers every flat surface, as usual.  There
is no sign of the photographs that used to hang here.  The foyer is north, and
a doorway into the living room is west.  The master bedroom is to the south.  A
small door leads east into a half bathroom.

>s

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>e

Master bathroom
This bathroom looks like it has been used as a place to party, in the
vernacular.  Various paraphernalia having to do with drug abuse is in evidence,
such as little plastic baggies, discarded needles, and the like.  It is a
shocking and somewhat depressing sight, to say the least.  The only exit is
west, back into the bedroom.

>w

Master bedroom
This is your bedroom, the one you've been longing all night to get back to. 
Unfortunately, there is no place to sleep here, even if you could close your
eyes to the general nightmare that your house has become.  The bed is missing. 
The large dresser that used to stand in the southeast corner of the room has
been toppled over, and its spilled contents have been thoroughly looted,
leaving nothing behind but some soiled linens.  Ratty curtains are open to the
west side of the house, letting some amount of somber, muted light in.  The
dimensions of the room look slightly smaller than you remember.  Perhaps it is
a trick of the eyes due to the unsettling damage.  The foyer is north through
the hallway, and the master bathroom is to the east.  A secret door is open to
the southeast.

>se

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling, but
it was left on and burned out long ago.  The only light in the passage is from
the open door.  The short hallway dead-ends at a crudely-carved staircase
leading down.  There is another door to the west, and you can go out the way
you came in.

>d

Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Storage room
This room is barely big enough to hold the time machine.  It is full of filing
cabinets, old computer equipment, stacks of old ledgers and printouts, and
other discards.  Fluorescent lighting fixtures flicker overhead.  The air is
conditioned and cold, almost antiseptic smelling.  A door leads east.

You see a time machine here.

>smell
The air is a hot furnace blast in your nostrils, smelling of baked pavement.

>open door
It's locked.

>unlock it
Unlocked.

>open it
Opened.

>out
Okay, you're no longer on the time machine platform.

>out

Sub-basement hallway
You find yourself in a long hallway stretching north and south.  Faceless,
identical doors line both sides.  The floor and ceiling are white, but the
walls are a muted blue.  To the north the hallway hits a T-intersection, and to
the south you see the hallway turn a corner to the east.  Immediately to the
west is the storage room door.

Around the corner to the south, you hear a tiny ringing noise.  It sounds like
an elevator has just arrived.

>listen
You hear footsteps vanish off into the distance.

>g
You hear footsteps vanish off into the distance.

>s

Corner
The hallway turns a corner here, from north to east.  Just ahead to the east,
the hallway dead-ends at a trio of elevators.

>e

Elevator room
The hallway dead-ends here, but this is probably as far as you need to go.  The
elevators for this floor are here.  One of them has recently arrived.  The only
way back is to the west.

>in

In the elevator
You are in a spacious, gleaming little elevator car.  A brass panel near the
doors contains a large array of possible destinations.  The only exit is out.

>x panel
The panel has a set of numbered buttons that go from 2 to 70, as well as
buttons labeled SB, B, and L.

>push 70
You push the button for floor 70.  The elevator begins to move.  After a smooth
ride, it arrives at floor 70.

>out

Floor 70 Elevators
The elevator doors part to reveal someone massive blocking your way.  Your
first instinct is to assume it is a set of muscular security guards but,
perhaps more frighteningly, it is just one, really imposing, man.  His bulk has
been fitted into a tailored, double-breasted wool suit at great expense and to
the textile industry's tremendous gain.

"You certainly know how to attract attention," he says to you.  "Don't you know
that there are security cameras everywhere?  Either you're dumber than you
look, or you wanted to be seen."

He escorts you, with no further words, to an empty holding room on the top
floor of the building.  "Please wait here," he says politely, as if you had
some choice in the matter.  The door shuts, and is locked from outside.

Holding room
There is nothing to see here, nowhere to sit, and nothing to do.  The walls are
painted a severe midnight blue.  The ceiling, twelve feet high, holds a row of
fluorescent lights.  The door, painted the same color as the walls, is only
barely visible.  There is no knob or handle on this side of the door.  There
are no exits from the room, as far as you can tell.

All of your possessions have been taken from you.

>x walls
Those aren't important.

>x door
The door is locked from outside, and lacks any way to open it from this side.

>open it
You can't open the door.

> knock on it
There is no answer.

>i
You are empty-handed.

>z
Time passes...

>z
Time passes...

>pace
I don't know the word "pace".

>z
Time passes...

>z
Time passes...

The door swings open.  It's Carl again.  You recognize him as Carl, one of
Laura's goons from ten years ago.  It seems more than likely that you are about
to be taken to meet the Laura of today.

"Come along," he says.  "You've been allowed five minutes with the Executive
Vice-President.  She's a busy woman, so hop to it."  He says this in a way that
suggests you should consider it a privilege.

You follow Carl down a series of carpeted hallways, with the doorways you pass
becoming grander and more imposing the farther you go.  You turn a final corner
and see the largest doors of them all, as if you had entered a land where
giants walk the earth and work as business executives.

Carl stops before the penultimate door, this one merely eight feet high and
made of solid slabs of redwood.  He raps it with his beefy knuckles.  The door
buzzes and pops open.

Outside the Executive VP's office
This is the office-before-the office, or one of them.  In your mind's eye you
can picture the unfolding layers of hierarchy and bureaucracy, doors that lead
to bigger doors, executive desks that are humbled by ever larger executive
desks.  This office has two such desks, sculpted antiques of dark-stained wood
with burnished, gleaming surfaces, and only tiny reminders of humanity: 
picture frames with families, post-it notes with lazy scrawls and doodles.  A
cherry-haired woman behind one of the desks asks, "Is this the 6:45?"

"You bet," says Carl, checking his gleaming, platinum watch.

"One moment, please."

Carl folds his arms, rocks on the balls of his feet and, inexplicably, flashes
you a wink.  He regards you for a moment, then extends one of his huge hands. 
"Carl," he says.

The woman at the desk says, "Ms. Remick will take the appointment now."

Carl says, "Thanks, baby."  He leads you inside.

Executive VP's office
This is not so much an office as it is a rippling gravity well of corporate
power, condensed by forces beyond imagining into an architectural metaphor for
the excesses of human vanity, lust, greed, and envy.  As much a papal audience
chamber as a prison cell fashioned from the finest materials on Earth, its
proportions so dwarf the human being at its center as to ridicule what it
purports to exalt.  Sitting on the imposing desk is a placard, a metal
suitcase, a ATM card, and a perfect blue crystal.

Lavish pillars of marble rise from a floor constructed of concentric rings of
polished black and red granite.  The ceiling vaults up into a dome, from which
hangs a futuristic, stainless-steel fixture, some sort of 21st Century
reimagining of a 16th Century chandelier, with a layered beehive shape holding
three or four dozen flashbulb-bright lamps.  A purely decorative fireplace,
framed in a bad mixture of burnished bronze and black slate, gapes open in the
west wall like a direct doorway to Hell, a mouth that laughs at what has been
wrought here.  There are ceramic vases on golden stands, gold trim slicing
through the walls, trailing like the threads on an integrated circuit chip,
leading to the apotheotic throne, the chair, at the far end of the room.  A
twenty by forty foot embroidered carpet lies underneath it, and in front of it,
a desk that felled a forest so that it might exist.

The throne chair itself is made of black leather.  Its back is nearly six feet
high.  Sitting in this contrivance is a tiny woman in a pearl white suit,
diamond jewelry flashing from every finger, each earlobe, and her neck.  Behind
her, a wall of windows reveals the purple, darkening sky.

You hear the doors shut behind you.  Carl has left you alone in here.

>get all
placard:  You can't take the placard.
metal suitcase:  You'll have to close the suitcase first.
ATM card:  Taken.
perfect blue crystal:  Taken.

>x placard
A placard on the desk reads:  'Laura Angela Remick, Executive Vice-President.'

>x laura
Sitting in the high-backed leather throne is a tiny woman in a pearl white
suit, diamond jewelry flashing from every finger, each earlobe, and her neck.

Laura looks at you.  Though she is far away, you can feel her eyes cut deeply
into you.

"Please sit," she says in an even, steady voice that has grown hushed with age.
"I have a number of things to tell you, and not much time."  She points out a
chair in front of her desk, so tiny in comparison to everything else that you
didn't even notice it before now.

"When I'm finished, you may leave.  Please."

>hi laura
I don't see her here.

>hi her
I don't see her here.

>x her
You can't reach that from here.

>x laura
Sitting in the high-backed leather throne is a tiny woman in a pearl white
suit, diamond jewelry flashing from every finger, each earlobe, and her neck.

>laura, hello
Laura says, "Hello."

>sit
(the tiny chair)
You sit down in the tiny chair.

"Thank you," Laura says, folding her fingers into a steeple that she touches to
the bridge of her nose.

Laura gazes at you from across the expanse of her desk.  She seems almost
ashamed of the ridiculous luxury around her.  You regard her as she takes a
moment to gather her thoughts, and you find yourself suddenly expecting a
confession rather than an inquisition.

Okay, you're now sitting on the tiny chair.  "Let me tell you a story," she
begins.  "It's my story.  It's the story of the Devil."  She pushes back in her
chair, shaking her head as she rises.  "Naturally, I'm not the Devil.  That's
not what I mean."

She walks to the windows and gazes from horizon to horizon.  "I'm not a
religious woman, not any more.  I don't believe in God or in Heaven.  But," she
says, facing you, "I find I have to believe in the Devil and in Hell."  She
sweeps her arms wide as she walks forward to the corner of her desk.  "This ...
is Hell."

A moaning sound issues from the fireplace, air flowing resonantly through the
flue.  "And the Devil rules it.  The Devil made it.  The Devil ..."  She leans
forward, her fingers tapping the desk's surface.  "The Devil put me here --
because I wanted it."

She straightens her jacket, smoothing the front of it as she stands up again. 
"You understand what a metaphor is, I hope.  Otherwise, you won't understand
any of this.  You're in Hell.  A metaphor for it.  It was made by the Devil --
the Devil being the name we give to another metaphor.  Christ in the
wilderness:  a metaphor meets a metaphor in a metaphorical landscape."  She
holds out her hand to you.  "Shall I complete the metaphor, by taking you to
these windows behind me, where you can gaze down upon the whole Earth below?" 
She takes back her hand.  "Or are you with me this far, and I can go on without
laboring the point?"

>ask laura about devil
Laura says, "I'm trying to tell you all I know, dear."

Laura cocks her head and a smile appears on her face.  It's the same face that
smiled up at you from the New Accounts desk forty years ago, but the smile is
different.  It's not the wrinkles and creases, the whitened hair, the change in
clothes and jewelry; it's the darkness behind the smile that's the difference. 
It's something in the eyes, or something lacking that was once there.

"Can I get you something?" Laura asks, playing hostess.  "Coffee?  Water? 
Wine?"  Her smile twists another notch.  "Wealth?  Fame?  Power?"

>no

She sobers up again.  "Fame isn't what it's cracked up to be, but I recommend
taking the rest."

She walks around behind you, far enough that you can't turn your neck far
enough to see her.  You feel her, though, as a sensation in the hair on the
back of your neck.  "I met the Devil the first of seven times when I was a
teenager.  This was before you and I met the first time, in the bank one sunny
morning four decades ago."

Suddenly, her voice is right behind your ear.  "You think I don't remember
you?" she asks.  "The Devil is in the details."  A chill runs the length of
your spine and back again.

Laura walks back into view.  "The first lie, the first promise, was about
freedom.  What else does a teenaged girl want?  When you scrape away the
superficialities, when you go to the heart of adolescent longing, this is the
tender meat, the flesh of your young soul so easily primed, probed, and
bruised.  'I will give you the freedom to do as thou wilt,' the promise goes. 
'You can be on your own, make your own rules, earn your own money, buy what you
want, date whomever you want.  Deal?'"

>no

Laura removes her suit jacket and hangs it over the back of her chair.  The
width of the chair's back makes the white sleeves stick out at acute angles. 
"Deal," Laura says.  She looks at you, watching to see if you're keeping up.

"Care to guess," she asks, "what the next six lies were?"

>x jacket
I don't see any jacket here.

>no

She picks up the metal suitcase, regards it for a moment, and then drops it
back onto the desk.

"That's right.  They were exactly the same as the first.  The deal was the
same -- I will sell you total freedom, but I'm really taking it away.  The best
part is, I'm not stealing it, you're giving it away."

Laura sits back on her black throne, the jacket-sleeve wings flaring to either
side.  "Does this look like freedom to you?"

>no

Laura leans forward across her desk, her eyes bearing down on you for a long
moment.  "Do you believe that I'm not the Devil?" she asks.  "I told you I
wasn't, but do you believe me?"

>yes

"I'm going to offer you a deal, so you had better be sure.  Because what I'm
offering you is freedom."  You expect her to smile ironically, but she does
not.

"You can take your metal suitcase, and you can walk out those doors, and you
can go back to where you came from.  You're free to go.  I could put you under
arrest for trespassing, but I won't.  I'm giving you your freedom.  But."

At last, she does smile.  "You knew there was going to be a catch, didn't you?"

>yes

"The catch is, if I give you your freedom, you have to give me back mine."  She
turns a key in a latch on the other side of the desk.  A drawer slides open,
and she removes a small, cream colored envelope sealed with red wax.  She
slides the drawer shut and locks it again.

"I want you to go back and give this to me on that first day we met.  I'll
recognize it, don't worry.  I'll recognize it, I'll read it, and I'll cease to
exist."  She stands again, dropping the envelope onto the desk.  "Not me then,
me now.  This."  She once again indicates the whole room as she turns away and
walks toward the gaping mouth of the fireplace.  It was farther away and larger
than you had thought.  Laura looks like a morsel ready to be swallowed whole by
it.  "This," she concludes, "will cease to exist."

She turns to face you again.  "I'm prepared to die.  I'm prepared for
nothingness to consume me as soon as you climb on that shiny little machine of
yours and vanish.  What will the suddenness of nonexistence feel like?  To be
blotted out, not like dying, but as in never having ever existed in the first
place?  No one will remember that I had a chance to live, and I chose to turn
out like this."  She regards you from across the room and begins to remove her
jewelry.  One by one, she tosses each piece into the fireplace.  "You, though. 
You'll remember."

She strips completely naked, revealing a pale old woman's body, and tosses her
clothes, too, into the fireplace.  It is a ghastly but hypnotic sight, one that
leaves you trembling slightly.  "Try to forget," she says.  "Try."

She touches a button on the wall, and orange flames belch into roaring life,
consuming quickly everything in the fireplace.  Laura stands naked in front of
the curling flames, gazing at them for a long time.

"Go," she says, shouting over the noise of the fire.  "I'm finished."

>get all from desk
placard:  You can't take the placard.
metal suitcase:  You'll have to close the suitcase first.
sealed envelope:  Taken.

>close case
Closed.

>take it
Taken.

>x envelope
It is a cream colored envelope, the kind that holds small stationery.  It has
been sealed shut with red wax.

>ask her about envelope
She has nothing more to say.

>x wax
The red wax is sealing the envelope shut.  There is a tiny imprint in the wax
of the initials "L.R."

>open wax
It is not for you to open.

>out
You're not going anywhere until you get out of the tiny chair.

>get out
(the tiny chair)
You arise, warily, from the tiny chair.  Laura nods at you.

Laura says, "Don't leave without your things."  She doesn't look around.

>i
You are carrying:
   a ATM card
   a perfect blue crystal
   a sealed envelope
   a metal suitcase

>s

Carl escorts you out of the office and into the elevator.  He pushes the button
for the sub-basement and stares straight ahead, saying nothing.  When the
elevator stops, he looks at you.

"I don't claim to understand this," he says soberly.  Then he affects a caveman
voice and says, "Carl only pawn, in game of life."  He laughs roughly as he
walks you back to the storage room, gives you a final nod, and shuts the door
behind you.

Storage room
This room is barely big enough to hold the time machine.  It is full of filing
cabinets, old computer equipment, stacks of old ledgers and printouts, and
other discards.  Fluorescent lighting fixtures flicker overhead.  The air is
conditioned and cold, almost antiseptic smelling.  A door leads east.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you, spinning into a wild vortex that suddenly vanishes, leaving you
to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>feel machine
The time machine feels hot.

>g
The time machine feels very warm.

>g
The time machine feels very warm.

>g
The time machine feels warm.

>g
The time machine feels warm.

>g
The time machine feels slightly warm.

>g
The time machine feels slightly warm.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you, spinning into a wild vortex that suddenly vanishes, leaving you
to find yourself in a ...


Crystal cavern
You are in a large cavern that seems to be an enormous natural geode, with
crystals as big as your head growing in splints and shafts from every
direction.  A pool of white water catches the reflected and refracted light and
spins it back into the room, where it is caught and re-refracted.  The original
source of the light seems to be a series of pinholes in the roof of the cavern
high above, but you don't think it could be sunlight.  You have lost track of
how deep you have gone, perhaps twenty, perhaps forty feet under the surface,
but too far down to see sunlight, you would have thought.  It is possible that
sunlight has periscoped down a set of small crystal encrusted shafts that lead
far enough up to see the open sky.  In any case, it is literally mesmerizing to
be here.  The only exit is a tunnel to the west.

You see crystals and a time machine here.

>undo
(Undoing one command)


Secret chamber (on the time machine platform)
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get off
(the time machine platform)
Okay, you're no longer on the time machine platform.

>u

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>sw
There is nowhere to go in that direction.

>s

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>sw

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you.  The world around you spins into a wild vortex that suddenly
vanishes, leaving you to find yourself in a ...


Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  Sitting on the
time machine platform is a wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>ne

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>ne

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>n

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  The
lobby is back to the north.

Laura, a bank employee, is sitting at the new accounts desk.

>hi laura
Laura smiles and says, "Good morning.  How can I help you?"

>show envelope to laura
Laura isn't impressed.

>give envelope to laura
Laura reacts with curious surprise as you hold out the sealed envelope to her. 
"What's this?"  she asks.  She gingerly breaks the red wax seal, trying to
preserve it.  "How fancy," she says, drawing out a letter written on brittle,
translucent stationery.

Laura begins to read the letter.  Before she even finishes the first page, she
abruptly stands up, her hand going to her throat.  She looks at you, and you
stare blankly back.  "Did ..." she starts to say, but breaks off.  She reads
the remaining two pages, then folds them back into the envelope and closes it.

"Could you excuse me for a moment?  I think I have to quit my job now."  She
looks like she's in a state of mild shock as she turns on her heels and walks,
almost in slow motion, from her desk and into the back corridors of the bank.

[ Your score just went up by 10 points. ]

>full
In a total of 1343 turns, you have achieved a score of 140 points out of a
possible 151, which means you are a master adventurer.  You have earned the
following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 5 points for arriving in the future the first time
 4 points for giving the bad shingle to the architect
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
10 points for leaping to the attic
 1 point for using the tire to break your fall from the attic
 5 points for giving a piping hot sandwich to the architect
 5 points for entering the secret passage the first time
 7 points for opening a new bank account
 7 points for showing Fred his future self
 4 points for installing the lightning rod
 5 points for buying DibbleBits stock
10 points for giving Laura the sealed envelope
20 points for finding various items

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>e

In the village
The little shopping village looks a lot different than you're used to seeing
it.  The sandwich shop is there, to the north, but it doesn't look like it's
open for business yet.  To the west is the bank, which seems like it's always
been here and always will.  To the east is an antique store, where the public
library will be.  The road leading back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these thirty- to eighty-year-old live oaks.  The road
leads north into the old shopping village, and a path winds back into the
forest to the southwest.

>s
There is nowhere to go in that direction.

>sw

Sloping wood
The ground slopes down here, eroded by the nearby stream.  Grasses heavy with
fresh dew and spring-saturated soil give the area a soft, spongy feel beneath
your feet.  The stream leads back southwest, and far ahead through the trees to
the northeast, you can see a road of some kind.

You see a soft spot and a little mound of dirt here.

>sw

Path in the woods
A natural path made by the stream winds through a natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way, and
the stream does an abrupt curve around it.  The stream runs from the northeast
to the south, and a clearing is visible to the southwest.

>sw
You push your way into the clearing, opening your usual path once again.

Forest
The woods surround you on all sides, although there is enough space around you
to consider it a clearing of sorts.  Light streams prettily through the canopy
of leaves above.  The ground is hard and flat and clean.

You can hear the soft gurgling of a stream nearby, but the foliage is so rich
and dense that the sound of it is dispersed.  You aren't sure from which
direction it originates.  You can see your usual path through the grove of
trees to the northeast.

You see a hacked path leading south and a time machine here.  Sitting on the
time machine platform is a wheelbarrow.

>get on
What do you want to get on?

>platform
Okay, you're now standing on the time machine platform.

>set dial to 4
Okay, it's now turned to 4.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>ne
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>ne

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>ne

Front of house
You are standing in what will be the front of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  A construction blockade is to the northeast,
preventing you from stepping on the freshly-poured cement driveway.  You can
walk around the house to the northwest and southwest.  You can go around the
driveway and find the road into town to the southeast.

>se

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>n
There is nowhere to go in that direction.

>e

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>n

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

>w
There is nowhere to go in that direction.

>n

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>w

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>s

New accounts
The new accounts area is a clean little area in the corner of the bank.  No one
seems to be here.  The lobby is back to the north.

>n

In the bank
The bank interior is polished and impeccable.  A desk to the south says "New
Accounts."  A teller window to the north is labeled "Deposits and Withdrawals."
A hallway leads west into the bank's back offices.  The exit is east.

>w
The teller says, "Excuse me, but bank customers are not allowed to go into the
back offices."

>e

In the village
The little shopping village looks a little different than you're used to seeing
it.  Colored signs point you to this merchant and that.  To the west is the
bank, which seems like it's always been here and always will.  To the east is
an empty plot of land.  The sandwich shop is to the north.  The road leading
back is south.

>s

Oakwood drive
This pleasant road wanders peacefully through the lush tree growths native to
the area.  In the intervening years, they'll straighten the road and widen it,
cutting down dozens of these forty- to ninety-year-old live oaks.  The road
leads north into the shopping village, and south to a familiar bend in the
direction of your house.

>s

Bend in path
The unpaved dirt road that leads in the direction of the construction site has
been crisscrossed by a number of vehicles with large treads.  By the side of
the road, water trickles under a sewer grating.  The road bends here from the
west to the north, following a scenic paved road into the shopping village.

>sw
There is nowhere to go in that direction.

>s
There is nowhere to go in that direction.

>se
There is nowhere to go in that direction.

>sw
There is nowhere to go in that direction.

>nw
There is nowhere to go in that direction.

>w

Sidewalk
The concrete sidewalk that leads away from your house is also recently poured. 
It follows alongside a dirt road that will soon be paved.  The sidewalk
disappears to the east, just before the road takes a bend to the north.  The
construction site is back to the west.

>w

South of house
You are standing on what will be the south side of your house.  The house is
currently under construction.  The wooden frame has gone up, but apart from
that, there's not much to see.  The ground slopes down slightly here, and the
wall of the house looms an extra story high because of it.  A little bare path
made by you just now leads southwest into the woods.  You can walk around the
house to the northwest and northeast.  To the east is a dirt road leading to
town.

You see a sapling here.

>sw

Woods
The smell of freshly-sawed wood wafts through this natural grove of cedar and
live oak trees.  A large rock juts up out of the ground right in your way.  A
construction site is to the northeast, and a clearing is visible to the
southwest.

>sw

Clearing
The woods part in a marvelous natural clearing here.  Light streams prettily
through the canopy of leaves above.  The ground is hard and flat and clean. 
You can hear the busy noise of construction work nearby, coming through the
woods from the northeast.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>get on platform
Okay, you're now standing on the time machine platform.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A bright blue
light envelops you.  The world around you spins into a wild vortex that
suddenly vanishes, leaving you to find yourself in a ...


Clearing
The woods part in a marvelous natural clearing here.  Moonlight streams
prettily through the canopy of leaves above.  The ground is hard and flat and
clean.  Your footpath leaves the clearing to the northeast, heading back to the
house.

You see a time machine here.  Sitting on the time machine platform is a
wheelbarrow.

>off
Okay, you're no longer on the time machine platform.

>ne

Path in the woods
This little spot is one of your favorite places to sit and think.  A well-trod
path winds through a natural grove of cedar and live oak trees.  A large rock
juts up out of the ground right in your way, so the path does an abrupt curve
around it.  The path leads northeast to your house, and a clearing is visible
to the southwest.

>ne

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>d

Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get on
What do you want to get on?

>platform
Okay, you're now standing on the time machine platform.

>set dial to 5
Okay, it's now turned to 5.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Laboratory
From the look of things, time machines are built here.  The room is thirty feet
square, with a fifteen foot ceiling.  Rows of refrigeration ducts and sealed-
off tubes poke through the wall on the north side.  Along the east wall is a
set of poster-sized pictures detailing the development from the first, room-
sized prototype to machines that look similar to the ones you have been using. 
Drafts of engineering blueprints are tacked to the remaining walls.  A busy
workdesk is set up to one side.  You see various unrecognizable machine parts
and prototypes in various stages of assembly, and one unused electrical socket.
A carpeted staircase to the south leads up.

You see a time machine here.

[ Your score just went up by 5 points. ]

>x schematics
The engineering schematics are beyond your current understanding, although some
of this is beginning to make a glimmer of sense to you.  You recognize some of
the plans from the time machine manual, but it's going to be a long time before
you can construct anything like them yourself.

>off
Okay, you're no longer on the time machine platform.

>u

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A new light bulb hangs from the ceiling, but it
is currently turned off.  The only light in the passage is from the open door. 
The short hallway dead-ends at a crudely-carved staircase leading down.  There
is another door to the west, and you can go out the way you came in.

>w
(Opening the west door)

Exhibition room
What used to be your master bedroom is now an exhibition room, full of colorful
photographs, charts, and schematics, as well as a video projection providing a
family-friendly documentary about the museum.  The lobby is back to the north. 
A secret door is open to the southeast.

A young man approaches from the north, smiling broadly.  His smile gets even
wider as he says, "It's you!  Look at you!" and, laughing, embraces you with
his strong young arms.

"Sorry, I guess you weren't expecting that," he says.  "Come in, come in."  He
steps back to the north, waving you to follow.

>x schematics
I don't see any schematics here.

>x young man
I don't see any young man here.

>follow man
I don't see any man here.

>n

Museum lobby
The lobby of the museum is homelike and welcoming.  What used to be a tiled
floor has been replaced with polished wood, and tasteful decorations hang on
the walls.  A visitor information desk has been set up here, but no one is
staffing it at the moment.  The front door is east, and hallways lead south and
north.  A wide staircase leads up.

The young man is here.
The young man says, "So, what do you think?  Pretty nice, huh?"

>x him
You can't reach that from here.

>x man
He is about eighteen years old, with a head of dark hair that has been tamed
into submission with a thick application of fragrant gel.  He has intelligent
brown eyes and a bright smile.  He's wearing a pair of shorts and some sort of
souvenir t-shirt.  The young man rocks back and forth on his feet.  "Hey, I
know.  Would you like me to show you around?" he asks.  "Should I give you the
grand tour?"

>x him
You can't reach that from here.

>what is him
You haven't seen him yet.  The young man gives you a friendly punch in the arm.
"You need to be more decisive," he says.  "Come on, it'll be fun.  Follow me."

>who is him
You haven't seen him yet.  He starts by leading you upstairs.

Upstairs hallway
The staircase ends at a slightly expanded upper hallway.  The doors lead north
and south, as usual, but into tiny offices stuffed with files and computers. 
In place of the upstairs bathroom is yet a third office.  You almost wonder how
many people are really needed to staff such a place as this.  It's starting to
seem like a surreal joke of some kind.  The staircase leads back down.  It also
leads up to the third floor, but a velvet rope has been strung across it as a
barrier to museum visitors.
He says, "The upstairs kind of looks the same as always, except we've added
another floor on top."  He gestures to the staircase.  "Upstairs are staff
offices for the museum.  Kind of boring.  Well, let me show you anyway."

He takes you past the rope and up another flight of stairs.  It's a small
hallway with doors leading off into offices.  On one wall is an enlarged
picture of you, looking a bit older, standing next to a time machine in the
clearing.  A small team of people you don't recognize are hugging shoulders
with you.

The young man notices your interest in the picture and says, "Yeah, how about
that, huh?  I can't tell you when that's taken, of course, but it's not far
off."  He briefly takes you out onto a balcony that provides a grand view of
the area.  The shopping village has expanded, but you see that many new trees
have been planted in the area, replacing the old trees that were removed from
Oakwood Drive ages ago.

"Come on, there's more to see," he says.

The young man leads you back downstairs to the lobby, and then north into the
new wing of the house.  In fact, this is the only part of the house that is
still living quarters, he explains.  "This is where we live," he says.  "We
decided to keep the old house open as a museum, so we had to move somewhere
new, so we built this wing.  It's only been a year or so.  You can kind of
still smell the fresh paint."

He leads you to a door at the east end of a hallway full of golden afternoon
light.  He raps his knuckles on the door and says, "We've invited some guests
today who were anxious to greet you," he says, smiling enigmatically.  "You
ready for this?"

>no
The young man says, "Are you sure you don't want to see them?  Okay, suit
yourself."  He starts walking away, back to the lobby.  Laughing, he turns and
says, "I've never been a very good kidder.  Come on.  And brace yourself."  He
opens the door into a large salon of paneled wood and tasteful chairs.  Sitting
in the chairs, and rising as you enter, are two people you recognize and three
you do not, including two children.

Laura, looking mature with her silvered hair but as vibrant as ever, approaches
first, giving you a hug.  "Apparently we're somewhat beholden to each other,"
she says, with a bright twinkle in her eyes.  "You put me on quite a different
path forty years ago, one of environmental activism and fighting corporate
interests.  I know you're probably curious what that letter said.  All I can
tell you is that the first part was full of secrets that I never told anyone,
and the second part was a set of warnings, and the third part was a set of
wishes."  She idly picks a bit of lint off of your shirt.  "Good wishes, from a
bad person."  She gives you a small kiss and steps aside.

Unsurprisingly, the other person is Fred, looking trimmer than you've ever seen
him, but with the same smile, below the same cheesy mustache, on his tanned
face.  He gives you a hearty handshake and introduces you to his wife, Carla,
and their two kids, Gary and Fred Jr.  "Sandwich shop's still open," he says,
looking for small talk to fill the strange awkwardness of the moment.  "In
fact, we've got local franchises now.  I'm running a couple of them."  He
roughs up Fred Jr.'s hair.  "Gotta keep these hungry mouths fed.  Heh heh, what
can you do?"  He draws his hand several times across his chin, staring at you. 
"Man, can you believe this?  Same as ever.  Same as ever."

There is another few minutes of idle chit-chat, but the young man breaks in. 
"We've gotta go folks, thanks for coming, though."  Fred says, "Yeah, we gotta
get going, too.  Thanks for the invite.  Nobody believes me when I tell them
that this museum is for real, but you got my vote, I'll tell you that right
now."

The young man escorts everyone back to the lobby.  Laura, Fred, and Fred's
family wave and depart.

"Let's go back downstairs," he says.  He leads you to the south, back through
the secret passage, and down into the laboratory.

Laboratory
From the look of things, time machines are built here.  The room is thirty feet
square, with a fifteen foot ceiling.  Rows of refrigeration ducts and sealed-
off tubes poke through the wall on the north side.  Along the east wall is a
set of poster-sized pictures detailing the development from the first, room-
sized prototype to machines that look similar to the ones you have been using. 
Drafts of engineering blueprints are tacked to the remaining walls.  A busy
workdesk is set up to one side.  You see various unrecognizable machine parts
and prototypes in various stages of assembly, and one unused electrical socket.
A carpeted staircase to the south leads up.

You see a time machine here.

The young man is here.

>ask young man about time machine
The young man says, "Sorry, I've been instructed not to answer any questions,
even if they seem innocuous."  He smiles and says, "Besides, we don't have much
time."  "This is where it all begins," he says.  "Well, sort of.  It's a long
story.  A retroactive effort was made -- or will be made -- to preserve the
crystal cavern that used to be here in this spot.  He searches a drawer of the
workdesk and withdraws a small tube of plastic.  Sealed inside the tube,
preserving it, is a shimmering blue crystal, about an inch long, with perfect
hexagonal symmetry.  He plops it back in the drawer.  "Can't have you running
off with that," he says.  "That'd really screw things up, let me tell you."

He looks at his watch.  "Speaking of which, we've got to wrap this up and send
you home.  Oh!"  He fidgets in his pocket.  "First things first, though."  He
withdraws a key and puts it on the workdesk.

"I've been instructed to tell you that you can't take this key back with you,"
he says apologetically, "but I've been led to understand that you've come
prepared to make a copy ...?"  He starts to head back upstairs.  "I'll be
waiting in the lobby.  Just bring the original back to me when you're done. 
Thanks."  He takes a long, funny, grinning look at you, and hops up the stairs
three at a time.

>x socket
I see nothing special about the socket.

>get key
Taken.

It's a key to your house, all right, but it doesn't look like the original one
that was missing from your doormat.  It's a copy, but an old one from the looks
of it.  It has the markings and smoothness of having been used for many years.

>s

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A new light bulb hangs from the ceiling, but it
is currently turned off.  The only light in the passage is from the open door. 
The short hallway dead-ends at a crudely-carved staircase leading down.  There
is another door to the west, and you can go out the way you came in.

>s
(Opening the main door)

South of house
The ground slopes here slightly, with cobblestones leading southwest to the
path through the lawn.  A little window sits high above in the wall, which has
been painted a demure white.  A couple of flagstones and some tiny hedges make
the landscaping complete.  A fence prevents passage northwest to the rear
entrance.  The path leads northeast to the front of the building, and the lawn
lies to the southwest.  A secret door is open to the north.

>sw

Lawn
A manicured lawn, watered frequently by a built-in sprinkler system, surrounds
the building, which seems to be your house, only a story taller.  A large rock
sits in a circle of gravel adjacent to the footpath, and a plaque has been
affixed to it near the bottom.  A footpath leads northeast to the south side of
the white building, and a pretty garden is to the southwest.

>sw

Pretty garden
Light pours prettily onto the grounds of a small garden, bursting with flowers
wild and rare.  A fountain pool graced by a whitewashed bench adds to the charm
of this little area.  A footpath leads northeast to a fresh green lawn, and
beyond that, a white building.

>sw
There is nowhere to go in that direction.

>x time machine
I don't see any time machine here.

>l

Pretty garden
Light pours prettily onto the grounds of a small garden, bursting with flowers
wild and rare.  A fountain pool graced by a whitewashed bench adds to the charm
of this little area.  A footpath leads northeast to a fresh green lawn, and
beyond that, a white building.

>ne

Lawn
A manicured lawn, watered frequently by a built-in sprinkler system, surrounds
the building, which seems to be your house, only a story taller.  A large rock
sits in a circle of gravel adjacent to the footpath, and a plaque has been
affixed to it near the bottom.  A footpath leads northeast to the south side of
the white building, and a pretty garden is to the southwest.

>ne

South of house
The ground slopes here slightly, with cobblestones leading southwest to the
path through the lawn.  A little window sits high above in the wall, which has
been painted a demure white.  A couple of flagstones and some tiny hedges make
the landscaping complete.  A fence prevents passage northwest to the rear
entrance.  The path leads northeast to the front of the building, and the lawn
lies to the southwest.  A secret door is open to the north.

>d
There is nowhere to go in that direction.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A new light bulb hangs from the ceiling, but it
is currently turned off.  The only light in the passage is from the open door. 
The short hallway dead-ends at a crudely-carved staircase leading down.  There
is another door to the west, and you can go out the way you came in.

>w

Exhibition room
What used to be your master bedroom is now an exhibition room, full of colorful
photographs, charts, and schematics, as well as a video projection providing a
family-friendly documentary about the museum.  The lobby is back to the north. 
A secret door is open to the southeast.

>n

Museum lobby
The lobby of the museum is homelike and welcoming.  What used to be a tiled
floor has been replaced with polished wood, and tasteful decorations hang on
the walls.  A visitor information desk has been set up here, but no one is
staffing it at the moment.  The front door is east, and hallways lead south and
north.  A wide staircase leads up.

The young man is here.

>u
You are suddenly overcome by the fatigue of a long and very sleepless day.  Or
night.  Or something.  You really need to finish up your last bit of business
and go straight home to bed, rather than exploring the house again.  Chances
are, in twenty years you'll be seeing quite a lot of it anyway.

>s

Exhibition room
What used to be your master bedroom is now an exhibition room, full of colorful
photographs, charts, and schematics, as well as a video projection providing a
family-friendly documentary about the museum.  The lobby is back to the north. 
A secret door is open to the southeast.

>e
There is nowhere to go in that direction.

>se

>d
There is nowhere to go in that direction.

>l

Exhibition room
What used to be your master bedroom is now an exhibition room, full of colorful
photographs, charts, and schematics, as well as a video projection providing a
family-friendly documentary about the museum.  The lobby is back to the north. 
A secret door is open to the southeast.

>se

>enter door

>e
There is nowhere to go in that direction.

>se

>kertimetravel
You invoke the magic word to turn into a rich wizard.  Phreeeow!  You suddenly
have superhuman strength, and you're surrounded by a strange ethereal glow
which permits you to enter darkened places with impunity!  You put the money
into the metal suitcase along with the rest of it.

>undo
(Undoing one command)


Exhibition room
What used to be your master bedroom is now an exhibition room, full of colorful
photographs, charts, and schematics, as well as a video projection providing a
family-friendly documentary about the museum.  The lobby is back to the north. 
A secret door is open to the southeast.

>n

Museum lobby
The lobby of the museum is homelike and welcoming.  What used to be a tiled
floor has been replaced with polished wood, and tasteful decorations hang on
the walls.  A visitor information desk has been set up here, but no one is
staffing it at the moment.  The front door is east, and hallways lead south and
north.  A wide staircase leads up.

The young man is here.

>e
You'll have to open the front door first.

>open door
It's locked.

>unlock it
Unlocked.

>e
(Opening the front door)

Front of museum
You are in the front of your house, but you can see from here that it is no
longer a simple residence.  A signpost hanging above the stoop says that it is
a laboratory museum.  A footpath leads southwest.  The driveway is to the
northeast.  The front door, as always, is to the west.

You see a familiar doormat here.

>look under mat
You find a small note, which you take.

>read it
It is addressed to you.  It reads, "We've been expecting you.  Please knock to
let us know you've arrived.  We have something you've been missing."

>knock on door
You knock on the front door.  There is no response.

>sw

South of museum
The ground slopes here slightly, with cobblestones leading southwest to the
path through the lawn.  A little window sits high above in the wall, which has
been painted a demure white.  A couple of flagstones and some tiny hedges make
the landscaping complete.  A fence prevents passage northwest to the rear
entrance.  The path leads northeast to the front of the building, and the lawn
lies to the southwest.  A secret door is open to the north.

>n

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A new light bulb hangs from the ceiling, but it
is currently turned off.  The only light in the passage is from the open door. 
The short hallway dead-ends at a crudely-carved staircase leading down.  There
is another door to the west, and you can go out the way you came in.

>d

Laboratory
From the look of things, time machines are built here.  The room is thirty feet
square, with a fifteen foot ceiling.  Rows of refrigeration ducts and sealed-
off tubes poke through the wall on the north side.  Along the east wall is a
set of poster-sized pictures detailing the development from the first, room-
sized prototype to machines that look similar to the ones you have been using. 
Drafts of engineering blueprints are tacked to the remaining walls.  A busy
workdesk is set up to one side.  You see various unrecognizable machine parts
and prototypes in various stages of assembly, and one unused electrical socket.
A carpeted staircase to the south leads up.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You aren't allowed to take the original front door key back in time with you.

>put original key on desk
Done.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you, spinning into a wild vortex that suddenly vanishes, leaving you
to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>u
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

You see a motorized grinder here.  The motorized grinder seems to contain a
blank.

>get grinder
You've already got your hands full.

>i
You are carrying:
   a ATM card
   a perfect blue crystal
   a metal suitcase
   a small note

>put grinder in case
The metal suitcase is closed.

>open case
Opening the metal suitcase reveals some money (1000 dollars), a blue pencil,
and a newspaper.

>put grinder in case
Done.

>d

Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 5
Okay, it's now turned to 5.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A blinding purple
light envelops you, spinning into a wild vortex that suddenly vanishes, leaving
you to find yourself in a ...


Laboratory
From the look of things, time machines are built here.  The room is thirty feet
square, with a fifteen foot ceiling.  Rows of refrigeration ducts and sealed-
off tubes poke through the wall on the north side.  Along the east wall is a
set of poster-sized pictures detailing the development from the first, room-
sized prototype to machines that look similar to the ones you have been using. 
Drafts of engineering blueprints are tacked to the remaining walls.  A busy
workdesk is set up to one side.  You see various unrecognizable machine parts
and prototypes in various stages of assembly, and one unused electrical socket.
A carpeted staircase to the south leads up.

You see a time machine here.  Sitting on the laboratory workdesk is a front
door key.

>off
Okay, you're no longer on the time machine platform.

>put grinder on desk
Done.

>plug grinder in socket
Okay, you plug the motorized grinder into the socket.

>turn grinder on
The motorized grinder turns on and hums for a few seconds.  Finding nothing to
do, it automatically turns itself off.

>put original key in grinder
Done.

>turn grinder on
You turn on the grinder, and the lathe goes to work, slicing the blank key into
a duplicate of the original front door key.

Its work done, the motorized grinder automatically turns itself off.

[ Your score just went up by 5 points. ]

>get copy
Taken.

>i
You are carrying:
   a ATM card
   a perfect blue crystal
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a small note
   a original front door key

>i
You are carrying:
   a ATM card
   a perfect blue crystal
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a small note
   a original front door key

>get all from grinder
shiny new duplicate house key:  Taken.

>i
You are carrying:
   a ATM card
   a perfect blue crystal
   a metal suitcase
       some money (1000 dollars)
       a blue pencil
       a newspaper
   a small note
   a original front door key
   a shiny new duplicate house key

>put original key on desk
Done.

>get on machine
Okay, you're now standing on the time machine platform.

>set dial to 1
Okay, it's now turned to 1.

>push button
You push the big red button.  Click!

The time machine vibrates and heats up like a toaster oven.  A deep red light
envelops you, spinning into a wild vortex that suddenly vanishes, leaving you
to find yourself in a ...


Secret chamber
Whether this nondescript room existed before the secret passage was made is
unclear to you, but here it is now.  It is made of concrete, about thirty feet
square, with a fifteen foot ceiling.  The floor of room must be at least twenty
feet below the ground.  The dim amber light, just enough to see by, seems to be
coming from the ceiling itself, rather than any kind of recognizable fixture. 
The only exit that you can see is back up.

You see a time machine here.

>u
(first getting off the platform)
Okay, you're no longer on the time machine platform.

Secret passage
The secret passage is a narrow hallway of sorts, only about twelve feet long
and three and a half feet wide.  The walls are bare plaster and sheet rock. 
Various springs and tumblers are connected together in an elegant set of
mechanisms to open the doors.  A small light bulb hangs from the ceiling,
giving the room some gentle illumnation.  The short hallway dead-ends at a
crudely-carved staircase leading down.  There is another door to the west, and
you can go out the way you came in.

>s

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>sw

South of house
The ground slopes down slightly here, and the wall of the house looms an extra
story high because of it.  There is a tiny window high in the wall, about 30
feet up.  There is a rope dangling from the window, and a tire is tied to its
bottom end.  A little path made by you on your many daily walks leads southwest
into the woods.  You can walk around your house to the northwest and northeast.
A secret door is open to the north.

A beautiful, leafy tree is growing here next to the house, right where you
always thought it should.

>x tree
It's a whopper!

>ne

Front of house
This is the front of your house.  A couple of stones laying about make up your
half-hearted attempt at landscaping.  Your driveway is to the northeast.  A
small path leads northwest and southwest.  The front door stands invitingly to
the west.

You see a doormat here.

>unlock front door with key
Unlocked!  You can barely believe it.

>put key under mat
You put the shiny new duplicate house key under the doormat.  A sudden sense of
satisfaction comes over you, as if you had taken care of the last bit of
unfinished business.

[ Your score just went up by 1 point. ]

>open door
Opened.

>in

You have won!
You step into your house at long last, head straight for your bedroom, and
dream your dreamy dreams of one day inventing a time travel machine...  but
they're no longer just dreams, are they?



*** You have won ***

In a total of 1473 turns, you have achieved a score of 151 points out of a
possible 151, which means you are at last a raving success!

You may restore a saved game, start over, quit, or undo the current command.

Please enter RESTORE, RESTART, QUIT, FULLSCORE, or UNDO:  >fullscore
In a total of 1473 turns, you have achieved a score of 151 points out of a
possible 151, which means you are at last a raving success!You have earned the
following:

 5 points for finding the garage door opener
 4 points for climbing onto the roof the first time
10 points for getting to the end of the junk in the garage
 5 points for stepping onto the platform the first time
 5 points for arriving in the far past the first time
 5 points for arriving in the past the first time
 5 points for arriving in the future the first time
 4 points for giving the bad shingle to the architect
 3 points for cleaning out the drainpipe
 4 points for making it through the maze to the stream
 6 points for planting the acorn in the hole
 2 points for fixing the wheel with the screwdriver
 3 points for pouring a second jug of miracle-gro
 5 points for pouring a fifth jug of miracle-gro
10 points for leaping to the attic
 1 point for using the tire to break your fall from the attic
 5 points for giving a piping hot sandwich to the architect
 5 points for entering the secret passage the first time
 7 points for opening a new bank account
 7 points for showing Fred his future self
 4 points for installing the lightning rod
 5 points for buying DibbleBits stock
10 points for giving Laura the sealed envelope
 5 points for arriving in the new far future for the first time
 5 points for grinding a duplicate front door key
 1 point for putting the duplicate key under the doormat
20 points for finding various items

Please enter RESTORE, RESTART, QUIT, FULLSCORE, or UNDO:  >q

Please enter RESTORE, RESTART, QUIT, FULLSCORE, or UNDO:  >quit

Thank you for playing First Things First.
