#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

#define gActionWas(action)\
    (me.lastAction != nil && me.lastAction.actionOfKind(action##Action))
#define gLastDobj (me.lastAction.getDobj())
#define gLastIobj (me.lastAction.getIobj())
#define gLastTopic (me.lastAction.getTopic())
#define gLastTopicText (gLastTopic.getTopicText.toLower())

modify Goal
    goalDisplayed = nil
    displaySubItem(idx, lastBeforeInput, eol)
    {
        inherited(idx, lastBeforeInput, eol);
        if(idx == menuContents.length())
            goalDisplayed = true;            
    }
;

topHintMenu: TopHintMenu 'Hints'
;

/*  
 *   OUTDOORS
 *
 *   (1) general hint
 *   (2) finding the skateboard
     (3) getting into the house
     (4) getting at the window
     (5) getting the car out of the way
     (6) luring mrs. pepper out of the house
     (7) finding the neighbor's brooch (put here so the hint menu
            on the cellar won't open until you've been there)
 */

+HintMenu 'Outdoors';

++ Goal 'What am I meant to be doing?'
    [ 
        'Try looking around and exploring a little. Something interesting
        is bound to happen before very long. ',
        
        skateBoardHint,
        
        'Before long you<./s>ll discover that something sinister is afoot
        on Mrs.\ Pepper<./s>s property. All of your cleverness will be
        needed to set things right. '
        
    ]
    openWhenTrue = true
    closeWhenTrue = skateboardGoal.goalState != UndiscoveredGoal
;

+++ skateBoardHint: Hint 'You could always try looking for your skateboard. '
    [skateboardGoal]
;

++ skateboardGoal: Goal 'Where can I find my skateboard?'
    [
        'Well, it was Mrs.\ Pepper who took it from you. ',
        'So presumably it<./s>ll be hidden somewhere on her property. ',
        'It doesn<./s>t really seem the kind of thing she<./s>d want for herself.
        ',
        'So perhaps she just tossed it out of the way somewhere. ',
        'How thoroughly have you searched the grounds? ',
        'Have you been into the back yard yet? ',
        'What did you see there? ',
        'If you didn<./s>t see anything interesting, perhaps you should hang
        around there a little longer. ',
        'Did you notice anything moving around in the back yard --- some kind
        of animal, perhaps? ',
        'The animal itself isn<./s>t important. ',
        'Did you notice where it went? ',
        'It went under the back porch. ',
        'Is there anything else under the porch? '
    ]
    closeWhenAchieved = porchFromBackYard.achievement
    openWhenRevealed = 'skate-find'
;

++ Goal 'How can I retrieve my skateboard?'
    [
        'Presumably you<./s>ve tried taking it. ',
        'But it<./s>s out of reach, which suggests...',
        '...that you need something long to reach it with. ',
        'You aren<./s>t in a position to find that object just yet. '
    ]
    openWhenAchieved = porchFromBackYard.achievement
    closeWhenAchieved = keyBunch.achievement
;

++ Goal 'How can I retrieve my skateboard?'
    [
        'It looks as if you need something long and thin to move it with. ',
        'A piece of gardening equipment, perhaps? ',
        'Where might such a thing be kept? ',
        'Have you looked in the garage? ',
        'The rake would probably do the job. ',
        'Try moving the skateboard with the rake. '
    ]
    openWhenTrue = ((keyBunch.moved && skateboard.seen))
    closeWhenAchieved = skateboard.achievement
;


/* (2) GETTING INTO THE HOUSE */

++ Goal 'What should I be doing about that voice I heard?'
    [
        'It seemed to be coming from inside the house. ',
        houseHint,
        'But you wouldn<./s>t want to just barge in while Mrs.\
        Pepper is there. There<./s>s no telling what she might
        do! '
    ]
    openWhenRevealed = 'elf-cry'
    closeWhenAchieved = kitchenWindow.achievement
;

+++ houseHint: Hint 'So it seems you need to find a way to get inside. '
    [houseGoal]
;

++ houseGoal: Goal 'How can I get inside the house?'
    [
        'Have you tried ringing the doorbell? ',
        'It doesn<./s>t look like Mrs.\ Pepper is going to let you in. ',
        'So you<./s>ll have to find another way in. ',
        'How else might you get into a house, other than through a door? ',
        'What other openings does a house generally have? ',
        'Are there any windows you could use? ',
        'Is there an open window anywhere? ',
        windowHint
    ]
    closeWhenAchieved = kitchenWindow.achievement
;

+++ windowHint: Hint 'Try the window at the side of the house, where Mrs.\
    Pepper parks her car. '
    [windowGoal]
;

++ windowGoal: Goal 'How can I reach the open window at the side of the house?'
    [
        'It<./s>s clearly too high up for you to reach from the ground. ',
        'And jumping doesn<./s>t seem to help much either. ',
        'So what might you do to increase your effective height? ',
        'Standing on something might be a good idea. ',
        'Is there something nearby you could try standing on? ',
        'The trash can, perhaps? ',
        dustbinHint
    ]
    openWhenRevealed = 'window-reach'
    closeWhenAchieved = kitchenWindow.achievement
;

+++ dustbinHint: Hint 
    'But first you need to move the trash can nearer the window. '
    [dustbinGoal]    
;

++ dustbinGoal: Goal 'How can I get the trash can nearer the window?'
    [
        'Presumably you<./s>ve tried moving the trash can beneath the window. ',
        'Something is in the way. ',
        carHint,
        'Once the car is out of the way you can just MOVE CAN TO WINDOW. '
    ]    
    openWhenRevealed = 'car-block'
    closeWhenAchieved = trashcan.achievement
;

+++ carHint: Hint
    'You<./s>ll have to get that car out of the way. '
    [carGoal]
;

++ carGoal: Goal 'How can I get the car out of the way?'
    [
        'You<./s>re not able to drive a car yourself. ',
        'And even if you could, you can<./s>t get into the car. ',
        'So you<./s>ll need to get someone else to drive it away for you. ',
        'The most likely candidate to drive the car would be its owner. ',
        pepperHint
    ]
    openWhenRevealed = 'car-block'
    closeWhenAchieved = doorbell.achievement
;

+++ pepperHint: Hint
    'It would be useful to get Mrs.\ Pepper out of the way in any case, as
    she<./s>s not likely to welcome you into her house. '
    [pepperGoal]
;

++ pepperGoal: Goal 'How can I get Mrs.\ Pepper to leave the house?'
    [
        'Merely ringing the doorbell isn<./s>t going to work; you<./s>re going
        to have to find some inducement. ',
        'Did you notice what Mrs.\ Pepper was wearing when you rang the bell? ',
        'How thoroughly have you searched the sidewalk area? ',
        'Is there anything special about the telephone pole? ',
        'Have you examined it? ',
        'Have you noticed the advertising flyer there? ',
        'Does the flyer suggest anything that might tempt Mrs.\ Pepper to go
        out? ',
        'If you ring the doorbell and try to show her the flyer, she won<./s>t
            pay any attention to you. ',
        'The trick is to make her find the flyer without her thinking you want her to.
        ',
        'How long does it take Mrs.\ Pepper to answer the doorbell? ',
        'Try dropping the flyer in the front porch and then ringing the bell. ',
        'Retreat into the front yard immediately after ringing the bell. '        
    ]
    openWhenRevealed = 'door-slam'
    closeWhenAchieved = doorbell.achievement
;

++ Goal 'Where can I find {the neighbour/she}<./s>s brooch?'
    [
        'What did {the neighbour/she} tell you about where Mrs.\ Pepper took the
        brooch? ',
        'She took it into the house. ',
        'Knowing Mrs.\ Pepper, she just took it to be contrary, not because she
        actually wanted it for herself. ',
        'What might Mrs.\ Pepper do with something she didn<./s>t actually have
        much use for? ',
        'Where do people store their junk? ',
        'One likely place would be the cellar. ',
        'How thoroughly have you searched the cellar? ',
        'Did you examine the shelf? ',
        'What about that jar on the shelf? '
    ]
    openWhenRevealed = 'brooch'
    closeWhenTrue = !brooch.isInInitState
;

/* INSIDE THE HOUSE  */
/*
 *   (1) getting back out of the house
     (2) lighting the cellar initially
     (3) fixing the flashlight
     (4) opening the door to the front bedroom
     (5) deciphering the wig tags
 */

+ HintMenu 'Inside the House';

++ Goal 'How do I get out of the house again?'
    [
        'When you climb through the kitchen window from the outside, you
        knock the lid off of the trash can, so you<./s>ll
        have to find another way out. ',
        'The only ways out are the back door and the front door. ',
        'But they<./s>re both locked with annoying keyed deadbolt locks that
            can<./s>t be opened from the inside simply by flipping a lever. ',
        'So unless there<./s>s a spare set of keys in the house you could be
            stuck. ',
        'Quite likely Mr. Pepper had a set of keys. ',
        'Where did Mr. Pepper habitually sit? ',
        'How carefully have you looked around the sitting-room? ',
        'Did you look on the mantel? ',
        'What does the photograph show? ',
        'Where might Mrs.\ Pepper have put the wheelchair if it<./s>s no longer
        needed? ',
        'Have you tried looking in the cellar? ',
        'How closely have you looked at the wheelchair? ',
        'Have you tried pulling the brake lever? ',
        'What seems to be jamming it? '
    ]
    openWhenRevealed = 'too-high'
    closeWhenTrue = keyBunch.discovered
;

++ Goal 'How do I light the cellar?'
    [
        'What would you normally use to bring light to a dark place? ',
        'How thoroughly have you searched the kitchen? ',
        'Have you looked at the table? ',
        'Have you looked in the drawer? ',
        'There<./s>s a small flashlight in the kitchen table drawer. '        
    ]
    openWhenRevealed = 'cellar-dark'
    closeWhenSeen = penLight
;


++ Goal 'How do I get the flashlight to work? '
    [
        'What is the obvious reason it might not be working? ',
        'Have you tried opening it? ',
        'There<./s>s nothing inside; it would probably work better with a
        battery. ',
        'Where else might you find a battery in the house? ',
        'What other piece of equipment might use a small battery? ',
        'How closely have you looked around the sitting-room? ',
        'What<./s>s the main piece of electronic equipment there? ',
        'How is it controlled? ',
        'Have you tried opening the remote control? ',
        'Take the battery from the remote control and put it in the flashlight.
        '
    ]
    openWhenRevealed = 'torch-dead'
    closeWhenAchieved = penLight.achievement
;

++ Goal 'What should I be doing about that voice I heard?'
    [
        'You need to search the house further. ',
        'Where did you hear the voice coming from? ',
        'It was coming from the front bedroom. ',
        'So that<./s>s where you need to investigate. ',
        lockHint
    ]
    openWhenAchieved = kitchenWindow.achievement
    closeWhenSeen = elf
;

+++ lockHint: Hint 
    'But first you<./s>ll have to find a way to open the bedroom door. '
    [lockGoal]
;

++ lockGoal: Goal 'How do I open the door to the front bedroom? '
    [
        'There seems to be something a little odd about what<./s>s preventing
        it from opening. ',
        'How closely have you searched the rest of the house? ',
        'In particular, the sitting-room and the back bedroom? ',
        'What did you find on the table in the sitting-room? ',
        'What might a book called <i>Spell-Casting for Dummies</i> be good for?
        ',
        'Make sure you hang on to the piece of paper that fell out of it. ',
        'Have you tried consulting the book about magic locks? ',
        'The book says you need to be properly clad --- is there anything
        distinctive or unusual Mrs.\ Pepper goes in for wearing? ',
        'Could there be a clue in the piece of paper that fell out of the spell
        book? ',
        'Where is Mrs.\ Pepper likely to keep the things she wears? ',
        'How thoroughly have you explored the back bedroom? ',
        'Have you looked at the dressing table? ',
        'You should find some wigs on it. Mrs.\ Pepper likes wigs. ',
        'But how do you know which wig you need? Have you examined them all? ',
        'Each wig has a tag, but each tag appears to be gibberish. ',
        'Could the writing on the tags be in some kind of code? ',
        'Have you found anything that could be a key to the code? ',
        'Take another look at the piece of paper that fell out of the spell
        book. ',
        'It<./s>s effectively the crib to a simple substitution cipher. ',
        'You should be able to use it to decipher each of the tags in turn. ',
        'This should tell you that it<./s>s the black wig you need to magically
        unlock a magically locked door. ',
        'Wear the black wig. ',
        'What else did the spell book say --- something about playing a tune? ',
        'You need a musical instrument of some kind. ', 
        'Mrs.\ Pepper probably keeps it close to hand --- not far from the wigs.
        ',
        'Have you tried looking in the dressing-table drawer? ',
        'The musical score is of no use to you --- but you can look under it. ',
        'Stand in the upstairs landing wearing the black wig and play the
        ocarina. ',
        'If the door won<./s>t open when you try it, you<./s>ve played the
        ocarina an even number of times. It alternately locks and unlocks the
        door, so you need to play it an odd number of times. '
    ]
    openWhenRevealed = 'magic-lock'
    closeWhenSeen = frontBedroom
;

++ wigTagGoal: Goal 'What do the tags on the wigs mean?'
    [
        'The tags seem to be written in some form of code. ',
        'In looking around the house, have you spotted anything else that had
            similar writing? ',
        'In the sitting-room, perhaps? ',
        'Have you tried reading the book on the coffee table? ',
        'A piece of paper will fall out of the book when you first pick it up.
            Try reading the paper. ',
        'The paper contains a phrase in English, and a phrase that appears to
        be gibberish --- much like the gibberish on the tags. ',
        'Count the letters in the words of the two phrases. They<./s>re the same
            length. ',
        'The nonsense phrase on the piece of paper is an encrypted version of
            the English phrase. ',
        'A substitution cipher was used. In a substitution cipher, each letter
            of the alphabet is systematically replaced with some other letter. ',
        'The first English word, for instance, is THE. Its equivalent in the
        other phrase is JAH. So the letter T has been replaced by a J, the
        letter H by an A, and so forth. If you make a list of the letters in
        the alphabet and write down the substitutions, you<./s>ll find that
        most of the letters you need to decipher the tags on the wigs are
        there. (One or two are missing, but they shouldn<./s>t be hard for you
        to work out.) ',
        'ZGOQTGK KDTBQSO translates as MAGICAL LOCKING. XPZZDS FGQS translates
        as SUMMON RAIN. TGPXH XKHHW is CAUSE SLEEP. And ZGBH YAHHKHU EHAQTKHX
        XYHFEH (a mouthful) is MAKE WHEELED VEHICLES SWERVE. ',
        'Not all of the wigs will be useful to you. But some of them may be. '
    ]
    openWhenRevealed = 'wig-tags'
    closeWhenTrue = chippedGlass.rainHasBeenSummoned
;

/* MISCELLANEOUS NON-HINTS ABOUT SCENERY */

+ HintMenu 'Miscellany';

++ Goal 'What is the musical score good for?'
    [
        'What does the title refer to? ',
        'It means <i>The Magic Ocarina</i>; an ocarina is a musical instrument.
        ',
        'The instrument would be more use to you than the score. ',
        'The score is not important for itself, but for what it conceals. ',
        'Look under the score, or pick it up. '
    ]
    openWhenSeen = musicScore
    closeWhenSeen = ocarina
;

++ Goal 'What is the black plastic brush good for?'
    [
        'What does it look like Mrs. Pepper uses it for? ',
        'What<./s>s on the back of it? ',
        'Have you seen something like that mentioned anywhere else? ',
        'Have you looked up the sleeping spell in the spell book? ',
        'Unfortunately, there<./s>s no way you can understand the incantation,
        so you won<./s>t be putting anyone to sleep. ',
        'But take a close look at the emblem on the back of the brush. ',
        'What<./s>s another name for a scarlet fish? ',
        'It<./s>s a red herring. '
    ]
    openWhenSeen = brush
    closeWhenTrue = goalDisplayed
;

++ Goal 'What is the TV used for?'
    [
        'What is a TV usually used for? ',
        'You can watch it. ',
        'It<./s>s strictly there for the entertainment value. It plays
            no part in the story. '
    ]
    openWhenSeen = sittingRoom
    closeWhenTrue = goalDisplayed
;

++ Goal 'What can I do with the stuff in the refrigerator?'
    [
        'Is there anything you really <i>want</i> to do with it? ',
        'The rotting food is simply scenery. It plays no part in
            the game. Nor does the refrigerator itself. '
    ]
    openWhenSeen = kitchen
    closeWhenTrue = goalDisplayed
;

++ Goal 'What is the stove used for?'
    [
        'The stove is simply a decoration. It does nothing. '
    ]
    openWhenSeen = kitchen
    closeWhenTrue = goalDisplayed
;   

++ Goal 'What is the fireplace used for?'
    [
        'The fireplace is simply a decoration. It does nothing. '
    ]
    openWhenSeen = sittingRoom
    closeWhenTrue = goalDisplayed
;

++ Goal 'Is there anything hidden in the holes in the back yard?'
    [
        'No. The holes are simply scenery. '
    ]
    openWhenSeen = backYard
    closeWhenTrue = goalDisplayed
;

++ Goal 'Is there anything hidden among the clutter in the garage?'
    [
        'No. The clutter in the garage is simply scenery. '
    ]
    openWhenSeen = garage
    closeWhenTrue = goalDisplayed
;

++ Goal 'Can I climb the fence?'
    [
        'No. The fence is simply the boundary around the area in which
            the story takes place. '
    ]
    openWhenSeen = onTheSidewalk
    closeWhenTrue = goalDisplayed
;

/* IN THE CELLAR */
//(1) getting the keys
//(2) reaching the jar
//(3) moving the wheelchair
//(4) fixing the machine

+ HintMenu 'In the Cellar';

++ Goal 'How do I get the keys from behing the brake lever? '
    [
        'You won<./s>t get them out by hand. ',
        'You<./s>ll need some kind of implement to move the keys with. ',
        'Something reasonably flat and sturdy. ',
        'The blade of a knife might do it. ',
        'Where might you find a knife? ',
        'How carefully have you searched the kitchen? ',
        'Have you looked in the cabinet? ',
        'MOVE KEYS WITH KNIFE should do the trick. '
    ]
    openWhenTrue = (keyBunch.discovered)
    closeWhenTrue = keyBunch.moved
;

++ jarGoal: Goal 'How can I reach the jar on the shelf in the cellar? '
    [
        'The shelf is too high up for you to reach from the ground. ',
        'So either you need to be taller, or your arms need to be longer. ',
        'There are two solutions to this one. ',
        'How did you gain access to the kitchen window? ',
        'The same method should work again. ',
        'You need to find something to stand on. ',
        'You also need to move it under the shelf. ',
        'Is there anything in the cellar that could do the job? ',
        wheelchairHint,
        'The chair needs to be stable before you stand on it. ',
        'After you<./s>ve moved the wheelchair to the shelf you need to put the
        brake on again. ',
        'Push the lever before standing on the wheelchair. '
    ]
    openWhenSeen = glassJar
    closeWhenTrue = glassJar.moved
;

+++ wheelchairHint: Hint 'You might be able to stand on the wheelchair. '
    [wheelchairGoal]
;

++ wheelchairGoal: Goal 'How can I get the wheelchair to move?'
    [
        'It<./s>s too heavy and awkward for you to maneuver it up the cellar
            stairs. ',
        'You can move it around in the cellar. ',
        'But something is stopping it moving. ',
        'The wheelchair has a brake. ',
        'To allow the wheelchair to move, you must pull the brake lever. ',
        'But something is jamming the lever. ',
        'Have you examined the lever closely? ',
        'Try looking behind it. ',
        'Once you<./s>ve got the keys out from behind the lever, you can
        release the brake and push the chair around the cellar. ',
        'For example, you might want to push it beneath the shelf. '
    ]
    openWhenRevealed = 'chair-brake'
    closeWhenRevealed = 'chair-moved'
;

++ machineryGoal: Goal 'What is the machinery in the cellar good for?'
    [
        'It<./s>s large, so it<./s>s probably powerful. ',
        'Did you notice the cable extending up through the ceiling? ',
        'Quite possibly the machine is attached to a large object that<./s>s
        upstairs in the house. ',
        'If the cable were attached to something, the machine could move it. ',
        'Have you noticed the photo on the mantelpiece? ',
        'The photo shows Mrs.\ Pepper with a man in a wheelchair. ',
        'Possibly the man is (or was) her husband. ',
        'He would have been unable to get up and down the stairs in the
        wheelchair. ',
        'How might the house have been modified to allow him to get to his
        bedroom? ',
        'Have you noticed the little room in the lower hall? The one with a
        button in it? ',
        'The little room is an elevator. '
    ]
    openWhenSeen = cellar
    closeWhenAchieved = elevator.achievement
;

++ fixMachineryGoal: Goal 'How can I fix the machine in the cellar?'
    [
        'Have you examined it closely? There are several objects nearby. ',
        'Why would a wire be dangling free? ',
        'Possibly the machinery is electrical in nature. ',
        'Usually a wire supplying power would have to be attached to the
        machine. ',
        'Did you notice the screw on the top of the machine? ',
        'You might be able to attach the wire to the screw somehow. ',
        'But if you touch the wire you<./s>ll get a shock. It<./s>s an
        electrical wire, all right. ',
        'Might there be a way to turn off the power, so as to be able to handle
        the wire safely? ',
        'Did you notice the metal door on the wall beside the machine? ',
        'If you open the door, you<./s>ll see a switch. ',
        'The switch is a circuit-breaker. ',
        'Turn off the switch. Now you can touch the wire safely. ',
        'To finish the task, you<./s>ll also need a screwdriver. ',
        'A good place to find a screwdriver would be on a workbench. ',
        'If you haven<./s>t yet been in the garage, you should return to this
        topic later. ',
        'In the garage is a toolbox, which you can open. ',
        'If you<./s>re holding the screwdriver, you can attach the wire to the
        screw. ',
        'But to do it, you<./s>ll need both hands. ',
        'If you<./s>re using the flashlight to illuminate the cellar, you
        can<./s>t fix the machine. ',
        'Look around the cellar for another way to provide light. ',
        'Did you notice the chain dangling from the ceiling? ',
        'Pull the chain. The lightbulb will come on. Now you can drop the
            flashlight. It<./s>s no longer needed. ',
        'Once you<./s>re holding only the screwdriver, you can attach the wire
            to the screw: ATTACH WIRE TO SCREW will do it. ',
        'One more step is required to get the machine to work. ',
        'Did you remember to switch the circuit-breaker back on? '
    ]
    openWhenSeen = cellar
    closeWhenTrue = machinery.isFixed
;

/* HELPING THE ELF */
//(1) getting water
//(2) getting the bamboo
//(3) what to do with the elf
//(4) getting the elf outdoors

+ HintMenu 'Helping the Elf';

++ Goal 'The little person in the pot is asking for water. Is that important?'
    [
        'Indeed it is. Without your help, he<./s>ll wither up and die before
            very long. '
    ]
    openWhenRevealed = 'need-water'
    closeWhenAchieved = elf.waterAchievement
;

++ waterGoal: Goal 'Where can I find water for {the elf/him}? '
    [
        'Where might you normally find water in a house? ',
        'You<./s>ll also need something to carry it in, of course. ',
        'You could try the kitchen for both. ',
        'Look in the kitchen cabinet. ',
        'You can fill the glass from the faucet. ',
        'And then try offering it to {the elf/him}, or simply pour it into
            the pot. ',
        'But it seems {the elf/he} doesn<./s>t much care for water from the
            faucet. ',
        'You<./s>ll need to find a source of fresh water for him. ',
        'Did you examine all the wigs in the back bedroom? ',
        'They have tags. The tags are in a cipher, making them difficult to read. ',
        'If you haven<./s>t figured out how to read the tags, work on that
        puzzle and return here after you<./s>ve worked it out. ',
        'One of the wigs has a tag that, when translated, says SUMMON RAIN. ',
        'You<./s>ll need to consult the spell book to learn how to use it. ',
        'One thing you need is a some water to pour onto the ground --- and you
        already know how to get that. ',
        bambooHint,
        'You also need the rain to fall somewhere where it can be easily
        collected. ',
        'Did you notice anything in the back yard where rain might collect? ',
        'The birdbath might make a good receptacle. ',
        'Go to the back yard wearing the blond wig and carrying a stick of
        bamboo, then pour a glass of water onto the ground. ',
        'Then you can fill the glass from the birdbath... ',
        '...and pour the fresh rainwater on {the elf/him}. '
    ]
    openWhenRevealed = 'need-water'
    closeWhenAchieved = elf.waterAchievement
;

+++ bambooHint: Hint
    'The other thing you need is a stick of bamboo. '
    [bambooGoal]
;

++ bambooGoal: Goal 'Where can I find a stick of bamboo? '
    [
        'Where might bamboo grow? ',
        'There<./s>s none growing in Mrs.\ Pepper<./s>s back yard. ',
        'But there is some not far from there. ',
        'What can you see from the back yard? ',
        'Have you tried looking at the neighbor<./s>s garden? ',
        'You can hardly go in there to steal bamboo while {the neighbour/she} is
        working there. ',
        'But you could try talking to {the neighbour/her} --- she may be
        willing to give you a stick of bamboo. ',
        'Have you asked {the neighbour/her} about the bamboo? ',
        '{The neighbour/her} may be more willing to give you some bamboo if
        you<./s>re able to do her a favor first. ',
        'Have you asked her about Mrs.\ Pepper? ',
        '{The neighbour/she} would probably be quite grateful if you could find
        her brooch and give it back to her. '
    ]
    openWhenRevealed = 'need-bamboo'
    closeWhenAchieved = bambooStick.achievement  
;

++ Goal 'What am I supposed to be doing with {the elf/he} in the front bedroom?'
    [
        'Evidently he<./s>s trapped in the pot. ',
        'Could it have been his voice that you heard from the front yard? ',
        'Have you tried talking to him? ',
        waterHint,
        'But he can<./s>t say much else to begin with: He<./s>s too thirsty. ',
        'You<./s>ll first need to find a way to bring him water. ',
        'Once you<./s>ve supplied him with water, he<./s>ll be much more
        talkative. ',
        transportationHint
    ]
    openWhenSeen = frontBedroom
    closeWhenTrue = (elf.isWatered)
;
+++ transportationHint: Hint
    'He<./s>ll explain that he needs to be taken outside. '
    [transportGoal]
;

+++waterHint: Hint
    'If you talk to him, he<./s>ll tell you that he needs water. '
    [waterGoal]
;

++ transportGoal: Goal 'How can I get the elf back outside?'
    [
        'Have you tried picking up the pot and carrying it? ',
        'You can pick it up, all right, but it<./s>s too heavy to carry any
        distance. ',
        'Evidently you need some form of transportation. Possibly something
        with wheels. ',
        'Have you looked in the cellar? ',
        'The first thing you might think of would be the wheelchair --- but
        it<./s>s too cumbersome for you to get it up the stairs. ',
        'Possibly a smaller wheeled vehicle would work. ',
        'What about your skateboard? ',
        'If you haven<./s>t yet found your skateboard, you need to work on that
        puzzle first. It<./s>s hidden, so you<./s>ll need to look carefully at
        various locations. ',
        'After picking up the pot, you can set it on the skateboard. ',
        'A standard way of moving large things from place to place in
        Interactive Fiction is to push them. ',
        'Try PUSH POT NORTH. ',
        'As you<./s>ll soon discover, the skateboard with the pot on it
        can<./s>t be pushed down the stairs. ',
        'How might you get from the upper floor to the lower floor without
        using the stairs? ',
        'If you haven<./s>t yet solved the mystery of the machinery in the
        cellar, you should work on that puzzle first. ',
        'The small room off the hall is an elevator. But it will only work when
        the machine has been repaired. ',
        'If the elevator is on the lower floor, enter it and push the button.
        When you exit, you<./s>ll be on the upper floor. Push the pot west into
        the elevator, then push the button again (taking the elevator to the
        lower floor), then push the pot east into the lower hall. ',
        'If you haven<./s>t unlocked the back door with the keys, this would be
        a good time to do so. ',
        'You can<./s>t push the pot out to the front yard, but you can push it
        out to the back yard, because there<./s>s a wheelchair ramp on the back
        porch. ',
        'If you haven<./s>t yet supplied the elf with fresh water, you<./s>ll
        need to do so now in order to finish rescuing him. '
    ]
    openWhenRevealed = 'transportation-need'
;

//==============================================================================
/*
 *   FRAMEWORK FOR THE EXTRA HINTS MECHANISM
 *
 *   The ExtraHint class provides a framework for providing players 
 *   (especially novice players) with extra hints, nudges, and tips during 
 *   the course of play. When it is activated (either at player request, or 
 *   because the player appears to be having trouble), a hint or tip can be 
 *   displayed at the end of the turn in response to what the player has 
 *   just typed, or some condition that has just become true, or which 
 *   became true a certain number of turns ago.
 *
 *   It is also possible to define conditions (typically the achievement of 
 *   some goal) that render a particular ExtraHint otiose, so that it is not 
 *   displayed if it is no longer needed.
 */

modify Achievement
    achieved = (scoreCount > 0)
;

/* Command for enabling or disabling extra hints */

VerbRule(ExtraHints)
    ('extra' | 'extras'| 'bonus') ('hint' | 'hints' |'tips' |'tip'| ) 
    ('on'->onOff | 'off'->onOff | )
    :ExtraHintsAction
    verbPhrase = ('turn/turning extra hints ' + onOff)
;

DefineSystemAction(ExtraHints)
    execSystemAction()
    {
        if(onOff == nil)
        {
            local cmd = 'EXTRA ' + onOrOff(!extraHintsActive).toUpper();
            "Extra hints are currently <<onOrOff(extraHintsActive)>>. To turn
            them <<onOrOff(!extraHintsActive)>> use the command <<aHref(cmd,
                cmd, 'Turn extra hints ' + onOrOff(!extraHintsActive))>>. ";
            return;
                    
        }
        onOff = onOff.toLower();
        if(onOff == 'off')
            extraHintManager.stopDaemon();
        else
            extraHintManager.startDaemon();
        
        "Okay; extra hints are now <<onOff>>. ";
    }
    extraHintsActive = (extraHintManager.activated)
    onOrOff(stat) { return stat ? 'on' : 'off'; }
;

/* 
 *   The ExtraHint class. We simply need to define objects of this class to 
 *   encapsulate the extra hints we want displayed.
 */


class ExtraHint: object
    location = extraHintManager
    closeWhen()
    {
        if(hintDone || (achieveObj && achieveObj.achievement.achieved))
            return true;
        
        return checkClose;
    }
    /* The object whose achievement we monitor */
    achieveObj = nil
    
    /* The condition that needs to be true for us to offer this hint */
    openWhen = nil
        
    /*  
     *   The number of turns between openWhen becoming true and this hint 
     *   being displayed.
     */
    hintDelay = 0
    
    /*  Alternative condition for closing this ExtraHint */
    checkClose = nil
    
    
    /*  
     *   If the closeWhen condition is true we remove this ExtraHint from the
     *   list of potentially active ExtraHints and return nil to tell the 
     *   caller that this ExtraHint was not displayed. Otherwise we check if 
     *   this ExtraHint (a) meets its openWhen conditions to be displayed 
     *   and (b) is due to be displayed because hintDelay turns have passed 
     *   since it was open. If both conditions are met we show our text and 
     *   return true to tell our caller that an ExtraHint has been displayed 
     *   (important since we display at most one ExtraHint per turn). 
     *   Otherwise we return nil.
     */
    
    doHint()
    {
        if(closeWhen)
        {
            extraHintManager.removeFromContents(self);
            return nil;
        }
        
        if(openWhen)
        {
            if(openedWhen == nil)
                openedWhen = libGlobal.totalTurns;
            
            if(libGlobal.totalTurns < (openedWhen + hintDelay))
               return nil;
               
            showHint();
            return true;
        }           
        return nil;
    }
    
    /* The text to display in relation to this ExtraHint */
    hintText = ""
    
    showHint()
    {
        "<.p>";hintText();"<.p>";
        hintDone = true;
    }
    
    hintDone = nil
    
    openedWhen = nil
;

/* 
 *   A Template to facilitate the definition of ExtraHints. We can define it 
 *   here and not in a header file since ExtraHints are only defined in this 
 *   source file. */

ExtraHint template ->achieveObj? +hintDelay? "hintText";


/*  
 *   The extraHintManager carries out the work of starting and stopping the 
 *   display of ExtraHints, and determing which, if any, ExtraHint is ready 
 *   to be displayed.
 */

extraHintManager: PreinitObject
    startDaemon()  {  daemonID = new Daemon(self, &hintDaemon, 1);  }
    
    stopDaemon()
    {
        if(daemonID)
        {
            daemonID.removeEvent();
            daemonID = nil;
        }
    }
    
    daemonID = nil
    activated = (daemonID != nil)
    
    /* 
     *   When we're active we run through every ExtraHint object in our 
     *   contents and run its doHint() method till either we run out of 
     *   ExtraHint objects or we find one that displays an extra hint, and 
     *   so returns true.
     */
    hintDaemon()
    {
        foreach(local obj in contents)
        {
            if(obj.doHint())
                break;
        }
    }
    
    contents = []
    
    addToContents(obj)   {  contents += obj; }
    
    removeFromContents(obj) {  contents -= obj; }
    
    /* Build a list of all ExtraHints in our contents property at PreInit */
    execute() { forEachInstance(ExtraHint, {x: addToContents(x) });  }
    
    explainExtraHints()
    {
        "If you\'re new to Interactive Fiction and would like to read a few
        extra hints and tips that will pop up here and there as you explore the
        story, type <<cmdStr('ON')>>. If you decide you don\'t want any more of
        these bonus tips, simply type <<cmdStr('OFF')>>.";
    }
    cmdStr(stat)
    {
        "<<aHref('EXTRA ' + stat, 'EXTRA ' + stat, 'Turning extra hints ' +
                stat.toLower)>>";
    }
;

/*
 *   A series of ExtraHints can now follow.
 *
 *   The first element in the template is the object whose achievement 
 *   property we check to see if this ExtraHint has become redundant. For 
 *   example, if the player has already taken the flyer, flyer.achievement 
 *   has been achieved, and so we don't need this first ExtraHint.
 *
 *   The second element in the template (e.g. +1) is the hintDelay; this is 
 *   number of turns that should elapse between the openWhen condition (see 
 *   below) becoming true and the hint being offered. This optionally allows 
 *   the player a few turns to work on the solution before being offered a 
 *   gratuitous hint.
 *
 *   The third element in the template is simply the text of the extra hint 
 *   to display.
 *
 *   The openWhen property holds the condition that must be true before this 
 *   ExtraHint is displayed. In the case of the first ExtraHint, the 
 *   condition is that the player char has visited the location that 
 *   contains the telephone pole. 
 */

+ ExtraHint
    "<b>Bonus Tip:</b> The locations you can travel through in an Interactive
    Fiction story are usually surrounded by walls, fences, rivers, or other
    barriers to travel. These are often described in realistic ways, but they
    aren't important: They exist strictly in order to make the world of the
    story seem more natural. Some of the barriers may look like places you
    could visit, but when you try to go in that direction, you'll see a message
    explaining why such an action isn't practical.\b
    On the other hand, you\'ll also encounter barriers to travel (such as
    locked doors) that you\'re meant to overcome. "
    openWhen = (gRevealed('off-map'))
;

+ ExtraHint ->flyer
    "<b>Bonus Tip:</b> When you enter a new location, it's always a good idea
    to look around carefully, and examine anything that's mentioned in the
    description of your location. Sometimes important objects are disguised as
    part of the scenery --- but once you notice them, you'll be able to pick
    them up and use them. "
    openWhen = (sidewalkByFrontYard.visited)
;

+ ExtraHint ->trashcan
    "<b>Bonus Tip:</b> Sometimes you're prevented from touching or using an
    object because it's <.q>out of reach<./q> (too high up or at the bottom
    of a well, for instance). If the object is too high up, you may be able
    to reach it by standing on something. If it's too deep in a recess, you
    may be able to find a way to extend your reach. "
    openWhen = ((gRevealed('window-reach') && mrsPepper.isGone 
                 && (me.location == driveByHouse)) || gRevealed('skateboard-reach'))
;
    
+ ExtraHint ->porchFromBackYard +1
    "You find yourself wondering vaguely ... where did that toad disappear to? "
    openWhen = (backYard.toadcounter <= 0)
;

+ ExtraHint ->doorbell +3
    "You find yourself wondering whether Mrs. Pepper might be enticed out of her
    house somehow. Perhaps if she had a reason to go somewhere.... "
    openWhen = (gRevealed('door-slam'))
;


+ ExtraHint
    "<b>Bonus Tip:</b> When a room is dark, you'll need to find and bring
    a portable light source in order to explore what's in it. "
    openWhen = (gRevealed('cellar-dark'))
;

+ ExtraHint ->elevator
    "<b>Bonus Tip:</b> Usually a button is attached to a mechanism of some kind.
    If the button doesn't seem to be working, possibly it's doing something in
    another location that you can't see, or perhaps the mechanism needs to be
    repaired. "
    openWhen = (gActionWas(Push) && gLastDobj.ofKind(LiftButton))
;

+ ExtraHint
    "<b>Bonus Tip:</b> Doors in interactive fiction are quite often locked. You
    may need to find a key, or find a different route that will take you to the
    other side of the door. "
    openWhen = (gRevealed('door-tried'))
;

+ ExtraHint
    "<b>Bonus Tip:</b> In interactive fiction, books and other reading material
    often supply important information. You may find that for various topics,
    you can LOOK UP TOPIC IN BOOK. "
    openWhen = (gRevealed('book-read'))
;

+ ExtraHint ->wire
    "<b>Bonus Tip:</b> Fixing a broken machine may mean performing several
    different actions. As a general rule, the handy command FIX MACHINE
    won't work. "
    openWhen = (gRevealed('machine-repair'))
;

+ ExtraHint
    "<b>Bonus Tip:</b> Carrying objects from place to place and using them
    to solve various puzzles is a staple of Interactive Fiction. What you're
    carrying at any given time is your <.q>inventory.<./q> Some stories place
    a limit on the number of objects you can have in your inventory, but other
    stories let you carry as much as you want to. Certain actions, such as
    rowing a boat, might take both hands, forcing you to set down what you're
    carrying. This is done using the DROP command. By convention, something
    that is dropped falls to the floor or ground of the location where it's
    dropped. When you return to that location later, the object should still
    be there. "
    openWhen = gActionWas(Take) 
;
                
+ ExtraHint
    "<b>Bonus Tip:</b> Garments in Interactive Fiction can often be worn by
    using the WEAR or DON command. When you no longer want to wear something,
    you can REMOVE it. "
    openWhen = (gRevealed('wearing-things'))  
    checkClose = (gRevealed('worn-wig'))
;

+ ExtraHint
    "<b>Bonus Tip:</b> {The neighbour/she} is what is called a <.q>Non-Player
    Character<./q> or NPC, meaning she's a character in the story but you don't
    control her actions. Some NPCs are friendly, others may be less so, but
    it's often worth engaging them in conversation to see what they can tell
    you. Try using TALK TO <<neighbour.name.toUpper()>>. You may also find the
    commands ASK <<neighbour.name.toUpper()>> ABOUT... and TELL
    <<neighbour.name.toUpper()>> ABOUT... useful. Follow this command with a
    topic (for instance, ASK HER ABOUT THE BIRDBATH). If the NPC doesn\'t have
    anything to say on a given subject, the response will be noncommital or
    irrelevant. "
    openWhen = (me.hasSeen(neighbour))
;

+ ExtraHint
    "<b>Bonus Tip:</b> ASK <<gLastDobj.toUpper>> ABOUT
    <<gLastTopicText.toUpper>> is one way of phrasing a conversational command.
    Once a conversation is under way you can shorten this to ASK ABOUT
    <<gLastTopicText.toUpper>> or just A <<gLastTopicText.toUpper>>. Similarly
    you could abbreviate TELL <<gLastDobj.toUpper>> ABOUT
    <<gLastTopicText.toUpper>> to just T <<gLastTopicText.toUpper>>.\b
    You can use the TOPICS command to get a list of things it may be worth
    asking or telling about, but there could well be other things besides. "
    
    openWhen = (gActionWas(AskAbout) || gActionWas(TellAbout))
        && (gLastDobj != nil)
;

+ ExtraHint 
    "<b>Bonus Tip:</b> To move around the map use compass directions:
    NORTH, SOUTH, EAST, WEST, NORTHEAST etc. (which can be abbreviated to N,
    S, E, W, NE etc.), or UP, DOWN, IN or OUT. Try going <<aHref('WEST', 'WEST',
        'Go West')>> now. "
    openWhen = libGlobal.totalTurns > 8
    checkClose = (endOfDriveway.visited)
;

+ wigHint1: ExtraHint ->doorbell
    "A stray image enters your mind: Mrs. Pepper wearing one of her more
    outlandish wigs. Come to think of it, she does seem quite fond of wigs. "
    openWhen = libGlobal.totalTurns > 40
;

+ windowHint1: ExtraHint ->kitchenWindow +35
    "It occurs to you that the window round the side of the house looks
    temptingly open, if only you could reach it. "
    openWhen = doorbell.achievement.achieved
    checkClose = kitchen.visited
;

+ windowHint2: ExtraHint ->kitchenWindow +10
    "It occurs to you that you'd be able to reach the window round the side of
    the house to climb through it if only you could find something to stand on.
    You'd just need to move it under the window. "
    openWhen = windowHint1.hintDone
    checkClose = kitchen.visited
;

+ torchHint1: ExtraHint ->penLight +20
    "It suddenly occurs to that you've seen something that probably contains a
    battery you could use in the penlight. "
    openWhen = gRevealed('torch-dead') && me.hasSeen(remote)
    checkClose = battery.seen
;

+ ExtraHint ->penLight +10
    "You feel a sudden urge to take a look at the remote control for the TV. "
    openWhen = torchHint1.hintDone
    checkClose = battery.moved
;

+ magicHint1: ExtraHint ->frontBedroom
    "That was really strange. Whatever's blocking that door felt very weird,
    somehow. "
    openWhen = gActionWas(Open) && gLastDobj == landingDoor
    checkClose = landingDoor.isOpen
;

+ magicHint2: ExtraHint ->frontBedroom +30
    "You pause for a moment to think about that bedroom door you couldn't open.
    There was something almost <i>magical</i> about the way it resisted you.
    It occurs to you that perhaps you need to consult a book on magic. "
    openWhen = magicHint1.hintDone
    checkClose = landingDoor.isOpen
;

+ ExtraHint ->frontBedroom +20
    "A sudden thought strikes you: Possibly Mrs. Pepper keeps her magical
    equipment in her bedroom. "    
    openWhen = magicHint2.hintDone && dummiesBook.described
    checkClose = landingDoor.isOpen
;

modify playerHelper
    firstCheckMsg()
    {
        if(!extraHintManager.activated)
        {
            inherited;
            extraHintManager.startDaemon();
            extraHintManager.hintDaemon();
            extraHintMsg;
        }            
    }
    
    extraHintMsg = "[To turn these bonus tips off, use the command
        <<aHref('EXTRA OFF', 'EXTRA OFF', 'Turn off extra hints')>>]<.p>";
;

#ifdef __DEBUG

modify Goal
    openWhen = (inherited || me.showAllHints)
;
 
#endif