#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   The Felicity NPC is represented by more than one object in this game; 
 *   this is the principal one.
 */


felicity : Person 'blonde felicity attractive young woman/hope/felicity' 
    'Felicity' @swamp
    "<<isIn(swamp) ? 'Right now she looks a bit bedraggled, but it\'s still
        Felicity' : 'She really is a very attractive young woman; her long
            blonde hair falls softly round a face that you find incredibly
            appealing -- it\'s not just the bright blue eyes, though their
            sparkle is undoubtedly attractive, and it\'s not just the generous
            mouth, though you like its readiness to smile. There\'s just
            something about the Gestalt of her face that has you totally
            smitten'>>. "
    isProperName = true
    isHer = true
    throwTargetCatch(obj, path)
    {
        if(obj==rope && curState == felicityDrowning)
        {
            "Felicity catches one end of the rope and holds it tightly. ";
            setCurState(felicityRope);
            rope.name = 'one end of a length of rope';
            rope.isQualifiedName = true;
            rope.initializeVocabWith('end/length');
        }
        else if (obj == rope && curState == felicityRope )
            "She already has one end of the rope, and it would be an excellent
            idea if you held on to the other. ";
        else
        {
            "{You/he} throw{s} {the dobj/him} to Felicity, but she's too
            preoccupied to catch {it dobj/him}, so {it dobj/he} fall{s} into
            the swamp and sink{s} out of sight. ";
            gDobj.moveInto(nil);
        }
    }
    iobjFor(ThrowTo)
    {
        verify()
        {
            if(curState not in (felicityDrowning, felicityRope))
                inherited;
        }
    }
    iobjFor(ThrowAt) remapTo(ThrowTo, DirectObject, self)
    
    dobjFor(Kiss)
    {
        preCond = [touchObj]
        verify() 
        { 
            if(isIn(swamp))
                illogicalNow('You can\'t; she\'s too far away.' ); 
            logicalRank(140, 'eminently kissable'); 
        }
        action() { curState.kissResponse; } 
    } 
    touchDesc = "You lightly touch Felicity on the arm, and she reciprocates
        the gesture with a mysterious smile. "
    postureDesc ()
    {
        if(isIn(swamp))
            "She's slowly sinking into the swamp. ";
        else
            inherited;
    }  
    showSpecialDescInContents(pov, cont)
    {
        if(cont == swamp)
            "<<nameIs>> struggling in <<cont.theName>>. ";
        else
            inherited(pov, cont);         
    }
    
    cannotScrewMsg = 'This is neither the time nor the place. '
    uselessToAttackMsg = 'That\'s the last thing you want to do. '
    sightSize = large
    dobjFor(PrayTo) { verify() { logicalRank(120, 'latest version'); } }
;

+ felicityHair: Component 'lovely long (blonde) golden hair' 'Felicity\'s hair'
    "Felicity's golden blonde hair tumbles over her shoulders. "
    feelDesc = "It's really very nice to the touch -- very soft and silky --
        and she makes no objection to your touching it. "
    isQualifiedName = true
    dobjFor(Pull) {
        verify() { nonObvious; }
        check() {
            reportFailure(&needlesslyUnpleasantMsg);
            exit;
        }
    }
    iobjFor(ThrowAt) maybeRemapTo(felicity.isIn(swamp), ThrowTo, DirectObject, felicity)
;

+ felicityDrowning : ActorState
    specialDesc = "Felicity Hope is stuck in the middle of the swamp, with the
        marshy waters already up to her chest as she struggles vainly to get
        free. "
    isInitState = true
    remoteSpecialDesc(pov)
    {    
        if(pov.isIn(stonePodium))
            "Felicity is struggling vainly to free herself from the swamp to
            the south.";
    }
    smileResponse = "<q>Don't just stand there grinning,</q> she cries, <q><i>Get me out
        of here!</i></q>. "
    hugResponse = "Besides that fact that she's too far away, she'd probably
        appreciate some more practical comfort right now. "  
    afterAction()
    {
        if(gActionIs(ThrowInto) && gDobj == rope && gIobj == swamp)
            "<.p><q>Can\'t you get it any closer than that?</q> Felicity
            complains. ";
        if(gActionIs(Yell))
            "<.p><q>What are you <<gVerbName>>ing about?</q> Felicity demands,
            <q>I'm the one in imminent danger of drowning here!</q>";
    }
    beforeTravel(traveler, connector)
    {
        if(connector is in (tunnelJunction, mountainTunnel))
            "<q>Hey, where are you going; you can't just leave me!</q> Felicity
            calls. ";
    }
;

++ AskTopic, ShuffledEventList [felicity, swamp]
    [
        '<q>Are you all right?</q> you ask.\b
        <q>What do you think?</q> she cries back, <q>of course I\'m not all
        right; now for goodness\'s sake get me out of here!</q>',
        
        '<q>How are you doing?</q> you enquire.\b
        <q>Oh, fine, just fine!</q> she retorts, <q>I\'m sinking into this
        swamp and I can\'t get out of it -- things just couldn\'t be
        better!</q>',
        
        '<q>What are you doing in that swamp, Felicity?</q> you inquire.\b
        <q>What does it look like?</q> she replies, <q>Trying to get out of it,
        of course!</q> ',
        
        '<q>Can I do anything to help?</q> you inquire.\b
        <q>Getting me out of here would be a pretty good start!</q> she
        declares. '
    ]
;

++ GiveShowTopic @rope
    "<q>Yes, that should do the trick.</q> she says, <q>try throwing it to
    me!</q>"
;

++ CommandTopic @TakeAction
    "<q>Here, take this rope!</q> you say.\b
    <q>You'll have to throw it to me first!</q> she replies. "
    matchDobj = rope
    isActive = felicity.canSee(rope)
;


++ DefaultGiveShowTopic
    "<q>I can't see that's going to be much use!</q> she complains. "
;

++ DefaultAnyTopic, ShuffledEventList
    [
        '<q>Just get me out of here, <i>please</i>!</q> she begs you. ',
        '<q>Don\'t just stand there nattering, <i>do</i> something!</q> she
        begs. ',
        '<q>There may be a good time to discuss that, but not when I\'m about
        to drown in this wretched swamp!</q> she cries. '
    ]
;

+ ConvAgendaItem, ShuffledEventList
    [
        '<q>Thank goodness you came!</q> Felicity calls, <q>now for goodness\'s
        sake get me out of here!</q>'
    ]
    [
        '<q>Help! Help!</q> Felicity cries. ',
        
        'Felicity lets out a shriek as she sinks a further few inches into the
        mire. ',
        
        '<q>For goodness\'s sake hurry up!</q> Felicity begs. ',
        
        '<q>Get me out of here!</q> the blonde pleads. ',
        
        '<q>You\'re not just going to leave me to drown in this muck!</q>
        Felicity cries. ',
        
        '<q>For goodness\'s sake!</q> Felicity cries, <q>do something!</q>',     
        
        '<q>Eek!</q> the distressed woman cries out, <q>I\'m sinking in this
        muck!</q>',
        
        '<q>My situation is getting more than a little desperate here,</q>
        Felicity points out, <q>If you are planning to do something to rescue
        me, I suggest you get on with it!</q>', 
        
        'Felicity struggles futilely to free herself from the sucking swamp,
        but it only seems to make matters worse. '    
    ]
    initiallyActive = true
    isReady = (inherited && gPlayerChar.canHear(getActor))
    isDone = (getActor.curState != felicityDrowning)
    invokeItem { doScript; }
;

//--- Felicity has caught the rope and is waiting to be pulled out of the swamp ---

+ felicityRope : ActorState
    specialDesc = "Felicity is semi-submerged in the swamp, but she's tightly
        holding the other end of the rope you've just thrown her. "
    stateDesc = "She's also desperately holding
        onto the rope you've just thrown her. "
    beforeTravel(traveler, connector)
    {
        "You can't just walk away now. ";
        exit;
    }  
    smileResponse = "<q>Don't just stand there grinning like an idiot,</q> she
        cries, <q>Pull me out of here, for goodness's sake!</q> "
    hugRespone = "She's out of reach and you have more urgent things to do right now. "
    beforeAction()
    {
        if(gActionIs(ThrowInto) && gDobj == rope)
        {
            "Felicity is holding on to one end of the rope for all she's worth;
            throwing away the other end right now would be madness! ";
            exit;
        }
    }  
    afterAction()
    {
        if(gActionIs(Yell))
            "<.p><q>I'd prefer it if you'd save your breath for pulling that
            rope!</q> Felicity tells you. ";
    }
;

++ AskTellTopic, ShuffledEventList @rope
    [
        '<q>Have you got hold of that rope?</q> you ask.\b
        <q>Don\'t worry, I\'m not letting go of it, that\'s for sure!</q> she
        replies. ',
        
        '<q>Don\'t let go of the rope!</q> you tell her.\b
        <q>I shan\'t!</q> she cries, <q>Now how about pulling me out of
        here?</q>',
        
        '<q>You are still holding that rope?</q> you enquire.\b
        <q>Of course I am!</q> she shouts back, <q>So why don\'t you try giving
        it a pull!</q>',
        
        '<q>Hang on tight!</q> you call, <q>I\'m going to try to pull you out
        of there!</q>\b
        <q>And about time too!</q> she calls back, <q>Don\'t worry; I\'m not
        letting go!</q>'    
        
    ]
;

++ AskTopic, ShuffledEventList @felicity
    [
        '<q>Are you okay?</q> you ask anxiously.\b
        <q>I\'d be a lot better if you got me out of here!</q> she replies. ',
        
        '<q>How are you?</q> you enquire.\b
        <q>Up to my waist in this stinking marsh,</q> she answers, <q>now for
        pity\'s sake tug on that rope and get me out of here!</q> ',
        
        '<q>Will you be all right?</q> you ask.\b
        <q>Only if you hurry up and pull me out of here!</q> she cries. ',
        
        '<q>Are you managing okay?</q> you inquire.\b
        <q>Not particularly!</q> she tells you, <q>I\'d manage a whole lot
        better if you just pulled me out of this stinking swamp!</q>'    
    ]
;

++ GiveShowTopic @rope
    "She's already holding the rope. "
    isConversational = nil
;

++ DefaultGiveTopic
    "Felicity can't reach {it dobj/him}, and right now she wouldn\'t be that
    interested anyway. "
    isConversational = nil
;

++ DefaultShowTopic
    "She has more pressing matters on her mind right now. "
    isConversational = nil
;

++ DefaultAnyTopic, ShuffledEventList
    [
        '<q>Perhaps you could pull me out of here!</q> Felicity suggests. ',
        '<q>We can talk after you\'ve got me out of here!</q> she insists. ',
        '<q>Don\'t talk -- pull!</q> she cries. ',
        '<q>There\'s a time for talk and a time for action -- I\'d say it\'s
        now obviously the latter!</q> she points out. ',
        '<q>It may have escaped your notice, but I\'m still up to my waist in
        this stinking swamp,</q> she observes, <q>how about you do something
        about it instead of just standing there nattering!</q>'
    ]
;

//-------- Felicity has been rescued and is now following the PC around -----------

+ felicityFollowing : AccompanyingState, ShuffledEventList
    specialDesc = "Felicity is standing at your side. "
    stateDesc = "She's looking at you expectantly. "  
    smileResponse = "She smiles warmly back. "
    hugResponse = "You give her a little hug, and she hugs you back. "
    accompanyTravel(traveler, conn) 
    { 
        return (traveler == gPlayerChar);      
    }
    arrivingTurn()
    {
        getActor.executeAgenda();
    }
    getAccompanyingTravelState(leadActor, conn)
        { return new FelicityTravelState(location, leadActor, self); }
    beforeAction()
    {
        if(gActionIs(Eat) && gDobj == apple)
        {
            if(gRevealed('apple-warning'))
                "Felicity pushes your hand away from your mouth, <q>Please
                don't do that!</q> she insists, <q>Get rid of it!</q>. ";
            else
                "You raise the apple to your mouth to take a bite, but before
                you sink your teeth into Felicity knocks it aside.\b
                <q>Don't!</q> she snaps. Then, more apologetically, she adds,
                <q>Sorry, but I have a bad feeling about it. For some reason I
                suspect that eating <i>anything</i> round here will be bad for
                us. I\'d throw it away, if I were you.</q><.reveal
                apple-warning>";
            exit;
        }
    }
    afterAction()
    {
        if(gActionIs(Push) && gDobj == mountainDoor)
        {
            "Seeing you struggle, Felicity lends her weight to yours, but even
            though the slab moves a fraction, even your combined strength isn't
            enough to do more.\b
            <q>It's no use!</q> she declares, giving up to catch her breath,
            <q>we'll have to find another way to shift it!</q><.p>";
        }
        if(gActionIs(Pull) && gActor == gPlayerChar && gDobj == smallLever)
        {
            "<.p><q>That's interesting,</q> Felicity remarks, <q>perhaps I
            could help in some way?</q>";
        }
        if(gActionIs(Open) && gDobj == ossuary2 && !gRevealed('yuk-bones') 
           && oldBones.isIn(ossuary2) )
        {
            "<.p><q>Ugh!</q> cries Felicity, turning up her nose at the bones,
            <q>they don't look too healthy!</q><.reveal yuk-bones><.p>";
        }
        
        if(gActionIs(Yell))
            "<.p><q>There's no need to shout, I'm right here!</q> Felicity
            assures you. ";
    }
    kissResponse { kissList.doScript; }
    kissList: ShuffledEventList {
    [
        'You venture a tentative kiss on the cheek, which she reciprocates with
        no apparent reluctance. ',
        'Emboldened by the first kiss, you try a quick kiss on the lips, which
        earns a similar kiss and a smile in return. ',
        'You kiss her fully on the lips, and she seems to appreciate it. ' 
    ]
    [
        'You exchange warm kisses. ',
        'You kiss Felicity yet again, and she gives you a warm smile of
        happiness. ',
        'You give her another lingering kiss on the lips. ',
        'You kiss yet again, and Felicity gives you a warm hug for good measure. '
    ]
    }
    eventList = [
        'Felicity gives your hand a little squeeze. ',
        'Felicity smiles at you. ',
        'Felicity slips her arm round your waist and nestles her head on your
        shoulder for a moment or two. ',
        'Felicity briefly touches your arm. ',
        'Felicity looks rather pensive for a moment or two. ',
        'Felicity looks into your eyes with a questioning smile. ',
        'Felicity glances round. ',
        'Felicity rests her hands on her hips for a moment. ',
        'Felicity absently runs her hand through her hair, seemingly in an
        attempt to straighten it. '
    ]
    eventPercent = 40
    eventReduceTo = 20
    eventReduceAfter = static eventList.length
;

class FelicityTravelState: AccompanyingInTravelState
    sayDeparting(conn) { 
        "Felicity ";
        switch(conn)
        {
        case tunnelJunction:
            "follows you into the tunnel. "; break;
            
        case cliffStairs: 
            "follows you up the stone steps. "; break;
        case ropeLedgePath:      
        case chasmEdgePath:
            "walks cautiously along behind you. "; break;
        default:
            "follows you. "; 
        }
    }
    
    specialDesc() {
        "Felicity ";
        switch(felicity.getOutermostRoom)
        {
        case tunnelJunction:
            "touches you lightly on the arm to show she is still following
            you. ";
            break;
        case eden:
            "peers round the garden. "; break;
        case swampside:
            "walks well clear of the swamp. "; break;
        case ropeLedge:
            "stops to peer across the chasm. "; break;
        default:
            "is still at your side. ";
        }
    }
;


++ AskTopic, EventList, SuggestedAskTopic @felicity
    [
        '<q>How are you?</q> you ask.\b
        <q>I\'m fine,</q> she assures you, <q>thank you.</q> ',
        
        '<q>So, what were you doing in that swamp?</q> you wonder.\b
        <q>Trying to escape from it, of course</q> she replies. ',
        
        '<q>How did you get in that swamp in the first place?</q> you want to
        know.\b
        <q>I was sucked into by love and deceit,</q> she answers.<.reveal
        love-deceit> ',
        
        '<q>How long were you trapped in that swamp, you poor old thing!</q>
        you ask.\b
        <q>I was there from the time you left until you found me,</q> she tells
        you. ',
        
        '<q>Are you <i>really</i> the same Felicity Hope I met at breakfast
        this morning?</q> you ask, feeling that her presence here has still not
        been properly explained.\b
        <q>Oh yes,</q> she assures you with a little laugh, <q>I\'m definitely
        the same Felicity -- and I\'m just as real as anything round
        here!</q>',
        
        '<q>Are you dead, then?</q> you ask.\b
        <q>Do I look dead?</q> she retorts with a pert little smile, <q>I
        assure you I feel very much alive!</q>'  
        
    ]
    name = 'herself'
;

+++ AltListTopic
    "Right now, there doesn't seem much more to ask; at least you can't think
    of anything more you can ask about her that seems likely satisfy your
    continuing puzzlement. "
;

++ AskTellTopic, ShuffledEventList @tLove
    [
        '<q>Do you think love is important?</q> you ask.\b
        <q>I think it\'s the most important thing in the world,<q> she tells
        you. ',
        
        '<q>Have you ever been in love, Felicity?</q> you wonder.\b
        <q>I\'m not sure,</q> she replies, <q>not before coming here, at any
        rate.</q>',
        
        '<q>Have you ever been loved?</q> you enquire.\b
        <q>Of course -- by my parents, and my brothers, and my friends,</q> she
        replies. ',
        
        '<q>Is there anyone in particular you\'d like to be loved by?</q> you
        wonder.\b
        <q>Oh yes!</q> she declares, <q>but that would be telling!</q>'      
    ]
;

+++ AltTopic, StopEventList, SuggestedAskTopic
    [
        '<q>How did love lure you into that swamp?</q> you ask.\b
        <q>If it were not for love, I should not have come here,</q> she
        replies. ',
        
        '<q>What sort of love -- who loving whom -- made you come here
        then?</q> you enquire.\b
        <q>Surely you know that!</q> she tells you. '         
    ]
    isActive = gRevealed('love-deceit')
    name = 'love'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic
    [
        '<q>How did deceit lure you into the swamp?</q> you wonder.\b
        <q>I was deceived about what I was getting into,</q> she replies.',
        
        '<q>Are you saying that I deceived you?</q> you ask.\b
        <q>No -- not you,</q> she assures you. ',
        
        '<q>Then who or what did deceive you?</q> you want to know.\b
        <q>The hope of learning something from someone with nothing worthwhile
        to say,</q> she replies. '  
    ] 
    isActive = gRevealed('love-deceit')
    name = 'deceit'
;

++ AskTellTopic, EventList, SuggestedAskTopic @worts
    [
        '<q>Well, Wortschlacter\'s paper turned out to be pretty dreadful,</q>
        you opine.\b
        <q>Absolutely terrible,</q> she agrees, <q>but at least we\'ve both
        escaped it now!</q>',
        
        '<q>You know, I have a strange feeling that this whole place is related
        to Professor Wortschlachter and his talk somehow,</q> you remark.\b
        <q>Yes, I\'m sure that\'s right,</q> she agrees, <q>Though I think
        there\'s a bit more to it than that.</q> ',
        
        '<q>Is it Wortschlachter\'s fault you ended up in this place?</q> you
        ask.\b
        <q>In a manner of speaking,</q> she replies slowly, <q>at least, I
        suspect it wouldn\'t exactly be <i>this</i> place but for
        Wortschlachter.</q>'
    ]
    name = 'Professor Wortschlachter'
;

+++ AltListTopic
    "You've run out of things to say about him. In any case you've established
    that Felicity agrees with you that Wortschlachter's paper was pretty
    dreadful, but that she thinks that he's in some way connected with this
    place, at least to the extent that it wouldn't exactly be <i>this</i> place
    but for him. "
;

++ AskTellTopic, StopEventList, SuggestedTellTopic [snake, rope]
    [
        '<q>Did you see what happened to that rope when I dropped it? It
        changed back into a snake!</q> you declare.\b
        <q>I can\'t say I was paying too much attention to it,</q> she
        confesses, <q>I was just so relieved to get back on dry land!</q>',
        
        '<q>That rope was a snake when I first found it,</q> you tell her, <q>I
        mean, the snake was lying under this tree, and when I picked it up, it
        turned into a rope!</q>\b
        <q>A bit like Moses and his rod, you mean?</q> she muses; then she
        shakes her head, <q>This sure is a weird place!</q>',
        
        '<q>But what do you think was going on with that snake?</q> you ask
        her.\b
        <q>I suppose much what\'s going on in general with this place!</q> she
        replies. '
        
    ]
    name = 'the snake'
;


++ AskTellTopic, EventList, SuggestedAskTopic @tMark
    [
        '<q>On my way to that swamp, I kept coming across Mark\'s version of
        the Empty Tomb, in various different guises,</q> you inform her.\b
        <q>That figures,</q> she nods. ',
        
        '<q>I kept having to find ways to get out of various versions of the
        Tomb,</q> you say.\b
        <q>Well, you would,</q> she says, <q>one thing Wortschlachter kind
        of got right is that Mark\'s Empty Tomb account marks a kind of
        frontier between life and death.</q>',
        
        '<q>But why do I have to keep finding a way out of the tomb again
        and again?</q> you wonder, <q>Why do I never finally cross that
        frontier between life and death?</q>\b
        <q>Perhaps because you\'ve yet to choose which way you\'re going,</q>
        she suggests enigmatically. '  
    ]
    name = 'the empty tomb'
;

+++ AltListTopic
;

++ AskTellTopic, EventList, SuggestedAskTopic @tHell
    [
        '<q>Are we in hell, do you think?</q> you ask her.\b
        <q>Well,</q> she replies, <q>it doesn\'t exactly feel like hell to me;
        for one thing, we\'re together, aren\'t we?</q> <.convnode
        we-together>',
        
        '<q>But if this isn\'t hell, what is it I wonder?</q> you ask.\b
        <q>Well, the traditional notion of hell comes from the burning rubbish
        in the Valley of Hinnom -- Gehenna -- does it not?</q> she muses,
        <q>But that\'s just an ancient myth. This is something a bit
        different.</q>',
        
        '<q>When I first arrived here -- wherever here is -- I found a gate
        marked, <q>All Hope Abandon Ye Who Enter Here</q> -- except that the
        final E was missing. Anyway, there was a demon there, as
        traditional-looking as you could get, chipping away at the inscription.
        He seemed to be of the impresion it was the gate of hell.</q>\b
        <q>Ah - but did you go through the gate?</q> she asks.<.convnode
        through-gate>'
        
    ]
    name = 'hell'
;

+++ AltListTopic
    
;

++ AskTopic, EventList, SuggestedAskTopic @gPlayerChar
    [
        '<q>What happened to me, how did I get here? Do you know?</q> you
        ask.\b
        <q>I know as much as you do, I think,</q> she replies, <q>or, to put it
        another way, you know as much as I. You were taken ill in Professor
        Wortschlachter\'s lecture. Then you came here -- not your body, just
        you.</q>',
        
        '<q>Am I dead, then?</q> you wonder.\b
        <q>Well,</q> she answers, <q>that may turn out to be up to you. I mean,
        how can you tell if this is a genuine post-mortem experience or simply
        a near-death experience? I bet you\'ve never experienced either before,
        so you\'ve no point of comparison.</q> ',
        
        '<q>Are you saying I could still be alive, then?</q> you ask.\b
        <q>You\'re obviously alive in some sense,</q> she points out,
        <q>otherwise you couldn\'t be talking to me!</q>'
        
    ]
    name = 'yourself'
;

+++ AltListTopic
    "She's probably said all she usefully can say about you for now. "
;

++ AskTellTopic, EventList @felicityHair
    [
        '<q>You have lovely hair!</q> you tell her.\b
        <q>Why, thank you, kind sir,</q> she smiles, <q>flattery will get you
        everywhere!</q> ',
        
        '<q>Have you always worn it that long?</q> you ask, <q>It suits
        you!</q>\b
        <q>You think so?</q> she replies, <q>it used to be longer when I was
        little.</q>'
    ]
;

+++ AltListTopic
;

++ AskTellTopic, EventList @eden
    [
        '<q>Don\'t you like the garden?</q> you ask.\b
        <q>Yes -- at least, it\'s a pleasant enough garden,</q> she replies,
        <q>but I don\'t exactly like it -- or rather I don\'t entirely
        <i>trust</i> it.</q>',
        
        '<q>What do you think\'s so wrong with the garden?</q> you want to
        know.\b
        <q>That tree, for one thing,</q> she gives a little shudder, <q>if we
        stayed in the garden too long one or the other of us would be bound to
        eat from it sooner or later, and I have a feeling that could have
        seriously <i>bad</i> consequences.</q>',
        
        '<q>Is there anything else that makes you mistrust the garden?</q> you
        wonder.\b
        <q>It\'s an image of a lost paradise -- not a place for real human
        life,</q> she replies. '     
    ]
;

+++ AltListTopic
    "Felicity has made it quite clear she doesn't care too much for the garden,
    so maybe the time has come to let that topic rest. "
;

++ ShowTopic @faintGlow
    "<q>Look at that distant glow!</q> you say.\b
    <q>Yes, I can see it -- but can't we get a closer look?</q> she
    replies.<.convnode closer-look>"
;

++ ShowTopic @distantGlow
    "You point across the chasm, <q>That's about the best view of that golden
    glow we can get -- at least from this side of the chasm,</q> you tell
    her.\b
    Felicity watches it, seemingly spellbound for a moment or two, then turns
    to you and declares, <q>Then we must find some way of getting to the other
    side!</q>"
;


++ AskTellGiveShowTopic, StopEventList @ropeBridge
    
    [
        '<q>It\'s too bad there\'s no way we can cross that bridge,</q> you
        remark, <q>I\'d like to find out what\'s over on the other side.</q>\b
        <q>Maybe we could find something to replace the missing post,</q> she
        suggests.<.reveal missing-post> ',
        
        '<q>Even if we did find something to use as another support for that
        bridge, I\'m not sure how secure it would be,</q> you opine, <q>I mean,
        I\'d hate to be on that bridge if we\'d jerry-rigged a repair that gave
        way while we were halfway across!</q>\b
        <q>Perhaps one of us could stay here to make sure the second pole
        didn\'t become dislodged while the other one crossed.</q> she
        suggests.\b
        <q>But then how does whoever\'s left get across?</q> you want to
        know.\b
        <q>Well, you\'re obviously heavier than me, so if you got across safely
        without pulling out second post out, I\'d know it was safe for me to
        follow,</q> she points out. ',
        
        '<q>I haven\'t seen anything round here that looks like something we
        could use as a second support post,</q> you observe.\b
        <q>There must be <i>something</i>,</q> she replies; but you\'re not
        quite sure who she\'s trying to convince. '    
        
    ]
    isActive = (getActor.canTouch(ropeBridge))
;

++ AskTellTopic, StopEventList @missingPost
    [ 
        '<q>Where do you think we might find the missing post?</q> you ask.\b
        <q>I don\'t know -- let\'s have a look-round.</q> she suggests. ',
        
        '<q>What can we use to replace that missing post?</q> you wonder.\b
        <q>Let\'s keep looking -- we\'re sure to find something!</q> she
        insists. ' 
        
    ]
    isActive = gRevealed('missing-post')
;


++ AskTellTopic, StopEventList [distantGlow, tHeaven]
    [
        '<q>That golden glow I saw across the chasm,</q> you remark, <q>I think
        it might be heaven --  I\'m convinced it\'s a place of ultimate
        felicity and bliss.</q>\b
        <q>Well, I\'ll supply the felicity if you supply the bliss!</q> she
        quips. ',     
        
        '<q>Seriously, Felicity, that golden glow looks like a glorious
        celestial city,</q> you tell her.\b
        <q>Really?</q> she replies, <q>It sounds to me like we should try to
        get there, then!</q>'      
    ]
;

+++ AltTopic, StopEventList
    [
        '<q>I wonder if that golden glow over the chasm really is heaven,</q>
        you muse.\b
        <q>I don\'t know,</q> she replies, <q>Let\'s see if we can find
        out!</q>',
        
        '<q>Do you think there\'s a way we can reach that golden city?</q> you
        ask.\b
        <q>We must find one!</q> she declares brightly. ' 
    ]
    isActive = (gRevealed('felicity-glow'))
;

++ AskTellGiveShowTopic, EventList @swamp
    [
        '<q>That was pretty nasty swamp you got yourself into,</q> you
        remark.\b
        <q>It was pretty nasty,</q> she agrees, <q>but I didn\'t exactly get
        myself into it.</q>',
        
        '<q>So how did you end up in that swamp?</q> you want to know.\b
        <q>I got sucked in,</q> she replies. ',
        
        '<q>What do you make of that swamp?</q> you enquire.\b
        <q>Now that,</q> she says, <q>could well be the pertinent question. It
        stinks of humbug and pops with buzz-words; it\'s a mire of slippery
        verbiage.</q> ' 
    ]
;

+++ AltListTopic
    
;

++ AskTellTopic @eden
    "<q>What's the matter with this garden? It seems fine to me -- why can't we
    stay here?</q> you want to know.\b
    <q>Because we can't,</q> she replies stubbornly. "
    isActive = (getActor.isIn(eden))
;

++ GiveShowTopic @ossuary2
    "<q>Here, look at this!</q> you say, passing her the ossuary.\b
    She takes it and examines it quickly, <q>It's an ossuary, a box for old
    bones,</q> she remarks, and then hands it back to you. "
;

++ GiveShowTopic @felicityHair
    "<q>Lovely hair,</q> you observe, touching it gently to call her attention
    to it.\b
    <q>Yes, and I'm very attached to it,</q> she replies pertly. "
;


++ GiveShowTopic, EventList @apple
    [
        '<q>Would you like this apple?</q> you enquire, offering it to her.\b
        <q>Where did you get it from?</q> she asks suspiciously.<.convnode
        ask-apple>',
        
        '<q>Are you sure you wouldn\'t like this apple?</q> you ask.\b
        <q>Quite sure!</q> she replies. '
    ]
;

+++ AltListTopic
    "Felicity has already made it quite clear that she doesn't want it. "
;

++ AskTellTopic [apple, appleTree]
    "<q>There was just this one apple growing on the tree in the middle of the
    garden,</q> you start to tell her.\b
    <q>One apple is all it takes,</q> she replies. "
;

++ AskTellTopic +100 [knife, wintryTree]
    "<q>I found a knife plunged into <<gPlayerChar.isIn(cliffGarden) ? 'this
        tree' : 'that tree in the cliff garden'>>,</q> you tell her, <q>I think
    it may have been used to cut one of the ropes securing
    <<gPlayerChar.isIn(ropeLedge) ? 'this bridge' : 'the bridge across the
        chasm'>>.</q>\b
    <q>That seems rather destructive!</q> she observes. "
    isActive = mountainDoor.isOpen
;

++ ShowTopic @felicity
    "You need to be more specific about what you want to show to Felicity. "
;

+++ AltTopic
    "Showing Felicity herself would be somewhat superfluous; she's presumably
    quite familiar with herself already. "
    isActive = gAction.getOrigTokenList.length > 2
;


++ AskTellTopic, EventList @demon
    [
        {: "<q>The first time I <<gPlayerChar.isIn(hellsGate) ? 'passed this
            way' : 'saw that gate'>> there was a demon there, up a ladder,
            chipping away at the lettering over the gate,</q> you tell her.\b
            <q>Well, he's not <<gPlayerChar.isIn(hellsGate) ? 'here' :
              'there'>> now,</q> she observes. " },
        
        '<q>I wonder where that demon got to,</q> you remark.\b
        <q>Perhaps it\'s his lunch-break,</q> she suggests, <q>or maybe
        today\'s an official underworld holiday.</q>'
    ]
    isActive = gRevealed('felicity-gate')
;

+++ AltListTopic
    "You've already told Felicity about the demon. "
;

++ AskTellGiveShowTopic, StopEventList @pipe
    [
        '<q>That\'s the pipe I used to get into hell,</q> you tell her, <q>I
        crawled in, slid down, and ended up inside a boiler!</q>\b
        <q>Goodness me!</q> she declares, <q>You\'re lucky you didn\'t get a
        roasting!</q>',
        
        '<q>There didn\'t seem any other way to get anywhere from here, so I
        used that pipe,</q> you explain.\b
        <q>So you said,</q> she remarks. '
    ]
    isActive = (getActor.canSee(pipe))
;


++ AskTellGiveShowTopic, StopEventList +110 [pipe, wireGrating]
    [
        '<q>That grating wasn\'t in the pipe before.</q> you remark.\b
        <q>Well, it\'s certainly there now!</q> she observes. ',
        
        '<q>I wonder is there\'s some way of removing that grating,</q> you
        muse.\b
        <q>I really can\'t see the point!</q> she protests, <q>I certainly have
        no intention of crawling into that pipe!</q>',
        
        '<q>I used that pipe to get into Hell in the first place,</q> you
        observe, <q>If I hadn\'t gone in there I wouldn\'t have found
        you!</q>\b
        <q>But that you have found me there\'s no need to go back in there,</q>
        she points out. ',
        
        'You\'ve said all that needs to be said about the pipe and the
        grating. '   
        
    ]
    isActive = wireGrating.seen
;

++ AskForTopic @tKiss
    topicResponse()
    {
        "<q>Felicity, would you give me a kiss?</q> you ask.\b
        <q>Of course -- but do you really have to ask? Why don't you just go
        right ahead?</q> she invites.<.p>";
        nestedActorAction(gPlayerChar, Kiss, felicity);
    }
;

++ SemiDefaultAskTopic, ShuffledEventList
    eventList =
    [
        '<q>I\'ve been meaning to ask you about ' + gTopicText + ',</q> you tell
            her.\b
            <q>Ah yes,' + gTopicText + ',</q> she muses, <q>now there\'s a 
                word to conjur with!</q>',
        
        '<q>What do you think about ' + gTopicText + '?</q> you ask.\b
            In response, Felicity gives you her views on ' + gTopicText
        + 'but you are so enchanted by the sound of her voice that you forget
            to attend to what she actually says. ',
        
        'You have an earnest discussion with Felicity about ' + gTopicText +
        ' for the next hour or so. ', 
        
        '<q>I was thinking we could explore the subject of ' + gTopicText +
        '</q> you suggest.\b
        <q>I think we\'d be better employed exploring the area!</q> she quips
        in reply. '     
    ]
;

++ DefaultAskTopic, ShuffledEventList
    [
        '<q>Wrong question,</q> she replies, with a mysterious little smile. ',
        
        '<q>Ask me something else,</q> she suggests. ',
        
        'In reply, she merely looks at you, as if to say you should have known
        better than to raise the subject right now. ',
        
        'By way of an answer she gives you a knowing look and lightly touches
        your arm, as if expecting you to understand just what this means. ',
        
        '<q>Let\'s talk about something else,</q> she sighs. ',
        
        '<q>Maybe we can discuss that some other time,</q> she suggests. '
    ]
;

++ DefaultTellTopic, ShuffledEventList
    [
        'She listens attentively while you tell her about ' + gTopicText
        + ', but offers no response. ',
        'In reply she merely gives a thoughtful nod. ',
        'She smiles, but offers no other comment. ',
        '<q>I see,</q> she remarks. ',
        '<q>That\'s very interesting!</q> she declares, <q>You must tell me
        more about it some time!</q>',
        'Your explanation of ' + gTopicText + ' brings a distant expression
            to her deep blue eyes. ' 
    ]
;

++ CommandTopic @PullAction
    topicResponse
    {
        "<q>Felicity, see that small lever at the back of the niche over there?
        Would you mind giving it a pull for me?</q> you ask.\b
        <q>Sure,</q> she says. ";
        nestedActorAction(felicity, Pull, smallLever);
    }
    matchDobj = smallLever
    isActive = getActor.canSee(smallLever)
;

++ CommandTopic @TurnAction
    topicResponse
    {
        "<q>Felicity, could you turn that wheel while I hold this lever,
        please?</q> you request.\b
        <q>Sure,</q> she agrees. ";
        nestedActorAction(felicity, Turn, ironWheel);
    }
    matchDobj = ironWheel
    isActive = getActor.canTouch(ironWheel)
;

++ CommandTopic @KissAction
    "<q>Felicity, I'd really like you to give me a kiss,</q> you tell her.\b
    <q>With pleasure!</q> she smiles, at once going on to demonstrate that she
    means just what she says. "
    matchDobj = gPlayerChar
;

++ TCommandTopic @AttackAction
    "<q>Felicity, <<cmdPhrase>>!</q> you suddenly command.\b
    <q>Why on earth should I do that?</q> she replies, bemused. "
;

++ CommandTopic @FollowAction
    "<q>Come with me,</q> you request.\b
    <q>Don't worry, I'm sticking right with you,</q> she assures you,
    <q>wherever you go, I shall follow.</q>"
    matchDobj = gPlayerChar
;

++ CommandTopic @TopicActionBase
    "You realize that's a pretty pointless command. "
    isConversational = nil
;

++ CommandTopic @ThinkAction
    "<q>Think, Felicity, think!</q> you urge her.\b
    <q>I'm doing my best!</q> she assures you. "
;

++ TCommandTopic @TravelAction
    "<q>Felicity, why don't you <<cmdPhrase>>?</q> you suggest.\b
    <q>I'm not going anywhere without you!</q> she insists. "
;

++ TCommandTopic @InventoryAction
    "<q>Felicity, could you check what you\'re carrying?</q> you suggest.\b
    <q>Sure,</q> she replies. "
    obeyCommand = true
;


++ DefaultTCommandTopic
    "<q>Felicity, do you think you could <<cmdPhrase>>?</q> you request.\b
    <q>I'd rather not,</q> she replies. "
;

++ GiveShowTopic @oldBones
    "<q>What do you make of those?</q> you ask, holding out the bones for
    Felicity to inspect.\b
    <q>Ugh!</q> she replies, instinctively recoiling from them; but she then
    adds, <q>Odd -- they don't look like a complete set; and I'm not even sure
    they\'re human!</q>"
;

++ ShowTopic, StopEventList @smallLever
    [
        '<q>Look, there\'s a small lever at the back of that niche,</q> you
        remark.\b
        Felicity peers inside and then agrees, <q>So there is!</q>',
        
        '<q>Look at that lever,</q> you suggest.\b
        <q>You\'ve already shown it to me,</q> she reminds you. ' 
    ]
;


++ DefaultAskForTopic
    "In reply, she merely gives you an engimatic smile. "
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>Here, what do think of {that dobj/him}?</q> you ask.\b
        <q>Very nice, I\'m sure,</q> she remarks drily, <q>but I think we
        have more important matters to attend to right now.</q> ',
        
        'She glances at {the dobj/him} and refuses it with a smile, <q>I\'ll
        let you keep {it dobj/him},</q> she tells you. ',
        
        '<q>It\'s {a dobj/he},</q> she remarks, <q>why don\'t you hang on to
        {it dobj/him}?</q>',
        
        'She takes one glance at {the dobj/him} then shakes her head. '  
    ]
;

+++ AltTopic, ShuffledEventList
    [
        '<q>Here, what do think of {that dobj/him}?</q> you ask.\b
        <q>Very nice, I\'m sure,</q> she remarks drily, <q>but I think we have
        more important matters to attend to right now.</q> ',
        
        'She glances at {the dobj/him} and turns away, <q>I think
        there are more interesting things round here,</q> she tells you. ',
        
        '<q>It\'s {a dobj/he},</q> she observes. ',
        
        'She takes one glance at {the dobj/him} then shakes her head. '  
    ]
    isActive = (gDobj.ofKind(NonPortable))
;

++ HelloTopic
    "<q>Hello!</q> you say.\b
    <q>Hello, I'm still here!</q> Felicity assures you. "
;

++ ByeTopic
    "This hardly seems an appropriate moment to bid farewell to Felicity. "
    isConversational = nil
;

++ DefaultAnyTopic
    "<q>Let\'s find a way out of here,</q> she suggests. "
;

+ ConvNode 'closer-look'
;

++ YesTopic
    "<q>Yes, we can get a closer from across the chasm,</q> you reply.\b
    <q>Show me!</q> she urges you, <q>Take me there!</q>. "
;


+++ AltTopic
    "<q>Yes -- </q> you reply dubiously, <q>At least, I daresay we could if we
    could find a way across that chasm.</q>\b
    <q>Then that\'s what we must do!</q> she declares. "
    isActive = (gRevealed('felicity-glow'))
;

++ NoTopic
    "<q>No -- at least not much closer,</q> you reply, <q>There doesn't seem
    to be a way to get across the chasm.</q>\b
    <q>But we can get a slightly better view -- show me, take me to where we
    can see it best,</q> she insists. "
;

+++ AltTopic
    "<q>No -- at least the view we saw across the chasm was the best there
    is,</q> you reply, <q>we can\'t get any closer then that.</q>\b
    <q>Then let's go back to take another look,</q> she suggests, <q>I want to
    see it again.</q>"
    isActive = (gRevealed('felicity-glow'))
;


+++ AltTopic
    "<q>No, this is the best view we can get,</q> you tell her.\b
    <q>The best view from this side, you mean,</q> she replies, <q>It looks so
    glorious -- we must find a way to get across the chasm so we can take a
    better look!</q> "
    isActive = (gPlayerChar.isIn(chasmEdge))
;

+ ConvNode 'we-together'
    
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes we are, and that's good at any rate,</q> you agree.\b
    <q>Yes, it is,</q> she affirms. "
;

+ ConvNode 'ask-apple'
    response = "<.p><q>And you\'re offering it to me?</q> Felicity laughs,
        <q>Shouldn\'t it be the other way round? As I recall, the last time a
        man and a woman ate of a fruit taken from a tree in the middle of a
        mythical Garden there were somewhat catastrophic results. I\'d get rid
        of it if I were you!</q>"
    limitSuggestions = true
;

++ SpecialTopic 'lie' ['lie']
    "<q>Oh, I just found it lying around somewhere.</q> you reply vaguely.\b
    <q>Hm. It looks freshly-picked to me,</q> she remarks suspiciously, <q>I
    think I'll give it a miss, thank you very much. I just have this funny
    feeling that eating any food in this place could be bad for us. I'd throw
    it away if I were you.</q> "
;

++ SpecialTopic 'tell the truth' ['tell', 'her', 'felicity', 'the', 'truth']
    "<q>I picked it from a tree in the middle of a big garden -- it was a bit
    like the Garden of Eden really.</q> you tell her.<<location.response()>> "
;

+++ AltTopic
    "<q>I picked it from there,</q> you tell her, pointing to the majestic tree at
    the centre of the garden. <<location.response>>"
    isActive = gPlayerChar.isIn(eden)
;

++ AskTellGiveShowTopic, SuggestedShowTopic @apple
    "<q>Look, here it is,</q> you say, <q>a nice juicy apple!</q>\b
    <q>Yes, I can see it's an apple,</q> she says, <q>but where on earth did
    you find it?</q><.convstay>"
    name = 'the apple'
;

+ ConvNode 'through-gate'
    reply = "<.p><q>A <i>boiler</i>!</q> she declares, <q>In <i>hell</i>! Well,
        it can't  exactly have been hell as we know it, can it? But then,
        nothing round here is quite as it seems.</q>"
;

++ NoTopic, SuggestedNoTopic
    "<q>No, I didn't go through the gate, but I'm pretty sure I found another
    way into Hell -- through a disused flue pipe into a boiler,</q> you tell
    her.<<location.reply()>>"   
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes -- at least, not actually through the gate itself, that was firmly
    closed, but I managed to get into Hell another way -- down an old flue pipe
    into a boiler,</q> you tell her.<<location.reply()>>"
;

+ AgendaItem
    initiallyActive = true
    isReady = (inherited && getActor.canSee(distantGlow))
    invokeItem
    {
        isDone = true;
        "<q>Oh! Look at that!</q> Felicity exclaims, pointing across the chasm
        to the distant golden glow, <q>Doesn't it look heavenly! Is that broken
        bridge really the only way across? There must be <i>some</i> way we get
        over there to take a closer look!</q><.reveal felicity-glow>";
    }
;

+ AgendaItem
    initiallyActive = true
    isReady = gRevealed('felicity-glow') && getActor.canTouch(ropeBridge)
    invokeItem
    {
        isDone = true;
        "Felicity looks thoughtfully at the rope bridge, then stares across the
        chasm. Then slowly but deliberately, she takes hold of the loose rope
        end and pulls it tight. Turning to you she says, <q>If I keep hold of
        this firmly, you should be able to get safely across.</q>";
        ropeBridge.isHeld = felicity;
        getActor.initiateConversation(felicityHolding, 'cross-bridge');  
        challengeManager.setChallengeUpdate('Felicity has just taken hold of
            the loose rope on the bridge and is suggesting that you cross. ', nil);   
    }
;

+ AgendaItem
    initiallyActive = true
    isReady = getActor.isIn(cliffGarden)
    invokeItem
    {
        isDone = true;
        "She walks to the western edge of the garden and peers at the distant
        golden glow, <q>What's that?</q> she asks you.\b
        <q>I'm not sure; I think it may be a city of some sort,</q> you tell
        her, <q>you can get a much better view from further along the
        chasm.</q>\b
        <q>Show me,</q> she requests. ";
    }
;

+ AgendaItem
    initiallyActive = true
    isReady = getActor.isIn(eden)
    invokeItem
    {
        isDone = true;
        "She reaches out and takes your hand. For a few moment she stands,
        breathing deeply, with an expression of blissful contentment on her
        face. But then her expression takes on a more wistful look as she
        remarks, <q>This may look like Paradise, but somehow I don't think we
        can stay here. You are not Adam and I am not Eve and -- and I just
        don't feel there\'s anything for us here. We need to move on.</q> ";
        getActor.addToAgenda(edenAgenda);
    }
;

+ edenAgenda : ConvAgendaItem, ShuffledEventList
    isReady = inherited && getActor.isIn(eden)
    invokeItem  {  doScript; }
    eventList = [
        '<q>Come, let\'s go,</q> Felicity insists, gently tugging you towards
        the cave entrance, <q>There\'s nothing for us here.</q><.reveal
        leave-garden>',
        
        '<q>What are you waiting for?</q> Felicity demands, <q>This place
        isn\'t for us -- we should go.</q> ',
        
        'Felicity takes your hand and pulls you insistently towards the cave,
        <q>Time to go,</q> she urges, <q>if we stay here we\'ll just
        vegetate!</q> ',
        
        '<q>Come on, come <i>on</i>!</q> Felicity insists, <q>we can\'t hang
        around this place for all eternity!</q>',
        
        'Felicity walks to the mouth of the cave, then turns to look back at
        you, <q>Well, are you coming?</q> she asks, <q>Come on!</q> '
        
    ]
    shuffleFirst = nil
;

+ AgendaItem
    initiallyActive = true
    isReady = getActor.isIn(hellsGate)
    invokeItem
    {
        isDone = true;
        "She stares at the great gate with evident distaste, then points to the
        sign about demythologization and laughs, <q>And about time
        too!</q><.reveal felicity-gate>";
    }
;

//+ AgendaItem
//  initiallyActive = true
//  isReady = getActor.isIn(chessRoom)
//  invokeItem
//  {
//    isDone = true;
//    "She stares curiously at the stone emperor still seated at the chessboard, then
//     at the chessboard itself.\b
//     <q>This all looks very strange!</q> she remarks.";
//    getActor.initiateConversation(nil, 'explain-chess');
//  }
//;
//
//+ ConvNode 'explain-chess'
//  limitSuggestions = true
//;
//
//++ SpecialTopic 'explain' ['explain']
//  "<q>Yes,</q> you tell her, <q>it was pretty weird. I came in here from the other side,
//   and Caiaphas was playing Pontius Pilate. When Pilate tried to move the Emperor, the
//   Emperor changed places with him and through him away. He then defeated Caiaphas by
//   taking his temple with a Whore seated on a Beast he took from under the table and 
//   challenged me to take him on. Well, I looked under the table and found a new piece 
//   of my own, with which I was able to take the Beast. At that point the Emperor turned
//   to stone and that crack in the wall opened up!</q>\b
//   <q>And then you were able to come and rescue me!</q> she smiles,
//   <q>How very suggestive!</q>"
//;
//
+ AgendaItem
    initiallyActive = true
    isReady = !getActor.isIn(swamp)
    invokeItem
    {
        if(rand(100) > 75)
        {
            isDone = true;
            getActor.addToAgenda(felicityGetOutAgenda);
        }
    }  
;

+ felicityGetOutAgenda : ConvAgendaItem, StopEventList
    eventList = [
        '<q>I think we should try to find a way out of this place,</q> Felicity remarks. ',
        '<q>I\'m sure there must be a way out of here somewhere -- I want to
        get as far away from that swamp as possible!</q> Felicity tells you. ',
        { : isDone_ = true } 
    ]
    invokeItem { doScript; }
    agendaOrder = 110
    isDone_ = nil
    isDone = (isDone_ || mountainDoor.isOpen)
;

//-------- Felicity now has hold of the rope-bridge ----------------

+ felicityHolding : ActorState
    specialDesc = "Felicity is holding tightly onto the loose rope. "
    hugResponse = "You manage a somewhat awkward little hug, with Felicity
        keeping one hand tightly on the rope. <q>Now, go!</q> she commands. "
    kissResponse = "You kiss, but it feels unsatisfactory somehow -- an all too
        brief passing kiss, as if you just going down to the corner shop
        instead, perhaps, of parting forever. "
    
    afterAction()
    {
        if(gActionIs(Yell))
            "<.p><q>There's no need to get upset,</q> Felicity assures you,
            <q>I'm sure we can resolve this rationally. All you need to do is
            cross the bridge!</q>";
    }
    beforeTravel(actor, connector)
    {
        if(actor == gPlayerChar && connector != ropeLedge.west)
        {
            "This hardly seems like a good moment to go wandering off. ";
            exit;
        }
    }
;

++ CommandTopic @CrossAction 
    "<q>Felicity, will you please cross the bridge!</q> you tell her.\b
    <q>No, I will not,</q> she refuses, <q>I want you to cross
    it!</q><.convnode cross-bridge>"
    
    matchDobj = ropeBridge
;

++ GiveShowTopic @apple
    topicResponse
    {
        "<q>Oh for goodness's sake get rid of that wretched thing!</q> she
        cries, snatching the apple from your grasp and tossing it into the
        chasm. ";
        apple.moveInto(nil);
    }
;

++ GiveShowTopic @parchment
    "She takes the parchment from you and remarks, <q>Looks like
    Wortschlachter's notes, perhaps... hm. <q>My mind is as empty as the
    tomb</q>. That's Wortschlachter all right.</q>\b
    After another cursory glance, she hands the parchment back to you with
    evident distaste. "
;

++ DefaultAnyTopic
    "<q>I wish you'd hurry up and cross!</q> she complains, <q>I can't
    hang on to this thing forever!</q>"
;

+ ConvNode 'cross-bridge'
;

++ SpecialTopic 'refuse' ['refuse']
    "<q>No,</q> you say, <q>that's not right; there has to be another
    way!</q>\b
    <q>There is no other way,</q> she tells you, <q>Only one of us can cross,
    and I've decided it's going to be you.</q><.convnode argue-bridge>"
    timesToSuggest = nil
;

++ SpecialTopic 'agree' ['agree']
    "<q>Very well, then,</q> you agree reluctantly, <q>I suppose I could just
    take a look at what's over there, and come back and tell you, or maybe see
    if there's another way to get across...</q>\b
    <q>That's the spirit!</q> she agrees, <q>So, what are you waiting for? Get
    going!</q>"
    timesToSuggest = nil
;


+ ConvNode 'argue-bridge'
;

++ SpecialTopic 'argue' ['argue']
    "<q>I still don\'t think it\'s right,</q> you protest, <q>I\'m not going to
    cross that bridge without you!</q>\b
    <q>Then we\'ll both be stuck here,</q> she points out, <q>Since it\'s clear
    we can\'t both cross this bridge together!</q><.convnode argue-again>"
    timesToSuggest = nil
;

++ SpecialTopic 'give in' ['give', 'in']
    "<q>All right, you win, I give in!</q> you declare, <q>Just make sure you
    hang on to that rope tightly!</q>\b
    <q>I will, don't you worry!</q> she assures you, <q>Now, get going, there's
    no point delaying!</q>"
    timesToSuggest = nil 
;

+ ConvNode 'argue-again'
;

++ SpecialTopic 'protest' ['protest']
    "<q>I must protest!</q> you protest, <q>It isn't right for me to go and
    leave you here!</q>\b
    <q>Because I'm a woman, you mean? Don't you believe in equality of the
    sexes?</q> she demands.<.convnode sex-equality><.topics>"
    timesToSuggest = nil
;

++ SpecialTopic 'give way' ['give', 'way']
    "<q>Well, if you insist...</q> you begin dubiously.\b
    <q>I do insist,</q> she insists, <q>So get going!</q>"
    timesToSuggest = nil
;

+ ConvNode 'sex-equality'
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes, of course,</q> you begin.\b
    <q>There you are then,</q> she declares triumphantly, <q>You've no excuse
    to try to be chivalrous! I held this rope first, I asked you to go first,
    and you've already saved me once, so fair's fair. Now get going!</q>"
    timesToSuggest = nil
;

++ NoTopic, SuggestedNoTopic
    "<q>Not in this case,</q> you reply stubbornly, <q>I didn't rescue you just
    to leave you stranded, after all!</q>\b
    <q>So, you think I'd feel any better about leaving you stranded?</q> she
    retorts. <q>Go on, please, I want you to!</q><.convnode cross-bridge>"
    timesToSuggest = nil
;

+ ConvNode 'really-think-so'
    limitSuggestions = true  
    npcContinueMsg = "Felicity is waiting anxiously for an answer to her
        question; do you really want her to cross that bridge while you hang on
        to the rope?"
    canEndConversation(actor, reason) { 
        switch(reason)
        {
        case endConvBye:
            "The time to say goodbye is once you've determined which of you is
            going to cross that bridge. "; break;
        case endConvTravel:
            "This is not a situation you can even contemplate walking away
            from. ";
            break;
        default:
            "Felicity is still waiting for your answer. ";
        }
        return nil; 
    }
    
;

++ YesTopic, SuggestedYesTopic
    "<q>Yes,</q> you nod firmly, <<felicityCrossesBridge()>>"
    timesToSuggest = nil
;

++ NoTopic, SuggestedNoTopic
    topicResponse
    {
        "<q>No,</q> you say, slowly letting the rope fall from your grasp,
        <q>Perhaps we should think this through some more.</q>\b
        She takes the rope firmly in her grasp once more and replies briskly,
        <q>Well, the only alternative is to do what I suggested all along --
        namely for you to cross while I hold the rope. Okay?</q> <.convnode
        cross-bridge>";
        
        ropeBridge.isHeld = felicity;
    }
    timesToSuggest = nil
;

++ CommandTopic, SuggestedTopic @CrossAction
    "<q>Go on, go across,</q> you tell her, <<felicityCrossesBridge()>>"
    fullName = 'tell her to cross the bridge'
;


++ ByeTopic
    "The time to say goodbye is once you've determined which of you is
    going to cross that bridge.<.convstay>"
;

++ DefaultAnyTopic
    "That's not important right now -- you're hanging onto the rope and Felicity
    has just asked if you really mean you want her to cross. <.convstay>"
;



//---------- Felicity is standing over the PC's hospital bed

+ felicityHospital : ActorState
    specialDesc = "Felicity is standing over the bed, smiling down at you. "
    stateDesc = "She\'s standing over the bed, smiling down at you. "
    kissResponse = "You'd like to, but you're not quite sure it would be
        appropriate. "
    hugResponse = "You're not strong enough to attempt that yet. "
    smileResponse = "Felicity smiles back at you. "
;

++ DefaultAnyTopic
    "Felicity laughs. ";
;


+ ConvNode 'welcome-back'
    npcGreetingMsg =  "<q>Welcome back,</q> she says, <q>I was afraid we'd lost
        you!</q>"  
    npcContinueList : ShuffledEventList {
    [
        'Felicity gives you a slightly quizzical look, waiting for your answer. ',
        '<q>Well?</q> she asks, <q>Have you nothing to say to
        me?</q><.topics> ',
        '<q>Perhaps I should come back when you\'re stronger?</q> she wonders
        anxiously.<.topics>',
        '<q>You don\'t mind my coming to see you like this?</q> she
        worries.<.topics>',
        'She smiles down at you, but behind the smile something in her eyes
        betrays the fear of rejection. '  
        
    ]
    }      
    isSticky = true
;

++ SpecialTopic 'thank her for coming' ['thank', 'her', 'you', 'for', 'coming']
    "<q>Thank you for coming,</q> you manage to croak, <q>I didn\'t know you
    cared! To be honest, I didn't know you'd even noticed me!</q>\b
    <q>Oh yes,</q> she assures you, <q>I noticed you! I was just afraid you
    hadn't noticed me!</q>\b
    <q>Oh yes!</q> you reply, <q>I could hardly fail to do that!</q>\b
    <q>So,</q> she asks brightly, <q>what now?</q>\b
    As you lie smiling up at her, there seem to be no shortage of good answers
    to <i>that</i> question.<<winGame()>> "
    
;

++ SpecialTopic 'tell her to get lost' ['tell', 'her', 'to', 'get', 'lost']
    topicResponse()
    {
        "<q>What the hell are you doing here?</q> you snap, <q>I don't even
        know you! Who let you into this ward? Bloody hell! Can't a chap even
        have a heart-attack in peace!</q>\b
        You see her visibly flinch at your words, the joyous light dying in her
        eyes as the smile vanishes from her face. Without another word, she
        turns and walks away, walking out of your life for ever. ";
        addToScore(-3, 'rejecting Felicity for no good reason');
        finishGameMsg('YOU HAVE JUST THROWN AWAY HOPE FOR NO GOOD REASON', 
                      [finishOptionUndo, finishOptionFullScore, finishOptionCredits]);
    }
    
;     

++ SpecialTopic 'say how glad you are to see her' 
    ['say', 'how', 'really', 'glad', 'you', 'i', 'are', 'am', 'i\'m', 'to', 
        'see', 'her', 'you']
    "<q>How kind of you to come!</q> you declare, <q>I'm really glad to see
    you!</q>\b
    <q>Are you?</q> she smiles, <q>That's nice -- then I'm glad I came!</q>
    Cautiously, she reaches out her hand to yours; hesitantly, you take
    it.<<winGame()>>"              
;       

++ AskTopic, StopEventList @gPlayerChar
    [
        '<q>Where am I? What happened?</q> you ask.\b
        <q>You were taken ill in Wortschlachter\'s lecture,</q> she tells you,
        <q>it was enough to make anyone sick, I grant you, but that was a
        rather extreme way of escaping it!</q> she smiles warmly down at you,
        <q>We thought you\'d died! But the doctors say you\'ll be fine -- thank
        goodness!</q><.topics>',
        
        '<q>How long have I been here?</q> you want to know.\b
        <q>Oh, just a couple of days,<q> she assures you, <q>anyway, I\'m just
        so relieved to see you back in the land of the living!</q><.topics>',
        
        '<q>Will I ...?</q> you begin.\b
        <q>You\'ll be fine!</q> she assures you, <q>thank
        goodness!</q><.topics>'  
        
    ]  
;

++ AskTopic, StopEventList @felicity
    [
        '<q>Howcome you\'re here?</q> you wonder.\b
        <q>Well -- I had to tell a few porkies to get past the doctors,</q> 
        she confesses, <q>but I was determined to come!</q><.topics>',
        
        '<q>But why did you come?</q> you ask.\b
        <q>To see you, of course!</q> she smiles.<.topics>'  
    ]
;

++ AskTopic, StopEventList @worts
    [
        '<q>What happened to Wortschlachter when I collapsed?</q> you ask.\b
        <q>Oh, he didn\'t notice at first,</q> she laughs, <q>he just went
        burbling on about religionsgeschichtliche midrash in binary opposition
        to Gibberish-im-Leben, or whatever he was on about by then. Even with
        half the audience gathered round where you\'d fallen he just ploughed
        on. I think he\'d have carried on till dinner time if the session chair
        hadn\'t stopped him! Anyway, never mind about Professor Word-Butcher;
        how are you feeling?</q><.topics>',
        
        '<q>So, did Wortschlachter ever get a chance to finish his talk?</q>
        you ask.\b
        <q>No, thank goodness!</q> she beams, <q>You <i>really</i> did us all a
        favour there! But I was so worried about you!</q><.topics>' 
    ]
;

++ TellTopic, StopEventList @gPlayerChar
    [
        '<q>I\'ve just had the strangest near-death experience,</q> you tell
        her, <q>I seemed to be going through hell -- and then I ended up
        rescuing you from drowning in some terrible stinking marsh!</q>\b
        <q>Well, you certainly saved me from the terrible stinking humbug of
        Wortschlachter\'s lecture!</q> she smiles, <q>but, flattered though I
        am to have figured in your near-death experience, I\'m much more
        pleased that you\'ve come back to the real me!</q><.topics>. ',
        
        '<q>It all seemed so real -- and yet so odd,</q> you muse.\b
        <q>You can tell me all about it when you\'re stronger,</q> she
        replies.<.topics>'  
        
    ]
;       

++ kissTopic: AskForTopic @tKiss
    "<q>I don't suppose you'd give me a kiss?</q> you ask.\b
    <q>I might,</q> she replies, with an enigmatic little smile, and then
    relents to the extent of planting a light kiss on your brow. <q>If you were
    thinking of something more than that...</q> she adds.<.topics>"
;       

++ TCommandTopic @KissAction
    "<<kissTopic.topicResponse()>>"
    matchDobj = me
;

++ DefaultTellTopic
    "Felicity listens to what you have to say, then remarks, <q>I hope you're
    not trying to change the subject! I did hope you might be pleased to see
    me.</q><.topics>"
;

++ SemiDefaultAskTopic       
    topicResponse =
        "You ask your question about <<gTopicText>>, but from Felicity's
        expression it seems you didn't make too much sense.\b
        <q>I came here to see you, not to talk about that!</q> she
        remarks.<.topics>"      
;       

++ AskTellTopic @tLove
    "<q>I think I'm in love,</q> you tell her.\b
    <q>Really?</q> she asks, <q>But are you glad I came?</q><.topics>"
;

++ DefaultAskTopic
    "You mumble some incoherent question on the subject, in response to which
    Felicity gives a slightly pained look, then laughs, <q>I'm afraid I haven't
    a clue what you're talking about!</q><.topics>"
;       

++ DefaultAnyTopic
    "You might want to respond to her more directly.<.topics><.convstay>"
;

winAchievement: Achievement 
    +1 "saying the right thing to Felicity in hospital"
;



//==============================================================================    

/* 
 *   This code represents Felicity in the breakfast queue flashback, before 
 *   the PC learns her name.
 */  

blondeWoman : Person 'blonde woman' 'blonde woman' @breakfastQueue
    "Apart from her long blonde hair, what you noticed about her was the
    concert between the sparkle in her bright blue eyes and a mouth far more
    inclined to smile than to frown. But quite apart from any specifics there
    was something undefinable about her face that left you feeling totally
    smitten. "
    isHer = true
    endFlashback([args])
    {
        /* 
         *   First check that we're not in the middle of a ConvNode, since 
         *   we don't want the flashback to end while a current ConvNode is 
         *   in progress. If a ConvNode is current, set up another fuse to 
         *   try firing this method again in two turns time. 
         */ 
        if(curConvNode != nil)
            fuseID = new Fuse(self, &endFlashback, 2);
        else
        {
            "And there your conversation ended, since right then you both
            reached the front of the queue and set about collecting your
            respective breakfasts. When she went off with hers, you did briefly
            consider following her, but then she went and sat with a group of
            people she seemed to know, so after a brief moment of regretful
            hesitation you decided not to impose yourself on them. But for the
            rest of the day you've been repeatedly wondering whether such
            consideration wasn't simply misplaced timidity.<.p>
            The breakfast memory fades and you return to the present, forcing
            yourself to try to concentrate on Professor Wortschlachter's
            lecture...<.p> ";
            inputManager.pauseForMore(true);
            fuseID.removeEvent();
            fuseID = nil;      
            foreach(local cur in lakesideDepository.contents)
                cur.moveInto(gPlayerChar);
            badge.moveInto(badge.formerLocation);
            badge.wornBy = badge.formerlyWornBy;
            setPastTense(nil);
            gPlayerChar.moveIntoForTravel(lectureRoomChair);
            gPlayerChar.makePosture(sitting);   
            gPlayerChar.lookAround(nil);
            /* 
             *   We need to run the roomDaemon() manually if the player 
             *   returns to the lecture room via the fuse, but not if he's 
             *   returned there following an explicit bye command.
             */
            if(args.length == 0)    
                gPlayerChar.getOutermostRoom.roomDaemon();  
            new Fuse(self, &killCommand, 0);
        }
    }
    killCommand()
    {
        gPlayerChar.pendingCommand.setLength(0);
    }
    fuseID = nil
    cannotKissActorMsg = 'As much as that felt viscerally tempting, you knew
        perfectly well that it would be utterly inappropriate. You had never
        kissed a strange woman in your life, and you weren\'t about to start
        now. '
    uselessToAttackMsg = 'You\'ve never hit a woman in your life, and you
        weren\'t about to start at breakfast. '
    feelDesc = "Touching up women in the breakfast queue was clearly not going
        to enhance your reputation with anyone. "
    smileResponse = "You smiled tentatively at her, and she smiled tentatively
        back. "
    hugResponse = "She may look like the kind of women you'd secretly like to
        hug, but you knew perfectly well that suddenly hugging a woman you'd
        hardly met would hardly be likely to create a favourable impression. "
    smellDesc = "You were aware of the fresh, clean scent of someone who'd
        recently taken a bath and put on a clean set of clothes. "
    soundDesc = "She was probably waiting for you to say something; when you
        spoke, she replied. "
;

+ Component 'lush long (blonde) silky smooth loose lovely fair hair' 'her hair'
    "It tumbled loosely and alluringly over her shoulders, silky smooth, lush
    and long. "
    isQualifiedName = true  
    feelDesc = "As lovely as her hair looked, you felt pretty confident she
        wouldn't appreciate having it mauled by a strange man. "
    cannotMoveMsg = 'You felt it would be wiser to leave it alone. '
;

+ Component 'pretty beautiful face/eyes/mouth' 'her face'
    "<<blondeWoman.desc()>>"
    dobjFor(Kiss) remapTo(Kiss, blondeWoman)
    dobjFor(Attack) remapTo(Attack, blondeWoman)
    dobjFor(Feel) remapTo(Feel, blondeWoman)
;


+ blondeChatting : InConversationState
    specialDesc = "The blonde woman was just ahead of you in the queue. "
    stateDesc = "She had turned to face you, and was waiting for you to speak. "
    attentionSpan = nil 
;

++ blondeQueuing : ConversationReadyState
    specialDesc = "An attractive blonde was standing just ahead of you in the
        queue. "
    stateDesc = "She was standing just ahead of you in the queue. "
    isInitState = true
;

+++ ByeTopic
    topicResponse()
    {
        "At that point, she turned away to concentrate on her breakfast. ";
        getActor.endFlashback(true);   
    }
;

+++ ImpByeTopic
    ""
;

+++ HelloTopic
    topicResponse()
    {
        blondeQuestionAgenda.isDone = true;
        "You plucked up your courage to address her, managing to say, <q>Good
        morning!</q>\b
        She turned to you with a friendly smile and replied, <q>Hello, how are
        you enjoying the conference so far?</q><.convnode blonde-greeting>";
    }
;

+++ ImpHelloTopic
    "You plucked up enough courage to overcome your shyness and say, <q>Good
    morning! I don't believe we've met.</q>\b
    <q>Hello -- I'm ...</q> she replied with a smile, but you're so terrible
    with names so can't quite remember what she said it was. "
;


++ AskTopic, SuggestedAskTopic, StopEventList @blondeWoman
    [
        {: "<q>Is this your first time at this conference?</q> you enquired.\b
            <q>Yes, it\'s my first time at a PANTS
            conference<<tooObj.name>>.</q> she told you. <.reveal first-pants>" },
        
        '<q>What\'s your particular area of interest?</q> you asked.\b
        <q>The Gospels -- particularly Mark,</q> she replied, <q>That\'s why
        I\'m quite curious to hear what Wortschlachter will have to say this
        afternoon, even though I\'m not holding my breath at the prospect of
        any great enlightenment.</q> <.reveal mark-work>',
        
        '<q>And you\'re from...?</q> you inquired.\b
        <q>Cambridge,</q> she told you.<.reveal cambridge>',
        
        '<q>How long have you been at Cambridge?</q> you asked.\b
        <q>Three and a bit years,</q> she replied, <q>I\'m just completing my
        PhD there.</q>',
        
        '<q>What are you doing your doctorate on?</q> you enquired.\b
        <q>The symbolic use of miracle stories in Mark\'s Gospel,</q> she
        informed you. '
    ]
    name = 'herself'
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @tCambridge
    [
        '<q>How do you like Cambridge?</q> you asked.\b
        <q>It\'s good,</q> she nodded, <q>there\'s some fine scholars there,
        and I like it.</q>',
        
        '<q>I don\'t know Cambridge that well,</q> you confessed.\b
        <q>Then you must come and see it some time,</q> she suggested. '
    ]
    name = 'Cambridge'
    isActive = gRevealed('cambridge');
;

++ AskTopic, SuggestedAskTopic, StopEventList @worts
    [
        '<q>So, what do you make of Wortschlachter?</q> you wondered.\b
        <q>I think he\'s a man who\'s made his reputation by wrapping up
        largely vacuous thoughts in impressive-sounding language,</q> she
        opined, <q>like rather too many academics -- present company excepted,
        of course!</q> she added, with a delightful little giggle. <.reveal
        academics>',
        
        '<q>So you don\'t think much of Wortschlachter,</q> you surmised.<.p>
        <q>Well -- I do think he\'s overrated,</q> she replied, adding with a
        wicked sparkle, <q>But then the man\'s name means <q>Word-Butcher</q>,
        so what can you expect?</q>',
        
        '<q>Professor Wordbutcher? I hadn\'t thought of that!</q> you
        laughed.\b
        <q>Then you can\'t have read much of what he\'s written!</q> she
        laughed back in reply.<.reveal books> ',
        
        '<q>Have you read much Wortschlachter?</q> you inquired.\b
        <q>More than enough!</q> she laughed. '
    ]
    name = 'Professor Wortschlachter'
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @tAcademics
    [
        '<q>Do you really think there are that many academics like
        Wortschlachter -- wrapping up vacuous thoughts in impressive
        language?</q> you asked.\b
        <q>Well -- don\'t you?</q> she replied. When you failed to reply
        straight away she blushed a little, then added, <q>Well, even if it\'s
        only a relatively small minority of academics, that\'s still rather too
        many.</q>\b
        <q>True,</q> you conceded.',
        
        '<q>But how can even this small minority of academics get away with
        being so vacuous in their thinking?</q> you wondered.\b
        <q>Oh, it\'s just the Emperor\'s New Clothes syndrome, isn\'t it?</q>
        she replied, <q>If you manage to get into print and to wrap up your
        vacuity in the right sort of obscurity, no one wants to be the first to
        appear to have missed your point.</q>',
        
        '<q>Presumably you don\'t have such a low opinion of academics in
        general, or you wouldn\'t be here,</q> you surmised.\b
        <q>No indeed,</q> she agreed, <q>most of us are dedicated scholars
        sincerely doing out best -- it\'s the word-butchers that let the rest
        of us down.</q>',
        
        '<q>I have to say I haven\'t come across any word-butchers among my
        colleagues at Oxford,</q> you remarked.\b
        <q>Maybe Oxford is better at weeding them out,</q> she suggested. ', 
        
        '<q>Have you actually come across many word-butchers among the
        academics you know?</q> you wondered.\b
        <q>Not in person,</q> she said, <q>But rather too many in print.</q>'   
        
    ]
    isActive = gRevealed('academics')
    name = 'academics'
;

++ AskTopic @tBooks
    "<q>You don't think much of Professor Wortschlachter's books then?</q> you
    surmised.\b
    In reply, she merely pulled a face. "
    isActive = gRevealed('books')
;

++ TellTopic, SuggestedTellTopic, StopEventList @gPlayerChar
    [
        {: "<q>This is my first time at a PANTS conference<<tooObj.name>>,</q>
            you told her.<.p>
            <q>I thought I hadn't seen you before,</q> she replied, with a
            slightly enigmatic smile that dimpled her cheek. <.reveal
            first-pants>" },
        
        '<q>My main interest is historical Jesus research,</q> you informed
        her.<.p>
        <q>Then you won\'t get much from Wortschlachter\'s talk this
        afternoon,</q> she replied, <q>I don\'t think he believes in history at
        all!</q>'
        
    ]
    name = 'yourself'
;

++ AskTellTopic, SuggestedTalkAboutTopic @tWeather
    "<q>Not bad weather we're having for the time of year,</q> you remarked.\b
    <q>Not bad at all.</q> she agreed. "      
    name = 'the weather'
;

++ AskTellTopic, SuggestedTalkAboutTopic, StopEventList [tBreakfast, tFood]
    [
        '<q>It looks like they do a good breakfast here,</q> you remarked.\b
        <q>Yes, it does,</q> she agreed. ',
        
        '<q>I like to start with a good solid breakfast,</q> you informed her,
        <q>It sets me up for the day.</q>\b
        <q>I know what you mean,</q> she nodded. '
    ]
    name = 'breakfast'
;


++ AskTellTopic, SuggestedAskTopic, StopEventList @tPants
    [
        '<q>You\'d have thought they could have come up with a more auspicious
        acronym than PANTS for this conference!</q> you remarked.<.p>
        <q>Yes, you would!</q> she laughed. ',
        
        '<q>Do you know many of the people here?</q> you wondered.<.p>
        <q>A few,</q> she replied, <q>I came with a couple of people, and
        there\'s my old teacher from Birmingham -- oh, and one or two people
        I remember from the BNTS conference.</q> '
        
        
    ]
    name = 'the conference'
;

+ AskTellTopic, SuggestedAskTopic, StopEventList @tMark
    [
        '<q>Mark is fascinating, isn\'t it?</q> you enthused, <q>I always find
        some new meaning in it each time I look.</q>\b
        <q>Yes,</q> she agreed with a ready smile, <q>but there are those who
        would argue it\'s simply because he wasn\'t master of his material and
        failed to make himself clear -- not because he was two thousand years
        of his time in creating a deliberately indeterminate text.</q>',
        
        '<q>But there seem to be so many clever things in Mark that can\'t
        simply be accidental,</q> you said.\b
        <q>Oh, I agree absolutely,</q> she nodded, <q>his sandwich technique,
        patterns of threes, symbolic healing of blindness framing his travel
        section -- he obviously knew what he was doing.</q>',
        
        '<q>So what are you currently working on in Mark?</q> you wondered.\b
        <q>Right now I\'m particularly interested in his symbolic use of
        miracle stories,</q> she told you. '
        
    ]
    name = 'Mark\'s Gospel'
    isActive = gRevealed('mark-work')
;

++ AskAboutForTopic @tHerName
    "You didn't need to, since her name was in plain sight on her badge, but
    you can't remember what it said now. "
;

++ DefaultAskTopic
    "You couldn't think of an appropriate question to ask on that subject. "
    isConversationalTopic = nil
;

++ DefaultTellTopic
    "You couldn't really think of anything terribly apt to say about that. "
    isConversationalTopic = nil
;

++ DefaultCommandTopic
    "This was the first time you'd spoken with her; you weren\'t going to
    start trying to boss her around. "
    isConversational = nil
;

++ ShowTopic @tie
    "<q>Very nice,</q> she remarked politely when you showed her your tie. "
;

++ DefaultGiveShowTopic
    "The blonde woman did not appear all that interested. "
;


+ blondeQuestionAgenda: ConvAgendaItem
    initiallyActive = true
    isReady = (inherited && getActor.canTalkTo(gPlayerChar))
    invokeItem()
    {
        isDone = true;
        if(getActor.curState == blondeQueuing)
            getActor.initiateConversation(blondeChatting, 'blonde-greeting');
        else if(getActor.curState == blondeChatting)
        {
            "<q>So, what do think of the conference so far?</q> she asked. ";
            getActor.setConvNode('blonde-greeting');
        }  
    }
;


+ ConvNode 'blonde-greeting'
    npcGreetingMsg = "The blonde woman turned round just as you joined the
        queue and asked, <q>So, how are you enjoying the conference?</q> "
    limitSuggestions = true
    npcContinueList : CyclicEventList {
    [
        nil,
        '<q>The conference,</q> she reminded you, <q>how are you enjoying
        it?</q> ',
        nil,
        '<q>Hello! Is anyone at home?</q> she smiled cautiously, <q>I asked you
        how you were finding the conference.</q>'
    ]
    }
    canEndConversation (actor, reason) 
    {
        "You had no desire to break off the conversation at that point. ";
        return nil;
    }
;

++ SpecialTopic 'say it\'s great' ['say', 'that', 'its', 'it\'s', 'great']
    "<q>It's great,</q> you told her, <q>I'm really enjoying it!</q><.p>
    <q>And how are you looking forward to our star speaker this afternoon?</q>
    she inquired, <q>Will he be good, do you think?</q><.convnode
    star-speaker><.topics>"
;

++ SpecialTopic 'be unenthusiastic' ['be', 'unenthusiastic', 'unenth', 'unenthus']
    "<q>Well, to be honest, I'm not a great enthusiast for conferences,</q> you
    confessed, <q>and I'm not sure this one has changed my mind so far.</q><.p>
    <q>That's a shame!</q> she laughed, <q>But maybe our star speaker this
    afternoon will enthuse you more -- are you looking forward to him?</q>
    <.convnode star-speaker><.topics>"
;

++ TellTopic [gPlayerChar, tPants]
    "<q>I'm finding it okay so far,</q> you replied.\b
    <q>That's a very cautious answer!</q> she complained, <q>So how about this
    afternoon's speaker, are you looking forward to hearing him?</q> <.convnode
    star-speaker><.topics>"
;

++ AskTopic [blondeWoman, tPants]
    "<q>How are you enjoying it?</q> you asked.\b
    <q>Pretty well,</q> she smiled, <q>except that -- well, how do you think
    our star speaker will be this afternoon; will he be good, do you think?</q>
    <.convnode star-speaker><.topics>"
;


++ DefaultConvStayTopic
;


+ ConvNode 'star-speaker'
    limitSuggestions = true
    npcContinueMsg: CyclicEventList {
    [
        nil,
        '<q>This afternoon\'s main speaker -- are you looking forward to
        hearing him?</q> she prompted you. ',
        nil,
        '<q>Er -- I asked if you were looking forward to our star speaker this
        afternoon,</q> she reminded you. '
    ]
    }
    canEndConversation (actor, reason) 
    {
        "You had no desire to break off the conversation at that point. ";
        return nil;
    }
;

++ YesTopic, SuggestedYesTopic
    "<q>Professor Wortschlachter, you mean?</q> you replied, <q>Yes, his topic
    looks very interesting.</q> That was a lie, of course, but you didn't want
    to appear too negative.<.p>
    <q>You think so?</q> she replied, <q>I'm not so sure -- to be honest, I
    haven't been all that impressed by his books.</q> "
;

++ NoTopic, SuggestedNoTopic
    "<q>Professor Wortschlachter, you mean?</q> you replied, <q>No; I'd never
    heard of him, to be honest, but the title of his lecture is enough to put
    me off!</q><.p>
    <q>Me too!</q> she grinned, <q>And I haven't been that impressed by his
    books, either.</q>"
;

++ AskTopic [blondeWoman, worts]
    "<q>What do you think about him?</q> you enquired.\b
    <q>Not much,</q> she replied shortly, <q>I certainly haven't been at all
    impressed by his books!</q>"
;

++ TellTopic [gPlayerChar, worts]
    "<q>I don't know much about Wortschlachter to be honest,</q> you replied,
    <q>But the little I do know doesn't impress me.</q>\b
    <q>Nor me,</q> she agreed, <q>frankly, I think his books are total
    rubbish!</q>"
    
;


++ DefaultConvStayTopic
;


DefaultConvStayTopic : DefaultAnyTopic
    "Answering the question she asked struck you as being an elementary
    courtesy, especially since you wanted to create a good
    impression.<.convstay>"
    isConversational = nil
;


tooObj : object
    name = (gRevealed('first-pants') ? ' too' : '' )
;

felicityCrossesBridge()
{
    "<q>I mean, you wouldn't be doing me any favours if I proved too heavy for
    you to hang on to that rope while I was half-way across, would you?</q>\b
    <q>Very well,</q> she agrees reluctantly, <q>I suppose you're right.</q>
    She gives you a warm hug and a lingering kiss, then finally sets off across
    the bridge. You hold tightly on the rope as she walks gingerly across,
    knowing that if you were to slacken your grip you could send her tumbling
    into the boiling lava below.\b
    About half way across she stops and turns to look back at you, but you wave
    her on urgently, signalling to her that you can hardly keep hold of the
    rope forever; so she turns away once more and resumes her progress.\b
    At last she reaches the far side where she stops, turns, and waves once
    more. Seeing her safely on solid ground, you let your aching hands relax
    their grip on the rope, which feels like it's been growing heavier by the
    minute. As you do so, the centre of the bridge plummets down as if weighted
    by tons of lead. It jerks to a halt, jolting the whole mountainside as it
    does so. For a heart-stopping moment Felicity sways on her feet, but she
    manages to retain her balance. Then there's a loud creaking and groaning as
    the rocks all around you take the strain; some loose boulders come tumbling
    down the mountainside behind you, bounce off the ledge all around you and
    plunge into the lava below; some others somehow miss you but roll on the
    bridge, tumbling to its centre and weighing it down even further.\b Still
    the bridge holds, but the rumbling and creaking and groaning become louder
    still as the centre of the bridge sags further, dragging the two sides of
    the chasm towards each other. You stare at Felicity in amazement as she is
    borne towards you on her rocky shelf. A look of joy spreads over her face
    at the prospect of your imminent reunion, but then a cloud of dust starts
    to blot all from view, and everything fades -- everything but Felicity's
    face and her long blonde hair...<.p>";             
    
    inputManager.pauseForMore(true);
    cls();
    ropeBridge.achievement.awardPointsOnce();
    
    foreach(local cur in gPlayerChar.contents)
        if(!cur.ofKind(NonPortable))
        cur.moveInto(ropeLedge);
    
    /* Close any open goals, since we won't need any more hints now */
    for(local obj = firstObj(Goal) ; obj != nil; obj = nextObj(obj, Goal))
    {
        if(obj.goalState == OpenGoal)
            obj.goalState = ClosedGoal;    
    }
    
    gPlayerChar.moveIntoForTravel(hospitalBed);
    gPlayerChar.makePosture(lying);
    felicity.moveIntoForTravel(hospital);
    felicity.setCurState(felicityHospital);
    "<.p>The blur slowly dissipates, but the long blonde hair stays in
    view, much closer now, with the face it frames smiling anxiously down
    at you.\b";
    gPlayerChar.lookAround(true);
    felicity.initiateConversation(felicityHospital, 'welcome-back');
    challengeManager.setChallenge(nil);
    return ''; 
}


winGame()
{
    winAchievement.awardPointsOnce();
    finishGameMsg('YOU HAVE FOUND HOPE AFTER ALL', [finishOptionUndo, 
        finishOptionFullScore, finishOptionCredits]);
}

