/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"
#include "lang.h"

#define RESERVED_FOR_VERBOSITY_FLAG 0
#define RUSGREVE 1
#define PRENDERGAST 2
#define B_DOOR 3
#define S_DOOR 4
#define G_DOOR 5
#define GRANDMASTER 6
#define PRINCESS 7
#define MAGPIE 8
#define BUTLER 9
#define MOUSECOUNTER 10
#define ELEPHANTS 11
#define ELEPHANTFOLLOW 12
#define WAITCOUNT 13
#define WATERSPRITE 14
#define TENNIS 15
#define BIN 16

unsigned char flags [128];

static void remove_persons_objects(void)
{
  while(objects [yaccplayer].inside != 0)
  {
    int obj = objects [yaccplayer].inside;

    detachfromchain(obj);
    addtochain(obj,59,& objects [59].inside);
  }
}

extern void twirl(void)
{
  int i;
  bool gotsomething = FALSE;

  if(all) addfirstdescendants(getroom(yaccplayer));
  for(i = 0;i < listedobjects;i++)
  {
    if(objectlist [i] == 103) {
      format("You twirl the chair round and round, but nothing happens.");
    } else {
      format("How ever could you turn that?");
    }
  }
  listedobjects = 0;
  if(all && ! gotsomething) format("There is nothing here that you can reall"
"y turn!");
}

extern void turn(void)
{
  twirl();
}

extern int premove(int player,int dest)
{
  switch(dest)
  {
  case 6: case 20: case 55: case 56: /* Leaving the rickety wooden rooms */
    if(getroom(yaccplayer) < 6) {
      format("\nYou are suspended for a moment in absolute darkness, then a "
"voice pipes up, 'Always keep tight hold of nurse, /For fear of finding somet"
"hing worse!'\n\nSuddenly you emerge into daylight:\n");
    }
    break;
  case 15: /* poolside, going down */
    if(flags [WATERSPRITE] < 2) {
      format("You wisely decide not to go for a swim in the garden pond.\n");
      return 0;
    }
    break;
  case 18:
    if(flags [GRANDMASTER] != 4) flags [GRANDMASTER] = 1;
    break;
  case 19:
    if(flags [GRANDMASTER] == 4) format("You slip east while the Grandmaster"
" is still thinking over his recent failed match.");
    if(flags [GRANDMASTER] == 3) {
      format("The Grandmaster says, 'You won't get into there by buttering m"
"e up!'\n\nYou find that you are unable to go east.  Looking round, you see t"
"he Grandmaster making a magic sign.");
      return 0;
    }
    if(flags [GRANDMASTER] < 3) {
      format("You find that you are unable to go east.  Looking round, you s"
"ee the Grandmaster making a magic sign.");
      return 0;
    }
    break;
  case 17:
    if(flags [GRANDMASTER] != 3) {
      format("You find that you are unable to go south.  Looking round, you "
"see the Grandmaster making a magic sign.");
      return 0;      
    } else format("You slip south while the Grandmaster is basking in his vi"
"ctory.");
    break;
  case 37: /* Going up the tree */
    if(flags [MAGPIE] == 0) {
      format("As you start to climb the tree, the magpie flies full into you"
"r face, screeching angrily.  You lose your footing and fall to the ground.");
      return 0;
    }
    break;
  case 45: /* Going through the bronze door */
    if(flags [B_DOOR] == 0) {
      format("But the door is closed and locked!\n");
      return 0;
    }
    break;
  case 46: /* Going through the silver door */
    if(flags [S_DOOR] == 0) {
      format("But the door is closed and locked!\n");
      return 0;
    }
    break;
  case 47: /* Going through the golden door */
    if(flags [G_DOOR] == 0) {
      format("But the door is closed and locked!\n");
      return 0;
    }
    break;
  case 51: /* Leaving the elephants */
    if(getroom(player) == 52) {
      if(flags [MOUSECOUNTER] != 0) {
	format("You find that there is a step up, with a large overhang, which you "
"cannot negotiate while you are a mouse.  Perhaps a real mouse could climb up"
", but you lack practice.\n");
	return 0;
      } else {
	format("\nAs you leave one of the elephants starts following you.");
	objects [160 /* elephant */].objtype.virtual = 0;
	flags [ELEPHANTFOLLOW] = 1;
      }
    }
    break;
  case 99: /* One of the funny moves in the enchanted maze */
    switch(getroom(player))
    {
    case 31: 
      dest = delay > 9 ? 29 : 32;
      format("\nAs you move, you are startled by a number of green flashes!");
      break;
    case 32: dest = delay > 9 ? 33 : 27; break;
    case 33: dest = delay > 9 ? 34 : 31; break;
    case 34: dest = delay > 9 ? 29 : 35; break;
    case 35: dest = delay > 9 ? 33 : 38; break;
    default: fail();
    }
    break;
  }
  return dest;
}

extern void postmove(void)
{
  switch(getroom(yaccplayer))
  {
  case 22: /* Rusgreve's room */
    flags [RUSGREVE] |= 1;
    break;
  case 23: /* Prendergast's room */
    flags [PRENDERGAST] |= 1;
    break;
  case 47: /* Princess' room */
    flags [PRINCESS] |= 1;
    break;
  case 54: /* Lions' room */
    if(flags [MOUSECOUNTER] == 0) {
      format("As you enter the lions' den, they reveal that they are not onl"
"y ready for tummy tickles, and they gobble you up.\n");
      dead = TRUE;
    } else {
      format("\nThe lions don't notice the little mouse scampering across th"
"e floor.");
    }
    break;
  case 52: /* Elephants' room */
    if(flags [MOUSECOUNTER] != 0) flags [ELEPHANTS] = 1; else {
      if(flags [ELEPHANTS] == 1) {
	format("\nAs you try to enter the elephants' room, one of them collides wit"
"h you, and tramples you underfoot.\n");
	dead = TRUE;
      }
    }
    break;
  }
  if(flags [ELEPHANTFOLLOW] == 1) {
    detachfromchain(160 /* elephant */);
    addtochain(160,getroom(yaccplayer),& objects [getroom(yaccplayer)].inside);
  }
}

extern void postdescription(int player)
{
  if(flags [GRANDMASTER] == 1) {
    flags [GRANDMASTER] = 2;
    format("The Grandmaster says, 'Will you do me the honour of joining me i"
"n a game of noughts and crosses, young adventurer?'\n");
  }

  if(flags [RUSGREVE] == 1) {
    format("Rusgreve says, 'I am not the leaker.'\n");
    flags [RUSGREVE] = 2;
  }
  if(flags [RUSGREVE] == 3) {
    format("Rusgreve says, 'Prendergast would say I was the leaker.'\n");
    flags [RUSGREVE] = 4;
  }
  if(flags [RUSGREVE] == 5) {
    format("Rusgreve says, 'Prendergast, I don't know how you put me up to t"
"his silly game, but I'm certainly not going on with it!'\n");
    flags [RUSGREVE] = 6;
  }

  if(flags [PRENDERGAST] == 1) {
    format("Prendergast says, 'I am not the leaker.'\n");
    flags [PRENDERGAST] = 2;
  }
  if(flags [PRENDERGAST] == 3) {
    format("Prendergast says, 'Rusgreve would say I was the leaker.'\n");
    flags [PRENDERGAST] = 4;
  }

  if(flags [PRINCESS] == 1) {
    flags [PRINCESS] = 2;
    format("The Princess says, 'Excellent!  I knew someone would come to res"
"cue me, it's part of being a princess really.  Now, to make sure you are gen"
"uine, I will just ask you a little question:  Who is it that has been leakin"
"g information from the Bureau?'\n");
  }

  switch(getroom(player))
  {
  case 12: /* Tennis court */
    if(flags [TENNIS] == 0) {
      format("Suddenly two people enter the tennis courts.  'Ah, someone els"
"e.  Let's have a game of quadruples,' exclaims one in a public school accent"
".  The game begins...\n\n");
      if(quadruples()) {
	format("\n'Uuuh!' calls a linesman, which roughly translates to 'out'.\n'YO"
"U CANNOT BE SERIOUS!' yells one of the public schools, flinging down his rac"
"quet.  However the public school pair are experienced at this, and manage to"
" leave the court with all their rackets (one broken) and the trophies, which"
" they grabbed before anyone could stop them.\n\nThe umpire then comes up to "
"you, and says, 'I'm most dreadfully sorry about this, but all the trophies s"
"eem to have gone.  What can I give you?'\nHe casts his eyes around, and sees"
" something that looks like the Olympic torch.  He gives it to you, 'I'm sorr"
"y but this is all that is left!'\n\nFinally he too leaves the court.\n");
	detachfromchain(164);
	addtochain(164,yaccplayer,& objects [yaccplayer].inside);
      } else {
	format("\n'Thanks for the game old boy,' says one of the other players, as "
"they walk off with the two trophies, for the game's two winners.\n");
      }
      flags [TENNIS] = 1;
    }
    break;
  case 36: /* Climbable tree room */
    if(flags [MAGPIE] == 0) format("In the tree, a magpie chirps noisily.\n");
    break;
  case 44: /* Bronze door room */
    if(flags [B_DOOR] == 0) format("A heavy wooden door with a bronze lock b"
"locks progress to the south.\n");
    break;
  case 45: /* Silver door room */
    if(flags [S_DOOR] == 0) format("A heavy wooden door with a silver lock b"
"locks progress to the south.\n");
    break;
  case 46: /* Golden door room */
    if(flags [G_DOOR] == 0) format("A heavy wooden door with a golden lock b"
"locks progress to the south.\n");
    break;
  case 50: /* Bridge */
    if(flags [ELEPHANTFOLLOW] == 1) {
      format("The bridge holds up for a moment, and then collapses as a huge"
" elephant stamps onto it.\n");
      dead = TRUE;
    }
    break;
  case 52: /* Elephants' room */
    if(flags [ELEPHANTS] == 1) format("The elephants are jumping around in a"
" violent frenzy.\n");
    else format("The elephants watch you calmly.\n");
    break;
  }
}

extern bool dogreeting(int who)
{
  switch(who)
  {
  case 104: /* The Grandmaster */
    format("The Grandmaster says 'The compliments of the day to you, my youn"
"g friend.'");
    return TRUE;
  case 142: /* Rusgreve */
    format("Rusgreve says, 'Good morning to you Sir.'");
    return TRUE;
  case 143: /* Prendergast */
    format("Prendergast says, 'Mmmm.  Morning.' and then busies himself with"
" what he was doing without appearing to notice you properly.");
    return TRUE;
  case 156: /* Princess */
    format("The Princess says, 'Good morning.'");
  }

  return FALSE;
}

extern bool dofarewell(int who)
{
  return FALSE;
}

extern bool referred_to(int recipient)
{
  if(recipient == 156 /* princess */)
  {
    if(subject == 140 /* butler */) {
      format("The Princess says, 'Good.  I'll allow you to rescue me.'\n\nPr"
"endergast's voice suddenly comes into your mind, 'Stand by.  We're going to "
"get you out.'\n\nThe room suddenly swims about you, and you find yourself ba"
"ck in your office.  The Princess isn't there, of course; she is waking up in"
" the room where she was asleep.\n\nCongratulations, you've completed Napoleo"
"n with a score of 99.5%% (as with all games of this type there is an impossi"
"ble puzzle that stops you getting a full score).  Have a nice day, your prom"
"pt should be reappearing about now...\n\n");
      finished = TRUE;
    } else {
      format("The Princess says, 'I don't think so.'");
    }

    return TRUE;
  }

  return FALSE;
}

extern void doyes(int who)
{
  switch(who)
  {
  case 104: /* Grandmaster */
    if(flags [GRANDMASTER] == 2) {
      format("The Grandmaster says, 'Excellent!  My friend, we shall begin a"
"t once.  We will play best of three games.  Now some have said that being \""
"X\" gives an advantage and they can then beat the best.  I say let them play"
" against the best, and we shall see.  So you may start in the first game.'");
      switch(playnoughts()) {
      case 0:
	format("The Grandmaster looks a little bit surprised and irritated.  He bow"
"s slightly, and says gruffly, 'Thank you for the game.'");
	flags [GRANDMASTER] = 4;
	break;
      case 1:
	format("The Grandmaster smiles and says, 'You are a promising young player."
"  With a few more years practice you will be really quite good!'");
	flags [GRANDMASTER] = 3;
	break;
      case 2:
	format("The Grandmaster chuckles to himself, and says, 'I don't think you w"
"ere really playing very hard.  Do you want to try again?'");
	break;
      }
    } else format("The Grandmaster says, 'I didn't think I was offering a ga"
"me.  I don't play with any riff-raff, you know!'");
    break;
  }
}

extern void dono(int who)
{
  switch(who)
  {
  case 104: /* Grandmaster */
    format("The Grandmaster says, 'I'm so sorry, I was looking forward to th"
"e game.'");
    break;
  }
}

extern void examineobject(int examiner,int this)
{
  switch(examiner)
  {
  case 104: /* The Grandmaster */
    format("The Grandmaster says, 'You are still young, and a pursuit of kno"
"wledge is a fine thing - but you cannot expect to acquire all the secrets of"
" the Universe in a single hour.'");
    break;
  case 125: /* The piano teacher */
    format("Rather unsympathetically, the teacher says, 'If you put half as "
"much effort into the piano as you put into your wild daydreams you would be "
"playing in the orchestra by now.'");
    break;
  case 142: /* Rusgreve */
    format("Rusgreve says, 'I don't know anything about that, sir.'");
    break;
  case 143: /* Prendergast */
    format("Prendergast says, 'Intriguing.  Hmm... no, no, I don't know.'");
    break;
  case 156: /* Princess */
    format("The Princess says, 'You're supposed to be rescuing me, not invit"
"ing me to look at things you've collected up around this horrible place.'");
    break;
  }
}

extern void justput(int what,int destination,int *chain)
{
  switch(destination)
  {
  case 108: /* Piano */
    if(what == 123 /* Punch card */) {
      destroy(123); /* Remove the punch card */
      format("The piano starts playing itself - the resulting music is only "
"marred by a loud clunking sound as the card mechanism turns over.\n\nThe pia"
"no teacher says, 'So you did do your practice this week after all.  In that "
"case, I can give you this - your parents asked me to give it to you when you"
" had achieved enough application not to do anything silly with it.'\n\nShe g"
"ives you a strange looking silver key.\n\n'And remember,' continues the teac"
"her, 'if you go looking for princesses firstly your piano playing will get n"
"o better, and secondly your quest is likely to be stopped by someone you kno"
"w very well.'\n");
      detachfromchain(124);
      addtochain(124,yaccplayer,& objects [yaccplayer].inside); /* Give you the key */
    }
    break;
  case 161: case 162: /* Vending machine or its slot */
    if(what == 145 /* 10p coin */) {
      destroy(145);
      detachfromchain(157 /* dictating machine */);
      addtochain(157,yaccplayer,& objects [yaccplayer].inside);
      format("The vending machine gives you a nice flashy new dictating mach"
"ine.\n");
    } else {
      format("You find that you can't get that into the slot.\n");
      detachfromchain(what);
      addtochain(what,yaccplayer,& objects [yaccplayer].inside); 
    }
    break;
  }
}

extern void play(int what)
{
  switch(what)
  {
  case 108: /* Piano */
    format("The piano makes a rather nasty donging sound, but nothing else h"
"appens.\n\nThe piano teacher says, 'What was that?  Do you actually do the p"
"ractice I set you?'\n");
    break;
  default:
    if(objects [what].objtype.alive) {
      format("Rusgreve's voice suddenly intrudes on your mind: 'Oi!  No hank"
"y panky, or we'll court martial you for breaching good order and military di"
"scipline!'\n\nYou wisely desist from whatever it was that you were thinking "
"of doing.\n");
    } else {
      format("You begin playing with %s.  It takes you back to when you were"
" young.\n",quickname("the",what));
    }
  }
}

extern void playnandc(int who)
{
  if(ispresent(who,yaccplayer)) {
    if(objects [who].objtype.alive) {
      if(who == 104 /* Grandmaster */) {
	doyes(104);
      } else {
	format("I don't think %s will want to play.\n",objects [who].longname);
      }
    } else {
      format("%s doesn't seem able to play, somehow.\n",quickname("The",who));
    }
  } else {
    format("I can't see anyone like that here.");
  }
}

extern bool wantsit(int destination,int what)
{
  switch(destination)
  {
  case 143: /* Prendergast */
    if(what == 144 /* coffee */) {
      destroy(144);
      format("Prendergast takes the coffee, and says distractedly, 'Mmm.  Th"
"anks very much.  Errm, here's 10p for the coffee machine.'");
      detachfromchain(145);
      addtochain(145,yaccplayer,& objects [yaccplayer].inside);
      return TRUE;
    }
    break;
  case 140: /* Butler */
    if(what == 124 /* silver key */) {
      detachfromchain(124);
      addtochain(124,49,& objects [49].inside);
      detachfromchain(159 /* potion */);
      addtochain(159,yaccplayer,& objects [yaccplayer].inside);
      format("The butler says, 'That's a very kind tip, Sir.  Please have th"
"is little bottle as a thank you for your kindness.  Being a butler never mak"
"es much to put on one side for retirement...'");
      return TRUE;
    }
  }

  format("%s isn't wanted.",quickname("The",what));

  return FALSE;
}

extern void throw(int overwhat)
{
  bool changingroom = getroom(yaccplayer) == 24 && overwhat == 24 /* balcony */,dontdrop = FALSE;

  if(getroom(yaccplayer) == 14 && flags [WATERSPRITE] == 1 && 
     (overwhat == 163 /* sprite */ || overwhat == 0) && objectlist [0] == 164 /* torch */) {
    format("The water sprite is hit by the torch, and a huge cloud of steam "
"is produced.  When everything clears and you can see again, the torch and wa"
"ter sprite have both gone.  The pond is now empty of water and a hole leads "
"down.\n");
    destroy(163);
    destroy(164);
    dontdrop = TRUE;
    flags [WATERSPRITE] = 2;
  }

  if(changingroom) {
    detachfromchain(yaccplayer);
    addtochain(yaccplayer,55,& objects [55].inside);
  }

  if(! dontdrop) drop();

  if(changingroom) {
    detachfromchain(yaccplayer);
    addtochain(yaccplayer,24,& objects [24].inside);
  }
}

extern void jump(int whatover)
{
  switch(getroom(yaccplayer))
  {
  case 24: /* Balcony */
    if(whatover == 126 /* Balcony */ || whatover == 0) {
      format("You panic horribly a moment before you would have jumped.  The"
" shock causes you to partially awaken from your dream.  But instead of findi"
"ng yourself in bed, you find that...\n");
      detachfromchain(yaccplayer);
      addtochain(yaccplayer,1,& objects [1].inside);
      descr = TRUE;
      /* Person's objects are taken away */
      remove_persons_objects();
    } else {
      format("You jump around, and nearly go over the side in your excitemen"
"t!");
    }
    break;
  case 50: /* Bridge */
    if(whatover == 0) {
      format("You dive over the side of the bridge, and into the cold water."
"  The shock causes you to partially awaken from your dream.  But instead of "
"finding yourself in bed, you find that...\n");
      detachfromchain(yaccplayer);
      addtochain(yaccplayer,1,& objects [1].inside);
      descr = TRUE;
    } else {
      format("You jump around, and nearly go over the side in your excitemen"
"t!");
    }
    break;
  case 37: /* Up the tree */
    format("You jump out of the tree, and fall rather painfully onto the flo"
"or.");
    detachfromchain(yaccplayer);
    addtochain(yaccplayer,36,& objects [36].inside);
    descr = TRUE;
    break;
  default:
    format("You jump around for a bit, then you feel silly and stop.");
    break;
  }
}

extern void touch(int what)
{
  if(what == 120 /* plate */) {
    format("You get a small electric shock from the plate.  Just enough to j"
"olt you some way towards waking up.  For a moment the room swims about you, "
"then Prendergast's voice cuts into your mind, 'Ah, yes, let's see what of yo"
"ur kit we can salvage... oops... botheration, we can't get anything that was"
" in the lab now... let's see what's there...'");
    detachfromchain(yaccplayer);
    addtochain(yaccplayer,1,& objects [1].inside);
    descr = TRUE;
    /* Person's objects are taken away */
    remove_persons_objects();
    /* Objects are given to the person from the storeroom */
    while(! objects [objects [17].inside].objtype.virtual)
    {
      int obj = objects [17].inside;

      detachfromchain(obj);
      addtochain(obj,1,& objects [1].inside);
    }
  } else {
    if(objects [what].objtype.alive) {
      format("Rusgreve's voice suddenly intrudes on your mind: 'Oi!  No hank"
"y panky, or we'll court martial you for breaching good order and military di"
"scipline!'\n\nYou wisely desist from whatever it was that you were thinking "
"of doing.\n");
    } else {
      format("You touch %s, but nothing happens.",quickname("the",what));
    }
  }
}

extern void unlock(int what,int whatwith)
{
  if(what != 148 && what != 149 && what != 150) {
    format("You can't unlock that!");
    return;
  }
  if(whatwith != 124 && whatwith != 146 && whatwith != 147 && whatwith != 0) {
    format("You won't unlock anything with that!");
    return;
  }
  if(whatwith != 0) {
    if((what == 148 && whatwith != 147) || (what == 149 && whatwith != 124)
    || (what == 150 && whatwith != 146)) {
      format("The key doesn't fit.\n");
      return;
    }
  } else {
    if((what == 148 && ! ispresent(yaccplayer,147)) || (what == 149 && ! ispresent(yaccplayer,124))
    || (what == 150 && ! ispresent(yaccplayer,146))) {
      format("You don't seem to have the appropriate key.\n");
      return;
    }
  }
  format("The door glides silently up and out of sight.\n");
  switch(what)
  {
  case 148: flags [B_DOOR]++; destroy(148); break;
  case 149: flags [S_DOOR]++; destroy(149); break;
  case 150: flags [G_DOOR]++; destroy(150); break;
  default: fail();
  }
}

extern void record(int what,int whatwith)
{
  if(whatwith == 0) whatwith = 157 /* dictating machine */ ;
  if(whatwith != 157) {
    format("You can't record anything on that!");
    return;
  }

  if(! ispresent(yaccplayer,157)) {
    format("You don't seem to have access to one of those.");
    return;
  }

  if(what == 158 /* magpie */)
  {
    format("You start recording the magpie's squawks.  After a while you get"
" bored and start to replay them; the magpie, hearing a rival goes flapping a"
"way in search of it.  Finally you stop the tape and rejoice in the sudden si"
"lence.");
    flags [MAGPIE] = 1;
  } else {
    format("You record %s.",quickname("the",what));
  }
}

extern void drink(int what)
{
  switch(what)
  {
  case 144: /* coffee */
    format("You take a big swig of coffee.");
    break;
  case 159: /* potion */
    format("You drink some of the potion.  You immediately turn into a horri"
"ble smelly mouse!  Your possessions shrink with you, so you can still manage"
" to carry them (just).");
    flags [MOUSECOUNTER] = 10;
    break;
  default:
    format("You wisely refrain from trying to drink that!");
    break;
  }
}

extern void precommand(void)
{
  if(flags [MOUSECOUNTER] > 0) {
    if(--flags [MOUSECOUNTER] == 0) {
      format("You suddenly change back to human form.\n");
      if(getroom(yaccplayer) == 52 /* elephants room */) {
	format("During the transformation, one of the elephants collides with you, "
"squashing you almost without seeing you.\n");
	dead = TRUE;
      }
    }
  }
}

extern void do_wait(void)
{
  format("You wait...");
  switch(getroom(yaccplayer))
  {
  case 48: /* River bank */
    if(++flags [WAITCOUNT] == 2) {
      format("Suddenly one of the 'logs' opens its eyes.  You realise with p"
"anic that it isn't a log at all, but a crocodile.  However, the elephant mov"
"es towards the bank, extending its trunk.  'Another two feet, please,' it sa"
"ys, and the crocodile takes its trunk in capable jaws.  The elephant has sto"
"pped following you.\n");
      flags [ELEPHANTFOLLOW] = 0;
    }
    break;
  case 14: /* poolside */
    if(flags [WATERSPRITE] == 0) {
      format("Suddenly the water forms itself into a ghastly, semi-human for"
"m: a water sprite.  You recoil instinctively, avoiding being dragged under t"
"he water by its first attempt to grasp you, but it is rearing further out of"
" the water all the time...\n");
      detachfromchain(163);
      addtochain(163,14,& objects [14].inside);
      objects [163].objtype.virtual = 0;
      flags [WATERSPRITE] = 1;
    }
    break;
  }
}

extern void kiss(int what)
{
  if(what == 156 /* princess */) {
    format("The Princess slaps your face.  'I know that's what you're suppos"
"ed to do in fairy stories, but I already know I'm not in one of them because"
" you're hardly Prince Charming, are you?'\n");
  } else {
    if(objects [what].objtype.alive) {
      format("Rusgreve's voice suddenly intrudes on your mind: 'Oi!  No hank"
"y panky, or we'll court martial you for breaching good order and military di"
"scipline!'\n\nYou wisely desist from whatever it was that you were thinking "
"of doing.\n");
    } else {
      format("You feel a bit silly, but you kiss %s just the same.\n",quickname("the",what));
    }
  }
}

extern void search(int what)
{
  if(what == 136 /* Prendergast's bin */ && flags [BIN] == 0) {
    format("Among lots of other funny stuff, you find a bronze key.");
    flags [BIN] = 1;
    detachfromchain(147); /* bronze key */
    addtochain(147,yaccplayer,& objects [yaccplayer].inside);
  } else {
    format("You don't find anything.");
  }
}

extern void climb(int what)
{
  switch(what)
  {
  case 165: /* Tree, in the clearing */
    direction = UP;
    moveplayer();
    break;
  default:
    format("You can't climb that!");
    break;
  }
}
