/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"
#include "lang.h"

static int identify(char *command,char *teststring)
{
  int i;

  for(i = 1;*teststring != 0;i++)
  {
    if(strcmp_ci(command,teststring)) return i;
    teststring += strlen(teststring) + 1;
  }
  return 0;
}

/* strcmp_ci_t is a routine to compare two strings, allowing any character
   in the third string as a terminator.  */

static bool strcmp_ci_t(char *a,char *b,char *term)
{
  while(tolower(*a) == tolower(*b) || (strchr(term,*a) && strchr(term,*b)))
  {
    if(strchr(term,*a)) return TRUE;
    a++;
    b++;
  }
  return FALSE;
}

/* findword has the job of searching for a word and determining
   whether it is a noun or an adjective.  */

static int findword(char *word)
{
  int i;

  for(i = 0;objects [i].examine != (char *) 1;i++)
  {
    if(objects [i].shortname != 0) {
      char *lookingat = objects [i].shortname;

      do {
	if(strcmp_ci_t(lookingat,word,"_")) {
	  if(strchr(lookingat,'_')) return ADJECTIVE;
	  return NOUN;
	}
	lookingat = strchr(lookingat,'_') + 1;
      } while(lookingat != (char *) 1);
    }
  }
  return 0;
}

extern int yylex(void)
{
  char buffer [64];
  int word,wordtype,i;

  while(isspace(*yaccstring)) yaccstring++;
  if(*yaccstring == 0) return 0; /* End of command line */
  if(isalpha(*yaccstring)) {
    strncpy(buffer,yaccstring,63);
    buffer [63] = 0;
    for(i = 0;isalpha(buffer [i]);i++);
    buffer [i] = 0;
    yaccstring += strlen(buffer);
    word = identify(buffer,"north\0south\0west\0east\0northwest\0northeast\0"
"southwest\0southeast\0up\0down\0");
    if(word == 0) word = identify(buffer,"n\0s\0w\0e\0nw\0ne\0sw\0se\0u\0d\0"
"inventory\0load\0look\0quit\0save\0score\0go\0examine\0all\0everything\0in\0"
"into\0on\0off\0to\0get\0drop\0take\0put\0inv\0restore\0onto\0under\0undernea"
"th\0at\0below\0the\0and\0read\0twirl\0turn\0say\0ask\0about\0yes\0no\0hello\0"
"hi\0goodbye\0bye\0hack\0play\0with\0noughts\0crosses\0give\0throw\0over\0jump"
"\0touch\0unlock\0open\0brief\0verbose\0normal\0record\0drink\0wait\0kiss\0"
"search\0climb\0");
    switch(word)
    {
    case 0:
      wordtype = findword(buffer);
      switch(wordtype)
      {
      case NOUN:
	strcpy(yylval.string,buffer);
	return NOUN;
      case ADJECTIVE:
	strcpy(yylval.string,buffer);
	return ADJECTIVE;
      case 0:
	format("I don't understand '%s'.",buffer);
	return 0;
      default:
	fail();
      }
    case 1: return NORTH;
    case 2: return SOUTH;
    case 3: return WEST;
    case 4: return EAST;
    case 5: return NORTHWEST;
    case 6: return NORTHEAST;
    case 7: return SOUTHWEST;
    case 8: return SOUTHEAST;
    case 9: return UP;
    case 10: return DOWN;
    case 11: return INVENTORY;
    case 12: return LOAD;
    case 13: return LOOK;
    case 14: return QUIT;
    case 15: return SAVE;
    case 16: return SCORE;
    case 17: return GO;
    case 18: return EXAMINE;
    case 19: return ALL;
    case 20: return EVERYTHING;
    case 21: return IN;
    case 22: return INTO;
    case 23: return ON;
    case 24: return OFF;
    case 25: return TO;
    case 26: return GET;
    case 27: return DROP;
    case 28: return TAKE;
    case 29: return PUT;
    case 30: return INV;
    case 31: return RESTORE;
    case 32: return ONTO;
    case 33: return UNDER;
    case 34: return UNDERNEATH;
    case 35: return AT;
    case 36: return BELOW;
    case 37: return THE;
    case 38: return AND;
    case 39: return READ;
    case 40: return TWIRL;
    case 41: return TURN;
    case 42: return SAY;
    case 43: return ASK;
    case 44: return ABOUT;
    case 45: return YES;
    case 46: return NO;
    case 47: return HELLO;
    case 48: return HI;
    case 49: return GOODBYE;
    case 50: return BYE;
    case 51: return HACK;
    case 52: return PLAY;
    case 53: return WITH;
    case 54: return NOUGHTS;
    case 55: return CROSSES;
    case 56: return GIVE;
    case 57: return THROW;
    case 58: return OVER;
    case 59: return JUMP;
    case 60: return TOUCH;
    case 61: return UNLOCK;
    case 62: return OPEN;
    case 63: return BRIEF;
    case 64: return VERBOSE;
    case 65: return NORMAL;
    case 66: return RECORD;
    case 67: return DRINK;
    case 68: return WAIT;
    case 69: return KISS;
    case 70: return SEARCH;
    case 71: return CLIMB;

    default: fail();
    }
  } else {
    switch(*(yaccstring++))
    {
    case '\"': case '\'': return QUOTE;
    case '.': case '!': return FULLSTOP;
    case ',': return COMMA;
    case ';': return SEMICOLON;
    default:
      format("What do you mean '%c'?",*(yaccstring - 1));
      return 0;
    }
  }
  return 0;
}
