/* Subroutines for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 27-Sep-94     RMS     Fixed bugs in WEIGHR, JIGSUP, SCORE. */
/*                       Added GRANITE WALL to GHERE. */
/* 30-Jan-94     RMS     Fixed bugs from MS DOS port. */
/* 30-Jun-92     RMS     Changed file names to lower case. */
/* 29-Jun-92     RMS     Removed extraneous declaration in RMDESC. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* RSPEAK-- Output random message routine */

/* Called by-- */

/*       CALL RSPEAK(MSGNUM) */

/* Subroutine */ int rspeak_(integer *n)
{


    rspsb2_(n, &c__0, &c__0);
    return 0;

} /* rspeak_ */


/* RSPSUB-- Output random message with substitutable argument */

/* Called by-- */

/*       CALL RSPSUB(MSGNUM,SUBNUM) */

/* Subroutine */ int rspsub_(integer *n, integer *s1)
{
    rspsb2_(n, s1, &c__0);
    return 0;

} /* rspsub_ */

/* RSPSB2-- Output random message with substitutable arguments */

/* Called by-- */

/*       CALL RSPSB2(MSGNUM,S1,S2) */

/* Subroutine */ int rspsb2_(integer *a, integer *b, integer *c__)
{
    /* System generated locals */
    integer i__1, i__2, ix;

    /* Local variables */
    char b1[76], b2[76];
    integer x, y, z__, oldrec;
    integer i__;
    integer newrec, j;

/* Convert all arguments from dictionary numbers (if positive) */
/* to absolute record numbers. */

    x = *a;
/* set up work variables. */
    y = *b;
    z__ = *c__;
    if (x > 0) {
        x = rmsg_1.rtext[x - 1];
    }
/* if >0, look up in rtex */
    if (y > 0) {
        y = rmsg_1.rtext[y - 1];
    }
    if (z__ > 0) {
        z__ = rmsg_1.rtext[z__ - 1];
    }
    x = abs(x);
/* take abs value. */
    y = abs(y);
    z__ = abs(z__);
    if (x == 0) {
        return 0;
    }
/* anything to do? */
    play_1.telflg = TRUE_;
/* said something. */
    printdb(x-1, y-1, z__-1, TRUE_);
    return 0;    
} /* rspsb2_ */



/* OBJACT-- Apply objects from parse vector */

/* Declarations */

logical objact_(integer *x)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


    ret_val = TRUE_;
/* assume wins. */
    if (prsvec_1.prsi == 0) {
        goto L100;
    }
/* ind object? */
    if (oappli_(&objcts_1.oactio[prsvec_1.prsi - 1], &c__0)) {
        return ret_val;
    }

/* yes, let it handle. */
L100:
    if (prsvec_1.prso == 0) {
        goto L200;
    }
/* dir object? */
    if (oappli_(&objcts_1.oactio[prsvec_1.prso - 1], &c__0)) {
        return ret_val;
    }

/* yes, let it handle. */
L200:
    ret_val = FALSE_;
/* loses. */
    return ret_val;

} /* objact_ */



/* BUG-- Report fatal system error */

/* Declarations */

/* Subroutine */ int bug_(integer *a, integer *b)
{
    /* Local variables */

    weeprintf("Program error %d, parameter = %d\n", *a, *b);

/* gonzo */
    if (misc_1.dbgflg != 0) {
        return 0;
    }
    s_copy(input_1.subbuf, "CRASH.DAT", 76L, 9L);
/* set up crash save name */
    input_1.sublnt = nblen_(input_1.subbuf, 76L);
    savegm_();
/* do final save. */
    glk_put_string("Game state saved in \"CRASH.DAT\".\n");
    s_stop(" ", 1L);

    return 0;
} /* bug_ */



/* NEWSTA-- Set new status for object */

/* Called by-- */

/*       CALL NEWSTA(OBJECT,STRING,NEWROOM,NEWCON,NEWADV) */

/* Subroutine */ int newsta_(integer *o, integer *r__, integer *rm, integer *
        cn, integer *ad)
{
    /* Local variables */


    rspeak_(r__);
    objcts_1.oroom[*o - 1] = *rm;
    objcts_1.ocan[*o - 1] = *cn;
    objcts_1.oadv[*o - 1] = *ad;
    return 0;

} /* newsta_ */



/* QHERE-- Test for object in room */

/* Declarations */

logical qhere_(integer *obj, integer *rm)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = TRUE_;
    if (objcts_1.oroom[*obj - 1] == *rm) {
        return ret_val;
    }
/* in room? */
    i__1 = oroom2_1.r2lnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* no, sch room2. */
        if (oroom2_1.o2[i__ - 1] == *obj && oroom2_1.r2[i__ - 1] == *rm) {
            return ret_val;
        }
/* L100: */
    }
    ret_val = FALSE_;
/* not present. */
    return ret_val;

} /* qhere_ */



/* QEMPTY-- Test for object empty */

/* Declarations */

logical qempty_(integer *obj)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = FALSE_;
/* assume lose. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.ocan[i__ - 1] == *obj) {
            return ret_val;
        }
/* inside target? */
/* L100: */
    }
    ret_val = TRUE_;
    return ret_val;

} /* qempty_ */



/* JIGSUP- You are dead */

/* Declarations */

/* Subroutine */ int jigsup_(integer *desc)
{
    /* Initialized data */

    static integer rlist[8] = { 6,36,33,32,4,32,6,5 };

    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical f;
    integer i__, j, nonofl;


/* Functions and data */


    rspeak_(desc);
/* describe sad state. */
    prsvec_1.prscon = 0;
/* stop parser. */
    if (misc_1.dbgflg != 0) {
        return 0;
    }
/* if dbg, exit. */
    advs_1.avehic[play_1.winner - 1] = 0;
/* get rid of vehicle. */
    if (play_1.winner == 1) {
        goto L10;
    }
/* himself? */
    rspsub_(&c__432, &objcts_1.odesc2[advs_1.aobj[play_1.winner - 1] - 1]);
/* no, say who died. */
    newsta_(&advs_1.aobj[play_1.winner - 1], &c__0, &c__0, &c__0, &c__0);
/* send object to hyper s */
    advs_1.aroom[play_1.winner - 1] = 0;
/* send actor to hyper sp */
    return 0;

L10:
    scrupd_(&c_n10);
/* charge 10 points. */
    if (findex_1.endgmf) {
        goto L900;
    }
/* no recovery in end gam */
    if (play_1.deaths >= 2) {
        goto L1000;
    }
/* dead twice? kick him o */
    ++play_1.deaths;
/* record deaths. */
    findex_1.deadf = TRUE_;
/* flag dead player. */
    i__ = 8;
/* normal message. */
    if (findex_1.lldf) {
        i__ = 1074;
    }
/* ghosts exorcised? */
    rspeak_(&i__);
/* tell him bad news. */
    advs_1.aactio[0] = 1;

/* turn on dead player fu */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* turn off fighting. */
        if (qhere_(&j, &play_1.here)) {
            objcts_1.oflag2[j - 1] = objcts_1.oflag2[j - 1] & -257;
        }
/* L50: */
    }

    f = moveto_(&c__93, &play_1.winner);
/* reposition him. */
    findex_1.egyptf = TRUE_;
/* restore coffin. */
    if (objcts_1.oadv[32] == play_1.winner) {
        newsta_(&c__33, &c__0, &c__44, &c__0, &c__0);
    }
    objcts_1.oflag2[65] = objcts_1.oflag2[65] & -5;
/* restore door. */
    objcts_1.oflag1[141] = (objcts_1.oflag1[141] | 32768) & -513;
    newsta_(&c__15, &c__0, &c__8, &c__0, &c__0);
/* lamp to living room, */
    objcts_1.oflag1[14] = objcts_1.oflag1[14] | 32768;
/* visible */
    i__1 = cevent_1.clnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* disable cevnts if need */
        if (cevent_1.ccncel[i__ - 1]) {
            cevent_1.cflag[i__ - 1] = FALSE_;
        }
/* L100: */
    }
/* JIGSUP, PAGE 2 */

/* Now redistribute his valuables and other belongings. */

/* The lamp has been placed in the living room. */
/* The first 8 non-valuables are placed in locations around the house. */
/* His valuables are placed starting at Troll Room. */
/* Remaining non-valuables are after that. */

    i__ = 0;
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* loop thru objects. */
        if (objcts_1.oadv[j - 1] != play_1.winner || objcts_1.otval[j - 1] != 
                0) {
            goto L200;
        }
/* get his non-val objs. */
        ++i__;
        if (i__ > 8) {
            goto L400;
        }
/* move to random locatio */
        newsta_(&j, &c__0, &rlist[i__ - 1], &c__0, &c__0);
L200:
        ;
    }

L400:
    i__ = 10;
/* now move valuables. */
    nonofl = 6160;
/* dont move here. */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
        if (objcts_1.oadv[j - 1] != play_1.winner || objcts_1.otval[j - 1] == 
                0) {
            goto L300;
        }
/* on adv and valuable? */
L250:
        ++i__;
/* find next room. */
        if ((rooms_1.rflag[i__ - 1] & nonofl) != 0) {
            goto L250;
        }
/* skip if nono. */
        newsta_(&j, &c__0, &i__, &c__0, &c__0);
/* yes, move. */
L300:
        ;
    }

    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* now get rid of remaind */
        if (objcts_1.oadv[j - 1] != play_1.winner) {
            goto L500;
        }
L450:
        ++i__;
/* find next room. */
        if ((rooms_1.rflag[i__ - 1] & nonofl) != 0) {
            goto L450;
        }
/* skip if nono. */
        newsta_(&j, &c__0, &i__, &c__0, &c__0);
L500:
        ;
    }
    return 0;

/* Cant or wont continue, clean up and exit. */

L900:
    rspeak_(&c__625);
/* in endgame, lose. */
    goto L1100;

L1000:
    rspeak_(&c__7);
/* involuntary exit. */
L1100:
    score_(&c_false);
/* tell score. */
    s_stop(" ", 1L);

    return 0;
} /* jigsup_ */



/* OACTOR-       Get actor associated with object */

/* Declarations */

integer oactor_(integer *obj)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */


    i__1 = advs_1.alnt;
    for (ret_val = 1; ret_val <= i__1; ++ret_val) {
/* loop thru actors. */
        if (advs_1.aobj[ret_val - 1] == *obj) {
            return ret_val;
        }
/* found it? */
/* L100: */
    }
    bug_(&c__40, obj);
/* no, die. */
    return ret_val;

} /* oactor_ */



/* PROB-         Compute probability */

/* Declarations */

logical prob_(integer *g, integer *b)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer i__;


    i__ = *g;
/* assume good luck. */
    if (findex_1.badlkf) {
        i__ = *b;
    }
/* if bad, too bad. */
    ret_val = rnd_(&c__100) < i__;
/* compute. */
    return ret_val;

} /* prob_ */



/* RMDESC-- Print room description */

/* RMDESC prints a description of the current room. */
/* It is also the processor for verbs 'LOOK' and 'EXAMINE' */
/* when there is no direct object. */

logical rmdesc_(integer *full)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer ra;
    integer i__;


/* FULL= 0/1/2/3=        full/obj/room/full but no applicable */

/* Declarations */


    ret_val = TRUE_;
/* assume wins. */
    ra = rooms_1.ractio[play_1.here - 1];
/* get room action. */
    if (prsvec_1.prso < 1024) {
        goto L50;
    }
/* if direction, */
    screen_1.fromdr = prsvec_1.prso;
/* save and */
    prsvec_1.prso = 0;
/* clear. */
L50:
    if (*full == 1) {
        goto L600;
    }
/* objects only? */
    if (play_1.here == advs_1.aroom[0]) {
        goto L100;
    }
/* player just move? */
    rspeak_(&c__2);
/* no, just say done. */
    prsvec_1.prsa = 6;
/* set up walk in action. */
    return ret_val;

L100:
    if (lit_(&play_1.here)) {
        goto L300;
    }
/* lit? */
    rspeak_(&c__430);
/* warn of grue. */
    ret_val = FALSE_;
    return ret_val;

L300:
    i__ = rooms_1.rdesc2 - play_1.here;
/* assume short desc. */
    if (*full == 0 && (findex_1.superf || ((rooms_1.rflag[play_1.here - 1] & 
            32768) != 0 && (findex_1.brieff || prob_(&c__80, &c__80))))) {
        goto L400;
    }
    i__ = rooms_1.rdesc1[play_1.here - 1];
/* use long. */
    if (i__ != 0 || ra == 0) {
        goto L400;
    }
/* if got desc, skip. */
    prsvec_1.prsa = 119;
/* pretend look around. */
    prsvec_1.prso = 0;
/* no object referenced. */
    rappli_(&ra);
/* let room handle. */
    prsvec_1.prsa = 8;
/* nop parser. */
    goto L500;

L400:
    rspeak_(&i__);
/* output description. */
L500:
    if (advs_1.avehic[play_1.winner - 1] != 0) {
        rspsub_(&c__431, &objcts_1.odesc2[advs_1.avehic[play_1.winner - 1] - 
                1]);
    }
    rooms_1.rflag[play_1.here - 1] = rooms_1.rflag[play_1.here - 1] | 32768;

/* indicate room seen. */
L600:
    if (lit_(&play_1.here)) {
        goto L700;
    }
/* if lit, do objects */
    rspeak_(&c__1036);
/* can't see anything */
    return ret_val;

L700:
    if (*full != 2) {
        princr_(full, &play_1.here);
    }
/* print room contents */
    if (*full != 0 || ra == 0) {
        return ret_val;
    }
/* anything more? */
    prsvec_1.prsa = 6;
/* give him a surpise. */
    rappli_(&ra);
/* let room handle */
    prsvec_1.prsa = 8;
    return ret_val;

} /* rmdesc_ */



/* PRINCR- Print contents of room */

/* Declarations */

/* Subroutine */ int princr_(integer *full, integer *rm)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer j, i__, k;


    j = 329;
/* assume superbrief form */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop on objects */
        if (! qhere_(&i__, rm) || (objcts_1.oflag1[i__ - 1] & 32768) == 0 || (
                (objcts_1.oflag1[i__ - 1] & 512) != 0 && *full != 1) || i__ ==
                 advs_1.avehic[play_1.winner - 1]) {
            goto L500;
        }
        if (*full == 0 && (findex_1.superf || (findex_1.brieff && (
                rooms_1.rflag[play_1.here - 1] & 32768) != 0))) {
            goto L200;
        }

/* Do long description of object. */

        k = objcts_1.odesco[i__ - 1];
/* get untouched. */
        if (k == 0 || (objcts_1.oflag2[i__ - 1] & 4) != 0) {
            k = objcts_1.odesc1[i__ - 1];
        }
        if (k == 0 && *full == 1) {
            rspsub_(&c__936, &objcts_1.odesc2[i__ - 1]);
        }
        rspeak_(&k);
/* describe. */
        goto L500;

/* Do short description of object. */

L200:
        rspsub_(&j, &objcts_1.odesc2[i__ - 1]);
/* you can see it. */
        j = 502;

L500:
        ;
    }

/* Now loop to print contents of objects in room. */

    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop on objects. */
        if (! qhere_(&i__, rm) || (objcts_1.oflag1[i__ - 1] & 32768) == 0 || (
                (objcts_1.oflag1[i__ - 1] & 512) != 0 && *full != 1)) {
            goto L1000;
        }
        if ((objcts_1.oflag2[i__ - 1] & 1024) != 0) {
            i__2 = oactor_(&i__);
            invent_(&i__2);
        }
        if (((objcts_1.oflag1[i__ - 1] & 2048) == 0 && (objcts_1.oflag2[i__ - 
                1] & 8) == 0) || qempty_(&i__)) {
            goto L1000;
        }

/* Object is not empty and is open or transparent. */

        if (i__ != 9) {
            goto L600;
        }
/* trophy case? */
        if (! (findex_1.brieff || findex_1.superf) || *full == 1) {
            princo_(&i__, &c__1053, &c_false);
        }
/* print contents. */
        goto L1000;
L600:
        princo_(&i__, &c__573, &c_true);
/* print contents */
L1000:
        ;
    }
    return 0;

} /* princr_ */



/* INVENT- Print contents of adventurer */

/* Declarations */

/* Subroutine */ int invent_(integer *adv)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__, j;


    i__ = 575;
/* first line. */
    if (*adv != 1) {
        i__ = 576;
    }
/* if not me. */
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* loop */
        if (objcts_1.oadv[j - 1] != *adv || (objcts_1.oflag1[j - 1] & 32768) 
                == 0) {
            goto L10;
        }
        rspsub_(&i__, &objcts_1.odesc2[advs_1.aobj[*adv - 1] - 1]);
        i__ = 0;
        rspsub_(&c__502, &objcts_1.odesc2[j - 1]);
L10:
        ;
    }

    if (i__ == 0) {
        goto L25;
    }
/* any objects? */
    if (*adv == 1) {
        rspeak_(&c__578);
    }
/* no, tell him. */
    return 0;

L25:
    i__1 = objcts_1.olnt;
    for (j = 1; j <= i__1; ++j) {
/* loop. */
        if (objcts_1.oadv[j - 1] != *adv || (objcts_1.oflag1[j - 1] & 32768) 
                == 0 || ((objcts_1.oflag1[j - 1] & 2048) == 0 && (
                objcts_1.oflag2[j - 1] & 8) == 0)) {
            goto L100;
        }
        if (! qempty_(&j)) {
            princo_(&j, &c__573, &c_true);
        }
/* if not empty, lis */
L100:
        ;
    }
    return 0;

} /* invent_ */



/* PRINCO-       Print contents of object */

/* Declarations */

/* Subroutine */ int princo_(integer *obj, integer *desc, logical *ldescf)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    logical moref;
    integer also, i__;
    integer j;


/* Functions and data */


    moref = FALSE_;
/* no additional printout */
    also = 0;
/* no untouched descripti */
    if (findex_1.superf || ! (*ldescf)) {
        goto L2000;
    }
/* skip long descriptions */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop thru objects. */
        if (! ((objcts_1.oflag1[i__ - 1] & 32768) != 0 && objcts_1.ocan[i__ - 
                1] == *obj && i__ != advs_1.aobj[play_1.winner - 1])) {
            goto L1000;
        }
/* inside target? */
        if (objcts_1.odesco[i__ - 1] == 0 || (objcts_1.oflag2[i__ - 1] & 4) !=
                 0) {
            goto L700;
        }
        rspeak_(&objcts_1.odesco[i__ - 1]);
/* print untouched descr. */
        also = 1;
/* flag. */
        if (! ((objcts_1.oflag1[i__ - 1] & 2048) != 0 || (objcts_1.oflag2[i__ 
                - 1] & 8) != 0) || qempty_(&i__)) {
            goto L1000;
        }
        rspsub_(&c__573, &objcts_1.odesc2[i__ - 1]);
/* object, which contains */
        i__2 = objcts_1.olnt;
        for (j = 1; j <= i__2; ++j) {
/* loop thru objects. */
            if ((objcts_1.oflag1[j - 1] & 32768) != 0 && objcts_1.ocan[j - 1] 
                    == i__ && j != advs_1.aobj[play_1.winner - 1]) {
                rspsub_(&c__502, &objcts_1.odesc2[j - 1]);
            }
/* L500: */
        }
        goto L1000;
L700:
        moref = TRUE_;
L1000:
        ;
    }
    if (! moref) {
        return 0;
    }

/* more to do? */
L2000:
    i__1 = *desc + also;
    rspsub_(&i__1, &objcts_1.odesc2[*obj - 1]);
/* print header. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop thru objects. */
        if (! ((objcts_1.oflag1[i__ - 1] & 32768) != 0 && objcts_1.ocan[i__ - 
                1] == *obj && i__ != advs_1.aobj[play_1.winner - 1])) {
            goto L3000;
        }
/* inside target? */
        if (also != 0 && objcts_1.odesco[i__ - 1] != 0 && (objcts_1.oflag2[
                i__ - 1] & 4) == 0) {
            goto L3000;
        }
        if (! ((objcts_1.oflag1[i__ - 1] & 2048) != 0 || (objcts_1.oflag2[i__ 
                - 1] & 8) != 0) || qempty_(&i__)) {
            goto L2700;
        }
        rspsub_(&c__1050, &objcts_1.odesc2[i__ - 1]);
/* object, which contains */
        i__2 = objcts_1.olnt;
        for (j = 1; j <= i__2; ++j) {
/* loop thru objects. */
            if ((objcts_1.oflag1[j - 1] & 32768) != 0 && objcts_1.ocan[j - 1] 
                    == i__ && j != advs_1.aobj[play_1.winner - 1]) {
                rspsub_(&c__1051, &objcts_1.odesc2[j - 1]);
            }
/* L2500: */
        }
        goto L3000;
L2700:
        rspsub_(&c__502, &objcts_1.odesc2[i__ - 1]);
/* object, nothing inside */
L3000:
        ;
    }
    return 0;

} /* princo_ */



/* MOVETO- Move player to new room */

/* Declarations */

logical moveto_(integer *nr, integer *who)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer j;
    integer bits;
    logical lhr, lnr, nlv;


    ret_val = FALSE_;
/* assume fails. */
    lhr = (rooms_1.rflag[play_1.here - 1] & 8192) != 0;
/* land  here flag. */
    lnr = (rooms_1.rflag[*nr - 1] & 8192) != 0;
/* land there flag. */
    j = advs_1.avehic[*who - 1];

/* his vehicle */
    if (j != 0) {
        goto L100;
    }
/* in vehicle? */
    if (lnr) {
        goto L500;
    }
/* no, going to land? */
    rspeak_(&c__427);
/* can't go without vehic */
    return ret_val;

L100:
    bits = 0;
/* assume nowhere. */
    if (j == 90) {
        bits = 4096;
    }
/* in boat? */
    if (j == 98) {
        bits = 2048;
    }
/* in balloon? */
    if (j == 137) {
        bits = 128;
    }
/* in bucket? */
    nlv = (rooms_1.rflag[*nr - 1] & bits) == 0;
/* got wrong vehicle flag */
    if ((! lnr && nlv) || (lnr && lhr && nlv && bits != 8192)) {
        goto L800;
    }

/* got wrong vehicle? */
L500:
    ret_val = TRUE_;
/* move should succeed. */
    if ((rooms_1.rflag[*nr - 1] & 256) == 0) {
        goto L600;
    }
/* room munged? */
    rspeak_(&rooms_1.rdesc1[*nr - 1]);
/* yes, tell how. */
    return ret_val;

L600:
    if (*who != 1) {
        newsta_(&advs_1.aobj[*who - 1], &c__0, nr, &c__0, &c__0);
    }
    if (j != 0) {
        newsta_(&j, &c__0, nr, &c__0, &c__0);
    }
    play_1.here = *nr;
    advs_1.aroom[*who - 1] = play_1.here;
    scrupd_(&rooms_1.rval[*nr - 1]);
/* score room */
    rooms_1.rval[*nr - 1] = 0;
    return ret_val;

L800:
    rspsub_(&c__428, &objcts_1.odesc2[j - 1]);
/* wrong vehicle. */
    return ret_val;

} /* moveto_ */



/* SCORE-- Print out current score */

/* Declarations */

/* Subroutine */ int score_(logical *flg)
{
    /* Initialized data */

    static integer rank[10] = { 20,19,18,16,12,8,4,2,1,0 };
    static integer erank[5] = { 20,15,10,5,0 };

    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer as, i__;

/* Functions and data */

    as = advs_1.ascore[play_1.winner - 1];
    if (findex_1.endgmf) {
        goto L60;
    }
/* endgame? */
    if (*flg) {
        glk_put_string("Your score would be ");
    }
    if (! (*flg)) {
        glk_put_string("Your score is ");
    }
    if (play_1.moves != 1) {
        weeprintf("%d [total of %d points], in %d moves.\n",
          as, play_1.mxscor, play_1.moves);
    }
    if (play_1.moves == 1) {
        weeprintf("%d [total of %d points], in %d move.\n",
          as, play_1.mxscor, play_1.moves);
    }
    if (as < 0) {
        goto L50;
    }
/* negative score? */
    for (i__ = 1; i__ <= 10; ++i__) {
/* find rank. */
        if (as * 20 / play_1.mxscor >= rank[i__ - 1]) {
            goto L20;
        }
/* L10: */
    }
    i__ = 10;
/* beginner. */
L20:
    i__1 = i__ + 484;
    rspeak_(&i__1);
/* print rank. */
    return 0;

L50:
    rspeak_(&c__886);
/* negative score. */
    return 0;

L60:
    if (*flg) {
        glk_put_string("Your score in the endgame would be ");
    }
    if (! (*flg)) {
        glk_put_string("Your score in the endgame is ");
    }
    weeprintf("%d [total of %d points], in %d moves.\n",
      play_1.egscor, play_1.egmxsc, play_1.moves);
    for (i__ = 1; i__ <= 5; ++i__) {
        if (play_1.egscor * 20 / play_1.egmxsc >= erank[i__ - 1]) {
            goto L80;
        }
/* L70: */
    }
    i__ = 5;
/* beginner. */
L80:
    i__1 = i__ + 786;
    rspeak_(&i__1);
    return 0;


} /* score_ */



/* SCRUPD- Update winner's score */

/* Declarations */

/* Subroutine */ int scrupd_(integer *n)
{
    /* Local variables */


    if (findex_1.endgmf) {
        goto L100;
    }
/* endgame? */
    advs_1.ascore[play_1.winner - 1] += *n;
/* update score */
    play_1.rwscor += *n;
/* update raw score */
    if (advs_1.ascore[play_1.winner - 1] < play_1.mxscor - min(1,
            play_1.deaths) * 10) {
        return 0;
    }
    cevent_1.cflag[14] = TRUE_;
/* turn on end game */
    cevent_1.ctick[14] = 15;
    return 0;

L100:
    play_1.egscor += *n;
/* update eg score. */
    return 0;

} /* scrupd_ */



/* FINDXT- Find exit from room */

/* Declarations */

logical findxt_(integer *dir, integer *rm)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer xi, i__;


    ret_val = TRUE_;
/* assume wins. */
    xi = rooms_1.rexit[*rm - 1];
/* find first entry. */
    if (xi == 0) {
        goto L1000;
    }

/* no exits? */
L100:
    i__ = exits_1.travel[xi - 1];
/* get entry. */
    curxt_1.xroom1 = i__ & 255;
/* isolate room. */
    curxt_1.xtype = ((i__ & -32769) / 256 & 3) + 1;
    switch (curxt_1.xtype) {
        case 1:  goto L110;
        case 2:  goto L120;
        case 3:  goto L130;
        case 4:  goto L130;
    }
/* branch on entry. */
    bug_(&c__10, &curxt_1.xtype);

L130:
    curxt_1.xobj = exits_1.travel[xi + 1] & 255;
/* door/cexit- get obj/fl */
    curxt_1.xactio = exits_1.travel[xi + 1] / 256;
L120:
    curxt_1.xstrng = exits_1.travel[xi];
/* door/cexit/nexit - str */
L110:
    xi += curxt_1.xelnt[curxt_1.xtype - 1];
/* advance to next entry. */
    if ((i__ & 31744) == *dir) {
        return ret_val;
    }
/* match? */
    if ((i__ & 32768) == 0) {
        goto L100;
    }
/* last entry? */
L1000:
    ret_val = FALSE_;
/* yes, lose. */
    return ret_val;

} /* findxt_ */



/* FWIM- Find what I mean */

/* Declarations */

integer fwim_(integer *f1, integer *f2, integer *rm, integer *con, integer *
        adv, logical *nocare)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    integer i__, j;


    ret_val = 0;
/* assume nothing. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop */
        if ((*rm == 0 || ! qhere_(&i__, rm)) && (*adv == 0 || objcts_1.oadv[
                i__ - 1] != *adv) && (*con == 0 || objcts_1.ocan[i__ - 1] != *
                con)) {
            goto L1000;
        }

/* Object is on list... is it a match? */

        if ((objcts_1.oflag1[i__ - 1] & 32768) == 0) {
            goto L1000;
        }
        if ((! (*nocare) && (objcts_1.oflag1[i__ - 1] & 8192) == 0) || ((
                objcts_1.oflag1[i__ - 1] & *f1) == 0 && (objcts_1.oflag2[i__ 
                - 1] & *f2) == 0)) {
            goto L500;
        }
        if (ret_val == 0) {
            goto L400;
        }
/* already got something? */
        ret_val = -ret_val;
/* yes, ambiguous. */
        return ret_val;

L400:
        ret_val = i__;

/* Does object contain a match? */

/* note match. */
L500:
        if ((objcts_1.oflag2[i__ - 1] & 8) == 0) {
            goto L1000;
        }
/* closed? */
        i__2 = objcts_1.olnt;
        for (j = 1; j <= i__2; ++j) {
/* no, search contents. */
            if (objcts_1.ocan[j - 1] != i__ || (objcts_1.oflag1[j - 1] & 
                    32768) == 0 || ((objcts_1.oflag1[j - 1] & *f1) == 0 && (
                    objcts_1.oflag2[j - 1] & *f2) == 0)) {
                goto L700;
            }
            if (ret_val == 0) {
                goto L600;
            }
            ret_val = -ret_val;
            return ret_val;

L600:
            ret_val = j;
L700:
            ;
        }
L1000:
        ;
    }
    return ret_val;

} /* fwim_ */



/* ORPHAN- Set up orphans for parser */

/* Declarations */

/* Subroutine */ int orphan_(integer *or1, integer *or2, integer *or3, 
        integer *or4, integer *or5, char *or6, integer *or7, integer *or8, 
        ftnlen or6_len)
{
    /* Local variables */


    prssta_1.oflag = *or1;
    prssta_1.oact = *or2;
    prssta_1.oprep1 = *or3;
    prssta_1.oobj1 = *or4;
    prssta_1.oprep = *or5;
    s_copy(prssta_1.oname, or6, 8L, or6_len);
    prssta_1.oprep2 = *or7;
    prssta_1.oobj2 = *or8;
    return 0;

} /* orphan_ */



/* YESNO- Obtain yes/no answer */

/* Called by- */

/*       YES-IS-TRUE=YESNO(QUESTION,YES-STRING,NO-STRING) */

logical yesno_(integer *q, integer *y, integer *n)
{
    /* System generated locals */
    integer i__1, ix, jx;
    logical ret_val;
    char ans, inbuf[32];

    /* Local variables */

L100:
    rspeak_(q);
/* ask */
    ans = ' ';
    glk_put_string(">>");
    ix = getline_(inbuf, 32);
    for (jx = 0; jx < ix && inbuf[jx] == ' '; jx++) { };
    if (jx < ix)
        ans = inbuf[jx];
/* get answer */
    if (ans == 'Y' || ans == 'y') {
        goto L200;
    }
    if (ans == 'N' || ans == 'n') {
        goto L300;
    }
L120:
    rspeak_(&c__6);
/* scold. */
    goto L100;

L200:
    ret_val = TRUE_;
/* yes, */
    rspeak_(y);
/* out with it. */
    return ret_val;

L300:
    ret_val = FALSE_;
/* no, */
    rspeak_(n);
/* likewise. */
    return ret_val;

} /* yesno_ */



/* ROBADV-- Steal winner's valuables */

/* Declarations */

integer robadv_(integer *adv, integer *nr, integer *nc, integer *na)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer i__;


    ret_val = 0;
/* count objects */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.oadv[i__ - 1] != *adv || objcts_1.otval[i__ - 1] <= 0 || 
                (objcts_1.oflag2[i__ - 1] & 8192) != 0) {
            goto L100;
        }
        newsta_(&i__, &c__0, nr, nc, na);
/* steal object */
        ++ret_val;
L100:
        ;
    }
    return ret_val;

} /* robadv_ */



/* ROBRM-- Steal room valuables */

/* Declarations */

integer robrm_(integer *rm, integer *pr, integer *nr, integer *nc, integer *
        na)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    integer i__;


    ret_val = 0;
/* count objects */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop on objects. */
        if (! qhere_(&i__, rm)) {
            goto L100;
        }
        if (objcts_1.otval[i__ - 1] <= 0 || (objcts_1.oflag2[i__ - 1] & 8192) 
                != 0 || (objcts_1.oflag1[i__ - 1] & 32768) == 0 || ! prob_(pr,
                 pr)) {
            goto L50;
        }
        newsta_(&i__, &c__0, nr, nc, na);
        ++ret_val;
        objcts_1.oflag2[i__ - 1] = objcts_1.oflag2[i__ - 1] | 4;
        goto L100;
L50:
        if ((objcts_1.oflag2[i__ - 1] & 1024) != 0) {
            i__2 = oactor_(&i__);
            ret_val += robadv_(&i__2, nr, nc, na);
        }
L100:
        ;
    }
    return ret_val;

} /* robrm_ */



/* WINNIN-- See if villain is winning */

/* Declarations */

logical winnin_(integer *vl, integer *hr)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer vs, ps;


    vs = objcts_1.ocapac[*vl - 1];
/* villain strength */
    ps = vs - fights_(hr, &c_true);
/* his margin over hero */
    ret_val = prob_(&c__90, &c__100);
    if (ps > 3) {
        return ret_val;
    }
/* +3... 90% winning */
    ret_val = prob_(&c__75, &c__85);
    if (ps > 0) {
        return ret_val;
    }
/* >0... 75% winning */
    ret_val = prob_(&c__50, &c__30);
    if (ps == 0) {
        return ret_val;
    }
/* =0... 50% winning */
    ret_val = prob_(&c__25, &c__25);
    if (vs > 1) {
        return ret_val;
    }
/* any villain strength. */
    ret_val = prob_(&c__10, &c__0);
    return ret_val;

} /* winnin_ */



/* FIGHTS-- Compute fight strength */

/* Declarations */

integer fights_(integer *h__, logical *flg)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */


    ret_val = (advs_1.ascore[*h__ - 1] * 5 + play_1.mxscor / 2) / 
            play_1.mxscor + 2;
    if (*flg) {
        ret_val += advs_1.astren[*h__ - 1];
    }
    return ret_val;

} /* fights_ */



/* VILSTR-       Compute villain strength */

/* Declarations */

integer vilstr_(integer *v)
{
    /* System generated locals */
    integer ret_val, i__1, i__2, i__3;

    /* Local variables */
    integer i__;


    ret_val = objcts_1.ocapac[*v - 1];
    if (ret_val <= 0) {
        return ret_val;
    }
    if (*v != 61 || ! findex_1.thfenf) {
        goto L100;
    }
    findex_1.thfenf = FALSE_;
/* thief unengrossed. */
    ret_val = min(ret_val,2);

/* no better than 2. */
L100:
    i__1 = vill_1.vlnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* see if best weapon. */
        if (vill_1.villns[i__ - 1] == *v && prsvec_1.prsi == vill_1.vbest[i__ 
                - 1]) {
/* Computing MAX */
            i__2 = 1, i__3 = ret_val - 1;
            ret_val = max(i__2,i__3);
        }
/* L200: */
    }
    return ret_val;

} /* vilstr_ */



/* GTTIME-- Get total time played (in minutes) */

/* Declarations */

/* Subroutine */ int gttime_(integer *t)
{
    /* Local variables */
    integer h__, m, s;


    itime_(&h__, &m, &s);
    *t = h__ * 60 + m - (misc_1.shour * 60 + misc_1.smin);
    if (*t < 0) {
        *t += 1440;
    }
    *t += misc_1.pltime;
    return 0;

} /* gttime_ */



/* OPNCLS-- Process open/close for doors */

/* Declarations */

logical opncls_(integer *obj, integer *so, integer *sc)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */


/* Functions and data */


    ret_val = TRUE_;
/* assume wins. */
    if (prsvec_1.prsa == 126) {
        goto L100;
    }
/* close? */
    if (prsvec_1.prsa == 125) {
        goto L50;
    }
/* open? */
    ret_val = FALSE_;
/* lose */
    return ret_val;

L50:
    if ((objcts_1.oflag2[*obj - 1] & 8) != 0) {
        goto L200;
    }
/* open... is it? */
    rspeak_(so);
    objcts_1.oflag2[*obj - 1] = objcts_1.oflag2[*obj - 1] | 8;
    return ret_val;

L100:
    if (! ((objcts_1.oflag2[*obj - 1] & 8) != 0)) {
        goto L200;
    }
/* close... is it? */
    rspeak_(sc);
    objcts_1.oflag2[*obj - 1] = objcts_1.oflag2[*obj - 1] & -9;
    return ret_val;

L200:
    i__1 = rnd_(&c__3) + 125;
    rspeak_(&i__1);
/* dummy. */
    return ret_val;

} /* opncls_ */



/* LIT-- Is room lit? */

/* Declarations */

logical lit_(integer *rm)
{
    /* System generated locals */
    integer i__1, i__2;
    logical ret_val;

    /* Local variables */
    integer i__, oa, j;


    ret_val = TRUE_;
/* assume wins */
    if (findex_1.deadf || (rooms_1.rflag[*rm - 1] & 16384) != 0) {
        return ret_val;
    }

/* room lit? */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* look for lit obj */
        if (qhere_(&i__, rm)) {
            goto L100;
        }
/* in room? */
        oa = objcts_1.oadv[i__ - 1];
/* no */
        if (oa <= 0) {
            goto L1000;
        }
/* on adv? */
        if (advs_1.aroom[oa - 1] != *rm) {
            goto L1000;
        }

/* Obj in room or on adv in room */

/* adv in room? */
L100:
        if ((objcts_1.oflag1[i__ - 1] & 1) != 0) {
            return ret_val;
        }
/* lit? */
        if ((objcts_1.oflag1[i__ - 1] & 32768) == 0 || ((objcts_1.oflag1[i__ 
                - 1] & 2048) == 0 && (objcts_1.oflag2[i__ - 1] & 8) == 0)) {
            goto L1000;
        }

/* Obj is visible and open or transparent */

        i__2 = objcts_1.olnt;
        for (j = 1; j <= i__2; ++j) {
            if (objcts_1.ocan[j - 1] == i__ && (objcts_1.oflag1[j - 1] & 1) !=
                     0) {
                return ret_val;
            }
/* L500: */
        }
L1000:
        ;
    }
    ret_val = FALSE_;
    return ret_val;

} /* lit_ */



/* WEIGHR- Returns sum of weight of qualifying objects */

/* Declarations */

integer weighr_(integer *cn, integer *ad)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer i__, j;

/*      LOGICAL QHERE */

    ret_val = 0;
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* omit big fixed items. */
        if (objcts_1.osize[i__ - 1] >= 10000) {
            goto L100;
        }
/* if fixed, forget it. */
        if (objcts_1.oadv[i__ - 1] == *ad && *ad != 0) {
            goto L50;
        }
/* on adv? */
        j = i__;
/* see if contained. */
L25:
        j = objcts_1.ocan[j - 1];
/* get next level up. */
        if (j == 0) {
            goto L100;
        }
/* end of list? */
        if ((objcts_1.oadv[j - 1] != *ad || *ad == 0) && j != *cn) {
            goto L25;
        }
/* cont on adv, or argume */
L50:
        ret_val += objcts_1.osize[i__ - 1];
/* add in weight. */
L100:
        ;
    }
    return ret_val;

} /* weighr_ */



/* GHERE--       Is global actually in this room? */

/* Declarations */

logical ghere_(integer *obj, integer *rm)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


    ret_val = TRUE_;
/* assume wins. */
    if (*obj <= 264) {
        return ret_val;
    }
/* if untested, return. */
    switch (*obj - 264) {
        case 1:  goto L100;
        case 2:  goto L1000;
        case 3:  goto L2000;
        case 4:  goto L3000;
        case 5:  goto L4000;
        case 6:  goto L5000;
        case 7:  goto L5000;
        case 8:  goto L5000;
        case 9:  goto L6000;
        case 10:  goto L7000;
        case 11:  goto L8000;
        case 12:  goto L9000;
        case 13:  goto L9100;
        case 14:  goto L8000;
        case 15:  goto L10000;
        case 16:  goto L11000;
        case 17:  goto L12000;
        case 18:  goto L13000;
        case 19:  goto L14000;
        case 20:  goto L15000;
    }
    bug_(&c__60, obj);

/* 100-- Granite Wall */

L100:
    ret_val = *rm == 96 || *rm == 103 || *rm == 58;
    return ret_val;

/* 1000--        House */

L1000:
    ret_val = (*rm >= 2 && *rm <= 5) || (*rm >= 31 && *rm <= 36) || *rm == 
            147;
    return ret_val;

/* 2000--        Bird */

L2000:
    ret_val = (*rm >= 31 && *rm < 36) || *rm == 147;
    return ret_val;

/* 3000--        Tree */

L3000:
    ret_val = *rm >= 31 && *rm < 36 && *rm != 33;
    return ret_val;

/* 4000--        North wall */

L4000:
    ret_val = (*rm >= 151 && *rm <= 155) || *rm == 190;
    return ret_val;

/* 5000--        East, south, west walls */

L5000:
    ret_val = (*rm >= 151 && *rm < 155) || *rm == 190;
    return ret_val;

/* 6000--        Global water */

L6000:
    ret_val = (rooms_1.rflag[*rm - 1] & 4608) != 0;
    return ret_val;

/* 7000--        Global guardians */

L7000:
    ret_val = (*rm >= 163 && *rm <= 165) || (*rm >= 171 && *rm <= 176) || *rm 
            == 177;
    return ret_val;

/* 8000--        Rose/channel */

L8000:
    ret_val = (*rm >= 161 && *rm <= 165) || *rm == 177;
    return ret_val;

/* 9000--        Mirror */
/* 9100          Panel */

L9100:
    if (*rm == 166) {
        return ret_val;
    }
/* panel at fdoor. */
L9000:
    ret_val = (*rm >= 161 && *rm <= 163) || (*rm >= 167 && *rm <= 172);
    return ret_val;

/* 10000--       Master */

L10000:
    ret_val = *rm == 166 || *rm == 182 || *rm == 183 || *rm == 184 || *rm == 
            185 || *rm == 186;
    return ret_val;

/* 11000--       Ladder */

L11000:
    ret_val = *rm == 190;
    return ret_val;

/* 12000--       Well */

L12000:
    ret_val = *rm == 142 || *rm == 143;
    return ret_val;

/* 13000--       Rope in slide */

L13000:
    ret_val = *rm >= 194 && *rm <= 197;
    return ret_val;

/* 14000--       Slide */

L14000:
    ret_val = *rm >= 58 || (*rm >= 194 && *rm <= 197);
    return ret_val;

/* 15000--       Bunch pseudo object */

L15000:
    ret_val = FALSE_;
/* never present */
    return ret_val;

} /* ghere_ */



/* MRHERE--      Is mirror here? */

/* Declarations */

integer mrhere_(integer *rm)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */


    if (*rm < 167 || *rm > 176) {
        goto L100;
    }

/* Room is an e-w room, mirror must be n-s (mdir= 0 or 180) */

    ret_val = 1;
/* assume mirror 1 here. */
    if ((*rm - 167) % 2 == findex_1.mdir / 180) {
        ret_val = 2;
    }
    return ret_val;

/* Room is north or south of mirror.  If mirror is n-s or not */
/* within one room of room, lose. */

L100:
    ret_val = 0;
    if ((i__1 = findex_1.mloc - *rm, abs(i__1)) != 1 || findex_1.mdir % 180 ==
             0) {
        return ret_val;
    }

/* Room is within one of mloc, and mdir is e-w */

    ret_val = 1;
    if ((*rm < findex_1.mloc && findex_1.mdir < 180) || (*rm > findex_1.mloc 
            && findex_1.mdir > 180)) {
        ret_val = 2;
    }
    return ret_val;

} /* mrhere_ */



/* ENCRYP--      Encrypt password */

/* Declarations */

/* Subroutine */ int encryp_(char *inw, char *outw, ftnlen inw_len, ftnlen 
        outw_len)
{
    /* Initialized data */

    static char keyw[8] = "ECOVXRMS";

    /* Local variables */
    integer uinw[8], ukeyw[8], ichara, uinws, ukeyws, j, i__, usum;


    ichara = 'A' - 1;
/* character base. */
    uinws = 0;
/* unbiased inw sum. */
    ukeyws = 0;
/* unbiased keyw sum. */
    j = 1;
/* pointer in keyword. */
    for (i__ = 1; i__ <= 8; ++i__) {
/* unbias, compute sums. */
        ukeyw[i__ - 1] = *(unsigned char *)&keyw[i__ - 1] - ichara;
/* strip ascii. */
        if (*(unsigned char *)&inw[j - 1] <= ichara) {
            j = 1;
        }
/* recycle on bad. */
        uinw[i__ - 1] = *(unsigned char *)&inw[j - 1] - ichara;
        ukeyws += ukeyw[i__ - 1];
        uinws += uinw[i__ - 1];
        ++j;
/* L100: */
    }

    usum = uinws % 8 + (ukeyws % 8 << 3);
/* compute mask. */
    for (i__ = 1; i__ <= 8; ++i__) {
        j = (uinw[i__ - 1] ^ (ukeyw[i__ - 1] ^ usum)) & 31;
        usum = (usum + 1) % 32;
        if (j > 26) {
            j %= 26;
        }
        *(unsigned char *)&outw[i__ - 1] = (char) (max(1,j) + ichara);
/* L200: */
    }
    return 0;

} /* encryp_ */



/* CPGOTO--      Move to next state in puzzle room */

/* Declarations */

/* Subroutine */ int cpgoto_(integer *st)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer i__;


    rooms_1.rflag[189] = rooms_1.rflag[189] & -32769;
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* relocate objects. */
        if (objcts_1.oroom[i__ - 1] == 190 && (objcts_1.oflag2[i__ - 1] & 
                1152) == 0) {
            i__2 = findex_1.cphere * 500;
            newsta_(&i__, &c__0, &i__2, &c__0, &c__0);
        }
        if (objcts_1.oroom[i__ - 1] == *st * 500) {
            newsta_(&i__, &c__0, &c__190, &c__0, &c__0);
        }
/* L100: */
    }
    findex_1.cphere = *st;
    return 0;

} /* cpgoto_ */



/* CPINFO--      Describe puzzle room */

/* Declarations */

/* Subroutine */ int cpinfo_(integer *rmk, integer *st)
{
    /* Initialized data */

    static integer dgmoft[8] = { -9,-8,-7,-1,1,7,8,9 };
    static char pict[2*5] = "SS" "SS" "SS" "  " "MM";
    static char qmk[2] = "??";

    /* Local variables */
    integer i__, j, k, l;
    char dgm[2*8];

/* Functions and local data */

    rspeak_(rmk);
    for (i__ = 1; i__ <= 8; ++i__) {
        j = dgmoft[i__ - 1];
        s_copy(dgm + ((i__ - 1) << 1), pict + ((puzzle_1.cpvec[*st + j - 1] + 
                3) << 1), 2L, 2L);
/* get picture element. */
        if (abs(j) == 1 || abs(j) == 8) {
            goto L100;
        }
        k = 8;
        if (j < 0) {
            k = -8;
        }
/* get ortho dir. */
        l = j - k;
        if (puzzle_1.cpvec[*st + k - 1] != 0 && puzzle_1.cpvec[*st + l - 1] !=
                 0) {
            s_copy(dgm + ((i__ - 1) << 1), qmk, 2L, 2L);
        }
L100:
        ;
    }
    glk_set_style(style_Preformatted);
    weeprintf(
      "       |%c%c %c%c %c%c|\n"
      " West  |%c%c .. %c%c|  East\n"
      "       |%c%c %c%c %c%c|\n",
      dgm[0], dgm[1], dgm[2], dgm[3], dgm[4], dgm[5], dgm[6], dgm[7],
      dgm[8], dgm[9], dgm[10], dgm[11], dgm[12], dgm[13], dgm[14], dgm[15]);
    glk_set_style(style_Normal);

    if (*st == 10) {
        rspeak_(&c__870);
    }
/* at hole? */
    if (*st == 37) {
        rspeak_(&c__871);
    }
/* at niche? */
    i__ = 872;
/* door open? */
    if (findex_1.cpoutf) {
        i__ = 873;
    }
    if (*st == 52) {
        rspeak_(&i__);
    }
/* at door? */
    if (puzzle_1.cpvec[*st] == -2) {
        rspeak_(&c__874);
    }
/* east ladder? */
    if (puzzle_1.cpvec[*st - 2] == -3) {
        rspeak_(&c__875);
    }
/* west ladder? */
    return 0;


} /* cpinfo_ */



/* NBLEN-        Compute string length without trailing blanks */

/* Declarations */

integer nblen_(char *string, ftnlen string_len)
{
    /* System generated locals */
    integer ret_val;

    ret_val = i_len(string, string_len);
/* get nominal length */
L100:
    if (ret_val <= 0) {
        return ret_val;
    }
/* any string left? */
    if (*(unsigned char *)&string[ret_val - 1] != ' ') {
        return ret_val;
    }
/* found a non-blank? */
    --ret_val;
/* no, trim len by 1 */
    goto L100;

/* and continue. */
} /* nblen_ */

