/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The Edge System
 *
 * This system is in the most remote explored part of the galaxy.
 *
 * PLANETS:
 *
 * Razor:		Small group of settlers make Razor Brandy, famous
 *			but illegal throughout the galaxy.  This planet
 *			is inhabited by many carnivores and is hence
 *			quite dangerous.
 * New Hell:		Tremendous volcanic activity -- almost inhospitable
 *			This is where the galaxy's outcasts end up.  It's
 *			not a gentle or pretty place.
 * Sharp:		?
 *
 * COLORSPACES:
 *
 * Midnight Blue:	Contains Razor and New Hell.
 */

#ifndef	DEMO

/*
 * The Watchmen
 *
 * The Watchmaker's lair and all-around underworld outcast hangout.
 */
watchmenmover: mattermover
	location = watchmen1

	address = {
		"The mover's address plate has been rubbed smooth.";
	}

	/*
	 * This mover's coordinates
	 */
	ar = -1
	ag = -1
	ab = -1

	/*
	 * This mover's dials
 	 */
	r = watchred
	g = watchgreen
	b = watchblue

	colorspace = 'Midnight Blue'
	system = 'Edge'
	planet = 'New Hell'
;

watchgreen: greendial 	setting = 0 location = watchmen1;
watchblue:  bluedial  	setting = 0 location = watchmen1;
watchred:   reddial 	setting = 0 location = watchmen1;

watchmen1: Room
	triedeast = nil
	walls = nil

	sdesc = "New Hell"
	ldesc = {
		I(); "You are in a small lobby enclosed by a transparent
		dome. The lobby opens up to the north into The Watchmen proper
		and an eastern portal leads outside.  This area itself
		is nondescript, but through the clear canopy you can see
		what a dark and terrifying world New Hell is: rivers of lava
		slither through the greasy-slick alleys	of the slums and on
		to the distant horizon,	where primordial geysers ejaculate
		molten rock into the midnight blue sky "; note(self); "."; P();

		I(); "Flourescent spotlights flicker nervously, at moments
		illuminating the victims of the collective carnivorous orgy
		just long enough for you to take the scenes in, but briefly
		enough for you to mistake them for little nightmares."; P();

		if (not self.isseen) {
			I(); "Flash.  A dog with its skull half crushed,
			pulling itself over to an upturned trashcan lid full
			of oily water, back legs dragging limply through
			the scum."; P();

			I(); "Flash.  Someone's daughter screaming as her arms
			are twisted to breaking	behind her back, her face
			bleeding as an aggressor's nails dig in and hold
			her head."; P();

			I(); "Flash.  A PainWhip, legal nowhere there is
			law, flays open a boy's bare leg.  As he crumples he
			is saved from the spiked wheels of the teenagers' 
			rattle-trap mining truck by a sniper's well-placed
		        disruptor blast.  The truck smolders as the boy
			hobbles into a tenement house."; P();
		}

		I(); "You turn away. New Hell isn't just where people
		suffer.  New Hell is where people who no one cares about
		suffer.  The poets' words don't drift away on the fiery
		rivers here. There aren't any poets.";
	}

	verGoIn(actor) = {}
	goIn(actor) = { watchmenmover.doEnter(actor); return nil; }

	verGoNorth(actor) = {}
	goNorth = watchmen2

	verGoEast(actor) = {}
	goEast(actor) = {
		if (not self.triedeast) {
			"It really doesn't seem like a good idea
			to venture out into the mayhem.";

			self.triedeast := true;
		}
		else {
			I(); "You steel yourself and head outside.  
			Although it's night, it's so warm it's nearly
			painful, and the air, reeking of sulfur, is
			thick with smoke and petroleum.  Within moments
			you are nearly overcome by it. "; P();

			I(); "You sally forth into the gloom, but are
			soon set upon by a roving gang of thugs.  You
			hurry back to the entrance to The Watchmen but
			don't make it.  Your death is slow and
			humiliating.";

			notify(deathobject, &death, 0);
		}

		return nil;
	}

	footnote = { watchmensky.ldesc;	}
;
watchmenspolights: Distant
	sdesc = "spotlights"
	ldesc = "They seem to be all around the city."
	noun = 'lights' 'light' 'spotlights'
	adjective = 'flicker' 'spot'
	location = watchmen1
;
watchmensky: Distant
	sdesc = "New Hell sky"
	ldesc = {
		"The night sky on New Hell is chillingly beautiful, 
		like none you've ever before seen.  The tapestry of
		stars is periodically wrinkled by the \"Charon
		Effect,\" which streaks the stars in white loops.
		The effect is still not well understood.";
	}
	noun = 'sky'
	adjective = 'midnight' 'blue'
	location = watchmen1
;
watchmengeysers: Distant
	sdesc = "geysers"
	ldesc = {
		"These aren't, of course, real geysers.  These are
		far more terrifying: holes in the crust of New
		Hell through which the molten earth issues forth.
		This planet, you realize, is far too unstable to
		support the cities that have been built here.";
	}
	noun = 'geysers'
	location = watchmen1
;
watchmenhorizon: Distant
	sdesc = "horizon"
	ldesc = "You can see a fair distance -- the horizon is many
		kilometers away."
	noun = 'horizon'
	location = watchmen1
;
watchmenslums: Distant
	sdesc = "slums"
	ldesc = {
		"The slums of New Hell look worse than any you've
		ever seen in the native Val system.  Tode has 
		largely solved its urban blight now.  It would
		seems that such problems are only worsening here
		on New Hell.";
	}
	noun = 'slums' 'slum'
	location = watchmen1
;
watchmenalleys: Distant
	sdesc = "filthy New Hell alleys"
	ldesc = {
		"The alleys are covered with flith of all kinds --
		garbage, oil, rodents, and many other things
	        you dearly hope to avoid.";
	}
	noun = 'alleys' 'alley' 'garbage' 'oil' 'rodents'
	adjective = 'slime' 'slime-covered' 'covered' 'dirty'
		'filth' 'filth-covered'
	location = watchmen1
;
watchmenlava: Distant
	sdesc = "lava"
	ldesc = {
		"There is lava all around outside, now and then
		bubbling up through the pavement.  From the looks
		of it, New Hell is a planet still forming -- not
		a very good place to settle.  But maybe these
		people had little choice.";
	}
	noun = 'lava' 'rivers'
	location = watchmen1
;
watchmenwalls: Decoration
	isplural = true
	sdesc = "transparent walls"
	ldesc = {
		"You can see the horrendous sights of New Hell
		through the walls.";
	}
	noun = 'wall' 'walls' 'side' 'sides' 'corners' 'ceiling' 'dome'
	adjective = 'transparent' 
	location = watchmen1
;

watchmen2: Room
	sdesc = "At the Entrance to The Watchmen"
	ldesc = {
		I(); "Here is the entrance to The Watchmen, home
		to the Watchmaker and, from the looks of it,
		frequented by society's outcasts.  Through
		the entranceway you spy unusual characters of
		all sorts engaging in business, pleasure, and
		pain."; P();

		I(); "North of here is the inside of the 
		establishment.  The matter mover and exit
		are to the south.";
	}

	verGoNorth(actor) = {}
	goNorth(actor) = {
		if (not watchbouncer.oktopass) {
			"\"Don't think so,\" the bouncer grunts.
			He bars your way north.";

			return nil;
		}
		
		notify(watchmen3, &events, 0);
       		return watchmen3;
	}

	verGoSouth(actor) = {}
	goSouth = watchmen1
;
watchbouncer: Male, Actor
	oktopass = nil
	scored = nil

	sdesc = "bouncer"
	
	ldesc = {
		I(); "This fellow is a monster. He looks human --
		sort of -- but he's almost twice your height, and
		comically broad."; P();

		I(); "Snakeskin grafts spiral up his arms, 
		culminating in fanged cobra-head epaulets on his
		bare shoulders.  His chest is bare but for
		a web of chains attached to steel posts pierced
		into his skin with mathematical precision.  Attached
		to the mail are thick ropes suspending baggy black
		trousers.  The sparkle of his steel-toed boots
		echoes the gleam in his eye."; P();

		I(); "You fear that his expression of disinterest
		only obscures the psychosis within.";
	}
	noun = 'bouncer' 'man' 'fellow' 
	adjective = 'watch' 'men' 'watchmen'
	location = watchmen2

	actordesc = { 
		if (not self.oktopass) {
			"The Watchmen bouncer is keeping an eye on you.
			He doesn't seem eager to let you enter.";
		}
		else {
			"The bouncer is here, fortunately ignoring you.";
		}
	}

	forget = { self.oktopass := nil; }

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (dobj = triangle) {
			"The bouncer pulls a hand-held device out
			of his left trouser pocket and plugs the
			triangle into it.  He grunts, hands it
			back to you, and waves you through.";

			if (not self.scored) {
				self.scored := true;
				incscore(1);
			}

			self.oktopass := true;
			notify(self, &forget, 15);
		}
		else {
			"The bouncer sneers and flexes, pulling his
			cobra-heads erect.";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		"He doesn't seem to be in a particularly
		talkative mood.";
	}
	verDoTellabout(actor, io) = {}	
	doTellabout(actor, io) = { "He's decidedly uninterested."; }
	
	ioShowto(actor, dobj) = { self.ioGiveto(actor, dobj); }

	doSmell(actor) = {
		"He smells reptilian.";
	}
	verDoRub(actor) = {
		"My advice to you: quit	this game before something really
		ugly happens.";
	}
	verDoAttackwith(actor, io)  = {
		"Not in this lifetime.";
	}
	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"The bouncer is not in the least amused.  He
		wrenches the can from your grasp and empties
		it on you.  You die a horrible, twitching death.";

		notify(deathobject, &death, 0);
	}
;
class watchroom: Room
	ldesc = {
		I(); "You are wandering around the smoky, dark,
		cavernous interior of The Watchmen.  All around
		you oddly-dressed men make transactions, fight
		with each other, and generally carouse loudly.
		It's so dimly lit here that you can barely find
		your way through the maze of human obstacles --
		sitting, standing, and prone."; P();

		I(); watchworkers.ldesc;

		P(); I();
		self.listexits;
	}
;
watchpatrons: floatingdecoration
	isplural = true
	sdesc = "Watchmen customers"
	ldesc = {
		"The customers don't appear very interested
		in dealing with you on any level you're
		comfortable with.";
	}
	noun = 'patrons' 'customers' 'clientele' 'people' 'men'
	adjective = 'oddly' 'dressed' 'oddly-dressed' 'carousing' 'loud'
	loclist = [watchmen3 watchmen4]
;
watchworkers: Knowntopic, floatingdecoration
	isplural = true
	sdesc = "Watchmen employees"
	ldesc = {
		"The employees all seem to be male, but
		in many cases it's hard to tell.  They are dressed
		very differently then the clientele -- slick
		fabric uniforms in dark maroon that look too tight.
		Each employee has a gold pocket watch emblem on his
		chest, just above the heart.";
	}
	noun = 'employees' 'workers' 'waiters' 'servers' 'watchmen'
	adjective = 'watchmen'
	loclist = [watchmen3 watchmen4]
;
watchemblem: Part
	partof = watchworkers
	sdesc = "gold pocket watch emblem"
	ldesc = {
		"It just looks like a normal pocket watch, rendered
		in some kind of shiny material.";
	}
	noun = 'emblem' 'watch' 'pocketwatch'
	adjective = 'gold' 'pocket' 'pocketwatch'
;
watchmen3: watchroom
	sdesc = "The Watchmen"
	listexits = {
		"The Watchmen continues to the north and south.";
	}

	events = {
		if (Me.isin(watchlair))
			return;

		if (rndchance(25)) {
			P(); I();
			say(self.Message[rnd(length(self.Message))]);
		}
	}

	Message = [
		'An androgynous Watchmen employee bumps
		into you and grabs your rear end.'

		'You are nearly hit by an energy bolt
		as an argument over some illegal implants
		reaches a climax across the room.'

		'Several tough-looking patrons in the
		corner eye you hungrily.'

		'You nearly trip over an outstretched
		leg, thereby provking intense and 
		prolonged swearing from the leg\'s owner.'

		'An individual whose gender is unclear
		walks past you bedecked in a tight leather
		outfit covered in a mesh of needles.'

		'Someone spits on you.  You wisely
		pretend not to notice.'

		'A rowdy party nearby jeers and gestures
		at you.'

		'Several men dressed only in disruptor chains
		barrel noisily into The Watchmen from outside.
		Their faces are covered with soot and grime.
		They look battle-weary.'

		'You walk through a section of The Watchmen
		that is particularly thick with tobacco smoke.
		You summon all the self-discipline you can to
		avoid coughing.  You suspect that attracting
		attention to your frailty here wouldn\'t be
		the best idea.'

		'The men at a table next to you just exchanged
		what looked to be paper money, long since fallen
		into total disuse in the galaxy, or so you thought.'

		'Before you even notice him, a man comes up
		behind you and kisses you on the back of the
		neck, then disappears into the crowd.'

		'Several partons in a nearby enclosed booth are
		attracting attention: you get a good look at the one
		bound up in disruptor chains shouting, "Yes! Yes!"
		before your staring is noticed.'

		'A glass shatters nearby.'

		'You hear a muffled scream.'

		'The conversation nearest you suddenly becomes a
		profane shouting match, then recedes into the din.'

		'You hear someone shouting, "Yes, cut me!"'
	]

	verGoNorth(actor) = {}
	goNorth = watchmen4

	verGoSouth(actor) = {}
	goSouth(actor) = {
		unnotify(watchmen3, &events);
       		return watchmen2;
	}
;

watchmen4: watchroom
	sdesc = "The Watchmen"
	listexits = {
		"The Watchmen proper ends here, but there is another
		smaller area to the east.  The rest of the establishment
		is south of here.";
		
	}

	verGoEast(actor) = {}
	goEast = watchlair

	verGoSouth(actor) = {}
	goSouth = watchmen3
;

watchlair: Room
	sdesc = "The Watchmaker's Headquarters"
	ldesc = {
		I(); "This area looks much like the rest of the 
		place, but there are far fewer people here.  The
		majority are Watchmen employees, hovering 
		around the Watchmaker.  No one pays much attention
		to you as you mill about.";
	}

	verGoWest(actor) = {}
	goWest = watchmen4
;

watchmaker: Knowntopic, Female, Actor
	solved = nil

	sdesc = "The Watchmaker"
	isdetermined = true
	
	ldesc = {
		I(); "The first thing that strikes you about the
		Watchmaker is her face, which seems to be fixed in
		a look that says, \"I'm more than you think\".  She
		is perpetually calm, speaks in a raspy whisper, 
		and has eyes that are alert with the analytical
		intelligence that has made her ruler of the 
		Republic's excrement."; P();

		I(); "You see no hint of the insanity Timon
		Sketch alluded to -- only matter-of-fact 
		evaluation and dispensation of orders."; P();

		I(); "Those who work here appear to obey her
		unquestioningly.";
	}
	noun = 'watchmaker' 'maker' 'woman' 'owner'
	adjective = 'watch'
	location = watchlair

	actordesc = { "The Watchmaker is here."; }

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (self.solved) {
			"You suspect that further bothering
			the Watchmaker would only lead to
			a gruesome death.";

			return;
		}

		if (dobj = triangle) {
			"She looks up from her work and eyes
			you incredulously.  \"Who the fuck
			are you?  No, scratch that.  I don't
			give a flying shit who you are. Do you
			have information?  If you do, let's talk.
			Otherwise, get out,\" she sneers.";
		}
		else if (dobj = handypad) {
			handytransition.transition;
			self.solved := true;
		}
		else {
			"\"Who the fuck is this brain-damaged
			college boy?  Anybody know this guy?\"
			she asks, never once looking you in
			the eye.";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = handypad)
			"\"A HandyPad is only worth the information	
			that's stored in it,\" she says	impatiently.";
		else if (io = sketch)
			"\"Timon Sketch?\" she says gleefully.  \"How's
			the bastard doing?  Great kid.  Love that song
			he does about the girl with horns.  Know any
			chicks with horns, boy?  Is your girlfriend
			horny?\".  She laughs too much.";
		else
			"\"No information is free, you little rugrat,\"
			the Watchmaker grumbles.";
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		if (io = sketch)
			self.doAskabout(actor, io);
		else if (io = handypad)
			self.doAskabout(actor, io);
		else if (io = virus or io = meddler or io = reb)
			"\"Look, kid,\" she sneers, \"I got my
			own problems to deal with.  You ain't the
			first crackpot to come in here and tell
			me the world's coming to an end.\"";
		else
			"\"How you do go on,\" she says mockingly.";
	}
	
	ioShowto(actor, dobj) = { self.doAskabout(actor, dobj); }

	doSmell(actor) = {
		"I wouldn't get that close, if I were you.";
	}
	verDoRub(actor) = {
		"My advice to you: quit	this game before something really  
		ugly happens.";
	}
	verDoAttackwith(actor, io)  = {
		"Give it up -- she'd eat you alive.";
	}
	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"You spray the Watchmaker with the repellent.  Gasping
		for breath, she manages to choke out the words, \"Have
		this punk killed.\"  Your death is quite drawn
		out (so to speak) and horrible.";

		notify(deathobject, &death, 0);
	}
;
indexcard: Item, Readable
	firstseen = true

	sdesc = "index card"
	ldesc = {
 		if (self.firstseen) {
			self.firstseen := nil;

			akmimover.ar := 10000 - rnd(50);
			akmimover.ag := 7470 + rnd(50);
			akmimover.ab := 1000 - rnd(50);
			akmimover.accepting := true;
		}
		
		"The index card is blank but for three relative
		coordinates:"; P();

		"\t (-";
			say(10000 - akmimover.ar);
	        ", +";
			say(akmimover.ag - 7470);
		", -";
			say(1000 - akmimover.ab);
		")";
	}
	readdesc = { self.ldesc; }

	noun = 'card' 'indexcard'
	adjective = 'index'

	location = nil
;
#endif	/* DEMO */
