/* cvmsg.c
 *  class messages:
 *
 *    these indicate the scores required for particular ratings.
 *    Each entry consists of a number and a message; if the number
 *    is posistive, it is the score required for the rating, and if
 *    the number is negative, it indicates how close to the maximum
 *    score you must be for the rating.  Watch out for -1, which
 *    terminates the list.
 *
 *  magic messages
 *
 *    messages for some special things, kept together for reference.
 *
 *  arbitrary messages
 *
 *    "*" appearing as the first character of any of these messages
 *    indicates that delivery of the message should result in
 *    termination of any multiple-command input line currently
 *    being processed.
 *
 *    Some of the messages are declared out of order, to accomodate
 *    limitations on the token length in my C compiler.
 *
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "cvmsg.h"

struct cmsg ctext[] =
{
    {10, "You are obviously a rank amateur.  Better luck next time.\n"},
    {50, "Your score qualifies you as a novice-class spelunker.\n"},
    {75, "You have achieved the rating: \"Experienced Spelunker\".\n"},
    {125, "You may now consider yourself a \"Seasoned Spelunker\".\n"},
    {175, "You are now a \"Senior Spelunker\".\n"},
    {225, "You attained a \"First Class Spelunker\" score.\n"},
    {300, "You have reached \"Junior Master\" status.\n"},
    {-25, "Your score puts you in Master Spelunker class C.\n"},
    {-20, "Your score puts you in Master Spelunker class B.\n"},
    {-5, "Your score puts you in Master Spelunker class A.\n"},
    {0, "All of Cavedom gives tribute to you, Spelunker Grandmaster!\n"},
    {-1}};


char *mmsg[] =
{
    "",

    "A large cloud of green smoke appears in front of you.  It clears away to\n\
reveal a tall wizard, clothed in grey.  He fixes you with a steely glare\n\
and declares, \"This expedition has lasted too long.\"  With that, he makes\n\
a single pass over you with his hands, and everything around you fades\n\
away into a grey nothingness.\n",

    "Even wizards have to wait longer than that!\n",

    "I'm terribly sorry, but Crystal Cave is closed.  Our hours are:\n",

    "Only wizards are permitted within the cave right now.\n",

    "We do allow visitors to make short explorations during our off hours.\n\
Would you like to do that?\n",

  "Crystal Cave is open to regular spelunkers at the following hours:\n",

    "",				/* 7 put into cvmotd.c */

    "Only a wizard may continue an expedition this soon.\n",

    "I suggest you continue your expedition at a later time.\n",

    "Do you wish to see the hours? ",

    "Do you wish to change the hours? ",

    "New magic word (null to leave it unchanged): ",

    "New magic number (zero to leave it unchanged): ",

    "",				/* 14 put into cvmotd.c */

    "",				/* 15 put into cvmotd.c */

    "",				/* 16 put into cvmotd.c */

    "",				/* 17 put into cvmotd.c */

    "That is not what I thought it was.  Do you know what I thought it was? ",

"Oh, dear, you really are a wizard!  Sorry to have bothered you . . .\n",

    "",				/* 20 put into cvmotd.c */

    "New hours specified by defining \"Prime Time\".  Give only the hour\n\
(e.g. 14, not 14:00 or 2PM).  Enter a negative number after the last pair.\n",

    "New hours for Crystal Cave:\n",

    "",				/* 23 put into cvmotd.c */

    "",				/* 24 put into cvmotd.c */

    "",				/* 25 put into cvmotd.c */

    "Do you wish to (re)schedule the next holiday? ",

    "To begin how many days from today? ",

    "To last how many days (zero if no holiday)? ",

    "To be called what (up to 20 characters)? ",

    "Too small!  Assuming minimum value (45 minutes).\n"
};


static char MSG157[] = "\
I know of places, actions, and things.  Most of my vocabulary describes\n\
places, and is used to move you there.  To move, try words like PATH, UP,\n\
DOWN, BARN, LEAVE, ENTER, EAST, WEST, NE, NW, etc.  Objects may be\n\
manipulated using some of the action words that I know.  Usually, you'll\n\
need to type both the object and the action word (in either order), but\n\
some objects also imply verbs; in particular, \"INVENTORY\" implies \"TAKE\n\
INVENTORY\", which causes me to list what you're carrying.  The objects have\n\
side effects.  Usually, people having trouble moving just need to try a few\n\
more words: folks trying unsuccessfully to manipulate an object are trying\n\
something beyond their (or my!) capabilities and should try a completely\n\
different tack.  I'll describe some of the more unusual aspects of the cave\n\
if you ask me (for example, say \"DESCRIBE TREES\").\n\
\n\
Press <return> to continue: ";

static char MSG158[] = "\n\
If you think your problems are the fault of the program, let me know.\n\
I am " PACKAGE_BUGREPORT ".  You never know, I might even do\n\
something about it.\n\
\n\
To speed the game, you can sometimes move long distances with a single\n\
word.  For example, \"BARN\" usually gets you to the barn from anywhere\n\
above ground except when lost in the woods.  Also, note that cave\n\
passages turn a lot, and that leaving a room to the north does not\n\
guarantee entering the next from the south!  ...Good Luck!\n";

static char MSG142[] = "\
If you want to end your expedition early, say \"QUIT\".  To suspend your\n\
expedition such that you can continue later, say \"SUSPEND\" (or \"PAUSE\"\n\
or \"SAVE\").  Later, you say \"RESTORE\" or \"CONTINUE\" to restore the game.\
\n\
To see how well you're doing, say \"SCORE\".  To get full credit for a\n\
treasure, you must have left it safely in the building, though you get\n\
partial credit just for locating it.  You lose points for getting killed,\n\
or for quitting, though the former costs you more.  There are also points\n\
based on how much (if any) of the cave you've managed to explore; in\n\
particular, there is a large bonus just for getting in (to distinguish\n\
the beginners from the rest of the pack), and there are other ways to\n\
determine whether you've been through some of the more harrowing sections.\n\
\n\
If you think you've found all the treasures, just keep exploring for a\n\
while.  If nothing interesting happens, you haven't found them all yet.\n\
If something interesting does happen, it means you're getting a bonus and\n\
have an opportunity to garner many more points in the master's section.\n\
I may occasionally offer hints if you seem to be having trouble.  If I\n\
do, I'll warn you in advance how much it will affect your score to accept\n\
the hints.  Finally, to save paper or time, you may specify \"BRIEF\", which\n\
tells me never to repeat the full description of a place unless you\n\
explicitly ask me to.\n";

char *rmsg[] =
{
    NULL,			/* no message zero */

     /* 1: */ "\
You are near Crystal Cave Park, where others have found fortunes in\n\
treasure and gold, though it is rumored that some who enter are never\n\
seen again.  Magic is said to work in the cave.  I will be your eyes and\n\
hands.  Direct me with commands of 1 or 2 words.  Several commands may\n\
be input on one line, as in \"IN. GET LAMP, KEYS. OUT\".  If you simply\n\
type \"AGAIN\", I will repeat your last command string.\n\
\n\
If you get stuck, type \"HELP\" for some general hints.  For information\n\
on how to end your expedition, etc., type \"INFO\".\n\
\n\
This game is based on, and is intended as a sequel to, the adventure\n\
game developed by Willie Crowther at Stanford.  The original FORTRAN\n\
author of this version is unknown.  This version was recoded in C,\n\
ported to the UNIX PC by Kevin O'Gorman around January 1, 1986.\n\
and then to Linux by Glenn Hutchings in 2007.\n",

     /* 2: */ "*\
A little dwarf with a big knife blocks your way.\n",

     /* 3: */ "\
A little dwarf just walked around a corner, saw you, threw a little axe\n\
at you (which missed), cursed, and ran away.\n",

     /* 4: */ "\
There is a threatening little dwarf in the room with you!\n",

     /* 5: */ "\
One sharp nasty knife is thrown at you.\n",

     /* 6: */ "\
None of them hit you.\n",

     /* 7: */ "*\
One of them gets you!\n",

     /* 8: */ "\
There is no one here to pay.\n",

     /* 9: */ "*\
There is no way to go that direction.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 10: */ "*\
I am unsure how you are facing.  Use compass points or nearby objects.\n",

     /* 11: */ "*\
I don't know in from out here.  Use compass points or name something in\n\
the general direction you want to go.\n",

     /* 12: */ "*\
I don't know how to apply that word here.\n",

     /* 13: */ "*\
I don't understand that.\n",

     /* 14: */ "*\
I'm game.  Would you care to explain how?\n",

     /* 15: */ "\
Sorry, but I am not allowed to give more details.  I will repeat the long\n\
description of your location:\n\n",

     /* 16: */ "*\
It is now pitch dark.  If you proceed you will likely fall into a pit.\n",

     /* 17: */ "\
If you prefer, simply type N rather than NORTH.\n",

     /* 18: */ "\
There is a Ranger behind you!  He says:\n",

     /* 19: */ "*\
The rapids are too swift to cross.\n",

     /* 20: */ "*\
You don't have your wallet!\n",

     /* 21: */ "*\
Your wallet is empty.\n",

     /* 22: */ "*\
Do you really wish to quit now? ",

     /* 23: */ "*\
You fell into a pit and broke every bone in your body!\n",

     /* 24: */ "\
You are already carrying it.\n",

     /* 25: */ "*\
You can't be serious!\n",

     /* 26: */ "\
The boat is already untied.\n",

     /* 27: */ "\
The boat is already tied.\n",

     /* 28: */ "*\
There is nothing here with a lock.\n",

     /* 29: */ "*\
You aren't carrying it.\n",

     /* 30: */ "*\
The boat is a wreck!\n",

     /* 31: */ "*\
You have no keys.\n",

     /* 32: */ "\
The boat was in the path of the wall of water.\n",

     /* 33: */ "*\
I don't know how to lock or unlock such a thing.\n",

     /* 34: */ "\
It was already locked.\n",

     /* 35: */ "\
The door is now locked.\n",

     /* 36: */ "\
The door is now unlocked.\n",

     /* 37: */ "\
It was already unlocked.\n",

     /* 38: */ "*\
You have no source of light.\n",

     /* 39: */ "\
Your lamp is now on.\n",

     /* 40: */ "\
Your lamp is now off.\n",

     /* 41: */ "\
The dam crashes open with a mighty roar.  A gigantic wall of water leaps\n\
across the lake and down the stream passage, destroying everything in its\n\
path.\n",

     /* 42: */ "\
Nothing happens.\n",

     /* 43: */ "*\
Where?\n",

     /* 44: */ "*\
There is nothing here to attack.\n",

     /* 45: */ "*\
You were in the boat. . .You are dead!!!\n",

     /* 46: */ "\
The flooding dam filled the cave mouth with debris (and nearly killed the\n\
Ranger).  The Park Service ordered the closing of Crystal Cave to\n\
tourists so there's nobody here to let you in (even if the gate wasn't\n\
jammed shut!)\n",

     /* 47: */ "\
You killed a little dwarf.\n",

     /* 47: */ "\
You attack a little dwarf, but he dodges out of the way.\n",

     /* 49: */ "*\
With what?  Your bare hands?\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 50: */ "\
Good try, but that is an old worn-out magic word.\n",

     /* 51: */ NULL,

     /* 52: */ "\
It misses.\n",

     /* 53: */ "*\
It gets you!\n",

     /* 54: */ "\
Ok.\n",

     /* 55: */ "*\
You can't unlock the keys.\n",

     /* 56: */ "*\
Be thankful, there really is no way to get past the boulders.\n",

     /* 57: */ "\
For an instant, you catch sight of a doorway, but it immediately wavers\n\
and then disappears.\n",

     /* 58: */ "*\
In an underground cave, you'll need a compass in order to use compass\n\
point directions.\n",

     /* 59: */ "\
I can only tell you what you see as you move about and manipulate things.\n\
I cannot tell you where remote things are.\n",

     /* 60: */ "*\
I don't know that word.\n",

     /* 61: */ "*\
What?\n",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 62: */ "*\
Are you trying to get into the cave? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 63: */ "\
The gate is very solid and has a hardened steel lock.  The Ranger won't\n\
let you in without paying, and you don't have your wallet.  I would\n\
recommend that you find where you left your wallet.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 64: */ "\
The trees of the forest are large hardwood oak and maple, with an\n\
occasional grove of pine or spruce.  There is quite a bit of undergrowth,\n\
largely birch and ash saplings plus nondescript bushes of various sorts.\n\
This time of year visibility is quite restricted by all the leaves, but\n\
travel is quite easy if you detour around the spruce and berry bushes.\n",

     /* 65: */ "\
Welcome to the Crystal Cave expedition.\n\nWould you like instructions? ",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 66: */ "\
Digging without a shovel is quite impractical.  Even with a shovel,\n\
progress is unlikely.\n",

     /* 67: */ "\
Blasting requires dynamite.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 68: */ "\
I'm as confused as you are.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 69: */ "\
Mist is a white vapor, usually water, seen from time to time in caverns.\n\
It can be found anywhere but is frequently a sign of a deep pit leading\n\
down to water.\n",

     /* 70: */ "\
Your feet are now wet.\n",

     /* 71: */ "\
I think I just lost my appetite.\n",

     /* 72: */ "\
Thank you, it was delicious.\n",

     /* 73: */ "\
You have taken a drink of water.  The water tastes strongly of minerals,\n\
but is not unpleasant.  It is extremely cold.\n",

     /* 74: */ "*\
You can't read the compass in the dark.\n",

     /* 75: */ "\
Rubbing the electric lamp is not particularly rewarding.  Anyway, nothing\n\
exciting happens.\n",

     /* 76: */ "\
Peculiar.  Nothing unexpected happens.\n",

     /* 77: */ "\
The ground is now wet.\n",

     /* 78: */ "*\
You can't pour that.\n",

     /* 79: */ "\
The ground is now wet and sticky.\n",

     /* 80: */ NULL,

/*************************************************************************
 * NOTE: messages 81 through 89 are reserved for dying and getting
 * resurrected.  This is hardwired into the various code pieces.
 *************************************************************************/

     /* 81: */ "*\
Oh dear, you seem to have gotten yourself killed.  Do you want me to try\n\
to reincarnate you? ",

     /* 82: */ "*\
All right.  By the way, I've never done this before, so don't blame me if\n\
something goes wr.....\n\
                    --- POOF!! ---\n\
You are engulfed in a cloud of sulfurous white smoke.  Coughing and\n\
gasping, you emerge from the smoke and find....\n",

     /* 83: */ "*\
Oh-oh!  I daresay you've done it again.  The reincarnation worked last\n\
time.  Do you want me to give it a go again? ",

     /* 84: */ "*\
Okay.  I used the white last time, let's see what this does.....\n\
\n\
                  | |  F O O P  | |\n\
OOPS!\n\
The smoke is a nauseous purple this time, and as it clears,\n",

     /* 85: */ "*\
I say there, this is becoming tiresome.  Shall we try again? ",

     /* 86: */ "*\
Right.  What does this do??\n\
\n\
                PPPP   OOO   OOO  FFFFF\n\
        X       P   P O   O O   O F          X\n\
      X   X     PPPP  O   O O   O FFFF     X   X\n\
        X       P     O   O O   O F          X\n\
                P      OOO   OOO  F\n\
\n\
My goodness, that was a good one!  Bilious black smoke encircles you,\n\
clearing to show that....\n",

     /* 87: */ "*\
You clumsy oaf, you've done it again.  I don't know how long I can keep\n\
this up.  Do you want me to try reincarnating you again? ",

     /* 88: */ "*\
Okay, now where did I put my orange smoke?....  >POOF!<\n\
Everything disappears in a dense cloud of orange smoke.\n",

     /* 89: */ "*\
Now you've really done it.  I'm out of colored smoke.  You don't expect\n\
me to do a decent reincarnation without any colored smoke, do you? ",

     /* 90: */ "*\
Okay, if you're so smart, do it yourself!  I'm leaving!\n",

     /* 91: */ "*\
Sorry, but I can no longer seem to remember how it was you got here.\n",

     /* 92: */ "*\
You can't carry anything more.  You'll have to drop something first.\n",

     /* 93: */ "\
You already have a saved game.  Do you want to overwrite it? ",

     /* 94: */ "\
I believe what you want is right here with you.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 95: */ "\
Bugbears are great hairy goblin giants.  Despite their size and shambling\n\
gait, they move very quietly and attack without warning whenever they can.\n",

     /* 96: */ "\
With a grate of dry bones, the skeleton stands!  It is coming after you!\n",

     /* 97: */ "\
As you drop the chest, the skeleton crumples to the ground.\n",

     /* 98: */ "\
You're not carrying anything.\n",

     /* 99: */ "You are currently carrying the following:\n",

     /* 100: */ "*\
You can't get past the skeleton.\n",

     /* 101: */ "\
The skeleton swings at you and misses!\n",

     /* 102: */ "*\
The skeleton swings at you...He gets you!\n",

     /* 103: */ "\
You fool, dwarves eat only coal.  Now you've made him really mad..\n",

     /* 104: */ "*\
You have nothing in which to carry it.\n",

     /* 105: */ "*\
You can't cut that!\n",

     /* 106: */ "*\
There is nothing here with which to fill it.\n",

     /* 107: */ "*\
The rope is anchored.  You will have to untie it first.\n",

     /* 108: */ "*\
If you cut it again, it will be too short to be useful.\n",

     /* 109: */ "*\
You can't fill that.\n",

     /* 110: */ "*\
Don't be ridiculous.\n",

     /* 111: */ "\
You clutch convulsively at the rocks, but you are falling...\n",

     /* 112: */ "\
There is a sullen glow from the ruby.\n",

     /* 113: */ "*\
The Ranger comments:\n\
\"You've been to the pig sinkhole.  You can't come in here smelling like\n\
that.  Go take a shower!\"\n",

     /* 114: */ "*\
How, by swimming?\n",

     /* 115: */ "*\
The Ranger won't let you in without paying.\n",

     /* 116: */ "*\
The dwarves' knives vanish as they strike the walls of the cave.\n",

     /* 117: */ "*\
Something with you won't fit.  You had best take inventory and drop\n\
something.\n",

     /* 118: */ "\
The boat is tied.\n",

     /* 119: */ "*\
The boat won't fit.\n",

     /* 120: */ "*\
You quickly discover that you are unable to swim (or to breathe under\n\
water).  Unfortunately, I don't know how to swim either.  You have just\n\
drowned.\n",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 121: */ "*\
Are you trying to get further into the cave? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 122: */ "\
The water behind the dam is higher, and thus must be the source.  If you\n\
can lower the water level back there, you may be able to get through.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 123: */ "\
In the time maze, there are paths in all directions, both past and future.\n",

     /* 124: */ "*\
A compelling force prevents you from moving in that direction.\n",

     /* 125: */ "\
After a few steps, you are thrown violently back.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 126: */ "\
The scroll seems to be held tightly wound by a powerful magic force.\n\
Peering in the ends reveals some archaic writing in the form of a poem\n\
or perhaps an incantation, but I am unable to decipher any of it for you.\n",

     /* 127: */ "\
There is a faint curse from the darkness behind you.\n",

     /* 128: */ "\
Out from the shadows behind you pounces a bearded pirate.  \"Har, har,\" he\n\
chortles, \"I'll just take all this booty and hide it away with me chest,\n\
deep in the grotto!\"  He snatches your treasure and vanishes into the\n\
gloom.\n",

     /* 129: */ "*\
A sepulchral voice reverberating through the cave, says, \"Cave closing\n\
soon.  All spelunkers exit immediately through Main Office.\"\n",

     /* 130: */ "*\
A mysterious recorded voice groans into life and announces:\n\
\"This exit is closed.  Please leave via Main Office.\"\n",

     /* 131: */ "*\
It looks as though you're dead.  Well, seeing as how the cave has closed\n\
anyway, I think we'll just call it a day.\n",

     /* 132: */ "*\
The sepulchral voice intones, \"The cave is now closed.\"  As the echoes\n\
fade, there is a blinding flash of light (and a small puff of white\n\
smoke). . . . You immediately feel the menacing presence of hundreds of\n\
pairs of unseen eyes upon you.  As your eyes re-focus, you look around\n\
and find. . .\n",

     /* 133: */ "*\
Stunned and almost drowned, you manage to swim to the nearby shore.\n",

     /* 134: */ "*\
Stunned, you drop all your treasures (which sink to the bottom, out of\n\
reach).  Almost drowned, you manage to swim to the nearby shore.\n",

     /* 135: */ "*\
Grendl pounces - - -\n\
and gets you!\n",

     /* 136: */ "*\
It doesn't seem to work here.\n",

     /* 137: */ "\
Grendl pounces - - -\n\
but luckily falls upon your sword, and dies!!\n",

     /* 138: */ "\
I daresay whatever you want is around here somewhere.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 139: */ "\
I don't know the word \"STOP\". Use \"QUIT\" if you want to give up.\n",

     /* 140: */ "*\
You can't get there from here.\n",

     /* 141: */ "\
The axe bounces off harmlessly, and falls to one side.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 142: */ MSG142,		/************ message too long, so fiddle *********/

     /* 143: */ "*\
From what?\n",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 144: */ "*\
Are you trying to return to the time maze? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 145: */ "\
In the time maze, there are paths in all directions, both past and\n\
future.  (You could have gotten this hint for free if you had asked me.)\n",

     /* 146: */ "*\
It is beyond your power to do that.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 147: */ "*\
I don't know how.\n",

     /* 148: */ "\
The spices fly through the air, forming a fine cloud.  The dragon rears\n\
back triumphantly, ready to blast you, when the spices make him sneeze\n\
explosively, and his fire is extinguished.  A very crestfallen and woe-\n\
begone dragon looks up at you and says \"Mind if I tag along, Boss?\"\n",

     /* 149: */ "\
You killed a little dwarf.  The body vanishes in a cloud of greasy black\n\
smoke.\n",

     /* 150: */ "\
You killed the kobold.  The body vanishes in a could of black smoke.\n",

     /* 151: */ "\
The bugbear grabs the keys and unlocks the chain.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 152: */ "\
That was intended as a rhetorical question.\n",

     /* 153: */ "\
For a moment, you are dangling precariously from the end of a 60 foot\n\
section of rope above an 80 foot drop...\n\
I am taking the liberty of assisting you back up the rope.\n",

     /* 154: */ "\
We're already flying.\n",

     /* 155: */ "*\
On what?\n",

     /* 156: */ "\
Okay, from now on I'll only describe a place in full the first time you\n\
come to it.  To get the full description, say \"LOOK\".\n",

     /* 157: */ MSG157,		/* part 1 of HELP text */

     /* 158: */ MSG158,		/* part 2 of HELP text */

     /* 159: */ NULL,

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 160: */ "\
The balrog is a hideous creature of immense strength who dwells in dark,\n\
forbidding places.  He fears nothing and strikes out violently at any-\n\
thing which disturbs him.\n",

     /* 161: */ "*\
You are halfway down the windshaft and falling rapidly.  It seems that\n\
you were transported to just above where the shelf used to be.\n\
The next thing you know...\n",

     /* 162: */ "\
There is a rumbling sound deep within the earth.\n",

     /* 163: */ "\
Your speaking started a rock slide.  One particularly large rock hit the\n\
shelf, destroying it totally.\n",

     /* 164: */ "\
The axe misses and lands near the bugbear where you can't get at it.\n",

     /* 165: */ "*\
With what?  Your bare hands?  Against his bear hands?\n",

     /* 166: */ "\
Okay, but I hope you weren't counting on the dragon eating that!\n",

     /* 167: */ "\
The rope has a knot in it, so I think I'll just untie it for you.\n",

     /* 168: */ "\
If you cut it now, the rope will fall and you'll lose it.\n",

     /* 169: */ NULL,

     /* 170: */ NULL,

     /* 171: */ NULL,

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 172: */ "*\
Do you need help getting into the hole? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 173: */ "\
In order to multiply your treasure further, something you already know\n\
must be divided.\n",

     /* 174: */ "*\
There is nothing here to eat.\n",

     /* 175: */ "*\
Do you want the hint? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 176: */ "*\
Do you need help getting out of the maze? ",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 177: */ "\
You can make the passages look less alike by dropping things.\n",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 178: */ "\
When lost in the woods, the safest approach is to stay in one place and\n\
wait for someone to find you.  Since nobody is likely to find you in here\n\
if you just wait, I recommend that you head down whenever possible and\n\
try to find the river by the cave entrance.\n",

/* NOTE: coordinated with the 'hints' array in cvlocs.c */
     /* 179: */ "*\
Do you need help getting out of the woods? ",

     /* 180: */ "\
Only the lamp can be turned on or off.\n",

     /* 181: */ "\
Your lamp was already on.\n",

     /* 182: */ "\
Your lamp was already off.\n",

     /* 183: */ "\
Your lamp is getting dim.  You'd best start wrapping this up, unless you\n\
can find some fresh batteries.  I seem to recall there were some in the\n\
timemaze.\n",

     /* 184: */ "\
Your lamp has run out of power.\n",

     /* 185: */ "*\
There's not much point in wandering around out here, and you can't\n\
explore the cave without a lamp.  So let's just call it a day.\n",

     /* 186: */ "\
There is a faint curse from the darkness behind you.  As you turn toward\n\
it, the beam of your lamp falls across a bearded pirate.  He is carrying\n\
a large chest.  \"Shiver me timbers!\" he cries, \"I've been spotted.\n\
I'd best hie meself off to the grotto to hide me chest.\"  With that, he\n\
vanishes into the gloom.\n",

     /* 187: */ "\
Your lamp is getting dim.  You'd best go back for those batteries.\n",

     /* 188: */ "\
Your lamp is getting dim.  I'm taking the liberty of replacing the\n\
batteries.\n",

     /* 189: */ "\
Your lamp is getting dim, and you're out of spare batteries.  You'd best\n\
start wrapping this up.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 190: */ "\
\"In Cornwall there was a Stone of power -- the Seige Perilous.  It was\n\
said to be able to judge a man, determine his worth, and then deliver him\n\
to his fate.  Arthur was supposed to have learned of its power from\n\
Merlin, and incorporated it among the seats of the Round Table.\"\n",

     /* 191: */ "\
Thank you, how refreshing to relax.  These old bones are not what they\n\
used to be.\n",

     /* 192: */ "\
We're already sitting.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 193: */ "\
The Djinn are free-willed, intelligent, air-elemental spirits.  They will\n\
not harm you, but may aid you if they are present.\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 194: */ "\
Kobolds are evil, dwarf-like creatures, more closely related to goblins.\n\
They are more dangerous than dwarves, however.\n",

     /* 195: */ "*\
I'm afraid I don't understand.\n",

     /* 196: */ "*\
The bugbear gets you, and gives you a big bear hug, breaking every bone\n\
in your body!\n",

     /* 197: */ "\
Okay.\n\
Oops. . .\n\
Sorry about that. . .\n\
How clumsy of me. . .\n",

     /* 198: */ "*\
How, by flying?\n",

     /* 199: */ "\
The wind catches the carpet, capsizing it and dropping you off!\n\
Unburdened, it sails off as you plummet to the bottom!\n",

     /* 200: */ "*\
Is this acceptable? ",

     /* 201: */ "\
There's no point in suspending a demonstration game.\n",

     /* 202: */ "\
I can't find it in the dark.\n",

     /* 203: */ "\
The dragon belches forth a ball of flame in your direction, which misses.\n\
You are unable to pick up anything though, because of the heat.\n",

     /* 204: */ "*\
There is nothing here to tie the rope around.\n",

     /* 205: */ "*\
You have no rope.\n",

     /* 206: */ "*\
Your rope will not reach.\n",

     /* 207: */ "*\
You have nothing to cut with.\n",

     /* 208: */ "*\
Due to your sloppy workmanship, the knot in the rope has come untied\n\
while you were halfway down.  You have fallen 45 feet onto some very\n\
sharp rocks.\n",

     /* 209: */ "\
Okay.\n\
The Djinni, his service finished, vanishes.\n",

     /* 210: */ "*\
Seven men, wearing grey business suits and carrying briefcases, surround\n\
you and identify themselves as representatives of the Internal Revenue\n\
Service!  With absolutely no show of emotion, they report:\n\
    \"We understand that you have been accumulating some un-declared\n\
     income.  We wish to discuss this matter with you.\"\n\
You have been taxed to death!\n",

     /* 211: */ "*\
The way is blocked.\n",

     /* 212: */ "*\
An immense white dragon lumbers out of the door, breathing incandescently\n\
hot balls of fire at you, all of which get you!  He then beats you\n\
severely about the head and shoulders with his wings, which have long,\n\
sharp talons on the edges!  He finally jumps up and down on you, over and\n\
over and over and over and over and over and over and...You get the idea.\n\
You are dead.\n",

     /* 213: */ "*\
The guard, Patrolman Pete, comes running out of the doorway, waving his\n\
pistol and shouting:\n\
     \"This area is off-limits.  You shouldn't come here.\"\n\
Just then, he trips and falls.  The gun discharges, putting a bullet\n\
through your heart.  You are dead!\n",

     /* 214: */ "\
As you speak, several large rocks drop down the shaft and carom off the\n\
shelf.  While they narrowly miss you, they raise a great cloud of dust\n\
and start numerous cracks in the rock.\n",

     /* 215: */ "\
You miss but manage to catch the near edge of the bridge and swing back\n\
up onto it.\n",

     /* 216: */ "\
You just manage to catch the far edge of the bridge and swing up onto it.\n",

     /* 217: */ "\
Things are looking awfully bleak.\n",

     /* 218: */ "\
Jump!\n",

     /* 219: */ "\
You drop through an impenetrable gloom.  Oppressive fear gathers, clawing\n\
at you.  You are sinking into the depths of Hell, with no salvation in\n\
sight.  The clammy, black air whistling past is the only sound filling\n\
your fear-crazed mind.  You are tumbling endlessly, spinning over and\n\
over.  Suddenly, you feel your descent slowing!  With a rush, you finally\n\
come to a landing and find...\n",

     /* 220: */ "*\
All directions are down.  Please be more specific.\n",

     /* 221: */ "*\
I don't know how to play such a thing.\n",

     /* 222: */ "\
The sweet music attracts the unicorn.\n",

     /* 223: */ "*\
The orc priest grabs you and efficiently converts you into a pile of\n\
greasy rubble!\n",

     /* 224: */ "\
You drop through an impenetrable gloom.  Oppressive fear gathers, clawing\n\
at you.  You are sinking into the depths of Hell, with no salvation in\n\
sight.  The clammy, black air whistling past is the only sound filling\n\
your fear-crazed mind.  You are tumbling endlessly, spinning over and\n\
over.  Below you, a roar arises from an unseen source, and gets louder\n\
and louder!!  Suddenly, you break into a lighted area, and immediately\n\
crash into the depths of an almost bottomless pool of water!\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 225: */ "\
Hey!  Watch it!  This adventure is rated \"G\"\n",

/* NOTE: The following message is number-coordinated with vocabulary
		section 3.  BEWARE. */
     /* 226: */ "\
Unicorns are magical creatures.  Though immortal in ordinary terms, they\n\
are frequently prey to careless arrows or deceitful behavior.  Their\n\
shyness is legendary, although they will often overcome their fear to\n\
befriend a virgin or to help one in mortal peril.  It is said that a\n\
unicorn's horn is proof against death!\n",

     /* 227: */ "\
Are you a wizard? ",

     /* 228: */ "\
Very well.\n",

     /* 229: */ "\
Do you wish to change the message of the day? "
};
