/* cvocab.h
 *    the crystal cave vocabulary
 ************************************************************************/

struct cvocab {
    int cvcode;
    char *cvword;
};

#define	NORTH	2
#define	NE	3
#define	EAST	4
#define	SE	5
#define	SOUTH	6
#define	SW	7
#define	WEST	8
#define	NW	9
#define	UP	10
#define	DOWN	11
#define OUT	12
#define	IN	13
#define ENTER	14
#define	JUMP	15
#define BARN	16
#define PRIVY	17
#define SHAFT	18
#define SINKH	19
#define PIGPE	20
#define BLUFF	21
#define	HEADQ	22
#define	M_GATE	23
#define LAKE	24
#define	FIELD	25
#define	BACK	27
#define	WAIT	28
#define	CROSS	29
#define	HOPE	30
#define UPSTR	31
#define DOWNS	32
#define	CLIMB	33
#define	PATH	34
#define	PAST	35
#define	FUTUR	36
#define	BANIS	37
#define	MISFO	38

/* some objects */

#define	MINTRS	(&(cvobj[1]))
#define	_JEWLRY	1003
#define	_CHEST	1005
#define	_CAPE	1006
#define	_CROWN	1007
#define	_SCEPT	1008
#define	_ORB	1010
#define	_IDOL	1011
#define	_RUG	1012
#define	_UNICRN	1013
#define	_CHAIN	1014
#define	_RING	1015
#define	_HELM	1016
#define	_THRONE	1018
#define	_SWORD	1019
#define	_HAMMER	1020
#define	_CUP	1021
#define	_MEDAL	1022
#define	_SCROLL	1023
#define	_HARP	1024
#define	_STONE	1025
#define	_KEG	1026
#define	ENDTRS	OBJ(1027)
#define	IFTREAS(o)	((o) < ENDTRS)

#define	MINWPN	OBJ(1027)
#define	MAXWPN	OBJ(1034)

#define	MINART	OBJ(1040)
#define	_COLUMN	1040
#define	MAXART	OBJ(1047)

#define	_COMPASS	1050
#define	_KEY	1051
#define	_LAMP	1052
#define	_RICK	1053
#define	_SEARS	1054
#define	_WALLET	1055
#define	_DOOR	1056
#define	_BRIDGE	1057
#define	_BOAT	1058
#define	_DAM	1059
#define	_O_GATE	1060
#define	_ROPE	1061
#define	_ROPE2	(_ROPE+1)
#define	_EROPE	(_ROPE+2)
#define	_EROPE2	(_ROPE+3)
#define	_SPICE	1067
#define	_KNIFE	1068
#define	_FOOD	1069
#define	_BOTTLE	1070
#define	_WATER	1071
#define	_WINE	1072
#define	_COLA	1073
#define	_MIRROR	1074
#define	_GIANT	1075
#define	_ORCS	1076
#define	_TOMB	1077
#define	_AXE	1078
#define	_TOAD	1079
#define	_SAND	1080
#define	_SHELF	1081
#define	_HANG	1082
#define	_CRAP	1086
#define	_SHOWER	1087
#define	_VEND	1088
#define	_BATTER	1089
#define	_DWARF	1090
#define	_BEAR	1091
#define	_SKELTN	1092
#define	_SPIDER	1093
#define	_DRAGON	1094
#define	_DJINN	1095
#define	_KOBOLD	1096
#define	_BALROG	1097
#define	_SELF	1098

/* verb section */

#define TAKE	2001
#define	DROP	2002
#define	ON	2003
#define	OFF	2004
#define	UNLOC	2005
#define	LOCK	2006
#define	SAY	2007
#define	RUB	2008
#define	FIND	2009
#define	INVENT	2010
#define	QUIT	2011
#define	SCORE	2012
#define	NOTHI	2013
#define	SAVE	2014
#define	BRIEF	2015
/* HOURS not implemented */
#define	THROW	2017
#define	WALK	2018
#define	PAY	2019
#define	BREAK	2020
#define	DRINK	2021
#define	EAT	2022
#define	READ	2023
#define	TIE	2024
#define	UNTIE	2025
#define	FEED	2026
#define	POUR	2027
#define	KILL	2028
#define	RIG	2029
#define	CUT	2030
#define	FILL	2031
#define	TEST	2032
#define	BLAST	2033
#define	WAVE	2034
#define	SIT	2035
#define	CALM	2036
#define	FLY	2037
#define	WAKE	2038
#define	DESCRB	2039
#define TOUCH	2040
#define	PLAY	2041
#define RESTOR	2042
#define	HELP	2043

/* define object references */

#define	OBJ(o)	(&(cvobj[(o) % 1000]))

#define	JEWLRY	OBJ(_JEWLRY)
#define	CHEST	OBJ(_CHEST)
#define	CAPE	OBJ(_CAPE)
#define	CROWN	OBJ(_CROWN)
#define	SCEPT	OBJ(_SCEPT)
#define	ORB	OBJ(_ORB)
#define	IDOL	OBJ(_IDOL)
#define	RUG	OBJ(_RUG)
#define	UNICRN	OBJ(_UNICRN)
#define	CHAIN	OBJ(_CHAIN)
#define	RING	OBJ(_RING)
#define	HELM	OBJ(_HELM)
#define	THRONE	OBJ(_THRONE)
#define	SWORD	OBJ(_SWORD)
#define	HAMMER	OBJ(_HAMMER)
#define	CUP	OBJ(_CUP)
#define	MEDAL	OBJ(_MEDAL)
#define	SCROLL	OBJ(_SCROLL)
#define	HARP	OBJ(_HARP)
#define	STONE	OBJ(_STONE)
#define	KEG	OBJ(_KEG)
#define	COLUMN	OBJ(_COLUMN)
#define	COMPASS	OBJ(_COMPASS)
#define	KEY	OBJ(_KEY)
#define	LAMP	OBJ(_LAMP)
#define	RICK	OBJ(_RICK)
#define	SEARS	OBJ(_SEARS)
#define	WALLET	OBJ(_WALLET)
#define	DOOR	OBJ(_DOOR)
#define	BRIDGE	OBJ(_BRIDGE)
#define	BOAT	OBJ(_BOAT)
#define	DAM	OBJ(_DAM)
#define	O_GATE	OBJ(_O_GATE)
#define	ROPE	OBJ(_ROPE)
#define	ROPE2	OBJ(_ROPE2)
#define	EROPE	OBJ(_EROPE)
#define	EROPE2	OBJ(_EROPE2)
#define	SPICE	OBJ(_SPICE)
#define	KNIFE	OBJ(_KNIFE)
#define	FOOD	OBJ(_FOOD)
#define	BOTTLE	OBJ(_BOTTLE)
#define	WATER	OBJ(_WATER)
#define	WINE	OBJ(_WINE)
#define	COLA	OBJ(_COLA)
#define	MIRROR	OBJ(_MIRROR)
#define	GIANT	OBJ(_GIANT)
#define	ORCS	OBJ(_ORCS)
#define	TOMB	OBJ(_TOMB)
#define	AXE	OBJ(_AXE)
#define	TOAD	OBJ(_TOAD)
#define	SAND	OBJ(_SAND)
#define	SHELF	OBJ(_SHELF)
#define	HANG	OBJ(_HANG)
#define	CRAP	OBJ(_CRAP)
#define	SHOWER	OBJ(_SHOWER)
#define	VEND	OBJ(_VEND)
#define	BATTER	OBJ(_BATTER)
#define	DWARF	OBJ(_DWARF)
#define	BEAR	OBJ(_BEAR)
#define	SKELTN	OBJ(_SKELTN)
#define	SPIDER	OBJ(_SPIDER)
#define	DRAGON	OBJ(_DRAGON)
#define	DJINN	OBJ(_DJINN)
#define	KOBOLD	OBJ(_KOBOLD)
#define	BALROG	OBJ(_BALROG)
#define	SELF	OBJ(_SELF)
