/* cvspk.c
 *************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "cvmsg.h"
#include "cvobj.h"
#include "cvlocs.h"
#include "cvocab.h"

#define	TRUE	(1)
#define	FALSE	(0)

extern struct hint hints[];
extern struct cvocab vtab[];
extern char *rmsg[];
extern char *mmsg[];
extern struct cmsg ctext[];
extern int blklin, mltcmd, samvrb;

extern void bug();
extern void exit();

void
putcode(msg)
char *msg;
{
    fputs(msg, stdout);
}

void
rspeak(num)
int num;
{
    char *msg;

    msg = rmsg[num];

    if (num == 54)
	blklin = FALSE;

    if (*msg == '*') {
	++msg;
	mltcmd = FALSE;
    }

    putcode(msg);
}

void
mspeak(num)
int num;
{
    fputs(mmsg[num], stdout);
}

void
pspeak(obj, prop)
struct cvobj *obj;
int prop;
{
    char *msg = obj->props;
    int i = 0, pos = 0, start = 0, end, last = 0;

    while (pos <= prop) {
	if (msg[i] == '\0') last = 1;

	if (msg[i] == '~' || msg[i] == '\0') {
	    if (pos == prop) end = i;
	    pos++;
	    if (pos == prop) start = i+1;
	}

	i++;
    }

    if (!last) msg[end] = '\0';
    putcode(msg+start);
    if (!last) msg[end] = '~';
}

int
yes(quest, agree, refuse)
int quest, agree, refuse;
{
    auto char answer[8];
    int i;

    for (;;) {
	if (quest)
	    rspeak(quest);
	if (fgets(answer, 6, stdin) == NULL) {
	    *answer = '\0';
	}
	if (!strlen(answer) || answer[strlen(answer) - 1] != '\n') {
	    while (getchar() != '\n');
	    answer[0] = '\n';	/* these are error cases */
	}
	for (i = 0; i < 5; ++i) {
	    if (answer[i] == '\n') {
		answer[i] = '\0';
		break;
	    } else
		answer[i] = tolower(answer[i]);
	}
	if (!cvstrcmp("y", answer) || !cvstrcmp("yes", answer)) {
	    if (agree)
		rspeak(agree);
	    return (TRUE);
	}
	if (!cvstrcmp("no", answer) || !cvstrcmp("n", answer)) {
	    if (refuse)
		rspeak(refuse);
	    return (FALSE);
	}

	fputs("\nPlease answer the question.\n", stdout);
    }
}

static char cchar = '\0';
static char *tmpchr;

/* routine to get the character pointed-to by tmpchr.
 * result to cchar
 * and mltcmd turned off if space-comma or space-period.
 */
static void
gchar()
{
    static char lchar;

    lchar = cchar;
    cchar = *(tmpchr++);
    if ((lchar == ' ')
	&& ((cchar == '.') || (cchar == ','))
	) {
	mltcmd = FALSE;
	cchar = '\0';
    }
}

/* gather a word, put terminator in cchar. */
static char *
gather()
{
    char *r;

    do {
	gchar();
    } while (cchar == ' ');
    if ((cchar == '\0') || (cchar == '.') || (cchar == ','))
	return (NULL);
    r = tmpchr;

    for (;;) {
	gchar();
	if ((cchar == '\0')
	    || (cchar == '.')
	    || (cchar == ',')
	    || (cchar == ' ')) {
	    *(tmpchr - 1) = '\0';
	    return (--r);
	}
    }
}

void
getin()
{
    extern char *word1, *word2;
    extern char *getline();

    static char ca1[81], ca2[81];
    char *cp2, *cp1;
    char *line;

    for (;; mltcmd = FALSE) {
	word1 = word2 = NULL;
	if (mltcmd) {
	    if ((cchar != '.') && (cchar != ','))
		continue;
	    samvrb = (cchar == ',');
	} else {
	    if (blklin)
		fputs("\n", stdout);

	    /* Slurp in a line */
	    line = getline("> ");
	    if (line == NULL) {
		fputs("\n\nBut, but, ... okay, goodbye.\n", stdout);
		gameover(1);
	    } else {
		strncpy(ca1, line, 80);
	    }

            if (strcmp(line, "") == 0)
                fputs("\nHuh?\n", stdout);

	    /* Convert to lower case */
	    for (cp1 = ca1; *cp1 != '\0'; ++cp1)
		*cp1 = (char) tolower((int) *cp1);

	    mltcmd = TRUE;
	    if (cvstrcmp(ca1, "again")
		&& cvstrcmp(ca1, "repeat")
		&& cvstrcmp(ca1, "ditto")
		&& cvstrcmp(ca1, "\"")
		&& cvstrcmp(ca1, "''")) {
		cp1 = ca1, cp2 = ca2;	/* set to preserve new command */
	    } else {
		cp1 = ca2, cp2 = ca1;	/* set to repeat old command */
	    }
	    while ((*(cp2++) = *(cp1++)) != '\0');	/* end AFTER the null */
	    tmpchr = ca1;
	    samvrb = FALSE;
	}
/* now have the input in 'ca1' */
/* and tmpchr points to the next char to see */

	if ((word1 = gather()) == NULL)
	    continue;
	if (cchar == ' ')
	    word2 = gather();
	return;
    }				/* end of for (implied mltcmd = FALSE) */
}

int
vocab(word, sect)
char *word;
int sect;
{
    int matched = 0, len;
    struct cvocab *curv = vtab, *likely = NULL;

    if (word == NULL)
	return (-1);

    len = strlen(word);

    if (sect >= 0) {
	for (; curv->cvcode != 0; ++curv) {
	    if (curv->cvcode / 1000 == sect)
		break;
	}
    }
    for (; curv->cvcode != 0; ++curv) {
	if ((sect >= 0) && ((curv->cvcode / 1000) > sect))
	    break;
	;
	if (!strncmp(word, curv->cvword, (size_t) len)) {
	    ++matched;
	    likely = curv;
	    if (strlen(curv->cvword) == (size_t) len)
		return (curv->cvcode);
	}
    }

    if (matched == 1)
	return (likely->cvcode);
    else
	return (-1);
}
