C REV. 22
C  ADVENTURES
        SUBROUTINE INIT
C
C MODIFIED BY KENT BLACKETT
C             ENGINEERING SYSTEMS GROUP
C             DIGITAL EQUIPMENT CORP.
C             15-JUL-77
C ORIGINAL VERSION WAS FOR DECSYSTEM-10
C THIS VERSION IS FOR FORTRAN IV-PLUS UNDER
C THE IAS OPERATING SYSTEM ON THE PDP-11/70
C NOTE THAT IT MUST BE COMPILED WITH THE
C /WF:3/I4 SWITCHES...
C
C  CURRENT LIMITS:
C       750 TRAVEL OPTIONS (TRAVEL, TRVSIZ).
C       300 VOCABULARY WORDS (KTAB, ATAB, TABSIZ).
C       150 LOCATIONS (LTEXT, STEXT, KEY, COND, ABB, ATLOC, LOCSIZ).
C       100 OBJECTS (PLAC, PLACE, FIXD, FIXED, LINK (TWICE), PTEXT, PROP).
C        35 "ACTION" VERBS (ACTSPK, VRBSIZ).
C       205 RANDOM MESSAGES (RTEXT, RTXSIZ).
C        12 DIFFERENT PLAYER CLASSIFICATIONS (CTEXT, CVAL, CLSMAX).
C        20 HINTS, LESS 3 (HINTLC, HINTED, HINTS, HNTSIZ).
C        35 MAGIC MESSAGES (MTEXT, MAGSIZ).
C  THERE ARE ALSO LIMITS WHICH CANNOT BE EXCEEDED DUE TO THE STRUCTURE OF
C  THE DATABASE.  (E.G., THE VOCABULARY USES N/1000 TO DETERMINE WORD TYPE,
C  SO THERE CAN'T BE MORE THAN 1000 WORDS.)  THESE UPPER LIMITS ARE:
C       1000 NON-SYNONYMOUS VOCABULARY WORDS
C       300 LOCATIONS
C       100 OBJECTS
      INTEGER VRBSIZ
       INTEGER*2 KTAB,LTEXT,STEXT,KEY,COND,ABB,ATLOC,PLAC,
     1 PLACE,FIXD,FIXED,LINK,PTEXT,PROP,ACTSPK,RTEXT,CTEXT,CVAL,
     2 HINTLC,HINTS,MTEXT,DLOC,ODLOC,ASCVAR,ASC2,ASC3
        LOGICAL DSEEN,BLKLIN,HINTED,YES,START
        LOGICAL TOTING,HERE,AT,BITSET,DARK,WZDARK,LMWARN,CLOSNG,PANIC,
     1       CLOSED,GAVEUP,SCORNG,DEMO,YEA
      INTEGER PBOTL,DUMMY
      INTEGER RTEXT,ASCVAR
      INTEGER KTAB,TABSIZ
      INTEGER ATLOC,LINK,PLACE,FIXED,HOLDNG
      LOGICAL BUF(128)
      INTEGER ITK(20)
      INTEGER MTEXT
      INTEGER PTEXT
      INTEGER ABB
      INTEGER WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1       SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
      INTEGER LINUSE,TRVS,CLSSES,OLDLOC,LOC,CVAL,NEWLOC,
     1 KEY,PLAC,FIXD,ACTSPK,COND,HINTS,HNTMAX,PROP,TALLY,TALLY2,
     2 HINTLC,CHLOC,CHLOC2,DFLAG,DLOC,DALTLC,KEYS,LAMP,GRATE,
     3 CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE,FISSUR,TABLET,
     4 CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,BOTTLE,WATER,OIL,PLANT,
     5 PLANT2,AXE,MIRROR,DRAGON,CHASM,TROLL,TROLL2,BEAR,MESSAG,VEND,
     6 BATTER,NUGGET,COINS,CHEST,EGGS,TRIDNT,VASE,EMRALD,PYRAM,
     7 PEARL,RUG,CHAIN,BACK,LOOK,CAVE,NULL,ENTRNC,DPRSSN,SAY,LOCK,
     8 THROW,FIND,INVENT,TURNS,IWEST,KNFLOC,DETAIL,ABBNUM,
     9 NUMDIE,MAXDIE,DKILL,FOOBAR,BONUS,CLOCK1,CLOCK2
      INTEGER I,RTXSIZ,CLSMAX,MAGSIZ,LOCSIZ,CTEXT,STEXT,LTEXT,
     1 SECT,TRAVEL,TRVSIZ,TABNDX,OBJ,J,K,VERB,HNTSIZ,MAXTRS,
     2 HNTLOC,KK
        REAL LINES(15),LINES2(15,2)
      LOGICAL TK,LIQ2,LIQ,LIQLOC,FORCED,PCT
      LOGICAL LTMP
        INTEGER TRAVEL(3,750)
      INTEGER VOCAB,RAN
        INTEGER KTAB(300)
      REAL ATAB(300)
	INTEGER LOC2(2)
C
      LOGICAL LLINES(60),CR,BL
C
        INTEGER LTEXT(150),STEXT(150),KEY(150),COND(150),ABB(150),
     1        ATLOC(150)
        INTEGER PLAC(100),PLACE(100),FIXD(100),FIXED(100),LINK(200),
     1        PTEXT(100),PROP(100)
        INTEGER ACTSPK(35)
        INTEGER RTEXT(205)
        INTEGER CTEXT(12),CVAL(12)
        DIMENSION HINTLC(20),HINTED(20),HINTS(20,4)
        INTEGER MTEXT(35)
        DIMENSION TK(20),DSEEN(6),DLOC(6),ODLOC(6),HNAME(4)
C
      COMMON /INCOM/ TRAVEL
        COMMON /TXTCOM/ RTEXT,LINES,ASCVAR
        COMMON /BLKCOM/ BLKLIN
        COMMON /VOCCOM/ KTAB,ATAB,TABSIZ
        COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,HOLDNG
        COMMON /MTXCOM/ MTEXT
        COMMON /PTXCOM/ PTEXT
        COMMON /ABBCOM/ ABB
        COMMON /WIZCOM/ WKDAY,WKEND,HOLID,HBEGIN,HEND,HNAME,
     1       SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP
        COMMON /MISCOM/ LINUSE,TRVS,CLSSES,OLDLOC,LOC,CVAL,TK,NEWLOC,
     1 KEY,PLAC,FIXD,ACTSPK,COND,HINTS,HNTMAX,PROP,TALLY,TALLY2,
     2 HINTLC,CHLOC,CHLOC2,DSEEN,DFLAG,DLOC,DALTLC,KEYS,LAMP,GRATE,
     3 CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE,FISSUR,TABLET,
     4 CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,BOTTLE,WATER,OIL,PLANT,
     5 PLANT2,AXE,MIRROR,DRAGON,CHASM,TROLL,TROLL2,BEAR,MESSAG,VEND,
     6 BATTER,NUGGET,COINS,CHEST,EGGS,TRIDNT,VASE,EMRALD,PYRAM,
     7 PEARL,RUG,CHAIN,BACK,LOOK,CAVE,NULL,ENTRNC,DPRSSN,SAY,LOCK,
     8 THROW,FIND,INVENT,TURNS,LMWARN,IWEST,KNFLOC,DETAIL,ABBNUM,
     9 NUMDIE,MAXDIE,DKILL,FOOBAR,BONUS,CLOCK1,CLOCK2,
     1 CLOSNG,PANIC,CLOSED,GAVEUP,SCORNG
        COMMON /MISC2/ I,RTXSIZ,CLSMAX,MAGSIZ,LOCSIZ,CTEXT,STEXT,LTEXT,
     1 SECT,TRVSIZ,TABNDX,OBJ,J,K,VERB,HNTSIZ,MAXTRS,
     2 HINTED,HNTLOC,KK
C
      EQUIVALENCE(LINES(1),LLINES(1))
      DATA CR/X'0D'/,BL/' '/
      DATA KEY/150*0/
C
C  STATEMENT FUNCTIONS
C
C
C  TOTING(OBJ)  = TRUE IF THE OBJ IS BEING CARRIED
C  HERE(OBJ)    = TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)
C  AT(OBJ)      = TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT
C  LIQ(DUMMY)   = OBJECT NUMBER OF LIQUID IN BOTTLE
C  LIQLOC(LOC)  = OBJECT NUMBER OF LIQUID (IF ANY) AT LOC
C  BITSET(L,N)  = TRUE IF COND(L) HAS BIT N SET (BIT 0 IS UNITS BIT)
C  FORCED(LOC)  = TRUE IF LOC MOVES WITHOUT ASKING FOR INPUT (COND=2)
C  DARK(DUMMY)  = TRUE IF LOCATION "LOC" IS DARK
C  PCT(N)       = TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)
C
C  WZDARK SAYS WHETHER THE LOC HE'S LEAVING WAS DARK
C  LMWARN SAYS WHETHER HE'S BEEN WARNED ABOUT LAMP GOING DIM
C  CLOSNG SAYS WHETHER ITS CLOSING TIME YET
C  PANIC SAYS WHETHER HE'S FOUND OUT HE'S TRAPPED IN THE CAVE
C  CLOSED SAYS WHETHER WE'RE ALL THE WAY CLOSED
C  GAVEUP SAYS WHETHER HE EXITED VIA "QUIT"
C  SCORNG INDICATES TO THE SCORE ROUTINE WHETHER WE'RE DOING A "SCORE" COMMAND
C  DEMO IS TRUE IF THIS IS A PRIME-TIME DEMONSTRATION GAME
C  YEA IS RANDOM YES/NO REPLY
        TOTING(OBJ)=PLACE(OBJ).EQ.-1
        HERE(OBJ)=PLACE(OBJ).EQ.LOC.OR.TOTING(OBJ)
        AT(OBJ)=PLACE(OBJ).EQ.LOC.OR.FIXED(OBJ).EQ.LOC
        LIQ2(PBOTL)=(1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL)
        LIQ(DUMMY)=LIQ2(MAX0(PROP(BOTTLE),-1-PROP(BOTTLE)))
        LIQLOC(LOC)=LIQ2((MOD(COND(LOC)/2*2,8)-5)*MOD(COND(LOC)/4,2)+1)
      BITSET(L,N)=MOD(COND(L),2**(N+1))/(2**N)
        FORCED(LOC)=COND(LOC).EQ.2
        DARK(DUMMY)=MOD(COND(LOC),2).EQ.0.AND.(PROP(LAMP).EQ.0.OR.
     1       .NOT.HERE(LAMP))
        PCT(N)=RAN(100).LT.N
C  DESCRIPTION OF THE DATABASE FORMAT
C
C
C  THE DATA FILE CONTAINS SEVERAL SECTIONS.  EACH BEGINS WITH A LINE CONTAINING
C  A NUMBER IDENTIFYING THE SECTION, AND ENDS WITH A LINE CONTAINING "-1".
C
C  SECTION 1: LONG FORM DESCRIPTIONS.  EACH LINE CONTAINS A LOCATION NUMBER,
C       A COMMA, AND A LINE OF TEXT.  THE SET OF (NECESSARILY ADJACENT) LINES
C       WHOSE NUMBERS ARE X FORM THE LONG DESCRIPTION OF LOCATION X.
C  SECTION 2: SHORT FORM DESCRIPTIONS.  SAME FORMAT AS LONG FORM.  NOT ALL
C       PLACES HAVE SHORT DESCRIPTIONS.
C  SECTION 3: TRAVEL TABLE.  EACH LINE CONTAINS A LOCATION NUMBER (X), A SECOND
C       LOCATION NUMBER (Y), AND A LIST OF MOTION NUMBERS (SEE SECTION 4).
C       EACH MOTION REPRESENTS A VERB WHICH WILL GO TO Y IF CURRENTLY AT X.
C       Y, IN TURN, IS INTERPRETED AS FOLLOWS.  LET M=Y/1000, N=Y MOD 1000.
C               IF N<=300       IT IS THE LOCATION TO GO TO.
C               IF 300<N<=500   N-300 IS USED IN A COMPUTED GOTO TO
C                                       A SECTION OF SPECIAL CODE.
C               IF N>500        MESSAGE N-500 FROM SECTION 6 IS PRINTED,
C                                       AND HE STAYS WHEREVER HE IS.
C       MEANWHILE, M SPECIFIES THE CONDITIONS ON THE MOTION.
C               IF M=0          IT'S UNCONDITIONAL.
C               IF 0<M<100      IT IS DONE WITH M% PROBABILITY.
C               IF M=100        UNCONDITIONAL, BUT FORBIDDEN TO DWARVES.
C               IF 100<M<=200   HE MUST BE CARRYING OBJECT M-100.
C               IF 200<M<=300   MUST BE CARRYING OR IN SAME ROOM AS M-200.
C               IF 300<M<=400   PROP(M MOD 100) MUST *NOT* BE 0.
C               IF 400<M<=500   PROP(M MOD 100) MUST *NOT* BE 1.
C               IF 500<M<=600   PROP(M MOD 100) MUST *NOT* BE 2, ETC.
C       IF THE CONDITION (IF ANY) IS NOT MET, THEN THE NEXT *DIFFERENT*
C       "DESTINATION" VALUE IS USED (UNLESS IT FAILS TO MEET *ITS* CONDITIONS,
C       IN WHICH CASE THE NEXT IS FOUND, ETC.).  TYPICALLY, THE NEXT DEST WILL
C       BE FOR ONE OF THE SAME VERBS, SO THAT ITS ONLY USE IS AS THE ALTERNATE
C       DESTINATION FOR THOSE VERBS.  FOR INSTANCE:
C               15      110022  29      31      34      35      23      43
C               15      14      29
C       THIS SAYS THAT, FROM LOC 15, ANY OF THE VERBS 29, 31, ETC., WILL TAKE
C       HIM TO 22 IF HE'S CARRYING OBJECT 10, AND OTHERWISE WILL GO TO 14.
C               11      303008  49
C               11      9       50
C       THIS SAYS THAT, FROM 11, 49 TAKES HIM TO 8 UNLESS PROP(3)=0, IN WHICH
C       CASE HE GOES TO 9.  VERB 50 TAKES HIM TO 9 REGARDLESS OF PROP(3).
C  SECTION 4: VOCABULARY.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C       FIVE-LETTER WORD.  CALL M=N/1000.  IF M=0, THEN THE WORD IS A MOTION
C       VERB FOR USE IN TRAVELLING (SEE SECTION 3).  ELSE, IF M=1, THE WORD IS
C       AN OBJECT.  ELSE, IF M=2, THE WORD IS AN ACTION VERB (SUCH AS "CARRY"
C       OR "ATTACK").  ELSE, IF M=3, THE WORD IS A SPECIAL CASE VERB (SUCH AS
C       "DIG") AND N MOD 1000 IS AN INDEX INTO SECTION 6.  OBJECTS FROM 50 TO
C       (CURRENTLY, ANYWAY) 79 ARE CONSIDERED TREASURES (FOR PIRATE, CLOSEOUT).
C  SECTION 5: OBJECT DESCRIPTIONS.  EACH LINE CONTAINS A NUMBER (N), A TAB,
C       AND A MESSAGE.  IF N IS FROM 1 TO 100, THE MESSAGE IS THE "INVENTORY"
C       MESSAGE FOR OBJECT N.  OTHERWISE, N SHOULD BE 000, 100, 200, ETC., AND
C       THE MESSAGE SHOULD BE THE DESCRIPTION OF THE PRECEDING OBJECT WHEN ITS
C       PROP VALUE IS N/100.  THE N/100 IS USED ONLY TO DISTINGUISH MULTIPLE
C       MESSAGES FROM MULTI-LINE MESSAGES; THE PROP INFO ACTUALLY REQUIRES ALL
C       MESSAGES FOR AN OBJECT TO BE PRESENT AND CONSECUTIVE.  PROPERTIES WHICH
C       PRODUCE NO MESSAGE SHOULD BE GIVEN THE MESSAGE ">$<".
C  SECTION 6: ARBITRARY MESSAGES.  SAME FORMAT AS SECTIONS 1, 2, AND 5, EXCEPT
C       THE NUMBERS BEAR NO RELATION TO ANYTHING (EXCEPT FOR SPECIAL VERBS
C       IN SECTION 4).
C  SECTION 7: OBJECT LOCATIONS.  EACH LINE CONTAINS AN OBJECT NUMBER AND ITS
C       INITIAL LOCATION (ZERO (OR OMITTED) IF NONE).  IF THE OBJECT IS
C       IMMOVABLE, THE LOCATION IS FOLLOWED BY A "-1".  IF IT HAS TWO LOCATIONS
C       (E.G. THE GRATE) THE FIRST LOCATION IS FOLLOWED WITH THE SECOND, AND
C       THE OBJECT IS ASSUMED TO BE IMMOVABLE.
C  SECTION 8: ACTION DEFAULTS.  EACH LINE CONTAINS AN "ACTION-VERB" NUMBER AND
C       THE INDEX (IN SECTION 6) OF THE DEFAULT MESSAGE FOR THE VERB.
C  SECTION 9: LIQUID ASSETS, ETC.  EACH LINE CONTAINS A NUMBER (N) AND UP TO 20
C       LOCATION NUMBERS.  BIT N (WHERE 0 IS THE UNITS BIT) IS SET IN COND(LOC)
C       FOR EACH LOC GIVEN.  THE COND BITS CURRENTLY ASSIGNED ARE:
C               0       LIGHT
C               1       IF BIT 2 IS ON: ON FOR OIL, OFF FOR WATER
C               2       LIQUID ASSET, SEE BIT 1
C               3       PIRATE DOESN'T GO HERE UNLESS FOLLOWING PLAYER
C       OTHER BITS ARE USED TO INDICATE AREAS OF INTEREST TO "HINT" ROUTINES:
C               4       TRYING TO GET INTO CAVE
C               5       TRYING TO CATCH BIRD
C               6       TRYING TO DEAL WITH SNAKE
C               7       LOST IN MAZE
C               8       PONDERING DARK ROOM
C               9       AT WITT'S END
C       COND(LOC) IS SET TO 2, OVERRIDING ALL OTHER BITS, IF LOC HAS FORCED
C       MOTION.
C  SECTION 10: CLASS MESSAGES.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C       MESSAGE DESCRIBING A CLASSIFICATION OF PLAYER.  THE SCORING SECTION
C       SELECTS THE APPROPRIATE MESSAGE, WHERE EACH MESSAGE IS CONSIDERED TO
C       APPLY TO PLAYERS WHOSE SCORES ARE HIGHER THAN THE PREVIOUS N BUT NOT
C       HIGHER THAN THIS N.  NOTE THAT THESE SCORES PROBABLY CHANGE WITH EVERY
C       MODIFICATION (AND PARTICULARLY EXPANSION) OF THE PROGRAM.
C  SECTION 11: HINTS.  EACH LINE CONTAINS A HINT NUMBER (CORRESPONDING TO A
C       COND BIT, SEE SECTION 9), THE NUMBER OF TURNS HE MUST BE AT THE RIGHT
C       LOC(S) BEFORE TRIGGERING THE HINT, THE POINTS DEDUCTED FOR TAKING THE
C       HINT, THE MESSAGE NUMBER (SECTION 6) OF THE QUESTION, AND THE MESSAGE
C       NUMBER OF THE HINT.  THESE VALUES ARE STASHED IN THE "HINTS" ARRAY.
C       HNTMAX IS SET TO THE MAX HINT NUMBER (<= HNTSIZ).  NUMBERS 1-3 ARE
C       UNUSABLE SINCE COND BITS ARE OTHERWISE ASSIGNED, SO 2 IS USED TO
C       REMEMBER IF HE'S READ THE CLUE IN THE REPOSITORY, AND 3 IS USED TO
C       REMEMBER WHETHER HE ASKED FOR INSTRUCTIONS (GETS MORE TURNS, BUT LOSES
C       POINTS).
C  SECTION 12: MAGIC MESSAGES. IDENTICAL TO SECTION 6 EXCEPT PUT IN A SEPARATE
C       SECTION FOR EASIER REFERENCE.  MAGIC MESSAGES ARE USED BY THE STARTUP,
C       MAINTENANCE MODE, AND RELATED ROUTINES.
C  SECTION 0: END OF DATABASE.
C  READ THE DATABASE IF WE HAVE NOT YET DONE SO
        IF(SETUP.NE.0)GOTO 1100
        RTXSIZ = 205
        HNTSIZ = 20
        MAGSIZ = 35
        TRVSIZ = 750
      VRBSIZ=35
        CLSMAX = 12
      WRITE(3,1000)
1000    FORMAT(' Have patience.  It takes a while to initialize...')
C  CLEAR OUT THE VARIOUS TEXT-POINTER ARRAYS.  ALL TEXT IS STORED IN DISK
C  FILE (RANDOM ACCESS ON UNIT 2).  THE TEXT-POINTER ARRAYS CONTAIN RECORD
C  NUMBERS IN THE FILE.  STEXT(N) IS SHORT DESCRIPTION OF LOCATION N.
C  LTEXT(N) IS LONG DESCRIPTION.  PTEXT(N) POINTS TO MESSAGE FOR PROP(N)=0.
C  SUCCESSIVE PROP MESSAGES ARE FOUND BY CHASING POINTERS.  RTEXT CONTAINS
C  SECTION 6'S STUFF.  CTEXT(N) POINTS TO A PLAYER-CLASS MESSAGE.  MTEXT IS FOR
C  SECTION 12.  WE ALSO CLEAR COND.  SEE DESCRIPTION OF SECTION 9 FOR DETAILS.
        DO 1001 I=1,300
        IF(I.LE.100)PTEXT(I)=0
        IF(I.LE.RTXSIZ)RTEXT(I)=0
        IF(I.LE.CLSMAX)CTEXT(I)=0
        IF(I.LE.MAGSIZ)MTEXT(I)=0
        IF(I.GT.LOCSIZ)GOTO 1001
        STEXT(I)=0
        LTEXT(I)=0
        COND(I)=0
1001    CONTINUE
      DO 5001 IJ=1,100
      FIXD(IJ)=0
5001  PLAC(IJ)=0
      CALL OPEN(6,'ADVENTURMSG',1)
      CALL OPEN(7,'ADVENTURDAT',2)
        ASCVAR = 1
        SETUP=1
        LINUSE=1
        TRVS=1
        CLSSES=1
C  START NEW DATA SECTION.  SECT IS THE SECTION NUMBER.
1002    READ(7,1003)SECT
1003    FORMAT(1X,I7)
       WRITE(3,10030) SECT
10030  FORMAT(' NOW LOADING SECTION',I3)
        OLDLOC=-1
      IGOTO=SECT+1
        GOTO(1100,1004,1004,1030,1040,1004,1004,1050,1060,1070,1004,
     1    1080,1004),IGOTO
C             (0)  (1)  (2)  (3)  (4)  (5)  (6)  (7)  (8)  (9)  (10)
C            (11) (12)
        CALL BUG(9)
C  SECTIONS 1, 2, 5, 6, 10, 12.  READ MESSAGES AND SET UP POINTERS.
1004    READ(7,1005) LOC,LINES
1005    FORMAT(1X,I4,15A4)
C     DO 3005 IJ=1,2
	ASC2=MOD((ASCVAR-1),2)+1
	LOC2(ASC2)=LOC
	DO 3006 IJ=1,15
3006	LINES2(IJ,ASC2)=LINES(IJ)
	ASC3=(ASCVAR-1)/2+1
3005    IF (ASC2.EQ.2) WRITE(6,REC=ASC3) LOC2,LINES2
      ASCVAR=ASCVAR+1
      DO 2004 I=1,60
      IF (LLINES(I) .EQ. CR) LLINES(I)=BL
2004  CONTINUE
        LINUSE = ASCVAR-1
        IF(LOC .EQ. -1) GO TO 1002
        IF(LOC .EQ. OLDLOC) GO TO 1020
        IF(SECT.EQ.12)GOTO 1013
        IF(SECT.EQ.10)GOTO 1012
        IF(SECT.EQ.6)GOTO 1011
        IF(SECT.EQ.5)GOTO 1010
        IF(SECT.EQ.1)GOTO 1008
        STEXT(LOC)=LINUSE
        GOTO 1020
1008    LTEXT(LOC)=LINUSE
        GOTO 1020
1010    IF(LOC.GT.0.AND.LOC.LE.100)PTEXT(LOC)=LINUSE
        GOTO 1020
1011    IF(LOC .GT. RTXSIZ) WRITE(3,2000)LOC,RTXSIZ
2000  FORMAT(1X,2I7)
        IF(LOC .GT. RTXSIZ) CALL BUG(6)
        RTEXT(LOC)=LINUSE
        GOTO 1020
1012    CTEXT(CLSSES)=LINUSE
        CVAL(CLSSES)=LOC
        CLSSES=CLSSES+1
        GOTO 1020
1013    IF(LOC.GT.MAGSIZ)CALL BUG(6)
        MTEXT(LOC)=LINUSE
1020    OLDLOC = LOC
        IF(LINUSE .GE. 2100) CALL BUG(2)
        GOTO 1004
C  THE STUFF FOR SECTION 3 IS ENCODED HERE.  EACH "FROM-LOCATION" GETS A
C  CONTIGUOUS SECTION OF THE "TRAVEL" ARRAY.  EACH ENTRY IN TRAVEL IS
C  NEWLOC*1000 + KEYWORD (FROM SECTION 4, MOTION VERBS), AND IS NEGATED IF
C  THIS IS THE LAST ENTRY FOR THIS LOCATION.  KEY(N) IS THE INDEX IN TRAVEL
C  OF THE FIRST OPTION AT LOCATION N.
1030    READ(7,2031)LOC,ANWLOC,ITK
2031  FORMAT(1X,I10,F10.0,99I10)
1031    FORMAT(1X,99I10)
        IF(LOC.EQ.-1)GOTO 1002
        IF(KEY(LOC).NE.0)GOTO 1033
        KEY(LOC)=TRVS
        GOTO 1035
1033    TRAVEL(2,TRVS-1)=-TRAVEL(2,TRVS-1)
1035    DO 1037 L=1,20
        IF(ITK(L).EQ.0)GO TO 1039
      TRAVEL(1,TRVS)=ANWLOC/1000.
      TRAVEL(2,TRVS)=AMOD(ANWLOC,1000.)
      TRAVEL(3,TRVS)=ITK(L)
        TRVS=TRVS+1
        IF(TRVS.EQ.TRVSIZ)CALL BUG(3)
1037    CONTINUE
1039    TRAVEL(2,TRVS-1)=-TRAVEL(2,TRVS-1)
        GOTO 1030
C  HERE WE READ IN THE VOCABULARY.  KTAB(N) IS THE WORD NUMBER, ATAB(N) IS
C  THE CORRESPONDING WORD.  THE -1 AT THE END OF SECTION 4 IS LEFT IN KTAB
C  AS AN END-MARKER.
1040    DO 1042 TABNDX=1,TABSIZ
1043    READ(7,1041)KTAB(TABNDX),ATAB(TABNDX)
1041    FORMAT(1X,I10,A4)
        IF(KTAB(TABNDX).EQ.-1)GOTO 1002
1042    CONTINUE
        CALL BUG(4)
C  READ IN THE INITIAL LOCATIONS FOR EACH OBJECT.  ALSO THE IMMOVABILITY INFO.
C  PLAC CONTAINS INITIAL LOCATIONS OF OBJECTS.  FIXD IS -1 FOR IMMOVABLE
C  OBJECTS (INCLUDING THE SNAKE), OR = SECOND LOC FOR TWO-PLACED OBJECTS.
1050    READ(7,1031)OBJ,J,K
C     WRITE(3,1031)OBJ,J,K
        IF(OBJ.EQ.-1)GOTO 1002
        PLAC(OBJ)=J
        FIXD(OBJ)=K
        GOTO 1050
C  READ DEFAULT MESSAGE NUMBERS FOR ACTION VERBS, STORE IN ACTSPK.
1060    READ(7,1031)VERB,J
        IF(VERB.EQ.-1)GOTO 1002
        ACTSPK(VERB)=J
        GOTO 1060
C  READ INFO ABOUT AVAILABLE LIQUIDS AND OTHER CONDITIONS, STORE IN COND.
1070    READ(7,1031)K,ITK
C      WRITE(2,2070)K,TK
C2070  FORMAT(1X,I3,3X,20I3)
        IF(K.EQ.-1)GOTO 1002
        DO 1071 I=1,20
        LOC=ITK(I)
        IF(LOC.EQ.0)GOTO 1070
C      LTMP=BITSET(LOC,K)
C      ITMP=COND(LOC)+2**K
C      WRITE(2,2071)K,I,LOC,COND(LOC),LTMP,ITMP
C2071  FORMAT(1X,'K=',I2,'  I=',I3,'  LOC=',I3,'  COND(LOC)=',
C     1  I6,'   BITSET(LOC,K)=',L7,'   NEW COND(LOC)=',I6)
        IF(BITSET(LOC,K))CALL BUG(8)
1071    COND(LOC)=COND(LOC)+2**K
        GOTO 1070
C  READ DATA FOR HINTS.
1080    HNTMAX=0
1081    READ(7,1031)K,ITK
        IF(K.EQ.-1)GOTO 1002
        IF(K.EQ.0)GOTO 1081
        IF(K.LT.0.OR.K.GT.HNTSIZ)CALL BUG(7)
        DO 1083 I=1,4
1083    HINTS(K,I)=ITK(I)
        HNTMAX=MAX0(HNTMAX,K)
        GOTO 1081
C  FINISH CONSTRUCTING INTERNAL DATA FORMAT
C  IF SETUP=2 WE DON'T NEED TO DO THIS.  IT'S ONLY NECESSARY IF WE HAVEN'T DONE
C  IT AT ALL OR IF THE PROGRAM HAS BEEN RUN SINCE THEN.
1100  CONTINUE
C     WRITE(3,1031)PLAC(3),FIXD(3),PLAC(13),FIXD(13)
        IF(SETUP.EQ.2)GOTO 1
        IF(SETUP.EQ.-1) GOTO1
C  HAVING READ IN THE DATABASE, CERTAIN THINGS ARE NOW CONSTRUCTED.  PROPS ARE
C  SET TO ZERO.  WE FINISH SETTING UP COND BY CHECKING FOR FORCED-MOTION TRAVEL
C  ENTRIES.  THE PLAC AND FIXD ARRAYS ARE USED TO SET UP ATLOC(N) AS THE FIRST
C  OBJECT AT LOCATION N, AND LINK(OBJ) AS THE NEXT OBJECT AT THE SAME LOCATION
C  AS OBJ.  (OBJ>100 INDICATES THAT FIXED(OBJ-100)=LOC; LINK(OBJ) IS STILL THE
C  CORRECT LINK TO USE.)  ABB IS ZEROED; IT CONTROLS WHETHER THE ABBREVIATED
C  DESCRIPTION IS PRINTED.  COUNTS MOD 5 UNLESS "LOOK" IS USED.
        DO 1101 I=1,100
        PLACE(I)=0
        PROP(I)=0
        LINK(I)=0
1101    LINK(I+100)=0
C     PAUSE 1101
        DO 1102 I=1,LOCSIZ
        ABB(I)=0
        IF(LTEXT(I).EQ.0.OR.KEY(I).EQ.0)GOTO 1102
        K=KEY(I)
        IF (TRAVEL(3,K) .EQ. 1)COND(I)=2
1102    ATLOC(I)=0
C     PAUSE 1102
C  SET UP THE ATLOC AND LINK ARRAYS AS DESCRIBED ABOVE.  WE'LL USE THE DROP
C  SUBROUTINE, WHICH PREFACES NEW OBJECTS ON THE LISTS.  SINCE WE WANT THINGS
C  IN THE OTHER ORDER, WE'LL RUN THE LOOP BACKWARDS.  IF THE OBJECT IS IN TWO
C  LOCS, WE DROP IT TWICE.  THIS ALSO SETS UP "PLACE" AND "FIXED" AS COPIES OF
C  "PLAC" AND "FIXD".  ALSO, SINCE TWO-PLACED OBJECTS ARE TYPICALLY BEST
C  DESCRIBED LAST, WE'LL DROP THEM FIRST.
        DO 1106 I=1,100
        K=101-I
        IF(FIXD(K).LE.0)GOTO 1106
        CALL DROP(K+100,FIXD(K))
        CALL DROP(K,PLAC(K))
1106    CONTINUE
C     PAUSE 1106
C     WRITE(3,1031)PLAC(3),FIXD(3),PLAC(13),FIXD(13)
        DO 1107 I=1,100
        K=101-I
        FIXED(K)=FIXD(K)
        IF(PLAC(K).NE.0.AND.FIXD(K).LE.0)CALL DROP(K,PLAC(K))
1107  CONTINUE
C     PAUSE 1107
C     WRITE(3,1031)PLAC(3),FIXD(3),PLAC(13),FIXD(13)
C  TREASURES, AS NOTED EARLIER, ARE OBJECTS 50 THROUGH MAXTRS (CURRENTLY 79).
C  THEIR PROPS ARE INITIALLY -1, AND ARE SET TO 0 THE FIRST TIME THEY ARE
C  DESCRIBED.  TALLY KEEPS TRACK OF HOW MANY ARE NOT YET FOUND, SO WE KNOW
C  WHEN TO CLOSE THE CAVE.  TALLY2 COUNTS HOW MANY CAN NEVER BE FOUND (E.G. IF
C  LOST BIRD OR BRIDGE).
        MAXTRS=79
        TALLY=0
        TALLY2=0
        DO 1200 I=50,MAXTRS
        IF(PTEXT(I).NE.0)PROP(I)=-1
1200    TALLY=TALLY-PROP(I)
C     PAUSE 1200
C  CLEAR THE HINT STUFF.  HINTLC(I) IS HOW LONG HE'S BEEN AT LOC WITH COND BIT
C  I.  HINTED(I) IS TRUE IFF HINT I HAS BEEN USED.
        DO 1300 I=1,HNTMAX
        HINTED(I)=.FALSE.
1300    HINTLC(I)=0
C     PAUSE 1300
C  DEFINE SOME HANDY MNEMONICS.  THESE CORRESPOND TO OBJECT NUMBERS.
        KEYS=VOCAB('keys',1)
        LAMP=VOCAB('lamp',1)
        GRATE=VOCAB('grat',1)
        CAGE=VOCAB('cage',1)
        ROD=VOCAB('rod ',1)
        ROD2=ROD+1
        STEPS=VOCAB('step',1)
        BIRD=VOCAB('bird',1)
        DOOR=VOCAB('door',1)
        PILLOW=VOCAB('pill',1)
        SNAKE=VOCAB('snak',1)
        FISSUR=VOCAB('fiss',1)
        TABLET=VOCAB('tabl',1)
        CLAM=VOCAB('clam',1)
        OYSTER=VOCAB('oyst',1)
        MAGZIN=VOCAB('maga',1)
        DWARF=VOCAB('dwar',1)
        KNIFE=VOCAB('knif',1)
        FOOD=VOCAB('food',1)
        BOTTLE=VOCAB('bott',1)
        WATER=VOCAB('wate',1)
        OIL=VOCAB('oil ',1)
        PLANT=VOCAB('plan',1)
        PLANT2=PLANT+1
        AXE=VOCAB('axe ',1)
        MIRROR=VOCAB('mirr',1)
        DRAGON=VOCAB('drag',1)
        CHASM=VOCAB('chas',1)
        TROLL=VOCAB('trol',1)
        TROLL2=TROLL+1
        BEAR=VOCAB('bear',1)
        MESSAG=VOCAB('mess',1)
        VEND=VOCAB('vend',1)
        BATTER=VOCAB('batt',1)
C  OBJECTS FROM 50 THROUGH WHATEVER ARE TREASURES.  HERE ARE A FEW.
        NUGGET=VOCAB('gold',1)
        COINS=VOCAB('coin',1)
        CHEST=VOCAB('ches',1)
        EGGS=VOCAB('eggs',1)
        TRIDNT=VOCAB('trid',1)
        VASE=VOCAB('vase',1)
        EMRALD=VOCAB('emer',1)
        PYRAM=VOCAB('pyra',1)
        PEARL=VOCAB('pear',1)
        RUG=VOCAB('rug ',1)
        CHAIN=VOCAB('chai',1)
C  THESE ARE MOTION-VERB NUMBERS.
        BACK=VOCAB('back',0)
        LOOK=VOCAB('look',0)
        CAVE=VOCAB('cave',0)
        NULL=VOCAB('null',0)
        ENTRNC=VOCAB('entr',0)
        DPRSSN=VOCAB('depr',0)
C  AND SOME ACTION VERBS.
        SAY=VOCAB('say ',2)
        LOCK=VOCAB('lock',2)
        THROW=VOCAB('thro',2)
        FIND=VOCAB('find',2)
        INVENT=VOCAB('inve',2)
C  INITIALISE THE DWARVES.  DLOC IS LOC OF DWARVES, HARD-WIRED IN.  ODLOC IS
C  PRIOR LOC OF EACH DWARF, INITIALLY GARBAGE.  DALTLC IS ALTERNATE INITIAL LOC
C  FOR DWARF, IN CASE ONE OF THEM STARTS OUT ON TOP OF THE ADVENTURER.  (NO 2
C  OF THE 5 INITIAL LOCS ARE ADJACENT.)  DSEEN IS TRUE IF DWARF HAS SEEN HIM.
C  DFLAG CONTROLS THE LEVEL OF ACTIVATION OF ALL THIS:
C       0       NO DWARF STUFF YET (WAIT UNTIL REACHES HALL OF MISTS)
C       1       REACHED HALL OF MISTS, BUT HASN'T MET FIRST DWARF
C       2       MET FIRST DWARF, OTHERS START MOVING, NO KNIVES THROWN YET
C       3       A KNIFE HAS BEEN THROWN (FIRST SET ALWAYS MISSES)
C       3+      DWARVES ARE MAD (INCREASES THEIR ACCURACY)
C  SIXTH DWARF IS SPECIAL (THE PIRATE).  HE ALWAYS STARTS AT HIS CHEST'S
C  EVENTUAL LOCATION INSIDE THE MAZE.  THIS LOC IS SAVED IN CHLOC FOR REF.
C  THE DEAD END IN THE OTHER MAZE HAS ITS LOC STORED IN CHLOC2.
        CHLOC=114
        CHLOC2=140
        DO 1700 I=1,6
1700    DSEEN(I)=.FALSE.
C     PAUSE 1700
        DFLAG=0
        DLOC(1)=19
        DLOC(2)=27
        DLOC(3)=33
        DLOC(4)=44
        DLOC(5)=64
        DLOC(6)=CHLOC
        DALTLC=18
C  OTHER RANDOM FLAGS AND COUNTERS, AS FOLLOWS:
C       TURNS   TALLIES HOW MANY COMMANDS HE'S GIVEN (IGNORES YES/NO)
C       LIMIT   LIFETIME OF LAMP (NOT SET HERE)
C       IWEST   HOW MANY TIMES HE'S SAID "WEST" INSTEAD OF "W"
C       KNFLOC  0 IF NO KNIFE HERE, LOC IF KNIFE HERE, -1 AFTER CAVEAT
C       DETAIL  HOW OFTEN WE'VE SAID "NOT ALLOWED TO GIVE MORE DETAIL"
C       ABBNUM  HOW OFTEN WE SHOULD PRINT NON-ABBREVIATED DESCRIPTIONS
C       MAXDIE  NUMBER OF REINCARNATION MESSAGES AVAILABLE (UP TO 5)
C       NUMDIE  NUMBER OF TIMES KILLED SO FAR
C       HOLDNG  NUMBER OF OBJECTS BEING CARRIED
C       DKILL   NUMBER OF DWARVES KILLED (UNUSED IN SCORING, NEEDED FOR MSG)
C       FOOBAR  CURRENT PROGRESS IN SAYING "FEE FIE FOE FOO".
C       BONUS   USED TO DETERMINE AMOUNT OF BONUS IF HE REACHES CLOSING
C       CLOCK1  NUMBER OF TURNS FROM FINDING LAST TREASURE TILL CLOSING
C       CLOCK2  NUMBER OF TURNS FROM FIRST WARNING TILL BLINDING FLASH
C       LOGICALS WERE EXPLAINED EARLIER
        TURNS=0
        LMWARN=.FALSE.
        IWEST=0
        KNFLOC=0
        DETAIL=0
        ABBNUM=5
        DO 1800 I2=1,5
      I=I2-1
      IF(RTEXT(2*I+81).NE.0)MAXDIE=I+1
1800  CONTINUE
C     PAUSE 1800
        NUMDIE=0
        HOLDNG=0
        DKILL=0
        FOOBAR=0
        BONUS=0
        CLOCK1=30
        CLOCK2=50
        SAVED=0
        CLOSNG=.FALSE.
        PANIC=.FALSE.
        CLOSED=.FALSE.
        GAVEUP=.FALSE.
        SCORNG=.FALSE.
C  IF SETUP=1, REPORT ON AMOUNT OF ARRAYS ACTUALLY USED, TO PERMIT REDUCTIONS.
        IF(SETUP.NE.1)GOTO 1
        SETUP=2
        DO 1998 K=1,LOCSIZ
        KK=LOCSIZ+1-K
        IF(LTEXT(KK).NE.0)GOTO 1997
1998    CONTINUE
C     PAUSE 1998
        OBJ=0
1997  CONTINUE
        DO 1996 K=1,100
1996    IF(PTEXT(K).NE.0)OBJ=OBJ+1
C     PAUSE 1996
        DO 1995 K=1,TABNDX
1995    IF(KTAB(K)/1000.EQ.2)VERB=KTAB(K)-2000
C     PAUSE 1995
        DO 1994 K=1,RTXSIZ
        J=RTXSIZ+1-K
        IF(RTEXT(J).NE.0)GOTO 1993
1994    CONTINUE
C     PAUSE 1994
1993  CONTINUE
        DO 1992 K=1,MAGSIZ
        I=MAGSIZ+1-K
        IF(MTEXT(I).NE.0)GOTO 1991
1992    CONTINUE
C     PAUSE 1992
1991  CONTINUE
        K=100
       WRITE(3,1999)LINUSE,TRVS,TRVSIZ,TABNDX,TABSIZ,KK
     1       ,LOCSIZ,OBJ,K,VERB,VRBSIZ,J,RTXSIZ,CLSSES,CLSMAX
     2       ,HNTMAX,HNTSIZ,I,MAGSIZ
1999    FORMAT (' TABLE SPACE USED:'/
     1       ' ',6X,'    ',I6,' LINES OF MESSAGES'/
     2       ' ',I6,' OF ',I6,' TRAVEL OPTIONS'/
     3       ' ',I6,' OF ',I6,' VOCABULARY WORDS'/
     4       ' ',I6,' OF ',I6,' LOCATIONS'/
     5       ' ',I6,' OF ',I6,' OBJECTS'/
     6       ' ',I6,' OF ',I6,' ACTION VERBS'/
     7       ' ',I6,' OF ',I6,' RTEXT MESSAGES'/
     8       ' ',I6,' OF ',I6,' CLASS MESSAGES'/
     9       ' ',I6,' OF ',I6,' HINTS'/
     1       ' ',I6,' OF ',I6,' MAGIC MESSAGES'/
     2       )
C  FINALLY, SINCE WE'RE CLEARLY SETTING THINGS UP FOR THE FIRST TIME...
        LOC = 1
C       PAUSE 'INIT DONE'
   1  ENDFILE 7
	ASC3=(ASCVAR-1)/2+1
	IF (MOD(ASCVAR,2).EQ.0)WRITE(6,REC=ASC3) LOC2,LINES2
      ENDFILE 6
C
      CALL INSUB
C     WRITE(3,1031)PLAC(3),FIXD(3),PLAC(13),FIXD(13)
C
C
C        WRITE COMMON STUFF FROM INITIALIZATION
C
      CALL OPEN(6,'COMMON  DAT',1)
C
      WRITE(6) LINES,ASCVAR,BLKLIN,TABSIZ,ATLOC,LINK,PLACE,
     1  FIXED,HOLDNG,MTEXT,PTEXT,ABB,WKDAY,WKEND,HOLID,HBEGIN,
     2  HEND,HNAME,SHORT,MAGIC,MAGNM,LATNCY,SAVED,SAVET,SETUP,
     3  LINUSE,TRVS,CLSSES,OLDLOC,LOC,CVAL,TK,NEWLOC,KEY,PLAC,
     4  FIXD,ACTSPK,COND,HINTS,HNTMAX,PROP,TALLY,TALLY2,
     5  HINTLC,CHLOC,CHLOC2,DSEEN,DFLAG,DLOC,DALTLC,KEYS,LAMP,
     6  GRATE,CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE,
     7  FISSUR,TABLET,CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,
     8  BOTTLE,WATER,OIL,PLANT,PLANT2,AXE,MIRROR,DRAGON,CHASM,
     9  TROLL,TROLL2,BEAR,MESSAG,VEND,BATTER,NUGGET,COINS,
     A  CHEST,EGGS,TRIDNT,VASE,EMRALD,PYRAM,PEARL,RUG,CHAIN,
     B  BACK,LOOK,CAVE,NULL,ENTRNC,DPRSSN,SAY,LOCK,THROW,FIND,
     C  INVENT,TURNS,LMWARN,IWEST,KNFLOC,DETAIL,ABBNUM,NUMDIE,
     D  MAXDIE,DKILL,FOOBAR,BONUS,CLOCK1,CLOCK2,CLOSNG,PANIC,
     E  CLOSED,GAVEUP,SCORNG,I,RTXSIZ,CLSMAX,MAGSIZ,LOCSIZ,
     F  CTEXT,SECT,TRVSIZ,TABNDX,OBJ,J,K,VERB,
     G  HNTSIZ,MAXTRS,HINTED,HNTLOC,KK
C
      ENDFILE 6
C
C     WRITE(3,1031)PLAC(3),FIXD(3),PLAC(13),FIXD(13)
        RETURN
        END
