/*	cvsave.c
 *		routine to save or restore the user's game
 *		what is saved:
 *			all non-stack variables from cvmain.c
 *			all variable info from cvlocs.c, cvobj.c
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "cvobj.h"
#include "cvlocs.h"
#include "cvorcs.h"
#include "cvmisc.h"

#define MAXORC	18		 /* length of orcs[] array */

static struct osave {		 /* save structure for orcs[] */
    int iloc, dw, dseen;
    int dloc, oloc;
} orcsave[MAXORC];

static unsigned orclen = MAXORC*sizeof(struct osave);
static unsigned conlen = sizeof(struct cvloc *) + sizeof(struct conn *);

#define M_READ	0		 /* read/write modes */
#define M_WRITE	1

#define MAXSAVE	20		 /* max saved games */
#define DESCLEN	60		 /* max game description length */

char *
getsavefile(int mode)
{
    char desc[MAXSAVE][DESCLEN], *reply, prompt[BUFSIZ];
    extern char *getline(char *prompt);
    char *homedir = getenv("HOME");
    static char pathname[BUFSIZ];
    int i, nsave = 0, game;
    FILE *fp;

    /* read saved game index */
    sprintf(pathname, "%s/.crystal.idx", homedir);
    if ((fp = fopen(pathname, "r")) != NULL) {
	while (fgets(desc[nsave], DESCLEN, fp) != NULL)
            nsave++;
        fclose(fp);
    }

    if (nsave == 0 && mode == M_READ) {
	printf("You don't have any saved games.\n");
	return NULL;
    }

    /* display saved games and prompt for which one if required */
    if (mode == M_READ || nsave > 0) {
	putchar('\n');
	for (i = 0; i < nsave; i++)
            printf("%2d: %s", i + 1, desc[i]);
	putchar('\n');

	sprintf(prompt, "Which number to %s%s: ",
                (mode == M_READ ? "restore" : "save as"),
                (mode == M_WRITE && nsave < MAXSAVE ? " (n = new)" : ""));

        reply = getline(prompt);
	putchar('\n');

	if (reply[0] == 'n' && nsave < MAXSAVE && mode == M_WRITE) {
	    game = nsave;
	    nsave++;
	} else {
	    game = atoi(reply) - 1;
	    if (game < 0 || game >= nsave)
                return NULL;
	}
    } else {
	game = nsave;
	nsave++;
    }

    /* get description of game and write new index if required */
    if (mode == M_WRITE) {
        reply = getline("Description: ");
	strcpy(desc[game], reply);
	if ((fp = fopen(pathname, "w")) != NULL) {
            for (i = 0; i < nsave; i++)
                fprintf(fp, "%s\n", desc[i]);
            fclose(fp);
        } else {
            printf("Can't open saved game index!\n");
        }
    }

    /* construct and return save file */
    sprintf(pathname, "%s/.crystal.%d", homedir, game);
    return pathname;
}

int
cvsave()
{
    struct cvloc *curloc;
    struct cvobj *curobj;
    int locnum = loc-cvloc, i;
    int err = 0;
    char *path;
    FILE *fp;

    if ((path = getsavefile(M_WRITE)) == NULL)
        return 0;

    fp = fopen(path, "w");
    if (fp == NULL) {
	perror("Opening save file");
	return 0;
    }

    /* pack orc array for saving */
    for (i = 0; i < MAXORC; i++) {
	orcsave[i].iloc = orcs[i].iloc;
	orcsave[i].dw = orcs[i].dw;
	orcsave[i].dseen = orcs[i].dseen;
	orcsave[i].dloc = (orcs[i].dloc ? orcs[i].dloc-cvloc : -1);
	orcsave[i].oloc = (orcs[i].oloc ? orcs[i].oloc-cvloc : -1);
    }

    err |= (fwrite(&locnum, sizeof(int), 1, fp) != 1);
    err |= (fwrite(orcsave, orclen, 1, fp) != 1);
    err |= (fwrite(&demo, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&score, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&mxscore, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&limit, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&setup, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&tally, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&tally2, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&inorth, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&detail, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&numdie, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&maxdie, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&holding, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&dkill, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&turns, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&nxtchr, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&abbnum, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&clock1, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&clock2, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&bonus, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&closing, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&panic, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&wzdark, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&closed, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&gaveup, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&scoring, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&mltcmd, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&blklin, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&samvrb, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&finish, sizeof(int), 1, fp) != 1);
    err |= (fwrite(&lmwarn, sizeof(int), 1, fp) != 1);

    for (curobj = cvobj; curobj->desc != NULL; curobj++) {
	err |= (fwrite(&(curobj->prop), sizeof(int), 1, fp) != 1);
	err |= (fwrite(&(curobj->conn1.where), conlen, 1, fp) != 1);
	err |= (fwrite(&(curobj->conn2.where), conlen, 1, fp) != 1);
    }

    for (curloc = cvloc; curloc->travel != NULL; curloc++) {
	err |= (fwrite(&(curloc->abb), sizeof(int), 1, fp) != 1);
	err |= (fwrite(&(curloc->atloc.where), conlen, 1, fp) != 1);
    }

    if (err) {
	perror("Saving cave");
	fclose(fp);
	return 0;
    }

    (void) fclose(fp);
    return 1;
}

int
cvrest()
{
    struct cvloc *curloc;
    struct cvobj *curobj;
    int locnum, i;
    int err = 0;
    char *path;
    FILE *fp;

    if ((path = getsavefile(M_READ)) == NULL)
        return 0;

    if ((fp = fopen(path, "r")) == NULL) {
	perror("Opening save file");
	return 0;
    }

    err |= (fread(&locnum, sizeof(int), 1, fp) != 1);
    loc = cvloc+locnum;
    err |= (fread(orcsave, orclen, 1, fp) != 1);
    err |= (fread(&demo, sizeof(int), 1, fp) != 1);
    err |= (fread(&score, sizeof(int), 1, fp) != 1);
    err |= (fread(&mxscore, sizeof(int), 1, fp) != 1);
    err |= (fread(&limit, sizeof(int), 1, fp) != 1);
    err |= (fread(&setup, sizeof(int), 1, fp) != 1);
    err |= (fread(&tally, sizeof(int), 1, fp) != 1);
    err |= (fread(&tally2, sizeof(int), 1, fp) != 1);
    err |= (fread(&inorth, sizeof(int), 1, fp) != 1);
    err |= (fread(&detail, sizeof(int), 1, fp) != 1);
    err |= (fread(&numdie, sizeof(int), 1, fp) != 1);
    err |= (fread(&maxdie, sizeof(int), 1, fp) != 1);
    err |= (fread(&holding, sizeof(int), 1, fp) != 1);
    err |= (fread(&dkill, sizeof(int), 1, fp) != 1);
    err |= (fread(&turns, sizeof(int), 1, fp) != 1);
    err |= (fread(&nxtchr, sizeof(int), 1, fp) != 1);
    err |= (fread(&abbnum, sizeof(int), 1, fp) != 1);
    err |= (fread(&clock1, sizeof(int), 1, fp) != 1);
    err |= (fread(&clock2, sizeof(int), 1, fp) != 1);
    err |= (fread(&bonus, sizeof(int), 1, fp) != 1);
    err |= (fread(&closing, sizeof(int), 1, fp) != 1);
    err |= (fread(&panic, sizeof(int), 1, fp) != 1);
    err |= (fread(&wzdark, sizeof(int), 1, fp) != 1);
    err |= (fread(&closed, sizeof(int), 1, fp) != 1);
    err |= (fread(&gaveup, sizeof(int), 1, fp) != 1);
    err |= (fread(&scoring, sizeof(int), 1, fp) != 1);
    err |= (fread(&mltcmd, sizeof(int), 1, fp) != 1);
    err |= (fread(&blklin, sizeof(int), 1, fp) != 1);
    err |= (fread(&samvrb, sizeof(int), 1, fp) != 1);
    err |= (fread(&finish, sizeof(int), 1, fp) != 1);
    err |= (fread(&lmwarn, sizeof(int), 1, fp) != 1);

    for (curobj = cvobj; curobj->desc != NULL; curobj++) {
	err |= (fread(&(curobj->prop), sizeof(int), 1, fp) != 1);
	err |= (fread(&(curobj->conn1.where), conlen, 1, fp) != 1);
	err |= (fread(&(curobj->conn2.where), conlen, 1, fp) != 1);
    }

    for (curloc = cvloc; curloc->travel != NULL; curloc++) {
	err |= (fread(&(curloc->abb), sizeof(int), 1, fp) != 1);
	err |= (fread(&(curloc->atloc.where), conlen, 1, fp) != 1);
    }

    if (err) {
	perror("Restoring cave");
	fclose(fp);
	return 0;
    }

    if (fread(&i, 1, 1, fp) != 0) {
	puts("\nNot end of file");
	fclose(fp);
	gameover(1);
    }

    /* unpack orc array */
    for (i = 0; i < MAXORC; i++) {
	orcs[i].iloc = orcsave[i].iloc;
	orcs[i].dw = orcsave[i].dw;
	orcs[i].dseen = orcsave[i].dseen;
	orcs[i].dloc = (orcsave[i].dloc >= 0 ? cvloc+orcsave[i].dloc : NULL);
	orcs[i].oloc = (orcsave[i].oloc >= 0 ? cvloc+orcsave[i].oloc : NULL);
    }

    (void) fclose(fp);
    if (saved == 1) saved = -1;
    return 1;
}
