/* cvmove.c
 *   various object motion subroutines
 *************************************************************************/

#include <stdio.h>
#include "cvobj.h"
#include "cvlocs.h"

extern void bug();
extern int holding;

/* start toting an object, removing it from the list of things at its
 * former location.  Increment 'holding' unless it was already being
 * toted.
 * Primarily used by move().
 */
void
carry(obj)
struct cvobj *obj;
{
    struct cvloc *from;
    struct conn *this;

    from = obj->conn1.where;
    obj->conn1.where = TAKEN;
    if (from == TAKEN)
	return;
    ++holding;
    if (from != (struct cvloc *) NULL) {
	for (this = &(from->atloc);
	     this->link != &(obj->conn1); this = this->link)
	    if (this->link == NULL)
		bug(30);
	this->link = obj->conn1.link;
    }
    obj->conn1.link = NULL;
    return;
}

/* pick up an object by its second location, removing it from the list
 * of things at its former location.
 * Primarily used by move2().
 */
static void
carry2(obj)
struct cvobj *obj;
{
    struct cvloc *from;
    struct conn *this;

    from = obj->conn2.where;
    obj->conn2.where = TAKEN;
    if (from == TAKEN)
	return;
    if (from != (struct cvloc *) NULL) {
	for (this = &(from->atloc);
	     this->link != &(obj->conn2); this = this->link)
	    if (this->link == NULL)
		bug(30);
	this->link = obj->conn2.link;
    }
    obj->conn2.link = NULL;
    return;
}

/* place any object anywhere by picking it up and dropping it.
 * may already be toting it, in which case the carry is a no-op.
 *
 * to move the second place of an object, use the object's number plus
 * OBJSIZ as the object.
 *
 * 'move' may be called regardless of where the object was, whether
 * it's being carried, is lost, is destroyed, or whatever.
 */
void
move(obj, toloc)
struct cvobj *obj;
struct cvloc *toloc;
{
    struct cvloc *from;

    from = obj->conn1.where;
    if ((from != LOST) && (from != TAKEN))
	carry(obj);

    if (obj->conn1.where == TAKEN)
	--holding;
    obj->conn1.where = toloc;
    if (toloc == LOST)
	return;
    obj->conn1.link = toloc->atloc.link;
    toloc->atloc.link = &(obj->conn1);
    return;
}

/* place any object anywhere by picking it up and dropping it by its
 * second location.  May already be toting it, in which case the carry
 * is a no-op.
 *
 * 'move2' may be called regardless of where the object was, whether
 * it's being carried, is lost, is destroyed, or whatever.
 */
void
move2(obj, toloc)
struct cvobj *obj;
struct cvloc *toloc;
{
    struct cvloc *from;

    from = obj->conn2.where;
    if ((from != LOST) && (from != TAKEN))
	carry2(obj);

    if (obj->conn2.where == TAKEN)
	--holding;
    obj->conn2.where = toloc;
    if (toloc == LOST)
	return;
    obj->conn2.link = toloc->atloc.link;
    toloc->atloc.link = &(obj->conn2);
    return;
}


/* juggle an object by picking it up and putting it down again, the
 * purpose being to get the object to the front of the chain of things
 * at its location.
 */
void
juggle(obj)
struct cvobj *obj;
{
    struct cvloc *where;

    where = obj->conn1.where;
    if (where == NULL)
	bug(33);
    move(obj, where);
    return;
}

void
juggl2(obj)
struct cvobj *obj;
{
    struct cvloc *where;

    where = obj->conn2.where;
    if (where == NULL)
	bug(33);
    move2(obj, where);
    return;
}


/* destroy the object by dropping at an inaccessable place
 */
void
destry(obj)
struct cvobj *obj;
{
    move(obj, LOST);
}

void
destr2(obj)
struct cvobj *obj;
{
    move2(obj, LOST);
}
