//
// Procedimientos de usuario
//
// NOTA: los procedimientos de este mdulo permiten "enganchar" cdigo de usuario
// a las respuestas y al bucle principal del juego.
// Los procedimientos de este mdulo son los nicos que deberan
// modificarse.
//
// v2.0 (15.03.2000)
//

// ********************************************************
// Los siguientes procedimientos (USR_...) son enganches desde el mdulo 'Librera'.
// Estos procedimientos se llaman cuando el jugador teclea alguna de las acciones
// asociadas y antes de que la librera los procese con lo que se puede
// colocar cdigo que responda a casos especiales.
//
// Algunos reciben parmetros que pueden usarse para determinar su comportamiento.
//
// En todos ellos se debe devolver un valor para indicar si se ha respondido
// o no a la accin.
// ********************************************************

// --------------------------------------------------------
// aqu podemos aadir informacin a la lnea de estado
// para ello slo tenemos que imprimirla con Print ya que
// al entrar a este procedimiento ya estar seleccionada
// la lnea de estado y el cursor posicionado justo detrs
// de la descripcin corta de la localidad
// si se quiere posicionar con exactitud el texto a imprimir
// se usar ScreenAt(pant_info,x,y) donde 'x' e 'y' marcan
// la posicin dentro de la lnea de estado
// --------------------------------------------------------
Sub USR_LineaEstado()

    ScreenAt(pant_info,400,0)
    Print("Turnos: " + turnos)
    ScreenAt(pant_info,500,0)
    Print("Puntos: " + puntos)

Return

// --------------------------------------------------------
// a este procedimiento se le llama antes de mover al jugador
// recibe:
//      'dir' verbo de movimiento que indica la direccin hacia
//            donde quiere moverse el jugador
// debe devolver TRUE si el jugador se mueve o FALSE si se queda donde est
// --------------------------------------------------------
Sub USR_MueveJugador(dir)
    Declare(ret)
    declare(loc)
    declare(lista)
    declare(longlista)
    declare(dado)
    declare(exito)
    declare(psizombie)
    loc:=PSI[PSIJugador].Localidad
    ret:=TRUE

    // NOTAS:
    // en este procedimiento pueden hacerse comprobaciones de si una puerta
    // est abierta para permitir o impedir el paso del jugador en una
    // determinada direccin, si devolvemos FALSE se le impedir el paso
    // al jugador, por ejemplo:
    //
    // If (PSI[PSIJugador].Localidad="HABITACION") & Not(LOC[dir].Abierta) Then
    //     Print("La puerta " + dir + " est cerrada." + CR)
    //     ret:=FALSE
    // EndIf
    //
    // Tambin se puede decir aqu el porqu de no poder moverse en una direccin
    // para prescindir del montono: "NO PUEDES IR POR AHI"
    // Tambien para poner una salida no contemplada en el mapa.
    // PERO ME PARECE ABSURDO METER LAS RAZONES POR LAS QUE NO SE PUEDA MOVER AQUI.
    // MIRAR USR_NoMueve() un poco ms abajo.

    // WARNING: Si alguna localidad tiene conexin hacia si misma, con lo ke se contempla
    // en la descripcin de las salidas; si quieres poner una razn para la que no vaya
    // por ella, fijate en la habitacin de 18JULIO4, debers poner aqui ese texto y no
    // en USR_NoMueve(), ya que ese sitio solo se ejecuta cuando fall el intento de 
    // movimiento, y este no es el caso de las conexiones a si mismas, ya que son 
    // un movimiento seguro (a menos que est la puerta cerrada).

Select loc
    Case "TECHO"
        if (dir="ESTE") then
          print("Por instinto levitas hacia la puerta. Tu avance parece imparable, ")
          print("pero al comenzar a travesarla, la sensacin es demasiado fuerte y..." + CR)
          USR_Fin(2)
          ret:=FALSE
        endif
    Case "18JULIO4" 
            Print("Caminas entre este mar de niebla con dificultad. A pesar de que ")
            print("logras divisar poco, te das cuenta de apenas avanzas, y a cada paso ")
            print("es como un pequeo saltito, notas que su espesura te eleva para ")
            print("despus dejarte suavemente cerca de donde estabas." + CR)
            ret:=FALSE
    Case "CALLE1"
        if (dir="NORTE") then
            print("Todos esos zombies se dirijen hacia aqui poco a poco. Es un suicidio ir ")
            print("en esa direccin." + CR)    
            ret:=FALSE
        endif
    Case "CALLE2"
        if (dir="ESTE") then
            print("\[N]IMPOSIBLE!!!:\[N] Est atestado de zombies.!" + CR)
            ret:=FALSE
        endif
    Case "CALLEJON" 
        if (dir="NORTE") then
            print("No es aconsejable echarte en los brazos de todos esos zombies." + CR)
            ret:=FALSE
        EndIf
    Case *
        // Aqui voy a chequear que no hay un PSI hostil boqueando una salida.
        if dir="NORTE" then
            lista:=Search("*","VIENE_DE=NORTE,HOSTIL=1",3)
        endif
        if dir="SUR" then
            lista:=Search("*","VIENE_DE=SUR,HOSTIL=1",3)
        endif
        if dir="ESTE" then
            lista:=Search("*","VIENE_DE=ESTE,HOSTIL=1",3)
        endif
        if dir="OESTE" then
            lista:=Search("*","VIENE_DE=OESTE,HOSTIL=1",3)
        endif
        longlista:=ArrayLen(lista)
        if longlista>0 then   // hay algn zombie.
            psizombie:=ArrayItem(lista,1)
            print("Empiezas a avanzar en direccin "+LCase(dir)+" pero ")
            if longlista=1 then
                print(PSI[psizombie].DescCorta+" bloquea el paso."+CR)
            else
                print("varios zombies bloquean el camino."+CR)
            endif
            dado:=Random(1,100)
            exito:=10+((50*PSI[PSIJugador].fuerza)/100)
            if dado<exito then
                if longlista=1 then
                     print("Con suerte y pericia, consigues zafarte de su abrazo mortal, logrando pasar por su ")
                     print("lado y escabullirte. El zombie cambia de direccin para seguirte lentamente."+CR)
                     PSI[PSIJugador].fuerza:=PSI[PSIJugador].fuerza-10
                else
                     print("Pasas a travs de ellos, entre sus zarpas y con un gran esfuerzo consigues pasarlos ileso; ")
                     print("mientras ellos murmullan estupefactos y giran, como si tu fueses un imn para ellos, en pos tuya."+CR)
                     PSI[PSIJugador].fuerza:=PSI[PSIJugador].fuerza-15
                endif
                ret:=TRUE
            else
                if longlista=1 then
                     print("Pero caes en sus fauces y no logras pasar..."+CR)
                else
                     print("Pero ellos te atrapan y bloquean el paso..."+CR)
                endif
                PSI[psizombie].Turno:=0
                ret:=FALSE
            endif
        endif
    endselect


Return ret



// --------------------------------------------------------
// EXAMINAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Examinar()
    Declare(ret)
    declare(loc)
    ret:=FALSE
    loc:=PSI[PSIJugador].Localidad
    
    // NOTAS:
    // se llama a este procedimiento justo antes de realizar la accin
    // por defecto del comando EXAMINAR que es devolver una descripcin
    // del objeto o PSI en cuestin
    // si queremos sustituir alguna descripcin por la nuestra propia
    // debemos imprimirla aqu y devolver TRUE para que no se ejecute
    // el EXAMINAR estndar.
    if marabunta then
        if parsenombre1="MARABUNTA" then
            IF loc<12 then
                print("Son cientos de zombies que lo van llenando todo... Parece una procesin siniestra ")
                print("como si fuesen cantando letanas en murmullos..."+CR)
                ret:=TRUE
            else
                if loc="18JULIO3" then
                    print("La niebla parece detener su avance... a partir de aqu estars a salvo... por ahora."+CR)
                    ret:=TRUE
                endif
            endif
        endif
    endif
    if (parsenombre1="MUCHACHA")&(PSI["ZOMBIE HEMBRA"].Localidad=loc) then
        parsenombre1:="ZOMBIE"
        parseadjetivo1:="HEMBRA"
        ret:=FALSE
    endif

    if (loc="EXPLANADA1") | (loc="EXPLANADA2") | (loc="EXPLANADA3") | (loc="EXPLANADA4") | (loc="EXPLANADA5") | (loc="EXPLANADA6") then
        Select ParseNombre1
            Case "HOSPITAL"
                print("El Hospital, ya no lo es ms. Fu un centro de salud hace ya ")
                print("medio siglo; ahora es un centro de cultura donde se dan ")
                print("conciertos y conferencias y exposiciones." + CR)
                print("Es un edificio grave y austero pero imponente: ")
                print("Crees recordar que es del estilo Herreriano, al igual que ")
                print("el Escorial de Madrid (por eso lo llaman el Escorial andaluz). ")
                print("Posee una gran puerta de madera con enormes clavos y argollas. ")
                print("Las ventanas son enrejadas de forja, y en lo ms alto de la fachada ")
                print("adornan una ventanas ciegas como pequeas cupulas negras, en linea, ")
                print("a lo largo de toda la longitud del edificio." + CR)
                print("En las dos esquinas de la fachada, se alzan dos torres, completamente ")
                print("distintas una de la otra; y otras dos ms en el interior, estas siamesas." + CR)
                ret:=TRUE
            Case "TORRES"
                print("Los cuatro brazos de este coloso. Las exteriores tienen distinta ")
                print("altura y distinta cspide: una abovedada y recubierta de azulejos; y ")
                print("la otra piramidal y de tejas. Se alzan en las esquinas de la ")
                print("fachada del edificio." + CR)
                print("Las torres interiores son idnticas, y muy cercanas la una de la ")
                print("otra. Asoman por detrs del edificio. Albergan cuatro ventanas ")
                print("con campanas en ellas." + CR)
                ret:=TRUE
            Case "SUELO"
                print("Pisas adoquines." + CR)
                ret:=TRUE
            Case "PUERTA"
                print("Gran puerta. Esta completamente cerrada, sera imposible abrirla. Y dentro, de noche, no habr nadie." + CR)
                ret:=TRUE
           
        EndSelect
    EndIf
    if loc="TECHO" then
        Select ParseNombre1
            Case "CAMA"
                print("Tu yaces en ella." + CR)
                ret:=TRUE
            Case "ARMARIO"
                print("Lo observas por su techo y ves que esta lleno de polvo. Esta cerrado." + CR)
                print("Por instinto derivas hacia l y lo atraviesas parcialmente examinando el contenido. ")
                print("Dentro aunque est oscuro puedes ver bien, en un tono verdoso, la ropa que hay, mantas, ")
                print("sabanas, toallas, y articulos hardware estn revueltos sin ton ni son. Con un zoom hacia ")
                print("atrs, vuelves a tumbarte en el techo." + CR)
                ret:=TRUE
            Case "ORDENADOR"
                print("Tu viejo 386 que arrastras desde el COU." + CR)
                ret:=TRUE
            Case "JUGADOR"
                print("Ves a un joven de unos 19 aos. Lo contemplas al revs que t, ")
                print("su cabeza a la altura de tus pies... parece un espejo totalmente. ")
                print("Est medio tapado con la sbana, ")
                print("con la cabeza ladeada con los ojos abiertos como platos y ")
                print("perdidos en otro mundo; por su/tu boca semiabierta asoma una baba." + CR)
                ret:=TRUE
            Case "VENTANA"
                print("Desde aqui parece el suelo. Est a unos palmos de tus pies, ")
                print("la persiana esta medio subida y las cortinas abiertas." + CR)
                ret:=TRUE
            Case *
                if (parsenombre1="TECHO")|(parsenombre1="PARED") then
                    print("Blanco inmaculado... bueno, no tan blanco: necesita ya una mano de pintura."+CR)
                    ret:=TRUE
                endif
        EndSelect
    EndIf
    if loc="EXPLANADA4" then
        Select ParseNombre1
            Case "CASA"
                print("Son casas y bloques de pisos normales y corrientes. ")
                print("Slo las puertas y ventanas cerradas, confirma la maldicin ")
                print("que ha caido en la ciudad." + CR)
                ret:=TRUE
            Case "18"
                print("Es una calle larga y hacia abajo. Por la mitad se divisa niebla." + CR)
                ret:=TRUE
        EndSelect
    EndIf
    if loc="EXPLANADA3" then
        Select ParseNombre1
        Case "CALLEJON"
            print("Oscuro y estrecho callejn que discurre entre una hilera de casas ")
            print("y la pared este del Edificio." + CR)
            ret:=TRUE
        EndSelect
    EndIf
    IF loc="EXPLANADA5" then
        Select ParseNombre1
            Case "CASAS" 
                print("Son casas y bloques de pisos normales y corrientes. ")
                print("Slo las puertas y ventanas cerradas, confirma la maldicin ")
                print("que ha caido en la ciudad." + CR)
                ret:=TRUE
        EndSelect
    EndIf
    IF loc="CALLE1" then
        Select ParseNombre1
            Case "HOSPITAL"
                print ("Su inmensa pared bloquea el este. Magnfico muro de piedra sin ninguna puerta ni ventana." + CR)
                ret:=TRUE
            Case "CHALETS"
                print("Chalets adosados de altos muros blancos agrietados. Tienen las ")
                print("puertas y ventanas cerradas." + CR)
                ret:=TRUE
            Case "SUELO"
                print("Pisas asfalto." + CR)
                ret:=TRUE
            Case "MULTITUD"
                print("Parece como si fuera Semana Santa... Pero el olor y los murmullos ")
                print("te avisan de lo contraio: es la mayora de la poblacn betense ")
                print("transformados en zombies." + CR)
                ret:=TRUE
        EndSelect
    EndIf
    If loc="CALLE2" then
        Select ParseNombre1
            Case "SUELO"
                print("Pisas adoquines." + CR)
                ret:=TRUE
            Case "MULTITUD"
                print("Ms y ms zombies se acercan por aquella direccin." + CR)
                ret:=TRUE
            Case "CASAS"
                print("Aqui hay una mezcla de grandes pisos de tres plantas, comercios y ")
                print("grandes casas. Cerradas." + CR)
                ret:=TRUE
        EndSelect
    EndIf      
    If loc="CALLEJON" then
        Select ParseNombre1
            Case "TELAPISA"
                print("El popular establecimiento de pizzas est cerrado completamente, ")
                print("ya que los potenciales clientes actuales prefieren la carne ")
                print("fresca." + CR)
                ret:=TRUE
            Case "CASAS"
                print("Casas y casas y casas y todas cerradas" + CR)
                ret:=TRUE
            Case "HOSPITAL"
                print("Aqui se ve el gran muro de piedra que es su pared este." + CR)
                ret:=TRUE
        EndSelect
    EndIf
    if (loc="18JULIO1") then
        Select ParseNombre1
        Case "NIEBLA"
            print("Parece un ocano fantasmal."+CR)
            ret:=TRUE
        endselect
    endif
    if (loc="18JULIO2") then
        Select ParseNombre1
        Case "NIEBLA"
            print("Translcida playa que te lame los pies con continuas y pequeas olas."+CR)
            ret:=TRUE
        Case "CEMENTERIO"
            print("S, eso parece. Con su verja, su valla maltrecha y sus tumbas siniestras."+CR)
            ret:=TRUE
        endselect
    endif
    if (loc="18JULIO3")|(loc="18JULIO4") then
        Select ParseNombre1
        Case "NIEBLA"
            print("Parece casi moldeable, de gran densidad. Es humeda ")
            print("y fra. Todo se desfigura a travs de ella, y contra ms ")
            print("cerca la tienes, peor se ve a travs de ella."+CR)
            ret:=TRUE
        EndSelect
    EndIf
    if (LOC[loc].exterior=TRUE) then
        Select ParseNombre1
            Case "CIELO"
                print("Azul marino profundo. El cielo est despejado y se observan todas las estrellas."+CR)
                ret:=TRUE
        endselect
    endif
    if loc="RECOLECTOR" then
        Select ParseNombre1
            CASE "COJIN"
                print("Un bonito y mullido cojin de tela. Sobre l descansa un jarrn."+CR)
                ret:=TRUE
            CASE *
                if (INARRAY(tesoros,ParseNombre1)<>0) then
                    print("Es un tesoro valioso!!!" + CR)
                    ret:=TRUE
                endif
        endselect
    endif        
Return ret

// --------------------------------------------------------
// EXAMINAR DETALLES
// recibe:
//      'espsi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver el texto sobre los detalles adicionales del
// PSI o el objeto que se imprimirn al examinarlo
// --------------------------------------------------------
Sub USR_ExaminarDetalles(espsi,nombre)
    Declare(txt)

    txt:=""

    // NOTA:
    // el EXAMINAR estndar llamar a esta procedimiento para obtener detalles
    // adicionales sobre el objeto o PSI en cuestin
    // detalles como si una botella est abierta o cerrada, o si un PSI
    // est herido, etc... por ejemplo:
    //
    // If psi Then
    //     // suponemos que hemos definido una propiedad 'Herido' para los PSIs
    //     If PSI[nombre].Herido Then
    //         txt:="Tiene una herida por la que mana sangre en abundancia."
    //     Else
    //         txt:="Parece que est en buena forma."
    //     EndIf
    // Else
    //     // suponemos que hemos definido una propiedad 'Lleno' para los objetos
    //     // que contendr una cadena vaca si el objeto est vaco o una descripcin
    //     // del lquido que contiene si est lleno
    //     If OBJ[nombre].Lleno="" Then
    //         txt:="Est vaco."
    //     Else
    //         txt:="Contiene un poco de " + OBJ[nombre].Lleno + "."
    //     EndIf
    // EndIf
if espsi then       // si hemos examinado un PSI
if nombre=PSIJugador then
    EstadoJugador(TRUE)

else        // si es un PSI diferente al jugador
    if PSI[nombre].vida_cabeza<=0 then
        txt:=txt+"No tiene cabeza. "
    endif
    if PSI[nombre].vida_cuerpo<=0 then
        txt:=txt+"Tiene el cuerpo destrozado. "
    endif
    if (PSI[nombre].vida_brazo_izq<=0)|(PSI[nombre].vida_brazo_izq<=0) then
        if (PSI[nombre].vida_brazo_izq<=0)&(PSI[nombre].vida_brazo_izq<=0) then
            txt:=txt+"No tiene brazos. "
        else
            if PSI[nombre].vida_brazo_izq<=0 then
                txt:=txt+"Le falta el brazo izquierdo. "
            endif
            if PSI[nombre].vida_brazo_dch<=0 then
                txt:=txt+"Le falta el brazo izquierdo. "
            endif
        endif
    endif
    if (PSI[nombre].vida_pierna_izq<=0)|(PSI[nombre].vida_pierna_izq<=0) then
        if (PSI[nombre].vida_pierna_izq<=0)&(PSI[nombre].vida_pierna_izq<=0) then
            txt:=txt+"Le faltan ambas piernas. "
        else
            if PSI[nombre].vida_pierna_izq<=0 then
                txt:=txt+"No tiene pierna izquierda. "
            endif
            if PSI[nombre].vida_pierna_dch<=0 then
                txt:=txt+"No tiene pierna izquierda. "
            endif
        endif
    endif

endif   // si el psi es el propio jugador

ELSE    // si hemos examinado un objeto
    if OBJ[nombre].gore>0 then
        if (OBJ[nombre].gore>0)&(OBJ[nombre].gore<=4) then
            print("Tiene unas manchas de sangre. "+CR)
        endif
        if (OBJ[nombre].gore>4)&(OBJ[nombre].gore<=9) then
            print("Tiene sangre por todas partes. "+CR)
        endif
        if (OBJ[nombre].gore>9) then
            print("Tiene abundante sangre chorreante y trozos de carne adheridos. "+CR)
        endif
     endif
endif

    // aadimos un espacio adicional a los detalles
    If txt<>"" Then
        txt:=" " + txt
    EndIf

Return txt

// --------------------------------------------------------
// COGER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Coger(psi,nombre)
    Declare(ret)
    declare(locjugador)
    locjugador:=PSI[PSIJugador].Localidad
    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta COGER
    // un objeto o PSI, podemos obviar la accin estndar de COGER
    // si se devuelve TRUE, por ejemplo:
    //
    // If psi Then
    //     // suponemos que se ha definido una propiedad 'Cogido' para los PSIs
    //     If PSI[nombre].Cogido Then
    //         Print("Ya llevas en brazos a " + PSI[nombre].DescCorta + "." + CR)
    //         PSI[nombre].Cogido:=TRUE
    //     Else
    //         Print("Coges en brazos a " + PSI[nombre].DescCorta + "." + CR)
    //     EndIf
    //     ret:=TRUE
    // Else
    //     // la tpica accin de COGER PIEDRA que aumenta las que lleva el jugador
    //     If (nombre="PIEDRA") & (PSI[PSIJugador].Localidad="CAMINO") Then
    //         Print("Coges una piedra de la muchas que hay por el suelo." + CR)
    //         piedras:=piedras+1
    //         ret:=TRUE
    //     EndIf
    // EndIf
        if parsenombre1="NIEBLA" then
            if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
                print("Coges un puado de niebla, notas el tacto glido ")
                print(" y la humedad en tu mano. Al rato se funde en el aire." + CR)
                ret:=TRUE
            endif  
        endif

Return ret

// --------------------------------------------------------
// DEJAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dejar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DEJAR
    // un objeto o PSI, podemos obviar la accin estndar de DEJAR
    // si se devuelve TRUE, por ejemplo:
    //
    // If psi Then
    //     // suponemos que se ha definido una propiedad 'Cogido' para los PSIs
    //     If PSI[nombre].Cogido Then
    //         Print("Dejas a " + PSI[nombre].DescCorta + " en el suelo." + CR)
    //         PSI[nombre].Cogido:=FALSE
    //     Else
    //         Print("No llevas a " + PSI[nombre].DescCorta + " en brazos." + CR)
    //     EndIf
    //     ret:=TRUE
    // Else
    //     // la tpica accin de DEJAR PIEDRA que decrementa las que lleva el jugador
    //     If nombre="PIEDRA" Then
    //         If piedras>0 Then
    //             Print("Dejas una piedra." + CR)
    //             piedras:=piedras-1
    //         Else
    //             Print("No tienes piedras." + CR)     
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// METER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Meter(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta METER
    // un objeto dentro de otro, podemos obviar la accin estndar
    // de METER si se devuelve TRUE, por ejemplo:
    //
    // If (nombre="PIEDRA") & (nombre_contenedor="SACO") Then
    //     If piedras>0 Then
    //         Print("Metes una piedra en el saco." + CR)
    //         piedras:=piedras-1
    //         piedras_saco:=piedras_saco+1
    //     Else
    //         Print("No llevas ninguna piedra." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// SACAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Sacar(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SACAR
    // un objeto de otro, podemos obviar la accin estndar
    // de SACAR si se devuelve TRUE, por ejemplo:
    //
    // If (nombre="PIEDRA") & (nombre_contenedor="SACO") Then
    //     If piedras_saco>0 Then
    //         Print("Sacas una piedra del saco." + CR)
    //         piedras_saco:=piedras_saco-1
    //         piedras:=piedras+1
    //     Else
    //         Print("No hay ninguna piedra dentro del saco." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ABRIR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Abrir(nombre)
    Declare(ret)
    Declare(loc)
    ret:=FALSE
    loc:=PSI[PSIJugador].Localidad
    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ABRIR
    // un objeto, podemos obviar la accin estndar de ABRIR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="PUERTA" Then
    //     If PSI[PSIJugador].Localidad:="HABITACION" Then
    //         If LOC["HABITACION"].Abierta("NORTE") Then
    //             Print("La puerta ya est abierta." + CR)
    //         Else
    //             Print("Abres la puerta." + CR)
    //             LOC["HABITACION"].Abrir("NORTE")
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf
if nombre="PUERTA" then
    if loc="EXPLANADA2" then
        print("Es imposible. Est cerrada por dentro, y de noche no hay nadie ah..."+CR)
    endif
endif
Return ret

// --------------------------------------------------------
// CERRAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cerrar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CERRAR
    // un objeto, podemos obviar la accin estndar de CERRAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="PUERTA" Then
    //     If PSI[PSIJugador].Localidad:="HABITACION" Then
    //         If LOC["HABITACION"].Abierta("NORTE") Then
    //             Print("Cierras la puerta." + CR)
    //             LOC["HABITACION"].Cerrar("NORTE")
    //         Else
    //             Print("La puerta ya est cerrada." + CR)
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// PONER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Poner(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta PONER
    // un objeto, podemos obviar la accin estndar de PONER si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="ESCAFANDRA" Then
    //     Print("No ests entrenado para ponerte una escfandra. Quiz deberas pedir ayuda." + CR)
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// QUITAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Quitar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta QUITAR
    // un objeto, podemos obviar la accin estndar de QUITAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If (nombre="ESCAFANDRA") & (PSI[PSIJugador].Localidad:="FONDO MARINO") Then
    //     Print("Primero deberas salir del agua, no crees?." + CR)
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ENCENDER
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Encender(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ENCENDER
    // un objeto, podemos obviar la accin estndar de ENCENDER si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="TELEVISION" Then
    //     If OBJ[nombre].Encendido Then
    //         Print("La televisin ya est encendida." + CR)
    //     Else
    //         Print("Enciendes la televisin." + CR)
    //         OBJ[nombre].Encendido:=TRUE
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// APAGAR
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Apagar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta APAGAR
    // un objeto, podemos obviar la accin estndar de APAGAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="TELEVISION" Then
    //     If OBJ[nombre].Encendido Then
    //         Print("Apagas la televisin." + CR)
    //         OBJ[nombre].Encendido:=FALSE
    //     Else
    //         Print("La televisin est apagada." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// SABOREAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saborear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SABOREAR o CHUPAR
    // un objeto o PSI, podemos obviar la accin estndar de SABOREAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// OLER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Oler(psi,nombre)
    Declare(ret)
    declare(locjugador)
    locjugador:=PSI[PSIJugador].Localidad

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta OLER
    // un objeto o PSI, podemos obviar la accin estndar de OLER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---
 
        if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
            if (ParseNombre1="NIEBLA") then
                print("A que huelen las cosas que no huelen?"+CR)
                ret:=TRUE
            endif
        endif

Return ret

// --------------------------------------------------------
// ESCUCHAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Escuchar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ESCUCHAR
    // un objeto o PSI, podemos obviar la accin estndar de ESCUCHAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// TOCAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Tocar(psi,nombre)
    Declare(ret)
    declare(locjugador)
    ret:=FALSE
    locjugador:=PSI[PSIJugador].Localidad
    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta TOCAR
    // un objeto o PSI, podemos obviar la accin estndar de TOCAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

        if (ParseNombre1="NIEBLA") then
            if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
                print("Realizas el gesto de palpar la niebla y ")
                print("notas como se hace hebras al pasar por tus dedos." + CR)
                ret:=TRUE
            endif
        endif

Return ret

// --------------------------------------------------------
// LANZAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Lanzar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se llama cuando se intenta LANZAR algo
    // la accin por defecto de LANZAR es dejar el objeto
    // podemos obviar la accin estndar codificndola aqu
    // y devolviendo TRUE, por ejemplo:
    //
    // If ParseNombre1:="PIEDRA" Then
    //     If piedras>0 Then
    //         Print("Arrojas la piedra muy lejos." + CR)
    //         piedras:=piedras-1
    //     Else
    //         Print("No llevas ninguna piedra." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// GOLPEAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Golpear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta GOLPEAR
    // un objeto o PSI, podemos obviar la accin estndar de GOLPEAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// CORTAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cortar(psi,nombre)
    Declare(ret)
    declare(locjugador)
    ret:=FALSE
    locjugador:=PSI[PSIJugador].Localidad

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CORTAR
    // un objeto o PSI, podemos obviar la accin estndar de CORTAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---
  
        if (ParseNombre1="NIEBLA") then
            if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
                print("Sesgas la niebla, separndola de un tajo, pero ")
                print("al rato, toda su densidad ocupa el espacio rajado." + CR)
                ret:=TRUE
            endif
        endif

Return ret

// --------------------------------------------------------
// ATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Atar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ATAR
    // un objeto o PSI, podemos obviar la accin estndar de ATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// DESATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Desatar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DESATAR
    // un objeto o PSI, podemos obviar la accin estndar de DESATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// MOVER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Mover(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta MOVER
    // un objeto o PSI, podemos obviar la accin estndar de MOVER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---
       
        if (ParseNombre1="NIEBLA") then
            if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
                print("Con amplios movimientos de brazos, desplazas la niebla ")
                print("de un lado para otro, sin conseguir nada." + CR)
                ret:=TRUE
            endif
        endif

Return ret

// --------------------------------------------------------
// MATAR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Matar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta MATAR
    // a un PSI, podemos obviar la accin estndar de MATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If EstaPresentaPSI(nombre) Then
    //     If PSI[PSIJugador].Contiene("PISTOLA") Then
    //         If PSI[nombre].Muerto Then
    //             Print(PSI[nombre].DescCorta + " ya est muerto. No querrs matarlo dos veces?." + CR)
    //         Else
    //             Print("Disparas contra " + PSI[nombre].DescCorta + " y este cae muerto al suelo." + CR)
    //             PSI[nombre].Muerto:=TRUE
    //         EndIf
    //     Else
    //         Print("No tienes ningn arma que puedas usar para matar a " + PSI[nombre].DescCorta + "." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// BEBER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Beber(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta BEBER
    // algo, podemos obviar la accin estndar de BEBER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_ENCENDER ---

Return ret

// --------------------------------------------------------
// COMER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Comer(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta COMER
    // algo, podemos obviar la accin estndar de COMER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_ENCENDER ---
    Saborear()
    ret:=true    

Return ret

// --------------------------------------------------------
// SALTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saltar()
    Declare(ret)
    declare(locjugador)
    ret:=FALSE
    locjugador:=PSI[PSIJugador].Localidad

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SALTAR
    // podemos obviar la accin estndar de SALTAR si se devuelve TRUE
    // por ejemplo:
    //
    // If ParseNombre1="ABISMO" Then
    //     If PSI[PSIJugador].Localidad="ABISMO" Then
    //         Print("Con total despreocupacin por la vida, te lanzas al vaco..." + CR)
    //         Print("*** Ests muerto ***" + CR)
    //         Abandonar()
    //     Else
    //         Print("A qu abismo?. Creo que deliras." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf
     
            if (locjugador="18JULIO4") then
                print("Te elevas con facilidad en esta niebla tan rara." + CR)
                print("\[N]\[C]Ests volando!!!\[C]\[N] Sin poder evitarlo te mueves ")
                print("como en el agua, agitando los brazos que a cada impulso te ")
                print("elevan un poco ms.")
                print("Te sientes nadador del cielo, pero falta la frustrante friccin ")
                print("del agua, ligero de movimientos, libre para ir donde quieras...")
                pause()
                PSI[PSIJugador].Localidad:="CUARTO"
                PSI[PSIJugador].estado:="despierto"
                RobaObjetos(PSIJugador)
                PSI[PSIJugador].Vitalidad:=100  // esto es pa que deje de sangrar.
                PSI[PSIJugador].Vida_Cabeza:=60
                PSI[PSIJugador].Vida_Cuerpo:=90
                PSI[PSIJugador].Vida_Brazo_Izq:=60
                PSI[PSIJugador].Vida_Brazo_Dch:=60
                PSI[PSIJugador].Vida_Pierna_Izq:=80
                PSI[PSIJugador].Vida_Pierna_Dch:=80
                ScreenCls(0)
                DescripcionLocalidad()
                ret:=TRUE
            else
                if (locjugador="18JULIO3") then
                    print("Saltas en el sitio sin conseguir nada... \[N]\[C]ESPERA\[C]\[N] el pequeo impulso se amplifica elevandote un poco ms de lo esperado." + CR)
                    print("Vuelves a bajar lentamente. ")
                    print(dialogo_psi1 + "Que extrao!!! ser cosa de la niebla?" + dialogo_psi2 + color_letra + " piensas.")
                    ret:=TRUE
                else
                    print("Saltas en el sitio sin conseguir nada.")
                    ret:=TRUE
                endif
            Endif 

Return ret

// --------------------------------------------------------
// GRITAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Gritar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta GRITAR
    // podemos obviar la accin estndar de GRITAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---


Return ret

// --------------------------------------------------------
// CANTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cantar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CANTAR
    // podemos obviar la accin estndar de CANTAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// BESAR
// recibe:
//      'psi' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Besar(psi)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta BESAR a un PSI
    // podemos obviar la accin estndar de BESAR si se devuelve TRUE
    // por ejemplo:
    //
    // If psi="NIA" Then
    //     If EstaPresentePSI(psi) Then
    //         Print("La nia se pone muy contenta." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf
if EstaPresentePSI(psi) then
    print("Claaaaro hombre, pnselo ms facil..."+CR)
    ret:=TRUE
endif
Return ret

// --------------------------------------------------------
// DORMIR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dormir()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DORMIR
    // podemos obviar la accin estndar de DORMIR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// DECIR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
//      'frase' frase que le decimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Decir(nombre,frase)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DECIR A PSI "xxx"
    // podemos obviar la accin estndar de DECIR si se devuelve TRUE
    // por ejemplo:
    //
    // If nombre="NIA" Then
    //     Parse(frase)
    //     If (ParseVerbo="COMO") & (ParseNombre1="LLAMAS") Then
    //         HablaPSI("Me llamo Mara pero mi mam me llama Mari.","dice la nia.")
    //     Else
    //         HablaPSI("No te entiendo.","dice la nia.")
    //     EndIf
    //     ret:=TRUE
    // EndIf     

Return ret

// --------------------------------------------------------
// DAR
// recibe:
//      'objeto' nombre del objeto que queremos dar
//      'psi' nombre del PSI a quien le queremos dar el objeto
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dar(objeto,psi)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DAR OBJ A PSI
    // podemos obviar la accin estndar de DAR si se devuelve TRUE
    // por ejemplo:
    //
    // If (objeto="ESPADA") & (psi="SOLDADO") Then
    //     Print("El soldado coge la espada que le entregas y de un mandoble mortal decapita al troll.")
    //     HablaPSI("Gracias, por poco no lo contamos.","dice el soldado al tiempo que te devuelve la espada.")
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ESPERAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Esperar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ESPERAR
    // podemos obviar la accin estndar de ESPERAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// acciones anteriores a que se procese el comando del jugador
// aqu se llega despus de analizar el comando pero antes
// de que se ejecute la accin asociada (si hubiese alguna)
// --------------------------------------------------------
Sub USR_Ant()
declare(locjugador)
locjugador:=PSI[PSIJugador].Localidad
    // NOTAS:
    // uno de los usos de este procedimiento es convertir
    // ciertas acciones del jugador en otras
    // por ejemplo:
    //
    // suponemos que hemos codificado la respuesta a LLENAR VASO y queremos que
    // el jugador pueda tambin teclear VERTER o VACIAR LICOR EN VASO y
    // VERTER o VACIAR BOTELLA EN VASO sin tener que codificar una respuesta independiente
    // a estas acciones, podemos conseguir esto de la siguiente manera:
    //
    // If ((ParseVerbo="VERTER") | (ParseVerbo="VACIAR")) & ((ParseNombre1="LICOR") | (ParseNombre1="BOTELLA")) & (ParseNombre2="VASO") Then
    //     ParseVerbo:="LLENAR"
    //     ParseNombre1:="VASO"
    //     ParseNombre2:=""
    // Endif
    //
    // ahora la aventura entender tanto LLENAR VASO, VERTER LICOR EN VASO,
    // VACIAR BOTELLA EN VASO como la misma accin y dar respuesta como si
    // hubisemos tecleado LLENAR VASO en cualquier caso
if (locjugador="18JULIO4")&(parseverbo="NADAR") then
    parseverbo:="SALTAR"
endif
if parseverbo="MATAR" then
    parseverbo:="GOLPEAR"
endif
If (parseverbo="COGER")&(parsepreposicion="EN") then
    parseverbo:="SACAR"
endif
if (parseverbo="DEJAR")&(parsepreposicion="EN") then
    parseverbo:="METER"
endif
if (parseverbo="QUITAR")&(parsenombre1="ROPA") then
    parseverbo:="DESNUDAR"
endif
Return

// --------------------------------------------------------
// respuestas a otras acciones no contempladas en la librera estndar
// debe devolver TRUE si se di una respuesta a al accin o FALSE si no
// --------------------------------------------------------
Sub USR_Respuesta()
    Declare(ret)
    Declare(obj)
    declare(locjugador)
    locjugador:=PSI[PSIJugador].Localidad
    ret:=FALSE

    // NOTAS:
    // la estructura ms comn del cdigo en este procedimiento
    // consiste en una sentencia SELECT que discrimine el verbo
    // tecleado y ejecute la accin correspondiente, por ejemplo:
    
    // Procesos sinnimos:

    // Select de Verbos
    Select ParseVerbo
        Case "BLANDIR"
            Blandir()
            ret:=TRUE
        Case "EMPUJAR"
            Empujar()
            ret:=TRUE
        Case "DESNUDAR"
            print("Claaaaro hombre... as los zombies te devorarn sin tener que pelarte...")
            ret:=TRUE
        Case "SOPLAR"
            if (locjugador="18JULIO2")|(locjugador="18JULIO3")|(locjugador="18JULIO4") then
            if (ParseNombre1="NIEBLA") Then
                print("Soplas y creas un vaco sin la mancha translcida, ")
                print("pero no tarda la niebla en volver a ocupar su espacio vital."+CR)
                ret:=TRUE
            endif
            endif
        Case "XYZZY"
            if (locjugador="TECHO") then
                secret:=TRUE
                print("\[N]\[C]Comienzas a elevarte a una velocidad vertiginosa!!!.\[C]\[N]" + CR)
                print("Atraviesas rpidamente el techo, ves a la vecina del sexto, ")
                print("atraviesas el tejado, y te elevas y elevas...." + CR)
                print("La tierra se aleja, viajas a la velocidad de la luz a otra zona ")
                print("del planeta, comienzas a caer, una regin aislada: un volcn, ")
                print("un bosque, un barranco, tierra, tierra..." + CR)
                print("Atraviesas la tierra, viajas entre ella... y la velocidad por fin cede." + CR)
                print(dialogo_psi1 + "QUE SITIO ES ESTE?!" + dialogo_psi2)
                print(tipo_letra + color_letra + " piensas.")
                PSI[PSIJugador].Localidad:="RECOLECTOR"
                ret:=TRUE
            else
                if (locjugador="RECOLECTOR") then
                    print("\[C]De nuevo atravesando la tierra hacia el cielo, vuelas sobre el mundo ")
                    print("hasta divisar tu pas. Caes a una velocidad vertiginosa, la tierra ")
                    print("se acerca peligrosamente. \[N]Te vas a estrellar contra ese edificio!\[N] ")
                    print("Atraviesas el tejado, ves a la vecina del sexto, atraviesas el techo... \[C]" + CR)
                    print("Y paras en seco de nuevo en tu dormitorio, gravitando cerca del techo." + CR)
                    PSI[PSIJugador].Localidad:="TECHO"
                    ret:=TRUE
                else
                    print("\[C]Nothing happens...\[C]" + CR)
                    ret:=TRUE
                EndIf
            EndIf
            ret:=TRUE
        Case "NADAR"
            print("No hay fluido en el que nadar."+CR)
            ret:=TRUE
    endselect

Return ret

// --------------------------------------------------------
// mensajes de copyright
// --------------------------------------------------------
Sub USR_Copyright()
    Declare(spc)
    Declare(copyright)
    Declare(email)
    Declare(web)
    Declare(descripcion)

    spc:="        "
    copyright:="(c) Clrigo Urbatain."
    email:="ruberalbert@bigfoot.com"
    web:=""
    descripcion:="LA CIUDAD EST INVADIDA POR LOS ZOMBIES!!!"

    Print(CR + "    \[Times New Roman]\[12]\[RGB(FFFFCC)]\[N]" + titulo + "\[N]" + CR)
    Print("\[10]\[C]" + spc + copyright + "\[C]" + CR)
    Print(spc + "\[RGB(8080FF)]\[S]" + email + "\[S]    " + web)
    Print(CR + spc + "\[RGB(FFCCCC)]" + descripcion)
    Print(CR + spc + "Versin " + version + " / intrprete " + VerVS)
    // inicializamos el tipo de letra y color del texto
    Print(tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// introduccin
// --------------------------------------------------------
Sub USR_Inicio()
print("\[C]El virus se ha extendido por toda la zona... es normal: la multinacional SOMBRILLA ")
print("CORPORATION S.L. compr, har poco, la fbrica de ELECTROQUMICA ANDALUZA S.A., con motivo de ")
print("un acuerdo econmico entre paises. Como ")
print("SOMBRILLA CORP. tuvo problemas en la ciudad de Ricoon City, en U.S.A., con la polica de all, ")
print("aparte de arrasar con toda la poblacin de la ciudad, decidieron venirse a un pais donde la ")
print("opinin de los ciudadanos pintaba poco, y los delitos ecolgicos se acallaban fcilmente con dinero."+CR)
print("Como era de esperar, la fbrica no tard en reventar, propagando un peligroso virus que ")
print("aunque de poco radio y corta vida de existencia, bast contaminar unos inofensivos animales ")
print("para convertirlos en unos asesinos sanguinarios deseosos de sangre y entraas. ")
print("De ah a una poblacin de zombies, hay slo un paso..."+CR)
print("As que te ves escapando por tu ciudad, de noche, silenciosa, slo perturbada por el olor ")
print("nauseabundo que arroja a tu cara el viento, sople de donde sople, y por los murmullos y el ")
print("arrastrar de pies de los espectros, que desplazan sus carcasas por las calles en busca de ")
print("comida fresca... y t an ests fresco...\[C]"+CR)
pause(0)
ScreenCls(0)
Print(CR+"\[RGB(E0E000)]\[Times New Roman]\[C](Teclea \[N]AYUDA\[N] para leer cmo jugar a este juego.)\[C]" + tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// msica de fondo
// --------------------------------------------------------
Sub USR_MusicaFondo()

    If hay_sonido Then
        musica_fondo:=LoadSong("#9999")
        PlaySong(musica_fondo)
    EndIf

Return

// --------------------------------------------------------
// pantalla de ayuda
// --------------------------------------------------------
Sub USR_Ayuda()
    ScreenCls(0)
    Print(CR+"\[RGB(FFFFCC)]\[Times New Roman]")

    print("Una parte importantsima de este juego es luchar contra los zombies, por tanto har incapi en las reglas y comandos del ")
    print("\[N]\[C]SISTEMA DE LUCHA:\[C]\[N]"+CR+CR)
    print("Para atacar usa \[N]GOLPEAR <OBJETIVO>\[N]. Si existe ambiguedad por haber varios PSIs enemigos presentes y no se ha metido el adjetivo, ")
    print("el parser eligir uno de ellos semialeatoriamente. O sea que como hay varios ZOMBIES, si no pones un adjetivo pa' diferenciar ")
    print("a quin quieres atacar concretamente, el juego decidir por ti."+CR+CR)
    print("Puedes elegir la zona del cuerpo donde descargar tu golpe: \[N]CABEZA, CUERPO o TORSO, ")
    print("BRAZO IZQUIERDO, BRAZO DERECHO, PIERNA IZQUIERDA y PIERNA DERECHA.\[N] Esto se hace con \[N]GOLPEAR <OBJETIVO> EN <ZONA>\[N]. Si no escribes ")
    print("una zona a golpear, el parser eligir una zona por ti al azar. Respecto a los BRAZOS y las PIERNAS, hay que concretar si ")
    print("deseas golpear la derecha o la izquierda. Si no lo haces as, el parser eligir entre los dos al azar."+CR+CR)
    print("Debes saber que puedes usar cualquier objeto que encuentres como arma. Por supuesto cada cual tiene sus propias ")
    print("caractersticas dependiendo de lo contundentes que sean y de su peso."+CR)
    print("Para elegir un objeto como arma pon \[N]BLANDIR <OBJETO>\[N], y este pasar a ser el arma al golpear por defecto ")
    print("(Si no, debers luchar con las manos desnudas, que no es muy aconsejable...), ")
    print("aunque tambin puedes poner \[N]GOLPEAR <OBJETIVO> CON <ARMA>\[N], que hace lo mismo que \[N]BLANDIR\[N], pero asesta un golpe con ella, ")
    print("lo cual es muy efectivo para comenzar un ataque."+CR)
    Pause(0)
    ScreenCls(0)
    print(CR+"\[N]\[C]EJEMPLOS:\[C]\[N]"+CR)
    print("\[N]GOLPEAR ZOMBIE\[N] (sin elegir arma ni zona. El parser lo har automticamente)"+CR)
    print("\[N]GOLPEAR ZOMBIE CON BARRA\[N] (zona se elige al azar y blandes el arma)"+CR)
    print("\[N]GOLPEAR ZOMBIE EN BRAZO IZQUIERDO \[N](esto es lo ideal para concentrar los golpes en una zona hacer ms dao en ella)"+CR)
    print("\[N]GOLPEAR ZOMBIE EN PIERNA \[N](no se ha especificado cual de las dos piernas, el parser lo har al azar)"+CR+CR)
    print("\[N]\[C]NOTA:\[N]\[C]"+CR+"Olvdate de poner \[N]GOLPEAR ZOMBIE EN CABEZA CON BARRA\[N] o similares. Esto no es INFORM y el parser es muy limitado ")
    print("a ese respecto, as que entender slo la primera preposicin que le pongas y omitir la segunda."+CR)
    print("No olvides poner siempre el objetivo, o sea, que \[N]GOLPEAR EN CABEZA o GOLPEAR\[N] simplemente, no sern entendidos por el parser."+CR)
    print("Yo te recomiendo que incialmente comiences blandiendo el arma, despus ataques a un zombie al azar, y una vez concretado ")
    print("el zombie atacado y su zona corporal, empieza a fustigarle en esa parte del cuerpo concreta. Un ejemplo:"+CR)
    print("\[N]BLANDIR BARRA o GOLPEAR ZOMBIE CON BARRA\[N]"+CR)
    print("\[N]GOLPEAR ZOMBIE\[N] (el parser informa: golpeas al zombie putrefacto en la cabeza)"+CR)
    print("\[N]GOLPEAR ZOMBIE PUTREFACTO EN CABEZA \[N](yeeeeeeeeaaaaah!!!! se la has reventado!)"+CR+CR)
    pause(0)
    ScreenCls(0)
    print(CR+"Cada golpe que des, cada ataque que recibas, caminar, y casi pensar, gastan energa: ")
    print("Si pierdes muchas fuerzas, tus ataques sern ms lentos y dbiles y hars menos dao al enemigo. Tambin si te quedas sin fuerzas ")
    print("te quedars indefenso durante unos instantes hasta que recuperes el aliento. As que mide bien tus golpes y acciones o sers carne ")
    print("para zombie."+CR+"Procura descansar de vez en cuando, simplemente no haciendo nada, esperando o cualquier accin que no sea ni ")
    print("atacar ni moverte. El programa te informar de vez en cuando si tus fuerzas bajan o suben, as que vigila esos mensajes."+CR)
    print("Tambin te informa de las heridas que tienes, si estas son graves y pierdes sangre, con lo que perders fuerza en cada turno, ")
    print("as que intenta no ir manchando las calles con tu propia sangre, ok?."+CR+CR)
    print("Aparte de golpear, puedes \[N]EMPUJAR <OBJETIVO>\[N] a los zombies, que si tienes xito, los dejars desorientados un ratito."+CR+CR)
    print("\[N]\[C]RECUERDA:\[N]\[C] un zombie sin brazos, tiene menos fuerza; y sin piernas sern ms lentos; y sin brazos ni piernas sern como peces ")
    print("fuera del agua."+CR+CR)
    print("Tambin el sistema de puntos, slo crece por magullar zombies, como si de un arcade se tratase, asi que es independiente de pasarse el juego."+CR)
    pause(0)
    ScreenCls(0)
    print(CR+"Aparte del sistema de lucha, en este juego se interacta con las rdenes normales en este tipo de juegos:"+CR)
    Print("\[N]COGER, DEJAR, MIRAR (M), EXAMINAR (EX), INVENTARIO (I), METER, SACAR, ABRIR, CERRAR, PONER, QUITAR, ENCENDER, APAGAR, ")
    Print("GOLPEAR, MATAR, ATAR, DESATAR, CORTAR, MOVER, OLER, SABOREAR, TOCAR, ESCUCHAR, LANZAR, BEBER, COMER, ")
    Print("SALTAR, GRITAR, CANTAR, BESAR, DORMIR, DAR, XYZZY\[N] (Como!?, que no sabes que es XYZZY?, entonces no eres muy ")
    print("aventurero... Bjate ahora mismo la Aventura Original y cuando lo sepas vuelves. Pero bueno... si lo deseas saber: ")
    print("es una palabra \[C]mgica\[C]."+CR+CR)

    Print("Se pueden teclear acciones mltiples en una sola lnea sin ms que encadenarlas con comas (,) o con \[N]Y\[N]. ")
    Print("Adems se pueden usar pronombres para referirse al ltimo objeto referenciado dentro de una accin, por ejemplo:" + CR)
    Print("\[N]COGER EL LIBRO, LEERLO Y DEJARLO\[N]" + CR)
    Print("En cualquier momento puedes hacer que la accin transcurra sin que t hagas nada usando el verbo \[N]ESPERAR (Z)\[N]" + CR)
    print("Y para saber las direcciones hacia donde ir, escribe: \[N]SALIDAS (X).\[N]"+CR)
//    Print("Adems puedes guardar y recuperar el estado del juego con los comandos \[N]GUARDAR y CARGAR\[N]" + CR)
    Print("Para salir del juego debes teclear \[N]FIN o ABANDONAR\[N]." + CR)
    Print("\[N]TURNOS\[N] muestra los turnos que llevas de juego." + CR+CR)
    Print("Pero lo mejor es que olvides todo esto y pongas lo que te salga del alma. El parser intentar entenderte lo ms que pueda."+CR)
    Print("\[N]NOTA:\[N] He quitado la opcin de \[N]CARGAR\[N] y \[N]GRABAR\[N], pues el juego es muy breve y puede terminarse sin problemas de una sentada.")
    Print("Adems le da un tinte ms arcade a la cosa, y tendrs que te tener ms cuidado con los zombies."+CR)
    print(CR+"\[N]\[C]SUERTE!!!\[C]\[N]"+CR)
    pause(0)
    Print(tipo_letra + color_letra)


Return


sub USR_DescObjs(loc)
 // Esto es igualito a USR_DescPsis(loc), ms arriba, slo que aplicado a Objetos
declare(objs)
declare(numobjs)
declare(lista)
declare(i)
declare(c)
declare(obj)

        objs:=LOC[loc].Objetos()
        numobjs:=ArrayLen(objs)
        If numobjs>0 Then
            lista:=""
            For i:=1 To numobjs
                obj:=ArrayItem(objs,i)
                If Not(OBJ[obj].Invisible) Then
                    c:=OBJ[obj].DescCorta
                    lista:=ArrayInsert(lista,ArrayLen(lista)+1,c)
                EndIf
            Next
        EndIf   
return lista


// Fin, con posibilidad de meter varios finales
sub USR_Fin(n)
Select n
Case 0      // muerto por marabunta
print("Una avalancha de zombies se te echa encima. Te derriban y caes sepultado entre un mar de cuerpos, brazos y piernas. ")
print("Un hedor nauseabundo te golpea el olfato, casi pierdes el sentido ante la profanacin de tanta putrefaccin. ")
print("Por un momento la confusin es total, y no puedes sino gritar de horror y desesperacin, pues no tardan mucho ")
print("en localizar tu blanda y fresca sangre, morderla, desgarrarla...."+CR)
print("El dolor es inmenso, no hay zona de tu cuerpo que no haya sido mordida y atacada, y pronto caes insconsciente ")
print("ante el asalto de dolor y hedor al que te enfrentas. An desmayado sigues sintiendo como engullen tus ")
print("entraas, sacan tus vsceras... cuando por fin a uno le da por abrirte la cabeza y sorberte los sesos..."+CR)
print("En ese instante, el alivio viene a tu ser..."+CR)
pause(0)
ScreenCls(0)
ScreenAt(0,240,170)
print("\[RGB(FF0000)]\[18]\[N]GAME OVER\[N]"+CR+tipo_letra+color_letra)
pause(2000)
ScreenAt(0,0,270)
Abandonar()

CASE 1
// Devorado por zombies
print("Al caer en la insconsciencia, sientes como ")
print("ms y ms zombies se unen al festn."+CR)
pause(0)
ScreenCls(0)
ScreenAt(0,240,170)
print("\[RGB(FF0000)]\[18]\[N]GAME OVER\[N]"+CR+tipo_letra+color_letra)
pause(2000)
ScreenAt(0,0,270)
Abandonar()

CASE 2
// Final relatado del juego
print("En un instante hay un flash que te ciega, no es sino la velocidad con la que te ")
print("precipitas a tu cuerpo, el cual reclama lo que es tuyo/suyo..." + CR)
print("El retorno es doloroso, los nervios inactivos reclaman informacin, el ")
print("cerebro se reactiva originando una tormenta." + CR)
print("Todo se vuelve oscuro, mientras notas como los rayos se expanden por tus ")
print("nervios adormilados.... el dolor... tu cuerpo se convulsina por la descarga que ")
print("est recibiendo. Observas miles de luces viajando al infinito. Durante un ")
print("instante te sientes infinito..." + CR)
pause()
ScreenCls(0)
print("La tormenta se apaga al fin, la vista se vuelve nublosa y observas la pared.")
print("Tienes la cabeza ladeada. Una baba caida resbala por tu barbilla. Te cuesta ")
print("controlar tu cuerpo." + CR)
print("Al fin reunes fuerzas para incorporarte un poco. La cabeza te late an con fuerza ")
print("despus de la 'extraa' experiencia. No puedes reprimir un sollozo. Has pasado ")
print("mucho miedo. El salto ha sido increible, pero la tormenta terrible. No sabes si ")
print("reir o llorar por lo acontecido:" + CR)
print("\[N]\[C]Has tenido un viaje Astral!!!\[C]\[N]" + CR)
print("An aturdido te levantas y enciendes el ordenador. Se te hace extrao el tacto ")
print("del botn de arranque: solidez." + CR)
print("Te sientas delante del ordenador y te dispones a relatar la maravillosa ")
print("experiencia vivida.")
pause()
Screen(pant_info)
ScreenCls(pant_info)
ScreenAt(pant_info,250,0)
print("\[C]\[N]EL FIN\[N]\[C]")
screen(0)

ScreenCls(0)
print("\[C]     Debo de estar loco, o al menos eso me repeta a mi mismo hace un rato. No por lo que me ")
print("ha pasado, que lo tengo ms que asumido, sino por el hecho de haberme decidido a narrarlo, y narrar ")
print("tambin todo lo relacionado con ello. Y a narrarlo a las 5:13 horas de la madrugada del domingo ")
print("al lunes, en noviembre, a finales del mes y del ao 96." + CR)

print("     Me ha costado eso de un cuarto de hora decidirme a levantarme y escribir. Un cuarto de ")
print("hora pensando y dndole vueltas a la idea, acongojado en la oscuridad, con la piel de gallina y ")
print("temblando a las sombras. Miedo y a la vez gozo: no quepo en mi gozo de lo que he ")
print("experimentado esta noche, y esa alegra ha hecho que est aqui. No se porqu ni a quin va ")
print("dirigido esto, pero ya ver que hago, quizs un juego..." + CR)

print("     Pues bien, estaba yo durmiendo plcidamente, cuando he entrado en uno de estos sueos ")
print("que se vuelven controlables, sueos en los que estoy semiconsciente y puedo controlar a mi ")
print("voluntad el curso del sueo, o por lo menos si soy yo el protagonista. Yo soy muy propicio a estos ")
print("tipos de sueos, no digo que los tenga todos los das, quizs ni siquiera sean mensuales. Pero tengo ")
print("presente que me han pasado a menudo y que puedo recordar siquiera un poco de que iban, ya que ")
print("yo suelo olvidar rapidamente mis sueos (esa ha sido otra razn para levantarme y no escribir esto" )
print("a otras horas ms decentes)." + CR)

print("     En estos sueos, como ya he dicho yo soy el entero protagonista, y controlo mis acciones ")
print("sin saber lo que va a pasar, aunque a veces incluso puedo controlar acontecimientos, o ")
print("simplemente despertarme de una pesadilla y continuarla en estado de duermevela porque me ")
print("interesaba el desarrollo de la historia; o todo lo contrario, de estando inmerso en un terrible ")
print("sueo, cortar por lo sano y despertarme a caso hecho, o sea: yo en el sueo pienso que tengo ")
print("que despertarme, hago un esfuerzo y lo consiguo." + CR)
pause()
ScreenCls(0)

print("     Bueno pues yo estaba soando que en beda, cerca del Hospital de Santiago, haba como ")
print("unos zombies con la cara deformada, y era como un videojuego, no paraban de salir y yo no ")
print("paraba de matarlos, pero se acumulaban demasiado y tena que escapar y rodearles por otro lado ")
print("(ultimamente juego demasiado al Duke Nukem 3d) para seguir la carnicera. Hasta que decido ")
print("escapar por el 18 Julio abajo. Naturalmente, todo esto narrado con inmensas lagunas de sueo ")
print("olvidado, pues al pasar a la segunda fase del sueo, se me iba olvidando el principio, de manera ")
print("que siempre me acuerdo sobre todo del final. Adems aunque el Hospital y la calle cuesta abajo ")
print("del 18 Julio existen, en el sueo no se parecan mucho al real, aunque yo tena consciencia de los ")
print("lugares donde me hallaba. Bueno, pues yo iba cuesta abajo (de mayor pendiente que la real), con ")
print("un paisaje muy amplio, de gran altura, y conforme ")
print("bajaba se estaba formando y se divisaba ms abajo una espesa niebla muy propicia para ms ")
print("zombies (o al menos eso pensaba yo en el sueo). La niebla ya era alcanzable con la mano, y quera ")
print("cogerla, comprobar que estaba ah, y al rato pensaba que podra nadar en ella de lo espesa que era. ")
print("As que de un salto y agitando los brazos me elevaba y me elevaba... Y aqui se produce el salto ")
print("del sueo a la 'experiencia'. El sueo se desvanece y noto que me quiero dejar ir, abandonar y ")
print("salir. Yo s lo que me pasa, o lo intuyo (soy del todo consciente), me dejo llevar y no me ")
print("resisto, y hoy me ha ocurrido lo que jams me atrev a continuar tan lejos..." + CR)
pause()
ScreenCls(0)

print("     La sensacin, en un instante breve de tiempo normal (unos 3 segundos), es que veo por ")
print("mis ojos, tumbado en la cama y me elevo, como si mis pies se descolgaran de mis pies, y hago un ")
print("movimiento de ascenso, enganchado por un  pelo con un pelo de mi cabeza, un movimiento con ")
print("el eje de simetra en la cabeza y el punto de movimiento el los pies. Veo por mis ojos que me pongo boca ")
print("abajo, suavemente pero en un instante (no lo puedo narrar bien, es inexplicable, como los horrores ")
print("de Lovecraft), en un scroll la vista de mi ventana pasa ante mis ojos y lo veo todo al revs. Pero ")
print("me asusto (como siempre me pasa), la sensacin es muy fuerte y decido volver. Lo decido al igual ")
print("que me despierto de esas pesadillas, bruscamente, como meneando la cabeza violentamente para ")
print("zafarse de una vista borrosa, y borroso es el regreso. Poco a poco se me aclara todo, y continuo ")
print("agazapado en la misma posicin en la que he vuelto. Al principio flipado y alegre por ")
print("la experiencia, ya que nunca la haba sentido tan vvida, y nunca lo haba hecho tanto tiempo. O ")
print("sea que..." + CR)

print("     Que esto ya me ha ocurrido muchsimas veces, pero nunca durante tanto tiempo, o con ")
print("tanta consciencia de ello. No es que haya sido ms tiempo que las otras veces, sino que ")
print("ahora saba lo que pasaba y antes no. Y pasaba 'el paseo' embobado hasta que me asustaba y ")
print("regresaba de forma hasta dolorosa." + CR)

print("     Tengo cierta reminiscencia que de pequeo tena sueos sobre que yo me converta en ")
print("infinito, como un haz de luz viajando en el vaco durante un tiempo infinito, hasta que me ")
print("'despertaba' y me cuesta recuperar el control de su cuerpo, con la ")
print("boca abierta y babeando. Eran sueos hasta que hace poco, har un ")
print("ao, que lo relacion con todas estas experiencias 'raras' que tengo. Yo creo que son viajes astrales ")
print("(cortos porque todava no he viajado a lugares remotos), pero siempre me asusto ")
print("y regreso, y entonces o a veces, me dan convulsiones...." + CR)
pause()
ScreenCls(0)


print("    Todo comenz una vez de pequeo, mi madre me dijo que ibamos al ")
print("mdico, que le iban a sacar sangre a ella. -Y yo tengo que ir? - preguntaba Alberto infeliz. No ")
print("recuerdo al final para que leches era aquel anlisis de sangre que me hicieron. El caso es que yo me ")
print("someta tranquilo a la enfermera y me hablaba con buenas palabras sobre la jeringa y la goma. ")
print("Pelleja! - le dira ahora. Me pincharon, y yo tan normal miraba por la ventana, y me vino un ")
print("pensamineto de que: 'Yo voy a aprobar, y todos mis compaeros no, y yo pasar de curso y ellos ")
print("se quedarn atrs, Gonzalo, Ricardo, Carlos, y ya no los ver ms...'. Me acuerdo perfectamente. Lo pensaba ")
print("repetitvamente, hasta que me vino la 'caida de las estrellas' que ya he narrado antes. Cuando ")
print("despert, estaba en el suelo, y oa todo, el vuelo de las moscas, los roces de zapatos y zapatillas de ")
print("mi madre y la emfermera, aumentadas de volumen que me atronaban. Fui recuperndome poco a ")
print("poco, y me dijo mi madre que me haba desmayado y que en el suelo haba tenido convulsiones ")
print("fuertes (Y me seco las lgrimas de los ojos: tengo los pelos de punta mientras escribo!!!). ")
print("Recuerdo, que iba por el ambulatorio como un zombie, con los oidos atronados todava, y me tena que tumbar ")
print("para no caerme. Me recuper, y supongo que mi madre me compr un Mortadelo y Filemn ")
print("(como cada vez que bamos al mdico), y yo feliz y contento." + CR)

print("     Y pasaron los aos, y desarroll una fobia tremenda a las jeringas, y ms si estn pinchadas ")
print("en brazos, y ms si es el mo. Y an les tengo pnico. Yo no lo saba por entonces, ni siquiera me ")
print("dan miedo, es un repels, y un rechazo instintivo." + CR)

pause()
ScreenCls(0)


print("    Una vez, el 'despertar' me cost mucho, y me asust especialmente: simplemente, mis ")
print("miembros no me respondan, y mi cabeza permaneca recostada de lado, la boca abierta y una ")
print("baba caida. Poco a poco me recuper. Siempre al despertar me daba esa sensacin de NO ")
print("CONTROL, y es muy desagradable." + CR)

print("     Con el tiempo y en COU, tuve casos de esos pero ya no eran tan desmayos, eran ms ") 
print("sueos y la sensacin de que me iba a flotar por ah, pero volva y me daban las tormentas ms o ")
print("menos fuertes y poco a poco fui tomandole el inters al asunto, y soaba y entonces decida ")
print("'viajar', etc etc, como esta misma noche me ha ocurrido." + CR)

print("     Una vez me tumb cansado en unos sillones, y decid intentar hacerlo. La sensacin de que ")
print("me iba vino, pero un tremendo chispazo en mi interior me hizo despertar de un salto. A partir de ")
print("ah asoci los ataques con las salidas de paseo del alma, y desarroll esta teora:"+CR)
print("     El alma intenta ")
print("salir del cuerpo, soy consciente y la sensacin es muy fuerte, siempre me he asustado o el cuerpo ")
print("me ha recuperado. Es como al desprenderse del alma, el cuerpo se muriera, y al volver el alma, ")
print("tiene que recuperar el control aletargado de la parte fsica con una descarga de energa a travs de ")
print("todos los nervios del cuerpo. Todo el mundo sabe que pensamos y nos movemos por impulsos del ")
print("cerebro, pues imaginaos que ese impulso fueran unos cuantos voltios...  Yo creo que es una ")
print("defensa de mi cerebro contra una 'muerte' del cuerpo si el alma se va." + CR)
pause()
ScreenCls(0)

print("     Hay que tener en cuenta que cada vez que me pasaba algo por el estilo, me paraba a ")
print("reflexionar, y son muchos aos ya de meditacin y experiencia. Pero le tengo miedo: y si la ")
print("reactivacin del cuerpo no funcionase y la pelase de verdad?,  y si mi alma se quedase vagando ")
print("por el limbo, y mi cuerpo en coma?. La curiosidad me dice una y otra vez que lo intente, que lo ")
print("haga, pero no quiero morir tan joven!. Despus de esta noche no creo que lo intente por mi slo, ")
print("por mi propia voluntad como cuando el 'chispazo' que me despert. Pero si me viene en un sueo ")
print("como me ha pasado esta noche, lo hara, y quizs llege un poco ms lejos, y me contemple a mi ")
print("mismo en la cama desde lo alto del techo, y quizs suba a ver como es la vecina del sexto, o ")
print("viajara a Ubeda." + CR)

print("     He oido hablar por ah de drogas naturales que potencian la mente y propician los viajes ")
print("astrales, como 'la soga del ahorcado', una liana de las selvas de porahyquiensabedonde. Tambin ")
print("he leido casos de gente normal y chavales con experiencias parecidas a la ma. Pero todos ")
print("coincidimos en esto: la sensacin es casi un xtasis, la sensacin de ingravidez. Alguien pasa ")
print("lianas de esas a precio de 'costo'?." + CR)

print("     Todo esto contado es verdico, no es ningn cuento (yo no tengo estilo para escribir). ")
print("Ahora bien, si lees esto, o te lo crees o no te lo crees, eso es cosa tuya. Mientras tanto, yo seguir ")
print("probando, y si algn da sientes mi presencia, an separados por kilometros fsicos, acurdate de ")
print("mi y desame suerte. Son las 7:31 de la maana..." + CR)
pause()
ScreenCls(0)
ScreenAt(0,240,170)
print("buenas noches a todos."+CR)
Pause(700)
Abandonar()
CASE *
    Abandonar()
EndSelect

If hay_sonido Then
    UnloadWav(sonido)
EndIf
Exit
// FIN DEL JUEGO
return

