\ advtr.f (buggy)  Leo Wong  28 June 02003 fyj +
\ Adventure in Forth after ADVENT.FOR by Will Crowther and Don Woods
\ ftp://ftp.gmd.de/if-archive/games/source/advent-original.tar.gz
\ Uses ADVENT.DAT.  Defaults to cave always open at start
\ Datime from 1967 because of TIME&DATE bug in my version of GForth
\ ANS with addition of DEFER IS. Heavy use of VALUE.  No variables.
\ Only arrays are stored to and fetched from.
\ Please e-mail bug corrections to: hello@albany.net
\ This version loads and runs in GForth, Win32For, VFX Forth,
\ SwiftForth, and PFE

MARKER game
: reset  ( -- )
   game  S" ADVTR.F" INCLUDED ;

INCLUDE TOOLS.F  :: INCLUDE BUG.F UTILS.F ;

((  With few exceptions, differences from the Fortran version are
inadvertent.  Comments closely follow the Fortran version. For example:

Adventures
Current limits:
\   9650 words of message text (lines, maxLines).
    750 travel options (travel, maxTravel).
    300 vocabulary words (ktab, atab, maxVocab).
    150 locations (ltext, stext, key, cond, abb, atloc, maxLocs).
    100 objects (plac, place, fixd, fixed, link (twice), ptext, prop).
     35 "action" verbs (actspk, maxActs).
    205 random messages (rtext, maxRndMsgs).
     12 different player classifications (ctext, cval, clsmax).
     20 hints, less 3 (hintlc, hinted, hints, maxHints).
     35 magic messages (mtext, maxMagMsgs).

     There are also limits which can't be exceeded owing to the
structure of the database (e.g., the vocabulary uses n/1000 to
determine word type, so there can't be more than 1000 words).  These
upper limits are:
   1000 non-synonymous vocabulary words
    300 locations
    100 objects ))

S" ADVENT.DAT" string database

:: constants    \ 500 maxLines  \ 9650 in source
                750 maxTravel
                300 maxVocab
                150 maxLocs
                100 maxObjects
                 35 maxActs
                205 maxRndMsgs
                 12 maxPlayerClasses
                 20 maxHints
                 35 maxMagMsgs
                 79 maxTreasures
                  6 maxDwarfs ;

:: arrays  \ maxLines Lines
           maxTravel Travel
           maxActs Actspk
           maxRndMsgs rtext
           maxMagMsgs mtext
           20 tk ;

CREATE holiday 21 CHARS ALLOT
: hname  ( -- a u )  holiday COUNT ;
S" Christmas" holiday place \ for example

maxVocab :: narrays  ktab atab ; DROP
maxLocs :: narrays ltext stext key cond abb atloc ; DROP
maxObjects :: narrays  plac place fixd fixed ptext prop ; 2* array link
maxPlayerClasses :: narrays ctext cval ; DROP
maxHints :: narrays  hintlc hinted ;  4 2array hints
maxDwarfs  :: narrays dseen dloc odloc ; DROP

DEFER start
0 :: values blklin ( yes ) ;  DROP
0 :: values wkday wkend holid hbegin hend short magic
            magnm latncy saved savet ; DROP
0 :: values tally tally2 ; DROP
0 :: values k kk ; DROP
79 VALUE maxtrs

0 :: values dtotal attack stick ; DROP  \ dwarf stuff values
0 :: values loc newloc oldloc oldloc2 ; DROP
0 :: values score mxscor ; DROP
0 VALUE yea

\ Other flags and counters placed here because holdng needed for
\ objects.f
 0 VALUE turns  \ commands he's given (ignores yes/no)
 0 VALUE limit  \ Lifetime of lamp.  Set later
 0 VALUE iwest  \ times he's said "west" instead of "w"
 0 VALUE knfloc \ 0=no knife here, loc=knife here, -1=after caveat
 0 VALUE detail \ times we've said "Not allowed to give more detail"
 5 VALUE abbnum \ times we should print non-abbreviated descriptions
 0 VALUE numdie \ times killed so far
 0 VALUE maxdie \ reincarnation messages available (up to 5)
 0 VALUE holdng \ of objects being carried
 0 VALUE dkill  \ dwarfs killed - unused in scoring, needed for msg
 0 VALUE foobar \ current progress in saying "fee fie foe foo"
 0 VALUE bonus  \ used to determine bonus amount if he reaches closing
30 VALUE clock1 \ turns from finding last treasure to closing
50 VALUE clock2 \ turns from first warning till blinding flash

\ flags              TRUE means:
FALSE VALUE lmwarn \ He's been warned about lamp going dim
FALSE VALUE closng \ It's closing time
FALSE VALUE panic  \ He's found out he's trap in the cave
FALSE VALUE closed \ We're all the way closed
FALSE VALUE gaveup \ He exited via "quit"
FALSE VALUE scorng \ Tells score routine it's "score" command

0 VALUE setup  \ apparently can be 0 , 1, 2 , 3 , -1 ?

:: INCLUDE IO.F WIZARDRY.F ;

\ "statement functions"
\ toting? True if object is being carried
: toting?  ( object -- flag )
   place @ -1 = ;

\ here? True if object is at location or being carried
: here?  ( object -- flag )
   DUP place @ loc = SWAP toting? OR ;

\ at? True if object is next to a two-placed object
: at?  ( object -- flag )
   loc >R  DUP place @ R@ =  SWAP fixed @ R> = OR ;

\ liq, etc. after "mnemonics"
\ bitset? True if cond(l) had nth bit set?
: bitset?  ( l n1 -- n2 )
   >R cond @ 1 R> shift AND ;

\ Location moves without asking for input
: forced?  ( loc -- flag )
   cond @ 2 = ;

\ True n percent of the time
: pct?  ( n -- flag )
   100 ran > ;

\ Database input
\ Database setup if setup=0
setup 0= [IF]

  CR .( Initializing...)

  1 ltext maxLocs CELLS ERASE
  1 stext maxLocs CELLS ERASE
  1 ptext maxObjects CELLS ERASE
  1 rtext maxRndMsgs CELLS ERASE
  1 ctext maxPlayerClasses CELLS ERASE
  1 mtext maxMagMsgs CELLS ERASE
  1 key maxLocs CELLS erase
  1 cond  maxLocs CELLS ERASE
  1 plac  maxObjects CELLS ERASE
  1 fixd  maxObjects CELLS ERASE
  1 actspk maxActs CELLS ERASE
  1 ktab maxVocab CELLS -1 FILL
 
\ Assume word> is a number; return its value and remaining string
: <n>  ( ca1 u1 -- ca2 u2 n )
   word> #eval ;

0 VALUE nnow
\ 1 VALUE line#
DEFER textpointer

: text,  ( ca u -- ) \ Sections 1 2 6 10 12, text messages
   \ Message addresses are stored in pointers
   <n> DUP nnow >
     IF TO nnow 0 C, HERE  ( DUP line# lines ! line# 1+ TO line# ) 
           nnow textpointer !  
     ELSE DROP THEN skip-white string, ;

1 VALUE trvs   
: travel,  ( ca u -- )  \ Section 3, travel table
   \ from-loc newloc motion-number(s)
   \ Each "from-location" gets a contiguous
   \ section of the "travel" array.  Each entry in travel is
   \ newloc*1000 + keyword (from Section 4, motion verbs, and is
   \ negated if it is the last entry for this location.  key(n) is
   \ the index in travel of the first option at location n.
   <n> ( fromloc ) DUP key @ 
     IF DROP trvs 1- travel DUP @ NEGATE SWAP !
     ELSE trvs SWAP key ! THEN
   <n> ( newloc )  >R
   BEGIN DUP WHILE <n> ( motion-number ) R@ 1000 * + trvs travel !
                   trvs 1+ DUP TO trvs maxTravel = IF 3 bug THEN
   REPEAT 2DROP R> DROP 
   trvs 1- travel DUP @ NEGATE SWAP ! ;

0 VALUE tabndx
: vtext,  ( ca u -- )  \ Section 4, vocabulary
   \ ktab(n) is the word number, atab(n) is the corresponding "word."
   \ "word" is given a minimal hash
   nnow 1+ TO nnow  <n> nnow ktab !  word> phrog nnow atab ! 2DROP
   tabndx 1+ TO tabndx ;

: ptext,  ( ca u -- )  \ Section 5, object descriptions
   2DUP word> DUP 3 <
   IF 0 C, #eval TO nnow HERE nnow textpointer !
   ELSE 2DROP THEN  2DROP string, ;

: locs,  ( ca u -- )  \ Section 7, Object Locations
   \ plac contains the initial locations of objets.  fixd is -1 for
   \ immovable objects (including the snake), or = second loc for two-
   \ placed objects.
   <n> >R <n> R@ plac ! word> DUP IF #eval R@ fixd ! ELSE 2DROP THEN
   2DROP R> DROP ;

: acts,  ( ca u -- ) \ Section 8, action defaults.  
   <n> >R <n> R> actspk ! 2DROP ;

: liqs,  ( ca u -- )  
   \ Store in cond info about liquids and other assets conditions
   <n> ( bit ) >R
   BEGIN DUP WHILE <n> ( location ) DUP R@ bitset? IF 8 bug THEN
      cond DUP @ 1 R@ shift OR SWAP !
   REPEAT 2DROP R> DROP ;

\ ctext, Compile Section 10, player classifcation messages
0 VALUE clsses
: ctext, ( ca u -- )
   nnow 1+ DUP TO nnow  TO clsses
   <n> nnow cval ! HERE nnow textpointer ! skip-white string, 0 C, ;

\ hints, Compile Section 11, hints
0 VALUE hntmax
: hints, ( ca u -- )
   <n> DUP hntmax MAX maxHints MIN to hntmax
   5 1 DO >R <n> R> TUCK I hints ! LOOP DROP 2DROP ;

defer read-action
CREATE px :: ',
\ pointer action
  ltext   2DROP   \  0 End of database
  ltext   text,   \  1 Location descriptions (long)
  stext   text,   \  2 Location descriptions (short)
   noop   travel, \  3 Travel table
  ltext   vtext,  \  4 Vocabulary
  ptext   ptext,  \  5 Object descriptions
  rtext   text,   \  6 Arbitrary messages
   noop   locs,   \  7 Object locations
   noop   acts,   \  8 Action defaults
  ltext   liqs,   \  9 Liquid assets, etc.
  ctext   ctext,  \ 10 Player classifications
   noop   hints,  \ 11 Hints
  mtext   text,   \ 12 Magic messages
 ;

\ pact  Set textpointer (if any) and read-action for a section
: pact  ( n -- )
   0 MAX 2* CELLS px + 2@ IS textpointer IS read-action ;

: xRead  ( ca u -- )
   OVER C@ [CHAR] - =
   IF 2DROP 0 C,
   ELSE DUP 3 < IF #eval pact 0 TO nnow
   ELSE read-action THEN THEN ;

: read-database   ( -- )
   \ don't know why this is here or what it's for
   21 1 DO I I tk ! LOOP
   database R/O OPEN-FILE THROW >R
   BEGIN PAD DUP 84 R@ READ-LINE THROW WHILE xRead REPEAT 2DROP 
   R> CLOSE-FILE THROW ;
   read-database
   1 TO setup

[THEN]

:: INCLUDE VOCAB.F OBJECT.F ;

\ -2setup Finish constructing internal format if setup <> 2
\  not needed if setup = 2, goes to 8305 if setup = -1
setup 2 <> [IF]
   (( Having read in the database, certain things are now constructed.
      Props are set to zero.  Conds are finished by checking for
      forced-motion travel entries.  The plac and fixd arrays are used
      to set up atloc(n) as the first object at loation n, and
      link(obj) as the next object at the same location as obj.
      (obj>100 indicates that fixed(obj-100)=loc; link(obj) is still
      the correct link to use.)  abb is zeroes; it controls whether
      the abbreviated description is displayed.  counts mod 5 unless
      "look" is used. ))

   1 place maxObjects CELLS ERASE
   1 prop maxObjects CELLS ERASE
   1 link maxObjects 2* CELLS ERASE

:NONAME
   maxLocs 1+ 1 DO 
   0 I abb !
   I ltext @ 0<> I key @ 0<> AND
     IF I key @ travel @ ABS 1000 MOD 1 = IF 2 I cond ! THEN THEN
     0 I atloc !
   LOOP ; EXECUTE

:NONAME
    1 maxObjects  \ from 100 to 1  
    DO I fixd @ 0> IF  I 100 + I fixd @ drop-object
                       I I plac @ drop-object THEN
    -1 +LOOP
    1 maxObjects
    DO I fixd @ I fixed !
       I plac @ I fixd @ 0> 0= AND IF I I plac @ drop-object THEN
    -1 +LOOP ; EXECUTE

\ treasures
0 TO tally
0 TO tally2
:NONAME
  maxTreasures 1+ 50 
  DO I ptext @ IF -1 I prop ! tally 1+ TO tally THEN LOOP ; EXECUTE

\ Clear the hint stuff.  Hintlc(i) is how long he's been at loc with
\ cond bit i.  Hinted(i) is true iff hint i has been used.

  1 hinted maxHints ERASE
  1 hintlc maxHints ERASE

\ Define some handy "mnemonics."
: parsevocab  ( n1 -- n2 ) parse-word 2 PICK vocab ; 
: mne parsevocab CONSTANT ;

1 :: mne
    \ These correspond to object numbers:
    keys  keys     lamp lamp     grate grate    cage  cage
    rod   rod      steps steps   bird  bird     door  door
    pillo pillow   snake snake   fissu fissure  table tablet
    clam  clam     oyste oyster  magaz magzin   dwarf dwarf
    knife knife    food  food    bottl bottle   water water
    oil   oil      plant plant   axe   axe      mirro mirror
    drago dragon   chasm chasm   troll troll    bear  bear
    messa messag   vendi vend    batte batter

    \ Objects form 50 through whatever are treasures.
    \ Here are a few:
    gold  nugget   coins coins   chest chest    eggs  eggs
    tride trident  vase  vase    emera emerald  pyram pyram
    pearl pearl    rug   rug     chain chain    spice spice ; DROP

0 :: mne
    \ These are motion-verb numbers:
    back  back     look  look    cave  cave     null  null
    entra entrance depre dprssn ; DROP

2 :: mne
    \ And some action verbs:
    \ Two nice Forth words redefined here!!
    say   say      lock  lock    throw throw    find  find
    inven invent ; DROP

rod 1+ CONSTANT rod2 
plant 1+ CONSTANT plant2 
troll 1+ CONSTANT troll2

\ * LIQ * DARK FUNCTIONS * \
: liq2  ( pbotl -- n )
   \ n=object number. Factor of liq & liqloc
   1 OVER - water * SWAP 2/ water oil + * + ;

: liq ( --  n )
   \ Object number of liquid in a bottle
   bottle prop @ -1 OVER - MAX liq2 ;

: liqloc  ( loc -- n )
   \ Object number of liquid - if any - in location
   cond @ DUP 2/ 2* 8 MOD 5 - SWAP 4 / 2 MOD * 1+ liq2 ;

\ dark? True if location is dark
: dark?  ( -- flag )
   loc cond @ 2 MOD 0=  lamp prop @ 0= lamp here? not OR AND ;

\  True if the loc he's leaving was dark
FALSE VALUE wzdark

\ Initialize Dwarfs
\     dloc is loc for dwarfs, hardwired in.  odloc prior loc for each
\ dwarf, initially garbage.  daltlc is alternate intial loc for
\ dwarf, in case one of them starts out on top of the adventurer.
\ No 2 of the 5 initial locs are adjacent.)  Dseen is true if dwarf
\ has seen him.  dflag controls the level of activation of all this:
\      0  No dwarf stuff yet (wait until reaches Hall of Mists
\      1  Reached Hall of Mists but hasn't met first dwarf.
\      2  Met first dwarf, others start moving.  No knives thrown yet
\      3  A knife has been thrown (first set always misses)
\      3+ dwarfs are mad (increases their accuracy)
\ Sixth dwarf is special (the pirate).  He always start at his
\ chest's eventual location inside the maxe.  This loc is saved in
\ chloc for ref.  The dead end in the other maze has its loc stored in
\ chloc2.
   
    114 VALUE chloc
    140 VALUE chloc2
      0 VALUE dflag
      1 dseen maxDwarfs ERASE
     19 1 dloc !
     27 2 dloc !
     33 3 dloc !
     44 4 dloc !
     64 5 dloc !
  chloc 6 dloc !
     18 VALUE daltlc

\ other random flags and counters 

0 TO turns
FALSE TO lmwarn
0 TO iwest
0 TO knfloc
0 TO detail
5 TO abbnum
:NONAME 4 0 DO I 2* 81 + rtext @ IF I 1+ TO maxdie THEN LOOP ; EXECUTE
0 TO numdie
0 TO holdng
0 TO dkill
0 TO foobar
0 TO bonus
30 TO clock1
50 TO clock2
0 TO saved
FALSE TO closng
FALSE TO panic
FALSE TO closed
FALSE TO gaveup
FALSE TO scorng

[THEN]
\ If setup = 1, report on the amount of arrays actually used, to
\ permit reductions.  Some of these values probably aren't needed
\ later a can be limited

setup 1 = [IF]

   2 TO setup

:NONAME  ( -- )
 1 MaxLocs
 DO I ltext @ IF I LEAVE THEN -1 +LOOP ; EXECUTE TO k

0 VALUE obj
:NONAME  ( -- )
  maxObjects 1+ 1 DO I ptext @ IF obj 1+ TO obj THEN LOOP ; EXECUTE

:NONAME ( -- )
  0 tabndx 1+ 1
  DO I ktab @ 1000 / 2 = IF DROP I ktab @ 2000 - THEN LOOP ; EXECUTE
  VALUE verb

:NONAME  ( -- )
  1 maxRndMsgs
  DO I rtext @ IF I LEAVE THEN -1 +LOOP ; EXECUTE VALUE jj

:NONAME  ( -- )
  1 maxMagMsgs
  DO I mtext @ IF I LEAVE THEN -1 +LOOP ; EXECUTE VALUE ii

: .of  ( ca u n1 n2 -- )
   CR 6 .R SPACE ." of" 6 .R SPACE TYPE ;

CR .( Table space used:)
\ S" words of messages"maxLines          line# .of
S" travel options"   maxTravel          trvs .of
S" vocabulary words" maxVocab         tabndx .of
S" locations"        maxLocs              k .of
S" objects"          maxObjects          obj .of
S" action verbs"     maxActs            verb .of
S" RTEXT messages"   maxRndMsgs           jj .of
S" CLASS messages"   maxPlayerClasses clsses .of
S" hints"            maxHints         hntmax .of
S" MAGIC messages"   maxMagMsgs           ii .of
CR

poof 

.( INIT Done )

[THEN]  

\ Startup, dwarf stuff
0 VALUE demo

DEFER describe-loc \ 2000
DEFER dwarf-stuff  \ 6000
:: DEFER
    loc2000 loc2009 loc2010 loc2011 loc2012 loc2600 loc2602 loc2608
    loc19999 loc2610 loc2630 loc5190 ?score ;

:: DEFER newloc8 newloc9 newloc12 ;

\ Can't leave cave once it's closing (except by main office).
: start2  \ 2 
   BEGIN 
      db?
      IF CR ." start2 turns=" turns . ." loc=" loc . .s 
            ." dflag=" dflag .  maxDwarfs 1+ 1 do i dloc ? LOOP
            ." dkill=" dkill . ." saved=" saved . ." tally=" tally .
            ." clock1=" clock1 . ." clock2=" clock2 . THEN
      newloc DUP 9 < 0= SWAP 0= OR closng 0= OR not
      IF 130 rspeak  loc TO newloc
         panic not IF 15 TO clock2 THEN TRUE TO panic THEN
      \ See if dwarf has seen him and has come from where he wants to
      \ go.  If so, the dwarf's blocking his way.  If coming from place
      \ forbidden to pirate (dwarfs rooted in place0 let him get out
      \ (and attacked
      newloc loc =  loc forced? OR  loc 3 bitset? OR not    \ 71
      IF 6 1
         DO I odloc @ newloc <>  I dseen @ not OR not
            IF loc TO newloc 2 rspeak LEAVE THEN LOOP THEN  \ 73
        newloc TO loc 
      \ Dwarf stuff.  See earlier comments for description of
      \ variables. Remember sixth dwarf is pirate and is thus very
      \ different except for motion rules.
      \
      \ First off, don't let dwarfs follow him into a pit or a wall.
      \ Activate the whole mess the first time he gets as far as the
      \ Hall of Mists (loc 15).  If newloc is forbidden to pirate (in
      \ particular, if it's beyond the Troll Bridge), bypass dwarf
      \ stuff.
      \ That way pirate can't steal return toll, and dwarfs can't meet
      \ the bear.  Also means dwarfs won't follow him into dead end in
      \ maze, but c'est la vie. They'll wait for him outside the dead
      \ end.
      loc 0= loc forced? OR newloc 3 bitset? OR not
         IF dflag IF dwarf-stuff
         ELSE  loc 15 < 0= IF 1 TO dflag THEN THEN 
      THEN describe-loc
   AGAIN ;
   \ Rest of dwarf stuff in dwarf.f

: startup
   start TO demo
   FALSE motd
   1 DUP TO newloc TO loc
   3 TO setup
   330 TO limit
   65 1 0 yesr 3 hinted !
   3 hinted @ IF 1000 TO limit THEN 
   start2 ;

:: INCLUDE HINTS.F CLOSING.F ACTIONS.F SCORING.F DEAD.F DWARF.F ;
:: INCLUDE LOC.F NEWLOC.F ;

startup
