\ closing.f for advtr.f  Leo Wong 19 June 02003 fyj +

\ Cave Closing

((  These sections handle the closing of the cave.  The cave closes
"clock1" turns fater the last treasure has been located (including
the pirate's chest, which may of course never show up).  Note that the
treasures need not have been taken yet, just located.  Hence clock1
must be large enough to get out of the cave (it only ticks while inside
the cave).  When it hits zero, branch to 1000 to start closing the
cave, and then sit back and wait for the adventurer to try to get out.
If he doesn't within clock2 turns, close the gave; if he does try,
assume he panics, and give him a few additional turns to get frantic
before closing.  When clock2 hits zero, branch to 11000 to transport
him to the final puzzle.  Note that the puzzle depends upon all sorts
of random things.  For instance, there must be no water or oil, since
there are beanstalks which can't be watered because the code can't
handle it.  Also, no keys, since there is a grate (having moved the
fixed object!) there separating him from all the treasures.  Most of
these problems arise from the use of negative prop numbers to suppress
the object descriptions until he's actually moved the objects.

When the first warning comes, lock the grate, destroy the bridge, kill
all the dwarfs (and the pirate), revoe the troll and bear (unless
dead), and set "closing" to true.  Leave the dragon -- too much trouble
to move it.  From now until clock2 runs out, the adventurer can't
unlock the grate, move to any location outside the cave (loc<9) , or
crate the bridge.  Nor can he be resurrected if he dies.  Note that the
snake is already gone, since he got the treasure is via the Hall of
the Mt. King.  Aso he's been in giant room (to get eggs), so it can be
referred to.  Also also, he got the pearl, so the bivalve is an
oyster.  *And*, the dwarfs must have been activated, since the chest
has been found. ))

: closing10000
   0 grate prop !
   0 fissure prop !
   7 1 DO FALSE I dseen !  0 I dloc !  LOOP
   troll 0 move-object
   troll 100 + 0 move-object
   troll2 troll plac @ move-object
   troll2 100 + troll fixd @ move-object
   chasm juggle-object
   bear prop @ 3 <> IF bear destroy-object THEN
   0 chain prop !   0 chain fixed !
   0 axe prop !     0 axe fixed !
   129 rspeak
   -1 TO clock1
   TRUE TO closng
   loc19999 ;

(( Once he's panicked, and clock2 has run out, come here to set up
the storage room.  The room has two locs, 115 (NE) and 116 (SW).  At
the NE end, place empty bottles, a nursery of plants, a bed of oysters,
a pile of lamps, rods with stars, sleeping dwarfs, and the adventurer.
At the SW end, place grate over treasures, snake pit, covey of caged
birds, more rods, and pillows.  A mirror stretches across one wall.
Many of the objects come from known locations or states (e.g. the
snake is known to have been destroyed and needn't be carried away from
its old "place), make the various objecs to be handled differently.
Also drop all other objects the adventurer might be carrying (lest he
have some which could cause trouble, such as the keys).  Describe the
flash of light and trundle back. ))

: put-prop
   2 PICK >R put-object R> prop ! ;
: closing11000
   bottle 115 1 put-prop  plant 115 0 put-prop  oyster 115 0 put-prop
     lamp 115 0 put-prop    rod 115 0 put-prop   dwarf 115 0 put-prop
   115 DUP TO loc DUP TO oldloc to newloc 
   \ Leave the grate with normal (non-negative) property.
   grate 116 0 put-object DROP
   snake 116 1 put-prop    bird 116 1 put-prop    cage 116 0 put-prop
    rod2 116 0 put-prop  pillow 116 0 put-prop  mirror 115 0 put-prop
   116 mirror fixed !
   101 1 DO I toting? IF I destroy-object THEN LOOP
   132 rspeak
   TRUE TO closed
   ( go to 2 ) ;

(( Another way to force an end to things is by having the lamp give
out.  When it gets close, come here to warn the adventurer.  Go to
12000 if the lamp and fresh batteries are here, we which case replace
the batteries and continue.  12200 is for other cases of lamp dying.
12400 is when it goes out, and 12600 if if the adventurer wandered
outside and the lamp is used up, in which case we force him to give
up. ))
: lamp&batteries \ lamp and fresh batteries are here 12000
   188 rspeak
   1 batter prop !
   batter toting? IF batter loc drop-object  THEN
   limit 2500 + TO limit
   FALSE TO lmwarn
   loc19999 ;

: lamp-dying  \ other cases of lamp dying 12200
   lmwarn 0= lamp here? AND
   IF TRUE TO lmwarn
      batter prop @ 1 =
      IF 189 ELSE batter place @ 0= IF 183 ELSE 187 THEN THEN rspeak
   THEN loc19999 ;

: lamp-out  \ lamp goes out 12400
   -1 TO limit
    0 prop lamp !
    lamp here? IF 184 rspeak THEN
    loc19999 ;

: wandered-out-lamp-out \ 12600
    185 rspeak
    TRUE TO gaveup
    ?score ;

: wizard-ends-demo \ 13000 
    1 mspeak
    ?score ;

: death-by-dwarfs  \ 19000
    136 rspeak
    ?score ;

