/* $Id: dark.t 1.18 2001/08/16 19:23:25 mol Exp $
 * --------------------------------------------------------------
 * Darkness handling for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

#include "verbs.t"

/* 
 * The message "I don't see any <foo> here" doesn't make much
 * sense in the darkness, so we replace it.
 */
replace parseError : function(errno, string)
{
    if (global.allMessage <> nil) {
        local r;
	
	r := global.allMessage;
	global.allMessage := nil;
	return r;
    }
    else if (errno = 9)
 	return 'There doesn\'t seem to be any %s here.';
    else
        return nil;
}

modify thing
    darkReachable(verb, actor) = {
 	return self.isIn(actor);
    }
    touchdesc = "\^<< self.thedesc >> doesn't feel unusual. "
    verDoTouch(actor) = {  }
    doTouch(actor) = {
        self.touchdesc;
    }
;
    
modify floor
    darkReachable(verb, actor) = {
        return true;
    }
;    

modify theFloor
    touchdesc = "A cold, uneven rock surface, slightly slippery
        with moisture. "
    doSearch(actor) = {
        if (self.islit)
	    pass doSearch;
	    
        "You get down on your hands and knees and  
	search << self.thedesc >>, but you don't find 
	anything interesting. ";
    }
;

replace class darkroom : room
    darkseen = nil // True if the player has "seen" the room when dark

    darksdesc = self.sdesc

    islit = {
        local rem, cur, tot, i;

	if (self.lightsOn) 
 	     return true;

	rem := global.lamplist;
	tot := length(rem);
	for (i := 1; i <= tot; ++i) {
	    cur := rem[i];
	    if (cur.isIn(self) and cur.islit) 
	        return true;
	}
	return nil;
    }
    
    enterRoom(actor) = {
        local full;
	
        if (self.islit)
	    full := not self.isseen;
	else
	    full := not self.darkseen;
        self.lookAround(full or global.verbose);
	
        if (self.islit)	{
	    if (not self.isseen) 
	        self.firstseen;
	    self.isseen := true;
	}
	else {
	    if (not self.darkseen) 
	        self.firstdarkseen;
	    self.darkseen := true;
	}
    }

    statusLine = {
        "\(";
        if (self.islit)
            self.sdesc; 
	else
	    self.darksdesc;
	"\)";
    }

    nrmLkAround(verbosity) = {
        if (self.islit)
	    pass nrmLkAround;

	"\nIt is too dark to see anything.";
	if (verbosity and defined(self, &darkldesc))
            "\b<< self.darkldesc >>";

	if (defined(self, &message)) {
	    "\b";
	    self.message;
	}
    }

    noexit = {
        if (self.islit) 
	    pass noexit;
	else {
            "%You% hit your head on the wall. ";
	    return nil;
	}
    }
    
    roomCheck(v) = {
        if (self.islit or v.isDarkVerb or v.isDarkReachableVerb) 
	    return true;
	else {
	    "%You% can't see a thing.\n";
	    return nil;
	}
    }

    roomDrop(obj) = {
 	if (self.islit)
	    pass roomDrop;
	else
	    "If you drop anything now, you might
	    never find it again in the dark. ";
    }
    
    darkobj(verb, actor, obj) = {
	if (obj.darkReachable(verb, actor))
	    return true;
	"%You% can't seem to find it in the dark. ";
	return nil;
    }
    
    roomAction(actor, v, dobj, prep, io) = {
        if (not self.islit) {
	    // The verb can be performed in darkness if
	    // isDarkVerb is set, or if isDarkReachableVerb is set
	    // and both objects can be found
	    if (v.isDarkVerb) 
	        pass roomAction;
	    else if (v.isDarkReachableVerb) {
	        if ((dobj = nil or self.darkobj(verb, actor, dobj)) and
		    (io = nil or self.darkobj(verb, actor, io)))
		    pass roomAction;
	        else
	            exit;
	    }
	    // Otherwise it's too dark to perform the verb.
	    else {
	        "%You% can't see a thing. ";
	        exit;
	    }
	}
	pass roomAction;
    }
;

modify thing
    doThrowAt(actor, io) = {
        if (actor.location.islit)
	    pass doThrowAt;
        "If %you% throw away << self.thedesc >> now, %you% may
 	never find it again in the dark.";
    }
    doThrowTo(actor, io) = {
        if (actor.location.islit)
	    pass doThrowTo;
        "If %you% throw away << self.thedesc >> now, %you% may
 	never find it again in the dark.";
    }
;

modify floor
    ioThrowAt(actor, dobj) = {
        if (actor.location.islit)
	    pass ioThrowAt;
	else
	    dobj.doThrowAt(actor, self);
    }
    ioThrowTo(actor, dobj) = {
        if (actor.location.islit)
	    pass ioThrowTo;
	else
	    dobj.doThrowAt(actor, self);
    }
;

modify switchItem
    verDoTurnon(actor) = {
	if (not actor.location.islit and not actor.isCarrying(self))
	    "%You% can't find << self.thedesc >> in the dark. ";
	else 
	    pass verDoTurnon;
    }
;

/*
 * Modify basicMe so that the player can move between dark rooms.
 */
modify basicMe
    travelTo(room) = {
        if (room) {
	    if (room.isobstacle) 
	        self.travelTo(room.destination);
	    else {
                if (self.location) 
		    self.location.leaveRoom(self);
                self.location := room;
                room.enterRoom(self);
	    }
        }
    }
;

/*
 * Split up the functionality of the old inspectVerb into inspectVerb
 * and lookAtVerb, where only the former works in darkness.
 */
replace inspectVerb : deepverb
    verb = 'inspect' 'examine' 'x'
    sdesc = "examine"
    isDarkReachableVerb = true
    
    doAction = 'Inspect'
    validDo(actor, obj, seqno) = {
        return obj.isVisible(actor);
    }
    rejectMultiDobj(prep) = {
        "You can only << self.sdesc >> one thing at a time. ";
        return true;
    }
;

lookatVerb : deepverb
    verb = 'look at' 'l at'
    sdesc = "look at"
    doAction = 'Lookat'
    validDo(actor, obj, seqno) = {
        return obj.isVisible(actor);
    }
    rejectMultiDobj(prep) = {
        "You can only << self.sdesc >> one thing at a time. ";
        return true;
    }
;


modify thing
    darkdesc = {
        self.touchdesc;
    }
    
    verDoLookat(actor) = { }
    verDoInspect(actor) = { 
        if (actor.location.islit)
	    self.verDoLookat(actor);
	else
	    self.verDoTouch(actor);
    }
    doInspect(actor) = {
        if (actor.location.islit)
	    self.doLookat(actor);
	else
	    self.darkdesc;
    }
    doLookat(actor) = {
        self.ldesc;
    }
;


    	    
/* 	
 * Make some more verbs work in the dark. This should really be
 * done by making them inherit from darkVerb, but we can't modify
 * the inheritance afterwards so we set the isDarkVerb flag instead.
 */

modify takeVerb
    isDarkReachableVerb = true
;    

modify openVerb
    isDarkReachableVerb = true
;    

modify closeVerb
    isDarkReachableVerb = true
;    

modify jumpVerb
    isDarkVerb = true
;

modify sitVerb
    isDarkReachableVerb = true
;    

modify lieVerb
    isDarkReachableVerb = true
;    

modify iVerb
    isDarkVerb = true
;    

modify standVerb
    isDarkVerb = true
;    

modify sayVerb
    isDarkVerb = true
;    

modify yellVerb
    isDarkVerb = true
;    

modify moveVerb
    isDarkReachableVerb = true
;    

modify touchVerb
    isDarkReachableVerb = true
;    

modify eatVerb
    isDarkReachableVerb = true
;    

modify pushVerb
    isDarkReachableVerb = true
;    

modify pullVerb
    isDarkReachableVerb = true
;    

modify searchVerb
    isDarkReachableVerb = true
;    
 
/*
 * Make 'look' work in the dark.
 * Is this a paradox? Can we see in the dark? Not necessarily - but
 * we'll leave that decision to the room's lookAround() routine.
 */
modify lookVerb
    isDarkVerb = true
;

modify wearVerb
    isDarkReachableVerb = true
;

modify followVerb
    isDarkReachableVerb = true
;

modify putVerb
    isDarkReachableVerb = true
;

modify breakVerb
    isDarkReachableVerb = true
;

modify throwVerb
    isDarkReachableVerb = true
;

modify climbVerb
    isDarkReachableVerb = true
;


modify standOnVerb
    isDarkReachableVerb = true
;

