class monTopic: thing
	ioAskAbout(actor, dobj) = {
		if (monstrosity == dobj) {
			self.monKnows;
		} else {
			inherited.ioAskAbout(actor, dobj);
		}
	}
;

monstrosity: Actor, monTopic
	isHim = true
	isHer = true
	noun = 'alien' 'pilot' 'monstrosity' 'creature' 'itself' 'demon' 'rediculan'
	adjective = 'conscious'
	sdesc = "monstrosity"
	ldesc = {
		"This creature is truly hideous.  It looks mostly human in shape from the neck
		down, ignoring the boneless tentacular fingers.  But
		the head looks like a squid, with huge black liquid eyes and a
		mustache of wriggling tentacles.  Its skin color changes rapidly,
		passing through cycles of white, red, purple, blue, and yellow.";
		if (self == box.location) {
			"  The monstrosity has a little metal box strapped to its neck.";
		}
	}
	actorDesc = "The monstrosity is here, blinking nervously."
	smelldesc = "It smells vaguely fishy."
	listendesc = "It's silent for the moment."
	location = head
	monKnows = "\"I'm just a pilot.\""
	isbabbling = {return (self != Me.form &&
		!(box.isfixed && (box.isworn || self == box.location)));}

	actorDaemon = {
		if (isclass(Me.location, shiproom) && !self.isVisible(Me)) {
			self.moveInto(Me.location);
			"\bThe monstrosity ambles into the room.";
		}
		
		if (self.isVisible(Me)) {
			if (head == self.location && town == ropes.location) {
				"\bThe monstrosity goes over to the windows and looks out.  ";
				if (isbabbling) {
					"\"Flurka zomanomafiblerapopinkawiddledoo blorons
					kerfle?\"  Its eyes go wide and it turns white as
					snow.  \"Blabble ferunk zeep!  Yowza!  Merkunk
					felaffle wizzle rapple fo blooz!\"";
				} else {
					"\"What on XJ945378-3 are the natives doing out
					there?\"  Its eyes go wide and it turns white as
					snow.  \"They've tied the ship down!  Oh no!  We
					can't get away and we're all going to die!\"";
				}
				"\bIt flails about in panic and one of its tentacles hits
				the black button on
				the control panel.  A beeping ensues, and a green light
				appears on the edge of the display.  The monstrosity stops
				moving suddenly, then slowly turns toward the control
				panel.  In a low voice it says ";
				if (isbabbling) {
					"\"Straczynsky.  Zopple mey finic wix.  Burfle
					so winc dur flan.  Zeep.\"";
				} else {
					"\"Great Maker.  I've activated the emergency
					distress beacon.  The rescue ship will be here
					in minutes.  We're doomed.\"";
				}
				"  It collapses onto the floor.";
				display.alarm = true;
				notify(display, &rescueFuse, 1);
				self.faints;

			} else {
				switch (rand(15)) {
				case 1:
					"\bThe monstrosity takes a deep breath and holds it, then
					releases it.  Its skin fades to blue for a little while,
					but the color cycles soon resume.";
					break;
				case 2:
					"\bThe monstrosity turns white and glances around
					quickly, eyes blinking.";
					break;
				case 3:
					if (self == box.location) {
						"\bThe monstrosity fiddles for a bit with the little
						box on its neck.  Its hue turns more and more red until
						finally it mutters something you don't understand and
						leaves the box alone.";
					}
					break;
				case 4:
					"\bThe monstrosity pulls from an unseen pocket a small
					portrait of another creature like itself.  Its skin
					turns purple as it gazes, until with a sigh
					it puts the portrait away again.";
					break;
				case 5:
					"\bThe monstrosity waves its tentacular fingers at
					you in what is probably meant to be a friendly gesture,
					and its skin turns yellow.  You manage to suppress a
					shudder at the grotesqueness of it.";
					break;
				case 6:
					if (town == monstrosity.location) {
						"\bA woman screams \"It's a demon!\"";
					}
					break;
				default:
				}
			}
		}
	}
	faints = {
		local monnouns = getwords(self, &noun);
		
		ucm.moveInto(self.location);
		if (monstrosity == box.location) box.moveInto(ucm);
		unnotify(self, &actorDaemon);
		self.moveInto(nil);

		while (nil != car(monnouns)) {
			addword(ucm, &noun, car(monnouns));
			delword(self, &noun, car(monnouns));
			monnouns = cdr(monnouns);
		}
	}

	verDoAttackWith(actor, weapon) = {}
	doAttackWith(actor, weapon) = {
		"Without warning, you strike down the helpless squid-headed
		creature.  He lies unconscious before you.";
		self.faints;
	}

	canttalk = {
		"The monstrosity turns pale yellow";
		if (monstrosity == box.location) {
			".  A voice from the little box on its neck replies \"Lef
			gurkles, som dela tor ";		
			if (1 == rand(3)) {
				"unmatched socks.";
			} else {
				"nog fufu.";
			}
			"\"  The monstrosity bangs on the box for a moment, then shrugs
			helplessly.";
		} else {
			" and shrugs helplessly.";
		}
	}
	verDoAskAbout(actor, iobj) = {
		if (self.isbabbling) {
			self.canttalk;
		}
	}
	verDoTellAbout(actor, iobj) = {
		if (self.isbabbling) {
			self.canttalk;
		}
	}
	doTellAbout(actor, iobj) = {
		"\"I'm sure under normal circumstances that would be utterly
		fascinating, but right now I'm much more concerned about not
		being killed.\"";
	}
		
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
		} else if (self.isbabbling) {
			canttalk;
		} else if (helloVerb == v) {
			self.doGreet(Me);
		} else {
			"\"Sorry, I can't interfere.  I've already bent the Prime Directive
			enough for one day, I'm afraid.\"";
		}
		exit;
	}

	verDoGreet(actor) = {}
	doGreet(actor) = {
		if (self.isbabbling) {
			canttalk;
		} else {
			"He turns yellow and grunts.  \"Howdy.  I come in peace, yadda
			yadda yadda.  Can we get on with fixing my engine now that the
			formalities are out of the way?\"";
		}
	}

	clupledonce = nil
	doCluple(actor) = {
	    inherited.doCluple(actor);
	    if (!clupledonce) {
		"\bThe monstrosity turns bright yellow.  In your present form you can
		directly perceive the chemical, visible, and electrical emanations
		it makes as speech";
		if (monstrosity == box.location) {
			", rather than trying to understand the gibberish
			coming out of the little box.\b";
		} else {
			".\b";
		}
		"\"You're a field agent!\"\ it says.  \"I didn't
		recognize you in your disguise!  Of course you have to use a portable
		transmogrifier here so you don't violate the Prime Directive, right?\b
		\"I really need some help.  I was delivering a vital package for the King
		when I pushed my ship too hard and jammed the engine.  I lost control of
		the ship and crashed here.  I transmogrified my ship to look like some of the
		local fauna and tried to ask for help, but my universal translator was
		damaged in the crash.";
		if (monstrosity == box.location) {
			"\"  It flushes pink and flips the little box on its neck.
			\"Blasted thing.";
		}
		"  Anyway, I need some parts to fix my ship and get out
		of here.  I've been looking in the dens of these creatures, but haven't
		had any luck.  If you can get this stuff for me, I might be able to get away
		before a rescue ship comes and blows up the planet in accordance with
		the Prime Directive.\"\b
		It gives you a large piece of paper depicting some sort of diagram.";
		paper.moveInto(Me);
		clupledonce = true;

		if (find(hintVerb.hintlist, self)) {
			hintVerb.hintlist -= self;
		}

	    }
	}
	verIoShowTo(actor) = {}
	seencarpet = nil
	seenjam = nil
	seentoast = nil
	verIoGiveTo(actor) = {}
	ioGiveTo(actor, dobj) = {
		if (box == dobj) {
			"The monstrosity turns purple and its mustache writhes.  It feels
			around its neck for the little box and doesn't find it.  It
			looks at the box, then at you, and finally accepts it with a
			little bow before putting it back on.";
			box.moveInto(monstrosity);
		} else {
			"The monstrosity doesn't take << dobj.thedesc >>, but examines it
			carefully.  ";
			self.ioShowTo(actor, dobj);
		}
	}
	ioShowTo(actor, dobj) = {
		if (carpet == dobj) {
			"Its eyes widen and it turns bright yellow.  ";
			seencarpet = true;
			if (find(hintVerb.hintlist, carpet)) {
				hintVerb.hintlist -= carpet;
			}
			if (isbabbling) {
				"\"Narf!  Furkle ca nobaans so ra!  Tehuni sorata ji
				yee-ha!\"";
			} else {
				carpet.monKnows;
			}
			"  It gives you the universal \"tentacles up\" gesture.";
			if (seenjam && seentoast) {
				self.aftershow;
			}
		} else if (jam == dobj) {
			"It throws its arms out wide and turns bright yellow.  ";
			seenjam = true;
			if (find(hintVerb.hintlist, jam)) {
				hintVerb.hintlist -= jam;
			}
			if (isbabbling) {
				"\"Poit!  Zepple furungi zo pletta fogle nox.\"";
			} else {
				jam.monKnows;
			}
			if (seentoast && seencarpet) {
				self.aftershow;
			}
		} else if (isclass(dobj, slice)) {
			self.showslice(dobj);
		} else {
			if (isclass(dobj, monTopic)) {
				if (isbabbling) {
					canttalk;
				} else {
					dobj.monKnows;
				}
			} else {
				if (isbabbling) {
					"\"Gerbopple fle tonug fiffle, zepel ifko
					ro soby wa tiddle ferump go nagaz duper.\"";
				} else {
					"\"I'm sure it's very nice, but I don't have
					time to appreciate alien artifacts at the
					moment.\"";
				}
			}
		}
	}
	showslice(dobj) = {
		if (dobj.issmashed) {
			"The monstrosity darkens to mauve. ";
			if (isbabbling) {
				"\"Zipple toe gerfunkled zombrewzki.  Wala wala wahsheeng
				tun pudnow filla remok toi, zabble irp poit flicle womp.
				Ze toe flipple doe rikle fingle floo.\"";
			} else {
				"\"That's too deformed to be of any use.  The attraction
				field would be uneven, and the resulting harmonic
				imbalances would rip the engine apart, and probably the
				ship too.  I'm just a pilot and I know that much.\"";
			}
			"  It waves the slice away.";
		} else if (dobj.isheel) {
			"It tinges red.  ";
			if (isbabbling) {
				"\"Gurk, gurk, gurk.  Bladda dis gatu hil.
				Lebarnu ga flanka sur bitta gooz.  Flopz.\"";
			} else {
				"\"No, no, no.  This is a heel.
				The rounded surface on the back will prevent it
				from mounting properly.  All these pieces are good for
				is grinding up to mix into meatloaf.  You'll have to find
				another slice.\"";
			}
			"  He wriggles his tentacles disdainfully.";
		} else if (0 == dobj.toastlevel) {
			"It flashes pale yellow for a moment.  ";
			if (isbabbling) {
				"\"Narf!  Zeblowni tornaga forkukka blotz.\"";
			} else {
				"\"Hey, that's a good start!  Now you need to
				toast it somehow.\"";
			}
		} else if (1 == dobj.toastlevel) {
			"The monstrosity's features take on a blue cast, as it
			explains to you very calmly, ";
			if (isbabbling) {
				"\"Gurk, sevoona byfurkle ze repuni toe fignal.
				Sorp, wala wala wahsheeng tun sepolopi formal
				ika booooooomz.\"";
			} else {
				"\"No, you see, it has to be perfectly toasted.
				Imperfectly toasted bread can't withstand the structural
				deformation imposed by the acceleration, and
				the resulting harmonic imbalances would be
				devastating.\"";
			}
			"  The creature suddenly reminds you of Zefron at his most
			pedantic.";
		} else if (3 == dobj.toastlevel) {
			"The monstrosity fades to purple, and it slumps a bit.  ";
			if (isbabbling) {
				"\"Gurk, falazzle.  Fahrtoona belail sicle ze
				plowski frapple foo.\"";
			} else {
				"\"No, that will never work.  Burnt toast is
				too brittle to withstand the rigors of space
				travel.\"";
			}
			"  It sighs deeply.";
		} else {
			seentoast = true;
			if (find(hintVerb.hintlist, oldtoast)) {
				hintVerb.hintlist -= oldtoast;
			}
			"The monstrosity turns bright yellow.  ";
			if (isbabbling) {
				"\"Folc, folc.  Birfna foblowni por
				sicle fres!\"";
			} else {
				"\"Good, good.  That's a great piece of
				toast!\"";
			}
			if (seenjam && seencarpet) {
				self.aftershow;
			}
		}
				
	}
	aftershow = {
		if (isbabbling) {
			"\b\"Flabble fo nopre go zoon!  Ter figgle wap la bamba
			zocolo!  Fnord!\"";
		} else {
			"\b\"There may be hope after all!  I'm sure you have the
			parts we need, now we just need to install them!  Come
			on!\"";
		}
		"  It turns and walks toward the ship.  As it approaches, the
		dragon's bottom jaw lowers to the ground.  The monstrosity
		climbs up into the jaw and walks right in.";
		monstrosity.moveInto(head);
		mouthin.isopen = true;
		mouthout.isopen = true;
	}
	
	verDoFollow(actor) = {
		if (head != monstrosity.location ||
			town != Me.location || !mouthin.isopen) {
			"Which way did he go?";
		}
	}
	doFollow(actor) = {Me.travelTo(mouthin.doordest);}
	
	hintlevel = 1
	hint1 = "Have you found any spells you can use yet?"
	hint2 = "Interspecies communication is very difficult."
	hint3 = "\(CLUPLE THE MONSTROSITY\)"
;

crash: monTopic
	sdesc = "crash"
	noun = 'crash'
	monKnows = {
		"The monstrosity turns yellow.  \"It must have been quite a sight!
		I left a lot of my hull up there in the atmosphere, and then the
		impact made a tremendous crater over that way.\"  It waves a tentacle
		vaguely to the south.  \"The air bags deployed okay though, so I
		wasn't hurt.  Some of the more highly sensitive equipment didn't
		make it though.\"";
		if (monstrosity == box.location) {
			"  It taps on the box around his neck.";
		}
	}
;

directive: monTopic
	sdesc = "prime directive"
	noun = 'directive'
	adjective = 'prime'
	monKnows = 	"\"You know, the Prime Directive.  The thing that says that we
			aren't allowed to interfere in the development of other cultures,
			and that if we do interfere, we destroy the evidence.\"  It
			flashes white.  \"We really need to get the engine fixed so I
			can get out of here.  If the rescue ship finds out I landed here
			and possibly contaminated the environment, it will blow everything
			up: me, you, ship, planet.\""
;

disguise: monTopic
	sdesc = "disguise"
	noun = 'disguise' 'agent'
	adjective = 'field'
	monKnows = "It turns a bright cheery yellow.  \"So you're here researching
		the locals, huh?  Must be interesting.  I'm just a pilot, myself.\""
;

elvis: monTopic
	sdesc = "the King"
	thedesc = self.sdesc
	adesc = self.sdesc
	noun = 'king' 'Elvis'
	monKnows = "\"Oh, he's fine.  He gets in his moods sometimes, and he's put on some
		weight, but he's still great.  What a voice he has!\""
;

parts: monTopic
	sdesc = "parts"
	noun = 'parts'
	monKnows = "\"Looking at the diagram I gave you and the current state of my engine,
		it looks to me as if I need a slice of toast, some jam, and a very
		expensive carpet.\""
;

portrait: monTopic
	sdesc = "portrait"
	noun = 'picture' 'photo' 'portrait'
	monKnows = "\"Oh that?  Just a friend.  Maybe more some day.  Someone I hope I
		get to see again.\""
;

rescueship: monTopic
	sdesc = "rescue"
	noun = 'rescue'
	monKnows = 	"\"In a little while the King will wonder what happened to his
			package and send a rescue ship after it.  I'd better not be here
			by then, or it will carry out the Prime Directive.\""
;

toast: monTopic
	sdesc = "toast"
	noun = 'toast'
	monKnows = "\"Dehydrated bread.  It's a vehicle for the jam.  Be sure not to apply
		the jam prematurely, or you won't be able to keep the toast and
		carpet apart.\""
	verDoMake(actor) = "Well, that requires a slice of bread and heat.  Find both of
		those and you should be able to figure the rest out."
;

tm: monTopic
	sdesc = "transmogrifier"
	noun = 'transmogrifier'
	monKnows = "\"Just like yours, it turns something into something else, but mine
		transmogrifies the whole ship.  The computer controls it and selects for
		a shape that will blend in with the surroundings.  Don't worry, I won't
		use it now.  I know the interacting fields would cause it to reset you
		back to your normal form.\""
;
 
// UnConscious Monstrosity
ucm: qcontainer
	adjective = 'unconscious'
	sdesc = "unconscious monstrosity"
	adesc = "an << self.sdesc >>"
	ldesc = 	"The monstrosity lies still, its hide a dark gray.  Its eyes
			are open but unresponsive.  Upon closer inspection, you can
			see that it still lives, but is quite unconscious."
	location = nil
	weight = 10
	bulk = 10
	doCluple -> monstrosity
	verDoAsk = {"It's in no condition to reply.";}
	verIoShowTo(actor) = {"The monstrosity does not respond.";}
	touchdesc = "It's slimy and cool, but you don't know if that means it's
		healthy or ill."
	smelldesc = monstrosity.smelldesc
	listendesc = "If you listen very closely, you can hear shallow breathing."
;
