modify room
	smelldesc = "The castle always smells a bit smoky, what with the torches and
		hearthfires, but the smell is unusually pronounced today."
	listendesc = "You hear a faint noise, as of people shouting in the distance."
;

outdoorroom: room
	noexit = {
		if (Me.form.canfly) {
			"You attempt to fly that direction, but the smoke of the burning
			town sears your lungs and you quickly come back down.\b";
			return (nil);
		} else {
			return (inherited.noexit);
		}
	}
	smelldesc = smoke.smelldesc
	listendesc = "Screams and shouts fill the air as the townsfolk try to save their
		homes."
;

gardenview: distantItem, floatingItem
	sdesc = "gardens"
	ldesc = "You see the royal gardens of Fimpoz, containing orchards and
		vineyards and gazebos and arbors of beautiful and/or exotic plants.  Every
		kind of plant that grows in the Royal Duchy of Fimpoz can be found within
		its walls."
	noun = 'garden' 'orchard' 'vineyard' 'gazebo' 'arbor' 'plant'
	adjective = 'beautiful' 'exotic' 'royal' 'privy'
	location = {
		if ((workshop == Me.location && window.isopen) ||
			courtyard == Me.location || garden == Me.location) {
			return Me.location;
		}
	}

	hintlevel = 1
	hint1 = "There's no way to open the garden gate."
	hint2 = "You can only enter the garden from above."
	hint3 = "In Zefron's workshop, \(OPEN THE WINDOW\), \(CLUPLE THE FLY\),
		then (\EXIT\) just before the cluple spell expires."
;	

townview: distantItem, floatingItem
	sdesc = "town"
	ldesc = "Smoke billows over the town.  There must be a great
		blaze nearby.  "
	listendesc = "You hear screams for help and houses collapsing. "
	noun = 'town' 'landscape'
	location = {
		if ((workshop == Me.location && window.isopen) ||
			courtyard == Me.location || head == Me.location ||
			isclass(Me.location, couch) ||
			town == Me.location) {
			return Me.location;
		}
	}
;

stench: intangible, floatingItem
	sdesc = "stench"
	noun = 'stench' 'odor' 'smell' 'stink'
	adjective = 'amazing'
	ldesc = {
		if (fly == Me.form) {
			"The aroma of human waste saturates the air.  You find it
			strangely... enticing.";
		} else {
			"The odor of human waste fills your nose and threatens to
			empty your stomach.";
		}
	}
	smelldesc = self.ldesc
	location = {
		if ((westwing == Me.location && garderobedoorin.isopen) ||
			garderobe == Me.location || pit == Me.location) {
			return Me.location;
		}
	}
;

// ROOM: WIZARD'S QUARTERS
workshop: room
noun = 'workshop'
	sdesc = "Zefron's Workshop"
	ldesc = {
		"You are in Zefron's workshop/bedroom at the top of the tower.
		There's lots of stuff in here that's obviously very important 
		but it isn't obvious what you can do with it.  A large, scarred
		workbench fills much of the room, and seems to be the focal point
		for the apparatus.";
	        if (itemcnt( workbench.contents )) {
          		"  On "; workbench.thedesc; " %you% see%s% ";
			listcont( workbench ); ". ";
        	}

		"\b\tThe south wall contains a shuttered window, which is ";
		window.isopen ? "open" : "closed";
		".  A";
		trapdoordown.isopen ? "n open" : " closed";
		" trapdoor leads down. ";

		if (smoke.location == workshop) { smoke.ldesc; }
	}
	smelldesc = {
		if (smoke.location == workshop) {
			smoke.smelldesc;
		} else {
			"The air in here is pretty stuffy.  It's probably the toxic
			chemicals.  Opening the window usually helps.";
		}
	}
	listendesc = {
		if (window.isopen) {
			"You hear screams and cries for help from the open window. ";
		} else {
			inherited.listendesc;
		}
	}
	down = trapdoordown
	south = window
	out = self.south
;

trapdoordown: doorway
	sdesc = "trapdoor"
	noun = 'door' 'trapdoor'
	adjective = 'trap'
	location = workshop
	otherside = trapdoorup
	doordest = stairtop
;

window: seethruItem, doorway
	sdesc = "window"
	ldesc = {
		"It's a rather large window with a pair of wooden shutters.  ";
		inherited.ldesc;
	}
	thrudesc = "The window gives a lovely view of the castle gardens,
		far below.  Out past the castle walls you can see smoke
		billowing over the town."
	noun = 'window' 'shutters'
	adjective = 'wooden'
	location = workshop
	doSynonym('Lookthru') = 'LookOut'
	verDoLookthru(actor) = {
		if (!self.isopen) {
			"The shutters are closed. ";
		}
	}
	doOpen(actor) = {
		inherited.doOpen(actor);
		if (smoke.location != workshop) {
			"A cloud of dry, gray smoke rolls in.  ";
			smoke.moveInto(workshop);
		}
	}
	doordest = {
		if (Me.form.canfly) {
			"You spread your wings and fly down to the gardens below.\b";
			return (garden);
		} else {
 			"You'd fall to your death!";
			return(nil);
		}
	}
;

clutter: fixedItem
	sdesc = "clutter"
	ldesc = {
		"This consists of assorted bones, vials, scraps of parchment,
		tubes, twisted bits of metal, dried fungus, and dust bunnies, 
		none of which is of any use under the circumstances. ";
	}
	smelldesc = "Ick.  Some of this stuff makes your head swim. "
	touchdesc = "Ugh.  Little bits stick to you, and you frantically
		wipe them on any handy surface. "
	noun = 'clutter' 'stuff' 'apparatus' 'junk'
	location = workshop
	verDoTake(actor) = "There's nothing useful in all this junk."
;

smoke: fixedItem
	sdesc = "smoke"
	ldesc = "A cloud of dry, gray smoke casts a haze over the room. "
	noun = 'smoke'
	adjective = 'dry' 'gray'
	smelldesc = "You detect the fine smell of an autumn bonfire.  It's sort of
		pleasant except for the fact that it's coming from people's
		burning homes."
	location = nil
;

workbench: surface, fixedItem
	sdesc = "workbench"
	ldesc = {
		"This is a large, scarred bench, cluttered with stuff. ";
		inherited.ldesc;
	}
	touchdesc = "The surface is rough and scarred.  "
	noun = 'workbench' 'bench'
	adjective = 'scarred' 'large' 'work'
	location = workshop
;

// ROOM: TOP OF THE TOWER STAIRS
stairtop: room
	sdesc = "Top of the Tower Stairs"
	ldesc = {
		"You are at a landing at the top of the east tower.  A short ladder leads
		up to a";
		trapdoorup.isopen ? "n open" : " closed";
		" trapdoor to Zefron's workshop.  Narrow stone slabs jut in from the
		tower wall, forming an unrailed stair spiraling down into obscurity.  ";
	}
	up = trapdoorup
	down = {
		if (Me.form.canfly) {
			"You fly straight to the bottom of the tower.\b";
			return (stairbase);
		} else {
			return stairs;
		}
	}
	roomDrop( obj ) = {
		"\^<<obj.thedesc>> falls over the edge of the stairs and plummets to
		the floor below. ";
		obj.moveInto( stairbase );
	}
;

trapdoorup: doorway
	sdesc = "trapdoor"
	noun = 'door' 'trapdoor'
	adjective = 'trap'
	location = stairtop
	otherside = trapdoordown
	doordest = workshop
;

// ROOM: ON THE TOWER STAIRS
stairs: room
	sdesc = "On the Tower Stairs"
	ldesc = "You are catching your breath on the stairs about
		halfway up the east tower.  "
	firstseen = "\bYou're not sure
		why the tower is so tall, but you've always suspected
		that it was to limit damage to the main keep should
		Zefron's workshop explode.  The stairs spiral up and
		down from here.  "
	up = stairtop
	down = stairbase
	roomDrop( obj ) = {
		"\^<<obj.thedesc>> falls over the edge of the stairs and plummets to
		the floor below. ";
		obj.moveInto( stairbase );
	}
;

// ROOM: BOTTOM OF THE TOWER STAIRS
stairbase: room
	sdesc = "Bottom of the Tower Stairs"
	ldesc = {
		"This is the base of the wizard's tower, situated at the end of the
		castle's east wing.  Stairs spiral far, far up to Zefron's 
		workshop.  An archway to the west leads into the east wing.";
	}
	up = {
		if (Me.form.canfly) {
			"You fly straight to the top of the tower.\b";
			return (stairtop);
		} else {
			return stairs;
		}
	}
	west = eastwing
;

// ROOM: EAST WING
eastwing: room
	sdesc = "East Wing"
	ldesc = {
		"This is a long hall running from the great hall to the base of the
		east tower.  Tapestries decorate the north wall.  A door on the south
		wall leads into the servants' quarters.";
	}
	east = stairbase
	west = hall
	south = {
		"The servants have barricaded themselves in their quarters.  You
		won't be getting in there.";
		return(nil);
	}
;

servantdoor: lockableDoorway
	sdesc = "door"
	ldesc = "You can see ends of nails in the door, pounded through from the
		other side."
	location = eastwing
	noun = 'door'
	mykey = nokey
;
	

tapestry: decoration
	sdesc = "tapestry"
	ldesc = {
		"These tapestries depict the key events in the life of
		Duke Oswale of Fimpoz.  His birth, coronation, and victory over
		the Ilwigs are displayed in vibrant color.  Each tapestry is
		surmounted by the rampant wombat, symbol of the fair land of
		Fimpoz.";
	}
	noun = 'tapestry'
	plural = 'tapestries'
	location = eastwing
	verDoLookbehind(actor) = {
		"You were expecting maybe a secret door?  No such luck.  There's
		only cobwebs back here.";
	}
;

// ROOM: WEST WING
westwing: room
	sdesc = "West Wing"
	ldesc = {
		"This short hallway opens on the castle kitchens to the north and
		the great hall to the east.  ";
		if (garderobedoorin.isopen) {
			"An unpleasant odor flows out
			from the open door to the south.";
		} else {
			"A small wooden door marked with a crescent is set in
			the south wall.";
		}
	}
	firstseen = "\bYou smell charred flesh and fear the dragon is coming closer,
		but then realize this smell is normal so close to the kitchen."
	east = hall
	south = garderobedoorin
	north = kitchen
	in = self.south
	smelldesc = {
		if (Me.location == stench.location) {
			"You detect the aroma of the kitchen to the north mingled with
			the sewer stench of the garderobe to the south.  It's really
			quite unpleasant.";
		} else {
			"You detect the aroma of the kitchen to the north.";
		}
	}
;

garderobedoorin: doorway
	sdesc = "door"
	ldesc = {
		"Someone has scrawled a crescent on this unassuming wooden door.  ";
		inherited.ldesc;
	}
	location = westwing
	noun = 'door'
	adjective = 'crescent' 'moon' 'small' 'wooden'
	otherside = garderobedoorout
	doordest = garderobe
	doKnockOn(actor) = {
		if (garderobe == guard.location) {
			"You hear the guard cheerfully shout \"Out in a minute!\" from
			within.";
		} else {
			inherited.doKnockOn(actor);
		}
	}
	verDoLock (actor) = {"You can't lock it from this side.";}
	verDoUnlock (actor) = {"You can't unlock it from this side.";}
	islockable = nil
	doOpen(actor) = {
		inherited.doOpen(actor);
		"  As you open the door, an amazing stench roils out into the hallway.";
	}
;

// ROOM: GARDEROBE
garderobe: room
noun = 'garderobe'
	sdesc = "Garderobe"
	ldesc = {
		"The most prominent feature of this small room is the amazing stench.
		There's also a hole in the floor opposite the door, and a row of wooden
		pegs juts out from the east wall.  ";
	        if (itemcnt( pegs.contents )) {
            		"On "; pegs.thedesc; " %you% see%s% "; listcont( pegs ); ". ";
        	}
	}
	smelldesc = stench.ldesc
	north = garderobedoorout
	down = {
		if (fly == Me.form) {
			"You follow your antennae and your instinks, I mean instincts.\b";
			return (pit);
		} else {
			"You haven't examined the hole, have you?  Anyway, it's too
			small.\b";
			return nil;
		}
	}
	out = self.north
	in = self.down
;

garderobedoorout: doorway
	sdesc = "door"
	ldesc = "There's an inscription carved on the door."
	location = garderobe
	noun = 'door' 'inscription'
	adjective = 'small' 'wooden'
	otherside = garderobedoorin
	doordest = westwing
	islockable = true
	verDoRead(actor) = {}
	doRead(actor) = "\"How long a minute is depends upon what side of the garderobe
		door you're on.\""
;

hole: fixedItem
	sdesc = "hole"
	ldesc = {
		"It's the opening to a deep, dark, pit.  You don't need to see down
		there to know what's at the bottom.  The smell is quite distinctive.";
		if (fly == Me.form) {
			"  Actually, the smell isn't as bad as you thought at first.  It's
			sort of an... earthy smell.  A smell of renewal, of life itself.
			It's sort of appealing in its own way.";
		}
	}
	noun = 'hole' 'pit'
	adjective = 'deep' 'dark'
	location = garderobe
	smelldesc = {
		if (fly == Me.form) {
			"It's tantalizing.  You have to investigate this sensation more.
			Impulses beyond your control draw you forward....\b";
			Me.travelTo(pit);
		} else {
			"Your eyes water and your nose burns.  The pit's probably due to
			be emptied soon.";
		}
	}
;

pegs: surface, fixedItem
	location = garderobe
	sdesc = "row of pegs"
	ldesc = {
		"The castle staff hang their garments here.  The smell here drives away
		moths and parasites.  ";
		inherited.ldesc;
	}
	noun = 'row' 'pegs' 'peg'
	adjective = 'wooden'
	ioPutOn(actor, dobj) = {
		if (!dobj.hangable) {
			"There doesn't seem to be a way to hang the << dobj.sdesc >>.";
		} else {
			inherited.ioPutOn(actor, dobj);
		}
	}
;

// ROOM: PIT
pit: room
noun = 'pit'
	sdesc = "Cesspit"
	ldesc = {
		"The stench here is even more intense than it is above.  Fortunately, it's
		too dark down here for you to actually see much of anything.  There's a
		small circle of light far above.";
	}
	smelldesc = stench.ldesc
	up = {
		if (fly == Me.form) {
			"Curiosity satisfied, you fly back up out of the pit.\b";
			return garderobe;
		} else {
			"The opening is too far up for you to reach, and too small for you
			to pass through.  You appear to be stuck.  You could have picked a
			nicer place for it.  You wonder if there's some magic that can
			extract you from this predicament.";
			return nil;
		}
	}
	out = self.up
;

/*
** After the contest, update this so you end up here after being arrested.
** Add stone walls, the hole, spider, gap, cobwebs, worn spot, guards.
*/
// ROOM: CELL
cell: room
noun = 'cell'
	sdesc = "Dungeon Cell"
	ldesc = "You're in the dungeon, in one of the cells reserved for people who
		have no political significance.  It has all the expected amenities:
		stone walls, a sturdy door, cobwebs, and a hole to relieve yourself.
		There's a worn spot on the floor that looks as if it's traditionally
		used as the sleeping area."
	smelldesc = "The distinctive odor of human waste arises from the hole."
	listendesc = "You hear the castle guards right outside your door.  Apparently
		they're all hiding down here in the dungeon until the dragon goes
		away."
;

celldoor: lockableDoorway
	sdesc = "door"
	ldesc = "There's a rather large gap under the door.  Apparently that's where
		food and water are passed in.  In the dim light here you can just
		make out an inscription carved on the door."
	location = cell
	noun = 'door' 'inscription'
	adjective = 'sturdy'
	verDoRead(actor) = {}
	doRead(actor) = "\"How long a year is depends upon what side of the cell
		door you're on.\""
;

// ROOM: KITCHEN
kitchen: room
noun = 'kitchen'
	sdesc = "Kitchen"
	ldesc = {
		"This is the castle kitchen.  It's a big room, full of marvelous
		aromas and the heat of the eternal hearthfires and the great oven.
		All manner of foodstuffs are scattered about.  There's almost always
		some activity in here, but today the room is unoccupied.";
	}
	smelldesc = oven.smelldesc
	south = westwing
	out = self.south
;

kitchenstuff: decoration
	noun = 'heat' 'hearthfires' 'foodstuffs' 'ingredients'
	adjective = 'eternal'
	location = kitchen
	sdesc = "kitchen accouterment"
;

oven: fixedItem, openable
	isopen = nil
	location = kitchen
	sdesc = "oven"
	ldesc = {
		"This is the large oven where the castle's bread is baked.  ";
		inherited.ldesc;
	}
	noun = 'oven'
	adjective = 'large' 'great'
	burning = nil
	smelldesc = "You smell fresh-<< burning ? "burnt" : "baked" >> bread."
;

// ROOM: GREAT HALL
hall: room
noun = 'hall'
	sdesc = "Great Hall"
	ldesc = {
		"This is the center of the castle.  It's a big room, well lit with large
		windows on both sides.  The ducal throne is at the north end of the hall.
		\bWings lead off to the east and west, and the main doors lead south to
		the courtyard.  A door behind the throne leads to the duke's apartments.";
	}
	firstseen = "\bDuke Oswale bellows at you from his throne. \"You there!  Apprentice!
		Where's your second-rate hedge wizard of a master?  Tell him
		there's a dragon outside destroying my town and I want a stop to it right
		NOW!!!  Or else you'll both be drawn, quartered, racked, and whatever
		else nasty I can think of.  And probably fed to the dragon afterward to
		boot!\"  He wipes his brow with a silk cloth.  \"This crisis
		has...\ tired me.  I will be in my chambers deliberating upon a course of
		action.\"\b
		With that he rises from the throne and exits via the north door.  Afterward
		there's a lot of noise from the other side, as if heavy objects are being
		shoved around."
	east = eastwing
	west = westwing
	south = maindoorsout
	north = {
		if (1 > Me.bulk) {
			"You crawl into the keyhole and make your way through to
			the room beyond.\b";
			return dukesroom;
		} else {
			return dukesdoorin;
		}
	}
	out = self.south
	in = self.north
;

maindoorsout: doubleDoorway
	sdesc = "main doors"
	ldesc = {
		"These sturdy oaken doors are reinforced with iron straps.  ";
		if (self.islocked) {
			"They are held shut with a heavy wooden bar.  ";
		} else {
			inherited.ldesc;
		}
	}
	location = hall
	noun = 'doors' 'straps' 'door'
	adjective = 'main' 'outer' 'oaken' 'oak' 'south' 'sturdy' 'iron'
	otherside = maindoorsin
	doordest = courtyard
	mykey = bar

	hintlevel = 1
	hint1 = "It's a good idea to examine everything you can, including doors."
	hint2 = "The bar keeps the main doors from opening.  It's very heavy."
	hint3 = "\(UNBAR THE DOORS\).  If you're not carrying much, you may
		instead be able to \(REMOVE THE BAR\).  Either command will make
		it possible to \(OPEN THE DOORS\)."

	doOpen(actor) = {
		if (find(hintVerb.hintlist, self)) {
			hintVerb.hintlist -= self;
		}
		inherited.doOpen(actor);
	}
;

dukesdoorin: lockableDoorway
	sdesc = "duke's door"
	ldesc = {
		"It's the door to the duke's apartments, carved with the ducal emblem of
		the rampant wombat.  It has a large and ornate brass doorknob, with
		an unusually large keyhole, obviously for a large and ornate key.  ";
		inherited.ldesc;
	}
	listendesc = "You hear muffled snoring from the other side."
	location = hall
	noun = 'door' 'knob' 'doorknob'
	adjective = 'duke\'s' 'north'
	otherside = dukesdoorout
	doordest = dukesroom
	mykey = dukeskey
	verDoOpen(actor) = {
		if (self.islocked) {
			inherited.verDoOpen(actor);
		} else if (furniture.isstacked) {
			"It won't open.  Some heavy things seem
			to be piled against the other side.";
		}
	}
	verDoKnock(actor) = {
		"\"Knock knock.\"\n
		\"sssnnnaaa...  Wha?  Hello?  Go away!  I'm...\  I'm
		deep in thought on the current dilemma.  Can't be disturbed.\"";
	}
	verDoPush(actor) = {
		if (islocked) {
			inherited.verDoPush(actor);
		}
	}
	doPush(actor) = {
		"You turn the knob and give your mightiest shove.  You hear
		heavy things fall on the other side of the door, and the door
		opens about a foot.\b
		The duke screams.  \"Guards!  Guards!  The dragon's coming to
		get me!  Stop him!\"
		Guards quickly arrive and drag you off to the dungeons.  Your
		protests that you are not a dragon are to no avail.  The duke
		said you were a dragon, and that's good enough for them.";
		global.status = 'prisoner';
		rescue();
	}

	hintlevel = 1
	hint1 = "Have you examined the duke's door?  There's something unusual about it."
	hint2 = "Getting into Duke Oswale's room is a tight squeeze."
	hint3 = "\(CLUPLE THE FLY\), then \(ENTER THE KEYHOLE\)."
;

keyholein: seethruItem, fixedItem
	isListed = nil
	sdesc = "keyhole"
	ldesc = "It's pretty large, as keyholes go.  You could probably get a good
		peek at the duke's apartments through it."
	thrudesc = {
		"Through the keyhole you can get a good look at the
		duke's apartments.\b";
		dukesroom.ldesc;
	        if (itemcnt( dukesroom.contents )) {
            		"  In the duke's room %you% see%s% "; listcont( dukesroom ); ". ";
        	}
	}
	noun = 'keyhole' 'hole'
	adjective = 'large' 'brass'
	location = hall
	verDoEnter(actor) = {
		if (1 < actor.bulk) {
			"%You% would have to be much smaller to do that!";
		}
	}
	doEnter(actor) = {
		"You crawl into the keyhole and make your way through to
		the room beyond.\b";
		actor.travelTo(dukesroom);
		if (find(hintVerb.hintlist, dukesdoorin)) {
			hintVerb.hintlist -= dukesdoorin;
		}
	}
	doSynonym('Lookthru') = 'Lookin'
;

throne: chairItem
	sdesc = "throne of Fimpoz"
	ldesc = {
		"The throne of Fimpoz is carved of the finest woods, and the ducal
		emblem of the rampant wombat is inlaid in the backrest.  The seat
		cushion is of puffed silk, which always reminds
		you of the throne's occupant.  ";
		inherited.ldesc;
	}
	noun = 'throne' 'chair' 'backrest' 'cushion'
	adjective = 'duke\'s' 'ducal' 'silk' 'puffed' 'seat'
	location = hall
	touchdesc = {
		if (!dukeskey.isseen) {
			"The seat feels lumpy.";
		} else {
			"The cushion is soft and poofy.";
		}
	}
	doSiton(actor) = {
		"It will mean your death if anyone sees you.  Are you sure? (Y or N): ";
		if (1 == yorn()) {
			"\b";
			inherited.doSiton(actor);
			if (!dukeskey.isseen) {
				"It's surprisingly uncomfortable.  The cushion
				seems to have something pointy underneath it.";
			}
		} else {
			"\bYou change your mind.";
		}			
	}
	verDoSearch(actor) = {
		if (dukeskey.isseen) {
			"You find nothing of interest.";
		}
	}
	doSearch(actor) = {
		if (!dukeskey.isseen) {
			"Under the cushion you find a key, which you take.";
			dukeskey.isseen = true;
			dukeskey.moveInto(actor);
		}
	}
	verDoLookunder(actor) = {self.verDoSearch(actor);}
	doLookunder(actor) = {self.doSearch(actor);}
;

hallwindows: fixedItem, seethruItem
	location = hall
	noun = 'window'
	plural = 'windows'
	adjective = 'large'
	sdesc = "window"
	ldesc = "A row of large windows runs along the upper half of the east and
		west walls."
	thrudesc = "It's a lovely day, if you don't mind the smoke."
;

// ROOM: DUKE OSWALE'S APARTMENTS
dukesroom: room
noun = 'dukesroom'
	firstseen = {notify(oswale, &actorDaemon, 0);}
	sdesc = "Duke Oswale's Apartments"	
	ldesc = {
		"The room is furnished luxuriously, though most of the furniture
		is ";
		if (furniture.isstacked) {
			"piled in front of the door.";
		} else {
			"scattered about.";
		}
		"  The exception is the ducal bed, where the duke lies
		in fitful slumber.";
	}
	south = {
		if (1 > Me.bulk) {
			"You crawl into the keyhole and make your way through to
			the room beyond.\b";
			return hall;
		} else {
			return dukesdoorout;
		}
	}
	out = self.south
;

dukesdoorout: lockableDoorway
	sdesc = "door to the duke's apartments"
	ldesc = {
		"It's the door to the main hall.  It has a large and ornate brass
		doorknob, with
		an unusually large keyhole, obviously for a large and ornate key.  ";
		inherited.ldesc;
	}
	location = dukesroom
	noun = 'door'
	adjective = 'duke\'s'
	otherside = dukesdoorin
	doordest = hall
	mykey = dukeskey
	verDoOpen(actor) = {
		if (furniture.isstacked) {
			"You'll have to move all that furniture out of the way first.";
		} else {
			inherited.verDoOpen(actor);
		}
	}
;

keyholeout: seethruItem, fixedItem
	isListed = nil
	sdesc = "keyhole"
	ldesc = "It's pretty large, as keyholes go.  You could probably get a good
		peek at the great hall through it."
	thrudesc = {
		"Through the keyhole you can get a good look at the great hall.\b";
		hall.ldesc;
	        if (itemcnt( hall.contents )) {
            		"  In the great hall %you% see%s% "; listcont( hall ); ". ";
        	}
	}
	noun = 'keyhole' 'hole'
	adjective = 'large' 'brass'
	location = dukesroom
	verDoEnter(actor) = {
		if (1 < actor.bulk) {
			"%You% would have to be much smaller to do that!";
		}
	}
	doEnter(actor) = {
		"You crawl into the keyhole and make your way through to
		the room beyond.\b";
		actor.travelTo(hall);
	}
	doSynonym('Lookthru') = 'Lookin'
;

dukesbed: beditem
	sdesc = "bed"
	ldesc = "This is the bed of Duke Oswale, the most ornate and
		elaborate vehicle to the Land of Nod in all of Fimpoz.  The canopy is
		embroidered with a scene of angels singing a weary Oswale to sleep,
		carrying away his royal accouterments that he might get his well-deserved
		rest.  The rampant wombat is carved protectively into the massive walnut
		headboard."
	noun = 'bed'
	adjective = 'duke\'s'
	location = dukesroom
;
		
furniture: fixedItem
	weight = 10
	sdesc = "furniture"
	ldesc = {
		"The furniture of the duke's apartments is ";
		if (furniture.isstacked) {
			"piled in front of his door in hopes that it will slow the
			dragon enough for the duke to escape.";
		} else {
			"scattered about the room as if someone had paused in the
			midst of redecorating.";
		}
	}
	location = dukesroom
	noun = 'furniture'
	adjective = 'duke\'s'
	isstacked = true
	verDoMove(actor) = {}
	doMove(actor) = {
		"As quietly as you can manage, you pull the furniture away from the
		door.  Finally it looks as if you could get the door open.";
		self.isstacked = nil;
	}
;

// ROOM: CASTLE COURTYARD
courtyard: outdoorroom
noun = 'courtyard'
	sdesc = "Castle Courtyard"
	ldesc = {
		"The castle courtyard is a wide open space within the outer walls of
		the castle.  Double doors to the north enter the castle, and
		a<< portcullisout.isopen ? "n open portcullis allows " : " closed portcullis blocks " >>
		passage to the town to the south.  A winch is mounted on the wall next to
		the portcullis.  A sign hangs next to a much smaller gate in
		the east wall.";
	}
	north = maindoorsin
	south = {
		if (Me.form.canfly && !portcullisout.isopen) {
			"You zip through the portcullis and into town.\b";
			return town;
		} else if (courtyard == guard.location) {
			return guard;
		} else {
			return portcullisout;
		}
	}
	east = {
		if (Me.form.canfly) {
			"You fly over the gate and into the garden.\b";
			return (garden);
		} else {
			return (gardengatein);
		}
	}
	in = self.north
	out = self.south

	firstseen = {notify(guard, &actorDaemon, 0);}
;

portcullisout: doorway, seethruItem
	sdesc = "portcullis"
	ldesc = {
		"It's a heavy grid of iron bars, sharpened to spikes at the bottom.
		Some mechanism above it allows it to be raised or lowered.  Currently,
		it is << portcullisout.isopen ? "raised." : "lowered." >>";
	}
	thrudesc = townview.ldesc
	noun = 'portcullis' 'gate' 'grid' 'spikes' 'bars'
	adjective = 'heavy' 'iron'
	location = courtyard
	otherside = portcullisin
	doordest = town
	verDoOpen(actor) = {
		if (Me == actor) {
			"It's much too heavy to lift.  There must be another way to open it.";
		}
	}
	doOpen(actor) = {
		if (guard == actor) {
			winch.doTurn(actor);
		}
	}
	verDoClose(actor) = {
		if (Me == actor) {
			"You can't just pull it down.  There must be another way to close it.";
		}
	}
	doClose(actor) = {
		if (guard == actor) {
			winch.doTurn(actor);
		}
	}

	hintlevel = 1
	hint1 = "The portcullis is too heavy to just open."
	hint2 = "There must be some sort of machine to open it."
	hint3 = "If the guard is gone, you can \(TURN THE WINCH\) in the courtyard
		to open the portcullis."
;
	
maindoorsin: doubleDoorway
	sdesc = "main doors"
	ldesc = {
		"These sturdy oaken doors are reinforced with iron straps. ";
		inherited.ldesc;
	}
	location = courtyard
	noun = 'doors'
	adjective = 'main' 'north' 'sturdy' 'oaken' 'oak'
	otherside = maindoorsout
	doordest = hall
	inside = nil
	verDoUnlock(actor) = self.verDoUnlock(actor)
;

gardengatein: lockableDoorway, seethruItem
	sdesc = "garden gate"
	ldesc = {
		"It's a small wrought-iron affair.  You can see through the gate to the
		garden beyond.  ";
		inherited.ldesc;
	}
	thrudesc = gardenview.ldesc
	location = courtyard
	noun = 'gate'
	adjective = 'garden' 'small' 'wrought-iron' 'wrought' 'iron'
	otherside = gardengateout
	doordest = garden
	mykey = nokey
	verDoOpen(actor) = {
		if (courtyard == guard.location && oswale != Me.form) {
			"The guard shoves you away.  \"Hey, can't you read?  The sign
			says 'REGAL PRIVATE GARDENIAS.'  Only the duke and his guest's
			allowed in there.  So back off!\"";
			return;
		}
		inherited.verDoOpen(actor);
	}
	verDoClimb(actor) = {
		if (courtyard == guard.location && oswale != Me.form) {
			"\"Hey!\" the guard shouts.  \"Get down from there!\"  He pulls
			you off and shoves you away.";
		} else {
			"Sharp spikes line the top of the gate, just to keep people
			from doing that.";
		}
	}

	hintlevel = 1
	hint1 = "Some portals cannot be opened."
	hint2 = "You'll never find the key to the garden gate."
	hint3 = "You'll need to find some other way into the garden."
;

sign: readable, fixeditem
	sdesc = "sign"
	ldesc = "It's a bronze plaque, engraved in a lovely script."
	readdesc = "\"ROYAL PRIVY GARDENS\""
	noun = 'sign' 'plaque' 'script'
	adjective = 'bronze' 'lovely'
	location = courtyard
;
	

winch: fixeditem
	weight = 8
	sdesc = "winch"
	ldesc = {
		"This is a large wooden spool with a crank handle and a ratchet.
		Heavy cables wound around the spool run up to a slot in the wall
		above the portcullis.";
	}
	location = courtyard
	noun = 'winch' 'crank' 'cables' 'ratchet' 'spool' 'handle'
	adjective = 'wooden' 'large'
	verDoTurn(actor) = {
		if (courtyard == guard.location && guard != actor) {
			"The guard steps in your way.  \"Nope, opening and closing
			the portcullis is the guard's job, and that's me.  I'm the
			guard.\"";
		}
	}
	doTurn(actor) = {
		if (portcullisout.isopen) {
			"%You% release%s% the ratchet, allowing the winch to spin freely.
			The portcullis crashes to the ground.";
		} else {
			"With great effort, %you% turn%s% the winch.  The portcullis
			raises up and out of the way.";
		}
		portcullisout.isopen = !portcullisout.isopen;
		portcullisin.isopen = portcullisout.isopen;
		
		if (find(hintVerb.hintlist, portcullisout)) {
			hintVerb.hintlist -= portcullisout;
		}
	}
;

// ROOM: TOWN
town: outdoorroom
noun = 'town'
	firstseen = {notify(dragon, &actorDaemon, 0);}
 	sdesc = "Town"
	ldesc = {
		"The town has been ravaged.  Thatched roofs blaze around you, and
		crumbled walls choke the streets, preventing passage to the outer
		gates of the town wall.  The only escape is back through the
		<< portcullisin.isopen ? " open " : " closed " >> portcullis to
		the castle courtyard.  ";
	}
	north = {
		if (Me.form.canfly && !portcullisin.isopen) {
			"You fly through the portcullis and into the courtyard.\b";
			return (courtyard);
		} else {
			return (portcullisin);
		}
	}
	out = self.north
	in = mouthin
;

portcullisin: doorway, seethruItem
	sdesc = "portcullis"
	ldesc = {
		"It's a heavy grid of iron bars, sharpened to spikes at the bottom.
		Some mechanism above it allows it to be raised or lowered.  Currently,
		it is << portcullisout.isopen ? "raised." : "lowered." >>";
	}
	thrudesc = {
		"It's the castle courtyard.  ";
		if (courtyard == guard.location) {
			"The guard, apparently thinking himself unnoticed, is intently
			scratching his buttocks.";
		}
	}
	noun = 'portcullis' 'gate' 'grid' 'spikes' 'bars'
	adjective = 'heavy' 'iron'
	location = town
	otherside = portcullisout
	doordest = courtyard
	verDoClose(actor) = {
		"The winch is on the other side of the wall.  You can't open or close the
		portcullis from here. ";
	}
	verDoOpen(actor) = self.verDoClose(actor)
	verDoKnockOn(actor) = {
		if (self.isopen) {
			"It's raised up out of your reach.";
		}
	}
	doKnockOn(actor) = {
		if (courtyard == guard.location) {
			if (monstrosity == Me.form) {
				"The guard peeks through the portcullis.  When he sees
				you, he screams \"A demon!\"\ and cowers in terror.";
				return;
			}
			"The guard peeks through the portcullis and then gapes at you in
			astonishment.  \"How in the world did you get out there?  Get back
			in here right away!  It's terribly dangerous out there!\"  With
			that he raises the portcullis, ushers you in, and lowers the
			portcullis again.\b";
			Me.travelTo(courtyard);
		} else {
			inherited.doKnockOn(actor);
		}
	}
;

mouthin: doorway
	sdesc = "dragon's mouth"
	ldesc = {
		"\^<< self.thedesc >> is currently ";
		isopen ? "open." : "closed.";
	}
	noun = 'mouth' 'way' 'hatchway' 'jaw' 'jaws'
	adjective = 'dragon\'s' 'hatch' 'bottom'
	location = town
	doordest = {
		if (!head.isseen) {
			"Bracing yourself, you walk into the dragon's open jaws.
			They silently shut behind you.\b";
		} else {
			"\^<< self.thedesc >> closes behind you as you enter.\b";
		}
		mouthin.isopen = nil;
		mouthout.isopen = nil;
		return head;
	}
	otherside = mouthout
	verDoClose(actor) = {
		"There doesn't seem to be any means here for opening or closing
		<< self.thedesc >>.";
	}
	verDoOpen(actor) = self.verDoClose(actor)
	verDoEnter(actor) = {
		if (!isopen) {
			"There doesn't seem to be a way to do that.";
		}
	}
;

eyesin: seethruItem, fixedItem
	sdesc = "eyes"
	ldesc = {
		"Strange.  They aren't just the size of windows, they look
		like they might actually BE windows.  They're dark and translucent, with
		no pupil or iris, like sooted windowpanes.";
		if (head == monstrosity.location) {
			"  Something appears to be moving about behind the surface.";
		}
	}
	adesc = "an eye"
	thrudesc = {
		if (head == monstrosity.location) {
			"There's definitely something moving about inside, but you
			can't make out what it is.";
		} else {
			"It's hard to make out much of anything.";
		}
	}
	noun = 'window' 'eye'
	plural = 'windows' 'eyes'
	location = town
	doSynonym('Lookthru') = 'Lookin'
;

ropes: fixeditem
	sdesc = "ropes"
	ldesc = "The dragon ship is covered with all the ropes the townsfolk could
		gather, from thick hawsers to baling twine.  The ropes are tied to
		the dragon, each other, and hundreds of spikes pounded down into the
		cobblestones of the square."
	noun = 'rope' 'hawser' 'twine' 'spike' 'net'
	plural = 'ropes' 'hawsers' 'spikes'
	adjective = 'thick' 'baling'
	location = nil
	ropeFuse = {
		"\b";
		if (head == Me.location || isclass(Me.location, couch)) {
			"You see something fly past the windows.  And another.  ";
		}
		if (isclass(Me.location, shiproom) || isclass(Me.location, couch)) {
			"From outside the ship you hear the ringing of metal on stone.";
		} else if (town == Me.location) {
			"You see the townsfolk come running with all the rope they can
			find.  They fling the ropes over the motionless dragon and tie
			them to steel spikes driven into the cobblestones.";
		} else {
			"From beyond the castle walls you hear the ringing of metal
			on stone.";
		}
		self.moveInto(town);
	}
	verDoCutWith(actor, iobj) = {}
	doCutWith(actor, iobj) = {
		"You quickly sever the ropes.";
		self.moveInto(nil);
	}
	moveInto(loc) = {
		if (nil == loc) {
			if (find(hintVerb.hintlist, self)) {
				hintVerb.hintlist -= self;
			}
			if (dragon.islaunching) {
				"  Freed of the ropes, the dragon ship leaps into the sky.";
				end();
			}
		}
		inherited.moveInto(loc);
	}
	verDoUnfasten(actor) = {
		"There's just too many.  You don't have time.";
	}

	hintlevel = 1
	hint1 = "Don't worry about the ropes until the engine is fixed."
	hint2 = "The ropes can be either cut or burnt."
	hint3 = "The simplest way to get rid of the ropes is to \(PRESS THE RED
		BUTTON\).  Alternatively, from outside the ship, you can
		\(CUT THE ROPES WITH THE SWORD\)."
;

folk: fixeditem
    noun = 'folk' 'people' 'woman' 'townsfolk'
    adjective = 'town'
    sdesc = "townsfolk"
    ldesc = "The townsfolk are frantically trying to save their homes.  They pay
	you no heed."
    location = town
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb)
	{
	    "\^<<self.thedesc>> are too frantic to notice you.";
	    exit;
	}
    }
    iobjGen(a, v, d, p) =
    {
        "\^<<self.thedesc>> are too frantic to notice you.";
	exit;
    }
;

// ROOM: DUKE'S GARDEN
garden: outdoorroom
noun = 'garden'
	firstseen = {
		notify(raven, &actorDaemon, 0);
		if (find(hintVerb.hintlist, gardengatein)) {
			hintVerb.hintlist -= gardengatein;
		}
		if (find(hintVerb.hintlist, gardenview)) {
			hintVerb.hintlist -= gardenview;
		}
	}
 	sdesc = "Duke Oswale's Garden"
	ldesc = {
		"You're in the vineyards of the duke's gardens.  The grapes are just coming
		into full ripeness, and hang heavy on the vines all around you.
		A small gate in the west wall opens onto the castle courtyard.";
	}
	smelldesc = "Delightful fragrances abound here: roses, jasmine, pine, and of
		course the ubiquitous woodsmoke."
	west = {
		if (Me.form.canfly) {
			"You fly over the gate and into the courtyard.\b";
			return (courtyard);
		} else {
			return (gardengateout);
		}
	}
	up = {
		if (!Me.form.canfly) {
			"You'd need wings to do that.";
		} else if (window.isopen) {
			"You spread your wings and fly up to the tower window.\b";
			return (workshop);
		} else {
			"You fly up to the tower window, but it's closed.  Choking
			on the smoke, you land once more in the garden.";
			return nil;
		}
	}
	out = self.west
	noexit = "You can't risk the luxury of wandering the garden paths,
		knowing your life would be forfeit if you were found here.  Besides,
		you have more urgent matters to attend to."	
;

gardengateout: lockableDoorway, seethruItem
	sdesc = "courtyard gate"
	ldesc = {
		"It's a small wrought-iron affair.  You can see through the gate to the
		courtyard beyond.  ";
		inherited.ldesc;
	}
	thrudesc = {
		"It's the castle courtyard.  ";
		if (courtyard == guard.location) {
			"The guard, apparently thinking himself unnoticed, is intently
			scratching his buttocks.";
		}
	}
	location = garden
	noun = 'gate'
	adjective = 'courtyard' 'small' 'wrought-iron' 'wrought' 'iron'
	otherside = gardengatein
	doordest = courtyard
	mykey = nokey
	verDoClimb(actor) = {
		"Sharp spikes line the top of the gate, just to keep people
		from doing that.";
	}
	verDoKnockOn(actor) = {
		"\"Knock knock.\"";
		if (courtyard == guard.location) {
			"  You hear the guard on the other side come running over to
			the gate just in time to duck aside.  \"Hey!  Who's in there?\"
			he asks.";
		}
	}
;

gardengrapes: fixedItem
	picked = nil
	weight = 0
	noun = 'grape' 'vine' 'grapes' 'vines'
	sdesc = "grape vines"
	ldesc = "The vines are loaded down with fruit.  The birds have ruined many of
		them, but there are still a few good bunches left."
	doEat(actor) = {
		"You pop a couple into your mouth.  They're taut with perfect ripeness,
		and when you bite down, sweet, delicious juices explode into your mouth.";
	}
	location = garden
	verDoTake(actor) = {
		if (5 > actor.maxweight) {
			"You aren't strong enough to tug any off the vine.";
		} else if (picked) {
			"You already picked the best bunch.  Let's not be greedy.  Any
			more would surely be missed.";
		}
	}
	doTake(actor) = {
		"You pick a big juicy bunch.";
		grapes.moveInto(actor);
		picked = true;
	}
;

class shiproom: room
	ldesc = {
		if (dragon.islaunching) {
			"\bThe room trembles as << dragon.thedesc >> struggles to rise.";
		}
	}
	smelldesc = "The air here is remarkably sterile, having almost no scent at all.
		You can just faintly detect a sort of fishy smell."
	listendesc = "If you concentrate, you can just make out the cries of the
		townsfolk outside."
;

// ROOM: HEAD (COCKPIT)
head: shiproom
noun = 'head'
	sdesc = "Head"
	ldesc = {
		"You are inside the dragon's head, which is actually a rather small
		room with two couches and an illuminated panel.  The windows alongside
		each couch probably look like eyes from the outside.  A narrow passage
		leads down the dragon's throat.";
		
		if (itemcnt( pilotcouch.contents )) {
            		"\b\^<< pilotcouch.thedesc >> contains ";
			listcont( pilotcouch ); ". ";
        	}
		if (itemcnt( passcouch.contents )) {
            		"\b\^<< passcouch.thedesc >> contains ";
			listcont( passcouch ); ". ";
        	}

		inherited.ldesc;
	}
	out = mouthout
	down = belly
	in = self.down
;

mouthout: doorway
	sdesc = "dragon's mouth"
	ldesc = {
		"The mouth looks like some sort of hatchway.  The bottom jaw drops so
		you can walk down it and out of the dragon.  The mouth is currently ";
		isopen ? "open." : "closed.";
	}
	noun = 'mouth' 'way' 'hatchway' 'jaw' 'jaws'
	adjective = 'dragon\'s' 'hatch' 'bottom'
	location = head
	doordest = {
		"You step out of the ship.  Several townsfolk point and
		gasp to see you step out of the mouth of a dragon.  The mouth silently
		closes behind you.\b";
		mouthout.isopen = nil;
		mouthin.isopen = nil;
		return town;
	}
	otherside = mouthin
	verDoClose(actor) = {
		"There doesn't seem to be any mechanism here for opening or closing
		the dragon's mouth.";
	}
	verDoOpen(actor) = self.verDoClose(actor)
;

eyesout: seethruItem, fixedItem
	sdesc = "windows"
	ldesc = {
		"There's one on either side of the room, right alongside each couch.
		They're oval and filled with some tinted glasslike material.  You can
		see through them to the town outside.";
	}
	adesc = "a window"
	thrudesc = {
		if (town == ropes.location) {
			"Your view out the window is partially obscured.  It looks
			as if a net has been thrown over the windows.\b";
		}
		townview.ldesc;
	}
	noun = 'window' 'eye'
	plural = 'windows' 'eyes'
	location = head
	doSynonym('Lookthru') = 'LookOut'
;

class couch: chairItem
	ldesc = {
		"  It looks like it's designed for someone of about your size and
		mass but with substantial physiological differences.  It's really shaped
		more or less like a bowl, and is probably meant to accommodate someone
		with a much less rigid skeletal structure than your own.  ";
		inherited.ldesc;
	}
	noun = 'couch' 'seat' 'chair'
	verDoSiton(actor) = {
		if (self == monstrosity.location || self == ucm.location) {
			"There's no room for you and the monstrosity both!";
		}
		inherited.verDoSiton(actor);
	}
	doSiton(actor) = {
		if (monstrosity == Me.form) {
			"You settle comfortably into the couch.";
		} else {
			"You sit down, but the curved surface is really bad
			on your spine.  You twist about a bit and manage to become
			only vaguely uncomfortable.";
		}
		actor.travelTo(self);
	}
	verIoPutOn(actor) = {
		if (self == monstrosity.location || self == ucm.location ||
			self == Me.location) {
			"There's no room with someone sitting on it.";
		}
	}
	touchdesc = "The surface is soft, but increases in firmness when pressed."
	ioSynonym('PutOn') = 'PutIn'
	doSynonym('Siton') = 'Enter'
;

pilotcouch: couch, monTopic
	adjective = 'pilot' 'pilot\'s' 'left'
	sdesc = "left couch"
	ldesc = {
		"The left couch is closer to the control panel and is probably intended
		for the pilot.";
		inherited.ldesc;
	}
	location = head
	reachable = head.contents + panel.contents + passcouch.contents
	monKnows = "\"I sit there to fly the ship.  I'm the pilot.\""
;

passcouch: couch, monTopic
	adjective = 'passenger' 'passenger\'s' 'right'
	sdesc = "right couch"
	ldesc = {
		"The right couch is probably intended for a passenger, since you can't
		reach the control panel from there.";
		inherited.ldesc;
	}
	location = head
	reachable = head.contents + pilotcouch.contents - panel
	monKnows = "\"That's for a passenger.  If they don't sit there during acceleration,
		they tend to get squished into jelly.  Ugh.\""
;

class panelbutton: buttonitem, monTopic
	location = panel
	verDoPush(actor) = {}
	monKnows = "\"Those are the controls for the ship.\""
;

panel: fixedItem, monTopic
	noun = 'panel' 'picture' 'readout'
	adjective = 'control' 'illuminated'
	plural = 'controls' 'panels'
	sdesc = "control panel"
	ldesc = {
		"The brightly lit panel is crammed with controls and displays, but five
		buttons are prominent: one is red, one is yellow, one is black, one is
		purple, and one is blue.  A<< engine.ison ? " glowing " : "n unlit " >>
		amber indicator light sits next to the yellow button.  There's
		some sort of sliding lever here, and a readout with a picture of a
		dragon.  Another display shows a glowing white dot in the middle
		of << display.rings >> concentric rings.";
		if (display.alarm) {
			"  A green dot glows on the display, << display.countdown >> rings
			away from the white dot.";
		}
	}
	location = head
	monKnows = "\"It's the control panel.  Be careful with the controls!  They're
		very sensitive.\""
;

display: fixeditem, monTopic
	noun = 'display' 'dot' 'radar'
	adjective = 'glowing' 'white' 'green' 'proximity'
	sdesc = "display"
	ldesc = {
		"The display shows a glowing white dot in the center
		of << rings >> concentric rings.";
		if (alarm) {
			"  A glowing green dot is on the display, << countdown >> rings
			away from the white dot.";
		}
	}
	location = panel
	monKnows = "\"That's the proximity display.  The white dot is our location, and
		other ships appear on the screen as green dots.\""
	rings = 10
	countdown = self.rings
	alarm = nil

	// Don't start the demon until one turn after button is pressed.
	rescueFuse = {
		notify(self, &rescueDaemon, 0);
	}
	rescueDaemon = {
		if (isclass(Me.location, shiproom) || isclass(Me.location, couch)) {
			"\bThe beeping continues.";
		}
		countdown--;
		if (head == Me.location || isclass(Me.location, couch)) {
			"  The green light on the display moves one ring closer to
			the white dot.";
		}
		if (0 == countdown) {
			rescue();
		}
	}
;

panicbutton: panelbutton
	adjective = 'black' 'panic' 'distress' 'beacon' 'signal' 'emergency'
	sdesc = "black button"
	monKnows = "\"That's the panic button.  It activates the emergency distress
		beacon, which will bring an emergency psychic rescue team in just a few
		minutes.  Their response time is so good because they receive the message
		a while before you send it.\""
	doPush(actor) = {
	    if (display.alarm) {
		"Nothing seems to happen.";
	    } else {
		"When you press the button, a beeping ensues and a green light appears
		on the edge of the display.";
		if (head == monstrosity.location) {
			"  The monstrosity turns white as snow.  ";
			if (monstrosity.isbabbling) {
				"\"Straczynsky.  Zopple vu finic wix.  Burfle
				so winc dur flan.  Zeep.\"";
			} else {
				"\"Great Maker.  You've activated the emergency
				distress beacon.  The rescue ship will be here
				in minutes.  We're doomed.\"";
			}
			"  It collapses onto the floor.";
		}
		display.alarm = true;
		notify(display, &rescueFuse, 1);
		monstrosity.faints;
	    }
	}
;

light: fixeditem, monTopic
	noun = 'light'
	adjective = 'amber' 'indicator' 'engine' 'power'
	sdesc = "indicator light"
	ldesc = "The amber indicator light is << engine.ison ? "on" : "off" >>."
	location = panel
	monKnows = "\"That's the engine power indicator light.  It comes on when the
		engine is switched on.\""
;

throttle: fixeditem, monTopic
	noun = 'lever' 'throttle' 'character'
	adjective = 'sliding'
	sdesc = "lever"
	setting = 11
	maxsetting = 11
	ldesc = {
		"There's some sort of sliding lever here with ten positions, each
		marked with a character ";
		if (monstrosity.isbabbling) {
			"of some sort.  The lever is currently set to ";
		} else {
			"from 1 through 10.  The lever is currently set to ";
		}
		if (11 == setting) {
			"a position a bit above the tenth character.";
		} else {
			"the << self.setting >>";
			switch (setting) {
			case 1: "st"; break;
			case 2: "nd"; break;
			case 3: "rd"; break;
			default: "th";
			}
			" character.";
		}
	}
	location = panel
	monKnows = "It turns purple.  \"That's the throttle.  I shouldn't have pushed it
		so hard.  I think I set it to eleven.\""
		
    verDoMove( actor ) = {}
    doMove( actor ) =
    {
        askio( toPrep );
    }
    verDoPush(actor) = {
		if (11 == self.setting) {
			"The lever won't go up any farther.";
		}
    }
    doPush(actor) = {
    	numObj.value = self.setting + 1;
	self.doMoveTo(actor, numObj);
    }
    verDoPull(actor) = {
		if (1 == self.setting) {
			"The lever won't go down any farther.";
		}
    }
    doPull(actor) = {
	numObj.value = self.setting - 1;
	self.doMoveTo(actor, numObj);
    }
    verDoMoveTo( actor, io ) = {}
    doMoveTo( actor, io ) = {
        if ( io == numObj ) {
            if ( numObj.value < 1 or numObj.value > self.maxsetting) {
                "There's no such setting! ";
            } else if (numObj.value == 11) {
            	if (engine.ison) {
            	    if (engine.isfixed) {
            	    	"Deep below you, in the bowels of the ship, the piston with
            	    	the toast and jam slides up and ruins the new carpet, repeating
            	    	the incident that started this whole mess.  Good going.";
            	    	rescue();
            	    } else {
            	    	self.setting = 11;
            	    	"Okay, it's now set to 11. ";
            	    }
            	} else {
            	    "The lever stops at 10 and won't go any farther. ";
            	    self.setting = 10;
            	}
            } else if ( numObj.value <> self.setting ) {
                self.setting = numObj.value;
                "Okay, it's now set to "; say( self.setting ); ". ";
            } else {
                "It's already set to "; say( self.setting ); "! ";
            }
        } else {
            "I don't know how to set "; self.thedesc;
            " to that. ";
        }
    }
;
	
openbutton: panelbutton
	adjective = 'purple' 'mouth'
	sdesc = "purple button"
	monKnows = "\"That opens the hatch.  I wouldn't do that right now.  It looks
		like the natives are getting restless out there.  The hatch is set
		to close right after someone goes out, to keep the natives from
		boarding.\""
	doPush(actor) = {
		if (mouthout.isopen) {
			"The bottom jaw of the dragon's mouth raises, closing the
			hatch.";
		} else {
			"The bottom jaw of the dragon's mouth lowers, allowing access to the
			outside.";
		}
		mouthout.isopen = !mouthout.isopen;
		mouthin.isopen = mouthout.isopen;
	}
;

tmbutton: panelbutton
	adjective = 'blue' 'transmogrifier'
	sdesc = "blue button"
	monKnows = "\"That's the transmogrifier activation button.  The transmogrifier
		changes the ship to a form that blends in with the environment, so that
		we can minimize interference with primitive cultures.\""
	doPush(actor) = {
		"The room spins around you.  The picture on the control panel cycles
		through innumerable shapes, including a disk, a clock tower, and
		a small blue booth.  In a few moments the room stops spinning and the 
		picture is that of a dragon once more.";
		if (Me != Me.form) {
			unnotify(actor, &unCluple);
			Me.unCluple;
		}
		if (isclass(fly.location, shiproom)) {
			if (fly.isVisible(actor)) {
				"\bIn the process of the ship's transmogrification, the
				fly grows and transforms into your master, Zefron!
				Caught in mid-flight, he falls to the floor with a thump.";
			}
			zefron.moveInto(fly.location);
			fly.moveInto(nil);
			unnotify(fly, &actorDaemon);
			notify(zefron, &actorDaemon, 0);
		}
	}
;

firebutton: panelbutton
	adjective = 'red' 'fire' 'weapons'
	sdesc = "red button"
	monKnows = "\"That activates the ship's weapon system.  The weapons are currently
		configured as a flame jet, in keeping with the ship's transmogrification.\""
	pushedOnce = nil
	doPush(actor) = {
		if (town == ropes.location) {
			"Through the windows you see a jet of flame shoot out and burn
			through the ropes that cover the dragon ship.";
			ropes.moveInto(nil);
			return;
		}
		if (pushedOnce) {
			"A jet of flame shoots out and engulfs some townsfolk.  They
			die quickly but horribly.  The remainder continue to try and
			save the burning church.";
			global.status = 'homicidal pyromaniac';
		} else {
			"Through the windows you see a jet of flame shoot out of the
			dragon ship and engulf the local church, which had heretofore
			been spared any damage.  It starts to burn, and the townsfolk
			abandon their own homes and
			form a bucket brigade to try and save the beloved landmark.";
			global.status = 'arsonist';
			pushedOnce = true;
			if (monstrosity.isVisible(Me.location) && !monstrosity.unconscious) {
				if (!monstrosity.isbabbling) {
					"\bThe monstrosity turns purple.  \"Aw.  I was trying to avoid
					damaging that lovely construct.  I'd assumed it was of
					some importance to these creatures.  Was I wrong?\"";
				} else {
					"\bThe monstrosity turns purple and utters more
					gibberish.";
				}
			}
		}
	}
;

/*
** Pressing the button toggles the engine power.  If the ropes are on the ship,
** you can turn the engine on, go out, then cut the ropes so the ship can leave
** without you.
*/
launchbutton: panelbutton
	adjective = 'yellow' 'launch'
	sdesc = "yellow button"
	ropefuselit = nil
	doPush(actor) = {
		local waslaunching = dragon.islaunching;

		if (11 == throttle.setting) {
			"You hear a grinding sound from the bowels of the dragon, but
			nothing more seems to happen.";
		} else {
			if (engine == sheet.location) {
				sheet.moveInto(nil);
			} else {
				sheet.moveInto(engine);
			}
			
			"Click.  The amber indicator light ";
			engine.ison ? "comes on.  " : "goes out.  ";

			if (dragon.islaunching) {
				if (find(hintVerb.hintlist, engine)) {
					hintVerb.hintlist -= engine;
				}
				"The ship trembles as it begins to rise.  ";
				if (2 != engine.mytoast.toastlevel ||
					engine.mytoast.issmashed) {
					"  You hear a throbbing that steadily grows in
					amplitude, coming from the dragon's bowels.  As
					the resonance increases, the dragon begins sympathetic
					vibrations.  Ultimately, the dragon is ripped apart,
					and you are shredded by bits of flying metal.\b
					On the bright side, when the rescue ship arrives,
					there's not enough left of the ship or the pilot
					for them to notice any violation of the prime
					directive.";
					global.status = 'martyr';
					die(nil);
				} else if (town != ropes.location) {
					end();
				}
			} else if (waslaunching) {
				"The ship falls back to the ground with a CRUNCH.  ";
			}

			if (!ropefuselit && engine.iscarpetfixed) {
				ropefuselit = true;
				notify(ropes, &ropeFuse, 5);
			}
		}
	}
	monKnows = "\"That's the power switch for the engine.  It removes the insulator
		from engine, allowing the jam to be attracted to the carpet.  The engine
		can generate a lot of thrust, so I have to already be in my couch when I
		press it.\""

	hintlevel = 1
	hint1 = "Have you fixed the engine yet?"
	hint2 = "You'd better make yourself and the monstrosity comfortable before you
		launch the ship."
	hint3 = "\(PUT THE UNCONSCIOUS MONSTROSITY IN THE RIGHT COUCH\).  Next, you have
		a choice.\n
		If you want to leave with the ship, \(CLUPLE THE MONSTROSITY\), \(SIT
		IN THE LEFT COUCH\), and \(PRESS THE YELLOW BUTTON\).  If the ropes are
		still tied to the dragon, \(PRESS THE RED BUTTON\).\n
		If you want to stay on your homeworld, don't destroy the ropes.
		\(PRESS THE YELLOW BUTTON\), and the ropes will hold the ship down so
		you can \(PRESS THE PURPLE BUTTON\), \(EXIT\) the Head, and \(CUT THE
		ROPES WITH THE SWORD\)."
;

// ROOM: BELLY (CARGO HOLD)
belly: shiproom
	sdesc = "Belly"
	ldesc = {
		"You're in the belly of the dragon, which looks more like a moderately
		large room with metal walls, floor, and ceiling.  It's quite likely the
		cleanest place you have ever seen.  From here you can go up the
		dragon's throat or down into the dragon's bowels.";
		inherited.ldesc;
	}
	up = head
	down = bowels
	in = self.down
	out = self.up
;

// ROOM: BOWELS (ENGINEERING)
bowels: shiproom
noun = 'bowels'
	sdesc = "Bowels"
	ldesc = {
		"You are deep in the bowels of the dragon.  Aside from being a bit warm,
		it's fortunately not what you would have expected the bowels of a dragon
		to be like.  It's much like the dragon's belly, but with lots of
		complicated equipment.  The area is dominated by a single apparatus,
		however, which you are certain must be the dragon's engine.\b
		From here you can climb up to the dragon's belly.";
		inherited.ldesc;
	}
	up = belly
	out = self.up
;

equipment: fixeditem, monTopic
	noun = 'equipment'
	adjective = 'complicated'
	location = bowels
	sdesc = "complicated equipment"
	ldesc = "You haven't the foggiest notion what any of this stuff is."
	monKnows = "\"I haven't the foggiest notion what any of that stuff is.  I'm
		a pilot, not a mechanic.\""
;

/*
** To fix the engine, you have to ease back on the throttle to clear some
** room to work, take out the old carpet and toast, mount the carpet, turn the
** engine off so it won't take off when you're putting in the toast, then mount
** the toast.  And the toast has to be jammed.
** If toastlevel != 2 or issmashed, the engine will explode when turned on.
*/
engine: fixedItem, qcontainer, monTopic
	noun = 'engine' 'apparatus' 'drive'
	adjective = 'large'
	location = bowels
	ison = {return (engine != sheet.location);}
	mytoast = oldtoast
	mycarpet = oldcarpet
	istoastfixed = {return (mytoast && mytoast.isjammed);}
	iscarpetfixed = {return (carpet == mycarpet);}
	isfixed = {return (istoastfixed && iscarpetfixed);}
	sdesc = "engine"
	ldesc = {
		"The engine is large, but relatively simple.  The front of the engine has
		a large, flat interior surface ";
		if (mycarpet) {
			"where << mycarpet.adesc >> is mounted";
		} else {
			"for mounting a carpet";
		}
		".  A piston ";
		if (mytoast) {
			"holds << mytoast.adesc >>.  ";
		} else {
			"has a mount for the toast.  ";
		}
		if (!ison) {
			"A clear sheet of some substance covers the carpet
			mounting surface.  ";
		}
		if (11 == throttle.setting) {
			"The piston is currently so far forward that it
			has actually come into contact with the front of the engine.";
		}
	}
	monKnows = "\"Yep, I pushed the engine too hard and jammed it.  That paper I
		gave you is the only instructions I have on fixing the thing, and I
		can't make head or tentacles out of it.  I'm a pilot, dammit, not an
		engineer.\""

	verIoPutIn(actor) = {
		if (11 == throttle.setting) {
			"The piston is jammed up against the front surface.
			You'll have to move it back somehow.";
		}
	}
	ioPutIn(actor, dobj) = {
		if (isclass(dobj, carpetItem)) {
			carpetsurface.ioPutOn(actor, dobj);
		} else if (isclass(dobj, slice)) {
			piston.ioPutOn(actor, dobj);
		} else {
			"There's no place to put that in the engine.";
			return;
		}
	}
	reachable = contents + piston.contents + carpetsurface.contents

	hintlevel = 1
	hint1 = "Have you asked the monstrosity about the panel controls?"
	hint2 = "Don't put jam on the toast until the new toast and carpet are in place.
		It's not impossible to fix the engine if you have, but it's much
		harder."
	hint3 = "We'll assume you've already \(SPREAD JAM ON PERFECT TOAST\) (it's the
		worst-case scenario, so go ahead if you haven't already, as long as
		the priceless carpet isn't nearby).  Somewhere away from
		the priceless carpet, \(PUT THE PERFECT JAMMED TOAST IN THE HAT\) and
		\(WEAR THE HAT\) to keep it from ruining the new carpet.\n
		\(PULL THE LEVER\) on the control panel (in the Head).  Then you
		can \(REMOVE THE SMASHED TOAST\) and \(REMOVE THE RUINED CARPET\).\n
		\(PUT THE PRICELESS CARPET ON THE SURFACE\), then go up to the Head again
		and \(PRESS THE YELLOW BUTTON\) to turn the engine off.  This raises the
		clear sheet in the engine to protect the carpet from the jam.  Make sure
		the amber panel light is out; if not, \(PRESS THE YELLOW BUTTON\) again.
		Go back down to the Bowels and \(TAKE OFF THE HAT\) so you can \(PUT
		THE PERFECT JAMMED TOAST ON THE PISTON\).\n
		The engine is now fixed!  After that, if you \(PRESS
		THE YELLOW BUTTON\) again, the engine will come on and the ship will
		try to launch.  But you should probably do some other things before
		launch."
;

sheet: fixedItem, monTopic
	location = nil
	sdesc = "clear sheet"
	ldesc = "It's a clear sheet of some stiff material that covers the entire carpet
		mounting surface."
	noun = 'sheet' 'insulator' 'material'
	adjective = 'clear' 'stiff'
	verDoMove(actor) = "You don't see any means for doing that here."
	monKnows = "\"That covers up the carpet and shields it from the jam's attraction,
		effectively turning the engine off.  The jam isn't attracted to the
		carpet if it can't stain it.  Some of the newer stainproof fabrics don't
		work for much the same reason.\""
;

piston: fixedItem, surface, monTopic
	location = engine
	noun = 'piston' 'mount'
	adjective = 'square'
	sdesc = "piston"
	ldesc = {
		"The piston has a square mount on its end, facing the front of the
		engine.";
		if (engine.mytoast) {
			"  The mount holds << engine.mytoast.adesc >>.";
		}
		if (11 == throttle.setting) {
			"  The piston is jammed up against the front of the engine.";
		} else if (10 == throttle.setting) {
			"  The piston is nearly touching the front of the engine.";
		} else {
			"  The piston is about << throttle.setting >>/10ths of the
			way from the back of the engine to the front.";
		}
	}
	monKnows = "\"That's where the toast goes.  The pull of the jam varies in
		proportion to its distance to the carpet.  Sliding the piston back
		and forth changes the velocity of the ship.\""
	verDoMove(actor) = "It won't budge.  There must be a controlling mechanism
		somewhere else on the ship."

	verGrab(obj) = {
		if (11 == throttle.setting) {
			"The piston is jammed up against the front surface.
			You'll have to move it back somehow.";
		} else {
			inherited.verGrab(obj);
		}
	}
	Grab(obj) = {
		engine.mytoast = nil;
		inherited.Grab(obj);
	}

	verIoPutOn(actor) = {
		if (11 == throttle.setting) {
			"The piston is jammed up against the front of the engine.
			You'll have to move it back somehow.";
		}
	}		
	ioPutOn(actor, dobj) = {
		if (!isclass(dobj, slice)) {
			"That doesn't fit on the piston.";
		} else if (engine.mytoast) {
			"There's already a slice on the piston.";
		} else if (dobj.isheel) {
			"The rounded back of the heel won't sit flush against
			the piston.  It won't stay put.";
		} else {
			"You place << dobj.thedesc >> on the piston.  Hundreds of tiny
			hooks embed themselves into the crust to hold it in
			place.  Good thing you didn't trim that off.";
			dobj.moveInto(self);
			engine.mytoast = dobj;
		}
	}
;

carpetsurface: fixedItem, surface, monTopic
	location = engine
	noun = 'surface'
	adjective = 'large' 'flat' 'mounting' 'carpet' 'front' 'interior'
	sdesc = "carpet mounting surface"
	ldesc = {
		"This is the front interior surface of the engine, where the carpet goes.";
		if (engine.mycarpet) {
			"  The surface holds << engine.mycarpet.adesc >>.";
		}
		if (11 == throttle.setting) {
			"  The piston is jammed up against the surface.";
		}
	}
	monKnows = "\"That's where the carpet goes.\""

	verGrab(obj) = {
		if (11 == throttle.setting) {
			"The piston is jammed up against the front surface.
			You'll have to move it back somehow.";
		} else if (!engine.ison) {
			"The hard clear sheet is in the way.  You can't get to it.";
		} else {
			inherited.verGrab(obj);
		}
	}
	Grab(obj) = {
		engine.mycarpet = nil;
		inherited.Grab(obj);
	}

	verIoPutOn(actor) = {
		if (11 == throttle.setting) {
			"The piston is jammed up against the front surface.
			You'll have to move it back somehow.";
		}
	}		
	ioPutOn(actor, dobj) = {
		if (!engine.ison) {
			"A clear sheet is in the way.";
		} else if (!isclass(dobj, carpetItem)) {
			"That doesn't fit on the surface.";
		} else if (engine.mycarpet) {
			"There's already a carpet on the surface.";
		} else if (engine.istoastfixed && carpet == dobj) {
			"As you put the carpet in the engine, it enters the
			attraction field of the jam.  It's yanked from your
			hands and flung upon the end of the piston, and grape
			jam soaks through, ruining it and your hopes.";
			rescue();
		} else {
			"You apply the carpet to the front of the engine, where
			some mystic force (call it, say, \"static cling,\")
			holds it fast.";
			dobj.moveInto(self);
			engine.mycarpet = dobj;
		}
	}
;

