// AdvGlobals.h - global variables

#ifndef _AdvGlobals_h_
#define _AdvGlobals_h_

#include "AdvDef.h"

// This structure defines the global context of the game

typedef struct globals
	{
    STRING    m_szExeDir;                 // directory containing program .exe file

    // Version information
    char      m_szSignature [256];        // signature
    long      m_nVerMajor;                // major version
    long      m_nVerMinor;                // minor version

    // Description database
    OBJECT_DESCRIPTOR   m_objects   [MAXOBJECTS];   // object descriptions
    PTR_TEXTLINES       m_messages  [MAXMESSAGES];  // message texts
    PTR_TEXTLINES       m_shortp    [MAXPLACES];    // short place descriptions
    PTR_TEXTLINES       m_longp     [MAXPLACES];    // long place descriptions
    PTR_TEXTLINES       m_vocab     [MAXVOCAB];     // vocabulary array

    long      m_nObjects;                 // # object descriptions loaded
    long      m_nMessages;                // # messages loaded
    long      m_nPlaces;                  // # place descriptions loaded
    long      m_nVocab;                   // # vocabulary words loaded

    // Player's command
    long      m_nCmdWords;                // # words in command (0, 1 or 2)
    long      m_nContext;                 // previous command context (1st part of a 2 line command)
    long      m_nArg1;                    // first command vocab word
    long      m_nArg2;                    // second command vocab word
    STRING    m_szArg1;                   // first command word
    STRING    m_szArg2;                   // second command word

    // Location properties
    bool      m_hintable [MAXPLACES];     // hint is available here
    bool      m_inMaze [MAXPLACES];       // location is inside a maze
    bool      m_lit [MAXPLACES];          // location is self-illuminated
    bool      m_noBack [MAXPLACES];       // GO BACK won't work here
    bool      m_noDwarf [MAXPLACES];      // dwarves are not allowed here
    bool      m_notInCave [MAXPLACES];    // location is outside the cave
    bool      m_oneExit [MAXPLACES];      // location has only one exit
    bool      m_thrower [MAXPLACES];      // throwing things here sends them elsewhere
    bool      m_waterHere [MAXPLACES];    // water is available here
    long      m_visited [MAXPLACES];      // # times adventurer has been here

    // Object properties
    bool      m_firstDesc [MAXOBJECTS];   // should be described first
    bool      m_invisible [MAXOBJECTS];   // is invisible
    bool      m_mortal [MAXOBJECTS];      // is killable
    bool      m_noDesc [MAXOBJECTS];      // should never be described
    bool      m_openable [MAXOBJECTS];    // can be opened/unlocked
    bool      m_portable [MAXOBJECTS];    // is portable
    bool      m_seen [MAXOBJECTS];        // has been seen
    bool      m_special1 [MAXOBJECTS];    // context sensitive flag (1 of 2)
    bool      m_special2 [MAXOBJECTS];    // context sensitive flag (1 of 2)
    bool      m_valued [MAXOBJECTS];      // is a treasure (must be left in building)
    bool      m_weightless [MAXOBJECTS];  // not counted in inventory
    long      m_nState [MAXOBJECTS];      // state of object
    long      m_nWhereIs [MAXOBJECTS];    // current location

    // Game context
    bool      m_bBriefMode;               // flag: display short descriptions after the first time
    bool      m_bExtendedVersion;         // flag: extended version of game recognized
    bool      m_bFastMode;                // flag: always display short descriptions
    bool      m_bJustDied;                // flag: player has just died
    bool      m_bMoved;                   // flag: player changed location
    bool      m_bNoMagic;                 // flag: magic words not recognized
    bool      m_bOk2Describe;             // flag: it's OK to describe the current location
    bool      m_bPanicked;                // flag: tried to leave cave during closure
    bool      m_bRanOut;                  // flag: his lamp has *just* run out of power
    bool      m_bSaidXyzzyPlugh;          // flag: has said XYZZY or PLUGH
    bool      m_bTicker;                  // flag: need to tick the administrative clock
    bool      m_bQuitting;                // flag: player wants to quit game
    bool      m_bWizard;                  // flag: player is a wizard

    long      m_nCameoTime;               // time left to make a cameo appearance
    long      m_nClockTick;               // game clock
    long      m_nClosure;                 // phase of cave closure
    long      m_nDeaths;                  // # times the player has died
    long      m_nDragonTime;              // dragon time
    long      m_nDwarfCount;              // # dwarves currently alive
    long      m_nDwarvesInRoom;           // # dwarves in room!
    long      m_nEscape;                  // state of escaping from cylinderical room
    long      m_nFooBar;                  // state of "fee fie foe foo" sequence
    long      m_nHere;                    // current location
    long      m_nHintTime;                // used in hint logic
    long      m_nInventory;               // size of inventory
    long      m_nLampLife;                // remaining life of lamp
    long      m_nLastClock;               // last value of game clock m_nClockTick
    long      m_nMaxScore;                // max # points player could have scored until now
    long      m_nMoves;                   // # moves made by player (see also m_nTurns)
    long      m_nMushTime;                // mushroom time
    long      m_nTimeStart;               // time he started playing
    long      m_nPassword;                // random password for escaping from safe
    long      m_nPenalties;               // # penalties charged
    long      m_nPrevLoc;                 // previous location
    long      m_nRetort;                  // last used retort to obscenities
    long      m_nSafeExit;                // exiting safe brings you here
    long      m_nScore;                   // player's score
    long      m_nStrength;                // strength of adventurer
    long      m_nWaterPhugg;              // # times player said PHUGG near water
    long      m_nTurns;                   // # commands input by player (see also m_nMoves)
	}
	AdvGlobalContext;

#endif

// End AdvGlobals.h