/* Parser for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 29-Sep-94     RMS     Fixed bugs in PLAY WITH, ALL BUT, GWIM, THISIT, IT. */
/*                       Fixed vocabularly for ROCK, LIGHT, GATES, STACK, */
/*                       BLIND.  Added COUNT, PERUSE, BLESSING, GHOSTS, */
/*                       SPIRITS, CLIFFS, CORPSES, OUTPUT, CHIMNEY, */
/*                       ZORKMID adjective, DIGBT flag. */
/* 30-Jan-94     RMS     Fixed bug in error message. */
/* 30-Jun-92     RMS     Changed file names to lower case. */
/* 29-Jun-92     RMS     Removed extraneous declaration from SPARSE. */
/*                       Added dummy argument to SYNMCH. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* Common Block Declarations */

struct vocab_1_ {
    char bword[96], pword[160], dword[200], aword[1280], oword[2880], vword[
            1920];
    integer pvoc[20], dvoc[25], avoc[300], ovoc[550], vvoc[750];
};

/* Initialized data */

struct vocab_1_ vocab_1 = { 
        "BY      IS      A       AN      THE     AM      ARE     TODAY   "
        "MY      YOUR    OUR     HIS     ",
        
        "OVER    WITH    USING   AT      "
        "TO      IN      INSIDE  INTO    DOWN    UP      UNDER   OF      "
        "ON      OFF     FOR     FROM    OUT     THROUGH                 ",
        
        "N       NORTH   S       SOUTH   E       EAST    W       WEST    "
        "SE      SW      NE      NW      U       UP      D       DOWN    "
        "LAUNCH  LAND    EXIT    OUT     TRAVEL  IN      CROSS           "
        "        ",
        
        "BROWN   ELONGATEHOT     PEPPER  VITREOUSJADE    HUGE    "
        "ENORMOUSTROPHY  CLEAR   LARGE   NASTY   ELVISH  BRASS   BROKEN  "
        "ORIENTALBLOODY  RUSTY   BURNED-ODEAD    OLD     LEATHER PLATINUM"
        "PEARL   MOBY    CRYSTAL GOLD    IVORY   SAPPHIREWOODEN  WOOD    "
        "STEEL   DENTED  FANCY   ANCIENT SMALL   BLACK   TOUR    VISCOUS "
        "VICIOUS GLASS   TRAP    FRONT   STONE   MANGLED RED     YELLOW  "
        "BLUE    VAMPIRE MAGIC   SEAWORTHTAN     SHARP   WICKER  CLOTH   "
        "BRAIDED GAUDY   SQUARE  CLAY    SHINY   THIN    GREEN   PURPLE  "
        "WHITE   MARBLE  COKE    EMPTY   ROUND   TRIANGULRARE    OBLONG  "
        "EAT-ME  EATME   ORANGE  ECCH    ROCKY   SHEER   200     NEAT    "
        "SHIMMERIZURICH  BIRDS   ENCRUSTEBEAUTIFUCLOCKWORMECHANICMAHOGANY"
        "PINE    LONG    CENTER  SHORT   T       COMPASS BRONZE  CELL    "
        "LOCKED  SUN     BARE    SONG    NORTH   NORTHERNSOUTH   SOUTHERN"
        "EAST    EASTERN WEST    WESTERN DUNGEON FREE    GRANITE LOWERED "
        "VOLCANO MAN-SIZEMETAL   PLASTIC SILVER  USED    USELESS SEEING  "
        "ONE-EYEDHOLY    HAND-HELUNRUSTY PLAIN   PRICELESSANDY   GIGANTIC"
        "LINE-PRIFLATHEADFINE    SHADY   SUSPICIOCROSS   TOOL    CONTROL "
        "DON     WOODS   GOLDEN  OAK     BARRED  DUSTY   NARROW  IRON    "
        "WELCOME RUBBER  SKELETONALL     ZORKMID                         "
        "                                                                "
        "        ",
        
        "BAG     SACK    GARLIC  CLOVE   FOOD    SANDWICHLUNCH   "
        "DINNER  GUNK    PIECE   SLAG    COAL    PILE    HEAP    FIGURINE"
        "MACHINE PDP10   VAX     DRYER   LID     DIAMOND CASE    BOTTLE  "
        "CONTAINEWATER   QUANTITYLIQUID  H2O     ROPE    HEMP    COIL    "
        "KNIFE   BLADE   SWORD   ORCHRISTGLAMDRINLAMP    LANTERN RUG     "
        "CARPET  LEAVES  LEAF    TROLL   AXE     PRAYER  KEYS    KEY     "
        "SET     BONES   SKELETONBODY    COINS   BAR     NECKLACEPEARLS  "
        "MIRROR  ICE     MASS    GLACIER RUBY    TRIDENT FORK    COFFIN  "
        "CASKET  TORCH   CAGE    DUMBWAITBASKET  BRACELETJEWEL   TIMBER  "
        "BOX     STRADIVAVIOLIN  ENGRAVININSCRIPTGHOST   SPIRIT  FIEND   "
        "GRAIL   TRUNK   CHEST   BELL    BOOK    BIBLE   GOODBOOKCANDLES "
        "PAIR    GUIDEBOOGUIDE   PAPER   NEWSPAPEISSUE   REPORT  MAGAZINE"
        "NEWS    MATCHBOOMATCH   MATCHES ADVERTISPAMPHLETLEAFLET BOOKLET "
        "MAILBOX TUBE    TOOTHPASPUTTY   MATERIALGLUE    WRENCH  SCREWDRI"
        "CYCLOPS MONSTER CHALICE CUP     GOBLET  PAINTINGART     CANVAS  "
        "PICTURE WORK    MASTERPITHIEF   ROBBER  CRIMINALBANDIT  CROOK   "
        "GENT    GENTLEMAMAN     INDIVIDUBAGMAN  STILETTOWINDOW  BOLT    "
        "NUT     GRATE   GRATING DOOR    TRAP-DOOSWITCH  HEAD    CORPSE  "
        "BODIES  DAM     GATES   GATE    FCD     RAIL    RAILING BUTTON  "
        "BUBBLE  LEAK    DRIP    HOLE    BAT     RAINBOW POT     STATUE  "
        "SCULPTURROCK    BOAT    PLASTIC PUMP    AIRPUMP AIR-PUMPLABEL   "
        "FINEPRINSTICK   BARREL  BUOY    EMERALD SHOVEL  GUANO   CRAP    "
        "SHIT    HUNK    BALLOON RECEPTACWIRE    HOOK    ZORKMID COIN    "
        "SAFE    CARD    NOTE    SLOT    CROWN   BRICK   FUSE    GNOME   "
        "STAMP   TOMB    CRYPT   GRAVE   HEADS   POLES   IMPLEMENLOSERS  "
        "COKES   LISTINGSOUTPUT  PRINTOUTSPHERE  BALL    ETCHING WALLS   "
        "WALL    FLASK   POOL    SEWAGE  TIN     SAFFRON SPICES  TABLE   "
        "POST    POSTS   BUCKET  CAKE    ICING   ROBOT   ROBBY   C3PO    "
        "R2D2    PANEL   POLE    TBAR    T-BAR   ARROW   POINT   BEAM    "
        "DIAL    SUNDIAL 1       ONE     2       TWO     3       THREE   "
        "4       FOUR    5       FIVE    6       SIX     7       SEVEN   "
        "8       EIGHT   WARNING SLIT    IT      THAT    THIS    ME      "
        "MYSELF  CRETIN  ALL     EVERYTHITREASUREVALUABLESAILOR  TEETH   "
        "GRUE    HAND    HANDS   LUNGS   AIR     AVIATOR FLYER   TREE    "
        "CLIFF   LEDGE   PORTRAITSTACK   BILLS   VAULT   CUBE    LETTERIN"
        "CURTAIN LIGHT   NEST    EGG     BAUBLE  CANARY  BIRD    SONGBIRD"
        "GUARD   GUARDIANROSE    STRUCTURCHANNEL KEEPER  LADDER  BROCHURE"
        "WISH    GROUND  EARTH   SAND    WELL    SLIDE   CHUTE   HOUSE   "
        "BOTTLES BUNCH   PALANTIRSTONE   FLINT   POSSESSIGOOP    BEACH   "
        "GRIP    HANDGRIPPRINT   ETCHINGSCRACK   KEYHOLE MAT     STOVE   "
        "PLATINUMHIM     SELF    GOLD    SAPPHIREIVORY   MASTER  CANDLE  "
        "JADE    SCREEN  BLESSINGGHOSTS  SPIRITS CORPSES JEWELS  CLIFFS  "
        "CHIMNEY                                                         "
        "                                                                "
        "                                                                "
        "        ",
        
        "BRIEF   VERBOSE SUPERBRISTAY    VERSION *SWIM   *BATHE  "
        "WADE    GERONIMO*ULYSSESODYSSEUS*PLUGH  XYZZY   PRAY    TREASURE"
        "TEMPLE  BLAST   SCORE   *QUIT   *GOODBYE*Q      BYE     HELP    "
        "INFO    *HISTORYUPDATE  BACK    *MUMBLE SIGH    *CHOMP  *LOSE   "
        "BARF    DUNGEON FROBOZZ *FOO    *BLETCH BAR     REPENT  *HOURS  "
        "SCHEDULEWIN     *YELL   *SCREAM SHOUT   *HOP    SKIP    *CURSE  "
        "*SHIT   *DAMN   FUCK    ZORK    WISH    SAVE    RESTORE TIME    "
        "DIAGNOSEEXORCISE*LIST   *I      INVENTORWAIT    INCANT  *ANSWER "
        "RESPOND AGAIN   NOOBJ   *BUG    *GRIPE  COMPLAIN*FEATURE*COMMENT"
        "*IDEA   SUGGESTIROOM    *OBJECTSOBJ     RNAME   DEFLATE *EXAMINE"
        "*WHAT   DESCRIBEFILL    *FIND   *SEEK   *WHERE  SEE     FOLLOW  "
        "*KICK   *BITE   TAUNT   LOWER   *PUSH   PRESS   *RING   PEAL    "
        "*RUB    *FEEL   *CARESS *TOUCH  FONDLE  SHAKE   SPIN    *UNTIE  "
        "FREE    *WALK   *RUN    *PROCEEDGO      *ATTACK *FIGHT  *INJURE "
        "*HIT    HURT    BOARD   *BRUSH  CLEAN   *BURN   *IGNITE INCINERA"
        "CLIMB   CLOSE   DIG     DISEMBAR*DRINK  *IMBIBE SWALLOW *DROP   "
        "RELEASE *EAT    *GOBBLE *CONSUME*MUNCH  TASTE   *DOUSE  EXTINGUI"
        "*GIVE   *HAND   DONATE  *HELLO  HI      BLOW    INFLATE *JUMP   "
        "LEAP    *KILL   *MURDER *SLAY   *STAB   DISPATCH*KNOCK  RAP     "
        "LIGHT   LOCK    *LOOK   *L      *STARE  GAZE    *MELT   LIQUIFY "
        "MOVE    *PULL   TUG     *DESTROY*MUNG   *BREAK  DAMAGE  OPEN    "
        "PICK    *PLUG   *GLUE   PATCH   *POKE   *BLIND  JAB     *POUR   "
        "SPILL   PUMP    *PUT    *INSERT *STUFF  PLACE   *RAISE  LIFT    "
        "*READ   *PERUSE SKIM    STRIKE  *SWING  THRUST  *TAKE   *HOLD   "
        "*CARRY  REMOVE  *TELL   *COMMANDREQUEST *THROW  *HURL   CHUCK   "
        "*TIE    FASTEN  *TURN   SET     UNLOCK  *WAKE   *ALARM  *STARTLE"
        "SURPRISE*WAVE   *FLAUNT BRANDISHWIND    ENTER   LEAVE   *MAKE   "
        "BUILD   *OIL    *GREASE LUBRICATPLAY    SEND    SLIDE   *SMELL  "
        "SNIFF   SQUEEZE GET     COUNT                                   "
        "                                                                "
        "        ", 

        {1, 2, 2, 3, 4, 5, 5, 5, 6, 7, 8, 9, 10, 11, 12, 
            13, 13, 14, 0, 0}, 
        {1024, 1024, 5120, 5120, 3072, 3072, 7168, 7168, 
            4096, 6144, 2048, 8192, 9216, 9216, 10240, 10240, 11264, 12288, 
            14336, 14336, 15360, 13312, 15360, 0, 0}, 
        {1, -81, -133, 1, 3, -190,
             3, 4, 6, 8, 8, -122, 9, 10, 12, -26, -47, -95, -96, -123, -133, 
            -135, -144, -145, -150, -176, -191, 13, -19, 14, 15, -16, -46, 
            -156, -190, 16, -22, -38, -92, -113, -155, -158, 17, 20, 24, -205,
             22, 22, 25, -41, -44, -45, -208, 25, 26, 27, 31, 32, -126, -206, 
            -209, 33, -85, -104, -157, -158, -188, 34, 37, 38, -67, -75, -93, 
            -136, -137, -165, -173, -174, -175, -197, -204, 38, -67, -136, 
            -137, -165, -173, -174, -175, 39, -105, -124, -125, -189, 39, 40, 
            41, -44, 5, -46, -52, -53, -89, -102, -103, -153, -187, 47, -162, 
            49, 55, 62, 10, -126, -132, -206, -209, 66, 68, 69, -150, -278, 
            72, -124, 79, -94, -140, -161, -170, -171, -190, -209, 80, -159, 
            82, -112, -114, -141, -206, 83, 90, -281, 90, 91, 92, 98, 100, 
            101, 108, 109, -127, 109, 110, 110, 77, -115, -143, 116, 117, 
            -126, -147, -160, -266, 119, 121, 121, 128, 129, 134, 135, 138, 
            138, 139, 141, 146, 146, 148, 148, 151, 152, 153, -154, -155, 154,
             -155, 86, -156, 157, -158, 157, -158, 163, 164, 166, 166, 167, 
            168, 169, -275, 172, 174, -175, 174, 177, 259, 267, 269, 269, 270,
             270, 271, 271, 67, -272, 67, -272, 279, 195, -262, 265, 36, 111, 
            93, 64, -99, -200, -201, 77, -87, -88, -90, 59, 22, 22, 126, -206,
             -209, 58, 43, 89, 13, 13, 104, 192, 122, 122, 118, 91, 61, 61, 
            165, 193, 194, 196, 196, 157, -158, 197, 198, -210, 204, 199, 205,
             207, 207, 23, 253, -254, 104, -148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
             0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
        {1, -25, -100, 1, 2, 2, 3, 3, 3, 3, 4, -55, 4, -143, 
            -186, -282, 4, 5, 5, -18, -38, -72, -73, -87, -88, -122, -148, 5, 
            6, 7, 7, 7, 7, 7, -200, -201, 8, 9, -123, 10, -121, 10, 11, -273, 
            11, -273, 11, -273, 11, -273, 12, -101, -282, 12, 12, -110, 13, 
            -24, 13, -14, 14, 14, 14, 15, -16, -22, 15, -16, -22, 17, 17, 18, 
            18, 19, -111, 20, 44, -47, 23, 23, -205, 23, 21, 21, 21, -72, -73,
            25, 26, -165, -168, 27, 27, 28, -29, -276, 30, 30, 30, 31, 32, 
            32, 33, 33, 34, 35, -36, -124, -125, 35, -36, 35, -36, -98, -113, 
            37, 37, 38, 39, -53, -105, 40, 40, 41, 41, -44, 42, 42, 42, 43, 
            45, 45, -193, 46, -190, 47, -49, -114, -115, -116, -117, 47, 47, 
            48, 48, 49, 49, 50, -122, -143, -186, 50, 50, 50, 50, 50, 51, 51, 
            51, 52, 52, 52, 52, 53, 54, 54, 55, 55, 55, 56, 57, 58, 58, 59, 
            59, 59, 60, -149, 60, -149, 60, 60, 60, 60, 61, 61, 61, 61, 61, 
            61, 61, 61, 61, 61, 62, 63, -198, -210, 64, 64, 65, 65, 66, -67, 
            -68, -69, -119, -164, -172, -173, -174, -175, -189, -197, 66, 70, 
            -79, -80, -81, -82, -170, 71, -120, 72, -73, 72, -73, 74, 74, -76,
            74, -76, 74, 75, 75, 76, -79, -80, -81, -82, -127, -128, -129, 
            -170, -176, 77, 78, -191, 78, 78, -107, -202, -203, 83, 84, 85, 
            86, 86, 86, 87, -88, -90, 87, -88, -90, 89, 89, 89, 91, -112, 91, 
            92, 93, 94, 95, 96, 97, 97, 97, 97, 98, -113, 99, 101, -110, 102, 
            -103, 104, -148, 104, 105, 106, -188, 106, -186, 107, -187, 108, 
            109, 110, 111, -152, 118, -196, 119, 119, 119, 120, 120, 120, 120,
            121, 122, 122, 122, 126, -206, -209, 126, 130, -131, 130, -131, 
            -257, 130, -131, -159, -160, -161, -162, -163, -164, -257, -265, 
            -269, -270, -271, -272, 132, 133, 133, 134, 134, 134, 135, -204, 
            136, -166, -167, 136, 137, 138, -139, -140, -141, 139, -140, -141,
            142, 142, 142, 142, 159, -160, -161, -162, -163, -164, -194, 
            -277, 120, -166, -167, 168, 168, 169, 169, 171, 177, 177, 178, 
            178, 179, 179, 180, 180, 181, 181, 182, 182, 183, 183, 184, 184, 
            185, 185, 186, 187, 250, 250, 250, 251, 251, 251, 252, 252, 253, 
            253, 255, 256, 258, 259, 259, 260, 260, 261, 261, 144, -145, -268,
            146, -147, 146, 149, 122, -148, 148, 150, 150, 67, -150, 151, 15,
            -151, -171, 153, 154, -155, 156, 157, -158, 267, 267, 274, 274, 
            275, 276, 278, 279, 280, 195, -262, 263, 264, 264, 192, -264, 281,
            283, 283, 266, 121, 121, 126, -206, -209, 126, -206, -209, 51, 
            254, 133, 192, 167, 167, 91, -122, 130, -131, 199, 202, -203, 207,
            208, 26, 250, 251, 85, -104, 37, 34, 279, 48, 6, 151, 263, 42, 
            42, 72, -73, 37, -45, 146, -147, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
            {1, 70, 1, 71, 1,
            72, 1, 73, 1, 74, 1, 75, 1, 76, 1, 77, 1, 56, 1, 79, 1, 80, 1, 
            81, 1, 82, 1, 83, 1, 84, 1, 40, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45,
            1, 46, 1, 47, 1, 48, 1, 49, 1, 50, 1, 51, 1, 52, 1, 53, 1, 54, 1,
            55, 1, 169, 1, 149, 1, 150, 1, 90, 1, 94, 1, 105, 1, 133, 1, 128,
            1, 95, 1, 96, 1, 57, 1, 58, 1, 59, 1, 60, 1, 65, 1, 66, 1, 67, 1,
            20583, 4, 16504, 24576, -1, -1, 11, 24710, 25088, 128, 0, 25090, 
            -1, -1, 16518, 25088, 128, 0, 4, 16511, 24576, -1, -1, 2, 85, 
            20565, 1, 20587, 1, 20590, 9, 20592, 16496, 25098, -1, -1, 16545, 
            25096, -1, -1, 5, 21591, 28759, 25090, -1, -1, 1, 20591, 1, 20601,
            1, 20609, 11, 17521, 25088, 0, 4096, 24738, 25088, 0, 4096, 
            25101, -1, -1, 9, 20622, 16470, 25102, -1, -1, 16470, 25093, -1, 
            -1, 7, 24717, 8704, 0, 128, 18434, 0, 512, 4, 16514, 8704, 0, 2, 
            5, 21592, 28760, 25090, -1, -1, 7, 24713, 25088, 16, 0, 26626, 8, 
            0, 12, 16541, 8199, 0, 2048, 16542, 8198, 0, 2048, 16540, 8192, 0,
            2048, 4, 16510, 25088, 4224, 0, 21, 24665, 8197, 0, 16384, 18434,
            4, 0, 24665, 8206, 0, 16384, 18434, 4, 0, 24665, 8192, 0, 16384, 
            18434, 4, 0, 8, 16515, 8192, 0, 2, 16515, 8205, 0, 2, 4, 16520, 
            25088, 256, 0, 25, 17553, 16896, -1, -1, 24720, 16896, -1, -1, 
            25093, -1, -1, 24720, 16896, -1, -1, 25094, -1, -1, 24720, 16896, 
            -1, -1, 25102, -1, -1, 4, 16519, 31232, 1024, 0, 4, 16508, 31232, 
            64, 0, 11, 29842, 8708, 32, 0, 26770, 8704, 32, 0, 25088, -1, -1, 
            2, 1175, 20631, 15, 25702, 25095, -1, -1, 25090, 4, 0, 16466, 
            25095, -1, -1, 16501, 25093, -1, -1, 4, 28774, 25090, 4, 0, 5, 91,
            16475, 25089, -1, -1, 7, 24715, 8704, 0, 128, 18434, 0, 512, 12, 
            17526, 25091, -1, -1, 16502, 25098, -1, -1, 16525, 9734, 32, 0, 
            11, 17531, 31232, 64, 0, 24713, 25088, 64, 0, 22530, 8, 0, 7, 
            24668, 8192, -1, -1, 30722, 4, 0, 31, 119, 16504, 24579, -1, -1, 
            16537, 25096, -1, -1, 16536, 24581, -1, -1, 16536, 24590, -1, -1, 
            24676, 24579, -1, -1, 25090, -1, -1, 24676, 24579, -1, -1, 25102, 
            -1, -1, 4, 28773, 25090, 8, 0, 4, 16506, 8192, -1, -1, 8, 17530, 
            8704, -1, -1, 16506, 8714, -1, -1, 5, 21642, 28810, 18434, -1, -1,
            11, 17533, 25088, 4224, 0, 24701, 25088, 4224, 0, 22530, 4, 512, 
            4, 16516, 25095, 8192, 32, 4, 28778, 25090, -1, -1, 7, 24714, 
            8704, 0, 128, 18434, 0, 512, 25, 17555, 16896, 256, 0, 24723, 
            16896, 256, 0, 25093, -1, -1, 24723, 16896, 256, 0, 25102, -1, -1,
            24736, 16896, 256, 0, 25098, -1, -1, 4, 16538, 24583, -1, -1, 16,
            29840, 25093, -1, -1, 28816, 25102, -1, -1, 16529, 25094, -1, -1,
            28833, 25096, -1, -1, 5, 21613, 16493, 25095, -1, -1, 18, 17508, 
            29184, 16384, 0, 24676, 29184, 16384, 0, 25090, -1, -1, 24676, 
            29184, 16384, 0, 25102, -1, -1, 12, 24717, 9728, 32, 0, 18434, 0, 
            512, 17549, 9728, 32, 0, 20603, 7, 24716, 18432, 0, 512, 8707, 0, 
            128, 11, 17540, 25088, 8192, 32, 24708, 25088, 8192, 0, 25101, -1,
            -1, 4, 16527, 8192, 0, 1024, 21, 25748, 18432, -1, -1, 8707, 32, 
            0, 24724, 18432, -1, -1, 8718, 32, 0, 24720, 18432, -1, -1, 25093,
            -1, -1, 11, 28786, 25092, -1, -1, 24691, 8711, 32, 0, 27138, 4, 
            0, 22, 25716, 25088, 2, 0, 26626, 4, 0, 16507, 31242, 64, 0, 
            16508, 31243, 64, 0, 24735, 25088, 2, 0, 8196, -1, -1, 7, 24669, 
            8704, -1, -1, 30722, 4, 0, 8, 17512, 8192, 32, 0, 16488, 8199, 32,
            0, 4, 16492, 16384, -1, -1, 5, 20635, 16539, 25095, -1, -1, 2, 
            167, 20566, 2, 168, 20624, 1, 20643, 4, 28836, 16898, -1, -1, 5, 
            20645, 28837, 31234, 4, 0, 4, 16550, 25100, -1, -1, 4, 28833, 
            25096, -1, -1, 1, 20549, 1, 20548, 19, 17540, 25088, 8192, 32, 
            16514, 8709, 0, 2, 16515, 8717, 0, 2, 24708, 25088, 8192, 32, 
            25101, -1, -1, 1, 20577, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0}
};


/* RDLINE-       Read input line */

/* Declarations */

/* Subroutine */ int rdline_(char *inline__, integer *inlen, integer *who, 
        ftnlen inline_len)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer lucvt;
    integer i__, ix;

    lucvt = 'A' - 'a';
/* case conversion factor */
L5:
    switch (*who + 1) {
        case 1:  goto L90;
        case 2:  goto L10;
    }
/* see who to prompt for. */
L10:
    glk_put_string("\n>");
/* prompt for game. */

L90:
    ix = getline_(inline__, inline_len);
    for (; ix<inline_len; ix++)
      inline__[ix] = ' ';
/* get input, padding with blanks. */

    *inlen = nblen_(inline__, 76L);
/* len w/o trailing blank */
    if (*inlen <= 0) {
        goto L5;
    }
/* anything left? */
    i__1 = *inlen;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* convert to upper case. */
        if (*(unsigned char *)&inline__[i__ - 1] >= 'a' && *(unsigned char *)&
                inline__[i__ - 1] <= 'z') {
            *(unsigned char *)&inline__[i__ - 1] = (char) (*(unsigned char *)&
                    inline__[i__ - 1] + lucvt);
        }
/* L400: */
    }
    prsvec_1.prscon = 1;
/* restart lex scan. */
    return 0;
} /* rdline_ */



/* PARSE-        Top level parse routine */

/* Declarations */

/* This routine details on bit 0 of PRSFLG */

logical parse_(char *inline__, integer *inlen, logical *vbflag, ftnlen 
        inline_len)
{
    /* Initialized data */

    static char bakbuf[8*20] = "L       ";
    static integer baklen = 1;

    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    char outbuf[8*20];
    logical dflag;
    integer outlen, i__;
    integer x;


    dflag = (misc_1.prsflg & 1) != 0;
    ret_val = FALSE_;
/* assume fails. */
    prsvec_1.prsa = 0;
/* zero outputs. */
    prsvec_1.prsi = 0;
    prsvec_1.prso = 0;

    if (! lex_(inline__, inlen, outbuf, &outlen, vbflag, 76L, 8L)) {
        goto L1000;
    }
    if (outlen != 1 || s_cmp(outbuf, "AGAIN", 8L, 5L) != 0) {
        goto L100;
    }
    for (i__ = 1; i__ <= 20; ++i__) {
/* use previous */
        s_copy(outbuf + ((i__ - 1) << 3), bakbuf + ((i__ - 1) << 3), 8L, 8L);
/* L50: */
    }
    outlen = baklen;
/* buffer and length. */
L100:
    if ((i__1 = sparse_(outbuf, &outlen, vbflag, 8L)) < 0) {
        goto L1000;
    } else if (i__1 == 0) {
        goto L200;
    } else {
        goto L300;
    }

/* Parse requires validation */

/* do syn scan. */
L200:
    if (! (*vbflag)) {
        goto L350;
    }
/* echo mode, force fail. */
    if (! synmch_(&x)) {
        goto L1000;
    }
/* do syn match. */
    if (prsvec_1.prso == 284) {
        prssta_1.lastit = prssta_1.bunvec[0];
    }
/* record for "it". */
    if (prsvec_1.prso > 0 && prsvec_1.prso < 284) {
        prssta_1.lastit = prsvec_1.prso;
    }

/* Successful parse or successful validation */

L300:
    ret_val = TRUE_;
L350:
    orphan_(&c__0, &c__0, &c__0, &c__0, &c__0, " ", &c__0, &c__0, 1L);
/* clear orphans. */
    for (i__ = 1; i__ <= 20; ++i__) {
/* save command */
        s_copy(bakbuf + ((i__ - 1) << 3), outbuf + ((i__ - 1) << 3), 8L, 8L);
/* L400: */
    }
    baklen = outlen;
/* save length */
    if (dflag) {
        weeprintf("PARSE RESULTS- %c %d %d %d\n",
          (ret_val ? 'T' : 'F'), 
          prsvec_1.prsa, prsvec_1.prso, prsvec_1.prsi);
    }
    return ret_val;

/* Parse fails, disallow continuation */

L1000:
    prsvec_1.prscon = 1;
    if (dflag) {
        weeprintf("PARSE RESULTS- %c %d %d %d\n",
          (ret_val ? 'T' : 'F'), 
          prsvec_1.prsa, prsvec_1.prso, prsvec_1.prsi);
    }
    return ret_val;

} /* parse_ */



/* LEX-  Lexical analyzer */

/* Declarations */

/* This routine details on bit 1 of PRSFLG */

logical lex_(char *inline__, integer *inlen, char *outbuf, integer *op, 
        logical *vbflag, ftnlen inline_len, ftnlen outbuf_len)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    char j[1];
    logical dflag;
    integer i__, cp, k;

    /* Parameter adjustments */
    outbuf -= 8;

    /* Function Body */
    dflag = (misc_1.prsflg & 2) != 0;
    ret_val = FALSE_;
/* assume lex fails. */
    *op = 0;
/* output ptr. */
    for (i__ = 1; i__ <= 20; ++i__) {
/* clear output buf. */
        s_copy(outbuf + (i__ << 3), " ", 8L, 1L);
/* L10: */
    }

L50:
    ++(*op);
/* adv output ptr. */
    cp = 0;

/* char ptr=0. */
L200:
    if (prsvec_1.prscon > *inlen) {
        goto L2000;
    }
/* end of input? */
    *(unsigned char *)j = *(unsigned char *)&inline__[prsvec_1.prscon - 1];
/* no, get character, */
    if (*(unsigned char *)j == '"' || *(unsigned char *)j == '\'') {
        goto L3000;
    }
/* substring? */
    ++prsvec_1.prscon;
/* advance ptr. */
    if (*(unsigned char *)j == ' ') {
        goto L1000;
    }
/* space? */
    if (*(unsigned char *)j == '.' || *(unsigned char *)j == ';' || *(
            unsigned char *)j == '!' || *(unsigned char *)j == '?') {
        goto L2000;
    }
/* end of command? */
    if (*(unsigned char *)j == ',') {
        goto L4000;
    }
/* comma? */
    if (*op > 20) {
        goto L5000;
    }
/* too many tokens? */
    ++cp;
/* adv char ptr. */
    if (cp <= 8) {
        *(unsigned char *)&outbuf[(*op << 3) + (cp - 1)] = *(unsigned char *)
                j;
    }
/* insert char in word. */
    goto L200;

/* Space. */

L1000:
    if (cp == 0) {
        goto L200;
    }
/* any word yet? */
    goto L50;

/* End of input, see if partial word available. */

/* yes, adv op. */
L2000:
    if (prsvec_1.prscon > *inlen) {
        prsvec_1.prscon = 1;
    }
/* force parse restart. */
    if (cp == 0 && *op == 1) {
        return ret_val;
    }
/* any results? */
    if (cp == 0) {
        --(*op);
    }
/* any last word? */
    ret_val = TRUE_;
    if (dflag) {
        weeprintf("LEX RESULTS- %d %d %d\n-",
          cp, *op, prsvec_1.prscon);
        
        i__1 = *op;
        for (i__ = 1; i__ <= i__1; ++i__) {
            glk_put_string(" ");
            glk_put_buffer(outbuf + (i__ << 3), 8);
        }

        glk_put_string("\n");
    }
    return ret_val;

/* Substring, J is delimiter. */

L3000:
    if (input_1.sublnt != 0) {
        goto L3400;
    }
/* already got one? */
L3100:
    ++prsvec_1.prscon;
/* skip initial quote. */
    if (prsvec_1.prscon > *inlen) {
        goto L3500;
    }
/* any more characters? */
    if (*(unsigned char *)&inline__[prsvec_1.prscon - 1] == ' ') {
        goto L3100;
    }
/* skip blanks. */
    k = i_indx(inline__ + (prsvec_1.prscon - 1), j, *inlen - (prsvec_1.prscon 
            - 1), 1L);
/* find closing quote. */
    if (k <= 1) {
        goto L3500;
    }
/* none or empty? */
    s_copy(input_1.subbuf, inline__ + (prsvec_1.prscon - 1), 76L, 
            prsvec_1.prscon + k - 2 - (prsvec_1.prscon - 1));
/* set up substring buffe */
    input_1.sublnt = k - 1;
/* length. */
    prsvec_1.prscon += k;
/* skip over string. */
    if (dflag) {
        weeprintf("SUBSTRING- %d (", input_1.sublnt);
        glk_put_buffer(input_1.subbuf, input_1.sublnt);
        glk_put_string(")\n");
    }
    goto L1000;

/* treat as end of word. */
L3400:
    if (*vbflag) {
        rspeak_(&c__1046);
    }
/* multiple substrings. */
    return ret_val;

L3500:
    if (*vbflag) {
        rspeak_(&c__616);
    }
/* bad substring. */
    return ret_val;

/* Comma. */

/* fails. */
L4000:
    if (cp != 0) {
        ++(*op);
    }
/* if partial word, go to */
    if (*op == 1) {
        goto L4500;
    }
/* no first word? die. */
    if (*op > 20) {
        goto L5000;
    }
/* too many tokens? */
    s_copy(outbuf + (*op << 3), "AND", 8L, 3L);
/* insert 'AND'. */
    goto L50;

/* start new word */
L4500:
    if (*vbflag) {
        rspeak_(&c__1047);
    }
/* misplaced comma. */
    return ret_val;

/* Too many tokens. */

L5000:
    if (*vbflag) {
        rspeak_(&c__1048);
    }
/* too many tokens. */
    return ret_val;

} /* lex_ */



/* SPARSE-       Start of parse */

/* Declarations */

/* This routine details on bit 2 of PRSFLG */

integer sparse_(char *lbuf, integer *llnt, logical *vbflag, ftnlen lbuf_len)
{
    /* System generated locals */
    address a__1[3];
    integer ret_val;
    ftnlen i__1[3], cc__3;
    char ch__1[8];

    /* Local variables */
    char word[8], lcword[8];
    char lcwrd1[10];
    logical dflag, andflg, bunflg;
#define objvec ((integer *)&prssta_1 + 11)
#define prpvec ((integer *)&prssta_1 + 13)
    integer i__, prep, pptr, lobj, errvoc, j, k;
    integer adjptr;
    integer adj, obj;

/* SPARSE, PAGE 2 */

/* Vocabularies */

/* Buzz words--  ignored in syntactic processing */

    /* Parameter adjustments */
    lbuf -= 8;

    /* Function Body */

/* Prepositions--        maps prepositions to indices */



/* Directions--  maps directions to indices */


/* SPARSE, PAGE 3 */

/* Adjectives--  maps adjectives to object numbers */

/* Each string entry in aword corresponds to a list of one or more */
/* object numbers in AVOC.  Object entries are delimited by the first */
/* object being positive, and all subsequent objects in the same entry */
/* being negative. */








/* SPARSE, PAGE 4 */

/* OBJECTS--     Maps objects to object indices, */
/*               same format as AVOC. */


















/* SPARSE, PAGE 5 */

/* VERBS--       Maps verbs to syntax slots */

/* Vocabulary entries are variable length and consist of one */
/* or more words.  If an entry contains more than one word, */
/* all but the last are prefaced with an '*'.  The preferred */
/* string for error messages should be first. */

/* Syntax entries consist of a flag word followed by 0, 1, or 2 */
/* Object descriptions.  The flag word has the following format-- */

/* bit <14>      if 1, syntax includes direct object */
/* bit <13>      if 1, syntax includes indirect object */
/* bit <12>      if 1, direct object is implicit (standard form) */
/* bit <11>      if 1, direct and indirect object must be swapped */
/*                       after syntax processing */
/* bit <10>      if 1, this is default syntax for orphanery */
/* bits <8:0>    verb number for VAPPLI */

/* Object descriptions consist of a flag word and two FWIM words. */
/* The flag word has the following format-- */

/* bit <14>      if 1, search adventurer for object */
/* bit <13>      if 1, search room for object */
/* bit <12>      if 1, parser will try to take object */
/* bit <11>      if 1, adventurer must have object */
/* bit <10>      if 1, qualifying bits (normally -1,-1) are same */
/*                       as FWIM bits */
/* bit <9>       if 1, object must be reachable */
/* bits <8:0>    preposition number for SYNMCH */

/* The FWIM words have the same format as the two object flag words. */

/* Note that bits 12 and 11 of object descriptions actually have */
/* four distinct states-- */

/*       bit 12  bit 11  mdldesc         interpretation */
/*       ------  ------  -------         --------------- */

/*         0       0      --             no parser action */
/*         0       1      HAVE           adventurer must have object */
/*         1       0      TRY            try to take, dont care if fail */
/*         1       1      TAKE           try to take, care if fail */

/* SPARSE, PAGE 6 */












/* SPARSE, PAGE 7 */

/* Set up for parsing */

    ret_val = -1;
/* assume parse fails. */
    adj = 0;
/* clear parts holders. */
    prssta_1.act = 0;
    prep = 0;
    pptr = 0;
    prssta_1.obj1 = 0;
    prssta_1.obj2 = 0;
    prssta_1.prep1 = 0;
    prssta_1.prep2 = 0;
    lobj = 0;
    andflg = FALSE_;
    bunflg = FALSE_;
    dflag = (misc_1.prsflg & 4) != 0;
/* SPARSE, PAGE 8 */

/* Now loop over input buffer of lexical tokens. */

    i__ = 0;
L10:
    ++i__;
/* do 1000 i=1,llnt */
    s_copy(word, lbuf + (i__ << 3), 8L, 8L);
/* get current token. */
    errvoc = 0;
/* assume won't find */
    if (s_cmp(word, " ", 8L, 1L) == 0) {
        goto L1000;
    }
/* blank? ignore. */
    if (s_cmp(word, "AND", 8L, 3L) == 0) {
        goto L1500;
    }
/* 'AND'? */
    if (s_cmp(word, "EXCEPT", 8L, 6L) == 0 || s_cmp(word, "BUT", 8L, 3L) == 0)
             {
        goto L2500;
    }

/* Check for buzz word */

    for (j = 1; j <= 12; ++j) {
        if (s_cmp(word, vocab_1.bword + ((j - 1) << 3), 8L, 8L) == 0) {
            goto L1000;
        }
/* if match, ignore. */
/* L50: */
    }

/* Check for action or direction */

    j = 1;
/* check for action. */
    for (k = 1; k <= 240; ++k) {
        if (*(unsigned char *)&vocab_1.vword[(k - 1) * 8] == '*') {
            goto L65;
        }
/* synonym? */
        if (s_cmp(word, vocab_1.vword + ((k - 1) << 3), 8L, 8L) == 0) {
            goto L2000;
        }
/* match to base word? */
        j = j + vocab_1.vvoc[j - 1] + 1;
/* skip over syntax. */
        goto L70;
L65:
        if (s_cmp(word, vocab_1.vword + (((k - 1) << 3) + 1), 8L, 7L) == 0) {
            goto L2000;
        }
/* synonym match? */
L70:
        ;
    }

L75:
    if (adj != 0 || prep != 0 || prssta_1.obj1 != 0) {
        goto L200;
    }
    if (prssta_1.act == 0) {
        goto L80;
    }
/* any verb yet? */
    if ((vocab_1.vvoc[prssta_1.act] & 511) != 142) {
        goto L200;
    }
/* walk? */
L80:
    for (j = 1; j <= 25; ++j) {
/* then chk for dir. */
        if (s_cmp(word, vocab_1.dword + ((j - 1) << 3), 8L, 8L) == 0) {
            goto L3000;
        }
/* match to direction? */
/* L100: */
    }

/* Not an action, check for preposition, adjective, or object. */

L200:
    for (j = 1; j <= 20; ++j) {
/* look for preposition. */
        if (s_cmp(word, vocab_1.pword + ((j - 1) << 3), 8L, 8L) == 0) {
            goto L4000;
        }
/* match to preposition? */
/* L250: */
    }

    j = 1;
/* look for adjective. */
    for (k = 1; k <= 160; ++k) {
        if (s_cmp(word, vocab_1.aword + ((k - 1) << 3), 8L, 8L) == 0) {
            goto L5000;
        }
/* match to adjective? */
L300:
        ++j;
/* advance to next entry. */
        if (vocab_1.avoc[j - 1] < 0) {
            goto L300;
        }
/* found next entry yet? */
/* L350: */
    }

L400:
    j = 1;
/* look for object. */
    for (k = 1; k <= 360; ++k) {
        if (s_cmp(word, vocab_1.oword + ((k - 1) << 3), 8L, 8L) == 0) {
            goto L6000;
        }
/* match to object? */
L500:
        ++j;
/* advance to next entry. */
        if (vocab_1.ovoc[j - 1] < 0) {
            goto L500;
        }
/* found next entry yet? */
/* L550: */
    }

/* Not recognizable */

    if (! (*vbflag)) {
        return ret_val;
    }
/* if mute, return */
    lcify_(ch__1, 8L, word, &c__1, 8L);
    s_copy(lcword, ch__1, 8L, 8L);
/* convert to lower case */
    glk_put_string("I don't understand \"");
    glk_put_buffer(lcword, nblen_(lcword, 8L));
    glk_put_string("\".\n");
/* don't recognize */
    rspeak_(&errvoc);
/* if extra verb, say so */
L800:
    play_1.telflg = TRUE_;
/* something said. */
    prssta_1.bunsub = 0;
/* no valid EXCEPT clause */
    return ret_val;
/* SPARSE, PAGE 9 */

L1000:
    if (i__ < *llnt) {
        goto L10;
    }

/* At end of parse, check for: */
/*       1. dangling adjective */
/*       2. bunched object */
/*       3. simple directions */
/*       4. orphan preposition */
/*       5. dangling preposition */

/* end of do loop */
    if (adj != 0) {
        goto L4500;
    }
/* dangling adjective? */
    if (bunflg) {
        prssta_1.obj1 = 284;
    }
/* bunched object? */
    if (bunflg && prssta_1.bunsub != 0 && prssta_1.bunlnt == 0) {
        goto L13200;
    }
/* except for nothing? */
    if (prssta_1.act == 0) {
        prssta_1.act = prssta_1.oflag & prssta_1.oact;
    }
/* if no action, take orp */
    if (prssta_1.act == 0) {
        goto L10000;
    }
/* no action, punt. */
    if ((vocab_1.vvoc[prssta_1.act] & 511) != 142 || prssta_1.obj1 < 1024) {
        goto L1100;
    }
/* simple direction? */
    if (prssta_1.obj2 != 0 || prssta_1.prep1 != 0 || prssta_1.prep2 != 0) {
        goto L1050;
    }
/* no extra junk? */
    prsvec_1.prsa = 142;
/* yes, win totally. */
    prsvec_1.prso = prssta_1.obj1;
    ret_val = 1;
/* special return value. */
    return ret_val;

L1050:
    if (*vbflag) {
        rspeak_(&c__618);
    }
/* direction+junk, fail. */
    goto L800;

/* clean up state. */
L1100:
    if (prssta_1.oflag != 0 && prssta_1.oprep != 0 && prep == 0 && 
            prssta_1.obj1 != 0 && prssta_1.obj2 == 0 && prssta_1.act == 
            prssta_1.oact) {
        goto L11000;
    }

    if (prep == 0) {
        goto L1200;
    }
/* if dangling prep, */
    if (pptr == 0) {
        goto L12000;
    }
/* and no object, die; */
    if (prpvec[pptr - 1] != 0) {
        goto L12000;
    }
/* and prep already, die; */
    prpvec[pptr - 1] = prep;
/* cvt to 'pick up frob'. */
L1200:
    ret_val = 0;
/* parse succeeds. */
    if (dflag) {
        weeprintf("SPARSE RESULTS- %d %d %d %d %d\n",
          prssta_1.act, prssta_1.obj1, prssta_1.obj2, prssta_1.prep1, 
          prssta_1.prep2);
    }
    return ret_val;
/* SPARSE, PAGE 10 */

/* 1500--        AND */

L1500:
    if (adj != 0) {
        goto L4100;
    }
/* dangling adj? treat as */
    if (prep != 0 || pptr != 1) {
        goto L8000;
    }
/* prep or not dir obj? */
    andflg = TRUE_;
/* flag 'AND'. */
    goto L1000;

/* 2000--        Action */

/* done. */
L2000:
    if (prssta_1.act == 0) {
        goto L2100;
    }
/* got one already? */
    errvoc = 624;
/* flag for error report. */
    goto L75;

/* try to construe differ */
L2100:
    prssta_1.act = j;
/* save index to verb. */
    prssta_1.oact = 0;
/* no orphan. */
    andflg = FALSE_;
/* clear 'AND' flag. */
    if (dflag) {
        weeprintf("SPARSE- ACT AT %d\n", j);
    }
    goto L1000;

/* 2500--        EXCEPT/BUT */

/* done. */
L2500:
    if (adj != 0) {
        goto L4100;
    }
/* dangling adjective? */
    if (andflg || bunflg || pptr != 1 || i__ >= *llnt) {
        goto L13000;
    }
/* not in right place? */
    if (s_cmp(lbuf + ((i__ + 1) << 3), "FOR", 8L, 3L) != 0) {
        goto L2600;
    }
/* except for? */
    ++i__;
/* skip over. */
    if (i__ >= *llnt) {
        goto L13000;
    }
/* out of text? */
L2600:
    if (prssta_1.obj1 != 252 && prssta_1.obj1 != 253 && prssta_1.obj1 != 254) 
            {
        goto L13100;
    }
/* "collective" EXCEPT? */
    andflg = TRUE_;
/* force next object */
    bunflg = TRUE_;
/* into bunch vector. */
    prssta_1.bunlnt = 0;
/* start at top. */
    prssta_1.bunsub = prssta_1.obj1;
/* remember collective. */
    goto L1000;

/* 3000--        Direction */
/*               Don't need to check for ambiguous use as adjective; */
/*               only possible overlap is north/south/east/west wall; */
/*               and global wall takes is found if no adjective given. */

/* on to next word. */
L3000:
    obj = vocab_1.dvoc[j - 1];
/* save direction. */
    prssta_1.act = 1;
/* find value for action. */
L3600:
    if (vocab_1.vvoc[prssta_1.act - 1] == 0) {
        bug_(&c__310, &prssta_1.act);
    }
/* can't find walk. */
    if ((vocab_1.vvoc[prssta_1.act] & 511) == 142) {
        goto L6300;
    }
/* treat as obj. */
    prssta_1.act = prssta_1.act + vocab_1.vvoc[prssta_1.act - 1] + 1;
/* to next syntax entry. */
    goto L3600;

/* 4000--        Preposition (or dangling adjective at end of parse) */

L4000:
    if (adj == 0) {
        goto L4600;
    }
/* dangling adjective? */
L4100:
    --i__;
/* back up parse stream. */
L4500:
    s_copy(word, vocab_1.aword + ((adjptr - 1) << 3), 8L, 8L);
/* get adjective string. */
    adj = 0;
/* now an object. */
    goto L400;

/* go search object words */
L4600:
    if (andflg) {
        goto L8000;
    }
/* 'AND' pending? */
    if (prep != 0) {
        goto L1000;
    }
/* already have one? igno */
    prep = vocab_1.pvoc[j - 1];
/* no, get index. */
    if (dflag) {
        weeprintf("SPARSE- PREP AT %d\n", j);
    }
    goto L1000;

/* 5000--        Adjective */

L5000:
    adj = j;
/* save adjective. */
    adjptr = k;
/* save string pointer. */
    if (i__ < *llnt || prssta_1.oflag == 0 || s_cmp(prssta_1.oname, " ", 8L, 
            1L) == 0) {
        goto L1000;
    }
/* last word + orphan str */
    if (dflag) {
        weeprintf("SPARSE- ADJ AT %d, ORPHAN=", adj);
        glk_put_buffer(prssta_1.oname, 8);
        weeprintf("\n");
    }
/* have orphan. */
    s_copy(word, prssta_1.oname, 8L, 8L);
/* get object string. */
    goto L400;

/* 6000--        Object */

/* go search object names */
L6000:
    obj = getobj_(&j, &adj, &c__0);
/* identify object. */
    if (dflag) {
        weeprintf("SPARSE- OBJ AT %d, OBJ=%d\n", j, obj);
    }
    if (obj <= 0) {
        goto L7000;
    }
/* if le, couldnt. */
    if (obj != 250) {
        goto L6100;
    }
/* "it"? */
    if ((prssta_1.oflag & prssta_1.oobj1) != 0) {
        prssta_1.lastit = prssta_1.oflag & prssta_1.oobj1;
    }
/* orphan? */
    obj = getobj_(&c__0, &c__0, &prssta_1.lastit);
/* find it. */
    if (obj <= 0) {
        goto L7500;
    }

/* if le, couldnt. */
L6100:
    if (prep != 9) {
        goto L6200;
    }
/* "of" obj? */
    if (lobj == obj || lobj == objcts_1.ocan[obj - 1]) {
        goto L6500;
    }
/* same as prev */
    if (lobj == 252 && (obj == 253 || obj == 254)) {
        goto L6350;
    }
/* all of "collective"? */
/* L6150: */
    if (*vbflag) {
        rspeak_(&c__601);
    }
/* doesn't work */
    goto L800;

/* clean up state. */
L6200:
    if (! andflg) {
        goto L6300;
    }
/* 'AND' pending? */
    if (bunflg) {
        goto L6250;
    }
/* first object? */
    prssta_1.bunvec[0] = objvec[pptr - 1];
/* put preceding obj in v */
    prssta_1.bunlnt = 1;
    bunflg = TRUE_;
/* flag bunch of objects. */
    prssta_1.bunsub = 0;
/* no EXCEPT/BUT clause. */
L6250:
    ++prssta_1.bunlnt;
/* advance bunch pointer. */
    if (prssta_1.bunlnt > 10) {
        goto L9000;
    }
/* too many objects? */
    prssta_1.bunvec[prssta_1.bunlnt - 1] = obj;
/* add to bunch vector. */
    goto L6500;

L6300:
    if (pptr == 2) {
        goto L9000;
    }
/* too many objs? */
    ++pptr;
    prpvec[pptr - 1] = prep;
L6350:
    objvec[pptr - 1] = obj;
/* stuff into vector. */
L6500:
    prep = 0;
    adj = 0;
    andflg = FALSE_;
/* no pending 'AND'. */
    lobj = obj;
/* record last object. */
    goto L1000;
/* SPARSE, PAGE 11 */

/* 7000--        Unidentifiable object (index into OVOC is J) */

L7000:
    lcify_(ch__1, 8L, word, &c__1, 8L);
    s_copy(lcword, ch__1, 8L, 8L);
/* convert obj to lower c */
    s_copy(lcwrd1, " ", 10L, 1L);
/* assume no adjective */
    if (adj != 0) {
/* Writing concatenation */
        i__1[0] = 1, a__1[0] = " ";
        lcify_(ch__1, 8L, vocab_1.aword + ((adjptr - 1) << 3), &c__1, 8L);
        i__1[1] = 8, a__1[1] = ch__1;
        i__1[2] = 1, a__1[2] = " ";
        s_cat(lcwrd1, a__1, i__1, &cc__3, 10L);
	c__3 = cc__3;
    }
    if (obj < 0) {
        goto L7200;
    }
/* ambiguous or unreachab */
    if (lit_(&play_1.here)) {
        goto L7100;
    }
/* lit? */
    if (*vbflag) {
        rspeak_(&c__579);
    }
/* not lit, report. */
    goto L800;

/* go clean up state. */
L7100:
    if (*vbflag) {
        glk_put_string("I can't see any");
        glk_put_buffer(lcwrd1, nblen_(lcwrd1, 10L) + 1);
        glk_put_buffer(lcword, nblen_(lcword, 8L));
        glk_put_string(" here.\n");
    }
    goto L800;

/* go clean up state. */
L7200:
    if (obj != -10000) {
        goto L7300;
    }
/* inside vehicle? */
    if (*vbflag) {
        rspsub_(&c__620, &objcts_1.odesc2[advs_1.avehic[play_1.winner - 1] - 
                1]);
    }
    goto L800;

/* go clean up state. */
L7300:
    if (prssta_1.act == 0) {
        prssta_1.act = prssta_1.oflag & prssta_1.oact;
    }
/* if no act, get orphan. */
    orphan_(&c_n1, &prssta_1.act, &prssta_1.prep1, &prssta_1.obj1, &prep, 
            word, &c__0, &c__0, 8L);
/* orphan the world. */
    if (*vbflag) {
        glk_put_string("Which");
        glk_put_buffer(lcwrd1, nblen_(lcwrd1, 10L) + 1);
        glk_put_buffer(lcword, nblen_(lcword, 8L));
        glk_put_string(" do you mean?\n");
    }
    goto L800;

/* 7500--        Unidentifiable 'IT' (last direct object is LASTIT). */

/* go clean up state. */
L7500:
    if (obj < 0) {
        goto L7200;
    }
/* if lt, must be unreach */
    if (lit_(&play_1.here)) {
        goto L7600;
    }
/* lit? */
    if (*vbflag) {
        rspeak_(&c__1076);
    }
/* lose. */
    goto L800;

/* go clean up state. */
L7600:
    if (*vbflag) {
        rspsub_(&c__1077, &objcts_1.odesc2[prssta_1.lastit - 1]);
    }
/* don't see it. */
    goto L800;

/* 8000--        Misplaced 'AND'. */

/* go clean up state. */
L8000:
    if (*vbflag) {
        rspeak_(&c__1049);
    }
    goto L800;

/* 9000--        Too many objects. */

/* go clean up state. */
L9000:
    if (*vbflag) {
        rspeak_(&c__617);
    }
    goto L800;

/* 10000--       No action, punt. */

/* go clean up state. */
L10000:
    if (prssta_1.obj1 == 0) {
        goto L10100;
    }
/* any direct object? */
    if (*vbflag) {
        rspsub_(&c__621, &objcts_1.odesc2[prssta_1.obj1 - 1]);
    }
/* what to do? */
    orphan_(&c_n1, &c__0, &prssta_1.prep1, &prssta_1.obj1, &c__0, " ", &c__0, 
            &c__0, 1L);
    return ret_val;

L10100:
    if (*vbflag) {
        rspeak_(&c__622);
    }
/* huh? */
    goto L800;

/* 11000--       Orphan preposition.  Conditions are */
/*               OBJ1.NE.0, OBJ2=0, PREP=0, ACT=OACT */

/* go clean up state. */
L11000:
    if (prssta_1.oobj1 != 0) {
        goto L11500;
    }
/* orphan object? */
    prssta_1.prep1 = prssta_1.oprep;
/* no, just use prep. */
    goto L1200;

L11500:
    prssta_1.obj2 = prssta_1.obj1;
/* yes, use as direct obj */
    prssta_1.prep2 = prssta_1.oprep;
    prssta_1.obj1 = prssta_1.oobj1;
    prssta_1.prep1 = prssta_1.oprep1;
    goto L1200;

/* 12000--       True hanging preposition, no objects yet. */

L12000:
    orphan_(&c_n1, &prssta_1.act, &c__0, &c__0, &prep, " ", &c__0, &c__0, 1L);
/* orphan prep. */
    goto L1200;

/* 13000--       EXCEPT/BUT errors. */

L13000:
    lcify_(ch__1, 8L, word, &c__1, 8L);
    s_copy(lcword, ch__1, 8L, 8L);
    if (*vbflag) {
        glk_put_string("Misplaced \"");
        glk_put_buffer(lcword, nblen_(lcword, 8L));
        glk_put_string("\".\n");
    }
/* wrong plac */
    goto L800;

/* go clean up state. */
L13100:
    lcify_(ch__1, 8L, word, &c__2, 8L);
    s_copy(lcword, ch__1, 8L, 8L);
/* wrong case. */
    if (*vbflag) {
        glk_put_string("\"");
        glk_put_buffer(lcword, nblen_(lcword, 8L));
        glk_put_string("\" can only be used with \"everything\", "
          "\"valuables\", or \"possessions\".\n");
    }
/* not coll. */
    goto L800;

/* go clean up state. */
L13200:
    if (*vbflag) {
        rspeak_(&c__619);
    }
/* no objects. */
    goto L800;

/* go clean up state. */
} /* sparse_ */

#undef prpvec
#undef objvec


/* GETOBJ--      Find obj described by adj, name pair */

/* Declarations */

/* This routine details on bit 3 of PRSFLG */

integer getobj_(integer *oidx, integer *aidx, integer *spcobj)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    logical chomp, dflag;
    integer av;
    integer nobj, i__, obj;

    dflag = (misc_1.prsflg & 8) != 0;
    chomp = FALSE_;
    av = advs_1.avehic[play_1.winner - 1];
    obj = 0;
/* assume dark. */
    if (! lit_(&play_1.here)) {
        goto L200;
    }

/* lit? */
    obj = schlst_(oidx, aidx, &play_1.here, &c__0, &c__0, spcobj);
/* search room. */
    if (dflag) {
        weeprintf("SCHLST- ROOM SCH %d\n", obj);
    }
    if (obj < 0) {
        goto L1000;
    } else if (obj == 0) {
        goto L200;
    } else {
        goto L100;
    }
/* test result. */
L100:
    if (av == 0 || av == obj || objcts_1.ocan[obj - 1] == av || (
            objcts_1.oflag2[obj - 1] & 32768) != 0) {
        goto L200;
    }
    chomp = TRUE_;

/* not reachable. */
L200:
    if (av == 0) {
        goto L400;
    }
/* in vehicle? */
    nobj = schlst_(oidx, aidx, &c__0, &av, &c__0, spcobj);
/* search vehicle. */
    if (dflag) {
        weeprintf("SCHLST- VEH SCH %d\n", nobj);
    }
    if (nobj < 0) {
        goto L800;
    } else if (nobj == 0) {
        goto L400;
    } else {
        goto L300;
    }
/* test result. */
L300:
    chomp = FALSE_;
/* reachable. */
    if (obj == nobj) {
        goto L400;
    }
/* same as before? */
    if (obj != 0) {
        nobj = -nobj;
    }
/* amb result? */
    obj = nobj;

L400:
    nobj = schlst_(oidx, aidx, &c__0, &c__0, &play_1.winner, spcobj);
/* search adventu */
    if (dflag) {
        weeprintf("SCHLST- ADV SCH %d\n", nobj);
    }
    if (nobj < 0) {
        goto L800;
    } else if (nobj == 0) {
        goto L900;
    } else {
        goto L500;
    }
/* test result */
L500:
    if (obj == 0) {
        goto L800;
    }
/* any previous? no, use */
    if (*aidx != 0) {
        goto L600;
    }
/* yes, amb, any adj? */
    if (noadjs_(&obj) != noadjs_(&nobj)) {
        goto L700;
    }
/* both adj or no adj? */
L600:
    obj = -nobj;
/* ambiguous result. */
    goto L900;
L700:
    if (noadjs_(&obj)) {
        goto L900;
    }
/* if old no adj, use old */
L800:
    obj = nobj;
/* return new object. */
L900:
    if (chomp) {
        obj = -10000;
    }
/* unreachable. */
L1000:
    ret_val = obj;

    if (ret_val != 0) {
        goto L1500;
    }
/* got something? */
    i__1 = objcts_1.olnt;
    for (i__ = misc_1.strbit + 1; i__ <= i__1; ++i__) {
/* no, search globals. */
        if (! thisit_(oidx, aidx, &i__, spcobj)) {
            goto L1200;
        }
        if (! ghere_(&i__, &play_1.here)) {
            goto L1200;
        }
/* can it be here? */
        if (ret_val == 0) {
            goto L1150;
        }
/* got one yet? */
        if (*aidx != 0) {
            goto L1050;
        }
/* yes, no adj? */
        if (noadjs_(&ret_val) != noadjs_(&i__)) {
            goto L1100;
        }
/* only one with no */
L1050:
        ret_val = -i__;
/* ambiguous */
        goto L1200;
L1100:
        if (noadjs_(&ret_val)) {
            goto L1200;
        }
/* if old no adj, retain. */
L1150:
        ret_val = i__;
/* new is target. */
L1200:
        ;
    }

L1500:
/* end of search. */
    if (dflag) {
        weeprintf("SCHLST- RESULT %d\n", ret_val);
    }
    return ret_val;
} /* getobj_ */



/* SCHLST--      Search for object */

/* Declarations */

integer schlst_(integer *oidx, integer *aidx, integer *rm, integer *cn, 
        integer *ad, integer *spcobj)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    logical aempty;
    integer i__, j, x;


/* Functions and data */


    ret_val = 0;
/* no result. */
    aempty = FALSE_;
/* no ambiguous empty. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* search objects. */
        if ((objcts_1.oflag1[i__ - 1] & 32768) == 0 || ((*rm == 0 || ! qhere_(
                &i__, rm)) && (*cn == 0 || objcts_1.ocan[i__ - 1] != *cn) && (
                *ad == 0 || objcts_1.oadv[i__ - 1] != *ad))) {
            goto L1000;
        }
        if (! thisit_(oidx, aidx, &i__, spcobj)) {
            goto L200;
        }
        if (ret_val == 0) {
            goto L150;
        }
/* got one already? */
        if (*aidx != 0) {
            goto L2000;
        }
/* adj? then ambiguous */
        if (noadjs_(&i__)) {
            goto L100;
        }
/* new have no adj? */
        aempty = TRUE_;
/* no, old might, flag. */
        goto L200;
L100:
        if (noadjs_(&ret_val)) {
            goto L2000;
        }
/* old have no adj? */
L150:
        ret_val = i__;
/* new has no adj, old does. */

/* If open or transparent, search the object itself. */

/* new is unique, or */
L200:
        if ((objcts_1.oflag1[i__ - 1] & 2048) == 0 && (objcts_1.oflag2[i__ - 
                1] & 8) == 0) {
            goto L1000;
        }

/* Search is conducted in reverse.  All objects are checked to */
/* See if they are at some level of containment inside object 'I'. */
/* If they are at level 1, or if all links in the containment */
/* chain are open, visible, and have SEARCHME set, they can qualify */
/* as a potential match. */

        i__2 = objcts_1.olnt;
        for (j = 1; j <= i__2; ++j) {
/* search objects. */
            if ((objcts_1.oflag1[j - 1] & 32768) == 0 || ! thisit_(oidx, aidx,
                     &j, spcobj)) {
                goto L500;
            }
/* visible & match? */
            x = objcts_1.ocan[j - 1];
/* get container. */
L300:
            if (x == i__) {
                goto L400;
            }
/* inside target? */
            if (x == 0) {
                goto L500;
            }
/* inside anything? */
            if ((objcts_1.oflag1[x - 1] & 32768) == 0 || ((objcts_1.oflag1[x 
                    - 1] & 2048) == 0 && (objcts_1.oflag2[x - 1] & 8) == 0) ||
                     (objcts_1.oflag2[x - 1] & 1) == 0) {
                goto L500;
            }
            x = objcts_1.ocan[x - 1];
/* go another level. */
            goto L300;

L400:
            if (ret_val == 0) {
                goto L450;
            }
/* already got one? */
            if (*aidx != 0) {
                goto L2000;
            }
/* adj? then ambiguous. */
            if (noadjs_(&j)) {
                goto L425;
            }
/* new have no adj? */
            aempty = TRUE_;
/* no, ambiguous empty. */
            goto L500;
L425:
            if (noadjs_(&ret_val)) {
                goto L2000;
            }
/* old have no adj? then */
L450:
            ret_val = j;
/* new has no adj, and old does. */
/* new is unique, or */
L500:
            ;
        }

L1000:
        ;
    }
    if (! aempty || ret_val == 0) {
        return ret_val;
    }
/* if none or not amb, do */
    if (noadjs_(&ret_val)) {
        return ret_val;
    }
/* if amb, and no adj, do */
L2000:
    ret_val = -ret_val;
/* amb return. */
    return ret_val;

} /* schlst_ */



/* THISIT--      Validate object vs description */

/* Declarations */

logical thisit_(integer *oidx, integer *aidx, integer *obj, integer *spcobj)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = FALSE_;
/* assume no match. */
    if (*spcobj != 0 && *obj == *spcobj) {
        goto L500;
    }

/* Check for object names */

    if (*oidx == 0) {
        return ret_val;
    }
/* no obj? lose. */
    i__ = *oidx;
L100:
    if ((i__1 = vocab_1.ovoc[i__ - 1], abs(i__1)) == *obj) {
        goto L200;
    }
/* found it? */
    ++i__;
/* adv to next. */
    if (vocab_1.ovoc[i__ - 1] < 0) {
        goto L100;
    }
/* still part of list? */
    return ret_val;

/* if done, lose. */
L200:
    if (*aidx == 0) {
        goto L500;
    }
/* no adj? done. */
    i__ = *aidx;
L300:
    if ((i__1 = vocab_1.avoc[i__ - 1], abs(i__1)) == *obj) {
        goto L500;
    }
/* found it? */
    ++i__;
/* adv to next. */
    if (vocab_1.avoc[i__ - 1] < 0) {
        goto L300;
    }
/* still part of list? */
    return ret_val;

/* if done, lose. */
L500:
    ret_val = TRUE_;
    return ret_val;
} /* thisit_ */



/* SYNMCH--      Syntax matcher */

/* Declarations */

/* This routine details on bit 4 of PRSFLG */

logical synmch_(integer *x)
{
    /* System generated locals */
    address a__1[3];
    ftnlen i__1[3], cc__3;
    integer i__2, i__3, i__4;
    logical ret_val;
    char ch__1[8], ch__2[8];

    /* Local variables */
    logical dflag;
    char lcword[8], lcprp1[10], lcprp2[10];
    integer j, drive, dforce, qprep, limit;
    integer newj, sprep;

/* SYNMCH, PAGE 2 */

    ret_val = FALSE_;
    dflag = (misc_1.prsflg & 16) != 0;
    j = prssta_1.act;
/* set up ptr to syntax. */
    drive = 0;
/* no default. */
    dforce = 0;
/* no forced default. */
    qprep = prssta_1.oflag & prssta_1.oprep;
/* valid orphan prep flag */
    limit = j + vocab_1.vvoc[j - 1] + 1;
/* compute limit. */
    ++j;

/* advance to next. */
L200:
    unpack_(&j, &newj);
/* unpack syntax. */
    if (dflag) {
        weeprintf("SYNMCH DOBJ INPUTS TO SYNEQL- "
           "%d %d %d %d %d %d\n", 
          j, prssta_1.obj1, prssta_1.prep1, prssta_1.dobj, 
          prssta_1.dfl1, prssta_1.dfl2);
    }
    sprep = prssta_1.dobj & 511;
/* save expected prep. */
    if (syneql_(&prssta_1.prep1, &prssta_1.obj1, &prssta_1.dobj, &
            prssta_1.dfl1, &prssta_1.dfl2)) {
        goto L1000;
    }

/* Direct syntax match fails, try direct as indirect. */

    if (prssta_1.obj2 != 0 || prssta_1.obj1 == 0 || ! syneql_(&prssta_1.prep1,
             &prssta_1.obj1, &prssta_1.iobj, &prssta_1.ifl1, &prssta_1.ifl2)) 
            {
        goto L500;
    }
/* try direct as indirect */
    prssta_1.obj2 = prssta_1.obj1;
/* move direct to indirec */
    prssta_1.prep2 = prssta_1.prep1;
    prssta_1.obj1 = 0;
/* no direct. */
    prssta_1.prep1 = 0;
    drive = j;
/* save as driver. */
    goto L3100;

/* Direct syntax match and direct-as-indirect fail. */

/* go try to get direct o */
L500:
    if (prssta_1.obj1 != 0) {
        goto L3000;
    }
/* if direct obj, on to n */
    goto L2500;

/* Direct syntax match succeeded, try indirect. */

/* go do defaults. */
L1000:
    if (dflag) {
        weeprintf("SYNMCH IOBJ INPUTS TO SYNEQL- "
           "%d %d %d %d %d %d\n", 
          j, prssta_1.obj2, prssta_1.prep2, prssta_1.iobj, 
          prssta_1.ifl1, prssta_1.ifl2);
    }
    sprep = prssta_1.iobj & 511;
/* save expected prep. */
    if (syneql_(&prssta_1.prep2, &prssta_1.obj2, &prssta_1.iobj, &
            prssta_1.ifl1, &prssta_1.ifl2)) {
        goto L6000;
    }

/* Indirect syntax match fails. */

    if (prssta_1.obj2 != 0) {
        goto L3000;
    }
/* if ind object, on to n */
L2500:
    if (qprep == 0 || qprep == sprep) {
        dforce = j;
    }
/* if prep mch. */
    if ((prssta_1.vflag & 1024) != 0) {
        drive = j;
    }
/* if driver, record. */
    if (dflag) {
        weeprintf("SYNMCH DEFAULT SYNTAXES- "
           "%d %d %d %d %d\n", 
          j, qprep, sprep, dforce, drive);
    }
L3000:
    j = newj;
    if (j < limit) {
        goto L200;
    }
/* SYNMCH, PAGE 3 */

/* Match has failed.  If default syntax exists, try to snarf */
/* orphans or GWIMs, or make new orphans. */

/* more to do? */
L3100:
    if (dflag) {
        weeprintf("SYNMCH, DRIVE=%d %d  OBJECTS=%d %d\n",
          drive, dforce, prssta_1.obj1, prssta_1.obj2);
    }
    if (drive == 0) {
        drive = dforce;
    }
/* no driver? use force. */
    if (drive == 0) {
        goto L10000;
    }
/* any driver? */
    unpack_(&drive, &dforce);
/* unpack dflt syntax. */
    findvb_(ch__2, 8L, &drive);
    lcify_(ch__1, 8L, ch__2, &c__2, 8L);
    s_copy(lcword, ch__1, 8L, 8L);
/* get verb string. */
/* Writing concatenation */
    i__1[0] = 1, a__1[0] = " ";
    i__2 = prssta_1.dobj & 511;
    findpr_(ch__2, 8L, &i__2);
    lcify_(ch__1, 8L, ch__2, &c__1, 8L);
    i__1[1] = 8, a__1[1] = ch__1;
    i__1[2] = 1, a__1[2] = " ";
    s_cat(lcprp1, a__1, i__1, &cc__3, 10L);
    c__3 = cc__3;
/* Writing concatenation */
    i__1[0] = 1, a__1[0] = " ";
    i__2 = prssta_1.iobj & 511;
    findpr_(ch__2, 8L, &i__2);
    lcify_(ch__1, 8L, ch__2, &c__1, 8L);
    i__1[1] = 8, a__1[1] = ch__1;
    i__1[2] = 1, a__1[2] = " ";
    s_cat(lcprp2, a__1, i__1, &cc__3, 10L);
    c__3 = cc__3;

/* Try to fill direct object slot if that was the problem. */

    if ((prssta_1.vflag & 16384) == 0 || prssta_1.obj1 != 0) {
        goto L4000;
    }
    prssta_1.obj1 = prssta_1.oflag & prssta_1.oobj1;
    if (prssta_1.obj1 == 0) {
        goto L3500;
    }
/* any orphan? */
    if (syneql_(&prssta_1.oprep1, &prssta_1.obj1, &prssta_1.dobj, &
            prssta_1.dfl1, &prssta_1.dfl2)) {
        goto L4000;
    }

/* Orphan fails, try GWIM. */

L3500:
    prssta_1.obj1 = gwim_(&prssta_1.dobj, &prssta_1.dfw1, &prssta_1.dfw2);
/* get gwim. */
    if (dflag) {
        weeprintf("SYNMCH- DO GWIM=%d\n", prssta_1.obj1);
    }
    if (prssta_1.obj1 > 0) {
        goto L4000;
    }
/* test result. */
    i__2 = prssta_1.dobj & 511;
    orphan_(&c_n1, &prssta_1.act, &c__0, &c__0, &i__2, " ", &prssta_1.prep2, &
            prssta_1.obj2, 1L);
/* fails, or */
    prssta_1.bunsub = 0;
/* no EXCEPT clause. */
    if (prssta_1.obj2 > 0) {
        goto L3800;
    }
/* if iobj, go print. */
L3700:
    glk_put_buffer(lcword, nblen_(lcword, 8L));
    glk_put_buffer(lcprp1, nblen_(lcprp1, 10L) + 1);
    glk_put_string("what?\n");
    play_1.telflg = TRUE_;
    return ret_val;

L3800:
    *x = (i__2 = objcts_1.odesc2[prssta_1.obj2 - 1], abs(i__2));
    glk_put_buffer(lcword, nblen_(lcword, 8L));
    glk_put_buffer(lcprp1, nblen_(lcprp1, 10L) + 1);
    glk_put_string("what");
    glk_put_buffer(lcprp2, nblen_(lcprp2, 10L) + 1);
    glk_put_string("the ");
/* get iobj description. */
    printdb((*x)-1, -1, -1, FALSE_);
    glk_put_string("?\n");
    play_1.telflg = TRUE_;
    return ret_val;
/* SYNMCH, PAGE 4 */

/* Try to fill indirect object slot if that was the problem. */

L4000:
    if ((prssta_1.vflag & 8192) == 0 || prssta_1.obj2 != 0) {
        goto L6000;
    }
    prssta_1.obj2 = prssta_1.oflag & prssta_1.oobj2;
    if (prssta_1.obj2 == 0) {
        goto L4500;
    }
/* any orphan? */
    if (syneql_(&prssta_1.oprep2, &prssta_1.obj2, &prssta_1.iobj, &
            prssta_1.ifl1, &prssta_1.ifl2)) {
        goto L6000;
    }

/* Orphan fails, try GWIM. */

L4500:
    prssta_1.obj2 = gwim_(&prssta_1.iobj, &prssta_1.ifw1, &prssta_1.ifw2);
/* gwim. */
    if (dflag) {
        weeprintf("SYNMCH- IO GWIM=%d\n", prssta_1.obj2);
    }
    if (prssta_1.obj2 > 0) {
        goto L6000;
    }
    if (prssta_1.obj1 > 0) {
        goto L4600;
    }
/* if dobj, go print. */
    i__2 = prssta_1.oflag & prssta_1.oprep1;
    i__3 = prssta_1.oflag & prssta_1.oobj1;
    i__4 = prssta_1.iobj & 511;
    orphan_(&c_n1, &prssta_1.act, &i__2, &i__3, &i__4, " ", &c__0, &c__0, 1L);
    goto L3700;

/* Error with direct object available. */

L4600:
    i__2 = prssta_1.iobj & 511;
    orphan_(&c_n1, &prssta_1.act, &prssta_1.prep1, &prssta_1.obj1, &i__2, 
            " ", &c__0, &c__0, 1L);
    *x = (i__2 = objcts_1.odesc2[prssta_1.obj1 - 1], abs(i__2));
    glk_put_buffer(lcword, nblen_(lcword, 8L)); 
    glk_put_buffer(lcprp1, nblen_(lcprp1, 10L) + 1);
    glk_put_string("the ");
/* get dobj description. */
    printdb((*x)-1, -1, -1, FALSE_);
    glk_put_buffer(lcprp2, nblen_(lcprp2, 10L) + 1);
    glk_put_string("what?\n");
    play_1.telflg = TRUE_;
    return ret_val;

/* Total chomp. */

L10000:
    rspeak_(&c__601);
/* cant do anything. */
    prssta_1.bunsub = 0;
    return ret_val;
/* SYNMCH, PAGE 5 */

/* Now try to take individual objects and */
/* in general clean up the parse vector. */

L6000:
    if ((prssta_1.vflag & 2048) == 0) {
        goto L7000;
    }
/* flip? */
    j = prssta_1.obj1;
/* yes. */
    prssta_1.obj1 = prssta_1.obj2;
    prssta_1.obj2 = j;

L7000:
    prsvec_1.prsa = prssta_1.vflag & 511;
/* get verb. */
    prsvec_1.prso = prssta_1.obj1;
/* get dir obj. */
    prsvec_1.prsi = prssta_1.obj2;
/* get ind obj. */
    if (! takeit_(&prsvec_1.prso, &prssta_1.dobj)) {
        return ret_val;
    }
/* try take. */
    if (! takeit_(&prsvec_1.prsi, &prssta_1.iobj)) {
        return ret_val;
    }
/* try take. */
    ret_val = TRUE_;
    if (dflag) {
        weeprintf("SYNMCH- RESULT %c %d %d %d %d %d %d\n", 
          (ret_val ? 'T' : 'F'),
          prsvec_1.prsa, prsvec_1.prso, prsvec_1.prsi, prssta_1.act, 
          prssta_1.obj1, prssta_1.obj2);
    }
    return ret_val;

} /* synmch_ */



/* UNPACK-       Unpack syntax specification, adv pointer */

/* Declarations */

/* Subroutine */ int unpack_(integer *oldj, integer *j)
{
    /* Local variables */
    integer i__;


/* clear syntax. */
    prssta_1.vflag = 0;
    prssta_1.dobj = 0;
    prssta_1.dfl1 = 0;
    prssta_1.dfl2 = 0;
    prssta_1.dfw1 = 0;
    prssta_1.dfw2 = 0;
    prssta_1.iobj = 0;
    prssta_1.ifl1 = 0;
    prssta_1.ifl2 = 0;
    prssta_1.ifw1 = 0;
    prssta_1.ifw2 = 0;
    /*
    #define syn ((integer *)&prssta_1 + 15)
    for (i__ = 1; i__ <= 11; ++i__) {
        syn[i__ - 1] = 0;
    }
    */

    prssta_1.vflag = vocab_1.vvoc[*oldj - 1];
    *j = *oldj + 1;
    if ((prssta_1.vflag & 16384) == 0) {
        return 0;
    }
/* dir object? */
    prssta_1.dfl1 = -1;
/* assume std. */
    prssta_1.dfl2 = -1;
    if ((prssta_1.vflag & 4096) == 0) {
        goto L100;
    }
/* std object? */
    prssta_1.dfw1 = -1;
/* yes. */
    prssta_1.dfw2 = -1;
    prssta_1.dobj = 25088;
    goto L200;

L100:
    prssta_1.dobj = vocab_1.vvoc[*j - 1];
/* not std. */
    prssta_1.dfw1 = vocab_1.vvoc[*j];
    prssta_1.dfw2 = vocab_1.vvoc[*j + 1];
    *j += 3;
    if ((prssta_1.dobj & 1024) == 0) {
        goto L200;
    }
/* vbit = vfwim? */
    prssta_1.dfl1 = prssta_1.dfw1;
/* yes. */
    prssta_1.dfl2 = prssta_1.dfw2;

L200:
    if ((prssta_1.vflag & 8192) == 0) {
        return 0;
    }
/* ind object? */
    prssta_1.ifl1 = -1;
/* assume std. */
    prssta_1.ifl2 = -1;
    prssta_1.iobj = vocab_1.vvoc[*j - 1];
    prssta_1.ifw1 = vocab_1.vvoc[*j];
    prssta_1.ifw2 = vocab_1.vvoc[*j + 1];
    *j += 3;
    if ((prssta_1.iobj & 1024) == 0) {
        return 0;
    }
/* vbit = vfwim? */
    prssta_1.ifl1 = prssta_1.ifw1;
/* yes. */
    prssta_1.ifl2 = prssta_1.ifw2;
    return 0;

} /* unpack_ */



/* SYNEQL-       Test for syntax equality */

/* Declarations */

logical syneql_(integer *prep, integer *obj, integer *sprep, integer *sfl1, 
        integer *sfl2)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


    if (*obj == 0) {
        goto L100;
    }
/* any object? */
    ret_val = *prep == (*sprep & 511) && ((*sfl1 & objcts_1.oflag1[*obj - 1]) 
            | (*sfl2 & objcts_1.oflag2[*obj - 1])) != 0;
    return ret_val;

L100:
    ret_val = *prep == 0 && *sfl1 == 0 && *sfl2 == 0;
    return ret_val;

} /* syneql_ */



/* TAKEIT-       Parser based take of object */

/* Declarations */

logical takeit_(integer *obj, integer *sflag)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer x;
    integer i__;
    integer sva, svi, svo;
    integer odo2;


    ret_val = FALSE_;
/* assume loses. */
    if (*obj == 0 || *obj > misc_1.strbit || findex_1.deadf) {
        goto L4000;
    }
/* null/stars/dead win. */
    odo2 = objcts_1.odesc2[*obj - 1];
/* get desc. */
    x = objcts_1.ocan[*obj - 1];
/* get container. */
    if (x == 0 || (*sflag & 512) == 0) {
        goto L500;
    }
    if ((objcts_1.oflag2[x - 1] & 8) != 0) {
        goto L500;
    }
    rspsub_(&c__566, &odo2);
/* cant reach. */
    return ret_val;

L500:
    if ((*sflag & 8192) == 0) {
        goto L1000;
    }
/* shld be in room? */
    if ((*sflag & 4096) == 0) {
        goto L2000;
    }

/* Should be in room (VRBIT NE 0) and can be taken (VTBIT NE 0) */

/* can be taken? */
    if (schlst_(&c__0, &c__0, &play_1.here, &c__0, &c__0, obj) <= 0) {
        goto L4000;
    }

/* Its in the room and can be taken. */

/* if not, ok. */
    if ((objcts_1.oflag1[*obj - 1] & 8192) != 0) {
        goto L3000;
    }

/* Not takeable.  If we care, fail. */

    if ((*sflag & 2048) == 0) {
        goto L4000;
    }
/* if no care, return. */
    rspsub_(&c__445, &odo2);
    return ret_val;

/* 1000--        It should not be in the room. */
/* 2000--        It cant be taken. */

L2000:
    if ((*sflag & 2048) == 0) {
        goto L4000;
    }
/* if no care, return */
L1000:
    if (schlst_(&c__0, &c__0, &play_1.here, &c__0, &c__0, obj) <= 0) {
        goto L4000;
    }
    i__ = 665;
/* assume player. */
    if (play_1.winner != 1) {
        i__ = 1082;
    }
    rspsub_(&i__, &odo2);
/* doesn't have it. */
    return ret_val;

/* 3000--        Take object. */

L3000:
    if (lit_(&play_1.here)) {
        goto L3500;
    }
/* lit? */
    rspeak_(&c__579);
/* can't do it. */
    return ret_val;

L3500:
    sva = prsvec_1.prsa;
/* save parse vector */
    svo = prsvec_1.prso;
    svi = prsvec_1.prsi;
    prsvec_1.prsa = 132;
/* make 'take obj' */
    prsvec_1.prso = *obj;
    prsvec_1.prsi = 0;
/* no indirect object */
    ret_val = take_(&c_true);
/* try to take object */
    prsvec_1.prsa = sva;
/* restore parse vector. */
    prsvec_1.prso = svo;
    prsvec_1.prsi = svi;
    return ret_val;

/* 4000--        Win on general principles. */

L4000:
    ret_val = TRUE_;
    return ret_val;

} /* takeit_ */



/* GWIM- Get what I mean in ambiguous situations */

/* Declarations */

integer gwim_(integer *sflag, integer *sfw1, integer *sfw2)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    logical nocare;
    integer av;
    integer robj;


    ret_val = 0;
/* no result. */
    if (findex_1.deadf) {
        return ret_val;
    }
/* dead? gwim disabled. */
    av = advs_1.avehic[play_1.winner - 1];
    nocare = (*sflag & 2048) == 0;

/* First search adventurer */

    if ((*sflag & 16384) != 0) {
        ret_val = fwim_(sfw1, sfw2, &c__0, &c__0, &play_1.winner, &nocare);
    }
    if (ret_val < 0 || ! lit_(&play_1.here) || (*sflag & 8192) == 0) {
        return ret_val;
    }

/* Also search room */

/* L100: */
    robj = fwim_(sfw1, sfw2, &play_1.here, &c__0, &c__0, &nocare);
    if (robj < 0) {
        goto L500;
    } else if (robj == 0) {
        goto L600;
    } else {
        goto L200;
    }

/* ROBJ > 0: if prev object, fail */

/* test result. */
L200:
    if (av == 0 || robj == av || (objcts_1.oflag2[robj - 1] & 32768) != 0) {
        goto L300;
    }
    if (objcts_1.ocan[robj - 1] != av) {
        return ret_val;
    }

/* unreachable? use prev */
L300:
    if (ret_val == 0) {
        goto L400;
    }
/* prev obj? */
    ret_val = -ret_val;
/* yes, ambiguous. */
    return ret_val;

L400:
    if (! takeit_(&robj, sflag)) {
        return ret_val;
    }
/* if untakeable, return */
L500:
    ret_val = robj;
/* return room seach. */
L600:
    return ret_val;

} /* gwim_ */



/* NOADJS-       See if any adjectives for object */

/* Declarations */

logical noadjs_(integer *obj)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = FALSE_;
/* assume false. */
    for (i__ = 1; i__ <= 300; ++i__) {
/* search adj. */
        if ((i__1 = vocab_1.avoc[i__ - 1], abs(i__1)) == *obj) {
            return ret_val;
        }
/* found adjective? */
        if (vocab_1.avoc[i__ - 1] == 0) {
            goto L200;
        }
/* end of list? */
/* L100: */
    }
L200:
    ret_val = TRUE_;
/* true. */
    return ret_val;

} /* noadjs_ */



/* LCIFY-        "Lower case"-ify a string for printing */

/* Declarations */

/* Character */ void lcify_(char *ret_val, ftnlen ret_val_len, char *string, 
        integer *start, ftnlen string_len)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__, k, ulcvt;


    s_copy(ret_val, string, ret_val_len, string_len);
/* assume input = output. */
    k = i_len(string, string_len);
/* get input length. */
    if (*start > k) {
        return ;
    }

/* anything to convert? */
    ulcvt = 'a' - 'A';
/* conversion factor */
    i__1 = k;
    for (i__ = *start; i__ <= i__1; ++i__) {
/* loop on characters */
        if (*(unsigned char *)&string[i__ - 1] >= 'A' && *(unsigned char *)&
                string[i__ - 1] <= 'Z') {
            *(unsigned char *)&ret_val[i__ - 1] = (char) (*(unsigned char *)&
                    string[i__ - 1] + ulcvt);
        }
/* L100: */
    }
    return ;

} /* lcify_ */

/* FINDVB-       Find verb string corresponding to syntax. */

/* Declarations */

/* Character */ void findvb_(char *ret_val, ftnlen ret_val_len, integer *
        syntax)
{
    /* Local variables */
    integer j, k, newj;


    j = 1;
    for (k = 1; k <= 240; ++k) {
/* loop through verbs */
        newj = j + vocab_1.vvoc[j - 1] + 1;
/* start of next syntax */
        if (j <= *syntax && *syntax < newj) {
            goto L200;
        }
        if (*(unsigned char *)&vocab_1.vword[(k - 1) * 8] != '*') {
            j = newj;
        }
/* if last synonym, advan */
/* L100: */
    }
    s_copy(ret_val, " ", ret_val_len, 1L);
/* disaster */
    return ;

L200:
    s_copy(ret_val, vocab_1.vword + ((k - 1) << 3), ret_val_len, 8L);
/* return string */
    if (*(unsigned char *)&vocab_1.vword[(k - 1) * 8] == '*') {
        s_copy(ret_val, vocab_1.vword + (((k - 1) << 3) + 1), ret_val_len, 7L)
                ;
    }
    return ;

} /* findvb_ */



/* FINDPR-       Find preposition string corresponding to index. */

/* Declarations */

/* Character */ void findpr_(char *ret_val, ftnlen ret_val_len, integer *
        prepno)
{
    /* Local variables */
    integer i__;


    for (i__ = 1; i__ <= 20; ++i__) {
/* loop through prepositi */
        if (vocab_1.pvoc[i__ - 1] == *prepno) {
            goto L200;
        }
/* L100: */
    }
    s_copy(ret_val, " ", ret_val_len, 1L);
    return ;

L200:
    s_copy(ret_val, vocab_1.pword + ((i__ - 1) << 3), ret_val_len, 8L);
    return ;

} /* findpr_ */



